//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armstoragesync

import "time"

// APIError - Error type
type APIError struct {
	// Error code of the given entry.
	Code *string `json:"code,omitempty"`

	// Error details of the given entry.
	Details *ErrorDetails `json:"details,omitempty"`

	// Inner error details of the given entry.
	Innererror *InnerErrorDetails `json:"innererror,omitempty"`

	// Error message of the given entry.
	Message *string `json:"message,omitempty"`

	// Target of the given error entry.
	Target *string `json:"target,omitempty"`
}

// BackupRequest - Backup request
type BackupRequest struct {
	// Azure File Share.
	AzureFileShare *string `json:"azureFileShare,omitempty"`
}

// CheckNameAvailabilityParameters - Parameters for a check name availability request.
type CheckNameAvailabilityParameters struct {
	// REQUIRED; The name to check for availability
	Name *string `json:"name,omitempty"`

	// REQUIRED; The resource type. Must be set to Microsoft.StorageSync/storageSyncServices
	Type *string `json:"type,omitempty"`
}

// CheckNameAvailabilityResult - The CheckNameAvailability operation response.
type CheckNameAvailabilityResult struct {
	// READ-ONLY; Gets an error message explaining the Reason value in more detail.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; Gets a boolean value that indicates whether the name is available for you to use. If true, the name is available.
	// If false, the name has already been taken or invalid and cannot be used.
	NameAvailable *bool `json:"nameAvailable,omitempty" azure:"ro"`

	// READ-ONLY; Gets the reason that a Storage Sync Service name could not be used. The Reason element is only returned if NameAvailable
	// is false.
	Reason *NameAvailabilityReason `json:"reason,omitempty" azure:"ro"`
}

// CloudEndpoint - Cloud Endpoint object.
type CloudEndpoint struct {
	// Cloud Endpoint properties.
	Properties *CloudEndpointProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// CloudEndpointArray - Array of CloudEndpoint
type CloudEndpointArray struct {
	// Collection of CloudEndpoint.
	Value []*CloudEndpoint `json:"value,omitempty"`
}

// CloudEndpointChangeEnumerationActivity - Cloud endpoint change enumeration activity object
type CloudEndpointChangeEnumerationActivity struct {
	// READ-ONLY; Progress percentage for processing deletes. This is done separately from the rest of the enumeration run
	DeletesProgressPercent *int32 `json:"deletesProgressPercent,omitempty" azure:"ro"`

	// READ-ONLY; Last updated timestamp
	LastUpdatedTimestamp *time.Time `json:"lastUpdatedTimestamp,omitempty" azure:"ro"`

	// READ-ONLY; Estimate of time remaining for the enumeration run
	MinutesRemaining *int32 `json:"minutesRemaining,omitempty" azure:"ro"`

	// READ-ONLY; Change enumeration operation state
	OperationState *CloudEndpointChangeEnumerationActivityState `json:"operationState,omitempty" azure:"ro"`

	// READ-ONLY; Count of directories processed
	ProcessedDirectoriesCount *int64 `json:"processedDirectoriesCount,omitempty" azure:"ro"`

	// READ-ONLY; Count of files processed
	ProcessedFilesCount *int64 `json:"processedFilesCount,omitempty" azure:"ro"`

	// READ-ONLY; Progress percentage for change enumeration run, excluding processing of deletes
	ProgressPercent *int32 `json:"progressPercent,omitempty" azure:"ro"`

	// READ-ONLY; Timestamp when change enumeration started
	StartedTimestamp *time.Time `json:"startedTimestamp,omitempty" azure:"ro"`

	// READ-ONLY; When non-zero, indicates an issue that is delaying change enumeration
	StatusCode *int32 `json:"statusCode,omitempty" azure:"ro"`

	// READ-ONLY; Change enumeration total counts state
	TotalCountsState *CloudEndpointChangeEnumerationTotalCountsState `json:"totalCountsState,omitempty" azure:"ro"`

	// READ-ONLY; Total count of directories enumerated
	TotalDirectoriesCount *int64 `json:"totalDirectoriesCount,omitempty" azure:"ro"`

	// READ-ONLY; Total count of files enumerated
	TotalFilesCount *int64 `json:"totalFilesCount,omitempty" azure:"ro"`

	// READ-ONLY; Total enumerated size in bytes
	TotalSizeBytes *int64 `json:"totalSizeBytes,omitempty" azure:"ro"`
}

// CloudEndpointChangeEnumerationStatus - Cloud endpoint change enumeration status object
type CloudEndpointChangeEnumerationStatus struct {
	// READ-ONLY; Change enumeration activity
	Activity *CloudEndpointChangeEnumerationActivity `json:"activity,omitempty" azure:"ro"`

	// READ-ONLY; Status of last completed change enumeration
	LastEnumerationStatus *CloudEndpointLastChangeEnumerationStatus `json:"lastEnumerationStatus,omitempty" azure:"ro"`

	// READ-ONLY; Last updated timestamp
	LastUpdatedTimestamp *time.Time `json:"lastUpdatedTimestamp,omitempty" azure:"ro"`
}

// CloudEndpointCreateParameters - The parameters used when creating a cloud endpoint.
type CloudEndpointCreateParameters struct {
	// The parameters used to create the cloud endpoint.
	Properties *CloudEndpointCreateParametersProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// CloudEndpointCreateParametersProperties - CloudEndpoint Properties object.
type CloudEndpointCreateParametersProperties struct {
	// Azure file share name
	AzureFileShareName *string `json:"azureFileShareName,omitempty"`

	// Friendly Name
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Storage Account Resource Id
	StorageAccountResourceID *string `json:"storageAccountResourceId,omitempty"`

	// Storage Account Tenant Id
	StorageAccountTenantID *string `json:"storageAccountTenantId,omitempty"`
}

// CloudEndpointLastChangeEnumerationStatus - Cloud endpoint change enumeration status object
type CloudEndpointLastChangeEnumerationStatus struct {
	// READ-ONLY; Timestamp when change enumeration completed
	CompletedTimestamp *time.Time `json:"completedTimestamp,omitempty" azure:"ro"`

	// READ-ONLY; Count of directories in the namespace
	NamespaceDirectoriesCount *int64 `json:"namespaceDirectoriesCount,omitempty" azure:"ro"`

	// READ-ONLY; Count of files in the namespace
	NamespaceFilesCount *int64 `json:"namespaceFilesCount,omitempty" azure:"ro"`

	// READ-ONLY; Namespace size in bytes
	NamespaceSizeBytes *int64 `json:"namespaceSizeBytes,omitempty" azure:"ro"`

	// READ-ONLY; Timestamp of when change enumeration is expected to run again
	NextRunTimestamp *time.Time `json:"nextRunTimestamp,omitempty" azure:"ro"`

	// READ-ONLY; Timestamp when change enumeration started
	StartedTimestamp *time.Time `json:"startedTimestamp,omitempty" azure:"ro"`
}

// CloudEndpointProperties - CloudEndpoint Properties object.
type CloudEndpointProperties struct {
	// Azure file share name
	AzureFileShareName *string `json:"azureFileShareName,omitempty"`

	// Friendly Name
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Resource Last Operation Name
	LastOperationName *string `json:"lastOperationName,omitempty"`

	// CloudEndpoint lastWorkflowId
	LastWorkflowID *string `json:"lastWorkflowId,omitempty"`

	// Partnership Id
	PartnershipID *string `json:"partnershipId,omitempty"`

	// CloudEndpoint Provisioning State
	ProvisioningState *string `json:"provisioningState,omitempty"`

	// Storage Account Resource Id
	StorageAccountResourceID *string `json:"storageAccountResourceId,omitempty"`

	// Storage Account Tenant Id
	StorageAccountTenantID *string `json:"storageAccountTenantId,omitempty"`

	// READ-ONLY; Backup Enabled
	BackupEnabled *string `json:"backupEnabled,omitempty" azure:"ro"`

	// READ-ONLY; Cloud endpoint change enumeration status
	ChangeEnumerationStatus *CloudEndpointChangeEnumerationStatus `json:"changeEnumerationStatus,omitempty" azure:"ro"`
}

// CloudEndpointsClientBeginCreateOptions contains the optional parameters for the CloudEndpointsClient.BeginCreate method.
type CloudEndpointsClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CloudEndpointsClientBeginDeleteOptions contains the optional parameters for the CloudEndpointsClient.BeginDelete method.
type CloudEndpointsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CloudEndpointsClientBeginPostBackupOptions contains the optional parameters for the CloudEndpointsClient.BeginPostBackup
// method.
type CloudEndpointsClientBeginPostBackupOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CloudEndpointsClientBeginPostRestoreOptions contains the optional parameters for the CloudEndpointsClient.BeginPostRestore
// method.
type CloudEndpointsClientBeginPostRestoreOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CloudEndpointsClientBeginPreBackupOptions contains the optional parameters for the CloudEndpointsClient.BeginPreBackup
// method.
type CloudEndpointsClientBeginPreBackupOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CloudEndpointsClientBeginPreRestoreOptions contains the optional parameters for the CloudEndpointsClient.BeginPreRestore
// method.
type CloudEndpointsClientBeginPreRestoreOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CloudEndpointsClientBeginTriggerChangeDetectionOptions contains the optional parameters for the CloudEndpointsClient.BeginTriggerChangeDetection
// method.
type CloudEndpointsClientBeginTriggerChangeDetectionOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CloudEndpointsClientGetOptions contains the optional parameters for the CloudEndpointsClient.Get method.
type CloudEndpointsClientGetOptions struct {
	// placeholder for future optional parameters
}

// CloudEndpointsClientListBySyncGroupOptions contains the optional parameters for the CloudEndpointsClient.ListBySyncGroup
// method.
type CloudEndpointsClientListBySyncGroupOptions struct {
	// placeholder for future optional parameters
}

// CloudEndpointsClientRestoreheartbeatOptions contains the optional parameters for the CloudEndpointsClient.Restoreheartbeat
// method.
type CloudEndpointsClientRestoreheartbeatOptions struct {
	// placeholder for future optional parameters
}

// CloudTieringCachePerformance - Server endpoint cloud tiering status object.
type CloudTieringCachePerformance struct {
	// READ-ONLY; Count of bytes that were served from the local server
	CacheHitBytes *int64 `json:"cacheHitBytes,omitempty" azure:"ro"`

	// READ-ONLY; Percentage of total bytes (hit + miss) that were served from the local server
	CacheHitBytesPercent *int32 `json:"cacheHitBytesPercent,omitempty" azure:"ro"`

	// READ-ONLY; Count of bytes that were served from the cloud
	CacheMissBytes *int64 `json:"cacheMissBytes,omitempty" azure:"ro"`

	// READ-ONLY; Last updated timestamp
	LastUpdatedTimestamp *time.Time `json:"lastUpdatedTimestamp,omitempty" azure:"ro"`
}

// CloudTieringDatePolicyStatus - Status of the date policy
type CloudTieringDatePolicyStatus struct {
	// READ-ONLY; Last updated timestamp
	LastUpdatedTimestamp *time.Time `json:"lastUpdatedTimestamp,omitempty" azure:"ro"`

	// READ-ONLY; Most recent access time of tiered files
	TieredFilesMostRecentAccessTimestamp *time.Time `json:"tieredFilesMostRecentAccessTimestamp,omitempty" azure:"ro"`
}

// CloudTieringFilesNotTiering - Server endpoint cloud tiering status object.
type CloudTieringFilesNotTiering struct {
	// READ-ONLY; Array of tiering errors
	Errors []*FilesNotTieringError `json:"errors,omitempty" azure:"ro"`

	// READ-ONLY; Last updated timestamp
	LastUpdatedTimestamp *time.Time `json:"lastUpdatedTimestamp,omitempty" azure:"ro"`

	// READ-ONLY; Last cloud tiering result (HResult)
	TotalFileCount *int64 `json:"totalFileCount,omitempty" azure:"ro"`
}

// CloudTieringSpaceSavings - Server endpoint cloud tiering status object.
type CloudTieringSpaceSavings struct {
	// READ-ONLY; Cached content size on the server
	CachedSizeBytes *int64 `json:"cachedSizeBytes,omitempty" azure:"ro"`

	// READ-ONLY; Last updated timestamp
	LastUpdatedTimestamp *time.Time `json:"lastUpdatedTimestamp,omitempty" azure:"ro"`

	// READ-ONLY; Count of bytes saved on the server
	SpaceSavingsBytes *int64 `json:"spaceSavingsBytes,omitempty" azure:"ro"`

	// READ-ONLY; Percentage of cached size over total size
	SpaceSavingsPercent *int32 `json:"spaceSavingsPercent,omitempty" azure:"ro"`

	// READ-ONLY; Total size of content in the azure file share
	TotalSizeCloudBytes *int64 `json:"totalSizeCloudBytes,omitempty" azure:"ro"`

	// READ-ONLY; Volume size
	VolumeSizeBytes *int64 `json:"volumeSizeBytes,omitempty" azure:"ro"`
}

// CloudTieringVolumeFreeSpacePolicyStatus - Status of the volume free space policy
type CloudTieringVolumeFreeSpacePolicyStatus struct {
	// READ-ONLY; Current volume free space percentage.
	CurrentVolumeFreeSpacePercent *int32 `json:"currentVolumeFreeSpacePercent,omitempty" azure:"ro"`

	// READ-ONLY; In the case where multiple server endpoints are present in a volume, an effective free space policy is applied.
	EffectiveVolumeFreeSpacePolicy *int32 `json:"effectiveVolumeFreeSpacePolicy,omitempty" azure:"ro"`

	// READ-ONLY; Last updated timestamp
	LastUpdatedTimestamp *time.Time `json:"lastUpdatedTimestamp,omitempty" azure:"ro"`
}

// Error type
type Error struct {
	// Error details of the given entry.
	Error *APIError `json:"error,omitempty"`

	// Error details of the given entry.
	Innererror *APIError `json:"innererror,omitempty"`
}

// ErrorDetails - Error Details object.
type ErrorDetails struct {
	// Error code of the given entry.
	Code *string `json:"code,omitempty"`

	// Exception type of the given entry.
	ExceptionType *string `json:"exceptionType,omitempty"`

	// HTTP error code of the given entry.
	HTTPErrorCode *string `json:"httpErrorCode,omitempty"`

	// HTTP method of the given entry.
	HTTPMethod *string `json:"httpMethod,omitempty"`

	// Hashed message of the given entry.
	HashedMessage *string `json:"hashedMessage,omitempty"`

	// Error message of the given entry.
	Message *string `json:"message,omitempty"`

	// Request URI of the given entry.
	RequestURI *string `json:"requestUri,omitempty"`

	// Target of the given entry.
	Target *string `json:"target,omitempty"`
}

// FilesNotTieringError - Files not tiering error object
type FilesNotTieringError struct {
	// READ-ONLY; Error code (HResult)
	ErrorCode *int32 `json:"errorCode,omitempty" azure:"ro"`

	// READ-ONLY; Count of files with this error
	FileCount *int64 `json:"fileCount,omitempty" azure:"ro"`
}

// InnerErrorDetails - Error Details object.
type InnerErrorDetails struct {
	// Call stack of the error.
	CallStack *string `json:"callStack,omitempty"`

	// Exception of the inner error.
	InnerException *string `json:"innerException,omitempty"`

	// Call stack of the inner error.
	InnerExceptionCallStack *string `json:"innerExceptionCallStack,omitempty"`

	// Error message of the error.
	Message *string `json:"message,omitempty"`
}

// LocationOperationStatus - Operation status object
type LocationOperationStatus struct {
	// READ-ONLY; End time of the operation
	EndTime *time.Time `json:"endTime,omitempty" azure:"ro"`

	// READ-ONLY; Error details.
	Error *APIError `json:"error,omitempty" azure:"ro"`

	// READ-ONLY; Operation resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Operation Id
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Percent complete.
	PercentComplete *int32 `json:"percentComplete,omitempty" azure:"ro"`

	// READ-ONLY; Start time of the operation
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`

	// READ-ONLY; Operation status
	Status *string `json:"status,omitempty" azure:"ro"`
}

// MicrosoftStorageSyncClientLocationOperationStatusOptions contains the optional parameters for the MicrosoftStorageSyncClient.LocationOperationStatus
// method.
type MicrosoftStorageSyncClientLocationOperationStatusOptions struct {
	// placeholder for future optional parameters
}

// OperationDisplayInfo - The operation supported by storage sync.
type OperationDisplayInfo struct {
	// The description of the operation.
	Description *string `json:"description,omitempty"`

	// The action that users can perform, based on their permission level.
	Operation *string `json:"operation,omitempty"`

	// Service provider: Microsoft StorageSync.
	Provider *string `json:"provider,omitempty"`

	// Resource on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
}

// OperationDisplayResource - Operation Display Resource object.
type OperationDisplayResource struct {
	// Operation Display Resource Description.
	Description *string `json:"description,omitempty"`

	// Operation Display Resource Operation.
	Operation *string `json:"operation,omitempty"`

	// Operation Display Resource Provider.
	Provider *string `json:"provider,omitempty"`

	// Operation Display Resource.
	Resource *string `json:"resource,omitempty"`
}

// OperationEntity - The operation supported by storage sync.
type OperationEntity struct {
	// The operation supported by storage sync.
	Display *OperationDisplayInfo `json:"display,omitempty"`

	// Operation name: {provider}/{resource}/{operation}.
	Name *string `json:"name,omitempty"`

	// The origin.
	Origin *string `json:"origin,omitempty"`

	// Properties of the operations resource.
	Properties *OperationProperties `json:"properties,omitempty"`
}

// OperationEntityListResult - The list of storage sync operations.
type OperationEntityListResult struct {
	// The link used to get the next page of operations.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of operations.
	Value []*OperationEntity `json:"value,omitempty"`
}

// OperationProperties - Properties of the operations resource.
type OperationProperties struct {
	// Service specification for the operations resource.
	ServiceSpecification *OperationResourceServiceSpecification `json:"serviceSpecification,omitempty"`
}

// OperationResourceMetricSpecification - Operation Display Resource object.
type OperationResourceMetricSpecification struct {
	// Aggregation type for the metric.
	AggregationType *string `json:"aggregationType,omitempty"`

	// Dimensions for the metric specification.
	Dimensions []*OperationResourceMetricSpecificationDimension `json:"dimensions,omitempty"`

	// Display description for the metric.
	DisplayDescription *string `json:"displayDescription,omitempty"`

	// Display name for the metric.
	DisplayName *string `json:"displayName,omitempty"`

	// Fill gaps in the metric with zero.
	FillGapWithZero *bool `json:"fillGapWithZero,omitempty"`

	// Name of the metric.
	Name *string `json:"name,omitempty"`

	// Supported aggregation types for the metric.
	SupportedAggregationTypes []*string `json:"supportedAggregationTypes,omitempty"`

	// Unit for the metric.
	Unit *string `json:"unit,omitempty"`
}

// OperationResourceMetricSpecificationDimension object.
type OperationResourceMetricSpecificationDimension struct {
	// Display name of the dimensions.
	DisplayName *string `json:"displayName,omitempty"`

	// Name of the dimension.
	Name *string `json:"name,omitempty"`

	// Indicates metric should be exported for Shoebox.
	ToBeExportedForShoebox *bool `json:"toBeExportedForShoebox,omitempty"`
}

// OperationResourceServiceSpecification - Service specification.
type OperationResourceServiceSpecification struct {
	// List of metric specifications.
	MetricSpecifications []*OperationResourceMetricSpecification `json:"metricSpecifications,omitempty"`
}

// OperationStatus - Operation status object
type OperationStatus struct {
	// READ-ONLY; End time of the operation
	EndTime *time.Time `json:"endTime,omitempty" azure:"ro"`

	// READ-ONLY; Error details.
	Error *APIError `json:"error,omitempty" azure:"ro"`

	// READ-ONLY; Operation Id
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Start time of the operation
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`

	// READ-ONLY; Operation status
	Status *string `json:"status,omitempty" azure:"ro"`
}

// OperationStatusClientGetOptions contains the optional parameters for the OperationStatusClient.Get method.
type OperationStatusClientGetOptions struct {
	// placeholder for future optional parameters
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// PostBackupResponse - Post Backup Response
type PostBackupResponse struct {
	// Post Backup Response Properties
	BackupMetadata *PostBackupResponseProperties `json:"backupMetadata,omitempty"`
}

// PostBackupResponseProperties - Post Backup Response Properties object.
type PostBackupResponseProperties struct {
	// READ-ONLY; cloud endpoint Name.
	CloudEndpointName *string `json:"cloudEndpointName,omitempty" azure:"ro"`
}

// PostRestoreRequest - Post Restore Request
type PostRestoreRequest struct {
	// Post Restore Azure file share uri.
	AzureFileShareURI *string `json:"azureFileShareUri,omitempty"`

	// Post Restore Azure failed file list.
	FailedFileList *string `json:"failedFileList,omitempty"`

	// Post Restore partition.
	Partition *string `json:"partition,omitempty"`

	// Post Restore replica group.
	ReplicaGroup *string `json:"replicaGroup,omitempty"`

	// Post Restore request id.
	RequestID *string `json:"requestId,omitempty"`

	// Post Restore restore file spec array.
	RestoreFileSpec []*RestoreFileSpec `json:"restoreFileSpec,omitempty"`

	// Post Restore Azure source azure file share uri.
	SourceAzureFileShareURI *string `json:"sourceAzureFileShareUri,omitempty"`

	// Post Restore Azure status.
	Status *string `json:"status,omitempty"`
}

// PreRestoreRequest - Pre Restore request object.
type PreRestoreRequest struct {
	// Pre Restore Azure file share uri.
	AzureFileShareURI *string `json:"azureFileShareUri,omitempty"`

	// Pre Restore backup metadata property bag.
	BackupMetadataPropertyBag *string `json:"backupMetadataPropertyBag,omitempty"`

	// Pre Restore partition.
	Partition *string `json:"partition,omitempty"`

	// Pre Restore pause wait for sync drain time period in seconds.
	PauseWaitForSyncDrainTimePeriodInSeconds *int32 `json:"pauseWaitForSyncDrainTimePeriodInSeconds,omitempty"`

	// Pre Restore replica group.
	ReplicaGroup *string `json:"replicaGroup,omitempty"`

	// Pre Restore request id.
	RequestID *string `json:"requestId,omitempty"`

	// Pre Restore restore file spec array.
	RestoreFileSpec []*RestoreFileSpec `json:"restoreFileSpec,omitempty"`

	// Pre Restore Azure source azure file share uri.
	SourceAzureFileShareURI *string `json:"sourceAzureFileShareUri,omitempty"`

	// Pre Restore Azure status.
	Status *string `json:"status,omitempty"`
}

// PrivateEndpoint - The Private Endpoint resource.
type PrivateEndpoint struct {
	// READ-ONLY; The ARM identifier for Private Endpoint
	ID *string `json:"id,omitempty" azure:"ro"`
}

// PrivateEndpointConnection - The Private Endpoint Connection resource.
type PrivateEndpointConnection struct {
	// Resource properties.
	Properties *PrivateEndpointConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionListResult - List of private endpoint connection associated with the specified storage account
type PrivateEndpointConnectionListResult struct {
	// Array of private endpoint connections
	Value []*PrivateEndpointConnection `json:"value,omitempty"`
}

// PrivateEndpointConnectionProperties - Properties of the PrivateEndpointConnectProperties.
type PrivateEndpointConnectionProperties struct {
	// REQUIRED; A collection of information about the state of the connection between service consumer and provider.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`

	// The resource of private end point.
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty"`

	// READ-ONLY; The provisioning state of the private endpoint connection resource.
	ProvisioningState *PrivateEndpointConnectionProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionsClientBeginCreateOptions contains the optional parameters for the PrivateEndpointConnectionsClient.BeginCreate
// method.
type PrivateEndpointConnectionsClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointConnectionsClientBeginDeleteOptions contains the optional parameters for the PrivateEndpointConnectionsClient.BeginDelete
// method.
type PrivateEndpointConnectionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointConnectionsClientGetOptions contains the optional parameters for the PrivateEndpointConnectionsClient.Get
// method.
type PrivateEndpointConnectionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsClientListByStorageSyncServiceOptions contains the optional parameters for the PrivateEndpointConnectionsClient.ListByStorageSyncService
// method.
type PrivateEndpointConnectionsClientListByStorageSyncServiceOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResource - A private link resource
type PrivateLinkResource struct {
	// Resource properties.
	Properties *PrivateLinkResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateLinkResourceListResult - A list of private link resources
type PrivateLinkResourceListResult struct {
	// Array of private link resources
	Value []*PrivateLinkResource `json:"value,omitempty"`
}

// PrivateLinkResourceProperties - Properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// The private link resource Private link DNS zone name.
	RequiredZoneNames []*string `json:"requiredZoneNames,omitempty"`

	// READ-ONLY; The private link resource group id.
	GroupID *string `json:"groupId,omitempty" azure:"ro"`

	// READ-ONLY; The private link resource required member names.
	RequiredMembers []*string `json:"requiredMembers,omitempty" azure:"ro"`
}

// PrivateLinkResourcesClientListByStorageSyncServiceOptions contains the optional parameters for the PrivateLinkResourcesClient.ListByStorageSyncService
// method.
type PrivateLinkResourcesClientListByStorageSyncServiceOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkServiceConnectionState - A collection of information about the state of the connection between service consumer
// and provider.
type PrivateLinkServiceConnectionState struct {
	// A message indicating if changes on the service provider require any updates on the consumer.
	ActionsRequired *string `json:"actionsRequired,omitempty"`

	// The reason for approval/rejection of the connection.
	Description *string `json:"description,omitempty"`

	// Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
	Status *PrivateEndpointServiceConnectionStatus `json:"status,omitempty"`
}

// ProxyResource - The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a
// location
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RecallActionParameters - The parameters used when calling recall action on server endpoint.
type RecallActionParameters struct {
	// Pattern of the files.
	Pattern *string `json:"pattern,omitempty"`

	// Recall path.
	RecallPath *string `json:"recallPath,omitempty"`
}

// RegisteredServer - Registered Server resource.
type RegisteredServer struct {
	// RegisteredServer properties.
	Properties *RegisteredServerProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RegisteredServerArray - Array of RegisteredServer
type RegisteredServerArray struct {
	// Collection of Registered Server.
	Value []*RegisteredServer `json:"value,omitempty"`
}

// RegisteredServerCreateParameters - The parameters used when creating a registered server.
type RegisteredServerCreateParameters struct {
	// The parameters used to create the registered server.
	Properties *RegisteredServerCreateParametersProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RegisteredServerCreateParametersProperties - RegisteredServer Create Properties object.
type RegisteredServerCreateParametersProperties struct {
	// Registered Server Agent Version
	AgentVersion *string `json:"agentVersion,omitempty"`

	// Registered Server clusterId
	ClusterID *string `json:"clusterId,omitempty"`

	// Registered Server clusterName
	ClusterName *string `json:"clusterName,omitempty"`

	// Friendly Name
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Registered Server last heart beat
	LastHeartBeat *string `json:"lastHeartBeat,omitempty"`

	// Registered Server Certificate
	ServerCertificate *string `json:"serverCertificate,omitempty"`

	// Registered Server serverId
	ServerID *string `json:"serverId,omitempty"`

	// Registered Server OS Version
	ServerOSVersion *string `json:"serverOSVersion,omitempty"`

	// Registered Server serverRole
	ServerRole *string `json:"serverRole,omitempty"`
}

// RegisteredServerProperties - RegisteredServer Properties object.
type RegisteredServerProperties struct {
	// Registered Server Agent Version
	AgentVersion *string `json:"agentVersion,omitempty"`

	// Registered Server clusterId
	ClusterID *string `json:"clusterId,omitempty"`

	// Registered Server clusterName
	ClusterName *string `json:"clusterName,omitempty"`

	// Resource discoveryEndpointUri
	DiscoveryEndpointURI *string `json:"discoveryEndpointUri,omitempty"`

	// Friendly Name
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Registered Server last heart beat
	LastHeartBeat *string `json:"lastHeartBeat,omitempty"`

	// Resource Last Operation Name
	LastOperationName *string `json:"lastOperationName,omitempty"`

	// Registered Server lastWorkflowId
	LastWorkflowID *string `json:"lastWorkflowId,omitempty"`

	// Management Endpoint Uri
	ManagementEndpointURI *string `json:"managementEndpointUri,omitempty"`

	// Monitoring Configuration
	MonitoringConfiguration *string `json:"monitoringConfiguration,omitempty"`

	// Telemetry Endpoint Uri
	MonitoringEndpointURI *string `json:"monitoringEndpointUri,omitempty"`

	// Registered Server Provisioning State
	ProvisioningState *string `json:"provisioningState,omitempty"`

	// Resource Location
	ResourceLocation *string `json:"resourceLocation,omitempty"`

	// Registered Server Certificate
	ServerCertificate *string `json:"serverCertificate,omitempty"`

	// Registered Server serverId
	ServerID *string `json:"serverId,omitempty"`

	// Registered Server Management Error Code
	ServerManagementErrorCode *int32 `json:"serverManagementErrorCode,omitempty"`

	// Registered Server OS Version
	ServerOSVersion *string `json:"serverOSVersion,omitempty"`

	// Registered Server serverRole
	ServerRole *string `json:"serverRole,omitempty"`

	// Service Location
	ServiceLocation *string `json:"serviceLocation,omitempty"`

	// Registered Server storageSyncServiceUid
	StorageSyncServiceUID *string `json:"storageSyncServiceUid,omitempty"`

	// READ-ONLY; Registered Server Agent Version Expiration Date
	AgentVersionExpirationDate *time.Time `json:"agentVersionExpirationDate,omitempty" azure:"ro"`

	// READ-ONLY; Registered Server Agent Version Status
	AgentVersionStatus *RegisteredServerAgentVersionStatus `json:"agentVersionStatus,omitempty" azure:"ro"`

	// READ-ONLY; Server name
	ServerName *string `json:"serverName,omitempty" azure:"ro"`
}

// RegisteredServersClientBeginCreateOptions contains the optional parameters for the RegisteredServersClient.BeginCreate
// method.
type RegisteredServersClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// RegisteredServersClientBeginDeleteOptions contains the optional parameters for the RegisteredServersClient.BeginDelete
// method.
type RegisteredServersClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// RegisteredServersClientBeginTriggerRolloverOptions contains the optional parameters for the RegisteredServersClient.BeginTriggerRollover
// method.
type RegisteredServersClientBeginTriggerRolloverOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// RegisteredServersClientGetOptions contains the optional parameters for the RegisteredServersClient.Get method.
type RegisteredServersClientGetOptions struct {
	// placeholder for future optional parameters
}

// RegisteredServersClientListByStorageSyncServiceOptions contains the optional parameters for the RegisteredServersClient.ListByStorageSyncService
// method.
type RegisteredServersClientListByStorageSyncServiceOptions struct {
	// placeholder for future optional parameters
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourcesMoveInfo - Resource Move Info.
type ResourcesMoveInfo struct {
	// Collection of Resources.
	Resources []*string `json:"resources,omitempty"`

	// Target resource group.
	TargetResourceGroup *string `json:"targetResourceGroup,omitempty"`
}

// RestoreFileSpec - Restore file spec.
type RestoreFileSpec struct {
	// Restore file spec isdir
	Isdir *bool `json:"isdir,omitempty"`

	// Restore file spec path
	Path *string `json:"path,omitempty"`
}

// ServerEndpoint - Server Endpoint object.
type ServerEndpoint struct {
	// Server Endpoint properties.
	Properties *ServerEndpointProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServerEndpointArray - Array of ServerEndpoint
type ServerEndpointArray struct {
	// Collection of ServerEndpoint.
	Value []*ServerEndpoint `json:"value,omitempty"`
}

// ServerEndpointBackgroundDataDownloadActivity - Background data download activity object
type ServerEndpointBackgroundDataDownloadActivity struct {
	// READ-ONLY; Running count of bytes downloaded
	DownloadedBytes *int64 `json:"downloadedBytes,omitempty" azure:"ro"`

	// READ-ONLY; Progress percentage
	PercentProgress *int32 `json:"percentProgress,omitempty" azure:"ro"`

	// READ-ONLY; Timestamp when the operation started
	StartedTimestamp *time.Time `json:"startedTimestamp,omitempty" azure:"ro"`

	// READ-ONLY; Timestamp when properties were updated
	Timestamp *time.Time `json:"timestamp,omitempty" azure:"ro"`
}

// ServerEndpointCloudTieringStatus - Server endpoint cloud tiering status object.
type ServerEndpointCloudTieringStatus struct {
	// READ-ONLY; Information regarding how well the local cache on the server is performing.
	CachePerformance *CloudTieringCachePerformance `json:"cachePerformance,omitempty" azure:"ro"`

	// READ-ONLY; Status of the date policy
	DatePolicyStatus *CloudTieringDatePolicyStatus `json:"datePolicyStatus,omitempty" azure:"ro"`

	// READ-ONLY; Information regarding files that failed to be tiered
	FilesNotTiering *CloudTieringFilesNotTiering `json:"filesNotTiering,omitempty" azure:"ro"`

	// READ-ONLY; Cloud tiering health state.
	Health *ServerEndpointHealthState `json:"health,omitempty" azure:"ro"`

	// READ-ONLY; The last updated timestamp of health state
	HealthLastUpdatedTimestamp *time.Time `json:"healthLastUpdatedTimestamp,omitempty" azure:"ro"`

	// READ-ONLY; Last cloud tiering result (HResult)
	LastCloudTieringResult *int32 `json:"lastCloudTieringResult,omitempty" azure:"ro"`

	// READ-ONLY; Last cloud tiering success timestamp
	LastSuccessTimestamp *time.Time `json:"lastSuccessTimestamp,omitempty" azure:"ro"`

	// READ-ONLY; Last updated timestamp
	LastUpdatedTimestamp *time.Time `json:"lastUpdatedTimestamp,omitempty" azure:"ro"`

	// READ-ONLY; Information regarding how much local space cloud tiering is saving.
	SpaceSavings *CloudTieringSpaceSavings `json:"spaceSavings,omitempty" azure:"ro"`

	// READ-ONLY; Status of the volume free space policy
	VolumeFreeSpacePolicyStatus *CloudTieringVolumeFreeSpacePolicyStatus `json:"volumeFreeSpacePolicyStatus,omitempty" azure:"ro"`
}

// ServerEndpointCreateParameters - The parameters used when creating a server endpoint.
type ServerEndpointCreateParameters struct {
	// The parameters used to create the server endpoint.
	Properties *ServerEndpointCreateParametersProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServerEndpointCreateParametersProperties - ServerEndpoint Properties object.
type ServerEndpointCreateParametersProperties struct {
	// Cloud Tiering.
	CloudTiering *FeatureStatus `json:"cloudTiering,omitempty"`

	// Friendly Name
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Policy for how namespace and files are recalled during FastDr.
	InitialDownloadPolicy *InitialDownloadPolicy `json:"initialDownloadPolicy,omitempty"`

	// Policy for how the initial upload sync session is performed.
	InitialUploadPolicy *InitialUploadPolicy `json:"initialUploadPolicy,omitempty"`

	// Policy for enabling follow-the-sun business models: link local cache to cloud behavior to pre-populate before local access.
	LocalCacheMode *LocalCacheMode `json:"localCacheMode,omitempty"`

	// Offline data transfer
	OfflineDataTransfer *FeatureStatus `json:"offlineDataTransfer,omitempty"`

	// Offline data transfer share name
	OfflineDataTransferShareName *string `json:"offlineDataTransferShareName,omitempty"`

	// Server Local path.
	ServerLocalPath *string `json:"serverLocalPath,omitempty"`

	// Server Resource Id.
	ServerResourceID *string `json:"serverResourceId,omitempty"`

	// Tier files older than days.
	TierFilesOlderThanDays *int32 `json:"tierFilesOlderThanDays,omitempty"`

	// Level of free space to be maintained by Cloud Tiering if it is enabled.
	VolumeFreeSpacePercent *int32 `json:"volumeFreeSpacePercent,omitempty"`
}

// ServerEndpointFilesNotSyncingError - Files not syncing error object
type ServerEndpointFilesNotSyncingError struct {
	// READ-ONLY; Error code (HResult)
	ErrorCode *int32 `json:"errorCode,omitempty" azure:"ro"`

	// READ-ONLY; Count of persistent files not syncing with the specified error code
	PersistentCount *int64 `json:"persistentCount,omitempty" azure:"ro"`

	// READ-ONLY; Count of transient files not syncing with the specified error code
	TransientCount *int64 `json:"transientCount,omitempty" azure:"ro"`
}

// ServerEndpointProperties - ServerEndpoint Properties object.
type ServerEndpointProperties struct {
	// Cloud Tiering.
	CloudTiering *FeatureStatus `json:"cloudTiering,omitempty"`

	// Friendly Name
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Policy for how namespace and files are recalled during FastDr.
	InitialDownloadPolicy *InitialDownloadPolicy `json:"initialDownloadPolicy,omitempty"`

	// Policy for how the initial upload sync session is performed.
	InitialUploadPolicy *InitialUploadPolicy `json:"initialUploadPolicy,omitempty"`

	// Policy for enabling follow-the-sun business models: link local cache to cloud behavior to pre-populate before local access.
	LocalCacheMode *LocalCacheMode `json:"localCacheMode,omitempty"`

	// Offline data transfer
	OfflineDataTransfer *FeatureStatus `json:"offlineDataTransfer,omitempty"`

	// Offline data transfer share name
	OfflineDataTransferShareName *string `json:"offlineDataTransferShareName,omitempty"`

	// Server Local path.
	ServerLocalPath *string `json:"serverLocalPath,omitempty"`

	// Server Resource Id.
	ServerResourceID *string `json:"serverResourceId,omitempty"`

	// Tier files older than days.
	TierFilesOlderThanDays *int32 `json:"tierFilesOlderThanDays,omitempty"`

	// Level of free space to be maintained by Cloud Tiering if it is enabled.
	VolumeFreeSpacePercent *int32 `json:"volumeFreeSpacePercent,omitempty"`

	// READ-ONLY; Cloud tiering status. Only populated if cloud tiering is enabled.
	CloudTieringStatus *ServerEndpointCloudTieringStatus `json:"cloudTieringStatus,omitempty" azure:"ro"`

	// READ-ONLY; Resource Last Operation Name
	LastOperationName *string `json:"lastOperationName,omitempty" azure:"ro"`

	// READ-ONLY; ServerEndpoint lastWorkflowId
	LastWorkflowID *string `json:"lastWorkflowId,omitempty" azure:"ro"`

	// READ-ONLY; Offline data transfer storage account resource ID
	OfflineDataTransferStorageAccountResourceID *string `json:"offlineDataTransferStorageAccountResourceId,omitempty" azure:"ro"`

	// READ-ONLY; Offline data transfer storage account tenant ID
	OfflineDataTransferStorageAccountTenantID *string `json:"offlineDataTransferStorageAccountTenantId,omitempty" azure:"ro"`

	// READ-ONLY; ServerEndpoint Provisioning State
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Recall status. Only populated if cloud tiering is enabled.
	RecallStatus *ServerEndpointRecallStatus `json:"recallStatus,omitempty" azure:"ro"`

	// READ-ONLY; Server name
	ServerName *string `json:"serverName,omitempty" azure:"ro"`

	// READ-ONLY; Server Endpoint sync status
	SyncStatus *ServerEndpointSyncStatus `json:"syncStatus,omitempty" azure:"ro"`
}

// ServerEndpointRecallError - Server endpoint recall error object
type ServerEndpointRecallError struct {
	// READ-ONLY; Count of occurences of the error
	Count *int64 `json:"count,omitempty" azure:"ro"`

	// READ-ONLY; Error code (HResult)
	ErrorCode *int32 `json:"errorCode,omitempty" azure:"ro"`
}

// ServerEndpointRecallStatus - Server endpoint recall status object.
type ServerEndpointRecallStatus struct {
	// READ-ONLY; Last updated timestamp
	LastUpdatedTimestamp *time.Time `json:"lastUpdatedTimestamp,omitempty" azure:"ro"`

	// READ-ONLY; Array of recall errors
	RecallErrors []*ServerEndpointRecallError `json:"recallErrors,omitempty" azure:"ro"`

	// READ-ONLY; Total count of recall errors.
	TotalRecallErrorsCount *int64 `json:"totalRecallErrorsCount,omitempty" azure:"ro"`
}

// ServerEndpointSyncActivityStatus - Sync Session status object.
type ServerEndpointSyncActivityStatus struct {
	// READ-ONLY; Applied bytes
	AppliedBytes *int64 `json:"appliedBytes,omitempty" azure:"ro"`

	// READ-ONLY; Applied item count.
	AppliedItemCount *int64 `json:"appliedItemCount,omitempty" azure:"ro"`

	// READ-ONLY; Per item error count
	PerItemErrorCount *int64 `json:"perItemErrorCount,omitempty" azure:"ro"`

	// READ-ONLY; Session minutes remaining (if available)
	SessionMinutesRemaining *int32 `json:"sessionMinutesRemaining,omitempty" azure:"ro"`

	// READ-ONLY; Sync mode
	SyncMode *ServerEndpointSyncMode `json:"syncMode,omitempty" azure:"ro"`

	// READ-ONLY; Timestamp when properties were updated
	Timestamp *time.Time `json:"timestamp,omitempty" azure:"ro"`

	// READ-ONLY; Total bytes (if available)
	TotalBytes *int64 `json:"totalBytes,omitempty" azure:"ro"`

	// READ-ONLY; Total item count (if available)
	TotalItemCount *int64 `json:"totalItemCount,omitempty" azure:"ro"`
}

// ServerEndpointSyncSessionStatus - Sync Session status object.
type ServerEndpointSyncSessionStatus struct {
	// READ-ONLY; Array of per-item errors coming from the last sync session.
	FilesNotSyncingErrors []*ServerEndpointFilesNotSyncingError `json:"filesNotSyncingErrors,omitempty" azure:"ro"`

	// READ-ONLY; Sync mode
	LastSyncMode *ServerEndpointSyncMode `json:"lastSyncMode,omitempty" azure:"ro"`

	// READ-ONLY; Last sync per item error count.
	LastSyncPerItemErrorCount *int64 `json:"lastSyncPerItemErrorCount,omitempty" azure:"ro"`

	// READ-ONLY; Last sync result (HResult)
	LastSyncResult *int32 `json:"lastSyncResult,omitempty" azure:"ro"`

	// READ-ONLY; Last sync success timestamp
	LastSyncSuccessTimestamp *time.Time `json:"lastSyncSuccessTimestamp,omitempty" azure:"ro"`

	// READ-ONLY; Last sync timestamp
	LastSyncTimestamp *time.Time `json:"lastSyncTimestamp,omitempty" azure:"ro"`

	// READ-ONLY; Count of persistent files not syncing.
	PersistentFilesNotSyncingCount *int64 `json:"persistentFilesNotSyncingCount,omitempty" azure:"ro"`

	// READ-ONLY; Count of transient files not syncing.
	TransientFilesNotSyncingCount *int64 `json:"transientFilesNotSyncingCount,omitempty" azure:"ro"`
}

// ServerEndpointSyncStatus - Server Endpoint sync status
type ServerEndpointSyncStatus struct {
	// READ-ONLY; Background data download activity
	BackgroundDataDownloadActivity *ServerEndpointBackgroundDataDownloadActivity `json:"backgroundDataDownloadActivity,omitempty" azure:"ro"`

	// READ-ONLY; Combined Health Status.
	CombinedHealth *ServerEndpointHealthState `json:"combinedHealth,omitempty" azure:"ro"`

	// READ-ONLY; Download sync activity
	DownloadActivity *ServerEndpointSyncActivityStatus `json:"downloadActivity,omitempty" azure:"ro"`

	// READ-ONLY; Download Health Status.
	DownloadHealth *ServerEndpointHealthState `json:"downloadHealth,omitempty" azure:"ro"`

	// READ-ONLY; Download Status
	DownloadStatus *ServerEndpointSyncSessionStatus `json:"downloadStatus,omitempty" azure:"ro"`

	// READ-ONLY; Last Updated Timestamp
	LastUpdatedTimestamp *time.Time `json:"lastUpdatedTimestamp,omitempty" azure:"ro"`

	// READ-ONLY; Offline Data Transfer State
	OfflineDataTransferStatus *ServerEndpointOfflineDataTransferState `json:"offlineDataTransferStatus,omitempty" azure:"ro"`

	// READ-ONLY; Sync activity
	SyncActivity *ServerEndpointSyncActivityState `json:"syncActivity,omitempty" azure:"ro"`

	// READ-ONLY; Total count of persistent files not syncing (combined upload + download).
	TotalPersistentFilesNotSyncingCount *int64 `json:"totalPersistentFilesNotSyncingCount,omitempty" azure:"ro"`

	// READ-ONLY; Upload sync activity
	UploadActivity *ServerEndpointSyncActivityStatus `json:"uploadActivity,omitempty" azure:"ro"`

	// READ-ONLY; Upload Health Status.
	UploadHealth *ServerEndpointHealthState `json:"uploadHealth,omitempty" azure:"ro"`

	// READ-ONLY; Upload Status
	UploadStatus *ServerEndpointSyncSessionStatus `json:"uploadStatus,omitempty" azure:"ro"`
}

// ServerEndpointUpdateParameters - Parameters for updating an Server Endpoint.
type ServerEndpointUpdateParameters struct {
	// The properties of the server endpoint.
	Properties *ServerEndpointUpdateProperties `json:"properties,omitempty"`
}

// ServerEndpointUpdateProperties - ServerEndpoint Update Properties object.
type ServerEndpointUpdateProperties struct {
	// Cloud Tiering.
	CloudTiering *FeatureStatus `json:"cloudTiering,omitempty"`

	// Policy for enabling follow-the-sun business models: link local cache to cloud behavior to pre-populate before local access.
	LocalCacheMode *LocalCacheMode `json:"localCacheMode,omitempty"`

	// Offline data transfer
	OfflineDataTransfer *FeatureStatus `json:"offlineDataTransfer,omitempty"`

	// Offline data transfer share name
	OfflineDataTransferShareName *string `json:"offlineDataTransferShareName,omitempty"`

	// Tier files older than days.
	TierFilesOlderThanDays *int32 `json:"tierFilesOlderThanDays,omitempty"`

	// Level of free space to be maintained by Cloud Tiering if it is enabled.
	VolumeFreeSpacePercent *int32 `json:"volumeFreeSpacePercent,omitempty"`
}

// ServerEndpointsClientBeginCreateOptions contains the optional parameters for the ServerEndpointsClient.BeginCreate method.
type ServerEndpointsClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServerEndpointsClientBeginDeleteOptions contains the optional parameters for the ServerEndpointsClient.BeginDelete method.
type ServerEndpointsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServerEndpointsClientBeginRecallActionOptions contains the optional parameters for the ServerEndpointsClient.BeginRecallAction
// method.
type ServerEndpointsClientBeginRecallActionOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServerEndpointsClientBeginUpdateOptions contains the optional parameters for the ServerEndpointsClient.BeginUpdate method.
type ServerEndpointsClientBeginUpdateOptions struct {
	// Any of the properties applicable in PUT request.
	Parameters *ServerEndpointUpdateParameters
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServerEndpointsClientGetOptions contains the optional parameters for the ServerEndpointsClient.Get method.
type ServerEndpointsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ServerEndpointsClientListBySyncGroupOptions contains the optional parameters for the ServerEndpointsClient.ListBySyncGroup
// method.
type ServerEndpointsClientListBySyncGroupOptions struct {
	// placeholder for future optional parameters
}

// Service - Storage Sync Service object.
type Service struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Storage Sync Service properties.
	Properties *ServiceProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServiceArray - Array of StorageSyncServices
type ServiceArray struct {
	// Collection of StorageSyncServices.
	Value []*Service `json:"value,omitempty"`
}

// ServiceCreateParameters - The parameters used when creating a storage sync service.
type ServiceCreateParameters struct {
	// REQUIRED; Required. Gets or sets the location of the resource. This will be one of the supported and registered Azure Geo
	// Regions (e.g. West US, East US, Southeast Asia, etc.). The geo region of a resource
	// cannot be changed once it is created, but if an identical geo region is specified on update, the request will succeed.
	Location *string `json:"location,omitempty"`

	// The parameters used to create the storage sync service.
	Properties *ServiceCreateParametersProperties `json:"properties,omitempty"`

	// Gets or sets a list of key value pairs that describe the resource. These tags can be used for viewing and grouping this
	// resource (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key with a length no greater than 128 characters and a value with a length no greater than
	// 256 characters.
	Tags map[string]*string `json:"tags,omitempty"`
}

// ServiceCreateParametersProperties - StorageSyncService Properties object.
type ServiceCreateParametersProperties struct {
	// Incoming Traffic Policy
	IncomingTrafficPolicy *IncomingTrafficPolicy `json:"incomingTrafficPolicy,omitempty"`
}

// ServiceProperties - Storage Sync Service Properties object.
type ServiceProperties struct {
	// Incoming Traffic Policy
	IncomingTrafficPolicy *IncomingTrafficPolicy `json:"incomingTrafficPolicy,omitempty"`

	// READ-ONLY; Resource Last Operation Name
	LastOperationName *string `json:"lastOperationName,omitempty" azure:"ro"`

	// READ-ONLY; StorageSyncService lastWorkflowId
	LastWorkflowID *string `json:"lastWorkflowId,omitempty" azure:"ro"`

	// READ-ONLY; List of private endpoint connection associated with the specified storage sync service
	PrivateEndpointConnections []*PrivateEndpointConnection `json:"privateEndpointConnections,omitempty" azure:"ro"`

	// READ-ONLY; StorageSyncService Provisioning State
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Storage Sync service status.
	StorageSyncServiceStatus *int32 `json:"storageSyncServiceStatus,omitempty" azure:"ro"`

	// READ-ONLY; Storage Sync service Uid
	StorageSyncServiceUID *string `json:"storageSyncServiceUid,omitempty" azure:"ro"`
}

// ServiceUpdateParameters - Parameters for updating an Storage sync service.
type ServiceUpdateParameters struct {
	// The properties of the server endpoint.
	Properties *ServiceUpdateProperties `json:"properties,omitempty"`

	// The user-specified tags associated with the storage sync service.
	Tags map[string]*string `json:"tags,omitempty"`
}

// ServiceUpdateProperties - StorageSyncService Properties object.
type ServiceUpdateProperties struct {
	// Incoming Traffic Policy
	IncomingTrafficPolicy *IncomingTrafficPolicy `json:"incomingTrafficPolicy,omitempty"`
}

// ServicesClientBeginCreateOptions contains the optional parameters for the ServicesClient.BeginCreate method.
type ServicesClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServicesClientBeginDeleteOptions contains the optional parameters for the ServicesClient.BeginDelete method.
type ServicesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServicesClientBeginUpdateOptions contains the optional parameters for the ServicesClient.BeginUpdate method.
type ServicesClientBeginUpdateOptions struct {
	// Storage Sync Service resource.
	Parameters *ServiceUpdateParameters
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServicesClientCheckNameAvailabilityOptions contains the optional parameters for the ServicesClient.CheckNameAvailability
// method.
type ServicesClientCheckNameAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// ServicesClientGetOptions contains the optional parameters for the ServicesClient.Get method.
type ServicesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ServicesClientListByResourceGroupOptions contains the optional parameters for the ServicesClient.ListByResourceGroup method.
type ServicesClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ServicesClientListBySubscriptionOptions contains the optional parameters for the ServicesClient.ListBySubscription method.
type ServicesClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// SubscriptionState - Subscription State object.
type SubscriptionState struct {
	// Subscription state properties.
	Properties interface{} `json:"properties,omitempty"`

	// State of Azure Subscription
	State *Reason `json:"state,omitempty"`

	// READ-ONLY; Is Transitioning
	Istransitioning *bool `json:"istransitioning,omitempty" azure:"ro"`
}

// SyncGroup - Sync Group object.
type SyncGroup struct {
	// SyncGroup properties.
	Properties *SyncGroupProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SyncGroupArray - Array of SyncGroup
type SyncGroupArray struct {
	// Collection of SyncGroup.
	Value []*SyncGroup `json:"value,omitempty"`
}

// SyncGroupCreateParameters - The parameters used when creating a sync group.
type SyncGroupCreateParameters struct {
	// The parameters used to create the sync group
	Properties interface{} `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SyncGroupProperties - SyncGroup Properties object.
type SyncGroupProperties struct {
	// READ-ONLY; Sync group status
	SyncGroupStatus *string `json:"syncGroupStatus,omitempty" azure:"ro"`

	// READ-ONLY; Unique Id
	UniqueID *string `json:"uniqueId,omitempty" azure:"ro"`
}

// SyncGroupsClientCreateOptions contains the optional parameters for the SyncGroupsClient.Create method.
type SyncGroupsClientCreateOptions struct {
	// placeholder for future optional parameters
}

// SyncGroupsClientDeleteOptions contains the optional parameters for the SyncGroupsClient.Delete method.
type SyncGroupsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// SyncGroupsClientGetOptions contains the optional parameters for the SyncGroupsClient.Get method.
type SyncGroupsClientGetOptions struct {
	// placeholder for future optional parameters
}

// SyncGroupsClientListByStorageSyncServiceOptions contains the optional parameters for the SyncGroupsClient.ListByStorageSyncService
// method.
type SyncGroupsClientListByStorageSyncServiceOptions struct {
	// placeholder for future optional parameters
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// TrackedResource - The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags'
// and a 'location'
type TrackedResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// TriggerChangeDetectionParameters - The parameters used when calling trigger change detection action on cloud endpoint.
type TriggerChangeDetectionParameters struct {
	// Change Detection Mode. Applies to a directory specified in directoryPath parameter.
	ChangeDetectionMode *ChangeDetectionMode `json:"changeDetectionMode,omitempty"`

	// Relative path to a directory Azure File share for which change detection is to be performed.
	DirectoryPath *string `json:"directoryPath,omitempty"`

	// Array of relative paths on the Azure File share to be included in the change detection. Can be files and directories.
	Paths []*string `json:"paths,omitempty"`
}

// TriggerRolloverRequest - Trigger Rollover Request.
type TriggerRolloverRequest struct {
	// Certificate Data
	ServerCertificate *string `json:"serverCertificate,omitempty"`
}

// Workflow resource.
type Workflow struct {
	// Workflow properties.
	Properties *WorkflowProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WorkflowArray - Array of Workflow
type WorkflowArray struct {
	// Collection of workflow items.
	Value []*Workflow `json:"value,omitempty"`
}

// WorkflowProperties - Workflow Properties object.
type WorkflowProperties struct {
	// workflow last operation identifier.
	LastOperationID *string `json:"lastOperationId,omitempty"`

	// last step name
	LastStepName *string `json:"lastStepName,omitempty"`

	// operation direction.
	Operation *OperationDirection `json:"operation,omitempty"`

	// workflow status.
	Status *WorkflowStatus `json:"status,omitempty"`

	// workflow steps
	Steps *string `json:"steps,omitempty"`

	// READ-ONLY; workflow command name.
	CommandName *string `json:"commandName,omitempty" azure:"ro"`

	// READ-ONLY; workflow created timestamp.
	CreatedTimestamp *time.Time `json:"createdTimestamp,omitempty" azure:"ro"`

	// READ-ONLY; workflow last status timestamp.
	LastStatusTimestamp *time.Time `json:"lastStatusTimestamp,omitempty" azure:"ro"`
}

// WorkflowsClientAbortOptions contains the optional parameters for the WorkflowsClient.Abort method.
type WorkflowsClientAbortOptions struct {
	// placeholder for future optional parameters
}

// WorkflowsClientGetOptions contains the optional parameters for the WorkflowsClient.Get method.
type WorkflowsClientGetOptions struct {
	// placeholder for future optional parameters
}

// WorkflowsClientListByStorageSyncServiceOptions contains the optional parameters for the WorkflowsClient.ListByStorageSyncService
// method.
type WorkflowsClientListByStorageSyncServiceOptions struct {
	// placeholder for future optional parameters
}
