//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armstorsimple1200series

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// BackupScheduleGroupsClient contains the methods for the BackupScheduleGroups group.
// Don't use this type directly, use NewBackupScheduleGroupsClient() instead.
type BackupScheduleGroupsClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewBackupScheduleGroupsClient creates a new instance of BackupScheduleGroupsClient with the specified values.
// subscriptionID - The subscription id
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewBackupScheduleGroupsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*BackupScheduleGroupsClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &BackupScheduleGroupsClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// BeginCreateOrUpdate - Creates or Updates the backup schedule Group.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
// deviceName - The name of the device.
// scheduleGroupName - The name of the schedule group.
// resourceGroupName - The resource group name
// managerName - The manager name
// scheduleGroup - The schedule group to be created
// options - BackupScheduleGroupsClientBeginCreateOrUpdateOptions contains the optional parameters for the BackupScheduleGroupsClient.BeginCreateOrUpdate
// method.
func (client *BackupScheduleGroupsClient) BeginCreateOrUpdate(ctx context.Context, deviceName string, scheduleGroupName string, resourceGroupName string, managerName string, scheduleGroup BackupScheduleGroup, options *BackupScheduleGroupsClientBeginCreateOrUpdateOptions) (*runtime.Poller[BackupScheduleGroupsClientCreateOrUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createOrUpdate(ctx, deviceName, scheduleGroupName, resourceGroupName, managerName, scheduleGroup, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[BackupScheduleGroupsClientCreateOrUpdateResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[BackupScheduleGroupsClientCreateOrUpdateResponse](options.ResumeToken, client.pl, nil)
	}
}

// CreateOrUpdate - Creates or Updates the backup schedule Group.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
func (client *BackupScheduleGroupsClient) createOrUpdate(ctx context.Context, deviceName string, scheduleGroupName string, resourceGroupName string, managerName string, scheduleGroup BackupScheduleGroup, options *BackupScheduleGroupsClientBeginCreateOrUpdateOptions) (*http.Response, error) {
	req, err := client.createOrUpdateCreateRequest(ctx, deviceName, scheduleGroupName, resourceGroupName, managerName, scheduleGroup, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *BackupScheduleGroupsClient) createOrUpdateCreateRequest(ctx context.Context, deviceName string, scheduleGroupName string, resourceGroupName string, managerName string, scheduleGroup BackupScheduleGroup, options *BackupScheduleGroupsClientBeginCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/backupScheduleGroups/{scheduleGroupName}"
	if deviceName == "" {
		return nil, errors.New("parameter deviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", url.PathEscape(deviceName))
	if scheduleGroupName == "" {
		return nil, errors.New("parameter scheduleGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{scheduleGroupName}", url.PathEscape(scheduleGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managerName == "" {
		return nil, errors.New("parameter managerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", url.PathEscape(managerName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, scheduleGroup)
}

// BeginDelete - Deletes the backup schedule group.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
// deviceName - The name of the device.
// scheduleGroupName - The name of the schedule group.
// resourceGroupName - The resource group name
// managerName - The manager name
// options - BackupScheduleGroupsClientBeginDeleteOptions contains the optional parameters for the BackupScheduleGroupsClient.BeginDelete
// method.
func (client *BackupScheduleGroupsClient) BeginDelete(ctx context.Context, deviceName string, scheduleGroupName string, resourceGroupName string, managerName string, options *BackupScheduleGroupsClientBeginDeleteOptions) (*runtime.Poller[BackupScheduleGroupsClientDeleteResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteOperation(ctx, deviceName, scheduleGroupName, resourceGroupName, managerName, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[BackupScheduleGroupsClientDeleteResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[BackupScheduleGroupsClientDeleteResponse](options.ResumeToken, client.pl, nil)
	}
}

// Delete - Deletes the backup schedule group.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
func (client *BackupScheduleGroupsClient) deleteOperation(ctx context.Context, deviceName string, scheduleGroupName string, resourceGroupName string, managerName string, options *BackupScheduleGroupsClientBeginDeleteOptions) (*http.Response, error) {
	req, err := client.deleteCreateRequest(ctx, deviceName, scheduleGroupName, resourceGroupName, managerName, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusAccepted, http.StatusNoContent) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// deleteCreateRequest creates the Delete request.
func (client *BackupScheduleGroupsClient) deleteCreateRequest(ctx context.Context, deviceName string, scheduleGroupName string, resourceGroupName string, managerName string, options *BackupScheduleGroupsClientBeginDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/backupScheduleGroups/{scheduleGroupName}"
	if deviceName == "" {
		return nil, errors.New("parameter deviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", url.PathEscape(deviceName))
	if scheduleGroupName == "" {
		return nil, errors.New("parameter scheduleGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{scheduleGroupName}", url.PathEscape(scheduleGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managerName == "" {
		return nil, errors.New("parameter managerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", url.PathEscape(managerName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Returns the properties of the specified backup schedule group name.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
// deviceName - The name of the device.
// scheduleGroupName - The name of the schedule group.
// resourceGroupName - The resource group name
// managerName - The manager name
// options - BackupScheduleGroupsClientGetOptions contains the optional parameters for the BackupScheduleGroupsClient.Get
// method.
func (client *BackupScheduleGroupsClient) Get(ctx context.Context, deviceName string, scheduleGroupName string, resourceGroupName string, managerName string, options *BackupScheduleGroupsClientGetOptions) (BackupScheduleGroupsClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, deviceName, scheduleGroupName, resourceGroupName, managerName, options)
	if err != nil {
		return BackupScheduleGroupsClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return BackupScheduleGroupsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return BackupScheduleGroupsClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *BackupScheduleGroupsClient) getCreateRequest(ctx context.Context, deviceName string, scheduleGroupName string, resourceGroupName string, managerName string, options *BackupScheduleGroupsClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/backupScheduleGroups/{scheduleGroupName}"
	if deviceName == "" {
		return nil, errors.New("parameter deviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", url.PathEscape(deviceName))
	if scheduleGroupName == "" {
		return nil, errors.New("parameter scheduleGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{scheduleGroupName}", url.PathEscape(scheduleGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managerName == "" {
		return nil, errors.New("parameter managerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", url.PathEscape(managerName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *BackupScheduleGroupsClient) getHandleResponse(resp *http.Response) (BackupScheduleGroupsClientGetResponse, error) {
	result := BackupScheduleGroupsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.BackupScheduleGroup); err != nil {
		return BackupScheduleGroupsClientGetResponse{}, err
	}
	return result, nil
}

// NewListByDevicePager - Retrieves all the backup schedule groups in a device.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
// deviceName - The name of the device.
// resourceGroupName - The resource group name
// managerName - The manager name
// options - BackupScheduleGroupsClientListByDeviceOptions contains the optional parameters for the BackupScheduleGroupsClient.ListByDevice
// method.
func (client *BackupScheduleGroupsClient) NewListByDevicePager(deviceName string, resourceGroupName string, managerName string, options *BackupScheduleGroupsClientListByDeviceOptions) *runtime.Pager[BackupScheduleGroupsClientListByDeviceResponse] {
	return runtime.NewPager(runtime.PagingHandler[BackupScheduleGroupsClientListByDeviceResponse]{
		More: func(page BackupScheduleGroupsClientListByDeviceResponse) bool {
			return false
		},
		Fetcher: func(ctx context.Context, page *BackupScheduleGroupsClientListByDeviceResponse) (BackupScheduleGroupsClientListByDeviceResponse, error) {
			req, err := client.listByDeviceCreateRequest(ctx, deviceName, resourceGroupName, managerName, options)
			if err != nil {
				return BackupScheduleGroupsClientListByDeviceResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return BackupScheduleGroupsClientListByDeviceResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return BackupScheduleGroupsClientListByDeviceResponse{}, runtime.NewResponseError(resp)
			}
			return client.listByDeviceHandleResponse(resp)
		},
	})
}

// listByDeviceCreateRequest creates the ListByDevice request.
func (client *BackupScheduleGroupsClient) listByDeviceCreateRequest(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *BackupScheduleGroupsClientListByDeviceOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/backupScheduleGroups"
	if deviceName == "" {
		return nil, errors.New("parameter deviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", url.PathEscape(deviceName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managerName == "" {
		return nil, errors.New("parameter managerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", url.PathEscape(managerName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByDeviceHandleResponse handles the ListByDevice response.
func (client *BackupScheduleGroupsClient) listByDeviceHandleResponse(resp *http.Response) (BackupScheduleGroupsClientListByDeviceResponse, error) {
	result := BackupScheduleGroupsClientListByDeviceResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.BackupScheduleGroupList); err != nil {
		return BackupScheduleGroupsClientListByDeviceResponse{}, err
	}
	return result, nil
}
