//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armtimeseriesinsights

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type AccessPolicyMutableProperties.
func (a AccessPolicyMutableProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", a.Description)
	populate(objectMap, "roles", a.Roles)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type AccessPolicyResourceProperties.
func (a AccessPolicyResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", a.Description)
	populate(objectMap, "principalObjectId", a.PrincipalObjectID)
	populate(objectMap, "roles", a.Roles)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type AccessPolicyUpdateParameters.
func (a AccessPolicyUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", a.Properties)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type AzureEventSourceProperties.
func (a AzureEventSourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "creationTime", a.CreationTime)
	populate(objectMap, "eventSourceResourceId", a.EventSourceResourceID)
	populate(objectMap, "ingressStartAt", a.IngressStartAt)
	populate(objectMap, "localTimestamp", a.LocalTimestamp)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	populate(objectMap, "timestampPropertyName", a.TimestampPropertyName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureEventSourceProperties.
func (a *AzureEventSourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationTime":
			err = unpopulateTimeRFC3339(val, "CreationTime", &a.CreationTime)
			delete(rawMsg, key)
		case "eventSourceResourceId":
			err = unpopulate(val, "EventSourceResourceID", &a.EventSourceResourceID)
			delete(rawMsg, key)
		case "ingressStartAt":
			err = unpopulate(val, "IngressStartAt", &a.IngressStartAt)
			delete(rawMsg, key)
		case "localTimestamp":
			err = unpopulate(val, "LocalTimestamp", &a.LocalTimestamp)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		case "timestampPropertyName":
			err = unpopulate(val, "TimestampPropertyName", &a.TimestampPropertyName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CreateOrUpdateTrackedResourceProperties.
func (c CreateOrUpdateTrackedResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "location", c.Location)
	populate(objectMap, "tags", c.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type EnvironmentCreateOrUpdateParameters.
func (e EnvironmentCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["kind"] = e.Kind
	populate(objectMap, "location", e.Location)
	populate(objectMap, "sku", e.SKU)
	populate(objectMap, "tags", e.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EnvironmentListResponse.
func (e *EnvironmentListResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			e.Value, err = unmarshalEnvironmentResourceClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EnvironmentResourceProperties.
func (e EnvironmentResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "creationTime", e.CreationTime)
	populate(objectMap, "dataAccessFqdn", e.DataAccessFqdn)
	populate(objectMap, "dataAccessId", e.DataAccessID)
	populate(objectMap, "provisioningState", e.ProvisioningState)
	populate(objectMap, "status", e.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EnvironmentResourceProperties.
func (e *EnvironmentResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationTime":
			err = unpopulateTimeRFC3339(val, "CreationTime", &e.CreationTime)
			delete(rawMsg, key)
		case "dataAccessFqdn":
			err = unpopulate(val, "DataAccessFqdn", &e.DataAccessFqdn)
			delete(rawMsg, key)
		case "dataAccessId":
			err = unpopulate(val, "DataAccessID", &e.DataAccessID)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &e.ProvisioningState)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &e.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EnvironmentUpdateParameters.
func (e EnvironmentUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["kind"] = e.Kind
	populate(objectMap, "tags", e.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type EventHubEventSourceCommonProperties.
func (e EventHubEventSourceCommonProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "consumerGroupName", e.ConsumerGroupName)
	populateTimeRFC3339(objectMap, "creationTime", e.CreationTime)
	populate(objectMap, "eventHubName", e.EventHubName)
	populate(objectMap, "eventSourceResourceId", e.EventSourceResourceID)
	populate(objectMap, "ingressStartAt", e.IngressStartAt)
	populate(objectMap, "keyName", e.KeyName)
	populate(objectMap, "localTimestamp", e.LocalTimestamp)
	populate(objectMap, "provisioningState", e.ProvisioningState)
	populate(objectMap, "serviceBusNamespace", e.ServiceBusNamespace)
	populate(objectMap, "timestampPropertyName", e.TimestampPropertyName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventHubEventSourceCommonProperties.
func (e *EventHubEventSourceCommonProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "consumerGroupName":
			err = unpopulate(val, "ConsumerGroupName", &e.ConsumerGroupName)
			delete(rawMsg, key)
		case "creationTime":
			err = unpopulateTimeRFC3339(val, "CreationTime", &e.CreationTime)
			delete(rawMsg, key)
		case "eventHubName":
			err = unpopulate(val, "EventHubName", &e.EventHubName)
			delete(rawMsg, key)
		case "eventSourceResourceId":
			err = unpopulate(val, "EventSourceResourceID", &e.EventSourceResourceID)
			delete(rawMsg, key)
		case "ingressStartAt":
			err = unpopulate(val, "IngressStartAt", &e.IngressStartAt)
			delete(rawMsg, key)
		case "keyName":
			err = unpopulate(val, "KeyName", &e.KeyName)
			delete(rawMsg, key)
		case "localTimestamp":
			err = unpopulate(val, "LocalTimestamp", &e.LocalTimestamp)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &e.ProvisioningState)
			delete(rawMsg, key)
		case "serviceBusNamespace":
			err = unpopulate(val, "ServiceBusNamespace", &e.ServiceBusNamespace)
			delete(rawMsg, key)
		case "timestampPropertyName":
			err = unpopulate(val, "TimestampPropertyName", &e.TimestampPropertyName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventHubEventSourceCreateOrUpdateParameters.
func (e EventHubEventSourceCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["kind"] = EventSourceKindMicrosoftEventHub
	populate(objectMap, "localTimestamp", e.LocalTimestamp)
	populate(objectMap, "location", e.Location)
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "tags", e.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventHubEventSourceCreateOrUpdateParameters.
func (e *EventHubEventSourceCreateOrUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "kind":
			err = unpopulate(val, "Kind", &e.Kind)
			delete(rawMsg, key)
		case "localTimestamp":
			err = unpopulate(val, "LocalTimestamp", &e.LocalTimestamp)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &e.Location)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &e.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventHubEventSourceCreationProperties.
func (e EventHubEventSourceCreationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "consumerGroupName", e.ConsumerGroupName)
	populateTimeRFC3339(objectMap, "creationTime", e.CreationTime)
	populate(objectMap, "eventHubName", e.EventHubName)
	populate(objectMap, "eventSourceResourceId", e.EventSourceResourceID)
	populate(objectMap, "ingressStartAt", e.IngressStartAt)
	populate(objectMap, "keyName", e.KeyName)
	populate(objectMap, "localTimestamp", e.LocalTimestamp)
	populate(objectMap, "provisioningState", e.ProvisioningState)
	populate(objectMap, "serviceBusNamespace", e.ServiceBusNamespace)
	populate(objectMap, "sharedAccessKey", e.SharedAccessKey)
	populate(objectMap, "timestampPropertyName", e.TimestampPropertyName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventHubEventSourceCreationProperties.
func (e *EventHubEventSourceCreationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "consumerGroupName":
			err = unpopulate(val, "ConsumerGroupName", &e.ConsumerGroupName)
			delete(rawMsg, key)
		case "creationTime":
			err = unpopulateTimeRFC3339(val, "CreationTime", &e.CreationTime)
			delete(rawMsg, key)
		case "eventHubName":
			err = unpopulate(val, "EventHubName", &e.EventHubName)
			delete(rawMsg, key)
		case "eventSourceResourceId":
			err = unpopulate(val, "EventSourceResourceID", &e.EventSourceResourceID)
			delete(rawMsg, key)
		case "ingressStartAt":
			err = unpopulate(val, "IngressStartAt", &e.IngressStartAt)
			delete(rawMsg, key)
		case "keyName":
			err = unpopulate(val, "KeyName", &e.KeyName)
			delete(rawMsg, key)
		case "localTimestamp":
			err = unpopulate(val, "LocalTimestamp", &e.LocalTimestamp)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &e.ProvisioningState)
			delete(rawMsg, key)
		case "serviceBusNamespace":
			err = unpopulate(val, "ServiceBusNamespace", &e.ServiceBusNamespace)
			delete(rawMsg, key)
		case "sharedAccessKey":
			err = unpopulate(val, "SharedAccessKey", &e.SharedAccessKey)
			delete(rawMsg, key)
		case "timestampPropertyName":
			err = unpopulate(val, "TimestampPropertyName", &e.TimestampPropertyName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventHubEventSourceResource.
func (e *EventHubEventSourceResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &e.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &e.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &e.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventHubEventSourceResourceProperties.
func (e EventHubEventSourceResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "consumerGroupName", e.ConsumerGroupName)
	populateTimeRFC3339(objectMap, "creationTime", e.CreationTime)
	populate(objectMap, "eventHubName", e.EventHubName)
	populate(objectMap, "eventSourceResourceId", e.EventSourceResourceID)
	populate(objectMap, "ingressStartAt", e.IngressStartAt)
	populate(objectMap, "keyName", e.KeyName)
	populate(objectMap, "localTimestamp", e.LocalTimestamp)
	populate(objectMap, "provisioningState", e.ProvisioningState)
	populate(objectMap, "serviceBusNamespace", e.ServiceBusNamespace)
	populate(objectMap, "timestampPropertyName", e.TimestampPropertyName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventHubEventSourceResourceProperties.
func (e *EventHubEventSourceResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "consumerGroupName":
			err = unpopulate(val, "ConsumerGroupName", &e.ConsumerGroupName)
			delete(rawMsg, key)
		case "creationTime":
			err = unpopulateTimeRFC3339(val, "CreationTime", &e.CreationTime)
			delete(rawMsg, key)
		case "eventHubName":
			err = unpopulate(val, "EventHubName", &e.EventHubName)
			delete(rawMsg, key)
		case "eventSourceResourceId":
			err = unpopulate(val, "EventSourceResourceID", &e.EventSourceResourceID)
			delete(rawMsg, key)
		case "ingressStartAt":
			err = unpopulate(val, "IngressStartAt", &e.IngressStartAt)
			delete(rawMsg, key)
		case "keyName":
			err = unpopulate(val, "KeyName", &e.KeyName)
			delete(rawMsg, key)
		case "localTimestamp":
			err = unpopulate(val, "LocalTimestamp", &e.LocalTimestamp)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &e.ProvisioningState)
			delete(rawMsg, key)
		case "serviceBusNamespace":
			err = unpopulate(val, "ServiceBusNamespace", &e.ServiceBusNamespace)
			delete(rawMsg, key)
		case "timestampPropertyName":
			err = unpopulate(val, "TimestampPropertyName", &e.TimestampPropertyName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventHubEventSourceUpdateParameters.
func (e EventHubEventSourceUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["kind"] = EventSourceKindMicrosoftEventHub
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "tags", e.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventHubEventSourceUpdateParameters.
func (e *EventHubEventSourceUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "kind":
			err = unpopulate(val, "Kind", &e.Kind)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &e.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventSourceCommonProperties.
func (e EventSourceCommonProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "creationTime", e.CreationTime)
	populate(objectMap, "ingressStartAt", e.IngressStartAt)
	populate(objectMap, "localTimestamp", e.LocalTimestamp)
	populate(objectMap, "provisioningState", e.ProvisioningState)
	populate(objectMap, "timestampPropertyName", e.TimestampPropertyName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventSourceCommonProperties.
func (e *EventSourceCommonProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationTime":
			err = unpopulateTimeRFC3339(val, "CreationTime", &e.CreationTime)
			delete(rawMsg, key)
		case "ingressStartAt":
			err = unpopulate(val, "IngressStartAt", &e.IngressStartAt)
			delete(rawMsg, key)
		case "localTimestamp":
			err = unpopulate(val, "LocalTimestamp", &e.LocalTimestamp)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &e.ProvisioningState)
			delete(rawMsg, key)
		case "timestampPropertyName":
			err = unpopulate(val, "TimestampPropertyName", &e.TimestampPropertyName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventSourceCreateOrUpdateParameters.
func (e EventSourceCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["kind"] = e.Kind
	populate(objectMap, "localTimestamp", e.LocalTimestamp)
	populate(objectMap, "location", e.Location)
	populate(objectMap, "tags", e.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventSourceListResponse.
func (e *EventSourceListResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			e.Value, err = unmarshalEventSourceResourceClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventSourceUpdateParameters.
func (e EventSourceUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["kind"] = e.Kind
	populate(objectMap, "tags", e.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type Gen1EnvironmentCreateOrUpdateParameters.
func (g Gen1EnvironmentCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["kind"] = EnvironmentKindGen1
	populate(objectMap, "location", g.Location)
	populate(objectMap, "properties", g.Properties)
	populate(objectMap, "sku", g.SKU)
	populate(objectMap, "tags", g.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Gen1EnvironmentCreateOrUpdateParameters.
func (g *Gen1EnvironmentCreateOrUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "kind":
			err = unpopulate(val, "Kind", &g.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &g.Location)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &g.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &g.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &g.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Gen1EnvironmentCreationProperties.
func (g Gen1EnvironmentCreationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dataRetentionTime", g.DataRetentionTime)
	populate(objectMap, "partitionKeyProperties", g.PartitionKeyProperties)
	populate(objectMap, "storageLimitExceededBehavior", g.StorageLimitExceededBehavior)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Gen1EnvironmentResource.
func (g *Gen1EnvironmentResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &g.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &g.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &g.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &g.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &g.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &g.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &g.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &g.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Gen1EnvironmentResourceProperties.
func (g Gen1EnvironmentResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "creationTime", g.CreationTime)
	populate(objectMap, "dataAccessFqdn", g.DataAccessFqdn)
	populate(objectMap, "dataAccessId", g.DataAccessID)
	populate(objectMap, "dataRetentionTime", g.DataRetentionTime)
	populate(objectMap, "partitionKeyProperties", g.PartitionKeyProperties)
	populate(objectMap, "provisioningState", g.ProvisioningState)
	populate(objectMap, "status", g.Status)
	populate(objectMap, "storageLimitExceededBehavior", g.StorageLimitExceededBehavior)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Gen1EnvironmentResourceProperties.
func (g *Gen1EnvironmentResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationTime":
			err = unpopulateTimeRFC3339(val, "CreationTime", &g.CreationTime)
			delete(rawMsg, key)
		case "dataAccessFqdn":
			err = unpopulate(val, "DataAccessFqdn", &g.DataAccessFqdn)
			delete(rawMsg, key)
		case "dataAccessId":
			err = unpopulate(val, "DataAccessID", &g.DataAccessID)
			delete(rawMsg, key)
		case "dataRetentionTime":
			err = unpopulate(val, "DataRetentionTime", &g.DataRetentionTime)
			delete(rawMsg, key)
		case "partitionKeyProperties":
			err = unpopulate(val, "PartitionKeyProperties", &g.PartitionKeyProperties)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &g.ProvisioningState)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &g.Status)
			delete(rawMsg, key)
		case "storageLimitExceededBehavior":
			err = unpopulate(val, "StorageLimitExceededBehavior", &g.StorageLimitExceededBehavior)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Gen1EnvironmentUpdateParameters.
func (g Gen1EnvironmentUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["kind"] = EnvironmentKindGen1
	populate(objectMap, "properties", g.Properties)
	populate(objectMap, "sku", g.SKU)
	populate(objectMap, "tags", g.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Gen1EnvironmentUpdateParameters.
func (g *Gen1EnvironmentUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "kind":
			err = unpopulate(val, "Kind", &g.Kind)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &g.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &g.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &g.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Gen2EnvironmentCreateOrUpdateParameters.
func (g Gen2EnvironmentCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["kind"] = EnvironmentKindGen2
	populate(objectMap, "location", g.Location)
	populate(objectMap, "properties", g.Properties)
	populate(objectMap, "sku", g.SKU)
	populate(objectMap, "tags", g.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Gen2EnvironmentCreateOrUpdateParameters.
func (g *Gen2EnvironmentCreateOrUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "kind":
			err = unpopulate(val, "Kind", &g.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &g.Location)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &g.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &g.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &g.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Gen2EnvironmentCreationProperties.
func (g Gen2EnvironmentCreationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "storageConfiguration", g.StorageConfiguration)
	populate(objectMap, "timeSeriesIdProperties", g.TimeSeriesIDProperties)
	populate(objectMap, "warmStoreConfiguration", g.WarmStoreConfiguration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Gen2EnvironmentResource.
func (g *Gen2EnvironmentResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &g.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &g.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &g.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &g.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &g.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &g.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &g.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &g.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Gen2EnvironmentResourceProperties.
func (g Gen2EnvironmentResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "creationTime", g.CreationTime)
	populate(objectMap, "dataAccessFqdn", g.DataAccessFqdn)
	populate(objectMap, "dataAccessId", g.DataAccessID)
	populate(objectMap, "provisioningState", g.ProvisioningState)
	populate(objectMap, "status", g.Status)
	populate(objectMap, "storageConfiguration", g.StorageConfiguration)
	populate(objectMap, "timeSeriesIdProperties", g.TimeSeriesIDProperties)
	populate(objectMap, "warmStoreConfiguration", g.WarmStoreConfiguration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Gen2EnvironmentResourceProperties.
func (g *Gen2EnvironmentResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationTime":
			err = unpopulateTimeRFC3339(val, "CreationTime", &g.CreationTime)
			delete(rawMsg, key)
		case "dataAccessFqdn":
			err = unpopulate(val, "DataAccessFqdn", &g.DataAccessFqdn)
			delete(rawMsg, key)
		case "dataAccessId":
			err = unpopulate(val, "DataAccessID", &g.DataAccessID)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &g.ProvisioningState)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &g.Status)
			delete(rawMsg, key)
		case "storageConfiguration":
			err = unpopulate(val, "StorageConfiguration", &g.StorageConfiguration)
			delete(rawMsg, key)
		case "timeSeriesIdProperties":
			err = unpopulate(val, "TimeSeriesIDProperties", &g.TimeSeriesIDProperties)
			delete(rawMsg, key)
		case "warmStoreConfiguration":
			err = unpopulate(val, "WarmStoreConfiguration", &g.WarmStoreConfiguration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Gen2EnvironmentUpdateParameters.
func (g Gen2EnvironmentUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["kind"] = EnvironmentKindGen2
	populate(objectMap, "properties", g.Properties)
	populate(objectMap, "tags", g.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Gen2EnvironmentUpdateParameters.
func (g *Gen2EnvironmentUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "kind":
			err = unpopulate(val, "Kind", &g.Kind)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &g.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &g.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IoTHubEventSourceCommonProperties.
func (i IoTHubEventSourceCommonProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "consumerGroupName", i.ConsumerGroupName)
	populateTimeRFC3339(objectMap, "creationTime", i.CreationTime)
	populate(objectMap, "eventSourceResourceId", i.EventSourceResourceID)
	populate(objectMap, "ingressStartAt", i.IngressStartAt)
	populate(objectMap, "iotHubName", i.IotHubName)
	populate(objectMap, "keyName", i.KeyName)
	populate(objectMap, "localTimestamp", i.LocalTimestamp)
	populate(objectMap, "provisioningState", i.ProvisioningState)
	populate(objectMap, "timestampPropertyName", i.TimestampPropertyName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IoTHubEventSourceCommonProperties.
func (i *IoTHubEventSourceCommonProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "consumerGroupName":
			err = unpopulate(val, "ConsumerGroupName", &i.ConsumerGroupName)
			delete(rawMsg, key)
		case "creationTime":
			err = unpopulateTimeRFC3339(val, "CreationTime", &i.CreationTime)
			delete(rawMsg, key)
		case "eventSourceResourceId":
			err = unpopulate(val, "EventSourceResourceID", &i.EventSourceResourceID)
			delete(rawMsg, key)
		case "ingressStartAt":
			err = unpopulate(val, "IngressStartAt", &i.IngressStartAt)
			delete(rawMsg, key)
		case "iotHubName":
			err = unpopulate(val, "IotHubName", &i.IotHubName)
			delete(rawMsg, key)
		case "keyName":
			err = unpopulate(val, "KeyName", &i.KeyName)
			delete(rawMsg, key)
		case "localTimestamp":
			err = unpopulate(val, "LocalTimestamp", &i.LocalTimestamp)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &i.ProvisioningState)
			delete(rawMsg, key)
		case "timestampPropertyName":
			err = unpopulate(val, "TimestampPropertyName", &i.TimestampPropertyName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IoTHubEventSourceCreateOrUpdateParameters.
func (i IoTHubEventSourceCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["kind"] = EventSourceKindMicrosoftIoTHub
	populate(objectMap, "localTimestamp", i.LocalTimestamp)
	populate(objectMap, "location", i.Location)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "tags", i.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IoTHubEventSourceCreateOrUpdateParameters.
func (i *IoTHubEventSourceCreateOrUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "kind":
			err = unpopulate(val, "Kind", &i.Kind)
			delete(rawMsg, key)
		case "localTimestamp":
			err = unpopulate(val, "LocalTimestamp", &i.LocalTimestamp)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &i.Location)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &i.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IoTHubEventSourceCreationProperties.
func (i IoTHubEventSourceCreationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "consumerGroupName", i.ConsumerGroupName)
	populateTimeRFC3339(objectMap, "creationTime", i.CreationTime)
	populate(objectMap, "eventSourceResourceId", i.EventSourceResourceID)
	populate(objectMap, "ingressStartAt", i.IngressStartAt)
	populate(objectMap, "iotHubName", i.IotHubName)
	populate(objectMap, "keyName", i.KeyName)
	populate(objectMap, "localTimestamp", i.LocalTimestamp)
	populate(objectMap, "provisioningState", i.ProvisioningState)
	populate(objectMap, "sharedAccessKey", i.SharedAccessKey)
	populate(objectMap, "timestampPropertyName", i.TimestampPropertyName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IoTHubEventSourceCreationProperties.
func (i *IoTHubEventSourceCreationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "consumerGroupName":
			err = unpopulate(val, "ConsumerGroupName", &i.ConsumerGroupName)
			delete(rawMsg, key)
		case "creationTime":
			err = unpopulateTimeRFC3339(val, "CreationTime", &i.CreationTime)
			delete(rawMsg, key)
		case "eventSourceResourceId":
			err = unpopulate(val, "EventSourceResourceID", &i.EventSourceResourceID)
			delete(rawMsg, key)
		case "ingressStartAt":
			err = unpopulate(val, "IngressStartAt", &i.IngressStartAt)
			delete(rawMsg, key)
		case "iotHubName":
			err = unpopulate(val, "IotHubName", &i.IotHubName)
			delete(rawMsg, key)
		case "keyName":
			err = unpopulate(val, "KeyName", &i.KeyName)
			delete(rawMsg, key)
		case "localTimestamp":
			err = unpopulate(val, "LocalTimestamp", &i.LocalTimestamp)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &i.ProvisioningState)
			delete(rawMsg, key)
		case "sharedAccessKey":
			err = unpopulate(val, "SharedAccessKey", &i.SharedAccessKey)
			delete(rawMsg, key)
		case "timestampPropertyName":
			err = unpopulate(val, "TimestampPropertyName", &i.TimestampPropertyName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IoTHubEventSourceResource.
func (i *IoTHubEventSourceResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &i.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &i.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &i.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IoTHubEventSourceResourceProperties.
func (i IoTHubEventSourceResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "consumerGroupName", i.ConsumerGroupName)
	populateTimeRFC3339(objectMap, "creationTime", i.CreationTime)
	populate(objectMap, "eventSourceResourceId", i.EventSourceResourceID)
	populate(objectMap, "ingressStartAt", i.IngressStartAt)
	populate(objectMap, "iotHubName", i.IotHubName)
	populate(objectMap, "keyName", i.KeyName)
	populate(objectMap, "localTimestamp", i.LocalTimestamp)
	populate(objectMap, "provisioningState", i.ProvisioningState)
	populate(objectMap, "timestampPropertyName", i.TimestampPropertyName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IoTHubEventSourceResourceProperties.
func (i *IoTHubEventSourceResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "consumerGroupName":
			err = unpopulate(val, "ConsumerGroupName", &i.ConsumerGroupName)
			delete(rawMsg, key)
		case "creationTime":
			err = unpopulateTimeRFC3339(val, "CreationTime", &i.CreationTime)
			delete(rawMsg, key)
		case "eventSourceResourceId":
			err = unpopulate(val, "EventSourceResourceID", &i.EventSourceResourceID)
			delete(rawMsg, key)
		case "ingressStartAt":
			err = unpopulate(val, "IngressStartAt", &i.IngressStartAt)
			delete(rawMsg, key)
		case "iotHubName":
			err = unpopulate(val, "IotHubName", &i.IotHubName)
			delete(rawMsg, key)
		case "keyName":
			err = unpopulate(val, "KeyName", &i.KeyName)
			delete(rawMsg, key)
		case "localTimestamp":
			err = unpopulate(val, "LocalTimestamp", &i.LocalTimestamp)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &i.ProvisioningState)
			delete(rawMsg, key)
		case "timestampPropertyName":
			err = unpopulate(val, "TimestampPropertyName", &i.TimestampPropertyName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IoTHubEventSourceUpdateParameters.
func (i IoTHubEventSourceUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["kind"] = EventSourceKindMicrosoftIoTHub
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "tags", i.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IoTHubEventSourceUpdateParameters.
func (i *IoTHubEventSourceUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "kind":
			err = unpopulate(val, "Kind", &i.Kind)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &i.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReferenceDataSetCreateOrUpdateParameters.
func (r ReferenceDataSetCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "location", r.Location)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "tags", r.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ReferenceDataSetCreationProperties.
func (r ReferenceDataSetCreationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dataStringComparisonBehavior", r.DataStringComparisonBehavior)
	populate(objectMap, "keyProperties", r.KeyProperties)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ReferenceDataSetResourceProperties.
func (r ReferenceDataSetResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "creationTime", r.CreationTime)
	populate(objectMap, "dataStringComparisonBehavior", r.DataStringComparisonBehavior)
	populate(objectMap, "keyProperties", r.KeyProperties)
	populate(objectMap, "provisioningState", r.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReferenceDataSetResourceProperties.
func (r *ReferenceDataSetResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationTime":
			err = unpopulateTimeRFC3339(val, "CreationTime", &r.CreationTime)
			delete(rawMsg, key)
		case "dataStringComparisonBehavior":
			err = unpopulate(val, "DataStringComparisonBehavior", &r.DataStringComparisonBehavior)
			delete(rawMsg, key)
		case "keyProperties":
			err = unpopulate(val, "KeyProperties", &r.KeyProperties)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &r.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReferenceDataSetUpdateParameters.
func (r ReferenceDataSetUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "tags", r.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ResourceProperties.
func (r ResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "creationTime", r.CreationTime)
	populate(objectMap, "provisioningState", r.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceProperties.
func (r *ResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationTime":
			err = unpopulateTimeRFC3339(val, "CreationTime", &r.CreationTime)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &r.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

func populate(m map[string]interface{}, k string, v interface{}) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v interface{}) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
