//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armvisualstudio

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// ProjectsClient contains the methods for the Projects group.
// Don't use this type directly, use NewProjectsClient() instead.
type ProjectsClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewProjectsClient creates a new instance of ProjectsClient with the specified values.
// subscriptionID - The Azure subscription identifier.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewProjectsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ProjectsClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &ProjectsClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// BeginCreate - Creates a Team Services project in the collection with the specified name. 'VersionControlOption' and 'ProcessTemplateId'
// must be specified in the resource properties. Valid values for
// VersionControlOption: Git, Tfvc. Valid values for ProcessTemplateId: 6B724908-EF14-45CF-84F8-768B5384DA45, ADCC42AB-9882-485E-A3ED-7678F01F66BC,
// 27450541-8E31-4150-9947-DC59F998FC01 (these IDs
// correspond to Scrum, Agile, and CMMI process templates).
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2014-04-01-preview
// resourceGroupName - Name of the resource group within the Azure subscription.
// rootResourceName - Name of the Team Services account.
// resourceName - Name of the Team Services project.
// body - The request data.
// options - ProjectsClientBeginCreateOptions contains the optional parameters for the ProjectsClient.BeginCreate method.
func (client *ProjectsClient) BeginCreate(ctx context.Context, resourceGroupName string, rootResourceName string, resourceName string, body ProjectResource, options *ProjectsClientBeginCreateOptions) (*runtime.Poller[ProjectsClientCreateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.create(ctx, resourceGroupName, rootResourceName, resourceName, body, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[ProjectsClientCreateResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[ProjectsClientCreateResponse](options.ResumeToken, client.pl, nil)
	}
}

// Create - Creates a Team Services project in the collection with the specified name. 'VersionControlOption' and 'ProcessTemplateId'
// must be specified in the resource properties. Valid values for
// VersionControlOption: Git, Tfvc. Valid values for ProcessTemplateId: 6B724908-EF14-45CF-84F8-768B5384DA45, ADCC42AB-9882-485E-A3ED-7678F01F66BC,
// 27450541-8E31-4150-9947-DC59F998FC01 (these IDs
// correspond to Scrum, Agile, and CMMI process templates).
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2014-04-01-preview
func (client *ProjectsClient) create(ctx context.Context, resourceGroupName string, rootResourceName string, resourceName string, body ProjectResource, options *ProjectsClientBeginCreateOptions) (*http.Response, error) {
	req, err := client.createCreateRequest(ctx, resourceGroupName, rootResourceName, resourceName, body, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// createCreateRequest creates the Create request.
func (client *ProjectsClient) createCreateRequest(ctx context.Context, resourceGroupName string, rootResourceName string, resourceName string, body ProjectResource, options *ProjectsClientBeginCreateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.visualstudio/account/{rootResourceName}/project/{resourceName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if rootResourceName == "" {
		return nil, errors.New("parameter rootResourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{rootResourceName}", url.PathEscape(rootResourceName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2014-04-01-preview")
	if options != nil && options.Validating != nil {
		reqQP.Set("validating", *options.Validating)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, body)
}

// Get - Gets the details of a Team Services project resource.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2014-04-01-preview
// resourceGroupName - Name of the resource group within the Azure subscription.
// rootResourceName - Name of the Team Services account.
// resourceName - Name of the Team Services project.
// options - ProjectsClientGetOptions contains the optional parameters for the ProjectsClient.Get method.
func (client *ProjectsClient) Get(ctx context.Context, resourceGroupName string, rootResourceName string, resourceName string, options *ProjectsClientGetOptions) (ProjectsClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, resourceGroupName, rootResourceName, resourceName, options)
	if err != nil {
		return ProjectsClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ProjectsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusNotFound) {
		return ProjectsClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *ProjectsClient) getCreateRequest(ctx context.Context, resourceGroupName string, rootResourceName string, resourceName string, options *ProjectsClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.visualstudio/account/{rootResourceName}/project/{resourceName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if rootResourceName == "" {
		return nil, errors.New("parameter rootResourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{rootResourceName}", url.PathEscape(rootResourceName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2014-04-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *ProjectsClient) getHandleResponse(resp *http.Response) (ProjectsClientGetResponse, error) {
	result := ProjectsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ProjectResource); err != nil {
		return ProjectsClientGetResponse{}, err
	}
	return result, nil
}

// GetJobStatus - Gets the status of the project resource creation job.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2014-04-01-preview
// resourceGroupName - Name of the resource group within the Azure subscription.
// rootResourceName - Name of the Team Services account.
// resourceName - Name of the Team Services project.
// subContainerName - This parameter should be set to the resourceName.
// operation - The operation type. The only supported value is 'put'.
// options - ProjectsClientGetJobStatusOptions contains the optional parameters for the ProjectsClient.GetJobStatus method.
func (client *ProjectsClient) GetJobStatus(ctx context.Context, resourceGroupName string, rootResourceName string, resourceName string, subContainerName string, operation string, options *ProjectsClientGetJobStatusOptions) (ProjectsClientGetJobStatusResponse, error) {
	req, err := client.getJobStatusCreateRequest(ctx, resourceGroupName, rootResourceName, resourceName, subContainerName, operation, options)
	if err != nil {
		return ProjectsClientGetJobStatusResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ProjectsClientGetJobStatusResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return ProjectsClientGetJobStatusResponse{}, runtime.NewResponseError(resp)
	}
	return client.getJobStatusHandleResponse(resp)
}

// getJobStatusCreateRequest creates the GetJobStatus request.
func (client *ProjectsClient) getJobStatusCreateRequest(ctx context.Context, resourceGroupName string, rootResourceName string, resourceName string, subContainerName string, operation string, options *ProjectsClientGetJobStatusOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.visualstudio/account/{rootResourceName}/project/{resourceName}/subContainers/{subContainerName}/status"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if rootResourceName == "" {
		return nil, errors.New("parameter rootResourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{rootResourceName}", url.PathEscape(rootResourceName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	if subContainerName == "" {
		return nil, errors.New("parameter subContainerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subContainerName}", url.PathEscape(subContainerName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2014-04-01-preview")
	reqQP.Set("operation", operation)
	if options != nil && options.JobID != nil {
		reqQP.Set("jobId", *options.JobID)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getJobStatusHandleResponse handles the GetJobStatus response.
func (client *ProjectsClient) getJobStatusHandleResponse(resp *http.Response) (ProjectsClientGetJobStatusResponse, error) {
	result := ProjectsClientGetJobStatusResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ProjectResource); err != nil {
		return ProjectsClientGetJobStatusResponse{}, err
	}
	return result, nil
}

// ListByResourceGroup - Gets all Visual Studio Team Services project resources created in the specified Team Services account.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2014-04-01-preview
// resourceGroupName - Name of the resource group within the Azure subscription.
// rootResourceName - Name of the Team Services account.
// options - ProjectsClientListByResourceGroupOptions contains the optional parameters for the ProjectsClient.ListByResourceGroup
// method.
func (client *ProjectsClient) ListByResourceGroup(ctx context.Context, resourceGroupName string, rootResourceName string, options *ProjectsClientListByResourceGroupOptions) (ProjectsClientListByResourceGroupResponse, error) {
	req, err := client.listByResourceGroupCreateRequest(ctx, resourceGroupName, rootResourceName, options)
	if err != nil {
		return ProjectsClientListByResourceGroupResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ProjectsClientListByResourceGroupResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ProjectsClientListByResourceGroupResponse{}, runtime.NewResponseError(resp)
	}
	return client.listByResourceGroupHandleResponse(resp)
}

// listByResourceGroupCreateRequest creates the ListByResourceGroup request.
func (client *ProjectsClient) listByResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, rootResourceName string, options *ProjectsClientListByResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.visualstudio/account/{rootResourceName}/project"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if rootResourceName == "" {
		return nil, errors.New("parameter rootResourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{rootResourceName}", url.PathEscape(rootResourceName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2014-04-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByResourceGroupHandleResponse handles the ListByResourceGroup response.
func (client *ProjectsClient) listByResourceGroupHandleResponse(resp *http.Response) (ProjectsClientListByResourceGroupResponse, error) {
	result := ProjectsClientListByResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ProjectResourceListResult); err != nil {
		return ProjectsClientListByResourceGroupResponse{}, err
	}
	return result, nil
}

// Update - Updates the tags of the specified Team Services project.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2014-04-01-preview
// resourceGroupName - Name of the resource group within the Azure subscription.
// rootResourceName - Name of the Team Services account.
// resourceName - Name of the Team Services project.
// body - The request data.
// options - ProjectsClientUpdateOptions contains the optional parameters for the ProjectsClient.Update method.
func (client *ProjectsClient) Update(ctx context.Context, resourceGroupName string, rootResourceName string, resourceName string, body ProjectResource, options *ProjectsClientUpdateOptions) (ProjectsClientUpdateResponse, error) {
	req, err := client.updateCreateRequest(ctx, resourceGroupName, rootResourceName, resourceName, body, options)
	if err != nil {
		return ProjectsClientUpdateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ProjectsClientUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ProjectsClientUpdateResponse{}, runtime.NewResponseError(resp)
	}
	return client.updateHandleResponse(resp)
}

// updateCreateRequest creates the Update request.
func (client *ProjectsClient) updateCreateRequest(ctx context.Context, resourceGroupName string, rootResourceName string, resourceName string, body ProjectResource, options *ProjectsClientUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.visualstudio/account/{rootResourceName}/project/{resourceName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if rootResourceName == "" {
		return nil, errors.New("parameter rootResourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{rootResourceName}", url.PathEscape(rootResourceName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2014-04-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, body)
}

// updateHandleResponse handles the Update response.
func (client *ProjectsClient) updateHandleResponse(resp *http.Response) (ProjectsClientUpdateResponse, error) {
	result := ProjectsClientUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ProjectResource); err != nil {
		return ProjectsClientUpdateResponse{}, err
	}
	return result, nil
}
