// Code generated by smithy-go-codegen DO NOT EDIT.

package alexaforbusiness

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/alexaforbusiness/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Determines the details for the room from which a skill request was invoked. This
// operation is used by skill developers. To query ResolveRoom from an Alexa skill,
// the skill ID needs to be authorized. When the skill is using an AWS Lambda
// function, the skill is automatically authorized when you publish your skill as a
// private skill to your AWS account. Skills that are hosted using a custom web
// service must be manually authorized. To get your skill authorized, contact AWS
// Support with your AWS account ID that queries the ResolveRoom API and skill ID.
func (c *Client) ResolveRoom(ctx context.Context, params *ResolveRoomInput, optFns ...func(*Options)) (*ResolveRoomOutput, error) {
	if params == nil {
		params = &ResolveRoomInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ResolveRoom", params, optFns, c.addOperationResolveRoomMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ResolveRoomOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ResolveRoomInput struct {

	// The ARN of the skill that was requested. Required.
	//
	// This member is required.
	SkillId *string

	// The ARN of the user. Required.
	//
	// This member is required.
	UserId *string

	noSmithyDocumentSerde
}

type ResolveRoomOutput struct {

	// The ARN of the room from which the skill request was invoked.
	RoomArn *string

	// The name of the room from which the skill request was invoked.
	RoomName *string

	// Response to get the room profile request. Required.
	RoomSkillParameters []types.RoomSkillParameter

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationResolveRoomMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpResolveRoom{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpResolveRoom{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpResolveRoomValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opResolveRoom(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opResolveRoom(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "a4b",
		OperationName: "ResolveRoom",
	}
}
