// Code generated by smithy-go-codegen DO NOT EDIT.

package databasemigrationservice

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Migrates 10 active and enabled Amazon SNS subscriptions at a time and converts
// them to corresponding Amazon EventBridge rules. By default, this operation
// migrates subscriptions only when all your replication instance versions are
// 3.4.6 or higher. If any replication instances are from versions earlier than
// 3.4.6, the operation raises an error and tells you to upgrade these instances to
// version 3.4.6 or higher. To enable migration regardless of version, set the
// Force option to true. However, if you don't upgrade instances earlier than
// version 3.4.6, some types of events might not be available when you use Amazon
// EventBridge. To call this operation, make sure that you have certain permissions
// added to your user account. For more information, see Migrating event
// subscriptions to Amazon EventBridge
// (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html#CHAP_Events-migrate-to-eventbridge)
// in the Amazon Web Services Database Migration Service User Guide.
func (c *Client) UpdateSubscriptionsToEventBridge(ctx context.Context, params *UpdateSubscriptionsToEventBridgeInput, optFns ...func(*Options)) (*UpdateSubscriptionsToEventBridgeOutput, error) {
	if params == nil {
		params = &UpdateSubscriptionsToEventBridgeInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateSubscriptionsToEventBridge", params, optFns, c.addOperationUpdateSubscriptionsToEventBridgeMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateSubscriptionsToEventBridgeOutput)
	out.ResultMetadata = metadata
	return out, nil
}

//
type UpdateSubscriptionsToEventBridgeInput struct {

	// When set to true, this operation migrates DMS subscriptions for Amazon SNS
	// notifications no matter what your replication instance version is. If not set or
	// set to false, this operation runs only when all your replication instances are
	// from DMS version 3.4.6 or higher.
	ForceMove *bool

	noSmithyDocumentSerde
}

//
type UpdateSubscriptionsToEventBridgeOutput struct {

	// A string that indicates how many event subscriptions were migrated and how many
	// remain to be migrated.
	Result *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateSubscriptionsToEventBridgeMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpUpdateSubscriptionsToEventBridge{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpUpdateSubscriptionsToEventBridge{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateSubscriptionsToEventBridge(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateSubscriptionsToEventBridge(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "dms",
		OperationName: "UpdateSubscriptionsToEventBridge",
	}
}
