// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// The Microsoft Active Directory attributes of the Amazon FSx for Windows File
// Server file system.
type ActiveDirectoryBackupAttributes struct {

	// The ID of the Amazon Web Services Managed Microsoft Active Directory instance to
	// which the file system is joined.
	ActiveDirectoryId *string

	// The fully qualified domain name of the self-managed Active Directory directory.
	DomainName *string

	// The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify
	// Amazon Web Services resources. We require an ARN when you need to specify a
	// resource unambiguously across all of Amazon Web Services. For more information,
	// see Amazon Resource Names (ARNs)
	// (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in
	// the Amazon Web Services General Reference.
	ResourceARN *string

	noSmithyDocumentSerde
}

// Describes a specific Amazon FSx administrative action for the current Windows,
// Lustre, or OpenZFS file system.
type AdministrativeAction struct {

	// Describes the type of administrative action, as follows:
	//
	// * FILE_SYSTEM_UPDATE -
	// A file system update administrative action initiated from the Amazon FSx
	// console, API (UpdateFileSystem), or CLI (update-file-system).
	//
	// *
	// STORAGE_OPTIMIZATION - After the FILE_SYSTEM_UPDATE task to increase a file
	// system's storage capacity has been completed successfully, a
	// STORAGE_OPTIMIZATION task starts.
	//
	// * For Windows and ONTAP, storage optimization
	// is the process of migrating the file system data to newer larger disks.
	//
	// * For
	// Lustre, storage optimization consists of rebalancing the data across the
	// existing and newly added file servers.
	//
	// You can track the storage-optimization
	// progress using the ProgressPercent property. When STORAGE_OPTIMIZATION has been
	// completed successfully, the parent FILE_SYSTEM_UPDATE action status changes to
	// COMPLETED. For more information, see Managing storage capacity
	// (https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-storage-capacity.html)
	// in the Amazon FSx for Windows File Server User Guide, Managing storage and
	// throughput capacity
	// (https://docs.aws.amazon.com/fsx/latest/LustreGuide/managing-storage-capacity.html)
	// in the Amazon FSx for Lustre User Guide, and Managing storage capacity and
	// provisioned IOPS
	// (https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-storage-capacity.html)
	// in the Amazon FSx for NetApp ONTAP User Guide.
	//
	// * FILE_SYSTEM_ALIAS_ASSOCIATION
	// - A file system update to associate a new Domain Name System (DNS) alias with
	// the file system. For more information, see  AssociateFileSystemAliases
	// (https://docs.aws.amazon.com/fsx/latest/APIReference/API_AssociateFileSystemAliases.html).
	//
	// *
	// FILE_SYSTEM_ALIAS_DISASSOCIATION - A file system update to disassociate a DNS
	// alias from the file system. For more information, see
	// DisassociateFileSystemAliases
	// (https://docs.aws.amazon.com/fsx/latest/APIReference/API_DisassociateFileSystemAliases.html).
	//
	// *
	// VOLUME_UPDATE - A volume update to an Amazon FSx for NetApp ONTAP or Amazon FSx
	// for OpenZFS volume initiated from the Amazon FSx console, API (UpdateVolume), or
	// CLI (update-volume).
	//
	// * SNAPSHOT_UPDATE - A snapshot update to an Amazon FSx for
	// OpenZFS volume initiated from the Amazon FSx console, API (UpdateSnapshot), or
	// CLI (update-snapshot).
	//
	// * RELEASE_NFS_V3_LOCKS - Tracks the release of Network
	// File System (NFS) V3 locks on an Amazon FSx for OpenZFS file system.
	AdministrativeActionType AdministrativeActionType

	// Provides information about a failed administrative action.
	FailureDetails *AdministrativeActionFailureDetails

	// The percentage-complete status of a STORAGE_OPTIMIZATION administrative action.
	// Does not apply to any other administrative action type.
	ProgressPercent *int32

	// The time that the administrative action request was received.
	RequestTime *time.Time

	// Describes the status of the administrative action, as follows:
	//
	// * FAILED -
	// Amazon FSx failed to process the administrative action successfully.
	//
	// *
	// IN_PROGRESS - Amazon FSx is processing the administrative action.
	//
	// * PENDING -
	// Amazon FSx is waiting to process the administrative action.
	//
	// * COMPLETED -
	// Amazon FSx has finished processing the administrative task.
	//
	// *
	// UPDATED_OPTIMIZING - For a storage-capacity increase update, Amazon FSx has
	// updated the file system with the new storage capacity, and is now performing the
	// storage-optimization process.
	Status Status

	// Describes the target value for the administration action, provided in the
	// UpdateFileSystem operation. Returned for FILE_SYSTEM_UPDATE administrative
	// actions.
	TargetFileSystemValues *FileSystem

	// A snapshot of an Amazon FSx for OpenZFS volume.
	TargetSnapshotValues *Snapshot

	// Describes an Amazon FSx for NetApp ONTAP or Amazon FSx for OpenZFS volume.
	TargetVolumeValues *Volume

	noSmithyDocumentSerde
}

// Provides information about a failed administrative action.
type AdministrativeActionFailureDetails struct {

	// Error message providing details about the failed administrative action.
	Message *string

	noSmithyDocumentSerde
}

// A DNS alias that is associated with the file system. You can use a DNS alias to
// access a file system using user-defined DNS names, in addition to the default
// DNS name that Amazon FSx assigns to the file system. For more information, see
// DNS aliases
// (https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html)
// in the FSx for Windows File Server User Guide.
type Alias struct {

	// Describes the state of the DNS alias.
	//
	// * AVAILABLE - The DNS alias is associated
	// with an Amazon FSx file system.
	//
	// * CREATING - Amazon FSx is creating the DNS
	// alias and associating it with the file system.
	//
	// * CREATE_FAILED - Amazon FSx was
	// unable to associate the DNS alias with the file system.
	//
	// * DELETING - Amazon FSx
	// is disassociating the DNS alias from the file system and deleting it.
	//
	// *
	// DELETE_FAILED - Amazon FSx was unable to disassociate the DNS alias from the
	// file system.
	Lifecycle AliasLifecycle

	// The name of the DNS alias. The alias name has to meet the following
	// requirements:
	//
	// * Formatted as a fully-qualified domain name (FQDN),
	// hostname.domain, for example, accounting.example.com.
	//
	// * Can contain
	// alphanumeric characters, the underscore (_), and the hyphen (-).
	//
	// * Cannot start
	// or end with a hyphen.
	//
	// * Can start with a numeric.
	//
	// For DNS names, Amazon FSx
	// stores alphabetic characters as lowercase letters (a-z), regardless of how you
	// specify them: as uppercase letters, lowercase letters, or the corresponding
	// letters in escape codes.
	Name *string

	noSmithyDocumentSerde
}

// Describes a data repository association's automatic export policy. The
// AutoExportPolicy defines the types of updated objects on the file system that
// will be automatically exported to the data repository. As you create, modify, or
// delete files, Amazon FSx automatically exports the defined changes
// asynchronously once your application finishes modifying the file. This
// AutoExportPolicy is supported only for file systems with the Persistent_2
// deployment type.
type AutoExportPolicy struct {

	// The AutoExportPolicy can have the following event values:
	//
	// * NEW - Amazon FSx
	// automatically exports new files and directories to the data repository as they
	// are added to the file system.
	//
	// * CHANGED - Amazon FSx automatically exports
	// changes to files and directories on the file system to the data repository.
	//
	// *
	// DELETED - Files and directories are automatically deleted on the data repository
	// when they are deleted on the file system.
	//
	// You can define any combination of
	// event types for your AutoExportPolicy.
	Events []EventType

	noSmithyDocumentSerde
}

// Describes the data repository association's automatic import policy. The
// AutoImportPolicy defines how Amazon FSx keeps your file metadata and directory
// listings up to date by importing changes to your file system as you modify
// objects in a linked S3 bucket. This AutoImportPolicy is supported only for file
// systems with the Persistent_2 deployment type.
type AutoImportPolicy struct {

	// The AutoImportPolicy can have the following event values:
	//
	// * NEW - Amazon FSx
	// automatically imports metadata of files added to the linked S3 bucket that do
	// not currently exist in the FSx file system.
	//
	// * CHANGED - Amazon FSx
	// automatically updates file metadata and invalidates existing file content on the
	// file system as files change in the data repository.
	//
	// * DELETED - Amazon FSx
	// automatically deletes files on the file system as corresponding files are
	// deleted in the data repository.
	//
	// You can define any combination of event types
	// for your AutoImportPolicy.
	Events []EventType

	noSmithyDocumentSerde
}

// A backup of an Amazon FSx for Windows File Server, Amazon FSx for Lustre file
// system, Amazon FSx for NetApp ONTAP volume, or Amazon FSx for OpenZFS file
// system.
type Backup struct {

	// The ID of the backup.
	//
	// This member is required.
	BackupId *string

	// The time when a particular backup was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The metadata of the file system associated with the backup. This metadata is
	// persisted even if the file system is deleted.
	//
	// This member is required.
	FileSystem *FileSystem

	// The lifecycle status of the backup.
	//
	// * AVAILABLE - The backup is fully
	// available.
	//
	// * PENDING - For user-initiated backups on Lustre file systems only;
	// Amazon FSx hasn't started creating the backup.
	//
	// * CREATING - Amazon FSx is
	// creating the backup.
	//
	// * TRANSFERRING - For user-initiated backups on Lustre file
	// systems only; Amazon FSx is transferring the backup to Amazon S3.
	//
	// * COPYING -
	// Amazon FSx is copying the backup.
	//
	// * DELETED - Amazon FSx deleted the backup and
	// it's no longer available.
	//
	// * FAILED - Amazon FSx couldn't finish the backup.
	//
	// This member is required.
	Lifecycle BackupLifecycle

	// The type of the file-system backup.
	//
	// This member is required.
	Type BackupType

	// The configuration of the self-managed Microsoft Active Directory directory to
	// which the Windows File Server instance is joined.
	DirectoryInformation *ActiveDirectoryBackupAttributes

	// Details explaining any failures that occurred when creating a backup.
	FailureDetails *BackupFailureDetails

	// The ID of the Key Management Service (KMS) key used to encrypt the backup of the
	// Amazon FSx file system's data at rest.
	KmsKeyId *string

	// An Amazon Web Services account ID. This ID is a 12-digit number that you use to
	// construct Amazon Resource Names (ARNs) for resources.
	OwnerId *string

	// The current percent of progress of an asynchronous task.
	ProgressPercent *int32

	// The Amazon Resource Name (ARN) for the backup resource.
	ResourceARN *string

	// Specifies the resource type that's backed up.
	ResourceType ResourceType

	// The ID of the source backup. Specifies the backup that you are copying.
	SourceBackupId *string

	// The source Region of the backup. Specifies the Region from where this backup is
	// copied.
	SourceBackupRegion *string

	// The tags associated with a particular file system.
	Tags []Tag

	// Describes an Amazon FSx for NetApp ONTAP or Amazon FSx for OpenZFS volume.
	Volume *Volume

	noSmithyDocumentSerde
}

// If backup creation fails, this structure contains the details of that failure.
type BackupFailureDetails struct {

	// A message describing the backup-creation failure.
	Message *string

	noSmithyDocumentSerde
}

// Provides a report detailing the data repository task results of the files
// processed that match the criteria specified in the report Scope parameter. FSx
// delivers the report to the file system's linked data repository in Amazon S3,
// using the path specified in the report Path parameter. You can specify whether
// or not a report gets generated for a task using the Enabled parameter.
type CompletionReport struct {

	// Set Enabled to True to generate a CompletionReport when the task completes. If
	// set to true, then you need to provide a report Scope, Path, and Format. Set
	// Enabled to False if you do not want a CompletionReport generated when the task
	// completes.
	//
	// This member is required.
	Enabled *bool

	// Required if Enabled is set to true. Specifies the format of the
	// CompletionReport. REPORT_CSV_20191124 is the only format currently supported.
	// When Format is set to REPORT_CSV_20191124, the CompletionReport is provided in
	// CSV format, and is delivered to {path}/task-{id}/failures.csv.
	Format ReportFormat

	// Required if Enabled is set to true. Specifies the location of the report on the
	// file system's linked S3 data repository. An absolute path that defines where the
	// completion report will be stored in the destination location. The Path you
	// provide must be located within the file system’s ExportPath. An example Path
	// value is "s3://myBucket/myExportPath/optionalPrefix". The report provides the
	// following information for each file in the report: FilePath, FileStatus, and
	// ErrorCode. To learn more about a file system's ExportPath, see .
	Path *string

	// Required if Enabled is set to true. Specifies the scope of the CompletionReport;
	// FAILED_FILES_ONLY is the only scope currently supported. When Scope is set to
	// FAILED_FILES_ONLY, the CompletionReport only contains information about files
	// that the data repository task failed to process.
	Scope ReportScope

	noSmithyDocumentSerde
}

// The Lustre configuration for the file system being created. The following
// parameters are not supported for file systems with the Persistent_2 deployment
// type. Instead, use CreateDataRepositoryAssociation to create a data repository
// association to link your Lustre file system to a data repository.
//
// *
// AutoImportPolicy
//
// * ExportPath
//
// * ImportedChunkSize
//
// * ImportPath
type CreateFileSystemLustreConfiguration struct {

	// (Optional) Available with Scratch and Persistent_1 deployment types. When you
	// create your file system, your existing S3 objects appear as file and directory
	// listings. Use this property to choose how Amazon FSx keeps your file and
	// directory listings up to date as you add or modify objects in your linked S3
	// bucket. AutoImportPolicy can have the following values:
	//
	// * NONE - (Default)
	// AutoImport is off. Amazon FSx only updates file and directory listings from the
	// linked S3 bucket when the file system is created. FSx does not update file and
	// directory listings for any new or changed objects after choosing this option.
	//
	// *
	// NEW - AutoImport is on. Amazon FSx automatically imports directory listings of
	// any new objects added to the linked S3 bucket that do not currently exist in the
	// FSx file system.
	//
	// * NEW_CHANGED - AutoImport is on. Amazon FSx automatically
	// imports file and directory listings of any new objects added to the S3 bucket
	// and any existing objects that are changed in the S3 bucket after you choose this
	// option.
	//
	// * NEW_CHANGED_DELETED - AutoImport is on. Amazon FSx automatically
	// imports file and directory listings of any new objects added to the S3 bucket,
	// any existing objects that are changed in the S3 bucket, and any objects that
	// were deleted in the S3 bucket.
	//
	// For more information, see  Automatically import
	// updates from your S3 bucket
	// (https://docs.aws.amazon.com/fsx/latest/LustreGuide/older-deployment-types.html#legacy-auto-import-from-s3).
	// This parameter is not supported for file systems with the Persistent_2
	// deployment type. Instead, use CreateDataRepositoryAssociation to create a data
	// repository association to link your Lustre file system to a data repository.
	AutoImportPolicy AutoImportPolicyType

	// The number of days to retain automatic backups. Setting this property to 0
	// disables automatic backups. You can retain automatic backups for a maximum of 90
	// days. The default is 0.
	AutomaticBackupRetentionDays *int32

	// (Optional) Not available for use with file systems that are linked to a data
	// repository. A boolean flag indicating whether tags for the file system should be
	// copied to backups. The default value is false. If CopyTagsToBackups is set to
	// true, all file system tags are copied to all automatic and user-initiated
	// backups when the user doesn't specify any backup-specific tags. If
	// CopyTagsToBackups is set to true and you specify one or more backup tags, only
	// the specified tags are copied to backups. If you specify one or more tags when
	// creating a user-initiated backup, no tags are copied from the file system,
	// regardless of this value. (Default = false) For more information, see  Working
	// with backups
	// (https://docs.aws.amazon.com/fsx/latest/LustreGuide/using-backups-fsx.html) in
	// the Amazon FSx for Lustre User Guide.
	CopyTagsToBackups *bool

	// A recurring daily time, in the format HH:MM. HH is the zero-padded hour of the
	// day (0-23), and MM is the zero-padded minute of the hour. For example, 05:00
	// specifies 5 AM daily.
	DailyAutomaticBackupStartTime *string

	// Sets the data compression configuration for the file system. DataCompressionType
	// can have the following values:
	//
	// * NONE - (Default) Data compression is turned
	// off when the file system is created.
	//
	// * LZ4 - Data compression is turned on with
	// the LZ4 algorithm.
	//
	// For more information, see Lustre data compression
	// (https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-compression.html) in
	// the Amazon FSx for Lustre User Guide.
	DataCompressionType DataCompressionType

	// (Optional) Choose SCRATCH_1 and SCRATCH_2 deployment types when you need
	// temporary storage and shorter-term processing of data. The SCRATCH_2 deployment
	// type provides in-transit encryption of data and higher burst throughput capacity
	// than SCRATCH_1. Choose PERSISTENT_1 for longer-term storage and for
	// throughput-focused workloads that aren’t latency-sensitive. PERSISTENT_1
	// supports encryption of data in transit, and is available in all Amazon Web
	// Services Regions in which FSx for Lustre is available. Choose PERSISTENT_2 for
	// longer-term storage and for latency-sensitive workloads that require the highest
	// levels of IOPS/throughput. PERSISTENT_2 supports SSD storage, and offers higher
	// PerUnitStorageThroughput (up to 1000 MB/s/TiB). PERSISTENT_2 is available in a
	// limited number of Amazon Web Services Regions. For more information, and an
	// up-to-date list of Amazon Web Services Regions in which PERSISTENT_2 is
	// available, see File system deployment options for FSx for Lustre
	// (https://docs.aws.amazon.com/fsx/latest/LustreGuide/using-fsx-lustre.html#lustre-deployment-types)
	// in the Amazon FSx for Lustre User Guide. If you choose PERSISTENT_2, and you set
	// FileSystemTypeVersion to 2.10, the CreateFileSystem operation fails. Encryption
	// of data in transit is automatically turned on when you access SCRATCH_2,
	// PERSISTENT_1 and PERSISTENT_2 file systems from Amazon EC2 instances that
	// support automatic encryption
	// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/data-
	// protection.html) in the Amazon Web Services Regions where they are available.
	// For more information about encryption in transit for FSx for Lustre file
	// systems, see Encrypting data in transit
	// (https://docs.aws.amazon.com/fsx/latest/LustreGuide/encryption-in-transit-fsxl.html)
	// in the Amazon FSx for Lustre User Guide. (Default = SCRATCH_1)
	DeploymentType LustreDeploymentType

	// The type of drive cache used by PERSISTENT_1 file systems that are provisioned
	// with HDD storage devices. This parameter is required when storage type is HDD.
	// Set this property to READ to improve the performance for frequently accessed
	// files by caching up to 20% of the total storage capacity of the file system.
	// This parameter is required when StorageType is set to HDD.
	DriveCacheType DriveCacheType

	// (Optional) Available with Scratch and Persistent_1 deployment types. Specifies
	// the path in the Amazon S3 bucket where the root of your Amazon FSx file system
	// is exported. The path must use the same Amazon S3 bucket as specified in
	// ImportPath. You can provide an optional prefix to which new and changed data is
	// to be exported from your Amazon FSx for Lustre file system. If an ExportPath
	// value is not provided, Amazon FSx sets a default export path,
	// s3://import-bucket/FSxLustre[creation-timestamp]. The timestamp is in UTC
	// format, for example s3://import-bucket/FSxLustre20181105T222312Z. The Amazon S3
	// export bucket must be the same as the import bucket specified by ImportPath. If
	// you specify only a bucket name, such as s3://import-bucket, you get a 1:1
	// mapping of file system objects to S3 bucket objects. This mapping means that the
	// input data in S3 is overwritten on export. If you provide a custom prefix in the
	// export path, such as s3://import-bucket/[custom-optional-prefix], Amazon FSx
	// exports the contents of your file system to that export prefix in the Amazon S3
	// bucket. This parameter is not supported for file systems with the Persistent_2
	// deployment type. Instead, use CreateDataRepositoryAssociation to create a data
	// repository association to link your Lustre file system to a data repository.
	ExportPath *string

	// (Optional) The path to the Amazon S3 bucket (including the optional prefix) that
	// you're using as the data repository for your Amazon FSx for Lustre file system.
	// The root of your FSx for Lustre file system will be mapped to the root of the
	// Amazon S3 bucket you select. An example is s3://import-bucket/optional-prefix.
	// If you specify a prefix after the Amazon S3 bucket name, only object keys with
	// that prefix are loaded into the file system. This parameter is not supported for
	// file systems with the Persistent_2 deployment type. Instead, use
	// CreateDataRepositoryAssociation to create a data repository association to link
	// your Lustre file system to a data repository.
	ImportPath *string

	// (Optional) For files imported from a data repository, this value determines the
	// stripe count and maximum amount of data per file (in MiB) stored on a single
	// physical disk. The maximum number of disks that a single file can be striped
	// across is limited by the total number of disks that make up the file system. The
	// default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB (500
	// GiB). Amazon S3 objects have a maximum size of 5 TB. This parameter is not
	// supported for file systems with the Persistent_2 deployment type. Instead, use
	// CreateDataRepositoryAssociation to create a data repository association to link
	// your Lustre file system to a data repository.
	ImportedFileChunkSize *int32

	// The Lustre logging configuration used when creating an Amazon FSx for Lustre
	// file system. When logging is enabled, Lustre logs error and warning events for
	// data repositories associated with your file system to Amazon CloudWatch Logs.
	LogConfiguration *LustreLogCreateConfiguration

	// Required with PERSISTENT_1 and PERSISTENT_2 deployment types, provisions the
	// amount of read and write throughput for each 1 tebibyte (TiB) of file system
	// storage capacity, in MB/s/TiB. File system throughput capacity is calculated by
	// multiplying ﬁle system storage capacity (TiB) by the PerUnitStorageThroughput
	// (MB/s/TiB). For a 2.4-TiB ﬁle system, provisioning 50 MB/s/TiB of
	// PerUnitStorageThroughput yields 120 MB/s of ﬁle system throughput. You pay for
	// the amount of throughput that you provision. Valid values:
	//
	// * For PERSISTENT_1
	// SSD storage: 50, 100, 200 MB/s/TiB.
	//
	// * For PERSISTENT_1 HDD storage: 12, 40
	// MB/s/TiB.
	//
	// * For PERSISTENT_2 SSD storage: 125, 250, 500, 1000 MB/s/TiB.
	PerUnitStorageThroughput *int32

	// The Lustre root squash configuration used when creating an Amazon FSx for Lustre
	// file system. When enabled, root squash restricts root-level access from clients
	// that try to access your file system as a root user.
	RootSquashConfiguration *LustreRootSquashConfiguration

	// (Optional) The preferred start time to perform weekly maintenance, formatted
	// d:HH:MM in the UTC time zone, where d is the weekday number, from 1 through 7,
	// beginning with Monday and ending with Sunday.
	WeeklyMaintenanceStartTime *string

	noSmithyDocumentSerde
}

// The ONTAP configuration properties of the FSx for ONTAP file system that you are
// creating.
type CreateFileSystemOntapConfiguration struct {

	// Specifies the FSx for ONTAP file system deployment type to use in creating the
	// file system.
	//
	// * MULTI_AZ_1 - (Default) A high availability file system
	// configured for Multi-AZ redundancy to tolerate temporary Availability Zone (AZ)
	// unavailability.
	//
	// * SINGLE_AZ_1 - A file system configured for Single-AZ
	// redundancy.
	//
	// For information about the use cases for Multi-AZ and Single-AZ
	// deployments, refer to Choosing a file system deployment type
	// (https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/high-availability-AZ.html).
	//
	// This member is required.
	DeploymentType OntapDeploymentType

	// Sets the throughput capacity for the file system that you're creating. Valid
	// values are 128, 256, 512, 1024, and 2048 MBps.
	//
	// This member is required.
	ThroughputCapacity *int32

	// The number of days to retain automatic backups. Setting this property to 0
	// disables automatic backups. You can retain automatic backups for a maximum of 90
	// days. The default is 0.
	AutomaticBackupRetentionDays *int32

	// A recurring daily time, in the format HH:MM. HH is the zero-padded hour of the
	// day (0-23), and MM is the zero-padded minute of the hour. For example, 05:00
	// specifies 5 AM daily.
	DailyAutomaticBackupStartTime *string

	// The SSD IOPS configuration for the FSx for ONTAP file system.
	DiskIopsConfiguration *DiskIopsConfiguration

	// (Multi-AZ only) Specifies the IP address range in which the endpoints to access
	// your file system will be created. By default, Amazon FSx selects an unused IP
	// address range for you from the 198.19.* range. The Endpoint IP address range you
	// select for your file system must exist outside the VPC's CIDR range and must be
	// at least /30 or larger.
	EndpointIpAddressRange *string

	// The ONTAP administrative password for the fsxadmin user with which you
	// administer your file system using the NetApp ONTAP CLI and REST API.
	FsxAdminPassword *string

	// Required when DeploymentType is set to MULTI_AZ_1. This specifies the subnet in
	// which you want the preferred file server to be located.
	PreferredSubnetId *string

	// (Multi-AZ only) Specifies the virtual private cloud (VPC) route tables in which
	// your file system's endpoints will be created. You should specify all VPC route
	// tables associated with the subnets in which your clients are located. By
	// default, Amazon FSx selects your VPC's default route table.
	RouteTableIds []string

	// A recurring weekly time, in the format D:HH:MM. D is the day of the week, for
	// which 1 represents Monday and 7 represents Sunday. For further details, see the
	// ISO-8601 spec as described on Wikipedia
	// (https://en.wikipedia.org/wiki/ISO_week_date). HH is the zero-padded hour of the
	// day (0-23), and MM is the zero-padded minute of the hour. For example, 1:05:00
	// specifies maintenance at 5 AM Monday.
	WeeklyMaintenanceStartTime *string

	noSmithyDocumentSerde
}

// The Amazon FSx for OpenZFS configuration properties for the file system that you
// are creating.
type CreateFileSystemOpenZFSConfiguration struct {

	// Specifies the file system deployment type. Amazon FSx for OpenZFS supports
	// SINGLE_AZ_1. SINGLE_AZ_1 deployment type is configured for redundancy within a
	// single Availability Zone.
	//
	// This member is required.
	DeploymentType OpenZFSDeploymentType

	// Specifies the throughput of an Amazon FSx for OpenZFS file system, measured in
	// megabytes per second (MB/s). Valid values are 64, 128, 256, 512, 1024, 2048,
	// 3072, or 4096 MB/s. You pay for additional throughput capacity that you
	// provision.
	//
	// This member is required.
	ThroughputCapacity *int32

	// The number of days to retain automatic backups. Setting this property to 0
	// disables automatic backups. You can retain automatic backups for a maximum of 90
	// days. The default is 0.
	AutomaticBackupRetentionDays *int32

	// A Boolean value indicating whether tags for the file system should be copied to
	// backups. This value defaults to false. If it's set to true, all tags for the
	// file system are copied to all automatic and user-initiated backups where the
	// user doesn't specify tags. If this value is true, and you specify one or more
	// tags, only the specified tags are copied to backups. If you specify one or more
	// tags when creating a user-initiated backup, no tags are copied from the file
	// system, regardless of this value.
	CopyTagsToBackups *bool

	// A Boolean value indicating whether tags for the file system should be copied to
	// volumes. This value defaults to false. If it's set to true, all tags for the
	// file system are copied to volumes where the user doesn't specify tags. If this
	// value is true, and you specify one or more tags, only the specified tags are
	// copied to volumes. If you specify one or more tags when creating the volume, no
	// tags are copied from the file system, regardless of this value.
	CopyTagsToVolumes *bool

	// A recurring daily time, in the format HH:MM. HH is the zero-padded hour of the
	// day (0-23), and MM is the zero-padded minute of the hour. For example, 05:00
	// specifies 5 AM daily.
	DailyAutomaticBackupStartTime *string

	// The SSD IOPS (input/output operations per second) configuration for an Amazon
	// FSx for NetApp ONTAP or Amazon FSx for OpenZFS file system. The default is 3
	// IOPS per GB of storage capacity, but you can provision additional IOPS per GB of
	// storage. The configuration consists of the total number of provisioned SSD IOPS
	// and how the amount was provisioned (by the customer or by the system).
	DiskIopsConfiguration *DiskIopsConfiguration

	// The configuration Amazon FSx uses when creating the root value of the Amazon FSx
	// for OpenZFS file system. All volumes are children of the root volume.
	RootVolumeConfiguration *OpenZFSCreateRootVolumeConfiguration

	// A recurring weekly time, in the format D:HH:MM. D is the day of the week, for
	// which 1 represents Monday and 7 represents Sunday. For further details, see the
	// ISO-8601 spec as described on Wikipedia
	// (https://en.wikipedia.org/wiki/ISO_week_date). HH is the zero-padded hour of the
	// day (0-23), and MM is the zero-padded minute of the hour. For example, 1:05:00
	// specifies maintenance at 5 AM Monday.
	WeeklyMaintenanceStartTime *string

	noSmithyDocumentSerde
}

// The configuration object for the Microsoft Windows file system used in
// CreateFileSystem and CreateFileSystemFromBackup operations.
type CreateFileSystemWindowsConfiguration struct {

	// Sets the throughput capacity of an Amazon FSx file system, measured in megabytes
	// per second (MB/s), in 2 to the nth increments, between 2^3 (8) and 2^11 (2048).
	//
	// This member is required.
	ThroughputCapacity *int32

	// The ID for an existing Amazon Web Services Managed Microsoft Active Directory
	// (AD) instance that the file system should join when it's created.
	ActiveDirectoryId *string

	// An array of one or more DNS alias names that you want to associate with the
	// Amazon FSx file system. Aliases allow you to use existing DNS names to access
	// the data in your Amazon FSx file system. You can associate up to 50 aliases with
	// a file system at any time. You can associate additional DNS aliases after you
	// create the file system using the AssociateFileSystemAliases operation. You can
	// remove DNS aliases from the file system after it is created using the
	// DisassociateFileSystemAliases operation. You only need to specify the alias name
	// in the request payload. For more information, see Working with DNS Aliases
	// (https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html)
	// and Walkthrough 5: Using DNS aliases to access your file system
	// (https://docs.aws.amazon.com/fsx/latest/WindowsGuide/walkthrough05-file-system-custom-CNAME.html),
	// including additional steps you must take to be able to access your file system
	// using a DNS alias. An alias name has to meet the following requirements:
	//
	// *
	// Formatted as a fully-qualified domain name (FQDN), hostname.domain, for example,
	// accounting.example.com.
	//
	// * Can contain alphanumeric characters, the underscore
	// (_), and the hyphen (-).
	//
	// * Cannot start or end with a hyphen.
	//
	// * Can start with
	// a numeric.
	//
	// For DNS alias names, Amazon FSx stores alphabetic characters as
	// lowercase letters (a-z), regardless of how you specify them: as uppercase
	// letters, lowercase letters, or the corresponding letters in escape codes.
	Aliases []string

	// The configuration that Amazon FSx for Windows File Server uses to audit and log
	// user accesses of files, folders, and file shares on the Amazon FSx for Windows
	// File Server file system.
	AuditLogConfiguration *WindowsAuditLogCreateConfiguration

	// The number of days to retain automatic backups. The default is to retain backups
	// for 7 days. Setting this value to 0 disables the creation of automatic backups.
	// The maximum retention period for backups is 90 days.
	AutomaticBackupRetentionDays *int32

	// A boolean flag indicating whether tags for the file system should be copied to
	// backups. This value defaults to false. If it's set to true, all tags for the
	// file system are copied to all automatic and user-initiated backups where the
	// user doesn't specify tags. If this value is true, and you specify one or more
	// tags, only the specified tags are copied to backups. If you specify one or more
	// tags when creating a user-initiated backup, no tags are copied from the file
	// system, regardless of this value.
	CopyTagsToBackups *bool

	// The preferred time to take daily automatic backups, formatted HH:MM in the UTC
	// time zone.
	DailyAutomaticBackupStartTime *string

	// Specifies the file system deployment type, valid values are the following:
	//
	// *
	// MULTI_AZ_1 - Deploys a high availability file system that is configured for
	// Multi-AZ redundancy to tolerate temporary Availability Zone (AZ) unavailability.
	// You can only deploy a Multi-AZ file system in Amazon Web Services Regions that
	// have a minimum of three Availability Zones. Also supports HDD storage type
	//
	// *
	// SINGLE_AZ_1 - (Default) Choose to deploy a file system that is configured for
	// single AZ redundancy.
	//
	// * SINGLE_AZ_2 - The latest generation Single AZ file
	// system. Specifies a file system that is configured for single AZ redundancy and
	// supports HDD storage type.
	//
	// For more information, see  Availability and
	// Durability: Single-AZ and Multi-AZ File Systems
	// (https://docs.aws.amazon.com/fsx/latest/WindowsGuide/high-availability-multiAZ.html).
	DeploymentType WindowsDeploymentType

	// Required when DeploymentType is set to MULTI_AZ_1. This specifies the subnet in
	// which you want the preferred file server to be located. For in-Amazon Web
	// Services applications, we recommend that you launch your clients in the same
	// Availability Zone (AZ) as your preferred file server to reduce cross-AZ data
	// transfer costs and minimize latency.
	PreferredSubnetId *string

	// The configuration that Amazon FSx uses to join a FSx for Windows File Server
	// file system or an ONTAP storage virtual machine (SVM) to a self-managed
	// (including on-premises) Microsoft Active Directory (AD) directory. For more
	// information, see  Using Amazon FSx with your self-managed Microsoft Active
	// Directory
	// (https://docs.aws.amazon.com/fsx/latest/WindowsGuide/self-managed-AD.html) or
	// Managing SVMs
	// (https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-svms.html).
	SelfManagedActiveDirectoryConfiguration *SelfManagedActiveDirectoryConfiguration

	// The preferred start time to perform weekly maintenance, formatted d:HH:MM in the
	// UTC time zone, where d is the weekday number, from 1 through 7, beginning with
	// Monday and ending with Sunday.
	WeeklyMaintenanceStartTime *string

	noSmithyDocumentSerde
}

// Specifies the configuration of the ONTAP volume that you are creating.
type CreateOntapVolumeConfiguration struct {

	// Specifies the location in the SVM's namespace where the volume is mounted. The
	// JunctionPath must have a leading forward slash, such as /vol3.
	//
	// This member is required.
	JunctionPath *string

	// Specifies the size of the volume, in megabytes (MB), that you are creating.
	//
	// This member is required.
	SizeInMegabytes *int32

	// Set to true to enable deduplication, compression, and compaction storage
	// efficiency features on the volume.
	//
	// This member is required.
	StorageEfficiencyEnabled *bool

	// Specifies the ONTAP SVM in which to create the volume.
	//
	// This member is required.
	StorageVirtualMachineId *string

	// The security style for the volume. Specify one of the following values:
	//
	// * UNIX
	// if the file system is managed by a UNIX administrator, the majority of users are
	// NFS clients, and an application accessing the data uses a UNIX user as the
	// service account. UNIX is the default.
	//
	// * NTFS if the file system is managed by a
	// Windows administrator, the majority of users are SMB clients, and an application
	// accessing the data uses a Windows user as the service account.
	//
	// * MIXED if the
	// file system is managed by both UNIX and Windows administrators and users consist
	// of both NFS and SMB clients.
	SecurityStyle SecurityStyle

	// Describes the data tiering policy for an ONTAP volume. When enabled, Amazon FSx
	// for ONTAP's intelligent tiering automatically transitions a volume's data
	// between the file system's primary storage and capacity pool storage based on
	// your access patterns. Valid tiering policies are the following:
	//
	// * SNAPSHOT_ONLY
	// - (Default value) moves cold snapshots to the capacity pool storage tier.
	//
	// *
	// AUTO - moves cold user data and snapshots to the capacity pool storage tier
	// based on your access patterns.
	//
	// * ALL - moves all user data blocks in both the
	// active file system and Snapshot copies to the storage pool tier.
	//
	// * NONE - keeps
	// a volume's data in the primary storage tier, preventing it from being moved to
	// the capacity pool tier.
	TieringPolicy *TieringPolicy

	noSmithyDocumentSerde
}

// The snapshot configuration to use when creating an OpenZFS volume from a
// snapshot.
type CreateOpenZFSOriginSnapshotConfiguration struct {

	// The strategy used when copying data from the snapshot to the new volume.
	//
	// *
	// CLONE - The new volume references the data in the origin snapshot. Cloning a
	// snapshot is faster than copying data from the snapshot to a new volume and
	// doesn't consume disk throughput. However, the origin snapshot can't be deleted
	// if there is a volume using its copied data.
	//
	// * FULL_COPY - Copies all data from
	// the snapshot to the new volume.
	//
	// This member is required.
	CopyStrategy OpenZFSCopyStrategy

	// The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify
	// Amazon Web Services resources. We require an ARN when you need to specify a
	// resource unambiguously across all of Amazon Web Services. For more information,
	// see Amazon Resource Names (ARNs)
	// (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in
	// the Amazon Web Services General Reference.
	//
	// This member is required.
	SnapshotARN *string

	noSmithyDocumentSerde
}

// Specifies the configuration of the Amazon FSx for OpenZFS volume that you are
// creating.
type CreateOpenZFSVolumeConfiguration struct {

	// The ID of the volume to use as the parent volume of the volume that you are
	// creating.
	//
	// This member is required.
	ParentVolumeId *string

	// A Boolean value indicating whether tags for the volume should be copied to
	// snapshots. This value defaults to false. If it's set to true, all tags for the
	// volume are copied to snapshots where the user doesn't specify tags. If this
	// value is true, and you specify one or more tags, only the specified tags are
	// copied to snapshots. If you specify one or more tags when creating the snapshot,
	// no tags are copied from the volume, regardless of this value.
	CopyTagsToSnapshots *bool

	// Specifies the method used to compress the data on the volume. The compression
	// type is NONE by default.
	//
	// * NONE - Doesn't compress the data on the volume. NONE
	// is the default.
	//
	// * ZSTD - Compresses the data in the volume using the Zstandard
	// (ZSTD) compression algorithm. ZSTD compression provides a higher level of data
	// compression and higher read throughput performance than LZ4 compression.
	//
	// * LZ4
	// - Compresses the data in the volume using the LZ4 compression algorithm. LZ4
	// compression provides a lower level of compression and higher write throughput
	// performance than ZSTD compression.
	//
	// For more information about volume
	// compression types and the performance of your Amazon FSx for OpenZFS file
	// system, see  Tips for maximizing performance
	// (https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/performance.html#performance-tips-zfs)
	// File system and volume settings in the Amazon FSx for OpenZFS User Guide.
	DataCompressionType OpenZFSDataCompressionType

	// The configuration object for mounting a Network File System (NFS) file system.
	NfsExports []OpenZFSNfsExport

	// The configuration object that specifies the snapshot to use as the origin of the
	// data for the volume.
	OriginSnapshot *CreateOpenZFSOriginSnapshotConfiguration

	// A Boolean value indicating whether the volume is read-only.
	ReadOnly *bool

	// Specifies the suggested block size for a volume in a ZFS dataset, in kibibytes
	// (KiB). Valid values are 4, 8, 16, 32, 64, 128, 256, 512, or 1024 KiB. The
	// default is 128 KiB. We recommend using the default setting for the majority of
	// use cases. Generally, workloads that write in fixed small or large record sizes
	// may benefit from setting a custom record size, like database workloads (small
	// record size) or media streaming workloads (large record size). For additional
	// guidance on when to set a custom record size, see  ZFS Record size
	// (https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/performance.html#record-size-performance)
	// in the Amazon FSx for OpenZFS User Guide.
	RecordSizeKiB *int32

	// Sets the maximum storage size in gibibytes (GiB) for the volume. You can specify
	// a quota that is larger than the storage on the parent volume. A volume quota
	// limits the amount of storage that the volume can consume to the configured
	// amount, but does not guarantee the space will be available on the parent volume.
	// To guarantee quota space, you must also set StorageCapacityReservationGiB. To
	// not specify a storage capacity quota, set this to -1. For more information, see
	// Volume properties
	// (https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/managing-volumes.html#volume-properties)
	// in the Amazon FSx for OpenZFS User Guide.
	StorageCapacityQuotaGiB *int32

	// Specifies the amount of storage in gibibytes (GiB) to reserve from the parent
	// volume. Setting StorageCapacityReservationGiB guarantees that the specified
	// amount of storage space on the parent volume will always be available for the
	// volume. You can't reserve more storage than the parent volume has. To not
	// specify a storage capacity reservation, set this to 0 or -1. For more
	// information, see Volume properties
	// (https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/managing-volumes.html#volume-properties)
	// in the Amazon FSx for OpenZFS User Guide.
	StorageCapacityReservationGiB *int32

	// An object specifying how much storage users or groups can use on the volume.
	UserAndGroupQuotas []OpenZFSUserOrGroupQuota

	noSmithyDocumentSerde
}

// The configuration that Amazon FSx uses to join the ONTAP storage virtual machine
// (SVM) to your self-managed (including on-premises) Microsoft Active Directory
// (AD) directory.
type CreateSvmActiveDirectoryConfiguration struct {

	// The NetBIOS name of the Active Directory computer object that will be created
	// for your SVM.
	//
	// This member is required.
	NetBiosName *string

	// The configuration that Amazon FSx uses to join a FSx for Windows File Server
	// file system or an ONTAP storage virtual machine (SVM) to a self-managed
	// (including on-premises) Microsoft Active Directory (AD) directory. For more
	// information, see  Using Amazon FSx with your self-managed Microsoft Active
	// Directory
	// (https://docs.aws.amazon.com/fsx/latest/WindowsGuide/self-managed-AD.html) or
	// Managing SVMs
	// (https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-svms.html).
	SelfManagedActiveDirectoryConfiguration *SelfManagedActiveDirectoryConfiguration

	noSmithyDocumentSerde
}

// The configuration of a data repository association that links an Amazon FSx for
// Lustre file system to an Amazon S3 bucket. The data repository association
// configuration object is returned in the response of the following operations:
//
// *
// CreateDataRepositoryAssociation
//
// * UpdateDataRepositoryAssociation
//
// *
// DescribeDataRepositoryAssociations
//
// Data repository associations are supported
// only for file systems with the Persistent_2 deployment type.
type DataRepositoryAssociation struct {

	// The system-generated, unique ID of the data repository association.
	AssociationId *string

	// A boolean flag indicating whether an import data repository task to import
	// metadata should run after the data repository association is created. The task
	// runs if this flag is set to true.
	BatchImportMetaDataOnCreate *bool

	// The time that the resource was created, in seconds (since 1970-01-01T00:00:00Z),
	// also known as Unix time.
	CreationTime *time.Time

	// The path to the Amazon S3 data repository that will be linked to the file
	// system. The path can be an S3 bucket or prefix in the format
	// s3://myBucket/myPrefix/. This path specifies where in the S3 data repository
	// files will be imported from or exported to.
	DataRepositoryPath *string

	// Provides detailed information about the data respository if its Lifecycle is set
	// to MISCONFIGURED or FAILED.
	FailureDetails *DataRepositoryFailureDetails

	// The globally unique ID of the file system, assigned by Amazon FSx.
	FileSystemId *string

	// A path on the file system that points to a high-level directory (such as /ns1/)
	// or subdirectory (such as /ns1/subdir/) that will be mapped 1-1 with
	// DataRepositoryPath. The leading forward slash in the name is required. Two data
	// repository associations cannot have overlapping file system paths. For example,
	// if a data repository is associated with file system path /ns1/, then you cannot
	// link another data repository with file system path /ns1/ns2. This path specifies
	// where in your file system files will be exported from or imported to. This file
	// system directory can be linked to only one Amazon S3 bucket, and no other S3
	// bucket can be linked to the directory. If you specify only a forward slash (/)
	// as the file system path, you can link only 1 data repository to the file system.
	// You can only specify "/" as the file system path for the first data repository
	// associated with a file system.
	FileSystemPath *string

	// For files imported from a data repository, this value determines the stripe
	// count and maximum amount of data per file (in MiB) stored on a single physical
	// disk. The maximum number of disks that a single file can be striped across is
	// limited by the total number of disks that make up the file system. The default
	// chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB (500 GiB).
	// Amazon S3 objects have a maximum size of 5 TB.
	ImportedFileChunkSize *int32

	// Describes the state of a data repository association. The lifecycle can have the
	// following values:
	//
	// * CREATING - The data repository association between the FSx
	// file system and the S3 data repository is being created. The data repository is
	// unavailable.
	//
	// * AVAILABLE - The data repository association is available for
	// use.
	//
	// * MISCONFIGURED - Amazon FSx cannot automatically import updates from the
	// S3 bucket or automatically export updates to the S3 bucket until the data
	// repository association configuration is corrected.
	//
	// * UPDATING - The data
	// repository association is undergoing a customer initiated update that might
	// affect its availability.
	//
	// * DELETING - The data repository association is
	// undergoing a customer initiated deletion.
	//
	// * FAILED - The data repository
	// association is in a terminal state that cannot be recovered.
	Lifecycle DataRepositoryLifecycle

	// The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify
	// Amazon Web Services resources. We require an ARN when you need to specify a
	// resource unambiguously across all of Amazon Web Services. For more information,
	// see Amazon Resource Names (ARNs)
	// (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in
	// the Amazon Web Services General Reference.
	ResourceARN *string

	// The configuration for an Amazon S3 data repository linked to an Amazon FSx
	// Lustre file system with a data repository association. The configuration defines
	// which file events (new, changed, or deleted files or directories) are
	// automatically imported from the linked data repository to the file system or
	// automatically exported from the file system to the data repository.
	S3 *S3DataRepositoryConfiguration

	// A list of Tag values, with a maximum of 50 elements.
	Tags []Tag

	noSmithyDocumentSerde
}

// The data repository configuration object for Lustre file systems returned in the
// response of the CreateFileSystem operation. This data type is not supported for
// file systems with the Persistent_2 deployment type. Instead, use .
type DataRepositoryConfiguration struct {

	// Describes the file system's linked S3 data repository's AutoImportPolicy. The
	// AutoImportPolicy configures how Amazon FSx keeps your file and directory
	// listings up to date as you add or modify objects in your linked S3 bucket.
	// AutoImportPolicy can have the following values:
	//
	// * NONE - (Default) AutoImport
	// is off. Amazon FSx only updates file and directory listings from the linked S3
	// bucket when the file system is created. FSx does not update file and directory
	// listings for any new or changed objects after choosing this option.
	//
	// * NEW -
	// AutoImport is on. Amazon FSx automatically imports directory listings of any new
	// objects added to the linked S3 bucket that do not currently exist in the FSx
	// file system.
	//
	// * NEW_CHANGED - AutoImport is on. Amazon FSx automatically imports
	// file and directory listings of any new objects added to the S3 bucket and any
	// existing objects that are changed in the S3 bucket after you choose this
	// option.
	//
	// * NEW_CHANGED_DELETED - AutoImport is on. Amazon FSx automatically
	// imports file and directory listings of any new objects added to the S3 bucket,
	// any existing objects that are changed in the S3 bucket, and any objects that
	// were deleted in the S3 bucket.
	AutoImportPolicy AutoImportPolicyType

	// The export path to the Amazon S3 bucket (and prefix) that you are using to store
	// new and changed Lustre file system files in S3.
	ExportPath *string

	// Provides detailed information about the data respository if its Lifecycle is set
	// to MISCONFIGURED or FAILED.
	FailureDetails *DataRepositoryFailureDetails

	// The import path to the Amazon S3 bucket (and optional prefix) that you're using
	// as the data repository for your FSx for Lustre file system, for example
	// s3://import-bucket/optional-prefix. If a prefix is specified after the Amazon S3
	// bucket name, only object keys with that prefix are loaded into the file system.
	ImportPath *string

	// For files imported from a data repository, this value determines the stripe
	// count and maximum amount of data per file (in MiB) stored on a single physical
	// disk. The maximum number of disks that a single file can be striped across is
	// limited by the total number of disks that make up the file system. The default
	// chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB (500 GiB).
	// Amazon S3 objects have a maximum size of 5 TB.
	ImportedFileChunkSize *int32

	// Describes the state of the file system's S3 durable data repository, if it is
	// configured with an S3 repository. The lifecycle can have the following
	// values:
	//
	// * CREATING - The data repository configuration between the FSx file
	// system and the linked S3 data repository is being created. The data repository
	// is unavailable.
	//
	// * AVAILABLE - The data repository is available for use.
	//
	// *
	// MISCONFIGURED - Amazon FSx cannot automatically import updates from the S3
	// bucket until the data repository configuration is corrected. For more
	// information, see Troubleshooting a Misconfigured linked S3 bucket
	// (https://docs.aws.amazon.com/fsx/latest/LustreGuide/troubleshooting.html#troubleshooting-misconfigured-data-repository).
	//
	// *
	// UPDATING - The data repository is undergoing a customer initiated update and
	// availability may be impacted.
	//
	// * FAILED - The data repository is in a terminal
	// state that cannot be recovered.
	Lifecycle DataRepositoryLifecycle

	noSmithyDocumentSerde
}

// Provides detailed information about the data respository if its Lifecycle is set
// to MISCONFIGURED or FAILED.
type DataRepositoryFailureDetails struct {

	// A detailed error message.
	Message *string

	noSmithyDocumentSerde
}

// A description of the data repository task. You use data repository tasks to
// perform bulk transfer operations between your Amazon FSx file system and a
// linked data repository.
type DataRepositoryTask struct {

	// The time that the resource was created, in seconds (since 1970-01-01T00:00:00Z),
	// also known as Unix time.
	//
	// This member is required.
	CreationTime *time.Time

	// The globally unique ID of the file system, assigned by Amazon FSx.
	//
	// This member is required.
	FileSystemId *string

	// The lifecycle status of the data repository task, as follows:
	//
	// * PENDING -
	// Amazon FSx has not started the task.
	//
	// * EXECUTING - Amazon FSx is processing the
	// task.
	//
	// * FAILED - Amazon FSx was not able to complete the task. For example,
	// there may be files the task failed to process. The
	// DataRepositoryTaskFailureDetails property provides more information about task
	// failures.
	//
	// * SUCCEEDED - FSx completed the task successfully.
	//
	// * CANCELED -
	// Amazon FSx canceled the task and it did not complete.
	//
	// * CANCELING - FSx is in
	// process of canceling the task.
	//
	// You cannot delete an FSx for Lustre file system
	// if there are data repository tasks for the file system in the PENDING or
	// EXECUTING states. Please retry when the data repository task is finished (with a
	// status of CANCELED, SUCCEEDED, or FAILED). You can use the
	// DescribeDataRepositoryTask action to monitor the task status. Contact the FSx
	// team if you need to delete your file system immediately.
	//
	// This member is required.
	Lifecycle DataRepositoryTaskLifecycle

	// The system-generated, unique 17-digit ID of the data repository task.
	//
	// This member is required.
	TaskId *string

	// The type of data repository task.
	//
	// * The EXPORT_TO_REPOSITORY data repository
	// task exports from your Lustre file system from to a linked S3 bucket.
	//
	// * The
	// IMPORT_METADATA_FROM_REPOSITORY data repository task imports metadata changes
	// from a linked S3 bucket to your Lustre file system.
	//
	// This member is required.
	Type DataRepositoryTaskType

	// The time that Amazon FSx completed processing the task, populated after the task
	// is complete.
	EndTime *time.Time

	// Failure message describing why the task failed, it is populated only when
	// Lifecycle is set to FAILED.
	FailureDetails *DataRepositoryTaskFailureDetails

	// An array of paths on the Amazon FSx for Lustre file system that specify the data
	// for the data repository task to process. For example, in an EXPORT_TO_REPOSITORY
	// task, the paths specify which data to export to the linked data repository.
	// (Default) If Paths is not specified, Amazon FSx uses the file system root
	// directory.
	Paths []string

	// Provides a report detailing the data repository task results of the files
	// processed that match the criteria specified in the report Scope parameter. FSx
	// delivers the report to the file system's linked data repository in Amazon S3,
	// using the path specified in the report Path parameter. You can specify whether
	// or not a report gets generated for a task using the Enabled parameter.
	Report *CompletionReport

	// The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify
	// Amazon Web Services resources. We require an ARN when you need to specify a
	// resource unambiguously across all of Amazon Web Services. For more information,
	// see Amazon Resource Names (ARNs)
	// (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in
	// the Amazon Web Services General Reference.
	ResourceARN *string

	// The time that Amazon FSx began processing the task.
	StartTime *time.Time

	// Provides the status of the number of files that the task has processed
	// successfully and failed to process.
	Status *DataRepositoryTaskStatus

	// A list of Tag values, with a maximum of 50 elements.
	Tags []Tag

	noSmithyDocumentSerde
}

// Provides information about why a data repository task failed. Only populated
// when the task Lifecycle is set to FAILED.
type DataRepositoryTaskFailureDetails struct {

	// A detailed error message.
	Message *string

	noSmithyDocumentSerde
}

// (Optional) An array of filter objects you can use to filter the response of data
// repository tasks you will see in the the response. You can filter the tasks
// returned in the response by one or more file system IDs, task lifecycles, and by
// task type. A filter object consists of a filter Name, and one or more Values for
// the filter.
type DataRepositoryTaskFilter struct {

	// Name of the task property to use in filtering the tasks returned in the
	// response.
	//
	// * Use file-system-id to retrieve data repository tasks for specific
	// file systems.
	//
	// * Use task-lifecycle to retrieve data repository tasks with one
	// or more specific lifecycle states, as follows: CANCELED, EXECUTING, FAILED,
	// PENDING, and SUCCEEDED.
	Name DataRepositoryTaskFilterName

	// Use Values to include the specific file system IDs and task lifecycle states for
	// the filters you are using.
	Values []string

	noSmithyDocumentSerde
}

// Provides the task status showing a running total of the total number of files to
// be processed, the number successfully processed, and the number of files the
// task failed to process.
type DataRepositoryTaskStatus struct {

	// A running total of the number of files that the task failed to process.
	FailedCount *int64

	// The time at which the task status was last updated.
	LastUpdatedTime *time.Time

	// A running total of the number of files that the task has successfully processed.
	SucceededCount *int64

	// The total number of files that the task will process. While a task is executing,
	// the sum of SucceededCount plus FailedCount may not equal TotalCount. When the
	// task is complete, TotalCount equals the sum of SucceededCount plus FailedCount.
	TotalCount *int64

	noSmithyDocumentSerde
}

// The configuration object for the Amazon FSx for Lustre file system being deleted
// in the DeleteFileSystem operation.
type DeleteFileSystemLustreConfiguration struct {

	// Use if SkipFinalBackup is set to false, and you want to apply an array of tags
	// to the final backup. If you have set the file system property CopyTagsToBackups
	// to true, and you specify one or more FinalBackupTags when deleting a file
	// system, Amazon FSx will not copy any existing file system tags to the backup.
	FinalBackupTags []Tag

	// Set SkipFinalBackup to false if you want to take a final backup of the file
	// system you are deleting. By default, Amazon FSx will not take a final backup on
	// your behalf when the DeleteFileSystem operation is invoked. (Default = true) The
	// fsx:CreateBackup permission is required if you set SkipFinalBackup to false in
	// order to delete the file system and take a final backup.
	SkipFinalBackup *bool

	noSmithyDocumentSerde
}

// The response object for the Amazon FSx for Lustre file system being deleted in
// the DeleteFileSystem operation.
type DeleteFileSystemLustreResponse struct {

	// The ID of the final backup for this file system.
	FinalBackupId *string

	// The set of tags applied to the final backup.
	FinalBackupTags []Tag

	noSmithyDocumentSerde
}

// The configuration object for the Amazon FSx for OpenZFS file system used in the
// DeleteFileSystem operation.
type DeleteFileSystemOpenZFSConfiguration struct {

	// A list of tags to apply to the file system's final backup.
	FinalBackupTags []Tag

	// To delete a file system if there are child volumes present below the root
	// volume, use the string DELETE_CHILD_VOLUMES_AND_SNAPSHOTS. If your file system
	// has child volumes and you don't use this option, the delete request will fail.
	Options []DeleteFileSystemOpenZFSOption

	// By default, Amazon FSx for OpenZFS takes a final backup on your behalf when the
	// DeleteFileSystem operation is invoked. Doing this helps protect you from data
	// loss, and we highly recommend taking the final backup. If you want to skip
	// taking a final backup, set this value to true.
	SkipFinalBackup *bool

	noSmithyDocumentSerde
}

// The response object for the Amazon FSx for OpenZFS file system that's being
// deleted in the DeleteFileSystem operation.
type DeleteFileSystemOpenZFSResponse struct {

	// The ID of the source backup. Specifies the backup that you are copying.
	FinalBackupId *string

	// A list of Tag values, with a maximum of 50 elements.
	FinalBackupTags []Tag

	noSmithyDocumentSerde
}

// The configuration object for the Microsoft Windows file system used in the
// DeleteFileSystem operation.
type DeleteFileSystemWindowsConfiguration struct {

	// A set of tags for your final backup.
	FinalBackupTags []Tag

	// By default, Amazon FSx for Windows takes a final backup on your behalf when the
	// DeleteFileSystem operation is invoked. Doing this helps protect you from data
	// loss, and we highly recommend taking the final backup. If you want to skip this
	// backup, use this flag to do so.
	SkipFinalBackup *bool

	noSmithyDocumentSerde
}

// The response object for the Microsoft Windows file system used in the
// DeleteFileSystem operation.
type DeleteFileSystemWindowsResponse struct {

	// The ID of the final backup for this file system.
	FinalBackupId *string

	// The set of tags applied to the final backup.
	FinalBackupTags []Tag

	noSmithyDocumentSerde
}

// Use to specify skipping a final backup, or to add tags to a final backup.
type DeleteVolumeOntapConfiguration struct {

	// A list of Tag values, with a maximum of 50 elements.
	FinalBackupTags []Tag

	// Set to true if you want to skip taking a final backup of the volume you are
	// deleting.
	SkipFinalBackup *bool

	noSmithyDocumentSerde
}

// The response object for the Amazon FSx for NetApp ONTAP volume being deleted in
// the DeleteVolume operation.
type DeleteVolumeOntapResponse struct {

	// The ID of the source backup. Specifies the backup that you are copying.
	FinalBackupId *string

	// A list of Tag values, with a maximum of 50 elements.
	FinalBackupTags []Tag

	noSmithyDocumentSerde
}

// A value that specifies whether to delete all child volumes and snapshots.
type DeleteVolumeOpenZFSConfiguration struct {

	// To delete the volume's child volumes, snapshots, and clones, use the string
	// DELETE_CHILD_VOLUMES_AND_SNAPSHOTS.
	Options []DeleteOpenZFSVolumeOption

	noSmithyDocumentSerde
}

// The SSD IOPS (input/output operations per second) configuration for an Amazon
// FSx for NetApp ONTAP or Amazon FSx for OpenZFS file system. The default is 3
// IOPS per GB of storage capacity, but you can provision additional IOPS per GB of
// storage. The configuration consists of the total number of provisioned SSD IOPS
// and how the amount was provisioned (by the customer or by the system).
type DiskIopsConfiguration struct {

	// The total number of SSD IOPS provisioned for the file system.
	Iops *int64

	// Specifies whether the number of IOPS for the file system is using the system
	// default (AUTOMATIC) or was provisioned by the customer (USER_PROVISIONED).
	Mode DiskIopsConfigurationMode

	noSmithyDocumentSerde
}

// A description of a specific Amazon FSx file system.
type FileSystem struct {

	// A list of administrative actions for the file system that are in process or
	// waiting to be processed. Administrative actions describe changes to the Amazon
	// FSx system that you have initiated using the UpdateFileSystem operation.
	AdministrativeActions []AdministrativeAction

	// The time that the file system was created, in seconds (since
	// 1970-01-01T00:00:00Z), also known as Unix time.
	CreationTime *time.Time

	// The Domain Name System (DNS) name for the file system.
	DNSName *string

	// A structure providing details of any failures that occurred when creating a file
	// system.
	FailureDetails *FileSystemFailureDetails

	// The system-generated, unique 17-digit ID of the file system.
	FileSystemId *string

	// The type of Amazon FSx file system, which can be LUSTRE, WINDOWS, ONTAP, or
	// OPENZFS.
	FileSystemType FileSystemType

	// The Lustre version of the Amazon FSx for Lustre file system, either 2.10 or
	// 2.12.
	FileSystemTypeVersion *string

	// The ID of the Key Management Service (KMS) key used to encrypt Amazon FSx file
	// system data. Used as follows with Amazon FSx file system types:
	//
	// * Amazon FSx
	// for Lustre PERSISTENT_1 and PERSISTENT_2 deployment types only. SCRATCH_1 and
	// SCRATCH_2 types are encrypted using the Amazon FSx service KMS key for your
	// account.
	//
	// * Amazon FSx for NetApp ONTAP
	//
	// * Amazon FSx for OpenZFS
	//
	// * Amazon FSx
	// for Windows File Server
	KmsKeyId *string

	// The lifecycle status of the file system. The following are the possible values
	// and what they mean:
	//
	// * AVAILABLE - The file system is in a healthy state, and is
	// reachable and available for use.
	//
	// * CREATING - Amazon FSx is creating the new
	// file system.
	//
	// * DELETING - Amazon FSx is deleting an existing file system.
	//
	// *
	// FAILED - An existing file system has experienced an unrecoverable failure. When
	// creating a new file system, Amazon FSx was unable to create the file system.
	//
	// *
	// MISCONFIGURED - The file system is in a failed but recoverable state.
	//
	// *
	// MISCONFIGURED_UNAVAILABLE - (Amazon FSx for Windows File Server only) The file
	// system is currently unavailable due to a change in your Active Directory
	// configuration.
	//
	// * UPDATING - The file system is undergoing a customer-initiated
	// update.
	Lifecycle FileSystemLifecycle

	// The configuration for the Amazon FSx for Lustre file system.
	LustreConfiguration *LustreFileSystemConfiguration

	// The IDs of the elastic network interfaces from which a specific file system is
	// accessible. The elastic network interface is automatically created in the same
	// virtual private cloud (VPC) that the Amazon FSx file system was created in. For
	// more information, see Elastic Network Interfaces
	// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html) in the
	// Amazon EC2 User Guide. For an Amazon FSx for Windows File Server file system,
	// you can have one network interface ID. For an Amazon FSx for Lustre file system,
	// you can have more than one.
	NetworkInterfaceIds []string

	// The configuration for this Amazon FSx for NetApp ONTAP file system.
	OntapConfiguration *OntapFileSystemConfiguration

	// The configuration for this Amazon FSx for OpenZFS file system.
	OpenZFSConfiguration *OpenZFSFileSystemConfiguration

	// The Amazon Web Services account that created the file system. If the file system
	// was created by an Identity and Access Management (IAM) user, the Amazon Web
	// Services account to which the IAM user belongs is the owner.
	OwnerId *string

	// The Amazon Resource Name (ARN) of the file system resource.
	ResourceARN *string

	// The storage capacity of the file system in gibibytes (GiB).
	StorageCapacity *int32

	// The type of storage the file system is using. If set to SSD, the file system
	// uses solid state drive storage. If set to HDD, the file system uses hard disk
	// drive storage.
	StorageType StorageType

	// Specifies the IDs of the subnets that the file system is accessible from. For
	// the Amazon FSx Windows and ONTAP MULTI_AZ_1 file system deployment type, there
	// are two subnet IDs, one for the preferred file server and one for the standby
	// file server. The preferred file server subnet identified in the
	// PreferredSubnetID property. All other file systems have only one subnet ID. For
	// FSx for Lustre file systems, and Single-AZ Windows file systems, this is the ID
	// of the subnet that contains the file system's endpoint. For MULTI_AZ_1 Windows
	// and ONTAP file systems, the file system endpoint is available in the
	// PreferredSubnetID.
	SubnetIds []string

	// The tags to associate with the file system. For more information, see Tagging
	// your Amazon EC2 resources
	// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html) in the
	// Amazon EC2 User Guide.
	Tags []Tag

	// The ID of the primary virtual private cloud (VPC) for the file system.
	VpcId *string

	// The configuration for this Amazon FSx for Windows File Server file system.
	WindowsConfiguration *WindowsFileSystemConfiguration

	noSmithyDocumentSerde
}

// An Amazon FSx for NetApp ONTAP file system has two endpoints that are used to
// access data or to manage the file system using the NetApp ONTAP CLI, REST API,
// or NetApp SnapMirror. They are the Management and Intercluster endpoints.
type FileSystemEndpoint struct {

	// The Domain Name Service (DNS) name for the file system. You can mount your file
	// system using its DNS name.
	DNSName *string

	// IP addresses of the file system endpoint.
	IpAddresses []string

	noSmithyDocumentSerde
}

// An Amazon FSx for NetApp ONTAP file system has the following endpoints that are
// used to access data or to manage the file system using the NetApp ONTAP CLI,
// REST API, or NetApp SnapMirror.
type FileSystemEndpoints struct {

	// An endpoint for managing your file system by setting up NetApp SnapMirror with
	// other ONTAP systems.
	Intercluster *FileSystemEndpoint

	// An endpoint for managing your file system using the NetApp ONTAP CLI and NetApp
	// ONTAP API.
	Management *FileSystemEndpoint

	noSmithyDocumentSerde
}

// A structure providing details of any failures that occurred when creating a file
// system.
type FileSystemFailureDetails struct {

	// A message describing any failures that occurred during file system creation.
	Message *string

	noSmithyDocumentSerde
}

// A filter used to restrict the results of describe calls. You can use multiple
// filters to return results that meet all applied filter requirements.
type Filter struct {

	// The name for this filter.
	Name FilterName

	// The values of the filter. These are all the values for any of the applied
	// filters.
	Values []string

	noSmithyDocumentSerde
}

// Describes why a resource lifecycle state changed.
type LifecycleTransitionReason struct {

	// A detailed error message.
	Message *string

	noSmithyDocumentSerde
}

// The configuration for the Amazon FSx for Lustre file system.
type LustreFileSystemConfiguration struct {

	// The number of days to retain automatic backups. Setting this property to 0
	// disables automatic backups. You can retain automatic backups for a maximum of 90
	// days. The default is 0.
	AutomaticBackupRetentionDays *int32

	// A boolean flag indicating whether tags on the file system are copied to backups.
	// If it's set to true, all tags on the file system are copied to all automatic
	// backups and any user-initiated backups where the user doesn't specify any tags.
	// If this value is true, and you specify one or more tags, only the specified tags
	// are copied to backups. If you specify one or more tags when creating a
	// user-initiated backup, no tags are copied from the file system, regardless of
	// this value. (Default = false)
	CopyTagsToBackups *bool

	// A recurring daily time, in the format HH:MM. HH is the zero-padded hour of the
	// day (0-23), and MM is the zero-padded minute of the hour. For example, 05:00
	// specifies 5 AM daily.
	DailyAutomaticBackupStartTime *string

	// The data compression configuration for the file system. DataCompressionType can
	// have the following values:
	//
	// * NONE - Data compression is turned off for the file
	// system.
	//
	// * LZ4 - Data compression is turned on with the LZ4 algorithm.
	//
	// For more
	// information, see Lustre data compression
	// (https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-compression.html).
	DataCompressionType DataCompressionType

	// The data repository configuration object for Lustre file systems returned in the
	// response of the CreateFileSystem operation. This data type is not supported for
	// file systems with the Persistent_2 deployment type. Instead, use .
	DataRepositoryConfiguration *DataRepositoryConfiguration

	// The deployment type of the FSx for Lustre file system. Scratch deployment type
	// is designed for temporary storage and shorter-term processing of data. SCRATCH_1
	// and SCRATCH_2 deployment types are best suited for when you need temporary
	// storage and shorter-term processing of data. The SCRATCH_2 deployment type
	// provides in-transit encryption of data and higher burst throughput capacity than
	// SCRATCH_1. The PERSISTENT_1 and PERSISTENT_2 deployment type is used for
	// longer-term storage and workloads and encryption of data in transit.
	// PERSISTENT_2 is built on Lustre v2.12 and offers higher PerUnitStorageThroughput
	// (up to 1000 MB/s/TiB) along with a lower minimum storage capacity requirement
	// (600 GiB). To learn more about FSx for Lustre deployment types, see  FSx for
	// Lustre deployment options
	// (https://docs.aws.amazon.com/fsx/latest/LustreGuide/lustre-deployment-types.html).
	// The default is SCRATCH_1.
	DeploymentType LustreDeploymentType

	// The type of drive cache used by PERSISTENT_1 file systems that are provisioned
	// with HDD storage devices. This parameter is required when StorageType is HDD.
	// When set to READ the file system has an SSD storage cache that is sized to 20%
	// of the file system's storage capacity. This improves the performance for
	// frequently accessed files by caching up to 20% of the total storage capacity.
	// This parameter is required when StorageType is set to HDD.
	DriveCacheType DriveCacheType

	// The Lustre logging configuration. Lustre logging writes the enabled log events
	// for your file system to Amazon CloudWatch Logs.
	LogConfiguration *LustreLogConfiguration

	// You use the MountName value when mounting the file system. For the SCRATCH_1
	// deployment type, this value is always "fsx". For SCRATCH_2, PERSISTENT_1, and
	// PERSISTENT_2 deployment types, this value is a string that is unique within an
	// Amazon Web Services Region.
	MountName *string

	// Per unit storage throughput represents the megabytes per second of read or write
	// throughput per 1 tebibyte of storage provisioned. File system throughput
	// capacity is equal to Storage capacity (TiB) * PerUnitStorageThroughput
	// (MB/s/TiB). This option is only valid for PERSISTENT_1 and PERSISTENT_2
	// deployment types. Valid values:
	//
	// * For PERSISTENT_1 SSD storage: 50, 100,
	// 200.
	//
	// * For PERSISTENT_1 HDD storage: 12, 40.
	//
	// * For PERSISTENT_2 SSD storage:
	// 125, 250, 500, 1000.
	PerUnitStorageThroughput *int32

	// The Lustre root squash configuration for an Amazon FSx for Lustre file system.
	// When enabled, root squash restricts root-level access from clients that try to
	// access your file system as a root user.
	RootSquashConfiguration *LustreRootSquashConfiguration

	// The preferred start time to perform weekly maintenance, formatted d:HH:MM in the
	// UTC time zone. Here, d is the weekday number, from 1 through 7, beginning with
	// Monday and ending with Sunday.
	WeeklyMaintenanceStartTime *string

	noSmithyDocumentSerde
}

// The configuration for Lustre logging used to write the enabled logging events
// for your file system to Amazon CloudWatch Logs. When logging is enabled, Lustre
// logs error and warning events from data repository operations such as automatic
// export and data repository tasks. To learn more about Lustre logging, see
// Logging with Amazon CloudWatch Logs
// (https://docs.aws.amazon.com/fsx/latest/LustreGuide/cw-event-logging.html).
type LustreLogConfiguration struct {

	// The data repository events that are logged by Amazon FSx.
	//
	// * WARN_ONLY - only
	// warning events are logged.
	//
	// * ERROR_ONLY - only error events are logged.
	//
	// *
	// WARN_ERROR - both warning events and error events are logged.
	//
	// * DISABLED -
	// logging of data repository events is turned off.
	//
	// This member is required.
	Level LustreAccessAuditLogLevel

	// The Amazon Resource Name (ARN) that specifies the destination of the logs. The
	// destination can be any Amazon CloudWatch Logs log group ARN. The destination ARN
	// must be in the same Amazon Web Services partition, Amazon Web Services Region,
	// and Amazon Web Services account as your Amazon FSx file system.
	Destination *string

	noSmithyDocumentSerde
}

// The Lustre logging configuration used when creating or updating an Amazon FSx
// for Lustre file system. Lustre logging writes the enabled logging events for
// your file system to Amazon CloudWatch Logs. Error and warning events can be
// logged from the following data repository operations:
//
// * Automatic export
//
// *
// Data repository tasks
//
// To learn more about Lustre logging, see Logging to Amazon
// CloudWatch Logs
// (https://docs.aws.amazon.com/fsx/latest/LustreGuide/cw-event-logging.html).
type LustreLogCreateConfiguration struct {

	// Sets which data repository events are logged by Amazon FSx.
	//
	// * WARN_ONLY - only
	// warning events are logged.
	//
	// * ERROR_ONLY - only error events are logged.
	//
	// *
	// WARN_ERROR - both warning events and error events are logged.
	//
	// * DISABLED -
	// logging of data repository events is turned off.
	//
	// This member is required.
	Level LustreAccessAuditLogLevel

	// The Amazon Resource Name (ARN) that specifies the destination of the logs. The
	// destination can be any Amazon CloudWatch Logs log group ARN, with the following
	// requirements:
	//
	// * The destination ARN that you provide must be in the same Amazon
	// Web Services partition, Amazon Web Services Region, and Amazon Web Services
	// account as your Amazon FSx file system.
	//
	// * The name of the Amazon CloudWatch
	// Logs log group must begin with the /aws/fsx prefix.
	//
	// * If you do not provide a
	// destination, Amazon FSx will create and use a log stream in the CloudWatch Logs
	// /aws/fsx/lustre log group.
	//
	// * If Destination is provided and the resource does
	// not exist, the request will fail with a BadRequest error.
	//
	// * If Level is set to
	// DISABLED, you cannot specify a destination in Destination.
	Destination *string

	noSmithyDocumentSerde
}

// The configuration for Lustre root squash used to restrict root-level access from
// clients that try to access your FSx for Lustre file system as root. Use the
// RootSquash parameter to enable root squash. To learn more about Lustre root
// squash, see Lustre root squash
// (https://docs.aws.amazon.com/fsx/latest/LustreGuide/root-squash.html). You can
// also use the NoSquashNids parameter to provide an array of clients who are not
// affected by the root squash setting. These clients will access the file system
// as root, with unrestricted privileges.
type LustreRootSquashConfiguration struct {

	// When root squash is enabled, you can optionally specify an array of NIDs of
	// clients for which root squash does not apply. A client NID is a Lustre Network
	// Identifier used to uniquely identify a client. You can specify the NID as either
	// a single address or a range of addresses:
	//
	// * A single address is described in
	// standard Lustre NID format by specifying the client’s IP address followed by the
	// Lustre network ID (for example, 10.0.1.6@tcp).
	//
	// * An address range is described
	// using a dash to separate the range (for example, 10.0.[2-10].[1-255]@tcp).
	NoSquashNids []string

	// You enable root squash by setting a user ID (UID) and group ID (GID) for the
	// file system in the format UID:GID (for example, 365534:65534). The UID and GID
	// values can range from 0 to 4294967294:
	//
	// * A non-zero value for UID and GID
	// enables root squash. The UID and GID values can be different, but each must be a
	// non-zero value.
	//
	// * A value of 0 (zero) for UID and GID indicates root, and
	// therefore disables root squash.
	//
	// When root squash is enabled, the user ID and
	// group ID of a root user accessing the file system are re-mapped to the UID and
	// GID you provide.
	RootSquash *string

	noSmithyDocumentSerde
}

// Configuration for the FSx for NetApp ONTAP file system.
type OntapFileSystemConfiguration struct {

	// The number of days to retain automatic backups. Setting this property to 0
	// disables automatic backups. You can retain automatic backups for a maximum of 90
	// days. The default is 0.
	AutomaticBackupRetentionDays *int32

	// A recurring daily time, in the format HH:MM. HH is the zero-padded hour of the
	// day (0-23), and MM is the zero-padded minute of the hour. For example, 05:00
	// specifies 5 AM daily.
	DailyAutomaticBackupStartTime *string

	// Specifies the FSx for ONTAP file system deployment type in use in the file
	// system.
	//
	// * MULTI_AZ_1 - (Default) A high availability file system configured for
	// Multi-AZ redundancy to tolerate temporary Availability Zone (AZ)
	// unavailability.
	//
	// * SINGLE_AZ_1 - A file system configured for Single-AZ
	// redundancy.
	//
	// For information about the use cases for Multi-AZ and Single-AZ
	// deployments, refer to Choosing Multi-AZ or Single-AZ file system deployment
	// (https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/high-availability-multiAZ.html).
	DeploymentType OntapDeploymentType

	// The SSD IOPS configuration for the ONTAP file system, specifying the number of
	// provisioned IOPS and the provision mode.
	DiskIopsConfiguration *DiskIopsConfiguration

	// (Multi-AZ only) The IP address range in which the endpoints to access your file
	// system are created. The Endpoint IP address range you select for your file
	// system must exist outside the VPC's CIDR range and must be at least /30 or
	// larger. If you do not specify this optional parameter, Amazon FSx will
	// automatically select a CIDR block for you.
	EndpointIpAddressRange *string

	// The Management and Intercluster endpoints that are used to access data or to
	// manage the file system using the NetApp ONTAP CLI, REST API, or NetApp
	// SnapMirror.
	Endpoints *FileSystemEndpoints

	// The ID for a subnet. A subnet is a range of IP addresses in your virtual private
	// cloud (VPC). For more information, see VPC and subnets
	// (https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Subnets.html) in the
	// Amazon VPC User Guide.
	PreferredSubnetId *string

	// (Multi-AZ only) The VPC route tables in which your file system's endpoints are
	// created.
	RouteTableIds []string

	// The sustained throughput of an Amazon FSx file system in Megabytes per second
	// (MBps).
	ThroughputCapacity *int32

	// A recurring weekly time, in the format D:HH:MM. D is the day of the week, for
	// which 1 represents Monday and 7 represents Sunday. For further details, see the
	// ISO-8601 spec as described on Wikipedia
	// (https://en.wikipedia.org/wiki/ISO_week_date). HH is the zero-padded hour of the
	// day (0-23), and MM is the zero-padded minute of the hour. For example, 1:05:00
	// specifies maintenance at 5 AM Monday.
	WeeklyMaintenanceStartTime *string

	noSmithyDocumentSerde
}

// The configuration of an Amazon FSx for NetApp ONTAP volume.
type OntapVolumeConfiguration struct {

	// Specifies the FlexCache endpoint type of the volume. Valid values are the
	// following:
	//
	// * NONE specifies that the volume doesn't have a FlexCache
	// configuration. NONE is the default.
	//
	// * ORIGIN specifies that the volume is the
	// origin volume for a FlexCache volume.
	//
	// * CACHE specifies that the volume is a
	// FlexCache volume.
	FlexCacheEndpointType FlexCacheEndpointType

	// Specifies the directory that network-attached storage (NAS) clients use to mount
	// the volume, along with the storage virtual machine (SVM) Domain Name System
	// (DNS) name or IP address. You can create a JunctionPath directly below a parent
	// volume junction or on a directory within a volume. A JunctionPath for a volume
	// named vol3 might be /vol1/vol2/vol3, or /vol1/dir2/vol3, or even
	// /dir1/dir2/vol3.
	JunctionPath *string

	// Specifies the type of volume. Valid values are the following:
	//
	// * RW specifies a
	// read/write volume. RW is the default.
	//
	// * DP specifies a data-protection volume.
	// You can protect data by replicating it to data-protection mirror copies. If a
	// disaster occurs, you can use these data-protection mirror copies to recover
	// data.
	//
	// * LS specifies a load-sharing mirror volume. A load-sharing mirror
	// reduces the network traffic to a FlexVol volume by providing additional
	// read-only access to clients.
	OntapVolumeType OntapVolumeType

	// The security style for the volume, which can be UNIX, NTFS, or MIXED.
	SecurityStyle SecurityStyle

	// The configured size of the volume, in megabytes (MBs).
	SizeInMegabytes *int32

	// The volume's storage efficiency setting.
	StorageEfficiencyEnabled *bool

	// The ID of the volume's storage virtual machine.
	StorageVirtualMachineId *string

	// A Boolean flag indicating whether this volume is the root volume for its storage
	// virtual machine (SVM). Only one volume on an SVM can be the root volume. This
	// value defaults to false. If this value is true, then this is the SVM root
	// volume. This flag is useful when you're deleting an SVM, because you must first
	// delete all non-root volumes. This flag, when set to false, helps you identify
	// which volumes to delete before you can delete the SVM.
	StorageVirtualMachineRoot *bool

	// The volume's TieringPolicy setting.
	TieringPolicy *TieringPolicy

	// The volume's universally unique identifier (UUID).
	UUID *string

	noSmithyDocumentSerde
}

// Specifies who can mount an OpenZFS file system and the options available while
// mounting the file system.
type OpenZFSClientConfiguration struct {

	// A value that specifies who can mount the file system. You can provide a wildcard
	// character (*), an IP address (0.0.0.0), or a CIDR address (192.0.2.0/24). By
	// default, Amazon FSx uses the wildcard character when specifying the client.
	//
	// This member is required.
	Clients *string

	// The options to use when mounting the file system. For a list of options that you
	// can use with Network File System (NFS), see the exports(5) - Linux man page
	// (https://linux.die.net/man/5/exports). When choosing your options, consider the
	// following:
	//
	// * crossmnt is used by default. If you don't specify crossmnt when
	// changing the client configuration, you won't be able to see or access snapshots
	// in your file system's snapshot directory.
	//
	// * sync is used by default. If you
	// instead specify async, the system acknowledges writes before writing to disk. If
	// the system crashes before the writes are finished, you lose the unwritten data.
	//
	// This member is required.
	Options []string

	noSmithyDocumentSerde
}

// The configuration of an Amazon FSx for OpenZFS root volume.
type OpenZFSCreateRootVolumeConfiguration struct {

	// A Boolean value indicating whether tags for the volume should be copied to
	// snapshots of the volume. This value defaults to false. If it's set to true, all
	// tags for the volume are copied to snapshots where the user doesn't specify tags.
	// If this value is true and you specify one or more tags, only the specified tags
	// are copied to snapshots. If you specify one or more tags when creating the
	// snapshot, no tags are copied from the volume, regardless of this value.
	CopyTagsToSnapshots *bool

	// Specifies the method used to compress the data on the volume. The compression
	// type is NONE by default.
	//
	// * NONE - Doesn't compress the data on the volume. NONE
	// is the default.
	//
	// * ZSTD - Compresses the data in the volume using the Zstandard
	// (ZSTD) compression algorithm. Compared to LZ4, Z-Standard provides a better
	// compression ratio to minimize on-disk storage utilization.
	//
	// * LZ4 - Compresses
	// the data in the volume using the LZ4 compression algorithm. Compared to
	// Z-Standard, LZ4 is less compute-intensive and delivers higher write throughput
	// speeds.
	DataCompressionType OpenZFSDataCompressionType

	// The configuration object for mounting a file system.
	NfsExports []OpenZFSNfsExport

	// A Boolean value indicating whether the volume is read-only. Setting this value
	// to true can be useful after you have completed changes to a volume and no longer
	// want changes to occur.
	ReadOnly *bool

	// Specifies the record size of an OpenZFS root volume, in kibibytes (KiB). Valid
	// values are 4, 8, 16, 32, 64, 128, 256, 512, or 1024 KiB. The default is 128 KiB.
	// Most workloads should use the default record size. Database workflows can
	// benefit from a smaller record size, while streaming workflows can benefit from a
	// larger record size. For additional guidance on setting a custom record size, see
	// Tips for maximizing performance
	// (https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/performance.html#performance-tips-zfs)
	// in the Amazon FSx for OpenZFS User Guide.
	RecordSizeKiB *int32

	// An object specifying how much storage users or groups can use on the volume.
	UserAndGroupQuotas []OpenZFSUserOrGroupQuota

	noSmithyDocumentSerde
}

// The configuration for the Amazon FSx for OpenZFS file system.
type OpenZFSFileSystemConfiguration struct {

	// The number of days to retain automatic backups. Setting this property to 0
	// disables automatic backups. You can retain automatic backups for a maximum of 90
	// days. The default is 0.
	AutomaticBackupRetentionDays *int32

	// A Boolean value indicating whether tags on the file system should be copied to
	// backups. If it's set to true, all tags on the file system are copied to all
	// automatic backups and any user-initiated backups where the user doesn't specify
	// any tags. If this value is true and you specify one or more tags, only the
	// specified tags are copied to backups. If you specify one or more tags when
	// creating a user-initiated backup, no tags are copied from the file system,
	// regardless of this value.
	CopyTagsToBackups *bool

	// A Boolean value indicating whether tags for the volume should be copied to
	// snapshots. This value defaults to false. If it's set to true, all tags for the
	// volume are copied to snapshots where the user doesn't specify tags. If this
	// value is true and you specify one or more tags, only the specified tags are
	// copied to snapshots. If you specify one or more tags when creating the snapshot,
	// no tags are copied from the volume, regardless of this value.
	CopyTagsToVolumes *bool

	// A recurring daily time, in the format HH:MM. HH is the zero-padded hour of the
	// day (0-23), and MM is the zero-padded minute of the hour. For example, 05:00
	// specifies 5 AM daily.
	DailyAutomaticBackupStartTime *string

	// Specifies the file-system deployment type. Amazon FSx for OpenZFS supports
	// SINGLE_AZ_1. SINGLE_AZ_1 is a file system configured for a single Availability
	// Zone (AZ) of redundancy.
	DeploymentType OpenZFSDeploymentType

	// The SSD IOPS (input/output operations per second) configuration for an Amazon
	// FSx for NetApp ONTAP or Amazon FSx for OpenZFS file system. The default is 3
	// IOPS per GB of storage capacity, but you can provision additional IOPS per GB of
	// storage. The configuration consists of the total number of provisioned SSD IOPS
	// and how the amount was provisioned (by the customer or by the system).
	DiskIopsConfiguration *DiskIopsConfiguration

	// The ID of the root volume of the OpenZFS file system.
	RootVolumeId *string

	// The throughput of an Amazon FSx file system, measured in megabytes per second
	// (MBps). Valid values are 64, 128, 256, 512, 1024, 2048, 3072, or 4096 MB/s.
	ThroughputCapacity *int32

	// A recurring weekly time, in the format D:HH:MM. D is the day of the week, for
	// which 1 represents Monday and 7 represents Sunday. For further details, see the
	// ISO-8601 spec as described on Wikipedia
	// (https://en.wikipedia.org/wiki/ISO_week_date). HH is the zero-padded hour of the
	// day (0-23), and MM is the zero-padded minute of the hour. For example, 1:05:00
	// specifies maintenance at 5 AM Monday.
	WeeklyMaintenanceStartTime *string

	noSmithyDocumentSerde
}

// The Network File System (NFS) configurations for mounting an Amazon FSx for
// OpenZFS file system.
type OpenZFSNfsExport struct {

	// A list of configuration objects that contain the client and options for mounting
	// the OpenZFS file system.
	//
	// This member is required.
	ClientConfigurations []OpenZFSClientConfiguration

	noSmithyDocumentSerde
}

// The snapshot configuration to use when creating an OpenZFS volume from a
// snapshot.
type OpenZFSOriginSnapshotConfiguration struct {

	// The strategy used when copying data from the snapshot to the new volume.
	//
	// *
	// CLONE - The new volume references the data in the origin snapshot. Cloning a
	// snapshot is faster than copying the data from a snapshot to a new volume and
	// doesn't consume disk throughput. However, the origin snapshot can't be deleted
	// if there is a volume using its copied data.
	//
	// * FULL_COPY - Copies all data from
	// the snapshot to the new volume.
	CopyStrategy OpenZFSCopyStrategy

	// The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify
	// Amazon Web Services resources. We require an ARN when you need to specify a
	// resource unambiguously across all of Amazon Web Services. For more information,
	// see Amazon Resource Names (ARNs)
	// (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in
	// the Amazon Web Services General Reference.
	SnapshotARN *string

	noSmithyDocumentSerde
}

// The configuration for how much storage a user or group can use on the volume.
type OpenZFSUserOrGroupQuota struct {

	// The ID of the user or group.
	//
	// This member is required.
	Id *int32

	// The amount of storage that the user or group can use in gibibytes (GiB).
	//
	// This member is required.
	StorageCapacityQuotaGiB *int32

	// A value that specifies whether the quota applies to a user or group.
	//
	// This member is required.
	Type OpenZFSQuotaType

	noSmithyDocumentSerde
}

// The configuration of an Amazon FSx for OpenZFS volume.
type OpenZFSVolumeConfiguration struct {

	// A Boolean value indicating whether tags for the volume should be copied to
	// snapshots. This value defaults to false. If it's set to true, all tags for the
	// volume are copied to snapshots where the user doesn't specify tags. If this
	// value is true and you specify one or more tags, only the specified tags are
	// copied to snapshots. If you specify one or more tags when creating the snapshot,
	// no tags are copied from the volume, regardless of this value.
	CopyTagsToSnapshots *bool

	// Specifies the method used to compress the data on the volume. The compression
	// type is NONE by default.
	//
	// * NONE - Doesn't compress the data on the volume. NONE
	// is the default.
	//
	// * ZSTD - Compresses the data in the volume using the Zstandard
	// (ZSTD) compression algorithm. Compared to LZ4, Z-Standard provides a better
	// compression ratio to minimize on-disk storage utilization.
	//
	// * LZ4 - Compresses
	// the data in the volume using the LZ4 compression algorithm. Compared to
	// Z-Standard, LZ4 is less compute-intensive and delivers higher write throughput
	// speeds.
	DataCompressionType OpenZFSDataCompressionType

	// The configuration object for mounting a Network File System (NFS) file system.
	NfsExports []OpenZFSNfsExport

	// The configuration object that specifies the snapshot to use as the origin of the
	// data for the volume.
	OriginSnapshot *OpenZFSOriginSnapshotConfiguration

	// The ID of the parent volume.
	ParentVolumeId *string

	// A Boolean value indicating whether the volume is read-only.
	ReadOnly *bool

	// The record size of an OpenZFS volume, in kibibytes (KiB). Valid values are 4, 8,
	// 16, 32, 64, 128, 256, 512, or 1024 KiB. The default is 128 KiB. Most workloads
	// should use the default record size. For guidance on when to set a custom record
	// size, see the Amazon FSx for OpenZFS User Guide.
	RecordSizeKiB *int32

	// The maximum amount of storage in gibibtyes (GiB) that the volume can use from
	// its parent. You can specify a quota larger than the storage on the parent
	// volume.
	StorageCapacityQuotaGiB *int32

	// The amount of storage in gibibytes (GiB) to reserve from the parent volume. You
	// can't reserve more storage than the parent volume has reserved.
	StorageCapacityReservationGiB *int32

	// An object specifying how much storage users or groups can use on the volume.
	UserAndGroupQuotas []OpenZFSUserOrGroupQuota

	// The path to the volume from the root volume. For example,
	// fsx/parentVolume/volume1.
	VolumePath *string

	noSmithyDocumentSerde
}

// The configuration for an Amazon S3 data repository linked to an Amazon FSx
// Lustre file system with a data repository association. The configuration
// consists of an AutoImportPolicy that defines file events on the data repository
// are automatically imported to the file system and an AutoExportPolicy that
// defines which file events on the file system are automatically exported to the
// data repository. File events are when files or directories are added, changed,
// or deleted on the file system or the data repository.
type S3DataRepositoryConfiguration struct {

	// Specifies the type of updated objects (new, changed, deleted) that will be
	// automatically exported from your file system to the linked S3 bucket.
	AutoExportPolicy *AutoExportPolicy

	// Specifies the type of updated objects (new, changed, deleted) that will be
	// automatically imported from the linked S3 bucket to your file system.
	AutoImportPolicy *AutoImportPolicy

	noSmithyDocumentSerde
}

// The configuration of the self-managed Microsoft Active Directory (AD) directory
// to which the Windows File Server or ONTAP storage virtual machine (SVM) instance
// is joined.
type SelfManagedActiveDirectoryAttributes struct {

	// A list of up to three IP addresses of DNS servers or domain controllers in the
	// self-managed AD directory.
	DnsIps []string

	// The fully qualified domain name of the self-managed AD directory.
	DomainName *string

	// The name of the domain group whose members have administrative privileges for
	// the FSx file system.
	FileSystemAdministratorsGroup *string

	// The fully qualified distinguished name of the organizational unit within the
	// self-managed AD directory to which the Windows File Server or ONTAP storage
	// virtual machine (SVM) instance is joined.
	OrganizationalUnitDistinguishedName *string

	// The user name for the service account on your self-managed AD domain that FSx
	// uses to join to your AD domain.
	UserName *string

	noSmithyDocumentSerde
}

// The configuration that Amazon FSx uses to join a FSx for Windows File Server
// file system or an ONTAP storage virtual machine (SVM) to a self-managed
// (including on-premises) Microsoft Active Directory (AD) directory. For more
// information, see  Using Amazon FSx with your self-managed Microsoft Active
// Directory
// (https://docs.aws.amazon.com/fsx/latest/WindowsGuide/self-managed-AD.html) or
// Managing SVMs
// (https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-svms.html).
type SelfManagedActiveDirectoryConfiguration struct {

	// A list of up to three IP addresses of DNS servers or domain controllers in the
	// self-managed AD directory.
	//
	// This member is required.
	DnsIps []string

	// The fully qualified domain name of the self-managed AD directory, such as
	// corp.example.com.
	//
	// This member is required.
	DomainName *string

	// The password for the service account on your self-managed AD domain that Amazon
	// FSx will use to join to your AD domain.
	//
	// This member is required.
	Password *string

	// The user name for the service account on your self-managed AD domain that Amazon
	// FSx will use to join to your AD domain. This account must have the permission to
	// join computers to the domain in the organizational unit provided in
	// OrganizationalUnitDistinguishedName, or in the default location of your AD
	// domain.
	//
	// This member is required.
	UserName *string

	// (Optional) The name of the domain group whose members are granted administrative
	// privileges for the file system. Administrative privileges include taking
	// ownership of files and folders, setting audit controls (audit ACLs) on files and
	// folders, and administering the file system remotely by using the FSx Remote
	// PowerShell. The group that you specify must already exist in your domain. If you
	// don't provide one, your AD domain's Domain Admins group is used.
	FileSystemAdministratorsGroup *string

	// (Optional) The fully qualified distinguished name of the organizational unit
	// within your self-managed AD directory. Amazon FSx only accepts OU as the direct
	// parent of the file system. An example is OU=FSx,DC=yourdomain,DC=corp,DC=com. To
	// learn more, see RFC 2253 (https://tools.ietf.org/html/rfc2253). If none is
	// provided, the FSx file system is created in the default location of your
	// self-managed AD directory. Only Organizational Unit (OU) objects can be the
	// direct parent of the file system that you're creating.
	OrganizationalUnitDistinguishedName *string

	noSmithyDocumentSerde
}

// The configuration that Amazon FSx uses to join the Windows File Server instance
// to a self-managed Microsoft Active Directory (AD) directory.
type SelfManagedActiveDirectoryConfigurationUpdates struct {

	// A list of up to three IP addresses of DNS servers or domain controllers in the
	// self-managed AD directory.
	DnsIps []string

	// The password for the service account on your self-managed AD domain that Amazon
	// FSx will use to join to your AD domain.
	Password *string

	// The user name for the service account on your self-managed AD domain that Amazon
	// FSx will use to join to your AD domain. This account must have the permission to
	// join computers to the domain in the organizational unit provided in
	// OrganizationalUnitDistinguishedName.
	UserName *string

	noSmithyDocumentSerde
}

// A snapshot of an Amazon FSx for OpenZFS volume.
type Snapshot struct {

	// A list of administrative actions for the file system that are in process or
	// waiting to be processed. Administrative actions describe changes to the Amazon
	// FSx system.
	AdministrativeActions []AdministrativeAction

	// The time that the resource was created, in seconds (since 1970-01-01T00:00:00Z),
	// also known as Unix time.
	CreationTime *time.Time

	// The lifecycle status of the snapshot.
	//
	// * PENDING - Amazon FSx hasn't started
	// creating the snapshot.
	//
	// * CREATING - Amazon FSx is creating the snapshot.
	//
	// *
	// DELETING - Amazon FSx is deleting the snapshot.
	//
	// * AVAILABLE - The snapshot is
	// fully available.
	Lifecycle SnapshotLifecycle

	// Describes why a resource lifecycle state changed.
	LifecycleTransitionReason *LifecycleTransitionReason

	// The name of the snapshot.
	Name *string

	// The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify
	// Amazon Web Services resources. We require an ARN when you need to specify a
	// resource unambiguously across all of Amazon Web Services. For more information,
	// see Amazon Resource Names (ARNs)
	// (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in
	// the Amazon Web Services General Reference.
	ResourceARN *string

	// The ID of the snapshot.
	SnapshotId *string

	// A list of Tag values, with a maximum of 50 elements.
	Tags []Tag

	// The ID of the volume that the snapshot is of.
	VolumeId *string

	noSmithyDocumentSerde
}

// A filter used to restrict the results of DescribeSnapshots calls. You can use
// multiple filters to return results that meet all applied filter requirements.
type SnapshotFilter struct {

	// The name of the filter to use. You can filter by the file-system-id or by
	// volume-id.
	Name SnapshotFilterName

	// The file-system-id or volume-id that you are filtering for.
	Values []string

	noSmithyDocumentSerde
}

// Describes the Amazon FSx for NetApp ONTAP storage virtual machine (SVM)
// configuration.
type StorageVirtualMachine struct {

	// Describes the Microsoft Active Directory configuration to which the SVM is
	// joined, if applicable.
	ActiveDirectoryConfiguration *SvmActiveDirectoryConfiguration

	// The time that the resource was created, in seconds (since 1970-01-01T00:00:00Z),
	// also known as Unix time.
	CreationTime *time.Time

	// The endpoints that are used to access data or to manage the SVM using the NetApp
	// ONTAP CLI, REST API, or NetApp CloudManager. They are the Iscsi, Management,
	// Nfs, and Smb endpoints.
	Endpoints *SvmEndpoints

	// The globally unique ID of the file system, assigned by Amazon FSx.
	FileSystemId *string

	// Describes the SVM's lifecycle status.
	//
	// * CREATED - The SVM is fully available
	// for use.
	//
	// * CREATING - Amazon FSx is creating the new SVM.
	//
	// * DELETING - Amazon
	// FSx is deleting an existing SVM.
	//
	// * FAILED - Amazon FSx was unable to create the
	// SVM.
	//
	// * MISCONFIGURED - The SVM is in a failed but recoverable state.
	//
	// * PENDING
	// - Amazon FSx has not started creating the SVM.
	Lifecycle StorageVirtualMachineLifecycle

	// Describes why the SVM lifecycle state changed.
	LifecycleTransitionReason *LifecycleTransitionReason

	// The name of the SVM, if provisioned.
	Name *string

	// The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify
	// Amazon Web Services resources. We require an ARN when you need to specify a
	// resource unambiguously across all of Amazon Web Services. For more information,
	// see Amazon Resource Names (ARNs)
	// (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in
	// the Amazon Web Services General Reference.
	ResourceARN *string

	// The security style of the root volume of the SVM.
	RootVolumeSecurityStyle StorageVirtualMachineRootVolumeSecurityStyle

	// The SVM's system generated unique ID.
	StorageVirtualMachineId *string

	// Describes the SVM's subtype.
	Subtype StorageVirtualMachineSubtype

	// A list of Tag values, with a maximum of 50 elements.
	Tags []Tag

	// The SVM's UUID (universally unique identifier).
	UUID *string

	noSmithyDocumentSerde
}

// A filter used to restrict the results of describe calls for Amazon FSx for
// NetApp ONTAP storage virtual machines (SVMs). You can use multiple filters to
// return results that meet all applied filter requirements.
type StorageVirtualMachineFilter struct {

	// The name for this filter.
	Name StorageVirtualMachineFilterName

	// The values of the filter. These are all the values for any of the applied
	// filters.
	Values []string

	noSmithyDocumentSerde
}

// Describes the configuration of the Microsoft Active Directory (AD) directory to
// which the Amazon FSx for ONTAP storage virtual machine (SVM) is joined. Pleae
// note, account credentials are not returned in the response payload.
type SvmActiveDirectoryConfiguration struct {

	// The NetBIOS name of the Active Directory computer object that is joined to your
	// SVM.
	NetBiosName *string

	// The configuration of the self-managed Microsoft Active Directory (AD) directory
	// to which the Windows File Server or ONTAP storage virtual machine (SVM) instance
	// is joined.
	SelfManagedActiveDirectoryConfiguration *SelfManagedActiveDirectoryAttributes

	noSmithyDocumentSerde
}

// An Amazon FSx for NetApp ONTAP storage virtual machine (SVM) has four endpoints
// that are used to access data or to manage the SVM using the NetApp ONTAP CLI,
// REST API, or NetApp CloudManager. They are the Iscsi, Management, Nfs, and Smb
// endpoints.
type SvmEndpoint struct {

	// The Domain Name Service (DNS) name for the file system. You can mount your file
	// system using its DNS name.
	DNSName *string

	// The SVM endpoint's IP addresses.
	IpAddresses []string

	noSmithyDocumentSerde
}

// An Amazon FSx for NetApp ONTAP storage virtual machine (SVM) has the following
// endpoints that are used to access data or to manage the SVM using the NetApp
// ONTAP CLI, REST API, or NetApp CloudManager.
type SvmEndpoints struct {

	// An endpoint for connecting using the Internet Small Computer Systems Interface
	// (iSCSI) protocol.
	Iscsi *SvmEndpoint

	// An endpoint for managing SVMs using the NetApp ONTAP CLI, NetApp ONTAP API, or
	// NetApp CloudManager.
	Management *SvmEndpoint

	// An endpoint for connecting using the Network File System (NFS) protocol.
	Nfs *SvmEndpoint

	// An endpoint for connecting using the Server Message Block (SMB) protocol.
	Smb *SvmEndpoint

	noSmithyDocumentSerde
}

// Specifies a key-value pair for a resource tag.
type Tag struct {

	// A value that specifies the TagKey, the name of the tag. Tag keys must be unique
	// for the resource to which they are attached.
	//
	// This member is required.
	Key *string

	// A value that specifies the TagValue, the value assigned to the corresponding tag
	// key. Tag values can be null and don't have to be unique in a tag set. For
	// example, you can have a key-value pair in a tag set of finances : April and also
	// of payroll : April.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Describes the data tiering policy for an ONTAP volume. When enabled, Amazon FSx
// for ONTAP's intelligent tiering automatically transitions a volume's data
// between the file system's primary storage and capacity pool storage based on
// your access patterns. Valid tiering policies are the following:
//
// * SNAPSHOT_ONLY
// - (Default value) moves cold snapshots to the capacity pool storage tier.
//
// *
// AUTO - moves cold user data and snapshots to the capacity pool storage tier
// based on your access patterns.
//
// * ALL - moves all user data blocks in both the
// active file system and Snapshot copies to the storage pool tier.
//
// * NONE - keeps
// a volume's data in the primary storage tier, preventing it from being moved to
// the capacity pool tier.
type TieringPolicy struct {

	// Specifies the number of days that user data in a volume must remain inactive
	// before it is considered "cold" and moved to the capacity pool. Used with the
	// AUTO and SNAPSHOT_ONLY tiering policies. Enter a whole number between 2 and 183.
	// Default values are 31 days for AUTO and 2 days for SNAPSHOT_ONLY.
	CoolingPeriod *int32

	// Specifies the tiering policy used to transition data. Default value is
	// SNAPSHOT_ONLY.
	//
	// * SNAPSHOT_ONLY - moves cold snapshots to the capacity pool
	// storage tier.
	//
	// * AUTO - moves cold user data and snapshots to the capacity pool
	// storage tier based on your access patterns.
	//
	// * ALL - moves all user data blocks
	// in both the active file system and Snapshot copies to the storage pool tier.
	//
	// *
	// NONE - keeps a volume's data in the primary storage tier, preventing it from
	// being moved to the capacity pool tier.
	Name TieringPolicyName

	noSmithyDocumentSerde
}

// The configuration object for Amazon FSx for Lustre file systems used in the
// UpdateFileSystem operation.
type UpdateFileSystemLustreConfiguration struct {

	// (Optional) When you create your file system, your existing S3 objects appear as
	// file and directory listings. Use this property to choose how Amazon FSx keeps
	// your file and directory listing up to date as you add or modify objects in your
	// linked S3 bucket. AutoImportPolicy can have the following values:
	//
	// * NONE -
	// (Default) AutoImport is off. Amazon FSx only updates file and directory listings
	// from the linked S3 bucket when the file system is created. FSx does not update
	// the file and directory listing for any new or changed objects after choosing
	// this option.
	//
	// * NEW - AutoImport is on. Amazon FSx automatically imports
	// directory listings of any new objects added to the linked S3 bucket that do not
	// currently exist in the FSx file system.
	//
	// * NEW_CHANGED - AutoImport is on.
	// Amazon FSx automatically imports file and directory listings of any new objects
	// added to the S3 bucket and any existing objects that are changed in the S3
	// bucket after you choose this option.
	//
	// * NEW_CHANGED_DELETED - AutoImport is on.
	// Amazon FSx automatically imports file and directory listings of any new objects
	// added to the S3 bucket, any existing objects that are changed in the S3 bucket,
	// and any objects that were deleted in the S3 bucket.
	//
	// The AutoImportPolicy
	// parameter is not supported for Lustre file systems with the Persistent_2
	// deployment type. Instead, use to update a data repository association on your
	// Persistent_2 file system.
	AutoImportPolicy AutoImportPolicyType

	// The number of days to retain automatic backups. Setting this property to 0
	// disables automatic backups. You can retain automatic backups for a maximum of 90
	// days. The default is 0.
	AutomaticBackupRetentionDays *int32

	// A recurring daily time, in the format HH:MM. HH is the zero-padded hour of the
	// day (0-23), and MM is the zero-padded minute of the hour. For example, 05:00
	// specifies 5 AM daily.
	DailyAutomaticBackupStartTime *string

	// Sets the data compression configuration for the file system. DataCompressionType
	// can have the following values:
	//
	// * NONE - Data compression is turned off for the
	// file system.
	//
	// * LZ4 - Data compression is turned on with the LZ4 algorithm.
	//
	// If
	// you don't use DataCompressionType, the file system retains its current data
	// compression configuration. For more information, see Lustre data compression
	// (https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-compression.html).
	DataCompressionType DataCompressionType

	// The Lustre logging configuration used when updating an Amazon FSx for Lustre
	// file system. When logging is enabled, Lustre logs error and warning events for
	// data repositories associated with your file system to Amazon CloudWatch Logs.
	LogConfiguration *LustreLogCreateConfiguration

	// The Lustre root squash configuration used when updating an Amazon FSx for Lustre
	// file system. When enabled, root squash restricts root-level access from clients
	// that try to access your file system as a root user.
	RootSquashConfiguration *LustreRootSquashConfiguration

	// (Optional) The preferred start time to perform weekly maintenance, formatted
	// d:HH:MM in the UTC time zone. d is the weekday number, from 1 through 7,
	// beginning with Monday and ending with Sunday.
	WeeklyMaintenanceStartTime *string

	noSmithyDocumentSerde
}

// The configuration updates for an Amazon FSx for NetApp ONTAP file system.
type UpdateFileSystemOntapConfiguration struct {

	// The number of days to retain automatic backups. Setting this property to 0
	// disables automatic backups. You can retain automatic backups for a maximum of 90
	// days. The default is 0.
	AutomaticBackupRetentionDays *int32

	// A recurring daily time, in the format HH:MM. HH is the zero-padded hour of the
	// day (0-23), and MM is the zero-padded minute of the hour. For example, 05:00
	// specifies 5 AM daily.
	DailyAutomaticBackupStartTime *string

	// The SSD IOPS (input/output operations per second) configuration for an Amazon
	// FSx for NetApp ONTAP file system. The default is 3 IOPS per GB of storage
	// capacity, but you can provision additional IOPS per GB of storage. The
	// configuration consists of an IOPS mode (AUTOMATIC or USER_PROVISIONED), and in
	// the case of USER_PROVISIONED IOPS, the total number of SSD IOPS provisioned.
	DiskIopsConfiguration *DiskIopsConfiguration

	// The ONTAP administrative password for the fsxadmin user.
	FsxAdminPassword *string

	// Specifies the throughput of an FSx for NetApp ONTAP file system, measured in
	// megabytes per second (MBps). Valid values are 128, 256, 512, 1024, or 2048 MB/s.
	ThroughputCapacity *int32

	// A recurring weekly time, in the format D:HH:MM. D is the day of the week, for
	// which 1 represents Monday and 7 represents Sunday. For further details, see the
	// ISO-8601 spec as described on Wikipedia
	// (https://en.wikipedia.org/wiki/ISO_week_date). HH is the zero-padded hour of the
	// day (0-23), and MM is the zero-padded minute of the hour. For example, 1:05:00
	// specifies maintenance at 5 AM Monday.
	WeeklyMaintenanceStartTime *string

	noSmithyDocumentSerde
}

// The configuration updates for an Amazon FSx for OpenZFS file system.
type UpdateFileSystemOpenZFSConfiguration struct {

	// The number of days to retain automatic backups. Setting this property to 0
	// disables automatic backups. You can retain automatic backups for a maximum of 90
	// days. The default is 0.
	AutomaticBackupRetentionDays *int32

	// A Boolean value indicating whether tags for the file system should be copied to
	// backups. This value defaults to false. If it's set to true, all tags for the
	// file system are copied to all automatic and user-initiated backups where the
	// user doesn't specify tags. If this value is true and you specify one or more
	// tags, only the specified tags are copied to backups. If you specify one or more
	// tags when creating a user-initiated backup, no tags are copied from the file
	// system, regardless of this value.
	CopyTagsToBackups *bool

	// A Boolean value indicating whether tags for the volume should be copied to
	// snapshots. This value defaults to false. If it's set to true, all tags for the
	// volume are copied to snapshots where the user doesn't specify tags. If this
	// value is true and you specify one or more tags, only the specified tags are
	// copied to snapshots. If you specify one or more tags when creating the snapshot,
	// no tags are copied from the volume, regardless of this value.
	CopyTagsToVolumes *bool

	// A recurring daily time, in the format HH:MM. HH is the zero-padded hour of the
	// day (0-23), and MM is the zero-padded minute of the hour. For example, 05:00
	// specifies 5 AM daily.
	DailyAutomaticBackupStartTime *string

	// The SSD IOPS (input/output operations per second) configuration for an Amazon
	// FSx for NetApp ONTAP or Amazon FSx for OpenZFS file system. The default is 3
	// IOPS per GB of storage capacity, but you can provision additional IOPS per GB of
	// storage. The configuration consists of the total number of provisioned SSD IOPS
	// and how the amount was provisioned (by the customer or by the system).
	DiskIopsConfiguration *DiskIopsConfiguration

	// The throughput of an Amazon FSx file system, measured in megabytes per second
	// (MBps). Valid values are 64, 128, 256, 512, 1024, 2048, 3072, or 4096 MB/s.
	ThroughputCapacity *int32

	// A recurring weekly time, in the format D:HH:MM. D is the day of the week, for
	// which 1 represents Monday and 7 represents Sunday. For further details, see the
	// ISO-8601 spec as described on Wikipedia
	// (https://en.wikipedia.org/wiki/ISO_week_date). HH is the zero-padded hour of the
	// day (0-23), and MM is the zero-padded minute of the hour. For example, 1:05:00
	// specifies maintenance at 5 AM Monday.
	WeeklyMaintenanceStartTime *string

	noSmithyDocumentSerde
}

// Updates the configuration for an existing Amazon FSx for Windows File Server
// file system. Amazon FSx only overwrites existing properties with non-null values
// provided in the request.
type UpdateFileSystemWindowsConfiguration struct {

	// The configuration that Amazon FSx for Windows File Server uses to audit and log
	// user accesses of files, folders, and file shares on the Amazon FSx for Windows
	// File Server file system..
	AuditLogConfiguration *WindowsAuditLogCreateConfiguration

	// The number of days to retain automatic daily backups. Setting this to zero (0)
	// disables automatic daily backups. You can retain automatic daily backups for a
	// maximum of 90 days. For more information, see Working with Automatic Daily
	// Backups
	// (https://docs.aws.amazon.com/fsx/latest/WindowsGuide/using-backups.html#automatic-backups).
	AutomaticBackupRetentionDays *int32

	// The preferred time to start the daily automatic backup, in the UTC time zone,
	// for example, 02:00
	DailyAutomaticBackupStartTime *string

	// The configuration Amazon FSx uses to join the Windows File Server instance to
	// the self-managed Microsoft AD directory. You cannot make a self-managed
	// Microsoft AD update request if there is an existing self-managed Microsoft AD
	// update request in progress.
	SelfManagedActiveDirectoryConfiguration *SelfManagedActiveDirectoryConfigurationUpdates

	// Sets the target value for a file system's throughput capacity, in MB/s, that you
	// are updating the file system to. Valid values are 8, 16, 32, 64, 128, 256, 512,
	// 1024, 2048. You cannot make a throughput capacity update request if there is an
	// existing throughput capacity update request in progress. For more information,
	// see Managing Throughput Capacity
	// (https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-throughput-capacity.html).
	ThroughputCapacity *int32

	// The preferred start time to perform weekly maintenance, formatted d:HH:MM in the
	// UTC time zone. Where d is the weekday number, from 1 through 7, with 1 = Monday
	// and 7 = Sunday.
	WeeklyMaintenanceStartTime *string

	noSmithyDocumentSerde
}

// Used to specify changes to the ONTAP configuration for the volume you are
// updating.
type UpdateOntapVolumeConfiguration struct {

	// Specifies the location in the SVM's namespace where the volume is mounted. The
	// JunctionPath must have a leading forward slash, such as /vol3.
	JunctionPath *string

	// The security style for the volume, which can be UNIX. NTFS, or MIXED.
	SecurityStyle SecurityStyle

	// Specifies the size of the volume in megabytes.
	SizeInMegabytes *int32

	// Default is false. Set to true to enable the deduplication, compression, and
	// compaction storage efficiency features on the volume.
	StorageEfficiencyEnabled *bool

	// Update the volume's data tiering policy.
	TieringPolicy *TieringPolicy

	noSmithyDocumentSerde
}

// Used to specify changes to the OpenZFS configuration for the volume that you are
// updating.
type UpdateOpenZFSVolumeConfiguration struct {

	// Specifies the method used to compress the data on the volume. The compression
	// type is NONE by default.
	//
	// * NONE - Doesn't compress the data on the volume. NONE
	// is the default.
	//
	// * ZSTD - Compresses the data in the volume using the Zstandard
	// (ZSTD) compression algorithm. Compared to LZ4, Z-Standard provides a better
	// compression ratio to minimize on-disk storage utilization.
	//
	// * LZ4 - Compresses
	// the data in the volume using the LZ4 compression algorithm. Compared to
	// Z-Standard, LZ4 is less compute-intensive and delivers higher write throughput
	// speeds.
	DataCompressionType OpenZFSDataCompressionType

	// The configuration object for mounting a Network File System (NFS) file system.
	NfsExports []OpenZFSNfsExport

	// A Boolean value indicating whether the volume is read-only.
	ReadOnly *bool

	// Specifies the record size of an OpenZFS volume, in kibibytes (KiB). Valid values
	// are 4, 8, 16, 32, 64, 128, 256, 512, or 1024 KiB. The default is 128 KiB. Most
	// workloads should use the default record size. Database workflows can benefit
	// from a smaller record size, while streaming workflows can benefit from a larger
	// record size. For additional guidance on when to set a custom record size, see
	// Tips for maximizing performance
	// (https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/performance.html#performance-tips-zfs)
	// in the Amazon FSx for OpenZFS User Guide.
	RecordSizeKiB *int32

	// The maximum amount of storage in gibibytes (GiB) that the volume can use from
	// its parent. You can specify a quota larger than the storage on the parent
	// volume. You can specify a value of -1 to unset a volume's storage capacity
	// quota.
	StorageCapacityQuotaGiB *int32

	// The amount of storage in gibibytes (GiB) to reserve from the parent volume. You
	// can't reserve more storage than the parent volume has reserved. You can specify
	// a value of -1 to unset a volume's storage capacity reservation.
	StorageCapacityReservationGiB *int32

	// An object specifying how much storage users or groups can use on the volume.
	UserAndGroupQuotas []OpenZFSUserOrGroupQuota

	noSmithyDocumentSerde
}

// Updates the Microsoft Active Directory (AD) configuration of an SVM joined to an
// AD. Please note, account credentials are not returned in the response payload.
type UpdateSvmActiveDirectoryConfiguration struct {

	// The configuration that Amazon FSx uses to join the Windows File Server instance
	// to a self-managed Microsoft Active Directory (AD) directory.
	SelfManagedActiveDirectoryConfiguration *SelfManagedActiveDirectoryConfigurationUpdates

	noSmithyDocumentSerde
}

// Describes an Amazon FSx for NetApp ONTAP or Amazon FSx for OpenZFS volume.
type Volume struct {

	// A list of administrative actions for the file system that are in process or
	// waiting to be processed. Administrative actions describe changes to the Amazon
	// FSx system that you initiated.
	AdministrativeActions []AdministrativeAction

	// The time that the resource was created, in seconds (since 1970-01-01T00:00:00Z),
	// also known as Unix time.
	CreationTime *time.Time

	// The globally unique ID of the file system, assigned by Amazon FSx.
	FileSystemId *string

	// The lifecycle status of the volume.
	//
	// * AVAILABLE - The volume is fully available
	// for use.
	//
	// * CREATED - The volume has been created.
	//
	// * CREATING - Amazon FSx is
	// creating the new volume.
	//
	// * DELETING - Amazon FSx is deleting an existing
	// volume.
	//
	// * FAILED - Amazon FSx was unable to create the volume.
	//
	// * MISCONFIGURED
	// - The volume is in a failed but recoverable state.
	//
	// * PENDING - Amazon FSx
	// hasn't started creating the volume.
	Lifecycle VolumeLifecycle

	// The reason why the volume lifecycle status changed.
	LifecycleTransitionReason *LifecycleTransitionReason

	// The name of the volume.
	Name *string

	// The configuration of an Amazon FSx for NetApp ONTAP volume.
	OntapConfiguration *OntapVolumeConfiguration

	// The configuration of an Amazon FSx for OpenZFS volume.
	OpenZFSConfiguration *OpenZFSVolumeConfiguration

	// The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify
	// Amazon Web Services resources. We require an ARN when you need to specify a
	// resource unambiguously across all of Amazon Web Services. For more information,
	// see Amazon Resource Names (ARNs)
	// (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in
	// the Amazon Web Services General Reference.
	ResourceARN *string

	// A list of Tag values, with a maximum of 50 elements.
	Tags []Tag

	// The system-generated, unique ID of the volume.
	VolumeId *string

	// The type of the volume.
	VolumeType VolumeType

	noSmithyDocumentSerde
}

// A filter used to restrict the results of describe calls for Amazon FSx for
// NetApp ONTAP or Amazon FSx for OpenZFS volumes. You can use multiple filters to
// return results that meet all applied filter requirements.
type VolumeFilter struct {

	// The name for this filter.
	Name VolumeFilterName

	// The values of the filter. These are all the values for any of the applied
	// filters.
	Values []string

	noSmithyDocumentSerde
}

// The configuration that Amazon FSx for Windows File Server uses to audit and log
// user accesses of files, folders, and file shares on the Amazon FSx for Windows
// File Server file system. For more information, see  File access auditing
// (https://docs.aws.amazon.com/fsx/latest/WindowsGuide/file-access-auditing.html).
type WindowsAuditLogConfiguration struct {

	// Sets which attempt type is logged by Amazon FSx for file and folder accesses.
	//
	// *
	// SUCCESS_ONLY - only successful attempts to access files or folders are
	// logged.
	//
	// * FAILURE_ONLY - only failed attempts to access files or folders are
	// logged.
	//
	// * SUCCESS_AND_FAILURE - both successful attempts and failed attempts to
	// access files or folders are logged.
	//
	// * DISABLED - access auditing of files and
	// folders is turned off.
	//
	// This member is required.
	FileAccessAuditLogLevel WindowsAccessAuditLogLevel

	// Sets which attempt type is logged by Amazon FSx for file share accesses.
	//
	// *
	// SUCCESS_ONLY - only successful attempts to access file shares are logged.
	//
	// *
	// FAILURE_ONLY - only failed attempts to access file shares are logged.
	//
	// *
	// SUCCESS_AND_FAILURE - both successful attempts and failed attempts to access
	// file shares are logged.
	//
	// * DISABLED - access auditing of file shares is turned
	// off.
	//
	// This member is required.
	FileShareAccessAuditLogLevel WindowsAccessAuditLogLevel

	// The Amazon Resource Name (ARN) for the destination of the audit logs. The
	// destination can be any Amazon CloudWatch Logs log group ARN or Amazon Kinesis
	// Data Firehose delivery stream ARN. The name of the Amazon CloudWatch Logs log
	// group must begin with the /aws/fsx prefix. The name of the Amazon Kinesis Data
	// Firehouse delivery stream must begin with the aws-fsx prefix. The destination
	// ARN (either CloudWatch Logs log group or Kinesis Data Firehose delivery stream)
	// must be in the same Amazon Web Services partition, Amazon Web Services Region,
	// and Amazon Web Services account as your Amazon FSx file system.
	AuditLogDestination *string

	noSmithyDocumentSerde
}

// The Windows file access auditing configuration used when creating or updating an
// Amazon FSx for Windows File Server file system.
type WindowsAuditLogCreateConfiguration struct {

	// Sets which attempt type is logged by Amazon FSx for file and folder accesses.
	//
	// *
	// SUCCESS_ONLY - only successful attempts to access files or folders are
	// logged.
	//
	// * FAILURE_ONLY - only failed attempts to access files or folders are
	// logged.
	//
	// * SUCCESS_AND_FAILURE - both successful attempts and failed attempts to
	// access files or folders are logged.
	//
	// * DISABLED - access auditing of files and
	// folders is turned off.
	//
	// This member is required.
	FileAccessAuditLogLevel WindowsAccessAuditLogLevel

	// Sets which attempt type is logged by Amazon FSx for file share accesses.
	//
	// *
	// SUCCESS_ONLY - only successful attempts to access file shares are logged.
	//
	// *
	// FAILURE_ONLY - only failed attempts to access file shares are logged.
	//
	// *
	// SUCCESS_AND_FAILURE - both successful attempts and failed attempts to access
	// file shares are logged.
	//
	// * DISABLED - access auditing of file shares is turned
	// off.
	//
	// This member is required.
	FileShareAccessAuditLogLevel WindowsAccessAuditLogLevel

	// The Amazon Resource Name (ARN) that specifies the destination of the audit logs.
	// The destination can be any Amazon CloudWatch Logs log group ARN or Amazon
	// Kinesis Data Firehose delivery stream ARN, with the following requirements:
	//
	// *
	// The destination ARN that you provide (either CloudWatch Logs log group or
	// Kinesis Data Firehose delivery stream) must be in the same Amazon Web Services
	// partition, Amazon Web Services Region, and Amazon Web Services account as your
	// Amazon FSx file system.
	//
	// * The name of the Amazon CloudWatch Logs log group must
	// begin with the /aws/fsx prefix. The name of the Amazon Kinesis Data Firehouse
	// delivery stream must begin with the aws-fsx prefix.
	//
	// * If you do not provide a
	// destination in AuditLogDestination, Amazon FSx will create and use a log stream
	// in the CloudWatch Logs /aws/fsx/windows log group.
	//
	// * If AuditLogDestination is
	// provided and the resource does not exist, the request will fail with a
	// BadRequest error.
	//
	// * If FileAccessAuditLogLevel and FileShareAccessAuditLogLevel
	// are both set to DISABLED, you cannot specify a destination in
	// AuditLogDestination.
	AuditLogDestination *string

	noSmithyDocumentSerde
}

// The configuration for this Microsoft Windows file system.
type WindowsFileSystemConfiguration struct {

	// The ID for an existing Amazon Web Services Managed Microsoft Active Directory
	// instance that the file system is joined to.
	ActiveDirectoryId *string

	// An array of one or more DNS aliases that are currently associated with the
	// Amazon FSx file system. Aliases allow you to use existing DNS names to access
	// the data in your Amazon FSx file system. You can associate up to 50 aliases with
	// a file system at any time. You can associate additional DNS aliases after you
	// create the file system using the AssociateFileSystemAliases operation. You can
	// remove DNS aliases from the file system after it is created using the
	// DisassociateFileSystemAliases operation. You only need to specify the alias name
	// in the request payload. For more information, see DNS aliases
	// (https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html).
	Aliases []Alias

	// The configuration that Amazon FSx for Windows File Server uses to audit and log
	// user accesses of files, folders, and file shares on the Amazon FSx for Windows
	// File Server file system.
	AuditLogConfiguration *WindowsAuditLogConfiguration

	// The number of days to retain automatic backups. Setting this to 0 disables
	// automatic backups. You can retain automatic backups for a maximum of 90 days.
	AutomaticBackupRetentionDays *int32

	// A boolean flag indicating whether tags on the file system should be copied to
	// backups. This value defaults to false. If it's set to true, all tags on the file
	// system are copied to all automatic backups and any user-initiated backups where
	// the user doesn't specify any tags. If this value is true, and you specify one or
	// more tags, only the specified tags are copied to backups. If you specify one or
	// more tags when creating a user-initiated backup, no tags are copied from the
	// file system, regardless of this value.
	CopyTagsToBackups *bool

	// The preferred time to take daily automatic backups, in the UTC time zone.
	DailyAutomaticBackupStartTime *string

	// Specifies the file system deployment type, valid values are the following:
	//
	// *
	// MULTI_AZ_1 - Specifies a high availability file system that is configured for
	// Multi-AZ redundancy to tolerate temporary Availability Zone (AZ) unavailability,
	// and supports SSD and HDD storage.
	//
	// * SINGLE_AZ_1 - (Default) Specifies a file
	// system that is configured for single AZ redundancy, only supports SSD
	// storage.
	//
	// * SINGLE_AZ_2 - Latest generation Single AZ file system. Specifies a
	// file system that is configured for single AZ redundancy and supports SSD and HDD
	// storage.
	//
	// For more information, see Single-AZ and Multi-AZ File Systems
	// (https://docs.aws.amazon.com/fsx/latest/WindowsGuide/high-availability-multiAZ.html).
	DeploymentType WindowsDeploymentType

	// The list of maintenance operations in progress for this file system.
	MaintenanceOperationsInProgress []FileSystemMaintenanceOperation

	// For MULTI_AZ_1 deployment types, the IP address of the primary, or preferred,
	// file server. Use this IP address when mounting the file system on Linux SMB
	// clients or Windows SMB clients that are not joined to a Microsoft Active
	// Directory. Applicable for all Windows file system deployment types. This IP
	// address is temporarily unavailable when the file system is undergoing
	// maintenance. For Linux and Windows SMB clients that are joined to an Active
	// Directory, use the file system's DNSName instead. For more information on
	// mapping and mounting file shares, see Accessing File Shares
	// (https://docs.aws.amazon.com/fsx/latest/WindowsGuide/accessing-file-shares.html).
	PreferredFileServerIp *string

	// For MULTI_AZ_1 deployment types, it specifies the ID of the subnet where the
	// preferred file server is located. Must be one of the two subnet IDs specified in
	// SubnetIds property. Amazon FSx serves traffic from this subnet except in the
	// event of a failover to the secondary file server. For SINGLE_AZ_1 and
	// SINGLE_AZ_2 deployment types, this value is the same as that for SubnetIDs. For
	// more information, see Availability and durability: Single-AZ and Multi-AZ file
	// systems
	// (https://docs.aws.amazon.com/fsx/latest/WindowsGuide/high-availability-multiAZ.html#single-multi-az-resources).
	PreferredSubnetId *string

	// For MULTI_AZ_1 deployment types, use this endpoint when performing
	// administrative tasks on the file system using Amazon FSx Remote PowerShell. For
	// SINGLE_AZ_1 and SINGLE_AZ_2 deployment types, this is the DNS name of the file
	// system. This endpoint is temporarily unavailable when the file system is
	// undergoing maintenance.
	RemoteAdministrationEndpoint *string

	// The configuration of the self-managed Microsoft Active Directory (AD) directory
	// to which the Windows File Server or ONTAP storage virtual machine (SVM) instance
	// is joined.
	SelfManagedActiveDirectoryConfiguration *SelfManagedActiveDirectoryAttributes

	// The throughput of the Amazon FSx file system, measured in megabytes per second.
	ThroughputCapacity *int32

	// The preferred start time to perform weekly maintenance, formatted d:HH:MM in the
	// UTC time zone. d is the weekday number, from 1 through 7, beginning with Monday
	// and ending with Sunday.
	WeeklyMaintenanceStartTime *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
