// Code generated by smithy-go-codegen DO NOT EDIT.

package iot

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/iot/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"math"
)

type awsRestjson1_serializeOpAcceptCertificateTransfer struct {
}

func (*awsRestjson1_serializeOpAcceptCertificateTransfer) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAcceptCertificateTransfer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AcceptCertificateTransferInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accept-certificate-transfer/{certificateId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsAcceptCertificateTransferInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAcceptCertificateTransferInput(v *AcceptCertificateTransferInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CertificateId == nil || len(*v.CertificateId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member certificateId must not be empty")}
	}
	if v.CertificateId != nil {
		if err := encoder.SetURI("certificateId").String(*v.CertificateId); err != nil {
			return err
		}
	}

	if v.SetAsActive {
		encoder.SetQuery("setAsActive").Boolean(v.SetAsActive)
	}

	return nil
}

type awsRestjson1_serializeOpAddThingToBillingGroup struct {
}

func (*awsRestjson1_serializeOpAddThingToBillingGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAddThingToBillingGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AddThingToBillingGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/billing-groups/addThingToBillingGroup")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentAddThingToBillingGroupInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAddThingToBillingGroupInput(v *AddThingToBillingGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentAddThingToBillingGroupInput(v *AddThingToBillingGroupInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BillingGroupArn != nil {
		ok := object.Key("billingGroupArn")
		ok.String(*v.BillingGroupArn)
	}

	if v.BillingGroupName != nil {
		ok := object.Key("billingGroupName")
		ok.String(*v.BillingGroupName)
	}

	if v.ThingArn != nil {
		ok := object.Key("thingArn")
		ok.String(*v.ThingArn)
	}

	if v.ThingName != nil {
		ok := object.Key("thingName")
		ok.String(*v.ThingName)
	}

	return nil
}

type awsRestjson1_serializeOpAddThingToThingGroup struct {
}

func (*awsRestjson1_serializeOpAddThingToThingGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAddThingToThingGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AddThingToThingGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/thing-groups/addThingToThingGroup")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentAddThingToThingGroupInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAddThingToThingGroupInput(v *AddThingToThingGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentAddThingToThingGroupInput(v *AddThingToThingGroupInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.OverrideDynamicGroups {
		ok := object.Key("overrideDynamicGroups")
		ok.Boolean(v.OverrideDynamicGroups)
	}

	if v.ThingArn != nil {
		ok := object.Key("thingArn")
		ok.String(*v.ThingArn)
	}

	if v.ThingGroupArn != nil {
		ok := object.Key("thingGroupArn")
		ok.String(*v.ThingGroupArn)
	}

	if v.ThingGroupName != nil {
		ok := object.Key("thingGroupName")
		ok.String(*v.ThingGroupName)
	}

	if v.ThingName != nil {
		ok := object.Key("thingName")
		ok.String(*v.ThingName)
	}

	return nil
}

type awsRestjson1_serializeOpAssociateTargetsWithJob struct {
}

func (*awsRestjson1_serializeOpAssociateTargetsWithJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAssociateTargetsWithJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AssociateTargetsWithJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/jobs/{jobId}/targets")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsAssociateTargetsWithJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentAssociateTargetsWithJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAssociateTargetsWithJobInput(v *AssociateTargetsWithJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.JobId == nil || len(*v.JobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member jobId must not be empty")}
	}
	if v.JobId != nil {
		if err := encoder.SetURI("jobId").String(*v.JobId); err != nil {
			return err
		}
	}

	if v.NamespaceId != nil {
		encoder.SetQuery("namespaceId").String(*v.NamespaceId)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentAssociateTargetsWithJobInput(v *AssociateTargetsWithJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Comment != nil {
		ok := object.Key("comment")
		ok.String(*v.Comment)
	}

	if v.Targets != nil {
		ok := object.Key("targets")
		if err := awsRestjson1_serializeDocumentJobTargets(v.Targets, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpAttachPolicy struct {
}

func (*awsRestjson1_serializeOpAttachPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAttachPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AttachPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/target-policies/{policyName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsAttachPolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentAttachPolicyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAttachPolicyInput(v *AttachPolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.PolicyName == nil || len(*v.PolicyName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member policyName must not be empty")}
	}
	if v.PolicyName != nil {
		if err := encoder.SetURI("policyName").String(*v.PolicyName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentAttachPolicyInput(v *AttachPolicyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Target != nil {
		ok := object.Key("target")
		ok.String(*v.Target)
	}

	return nil
}

type awsRestjson1_serializeOpAttachPrincipalPolicy struct {
}

func (*awsRestjson1_serializeOpAttachPrincipalPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAttachPrincipalPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AttachPrincipalPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/principal-policies/{policyName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsAttachPrincipalPolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAttachPrincipalPolicyInput(v *AttachPrincipalPolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.PolicyName == nil || len(*v.PolicyName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member policyName must not be empty")}
	}
	if v.PolicyName != nil {
		if err := encoder.SetURI("policyName").String(*v.PolicyName); err != nil {
			return err
		}
	}

	if v.Principal != nil && len(*v.Principal) > 0 {
		locationName := "X-Amzn-Iot-Principal"
		encoder.SetHeader(locationName).String(*v.Principal)
	}

	return nil
}

type awsRestjson1_serializeOpAttachSecurityProfile struct {
}

func (*awsRestjson1_serializeOpAttachSecurityProfile) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAttachSecurityProfile) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AttachSecurityProfileInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/security-profiles/{securityProfileName}/targets")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsAttachSecurityProfileInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAttachSecurityProfileInput(v *AttachSecurityProfileInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.SecurityProfileName == nil || len(*v.SecurityProfileName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member securityProfileName must not be empty")}
	}
	if v.SecurityProfileName != nil {
		if err := encoder.SetURI("securityProfileName").String(*v.SecurityProfileName); err != nil {
			return err
		}
	}

	if v.SecurityProfileTargetArn != nil {
		encoder.SetQuery("securityProfileTargetArn").String(*v.SecurityProfileTargetArn)
	}

	return nil
}

type awsRestjson1_serializeOpAttachThingPrincipal struct {
}

func (*awsRestjson1_serializeOpAttachThingPrincipal) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAttachThingPrincipal) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AttachThingPrincipalInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/things/{thingName}/principals")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsAttachThingPrincipalInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAttachThingPrincipalInput(v *AttachThingPrincipalInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Principal != nil && len(*v.Principal) > 0 {
		locationName := "X-Amzn-Principal"
		encoder.SetHeader(locationName).String(*v.Principal)
	}

	if v.ThingName == nil || len(*v.ThingName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member thingName must not be empty")}
	}
	if v.ThingName != nil {
		if err := encoder.SetURI("thingName").String(*v.ThingName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCancelAuditMitigationActionsTask struct {
}

func (*awsRestjson1_serializeOpCancelAuditMitigationActionsTask) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCancelAuditMitigationActionsTask) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CancelAuditMitigationActionsTaskInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/audit/mitigationactions/tasks/{taskId}/cancel")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCancelAuditMitigationActionsTaskInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCancelAuditMitigationActionsTaskInput(v *CancelAuditMitigationActionsTaskInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TaskId == nil || len(*v.TaskId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member taskId must not be empty")}
	}
	if v.TaskId != nil {
		if err := encoder.SetURI("taskId").String(*v.TaskId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCancelAuditTask struct {
}

func (*awsRestjson1_serializeOpCancelAuditTask) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCancelAuditTask) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CancelAuditTaskInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/audit/tasks/{taskId}/cancel")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCancelAuditTaskInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCancelAuditTaskInput(v *CancelAuditTaskInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TaskId == nil || len(*v.TaskId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member taskId must not be empty")}
	}
	if v.TaskId != nil {
		if err := encoder.SetURI("taskId").String(*v.TaskId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCancelCertificateTransfer struct {
}

func (*awsRestjson1_serializeOpCancelCertificateTransfer) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCancelCertificateTransfer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CancelCertificateTransferInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/cancel-certificate-transfer/{certificateId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCancelCertificateTransferInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCancelCertificateTransferInput(v *CancelCertificateTransferInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CertificateId == nil || len(*v.CertificateId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member certificateId must not be empty")}
	}
	if v.CertificateId != nil {
		if err := encoder.SetURI("certificateId").String(*v.CertificateId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCancelDetectMitigationActionsTask struct {
}

func (*awsRestjson1_serializeOpCancelDetectMitigationActionsTask) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCancelDetectMitigationActionsTask) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CancelDetectMitigationActionsTaskInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/detect/mitigationactions/tasks/{taskId}/cancel")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCancelDetectMitigationActionsTaskInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCancelDetectMitigationActionsTaskInput(v *CancelDetectMitigationActionsTaskInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TaskId == nil || len(*v.TaskId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member taskId must not be empty")}
	}
	if v.TaskId != nil {
		if err := encoder.SetURI("taskId").String(*v.TaskId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCancelJob struct {
}

func (*awsRestjson1_serializeOpCancelJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCancelJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CancelJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/jobs/{jobId}/cancel")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCancelJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCancelJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCancelJobInput(v *CancelJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Force {
		encoder.SetQuery("force").Boolean(v.Force)
	}

	if v.JobId == nil || len(*v.JobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member jobId must not be empty")}
	}
	if v.JobId != nil {
		if err := encoder.SetURI("jobId").String(*v.JobId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCancelJobInput(v *CancelJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Comment != nil {
		ok := object.Key("comment")
		ok.String(*v.Comment)
	}

	if v.ReasonCode != nil {
		ok := object.Key("reasonCode")
		ok.String(*v.ReasonCode)
	}

	return nil
}

type awsRestjson1_serializeOpCancelJobExecution struct {
}

func (*awsRestjson1_serializeOpCancelJobExecution) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCancelJobExecution) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CancelJobExecutionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/things/{thingName}/jobs/{jobId}/cancel")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCancelJobExecutionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCancelJobExecutionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCancelJobExecutionInput(v *CancelJobExecutionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Force {
		encoder.SetQuery("force").Boolean(v.Force)
	}

	if v.JobId == nil || len(*v.JobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member jobId must not be empty")}
	}
	if v.JobId != nil {
		if err := encoder.SetURI("jobId").String(*v.JobId); err != nil {
			return err
		}
	}

	if v.ThingName == nil || len(*v.ThingName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member thingName must not be empty")}
	}
	if v.ThingName != nil {
		if err := encoder.SetURI("thingName").String(*v.ThingName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCancelJobExecutionInput(v *CancelJobExecutionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ExpectedVersion != nil {
		ok := object.Key("expectedVersion")
		ok.Long(*v.ExpectedVersion)
	}

	if v.StatusDetails != nil {
		ok := object.Key("statusDetails")
		if err := awsRestjson1_serializeDocumentDetailsMap(v.StatusDetails, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpClearDefaultAuthorizer struct {
}

func (*awsRestjson1_serializeOpClearDefaultAuthorizer) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpClearDefaultAuthorizer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ClearDefaultAuthorizerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/default-authorizer")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsClearDefaultAuthorizerInput(v *ClearDefaultAuthorizerInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestjson1_serializeOpConfirmTopicRuleDestination struct {
}

func (*awsRestjson1_serializeOpConfirmTopicRuleDestination) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpConfirmTopicRuleDestination) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ConfirmTopicRuleDestinationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/confirmdestination/{confirmationToken+}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsConfirmTopicRuleDestinationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsConfirmTopicRuleDestinationInput(v *ConfirmTopicRuleDestinationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ConfirmationToken == nil || len(*v.ConfirmationToken) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member confirmationToken must not be empty")}
	}
	if v.ConfirmationToken != nil {
		if err := encoder.SetURI("confirmationToken").String(*v.ConfirmationToken); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateAuditSuppression struct {
}

func (*awsRestjson1_serializeOpCreateAuditSuppression) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateAuditSuppression) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateAuditSuppressionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/audit/suppressions/create")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateAuditSuppressionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateAuditSuppressionInput(v *CreateAuditSuppressionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateAuditSuppressionInput(v *CreateAuditSuppressionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CheckName != nil {
		ok := object.Key("checkName")
		ok.String(*v.CheckName)
	}

	if v.ClientRequestToken != nil {
		ok := object.Key("clientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.ExpirationDate != nil {
		ok := object.Key("expirationDate")
		ok.Double(smithytime.FormatEpochSeconds(*v.ExpirationDate))
	}

	if v.ResourceIdentifier != nil {
		ok := object.Key("resourceIdentifier")
		if err := awsRestjson1_serializeDocumentResourceIdentifier(v.ResourceIdentifier, ok); err != nil {
			return err
		}
	}

	if v.SuppressIndefinitely != nil {
		ok := object.Key("suppressIndefinitely")
		ok.Boolean(*v.SuppressIndefinitely)
	}

	return nil
}

type awsRestjson1_serializeOpCreateAuthorizer struct {
}

func (*awsRestjson1_serializeOpCreateAuthorizer) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateAuthorizer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateAuthorizerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/authorizer/{authorizerName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateAuthorizerInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateAuthorizerInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateAuthorizerInput(v *CreateAuthorizerInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AuthorizerName == nil || len(*v.AuthorizerName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member authorizerName must not be empty")}
	}
	if v.AuthorizerName != nil {
		if err := encoder.SetURI("authorizerName").String(*v.AuthorizerName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateAuthorizerInput(v *CreateAuthorizerInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AuthorizerFunctionArn != nil {
		ok := object.Key("authorizerFunctionArn")
		ok.String(*v.AuthorizerFunctionArn)
	}

	if v.EnableCachingForHttp != nil {
		ok := object.Key("enableCachingForHttp")
		ok.Boolean(*v.EnableCachingForHttp)
	}

	if v.SigningDisabled != nil {
		ok := object.Key("signingDisabled")
		ok.Boolean(*v.SigningDisabled)
	}

	if len(v.Status) > 0 {
		ok := object.Key("status")
		ok.String(string(v.Status))
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.TokenKeyName != nil {
		ok := object.Key("tokenKeyName")
		ok.String(*v.TokenKeyName)
	}

	if v.TokenSigningPublicKeys != nil {
		ok := object.Key("tokenSigningPublicKeys")
		if err := awsRestjson1_serializeDocumentPublicKeyMap(v.TokenSigningPublicKeys, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateBillingGroup struct {
}

func (*awsRestjson1_serializeOpCreateBillingGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateBillingGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateBillingGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/billing-groups/{billingGroupName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateBillingGroupInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateBillingGroupInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateBillingGroupInput(v *CreateBillingGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BillingGroupName == nil || len(*v.BillingGroupName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member billingGroupName must not be empty")}
	}
	if v.BillingGroupName != nil {
		if err := encoder.SetURI("billingGroupName").String(*v.BillingGroupName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateBillingGroupInput(v *CreateBillingGroupInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BillingGroupProperties != nil {
		ok := object.Key("billingGroupProperties")
		if err := awsRestjson1_serializeDocumentBillingGroupProperties(v.BillingGroupProperties, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateCertificateFromCsr struct {
}

func (*awsRestjson1_serializeOpCreateCertificateFromCsr) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateCertificateFromCsr) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateCertificateFromCsrInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/certificates")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateCertificateFromCsrInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateCertificateFromCsrInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateCertificateFromCsrInput(v *CreateCertificateFromCsrInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.SetAsActive {
		encoder.SetQuery("setAsActive").Boolean(v.SetAsActive)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateCertificateFromCsrInput(v *CreateCertificateFromCsrInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CertificateSigningRequest != nil {
		ok := object.Key("certificateSigningRequest")
		ok.String(*v.CertificateSigningRequest)
	}

	return nil
}

type awsRestjson1_serializeOpCreateCustomMetric struct {
}

func (*awsRestjson1_serializeOpCreateCustomMetric) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateCustomMetric) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateCustomMetricInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/custom-metric/{metricName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateCustomMetricInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateCustomMetricInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateCustomMetricInput(v *CreateCustomMetricInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MetricName == nil || len(*v.MetricName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member metricName must not be empty")}
	}
	if v.MetricName != nil {
		if err := encoder.SetURI("metricName").String(*v.MetricName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateCustomMetricInput(v *CreateCustomMetricInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientRequestToken != nil {
		ok := object.Key("clientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.DisplayName != nil {
		ok := object.Key("displayName")
		ok.String(*v.DisplayName)
	}

	if len(v.MetricType) > 0 {
		ok := object.Key("metricType")
		ok.String(string(v.MetricType))
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateDimension struct {
}

func (*awsRestjson1_serializeOpCreateDimension) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateDimension) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateDimensionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/dimensions/{name}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateDimensionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateDimensionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateDimensionInput(v *CreateDimensionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("name").String(*v.Name); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateDimensionInput(v *CreateDimensionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientRequestToken != nil {
		ok := object.Key("clientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.StringValues != nil {
		ok := object.Key("stringValues")
		if err := awsRestjson1_serializeDocumentDimensionStringValues(v.StringValues, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

type awsRestjson1_serializeOpCreateDomainConfiguration struct {
}

func (*awsRestjson1_serializeOpCreateDomainConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateDomainConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateDomainConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/domainConfigurations/{domainConfigurationName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateDomainConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateDomainConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateDomainConfigurationInput(v *CreateDomainConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DomainConfigurationName == nil || len(*v.DomainConfigurationName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member domainConfigurationName must not be empty")}
	}
	if v.DomainConfigurationName != nil {
		if err := encoder.SetURI("domainConfigurationName").String(*v.DomainConfigurationName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateDomainConfigurationInput(v *CreateDomainConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AuthorizerConfig != nil {
		ok := object.Key("authorizerConfig")
		if err := awsRestjson1_serializeDocumentAuthorizerConfig(v.AuthorizerConfig, ok); err != nil {
			return err
		}
	}

	if v.DomainName != nil {
		ok := object.Key("domainName")
		ok.String(*v.DomainName)
	}

	if v.ServerCertificateArns != nil {
		ok := object.Key("serverCertificateArns")
		if err := awsRestjson1_serializeDocumentServerCertificateArns(v.ServerCertificateArns, ok); err != nil {
			return err
		}
	}

	if len(v.ServiceType) > 0 {
		ok := object.Key("serviceType")
		ok.String(string(v.ServiceType))
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.ValidationCertificateArn != nil {
		ok := object.Key("validationCertificateArn")
		ok.String(*v.ValidationCertificateArn)
	}

	return nil
}

type awsRestjson1_serializeOpCreateDynamicThingGroup struct {
}

func (*awsRestjson1_serializeOpCreateDynamicThingGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateDynamicThingGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateDynamicThingGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/dynamic-thing-groups/{thingGroupName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateDynamicThingGroupInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateDynamicThingGroupInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateDynamicThingGroupInput(v *CreateDynamicThingGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ThingGroupName == nil || len(*v.ThingGroupName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member thingGroupName must not be empty")}
	}
	if v.ThingGroupName != nil {
		if err := encoder.SetURI("thingGroupName").String(*v.ThingGroupName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateDynamicThingGroupInput(v *CreateDynamicThingGroupInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IndexName != nil {
		ok := object.Key("indexName")
		ok.String(*v.IndexName)
	}

	if v.QueryString != nil {
		ok := object.Key("queryString")
		ok.String(*v.QueryString)
	}

	if v.QueryVersion != nil {
		ok := object.Key("queryVersion")
		ok.String(*v.QueryVersion)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.ThingGroupProperties != nil {
		ok := object.Key("thingGroupProperties")
		if err := awsRestjson1_serializeDocumentThingGroupProperties(v.ThingGroupProperties, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateFleetMetric struct {
}

func (*awsRestjson1_serializeOpCreateFleetMetric) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateFleetMetric) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateFleetMetricInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/fleet-metric/{metricName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateFleetMetricInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateFleetMetricInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateFleetMetricInput(v *CreateFleetMetricInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MetricName == nil || len(*v.MetricName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member metricName must not be empty")}
	}
	if v.MetricName != nil {
		if err := encoder.SetURI("metricName").String(*v.MetricName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateFleetMetricInput(v *CreateFleetMetricInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AggregationField != nil {
		ok := object.Key("aggregationField")
		ok.String(*v.AggregationField)
	}

	if v.AggregationType != nil {
		ok := object.Key("aggregationType")
		if err := awsRestjson1_serializeDocumentAggregationType(v.AggregationType, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.IndexName != nil {
		ok := object.Key("indexName")
		ok.String(*v.IndexName)
	}

	if v.Period != nil {
		ok := object.Key("period")
		ok.Integer(*v.Period)
	}

	if v.QueryString != nil {
		ok := object.Key("queryString")
		ok.String(*v.QueryString)
	}

	if v.QueryVersion != nil {
		ok := object.Key("queryVersion")
		ok.String(*v.QueryVersion)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if len(v.Unit) > 0 {
		ok := object.Key("unit")
		ok.String(string(v.Unit))
	}

	return nil
}

type awsRestjson1_serializeOpCreateJob struct {
}

func (*awsRestjson1_serializeOpCreateJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/jobs/{jobId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateJobInput(v *CreateJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.JobId == nil || len(*v.JobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member jobId must not be empty")}
	}
	if v.JobId != nil {
		if err := encoder.SetURI("jobId").String(*v.JobId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateJobInput(v *CreateJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AbortConfig != nil {
		ok := object.Key("abortConfig")
		if err := awsRestjson1_serializeDocumentAbortConfig(v.AbortConfig, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.Document != nil {
		ok := object.Key("document")
		ok.String(*v.Document)
	}

	if v.DocumentParameters != nil {
		ok := object.Key("documentParameters")
		if err := awsRestjson1_serializeDocumentParameterMap(v.DocumentParameters, ok); err != nil {
			return err
		}
	}

	if v.DocumentSource != nil {
		ok := object.Key("documentSource")
		ok.String(*v.DocumentSource)
	}

	if v.JobExecutionsRetryConfig != nil {
		ok := object.Key("jobExecutionsRetryConfig")
		if err := awsRestjson1_serializeDocumentJobExecutionsRetryConfig(v.JobExecutionsRetryConfig, ok); err != nil {
			return err
		}
	}

	if v.JobExecutionsRolloutConfig != nil {
		ok := object.Key("jobExecutionsRolloutConfig")
		if err := awsRestjson1_serializeDocumentJobExecutionsRolloutConfig(v.JobExecutionsRolloutConfig, ok); err != nil {
			return err
		}
	}

	if v.JobTemplateArn != nil {
		ok := object.Key("jobTemplateArn")
		ok.String(*v.JobTemplateArn)
	}

	if v.NamespaceId != nil {
		ok := object.Key("namespaceId")
		ok.String(*v.NamespaceId)
	}

	if v.PresignedUrlConfig != nil {
		ok := object.Key("presignedUrlConfig")
		if err := awsRestjson1_serializeDocumentPresignedUrlConfig(v.PresignedUrlConfig, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.Targets != nil {
		ok := object.Key("targets")
		if err := awsRestjson1_serializeDocumentJobTargets(v.Targets, ok); err != nil {
			return err
		}
	}

	if len(v.TargetSelection) > 0 {
		ok := object.Key("targetSelection")
		ok.String(string(v.TargetSelection))
	}

	if v.TimeoutConfig != nil {
		ok := object.Key("timeoutConfig")
		if err := awsRestjson1_serializeDocumentTimeoutConfig(v.TimeoutConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateJobTemplate struct {
}

func (*awsRestjson1_serializeOpCreateJobTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateJobTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateJobTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/job-templates/{jobTemplateId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateJobTemplateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateJobTemplateInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateJobTemplateInput(v *CreateJobTemplateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.JobTemplateId == nil || len(*v.JobTemplateId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member jobTemplateId must not be empty")}
	}
	if v.JobTemplateId != nil {
		if err := encoder.SetURI("jobTemplateId").String(*v.JobTemplateId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateJobTemplateInput(v *CreateJobTemplateInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AbortConfig != nil {
		ok := object.Key("abortConfig")
		if err := awsRestjson1_serializeDocumentAbortConfig(v.AbortConfig, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.Document != nil {
		ok := object.Key("document")
		ok.String(*v.Document)
	}

	if v.DocumentSource != nil {
		ok := object.Key("documentSource")
		ok.String(*v.DocumentSource)
	}

	if v.JobArn != nil {
		ok := object.Key("jobArn")
		ok.String(*v.JobArn)
	}

	if v.JobExecutionsRetryConfig != nil {
		ok := object.Key("jobExecutionsRetryConfig")
		if err := awsRestjson1_serializeDocumentJobExecutionsRetryConfig(v.JobExecutionsRetryConfig, ok); err != nil {
			return err
		}
	}

	if v.JobExecutionsRolloutConfig != nil {
		ok := object.Key("jobExecutionsRolloutConfig")
		if err := awsRestjson1_serializeDocumentJobExecutionsRolloutConfig(v.JobExecutionsRolloutConfig, ok); err != nil {
			return err
		}
	}

	if v.PresignedUrlConfig != nil {
		ok := object.Key("presignedUrlConfig")
		if err := awsRestjson1_serializeDocumentPresignedUrlConfig(v.PresignedUrlConfig, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.TimeoutConfig != nil {
		ok := object.Key("timeoutConfig")
		if err := awsRestjson1_serializeDocumentTimeoutConfig(v.TimeoutConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateKeysAndCertificate struct {
}

func (*awsRestjson1_serializeOpCreateKeysAndCertificate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateKeysAndCertificate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateKeysAndCertificateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/keys-and-certificate")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateKeysAndCertificateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateKeysAndCertificateInput(v *CreateKeysAndCertificateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.SetAsActive {
		encoder.SetQuery("setAsActive").Boolean(v.SetAsActive)
	}

	return nil
}

type awsRestjson1_serializeOpCreateMitigationAction struct {
}

func (*awsRestjson1_serializeOpCreateMitigationAction) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateMitigationAction) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateMitigationActionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/mitigationactions/actions/{actionName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateMitigationActionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateMitigationActionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateMitigationActionInput(v *CreateMitigationActionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ActionName == nil || len(*v.ActionName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member actionName must not be empty")}
	}
	if v.ActionName != nil {
		if err := encoder.SetURI("actionName").String(*v.ActionName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateMitigationActionInput(v *CreateMitigationActionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ActionParams != nil {
		ok := object.Key("actionParams")
		if err := awsRestjson1_serializeDocumentMitigationActionParams(v.ActionParams, ok); err != nil {
			return err
		}
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateOTAUpdate struct {
}

func (*awsRestjson1_serializeOpCreateOTAUpdate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateOTAUpdate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateOTAUpdateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/otaUpdates/{otaUpdateId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateOTAUpdateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateOTAUpdateInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateOTAUpdateInput(v *CreateOTAUpdateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.OtaUpdateId == nil || len(*v.OtaUpdateId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member otaUpdateId must not be empty")}
	}
	if v.OtaUpdateId != nil {
		if err := encoder.SetURI("otaUpdateId").String(*v.OtaUpdateId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateOTAUpdateInput(v *CreateOTAUpdateInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdditionalParameters != nil {
		ok := object.Key("additionalParameters")
		if err := awsRestjson1_serializeDocumentAdditionalParameterMap(v.AdditionalParameters, ok); err != nil {
			return err
		}
	}

	if v.AwsJobAbortConfig != nil {
		ok := object.Key("awsJobAbortConfig")
		if err := awsRestjson1_serializeDocumentAwsJobAbortConfig(v.AwsJobAbortConfig, ok); err != nil {
			return err
		}
	}

	if v.AwsJobExecutionsRolloutConfig != nil {
		ok := object.Key("awsJobExecutionsRolloutConfig")
		if err := awsRestjson1_serializeDocumentAwsJobExecutionsRolloutConfig(v.AwsJobExecutionsRolloutConfig, ok); err != nil {
			return err
		}
	}

	if v.AwsJobPresignedUrlConfig != nil {
		ok := object.Key("awsJobPresignedUrlConfig")
		if err := awsRestjson1_serializeDocumentAwsJobPresignedUrlConfig(v.AwsJobPresignedUrlConfig, ok); err != nil {
			return err
		}
	}

	if v.AwsJobTimeoutConfig != nil {
		ok := object.Key("awsJobTimeoutConfig")
		if err := awsRestjson1_serializeDocumentAwsJobTimeoutConfig(v.AwsJobTimeoutConfig, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.Files != nil {
		ok := object.Key("files")
		if err := awsRestjson1_serializeDocumentOTAUpdateFiles(v.Files, ok); err != nil {
			return err
		}
	}

	if v.Protocols != nil {
		ok := object.Key("protocols")
		if err := awsRestjson1_serializeDocumentProtocols(v.Protocols, ok); err != nil {
			return err
		}
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.Targets != nil {
		ok := object.Key("targets")
		if err := awsRestjson1_serializeDocumentTargets(v.Targets, ok); err != nil {
			return err
		}
	}

	if len(v.TargetSelection) > 0 {
		ok := object.Key("targetSelection")
		ok.String(string(v.TargetSelection))
	}

	return nil
}

type awsRestjson1_serializeOpCreatePolicy struct {
}

func (*awsRestjson1_serializeOpCreatePolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreatePolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreatePolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/policies/{policyName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreatePolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreatePolicyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreatePolicyInput(v *CreatePolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.PolicyName == nil || len(*v.PolicyName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member policyName must not be empty")}
	}
	if v.PolicyName != nil {
		if err := encoder.SetURI("policyName").String(*v.PolicyName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreatePolicyInput(v *CreatePolicyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PolicyDocument != nil {
		ok := object.Key("policyDocument")
		ok.String(*v.PolicyDocument)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreatePolicyVersion struct {
}

func (*awsRestjson1_serializeOpCreatePolicyVersion) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreatePolicyVersion) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreatePolicyVersionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/policies/{policyName}/version")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreatePolicyVersionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreatePolicyVersionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreatePolicyVersionInput(v *CreatePolicyVersionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.PolicyName == nil || len(*v.PolicyName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member policyName must not be empty")}
	}
	if v.PolicyName != nil {
		if err := encoder.SetURI("policyName").String(*v.PolicyName); err != nil {
			return err
		}
	}

	if v.SetAsDefault {
		encoder.SetQuery("setAsDefault").Boolean(v.SetAsDefault)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreatePolicyVersionInput(v *CreatePolicyVersionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PolicyDocument != nil {
		ok := object.Key("policyDocument")
		ok.String(*v.PolicyDocument)
	}

	return nil
}

type awsRestjson1_serializeOpCreateProvisioningClaim struct {
}

func (*awsRestjson1_serializeOpCreateProvisioningClaim) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateProvisioningClaim) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateProvisioningClaimInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/provisioning-templates/{templateName}/provisioning-claim")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateProvisioningClaimInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateProvisioningClaimInput(v *CreateProvisioningClaimInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TemplateName == nil || len(*v.TemplateName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member templateName must not be empty")}
	}
	if v.TemplateName != nil {
		if err := encoder.SetURI("templateName").String(*v.TemplateName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateProvisioningTemplate struct {
}

func (*awsRestjson1_serializeOpCreateProvisioningTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateProvisioningTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateProvisioningTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/provisioning-templates")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateProvisioningTemplateInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateProvisioningTemplateInput(v *CreateProvisioningTemplateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateProvisioningTemplateInput(v *CreateProvisioningTemplateInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.Enabled {
		ok := object.Key("enabled")
		ok.Boolean(v.Enabled)
	}

	if v.PreProvisioningHook != nil {
		ok := object.Key("preProvisioningHook")
		if err := awsRestjson1_serializeDocumentProvisioningHook(v.PreProvisioningHook, ok); err != nil {
			return err
		}
	}

	if v.ProvisioningRoleArn != nil {
		ok := object.Key("provisioningRoleArn")
		ok.String(*v.ProvisioningRoleArn)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.TemplateBody != nil {
		ok := object.Key("templateBody")
		ok.String(*v.TemplateBody)
	}

	if v.TemplateName != nil {
		ok := object.Key("templateName")
		ok.String(*v.TemplateName)
	}

	return nil
}

type awsRestjson1_serializeOpCreateProvisioningTemplateVersion struct {
}

func (*awsRestjson1_serializeOpCreateProvisioningTemplateVersion) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateProvisioningTemplateVersion) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateProvisioningTemplateVersionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/provisioning-templates/{templateName}/versions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateProvisioningTemplateVersionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateProvisioningTemplateVersionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateProvisioningTemplateVersionInput(v *CreateProvisioningTemplateVersionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.SetAsDefault {
		encoder.SetQuery("setAsDefault").Boolean(v.SetAsDefault)
	}

	if v.TemplateName == nil || len(*v.TemplateName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member templateName must not be empty")}
	}
	if v.TemplateName != nil {
		if err := encoder.SetURI("templateName").String(*v.TemplateName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateProvisioningTemplateVersionInput(v *CreateProvisioningTemplateVersionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TemplateBody != nil {
		ok := object.Key("templateBody")
		ok.String(*v.TemplateBody)
	}

	return nil
}

type awsRestjson1_serializeOpCreateRoleAlias struct {
}

func (*awsRestjson1_serializeOpCreateRoleAlias) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateRoleAlias) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateRoleAliasInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/role-aliases/{roleAlias}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateRoleAliasInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateRoleAliasInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateRoleAliasInput(v *CreateRoleAliasInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.RoleAlias == nil || len(*v.RoleAlias) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member roleAlias must not be empty")}
	}
	if v.RoleAlias != nil {
		if err := encoder.SetURI("roleAlias").String(*v.RoleAlias); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateRoleAliasInput(v *CreateRoleAliasInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CredentialDurationSeconds != nil {
		ok := object.Key("credentialDurationSeconds")
		ok.Integer(*v.CredentialDurationSeconds)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateScheduledAudit struct {
}

func (*awsRestjson1_serializeOpCreateScheduledAudit) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateScheduledAudit) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateScheduledAuditInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/audit/scheduledaudits/{scheduledAuditName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateScheduledAuditInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateScheduledAuditInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateScheduledAuditInput(v *CreateScheduledAuditInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ScheduledAuditName == nil || len(*v.ScheduledAuditName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member scheduledAuditName must not be empty")}
	}
	if v.ScheduledAuditName != nil {
		if err := encoder.SetURI("scheduledAuditName").String(*v.ScheduledAuditName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateScheduledAuditInput(v *CreateScheduledAuditInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DayOfMonth != nil {
		ok := object.Key("dayOfMonth")
		ok.String(*v.DayOfMonth)
	}

	if len(v.DayOfWeek) > 0 {
		ok := object.Key("dayOfWeek")
		ok.String(string(v.DayOfWeek))
	}

	if len(v.Frequency) > 0 {
		ok := object.Key("frequency")
		ok.String(string(v.Frequency))
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.TargetCheckNames != nil {
		ok := object.Key("targetCheckNames")
		if err := awsRestjson1_serializeDocumentTargetAuditCheckNames(v.TargetCheckNames, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateSecurityProfile struct {
}

func (*awsRestjson1_serializeOpCreateSecurityProfile) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateSecurityProfile) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateSecurityProfileInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/security-profiles/{securityProfileName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateSecurityProfileInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateSecurityProfileInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateSecurityProfileInput(v *CreateSecurityProfileInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.SecurityProfileName == nil || len(*v.SecurityProfileName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member securityProfileName must not be empty")}
	}
	if v.SecurityProfileName != nil {
		if err := encoder.SetURI("securityProfileName").String(*v.SecurityProfileName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateSecurityProfileInput(v *CreateSecurityProfileInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdditionalMetricsToRetain != nil {
		ok := object.Key("additionalMetricsToRetain")
		if err := awsRestjson1_serializeDocumentAdditionalMetricsToRetainList(v.AdditionalMetricsToRetain, ok); err != nil {
			return err
		}
	}

	if v.AdditionalMetricsToRetainV2 != nil {
		ok := object.Key("additionalMetricsToRetainV2")
		if err := awsRestjson1_serializeDocumentAdditionalMetricsToRetainV2List(v.AdditionalMetricsToRetainV2, ok); err != nil {
			return err
		}
	}

	if v.AlertTargets != nil {
		ok := object.Key("alertTargets")
		if err := awsRestjson1_serializeDocumentAlertTargets(v.AlertTargets, ok); err != nil {
			return err
		}
	}

	if v.Behaviors != nil {
		ok := object.Key("behaviors")
		if err := awsRestjson1_serializeDocumentBehaviors(v.Behaviors, ok); err != nil {
			return err
		}
	}

	if v.SecurityProfileDescription != nil {
		ok := object.Key("securityProfileDescription")
		ok.String(*v.SecurityProfileDescription)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateStream struct {
}

func (*awsRestjson1_serializeOpCreateStream) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateStream) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateStreamInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/streams/{streamId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateStreamInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateStreamInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateStreamInput(v *CreateStreamInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.StreamId == nil || len(*v.StreamId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member streamId must not be empty")}
	}
	if v.StreamId != nil {
		if err := encoder.SetURI("streamId").String(*v.StreamId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateStreamInput(v *CreateStreamInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.Files != nil {
		ok := object.Key("files")
		if err := awsRestjson1_serializeDocumentStreamFiles(v.Files, ok); err != nil {
			return err
		}
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateThing struct {
}

func (*awsRestjson1_serializeOpCreateThing) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateThing) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateThingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/things/{thingName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateThingInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateThingInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateThingInput(v *CreateThingInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ThingName == nil || len(*v.ThingName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member thingName must not be empty")}
	}
	if v.ThingName != nil {
		if err := encoder.SetURI("thingName").String(*v.ThingName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateThingInput(v *CreateThingInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AttributePayload != nil {
		ok := object.Key("attributePayload")
		if err := awsRestjson1_serializeDocumentAttributePayload(v.AttributePayload, ok); err != nil {
			return err
		}
	}

	if v.BillingGroupName != nil {
		ok := object.Key("billingGroupName")
		ok.String(*v.BillingGroupName)
	}

	if v.ThingTypeName != nil {
		ok := object.Key("thingTypeName")
		ok.String(*v.ThingTypeName)
	}

	return nil
}

type awsRestjson1_serializeOpCreateThingGroup struct {
}

func (*awsRestjson1_serializeOpCreateThingGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateThingGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateThingGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/thing-groups/{thingGroupName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateThingGroupInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateThingGroupInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateThingGroupInput(v *CreateThingGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ThingGroupName == nil || len(*v.ThingGroupName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member thingGroupName must not be empty")}
	}
	if v.ThingGroupName != nil {
		if err := encoder.SetURI("thingGroupName").String(*v.ThingGroupName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateThingGroupInput(v *CreateThingGroupInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ParentGroupName != nil {
		ok := object.Key("parentGroupName")
		ok.String(*v.ParentGroupName)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.ThingGroupProperties != nil {
		ok := object.Key("thingGroupProperties")
		if err := awsRestjson1_serializeDocumentThingGroupProperties(v.ThingGroupProperties, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateThingType struct {
}

func (*awsRestjson1_serializeOpCreateThingType) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateThingType) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateThingTypeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/thing-types/{thingTypeName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateThingTypeInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateThingTypeInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateThingTypeInput(v *CreateThingTypeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ThingTypeName == nil || len(*v.ThingTypeName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member thingTypeName must not be empty")}
	}
	if v.ThingTypeName != nil {
		if err := encoder.SetURI("thingTypeName").String(*v.ThingTypeName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateThingTypeInput(v *CreateThingTypeInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.ThingTypeProperties != nil {
		ok := object.Key("thingTypeProperties")
		if err := awsRestjson1_serializeDocumentThingTypeProperties(v.ThingTypeProperties, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateTopicRule struct {
}

func (*awsRestjson1_serializeOpCreateTopicRule) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateTopicRule) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateTopicRuleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/rules/{ruleName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateTopicRuleInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if !restEncoder.HasHeader("Content-Type") {
		ctx = smithyhttp.SetIsContentTypeDefaultValue(ctx, true)
		restEncoder.SetHeader("Content-Type").String("application/json")
	}

	if input.TopicRulePayload != nil {
		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentTopicRulePayload(input.TopicRulePayload, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	} else {
		jsonEncoder := smithyjson.NewEncoder()
		jsonEncoder.Value.Object().Close()
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}

	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateTopicRuleInput(v *CreateTopicRuleInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.RuleName == nil || len(*v.RuleName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ruleName must not be empty")}
	}
	if v.RuleName != nil {
		if err := encoder.SetURI("ruleName").String(*v.RuleName); err != nil {
			return err
		}
	}

	if v.Tags != nil && len(*v.Tags) > 0 {
		locationName := "X-Amz-Tagging"
		encoder.SetHeader(locationName).String(*v.Tags)
	}

	return nil
}

type awsRestjson1_serializeOpCreateTopicRuleDestination struct {
}

func (*awsRestjson1_serializeOpCreateTopicRuleDestination) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateTopicRuleDestination) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateTopicRuleDestinationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/destinations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateTopicRuleDestinationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateTopicRuleDestinationInput(v *CreateTopicRuleDestinationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateTopicRuleDestinationInput(v *CreateTopicRuleDestinationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DestinationConfiguration != nil {
		ok := object.Key("destinationConfiguration")
		if err := awsRestjson1_serializeDocumentTopicRuleDestinationConfiguration(v.DestinationConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteAccountAuditConfiguration struct {
}

func (*awsRestjson1_serializeOpDeleteAccountAuditConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteAccountAuditConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteAccountAuditConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/audit/configuration")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteAccountAuditConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteAccountAuditConfigurationInput(v *DeleteAccountAuditConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DeleteScheduledAudits {
		encoder.SetQuery("deleteScheduledAudits").Boolean(v.DeleteScheduledAudits)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteAuditSuppression struct {
}

func (*awsRestjson1_serializeOpDeleteAuditSuppression) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteAuditSuppression) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteAuditSuppressionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/audit/suppressions/delete")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentDeleteAuditSuppressionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteAuditSuppressionInput(v *DeleteAuditSuppressionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentDeleteAuditSuppressionInput(v *DeleteAuditSuppressionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CheckName != nil {
		ok := object.Key("checkName")
		ok.String(*v.CheckName)
	}

	if v.ResourceIdentifier != nil {
		ok := object.Key("resourceIdentifier")
		if err := awsRestjson1_serializeDocumentResourceIdentifier(v.ResourceIdentifier, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteAuthorizer struct {
}

func (*awsRestjson1_serializeOpDeleteAuthorizer) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteAuthorizer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteAuthorizerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/authorizer/{authorizerName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteAuthorizerInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteAuthorizerInput(v *DeleteAuthorizerInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AuthorizerName == nil || len(*v.AuthorizerName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member authorizerName must not be empty")}
	}
	if v.AuthorizerName != nil {
		if err := encoder.SetURI("authorizerName").String(*v.AuthorizerName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteBillingGroup struct {
}

func (*awsRestjson1_serializeOpDeleteBillingGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteBillingGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteBillingGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/billing-groups/{billingGroupName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteBillingGroupInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteBillingGroupInput(v *DeleteBillingGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BillingGroupName == nil || len(*v.BillingGroupName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member billingGroupName must not be empty")}
	}
	if v.BillingGroupName != nil {
		if err := encoder.SetURI("billingGroupName").String(*v.BillingGroupName); err != nil {
			return err
		}
	}

	if v.ExpectedVersion != nil {
		encoder.SetQuery("expectedVersion").Long(*v.ExpectedVersion)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteCACertificate struct {
}

func (*awsRestjson1_serializeOpDeleteCACertificate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteCACertificate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteCACertificateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/cacertificate/{certificateId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteCACertificateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteCACertificateInput(v *DeleteCACertificateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CertificateId == nil || len(*v.CertificateId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member certificateId must not be empty")}
	}
	if v.CertificateId != nil {
		if err := encoder.SetURI("certificateId").String(*v.CertificateId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteCertificate struct {
}

func (*awsRestjson1_serializeOpDeleteCertificate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteCertificate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteCertificateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/certificates/{certificateId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteCertificateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteCertificateInput(v *DeleteCertificateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CertificateId == nil || len(*v.CertificateId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member certificateId must not be empty")}
	}
	if v.CertificateId != nil {
		if err := encoder.SetURI("certificateId").String(*v.CertificateId); err != nil {
			return err
		}
	}

	if v.ForceDelete {
		encoder.SetQuery("forceDelete").Boolean(v.ForceDelete)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteCustomMetric struct {
}

func (*awsRestjson1_serializeOpDeleteCustomMetric) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteCustomMetric) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteCustomMetricInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/custom-metric/{metricName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteCustomMetricInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteCustomMetricInput(v *DeleteCustomMetricInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MetricName == nil || len(*v.MetricName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member metricName must not be empty")}
	}
	if v.MetricName != nil {
		if err := encoder.SetURI("metricName").String(*v.MetricName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteDimension struct {
}

func (*awsRestjson1_serializeOpDeleteDimension) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteDimension) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteDimensionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/dimensions/{name}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteDimensionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteDimensionInput(v *DeleteDimensionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("name").String(*v.Name); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteDomainConfiguration struct {
}

func (*awsRestjson1_serializeOpDeleteDomainConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteDomainConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteDomainConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/domainConfigurations/{domainConfigurationName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteDomainConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteDomainConfigurationInput(v *DeleteDomainConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DomainConfigurationName == nil || len(*v.DomainConfigurationName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member domainConfigurationName must not be empty")}
	}
	if v.DomainConfigurationName != nil {
		if err := encoder.SetURI("domainConfigurationName").String(*v.DomainConfigurationName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteDynamicThingGroup struct {
}

func (*awsRestjson1_serializeOpDeleteDynamicThingGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteDynamicThingGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteDynamicThingGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/dynamic-thing-groups/{thingGroupName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteDynamicThingGroupInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteDynamicThingGroupInput(v *DeleteDynamicThingGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ExpectedVersion != nil {
		encoder.SetQuery("expectedVersion").Long(*v.ExpectedVersion)
	}

	if v.ThingGroupName == nil || len(*v.ThingGroupName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member thingGroupName must not be empty")}
	}
	if v.ThingGroupName != nil {
		if err := encoder.SetURI("thingGroupName").String(*v.ThingGroupName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteFleetMetric struct {
}

func (*awsRestjson1_serializeOpDeleteFleetMetric) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteFleetMetric) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteFleetMetricInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/fleet-metric/{metricName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteFleetMetricInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteFleetMetricInput(v *DeleteFleetMetricInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ExpectedVersion != nil {
		encoder.SetQuery("expectedVersion").Long(*v.ExpectedVersion)
	}

	if v.MetricName == nil || len(*v.MetricName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member metricName must not be empty")}
	}
	if v.MetricName != nil {
		if err := encoder.SetURI("metricName").String(*v.MetricName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteJob struct {
}

func (*awsRestjson1_serializeOpDeleteJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/jobs/{jobId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteJobInput(v *DeleteJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Force {
		encoder.SetQuery("force").Boolean(v.Force)
	}

	if v.JobId == nil || len(*v.JobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member jobId must not be empty")}
	}
	if v.JobId != nil {
		if err := encoder.SetURI("jobId").String(*v.JobId); err != nil {
			return err
		}
	}

	if v.NamespaceId != nil {
		encoder.SetQuery("namespaceId").String(*v.NamespaceId)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteJobExecution struct {
}

func (*awsRestjson1_serializeOpDeleteJobExecution) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteJobExecution) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteJobExecutionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/things/{thingName}/jobs/{jobId}/executionNumber/{executionNumber}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteJobExecutionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteJobExecutionInput(v *DeleteJobExecutionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ExecutionNumber == nil {
		return &smithy.SerializationError{Err: fmt.Errorf("input member executionNumber must not be empty")}
	}
	if v.ExecutionNumber != nil {
		if err := encoder.SetURI("executionNumber").Long(*v.ExecutionNumber); err != nil {
			return err
		}
	}

	if v.Force {
		encoder.SetQuery("force").Boolean(v.Force)
	}

	if v.JobId == nil || len(*v.JobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member jobId must not be empty")}
	}
	if v.JobId != nil {
		if err := encoder.SetURI("jobId").String(*v.JobId); err != nil {
			return err
		}
	}

	if v.NamespaceId != nil {
		encoder.SetQuery("namespaceId").String(*v.NamespaceId)
	}

	if v.ThingName == nil || len(*v.ThingName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member thingName must not be empty")}
	}
	if v.ThingName != nil {
		if err := encoder.SetURI("thingName").String(*v.ThingName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteJobTemplate struct {
}

func (*awsRestjson1_serializeOpDeleteJobTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteJobTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteJobTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/job-templates/{jobTemplateId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteJobTemplateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteJobTemplateInput(v *DeleteJobTemplateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.JobTemplateId == nil || len(*v.JobTemplateId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member jobTemplateId must not be empty")}
	}
	if v.JobTemplateId != nil {
		if err := encoder.SetURI("jobTemplateId").String(*v.JobTemplateId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteMitigationAction struct {
}

func (*awsRestjson1_serializeOpDeleteMitigationAction) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteMitigationAction) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteMitigationActionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/mitigationactions/actions/{actionName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteMitigationActionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteMitigationActionInput(v *DeleteMitigationActionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ActionName == nil || len(*v.ActionName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member actionName must not be empty")}
	}
	if v.ActionName != nil {
		if err := encoder.SetURI("actionName").String(*v.ActionName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteOTAUpdate struct {
}

func (*awsRestjson1_serializeOpDeleteOTAUpdate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteOTAUpdate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteOTAUpdateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/otaUpdates/{otaUpdateId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteOTAUpdateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteOTAUpdateInput(v *DeleteOTAUpdateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DeleteStream {
		encoder.SetQuery("deleteStream").Boolean(v.DeleteStream)
	}

	if v.ForceDeleteAWSJob {
		encoder.SetQuery("forceDeleteAWSJob").Boolean(v.ForceDeleteAWSJob)
	}

	if v.OtaUpdateId == nil || len(*v.OtaUpdateId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member otaUpdateId must not be empty")}
	}
	if v.OtaUpdateId != nil {
		if err := encoder.SetURI("otaUpdateId").String(*v.OtaUpdateId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeletePolicy struct {
}

func (*awsRestjson1_serializeOpDeletePolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeletePolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeletePolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/policies/{policyName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeletePolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeletePolicyInput(v *DeletePolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.PolicyName == nil || len(*v.PolicyName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member policyName must not be empty")}
	}
	if v.PolicyName != nil {
		if err := encoder.SetURI("policyName").String(*v.PolicyName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeletePolicyVersion struct {
}

func (*awsRestjson1_serializeOpDeletePolicyVersion) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeletePolicyVersion) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeletePolicyVersionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/policies/{policyName}/version/{policyVersionId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeletePolicyVersionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeletePolicyVersionInput(v *DeletePolicyVersionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.PolicyName == nil || len(*v.PolicyName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member policyName must not be empty")}
	}
	if v.PolicyName != nil {
		if err := encoder.SetURI("policyName").String(*v.PolicyName); err != nil {
			return err
		}
	}

	if v.PolicyVersionId == nil || len(*v.PolicyVersionId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member policyVersionId must not be empty")}
	}
	if v.PolicyVersionId != nil {
		if err := encoder.SetURI("policyVersionId").String(*v.PolicyVersionId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteProvisioningTemplate struct {
}

func (*awsRestjson1_serializeOpDeleteProvisioningTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteProvisioningTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteProvisioningTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/provisioning-templates/{templateName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteProvisioningTemplateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteProvisioningTemplateInput(v *DeleteProvisioningTemplateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TemplateName == nil || len(*v.TemplateName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member templateName must not be empty")}
	}
	if v.TemplateName != nil {
		if err := encoder.SetURI("templateName").String(*v.TemplateName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteProvisioningTemplateVersion struct {
}

func (*awsRestjson1_serializeOpDeleteProvisioningTemplateVersion) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteProvisioningTemplateVersion) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteProvisioningTemplateVersionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/provisioning-templates/{templateName}/versions/{versionId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteProvisioningTemplateVersionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteProvisioningTemplateVersionInput(v *DeleteProvisioningTemplateVersionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TemplateName == nil || len(*v.TemplateName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member templateName must not be empty")}
	}
	if v.TemplateName != nil {
		if err := encoder.SetURI("templateName").String(*v.TemplateName); err != nil {
			return err
		}
	}

	if v.VersionId == nil {
		return &smithy.SerializationError{Err: fmt.Errorf("input member versionId must not be empty")}
	}
	if v.VersionId != nil {
		if err := encoder.SetURI("versionId").Integer(*v.VersionId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteRegistrationCode struct {
}

func (*awsRestjson1_serializeOpDeleteRegistrationCode) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteRegistrationCode) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteRegistrationCodeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/registrationcode")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteRegistrationCodeInput(v *DeleteRegistrationCodeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteRoleAlias struct {
}

func (*awsRestjson1_serializeOpDeleteRoleAlias) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteRoleAlias) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteRoleAliasInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/role-aliases/{roleAlias}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteRoleAliasInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteRoleAliasInput(v *DeleteRoleAliasInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.RoleAlias == nil || len(*v.RoleAlias) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member roleAlias must not be empty")}
	}
	if v.RoleAlias != nil {
		if err := encoder.SetURI("roleAlias").String(*v.RoleAlias); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteScheduledAudit struct {
}

func (*awsRestjson1_serializeOpDeleteScheduledAudit) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteScheduledAudit) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteScheduledAuditInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/audit/scheduledaudits/{scheduledAuditName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteScheduledAuditInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteScheduledAuditInput(v *DeleteScheduledAuditInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ScheduledAuditName == nil || len(*v.ScheduledAuditName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member scheduledAuditName must not be empty")}
	}
	if v.ScheduledAuditName != nil {
		if err := encoder.SetURI("scheduledAuditName").String(*v.ScheduledAuditName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteSecurityProfile struct {
}

func (*awsRestjson1_serializeOpDeleteSecurityProfile) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteSecurityProfile) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteSecurityProfileInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/security-profiles/{securityProfileName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteSecurityProfileInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteSecurityProfileInput(v *DeleteSecurityProfileInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ExpectedVersion != nil {
		encoder.SetQuery("expectedVersion").Long(*v.ExpectedVersion)
	}

	if v.SecurityProfileName == nil || len(*v.SecurityProfileName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member securityProfileName must not be empty")}
	}
	if v.SecurityProfileName != nil {
		if err := encoder.SetURI("securityProfileName").String(*v.SecurityProfileName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteStream struct {
}

func (*awsRestjson1_serializeOpDeleteStream) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteStream) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteStreamInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/streams/{streamId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteStreamInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteStreamInput(v *DeleteStreamInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.StreamId == nil || len(*v.StreamId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member streamId must not be empty")}
	}
	if v.StreamId != nil {
		if err := encoder.SetURI("streamId").String(*v.StreamId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteThing struct {
}

func (*awsRestjson1_serializeOpDeleteThing) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteThing) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteThingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/things/{thingName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteThingInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteThingInput(v *DeleteThingInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ExpectedVersion != nil {
		encoder.SetQuery("expectedVersion").Long(*v.ExpectedVersion)
	}

	if v.ThingName == nil || len(*v.ThingName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member thingName must not be empty")}
	}
	if v.ThingName != nil {
		if err := encoder.SetURI("thingName").String(*v.ThingName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteThingGroup struct {
}

func (*awsRestjson1_serializeOpDeleteThingGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteThingGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteThingGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/thing-groups/{thingGroupName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteThingGroupInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteThingGroupInput(v *DeleteThingGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ExpectedVersion != nil {
		encoder.SetQuery("expectedVersion").Long(*v.ExpectedVersion)
	}

	if v.ThingGroupName == nil || len(*v.ThingGroupName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member thingGroupName must not be empty")}
	}
	if v.ThingGroupName != nil {
		if err := encoder.SetURI("thingGroupName").String(*v.ThingGroupName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteThingType struct {
}

func (*awsRestjson1_serializeOpDeleteThingType) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteThingType) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteThingTypeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/thing-types/{thingTypeName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteThingTypeInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteThingTypeInput(v *DeleteThingTypeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ThingTypeName == nil || len(*v.ThingTypeName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member thingTypeName must not be empty")}
	}
	if v.ThingTypeName != nil {
		if err := encoder.SetURI("thingTypeName").String(*v.ThingTypeName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteTopicRule struct {
}

func (*awsRestjson1_serializeOpDeleteTopicRule) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteTopicRule) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteTopicRuleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/rules/{ruleName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteTopicRuleInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteTopicRuleInput(v *DeleteTopicRuleInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.RuleName == nil || len(*v.RuleName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ruleName must not be empty")}
	}
	if v.RuleName != nil {
		if err := encoder.SetURI("ruleName").String(*v.RuleName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteTopicRuleDestination struct {
}

func (*awsRestjson1_serializeOpDeleteTopicRuleDestination) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteTopicRuleDestination) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteTopicRuleDestinationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/destinations/{arn+}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteTopicRuleDestinationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteTopicRuleDestinationInput(v *DeleteTopicRuleDestinationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Arn == nil || len(*v.Arn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member arn must not be empty")}
	}
	if v.Arn != nil {
		if err := encoder.SetURI("arn").String(*v.Arn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteV2LoggingLevel struct {
}

func (*awsRestjson1_serializeOpDeleteV2LoggingLevel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteV2LoggingLevel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteV2LoggingLevelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2LoggingLevel")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteV2LoggingLevelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteV2LoggingLevelInput(v *DeleteV2LoggingLevelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TargetName != nil {
		encoder.SetQuery("targetName").String(*v.TargetName)
	}

	if len(v.TargetType) > 0 {
		encoder.SetQuery("targetType").String(string(v.TargetType))
	}

	return nil
}

type awsRestjson1_serializeOpDeprecateThingType struct {
}

func (*awsRestjson1_serializeOpDeprecateThingType) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeprecateThingType) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeprecateThingTypeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/thing-types/{thingTypeName}/deprecate")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeprecateThingTypeInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentDeprecateThingTypeInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeprecateThingTypeInput(v *DeprecateThingTypeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ThingTypeName == nil || len(*v.ThingTypeName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member thingTypeName must not be empty")}
	}
	if v.ThingTypeName != nil {
		if err := encoder.SetURI("thingTypeName").String(*v.ThingTypeName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentDeprecateThingTypeInput(v *DeprecateThingTypeInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.UndoDeprecate {
		ok := object.Key("undoDeprecate")
		ok.Boolean(v.UndoDeprecate)
	}

	return nil
}

type awsRestjson1_serializeOpDescribeAccountAuditConfiguration struct {
}

func (*awsRestjson1_serializeOpDescribeAccountAuditConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeAccountAuditConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeAccountAuditConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/audit/configuration")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeAccountAuditConfigurationInput(v *DescribeAccountAuditConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestjson1_serializeOpDescribeAuditFinding struct {
}

func (*awsRestjson1_serializeOpDescribeAuditFinding) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeAuditFinding) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeAuditFindingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/audit/findings/{findingId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeAuditFindingInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeAuditFindingInput(v *DescribeAuditFindingInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FindingId == nil || len(*v.FindingId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member findingId must not be empty")}
	}
	if v.FindingId != nil {
		if err := encoder.SetURI("findingId").String(*v.FindingId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeAuditMitigationActionsTask struct {
}

func (*awsRestjson1_serializeOpDescribeAuditMitigationActionsTask) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeAuditMitigationActionsTask) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeAuditMitigationActionsTaskInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/audit/mitigationactions/tasks/{taskId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeAuditMitigationActionsTaskInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeAuditMitigationActionsTaskInput(v *DescribeAuditMitigationActionsTaskInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TaskId == nil || len(*v.TaskId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member taskId must not be empty")}
	}
	if v.TaskId != nil {
		if err := encoder.SetURI("taskId").String(*v.TaskId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeAuditSuppression struct {
}

func (*awsRestjson1_serializeOpDescribeAuditSuppression) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeAuditSuppression) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeAuditSuppressionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/audit/suppressions/describe")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentDescribeAuditSuppressionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeAuditSuppressionInput(v *DescribeAuditSuppressionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentDescribeAuditSuppressionInput(v *DescribeAuditSuppressionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CheckName != nil {
		ok := object.Key("checkName")
		ok.String(*v.CheckName)
	}

	if v.ResourceIdentifier != nil {
		ok := object.Key("resourceIdentifier")
		if err := awsRestjson1_serializeDocumentResourceIdentifier(v.ResourceIdentifier, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeAuditTask struct {
}

func (*awsRestjson1_serializeOpDescribeAuditTask) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeAuditTask) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeAuditTaskInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/audit/tasks/{taskId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeAuditTaskInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeAuditTaskInput(v *DescribeAuditTaskInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TaskId == nil || len(*v.TaskId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member taskId must not be empty")}
	}
	if v.TaskId != nil {
		if err := encoder.SetURI("taskId").String(*v.TaskId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeAuthorizer struct {
}

func (*awsRestjson1_serializeOpDescribeAuthorizer) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeAuthorizer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeAuthorizerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/authorizer/{authorizerName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeAuthorizerInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeAuthorizerInput(v *DescribeAuthorizerInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AuthorizerName == nil || len(*v.AuthorizerName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member authorizerName must not be empty")}
	}
	if v.AuthorizerName != nil {
		if err := encoder.SetURI("authorizerName").String(*v.AuthorizerName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeBillingGroup struct {
}

func (*awsRestjson1_serializeOpDescribeBillingGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeBillingGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeBillingGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/billing-groups/{billingGroupName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeBillingGroupInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeBillingGroupInput(v *DescribeBillingGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BillingGroupName == nil || len(*v.BillingGroupName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member billingGroupName must not be empty")}
	}
	if v.BillingGroupName != nil {
		if err := encoder.SetURI("billingGroupName").String(*v.BillingGroupName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeCACertificate struct {
}

func (*awsRestjson1_serializeOpDescribeCACertificate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeCACertificate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeCACertificateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/cacertificate/{certificateId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeCACertificateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeCACertificateInput(v *DescribeCACertificateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CertificateId == nil || len(*v.CertificateId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member certificateId must not be empty")}
	}
	if v.CertificateId != nil {
		if err := encoder.SetURI("certificateId").String(*v.CertificateId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeCertificate struct {
}

func (*awsRestjson1_serializeOpDescribeCertificate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeCertificate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeCertificateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/certificates/{certificateId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeCertificateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeCertificateInput(v *DescribeCertificateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CertificateId == nil || len(*v.CertificateId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member certificateId must not be empty")}
	}
	if v.CertificateId != nil {
		if err := encoder.SetURI("certificateId").String(*v.CertificateId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeCustomMetric struct {
}

func (*awsRestjson1_serializeOpDescribeCustomMetric) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeCustomMetric) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeCustomMetricInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/custom-metric/{metricName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeCustomMetricInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeCustomMetricInput(v *DescribeCustomMetricInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MetricName == nil || len(*v.MetricName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member metricName must not be empty")}
	}
	if v.MetricName != nil {
		if err := encoder.SetURI("metricName").String(*v.MetricName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeDefaultAuthorizer struct {
}

func (*awsRestjson1_serializeOpDescribeDefaultAuthorizer) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeDefaultAuthorizer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeDefaultAuthorizerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/default-authorizer")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeDefaultAuthorizerInput(v *DescribeDefaultAuthorizerInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestjson1_serializeOpDescribeDetectMitigationActionsTask struct {
}

func (*awsRestjson1_serializeOpDescribeDetectMitigationActionsTask) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeDetectMitigationActionsTask) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeDetectMitigationActionsTaskInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/detect/mitigationactions/tasks/{taskId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeDetectMitigationActionsTaskInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeDetectMitigationActionsTaskInput(v *DescribeDetectMitigationActionsTaskInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TaskId == nil || len(*v.TaskId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member taskId must not be empty")}
	}
	if v.TaskId != nil {
		if err := encoder.SetURI("taskId").String(*v.TaskId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeDimension struct {
}

func (*awsRestjson1_serializeOpDescribeDimension) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeDimension) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeDimensionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/dimensions/{name}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeDimensionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeDimensionInput(v *DescribeDimensionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("name").String(*v.Name); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeDomainConfiguration struct {
}

func (*awsRestjson1_serializeOpDescribeDomainConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeDomainConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeDomainConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/domainConfigurations/{domainConfigurationName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeDomainConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeDomainConfigurationInput(v *DescribeDomainConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DomainConfigurationName == nil || len(*v.DomainConfigurationName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member domainConfigurationName must not be empty")}
	}
	if v.DomainConfigurationName != nil {
		if err := encoder.SetURI("domainConfigurationName").String(*v.DomainConfigurationName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeEndpoint struct {
}

func (*awsRestjson1_serializeOpDescribeEndpoint) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeEndpoint) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeEndpointInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/endpoint")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeEndpointInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeEndpointInput(v *DescribeEndpointInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.EndpointType != nil {
		encoder.SetQuery("endpointType").String(*v.EndpointType)
	}

	return nil
}

type awsRestjson1_serializeOpDescribeEventConfigurations struct {
}

func (*awsRestjson1_serializeOpDescribeEventConfigurations) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeEventConfigurations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeEventConfigurationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/event-configurations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeEventConfigurationsInput(v *DescribeEventConfigurationsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestjson1_serializeOpDescribeFleetMetric struct {
}

func (*awsRestjson1_serializeOpDescribeFleetMetric) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeFleetMetric) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeFleetMetricInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/fleet-metric/{metricName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeFleetMetricInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeFleetMetricInput(v *DescribeFleetMetricInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MetricName == nil || len(*v.MetricName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member metricName must not be empty")}
	}
	if v.MetricName != nil {
		if err := encoder.SetURI("metricName").String(*v.MetricName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeIndex struct {
}

func (*awsRestjson1_serializeOpDescribeIndex) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeIndex) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeIndexInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/indices/{indexName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeIndexInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeIndexInput(v *DescribeIndexInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.IndexName == nil || len(*v.IndexName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member indexName must not be empty")}
	}
	if v.IndexName != nil {
		if err := encoder.SetURI("indexName").String(*v.IndexName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeJob struct {
}

func (*awsRestjson1_serializeOpDescribeJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/jobs/{jobId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeJobInput(v *DescribeJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.JobId == nil || len(*v.JobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member jobId must not be empty")}
	}
	if v.JobId != nil {
		if err := encoder.SetURI("jobId").String(*v.JobId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeJobExecution struct {
}

func (*awsRestjson1_serializeOpDescribeJobExecution) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeJobExecution) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeJobExecutionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/things/{thingName}/jobs/{jobId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeJobExecutionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeJobExecutionInput(v *DescribeJobExecutionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ExecutionNumber != nil {
		encoder.SetQuery("executionNumber").Long(*v.ExecutionNumber)
	}

	if v.JobId == nil || len(*v.JobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member jobId must not be empty")}
	}
	if v.JobId != nil {
		if err := encoder.SetURI("jobId").String(*v.JobId); err != nil {
			return err
		}
	}

	if v.ThingName == nil || len(*v.ThingName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member thingName must not be empty")}
	}
	if v.ThingName != nil {
		if err := encoder.SetURI("thingName").String(*v.ThingName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeJobTemplate struct {
}

func (*awsRestjson1_serializeOpDescribeJobTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeJobTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeJobTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/job-templates/{jobTemplateId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeJobTemplateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeJobTemplateInput(v *DescribeJobTemplateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.JobTemplateId == nil || len(*v.JobTemplateId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member jobTemplateId must not be empty")}
	}
	if v.JobTemplateId != nil {
		if err := encoder.SetURI("jobTemplateId").String(*v.JobTemplateId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeManagedJobTemplate struct {
}

func (*awsRestjson1_serializeOpDescribeManagedJobTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeManagedJobTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeManagedJobTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/managed-job-templates/{templateName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeManagedJobTemplateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeManagedJobTemplateInput(v *DescribeManagedJobTemplateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TemplateName == nil || len(*v.TemplateName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member templateName must not be empty")}
	}
	if v.TemplateName != nil {
		if err := encoder.SetURI("templateName").String(*v.TemplateName); err != nil {
			return err
		}
	}

	if v.TemplateVersion != nil {
		encoder.SetQuery("templateVersion").String(*v.TemplateVersion)
	}

	return nil
}

type awsRestjson1_serializeOpDescribeMitigationAction struct {
}

func (*awsRestjson1_serializeOpDescribeMitigationAction) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeMitigationAction) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeMitigationActionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/mitigationactions/actions/{actionName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeMitigationActionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeMitigationActionInput(v *DescribeMitigationActionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ActionName == nil || len(*v.ActionName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member actionName must not be empty")}
	}
	if v.ActionName != nil {
		if err := encoder.SetURI("actionName").String(*v.ActionName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeProvisioningTemplate struct {
}

func (*awsRestjson1_serializeOpDescribeProvisioningTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeProvisioningTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeProvisioningTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/provisioning-templates/{templateName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeProvisioningTemplateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeProvisioningTemplateInput(v *DescribeProvisioningTemplateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TemplateName == nil || len(*v.TemplateName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member templateName must not be empty")}
	}
	if v.TemplateName != nil {
		if err := encoder.SetURI("templateName").String(*v.TemplateName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeProvisioningTemplateVersion struct {
}

func (*awsRestjson1_serializeOpDescribeProvisioningTemplateVersion) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeProvisioningTemplateVersion) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeProvisioningTemplateVersionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/provisioning-templates/{templateName}/versions/{versionId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeProvisioningTemplateVersionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeProvisioningTemplateVersionInput(v *DescribeProvisioningTemplateVersionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TemplateName == nil || len(*v.TemplateName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member templateName must not be empty")}
	}
	if v.TemplateName != nil {
		if err := encoder.SetURI("templateName").String(*v.TemplateName); err != nil {
			return err
		}
	}

	if v.VersionId == nil {
		return &smithy.SerializationError{Err: fmt.Errorf("input member versionId must not be empty")}
	}
	if v.VersionId != nil {
		if err := encoder.SetURI("versionId").Integer(*v.VersionId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeRoleAlias struct {
}

func (*awsRestjson1_serializeOpDescribeRoleAlias) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeRoleAlias) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeRoleAliasInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/role-aliases/{roleAlias}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeRoleAliasInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeRoleAliasInput(v *DescribeRoleAliasInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.RoleAlias == nil || len(*v.RoleAlias) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member roleAlias must not be empty")}
	}
	if v.RoleAlias != nil {
		if err := encoder.SetURI("roleAlias").String(*v.RoleAlias); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeScheduledAudit struct {
}

func (*awsRestjson1_serializeOpDescribeScheduledAudit) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeScheduledAudit) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeScheduledAuditInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/audit/scheduledaudits/{scheduledAuditName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeScheduledAuditInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeScheduledAuditInput(v *DescribeScheduledAuditInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ScheduledAuditName == nil || len(*v.ScheduledAuditName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member scheduledAuditName must not be empty")}
	}
	if v.ScheduledAuditName != nil {
		if err := encoder.SetURI("scheduledAuditName").String(*v.ScheduledAuditName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeSecurityProfile struct {
}

func (*awsRestjson1_serializeOpDescribeSecurityProfile) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeSecurityProfile) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeSecurityProfileInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/security-profiles/{securityProfileName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeSecurityProfileInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeSecurityProfileInput(v *DescribeSecurityProfileInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.SecurityProfileName == nil || len(*v.SecurityProfileName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member securityProfileName must not be empty")}
	}
	if v.SecurityProfileName != nil {
		if err := encoder.SetURI("securityProfileName").String(*v.SecurityProfileName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeStream struct {
}

func (*awsRestjson1_serializeOpDescribeStream) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeStream) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeStreamInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/streams/{streamId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeStreamInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeStreamInput(v *DescribeStreamInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.StreamId == nil || len(*v.StreamId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member streamId must not be empty")}
	}
	if v.StreamId != nil {
		if err := encoder.SetURI("streamId").String(*v.StreamId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeThing struct {
}

func (*awsRestjson1_serializeOpDescribeThing) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeThing) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeThingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/things/{thingName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeThingInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeThingInput(v *DescribeThingInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ThingName == nil || len(*v.ThingName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member thingName must not be empty")}
	}
	if v.ThingName != nil {
		if err := encoder.SetURI("thingName").String(*v.ThingName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeThingGroup struct {
}

func (*awsRestjson1_serializeOpDescribeThingGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeThingGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeThingGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/thing-groups/{thingGroupName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeThingGroupInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeThingGroupInput(v *DescribeThingGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ThingGroupName == nil || len(*v.ThingGroupName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member thingGroupName must not be empty")}
	}
	if v.ThingGroupName != nil {
		if err := encoder.SetURI("thingGroupName").String(*v.ThingGroupName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeThingRegistrationTask struct {
}

func (*awsRestjson1_serializeOpDescribeThingRegistrationTask) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeThingRegistrationTask) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeThingRegistrationTaskInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/thing-registration-tasks/{taskId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeThingRegistrationTaskInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeThingRegistrationTaskInput(v *DescribeThingRegistrationTaskInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TaskId == nil || len(*v.TaskId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member taskId must not be empty")}
	}
	if v.TaskId != nil {
		if err := encoder.SetURI("taskId").String(*v.TaskId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeThingType struct {
}

func (*awsRestjson1_serializeOpDescribeThingType) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeThingType) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeThingTypeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/thing-types/{thingTypeName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeThingTypeInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeThingTypeInput(v *DescribeThingTypeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ThingTypeName == nil || len(*v.ThingTypeName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member thingTypeName must not be empty")}
	}
	if v.ThingTypeName != nil {
		if err := encoder.SetURI("thingTypeName").String(*v.ThingTypeName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDetachPolicy struct {
}

func (*awsRestjson1_serializeOpDetachPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDetachPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DetachPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/target-policies/{policyName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDetachPolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentDetachPolicyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDetachPolicyInput(v *DetachPolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.PolicyName == nil || len(*v.PolicyName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member policyName must not be empty")}
	}
	if v.PolicyName != nil {
		if err := encoder.SetURI("policyName").String(*v.PolicyName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentDetachPolicyInput(v *DetachPolicyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Target != nil {
		ok := object.Key("target")
		ok.String(*v.Target)
	}

	return nil
}

type awsRestjson1_serializeOpDetachPrincipalPolicy struct {
}

func (*awsRestjson1_serializeOpDetachPrincipalPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDetachPrincipalPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DetachPrincipalPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/principal-policies/{policyName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDetachPrincipalPolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDetachPrincipalPolicyInput(v *DetachPrincipalPolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.PolicyName == nil || len(*v.PolicyName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member policyName must not be empty")}
	}
	if v.PolicyName != nil {
		if err := encoder.SetURI("policyName").String(*v.PolicyName); err != nil {
			return err
		}
	}

	if v.Principal != nil && len(*v.Principal) > 0 {
		locationName := "X-Amzn-Iot-Principal"
		encoder.SetHeader(locationName).String(*v.Principal)
	}

	return nil
}

type awsRestjson1_serializeOpDetachSecurityProfile struct {
}

func (*awsRestjson1_serializeOpDetachSecurityProfile) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDetachSecurityProfile) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DetachSecurityProfileInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/security-profiles/{securityProfileName}/targets")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDetachSecurityProfileInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDetachSecurityProfileInput(v *DetachSecurityProfileInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.SecurityProfileName == nil || len(*v.SecurityProfileName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member securityProfileName must not be empty")}
	}
	if v.SecurityProfileName != nil {
		if err := encoder.SetURI("securityProfileName").String(*v.SecurityProfileName); err != nil {
			return err
		}
	}

	if v.SecurityProfileTargetArn != nil {
		encoder.SetQuery("securityProfileTargetArn").String(*v.SecurityProfileTargetArn)
	}

	return nil
}

type awsRestjson1_serializeOpDetachThingPrincipal struct {
}

func (*awsRestjson1_serializeOpDetachThingPrincipal) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDetachThingPrincipal) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DetachThingPrincipalInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/things/{thingName}/principals")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDetachThingPrincipalInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDetachThingPrincipalInput(v *DetachThingPrincipalInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Principal != nil && len(*v.Principal) > 0 {
		locationName := "X-Amzn-Principal"
		encoder.SetHeader(locationName).String(*v.Principal)
	}

	if v.ThingName == nil || len(*v.ThingName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member thingName must not be empty")}
	}
	if v.ThingName != nil {
		if err := encoder.SetURI("thingName").String(*v.ThingName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDisableTopicRule struct {
}

func (*awsRestjson1_serializeOpDisableTopicRule) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDisableTopicRule) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisableTopicRuleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/rules/{ruleName}/disable")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDisableTopicRuleInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDisableTopicRuleInput(v *DisableTopicRuleInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.RuleName == nil || len(*v.RuleName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ruleName must not be empty")}
	}
	if v.RuleName != nil {
		if err := encoder.SetURI("ruleName").String(*v.RuleName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpEnableTopicRule struct {
}

func (*awsRestjson1_serializeOpEnableTopicRule) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpEnableTopicRule) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*EnableTopicRuleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/rules/{ruleName}/enable")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsEnableTopicRuleInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsEnableTopicRuleInput(v *EnableTopicRuleInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.RuleName == nil || len(*v.RuleName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ruleName must not be empty")}
	}
	if v.RuleName != nil {
		if err := encoder.SetURI("ruleName").String(*v.RuleName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetBehaviorModelTrainingSummaries struct {
}

func (*awsRestjson1_serializeOpGetBehaviorModelTrainingSummaries) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetBehaviorModelTrainingSummaries) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetBehaviorModelTrainingSummariesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/behavior-model-training/summaries")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetBehaviorModelTrainingSummariesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetBehaviorModelTrainingSummariesInput(v *GetBehaviorModelTrainingSummariesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.SecurityProfileName != nil {
		encoder.SetQuery("securityProfileName").String(*v.SecurityProfileName)
	}

	return nil
}

type awsRestjson1_serializeOpGetBucketsAggregation struct {
}

func (*awsRestjson1_serializeOpGetBucketsAggregation) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetBucketsAggregation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetBucketsAggregationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/indices/buckets")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentGetBucketsAggregationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetBucketsAggregationInput(v *GetBucketsAggregationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentGetBucketsAggregationInput(v *GetBucketsAggregationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AggregationField != nil {
		ok := object.Key("aggregationField")
		ok.String(*v.AggregationField)
	}

	if v.BucketsAggregationType != nil {
		ok := object.Key("bucketsAggregationType")
		if err := awsRestjson1_serializeDocumentBucketsAggregationType(v.BucketsAggregationType, ok); err != nil {
			return err
		}
	}

	if v.IndexName != nil {
		ok := object.Key("indexName")
		ok.String(*v.IndexName)
	}

	if v.QueryString != nil {
		ok := object.Key("queryString")
		ok.String(*v.QueryString)
	}

	if v.QueryVersion != nil {
		ok := object.Key("queryVersion")
		ok.String(*v.QueryVersion)
	}

	return nil
}

type awsRestjson1_serializeOpGetCardinality struct {
}

func (*awsRestjson1_serializeOpGetCardinality) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetCardinality) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetCardinalityInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/indices/cardinality")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentGetCardinalityInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetCardinalityInput(v *GetCardinalityInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentGetCardinalityInput(v *GetCardinalityInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AggregationField != nil {
		ok := object.Key("aggregationField")
		ok.String(*v.AggregationField)
	}

	if v.IndexName != nil {
		ok := object.Key("indexName")
		ok.String(*v.IndexName)
	}

	if v.QueryString != nil {
		ok := object.Key("queryString")
		ok.String(*v.QueryString)
	}

	if v.QueryVersion != nil {
		ok := object.Key("queryVersion")
		ok.String(*v.QueryVersion)
	}

	return nil
}

type awsRestjson1_serializeOpGetEffectivePolicies struct {
}

func (*awsRestjson1_serializeOpGetEffectivePolicies) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetEffectivePolicies) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetEffectivePoliciesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/effective-policies")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetEffectivePoliciesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentGetEffectivePoliciesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetEffectivePoliciesInput(v *GetEffectivePoliciesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ThingName != nil {
		encoder.SetQuery("thingName").String(*v.ThingName)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentGetEffectivePoliciesInput(v *GetEffectivePoliciesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CognitoIdentityPoolId != nil {
		ok := object.Key("cognitoIdentityPoolId")
		ok.String(*v.CognitoIdentityPoolId)
	}

	if v.Principal != nil {
		ok := object.Key("principal")
		ok.String(*v.Principal)
	}

	return nil
}

type awsRestjson1_serializeOpGetIndexingConfiguration struct {
}

func (*awsRestjson1_serializeOpGetIndexingConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetIndexingConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetIndexingConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/indexing/config")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetIndexingConfigurationInput(v *GetIndexingConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestjson1_serializeOpGetJobDocument struct {
}

func (*awsRestjson1_serializeOpGetJobDocument) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetJobDocument) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetJobDocumentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/jobs/{jobId}/job-document")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetJobDocumentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetJobDocumentInput(v *GetJobDocumentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.JobId == nil || len(*v.JobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member jobId must not be empty")}
	}
	if v.JobId != nil {
		if err := encoder.SetURI("jobId").String(*v.JobId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetLoggingOptions struct {
}

func (*awsRestjson1_serializeOpGetLoggingOptions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetLoggingOptions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetLoggingOptionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/loggingOptions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetLoggingOptionsInput(v *GetLoggingOptionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestjson1_serializeOpGetOTAUpdate struct {
}

func (*awsRestjson1_serializeOpGetOTAUpdate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetOTAUpdate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetOTAUpdateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/otaUpdates/{otaUpdateId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetOTAUpdateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetOTAUpdateInput(v *GetOTAUpdateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.OtaUpdateId == nil || len(*v.OtaUpdateId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member otaUpdateId must not be empty")}
	}
	if v.OtaUpdateId != nil {
		if err := encoder.SetURI("otaUpdateId").String(*v.OtaUpdateId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetPercentiles struct {
}

func (*awsRestjson1_serializeOpGetPercentiles) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetPercentiles) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetPercentilesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/indices/percentiles")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentGetPercentilesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetPercentilesInput(v *GetPercentilesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentGetPercentilesInput(v *GetPercentilesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AggregationField != nil {
		ok := object.Key("aggregationField")
		ok.String(*v.AggregationField)
	}

	if v.IndexName != nil {
		ok := object.Key("indexName")
		ok.String(*v.IndexName)
	}

	if v.Percents != nil {
		ok := object.Key("percents")
		if err := awsRestjson1_serializeDocumentPercentList(v.Percents, ok); err != nil {
			return err
		}
	}

	if v.QueryString != nil {
		ok := object.Key("queryString")
		ok.String(*v.QueryString)
	}

	if v.QueryVersion != nil {
		ok := object.Key("queryVersion")
		ok.String(*v.QueryVersion)
	}

	return nil
}

type awsRestjson1_serializeOpGetPolicy struct {
}

func (*awsRestjson1_serializeOpGetPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/policies/{policyName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetPolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetPolicyInput(v *GetPolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.PolicyName == nil || len(*v.PolicyName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member policyName must not be empty")}
	}
	if v.PolicyName != nil {
		if err := encoder.SetURI("policyName").String(*v.PolicyName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetPolicyVersion struct {
}

func (*awsRestjson1_serializeOpGetPolicyVersion) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetPolicyVersion) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetPolicyVersionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/policies/{policyName}/version/{policyVersionId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetPolicyVersionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetPolicyVersionInput(v *GetPolicyVersionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.PolicyName == nil || len(*v.PolicyName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member policyName must not be empty")}
	}
	if v.PolicyName != nil {
		if err := encoder.SetURI("policyName").String(*v.PolicyName); err != nil {
			return err
		}
	}

	if v.PolicyVersionId == nil || len(*v.PolicyVersionId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member policyVersionId must not be empty")}
	}
	if v.PolicyVersionId != nil {
		if err := encoder.SetURI("policyVersionId").String(*v.PolicyVersionId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetRegistrationCode struct {
}

func (*awsRestjson1_serializeOpGetRegistrationCode) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetRegistrationCode) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetRegistrationCodeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/registrationcode")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetRegistrationCodeInput(v *GetRegistrationCodeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestjson1_serializeOpGetStatistics struct {
}

func (*awsRestjson1_serializeOpGetStatistics) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetStatistics) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetStatisticsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/indices/statistics")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentGetStatisticsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetStatisticsInput(v *GetStatisticsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentGetStatisticsInput(v *GetStatisticsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AggregationField != nil {
		ok := object.Key("aggregationField")
		ok.String(*v.AggregationField)
	}

	if v.IndexName != nil {
		ok := object.Key("indexName")
		ok.String(*v.IndexName)
	}

	if v.QueryString != nil {
		ok := object.Key("queryString")
		ok.String(*v.QueryString)
	}

	if v.QueryVersion != nil {
		ok := object.Key("queryVersion")
		ok.String(*v.QueryVersion)
	}

	return nil
}

type awsRestjson1_serializeOpGetTopicRule struct {
}

func (*awsRestjson1_serializeOpGetTopicRule) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetTopicRule) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetTopicRuleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/rules/{ruleName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetTopicRuleInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetTopicRuleInput(v *GetTopicRuleInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.RuleName == nil || len(*v.RuleName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ruleName must not be empty")}
	}
	if v.RuleName != nil {
		if err := encoder.SetURI("ruleName").String(*v.RuleName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetTopicRuleDestination struct {
}

func (*awsRestjson1_serializeOpGetTopicRuleDestination) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetTopicRuleDestination) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetTopicRuleDestinationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/destinations/{arn+}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetTopicRuleDestinationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetTopicRuleDestinationInput(v *GetTopicRuleDestinationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Arn == nil || len(*v.Arn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member arn must not be empty")}
	}
	if v.Arn != nil {
		if err := encoder.SetURI("arn").String(*v.Arn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetV2LoggingOptions struct {
}

func (*awsRestjson1_serializeOpGetV2LoggingOptions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetV2LoggingOptions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetV2LoggingOptionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2LoggingOptions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetV2LoggingOptionsInput(v *GetV2LoggingOptionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestjson1_serializeOpListActiveViolations struct {
}

func (*awsRestjson1_serializeOpListActiveViolations) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListActiveViolations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListActiveViolationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/active-violations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListActiveViolationsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListActiveViolationsInput(v *ListActiveViolationsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if len(v.BehaviorCriteriaType) > 0 {
		encoder.SetQuery("behaviorCriteriaType").String(string(v.BehaviorCriteriaType))
	}

	if v.ListSuppressedAlerts != nil {
		encoder.SetQuery("listSuppressedAlerts").Boolean(*v.ListSuppressedAlerts)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.SecurityProfileName != nil {
		encoder.SetQuery("securityProfileName").String(*v.SecurityProfileName)
	}

	if v.ThingName != nil {
		encoder.SetQuery("thingName").String(*v.ThingName)
	}

	if len(v.VerificationState) > 0 {
		encoder.SetQuery("verificationState").String(string(v.VerificationState))
	}

	return nil
}

type awsRestjson1_serializeOpListAttachedPolicies struct {
}

func (*awsRestjson1_serializeOpListAttachedPolicies) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListAttachedPolicies) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListAttachedPoliciesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/attached-policies/{target}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListAttachedPoliciesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListAttachedPoliciesInput(v *ListAttachedPoliciesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Marker != nil {
		encoder.SetQuery("marker").String(*v.Marker)
	}

	if v.PageSize != nil {
		encoder.SetQuery("pageSize").Integer(*v.PageSize)
	}

	if v.Recursive {
		encoder.SetQuery("recursive").Boolean(v.Recursive)
	}

	if v.Target == nil || len(*v.Target) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member target must not be empty")}
	}
	if v.Target != nil {
		if err := encoder.SetURI("target").String(*v.Target); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListAuditFindings struct {
}

func (*awsRestjson1_serializeOpListAuditFindings) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListAuditFindings) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListAuditFindingsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/audit/findings")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListAuditFindingsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListAuditFindingsInput(v *ListAuditFindingsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListAuditFindingsInput(v *ListAuditFindingsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CheckName != nil {
		ok := object.Key("checkName")
		ok.String(*v.CheckName)
	}

	if v.EndTime != nil {
		ok := object.Key("endTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.EndTime))
	}

	if v.ListSuppressedFindings {
		ok := object.Key("listSuppressedFindings")
		ok.Boolean(v.ListSuppressedFindings)
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if v.ResourceIdentifier != nil {
		ok := object.Key("resourceIdentifier")
		if err := awsRestjson1_serializeDocumentResourceIdentifier(v.ResourceIdentifier, ok); err != nil {
			return err
		}
	}

	if v.StartTime != nil {
		ok := object.Key("startTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.StartTime))
	}

	if v.TaskId != nil {
		ok := object.Key("taskId")
		ok.String(*v.TaskId)
	}

	return nil
}

type awsRestjson1_serializeOpListAuditMitigationActionsExecutions struct {
}

func (*awsRestjson1_serializeOpListAuditMitigationActionsExecutions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListAuditMitigationActionsExecutions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListAuditMitigationActionsExecutionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/audit/mitigationactions/executions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListAuditMitigationActionsExecutionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListAuditMitigationActionsExecutionsInput(v *ListAuditMitigationActionsExecutionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if len(v.ActionStatus) > 0 {
		encoder.SetQuery("actionStatus").String(string(v.ActionStatus))
	}

	if v.FindingId != nil {
		encoder.SetQuery("findingId").String(*v.FindingId)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.TaskId != nil {
		encoder.SetQuery("taskId").String(*v.TaskId)
	}

	return nil
}

type awsRestjson1_serializeOpListAuditMitigationActionsTasks struct {
}

func (*awsRestjson1_serializeOpListAuditMitigationActionsTasks) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListAuditMitigationActionsTasks) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListAuditMitigationActionsTasksInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/audit/mitigationactions/tasks")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListAuditMitigationActionsTasksInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListAuditMitigationActionsTasksInput(v *ListAuditMitigationActionsTasksInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AuditTaskId != nil {
		encoder.SetQuery("auditTaskId").String(*v.AuditTaskId)
	}

	if v.EndTime != nil {
		encoder.SetQuery("endTime").String(smithytime.FormatDateTime(*v.EndTime))
	}

	if v.FindingId != nil {
		encoder.SetQuery("findingId").String(*v.FindingId)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.StartTime != nil {
		encoder.SetQuery("startTime").String(smithytime.FormatDateTime(*v.StartTime))
	}

	if len(v.TaskStatus) > 0 {
		encoder.SetQuery("taskStatus").String(string(v.TaskStatus))
	}

	return nil
}

type awsRestjson1_serializeOpListAuditSuppressions struct {
}

func (*awsRestjson1_serializeOpListAuditSuppressions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListAuditSuppressions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListAuditSuppressionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/audit/suppressions/list")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListAuditSuppressionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListAuditSuppressionsInput(v *ListAuditSuppressionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListAuditSuppressionsInput(v *ListAuditSuppressionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AscendingOrder {
		ok := object.Key("ascendingOrder")
		ok.Boolean(v.AscendingOrder)
	}

	if v.CheckName != nil {
		ok := object.Key("checkName")
		ok.String(*v.CheckName)
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if v.ResourceIdentifier != nil {
		ok := object.Key("resourceIdentifier")
		if err := awsRestjson1_serializeDocumentResourceIdentifier(v.ResourceIdentifier, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListAuditTasks struct {
}

func (*awsRestjson1_serializeOpListAuditTasks) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListAuditTasks) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListAuditTasksInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/audit/tasks")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListAuditTasksInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListAuditTasksInput(v *ListAuditTasksInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.EndTime != nil {
		encoder.SetQuery("endTime").String(smithytime.FormatDateTime(*v.EndTime))
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.StartTime != nil {
		encoder.SetQuery("startTime").String(smithytime.FormatDateTime(*v.StartTime))
	}

	if len(v.TaskStatus) > 0 {
		encoder.SetQuery("taskStatus").String(string(v.TaskStatus))
	}

	if len(v.TaskType) > 0 {
		encoder.SetQuery("taskType").String(string(v.TaskType))
	}

	return nil
}

type awsRestjson1_serializeOpListAuthorizers struct {
}

func (*awsRestjson1_serializeOpListAuthorizers) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListAuthorizers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListAuthorizersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/authorizers")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListAuthorizersInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListAuthorizersInput(v *ListAuthorizersInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AscendingOrder {
		encoder.SetQuery("isAscendingOrder").Boolean(v.AscendingOrder)
	}

	if v.Marker != nil {
		encoder.SetQuery("marker").String(*v.Marker)
	}

	if v.PageSize != nil {
		encoder.SetQuery("pageSize").Integer(*v.PageSize)
	}

	if len(v.Status) > 0 {
		encoder.SetQuery("status").String(string(v.Status))
	}

	return nil
}

type awsRestjson1_serializeOpListBillingGroups struct {
}

func (*awsRestjson1_serializeOpListBillingGroups) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListBillingGroups) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListBillingGroupsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/billing-groups")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListBillingGroupsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListBillingGroupsInput(v *ListBillingGroupsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NamePrefixFilter != nil {
		encoder.SetQuery("namePrefixFilter").String(*v.NamePrefixFilter)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListCACertificates struct {
}

func (*awsRestjson1_serializeOpListCACertificates) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListCACertificates) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListCACertificatesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/cacertificates")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListCACertificatesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListCACertificatesInput(v *ListCACertificatesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AscendingOrder {
		encoder.SetQuery("isAscendingOrder").Boolean(v.AscendingOrder)
	}

	if v.Marker != nil {
		encoder.SetQuery("marker").String(*v.Marker)
	}

	if v.PageSize != nil {
		encoder.SetQuery("pageSize").Integer(*v.PageSize)
	}

	return nil
}

type awsRestjson1_serializeOpListCertificates struct {
}

func (*awsRestjson1_serializeOpListCertificates) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListCertificates) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListCertificatesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/certificates")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListCertificatesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListCertificatesInput(v *ListCertificatesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AscendingOrder {
		encoder.SetQuery("isAscendingOrder").Boolean(v.AscendingOrder)
	}

	if v.Marker != nil {
		encoder.SetQuery("marker").String(*v.Marker)
	}

	if v.PageSize != nil {
		encoder.SetQuery("pageSize").Integer(*v.PageSize)
	}

	return nil
}

type awsRestjson1_serializeOpListCertificatesByCA struct {
}

func (*awsRestjson1_serializeOpListCertificatesByCA) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListCertificatesByCA) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListCertificatesByCAInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/certificates-by-ca/{caCertificateId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListCertificatesByCAInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListCertificatesByCAInput(v *ListCertificatesByCAInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AscendingOrder {
		encoder.SetQuery("isAscendingOrder").Boolean(v.AscendingOrder)
	}

	if v.CaCertificateId == nil || len(*v.CaCertificateId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member caCertificateId must not be empty")}
	}
	if v.CaCertificateId != nil {
		if err := encoder.SetURI("caCertificateId").String(*v.CaCertificateId); err != nil {
			return err
		}
	}

	if v.Marker != nil {
		encoder.SetQuery("marker").String(*v.Marker)
	}

	if v.PageSize != nil {
		encoder.SetQuery("pageSize").Integer(*v.PageSize)
	}

	return nil
}

type awsRestjson1_serializeOpListCustomMetrics struct {
}

func (*awsRestjson1_serializeOpListCustomMetrics) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListCustomMetrics) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListCustomMetricsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/custom-metrics")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListCustomMetricsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListCustomMetricsInput(v *ListCustomMetricsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListDetectMitigationActionsExecutions struct {
}

func (*awsRestjson1_serializeOpListDetectMitigationActionsExecutions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListDetectMitigationActionsExecutions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDetectMitigationActionsExecutionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/detect/mitigationactions/executions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListDetectMitigationActionsExecutionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListDetectMitigationActionsExecutionsInput(v *ListDetectMitigationActionsExecutionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.EndTime != nil {
		encoder.SetQuery("endTime").String(smithytime.FormatDateTime(*v.EndTime))
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.StartTime != nil {
		encoder.SetQuery("startTime").String(smithytime.FormatDateTime(*v.StartTime))
	}

	if v.TaskId != nil {
		encoder.SetQuery("taskId").String(*v.TaskId)
	}

	if v.ThingName != nil {
		encoder.SetQuery("thingName").String(*v.ThingName)
	}

	if v.ViolationId != nil {
		encoder.SetQuery("violationId").String(*v.ViolationId)
	}

	return nil
}

type awsRestjson1_serializeOpListDetectMitigationActionsTasks struct {
}

func (*awsRestjson1_serializeOpListDetectMitigationActionsTasks) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListDetectMitigationActionsTasks) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDetectMitigationActionsTasksInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/detect/mitigationactions/tasks")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListDetectMitigationActionsTasksInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListDetectMitigationActionsTasksInput(v *ListDetectMitigationActionsTasksInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.EndTime != nil {
		encoder.SetQuery("endTime").String(smithytime.FormatDateTime(*v.EndTime))
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.StartTime != nil {
		encoder.SetQuery("startTime").String(smithytime.FormatDateTime(*v.StartTime))
	}

	return nil
}

type awsRestjson1_serializeOpListDimensions struct {
}

func (*awsRestjson1_serializeOpListDimensions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListDimensions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDimensionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/dimensions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListDimensionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListDimensionsInput(v *ListDimensionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListDomainConfigurations struct {
}

func (*awsRestjson1_serializeOpListDomainConfigurations) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListDomainConfigurations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDomainConfigurationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/domainConfigurations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListDomainConfigurationsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListDomainConfigurationsInput(v *ListDomainConfigurationsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Marker != nil {
		encoder.SetQuery("marker").String(*v.Marker)
	}

	if v.PageSize != nil {
		encoder.SetQuery("pageSize").Integer(*v.PageSize)
	}

	if len(v.ServiceType) > 0 {
		encoder.SetQuery("serviceType").String(string(v.ServiceType))
	}

	return nil
}

type awsRestjson1_serializeOpListFleetMetrics struct {
}

func (*awsRestjson1_serializeOpListFleetMetrics) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListFleetMetrics) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListFleetMetricsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/fleet-metrics")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListFleetMetricsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListFleetMetricsInput(v *ListFleetMetricsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListIndices struct {
}

func (*awsRestjson1_serializeOpListIndices) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListIndices) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListIndicesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/indices")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListIndicesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListIndicesInput(v *ListIndicesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListJobExecutionsForJob struct {
}

func (*awsRestjson1_serializeOpListJobExecutionsForJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListJobExecutionsForJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListJobExecutionsForJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/jobs/{jobId}/things")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListJobExecutionsForJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListJobExecutionsForJobInput(v *ListJobExecutionsForJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.JobId == nil || len(*v.JobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member jobId must not be empty")}
	}
	if v.JobId != nil {
		if err := encoder.SetURI("jobId").String(*v.JobId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if len(v.Status) > 0 {
		encoder.SetQuery("status").String(string(v.Status))
	}

	return nil
}

type awsRestjson1_serializeOpListJobExecutionsForThing struct {
}

func (*awsRestjson1_serializeOpListJobExecutionsForThing) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListJobExecutionsForThing) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListJobExecutionsForThingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/things/{thingName}/jobs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListJobExecutionsForThingInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListJobExecutionsForThingInput(v *ListJobExecutionsForThingInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.JobId != nil {
		encoder.SetQuery("jobId").String(*v.JobId)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NamespaceId != nil {
		encoder.SetQuery("namespaceId").String(*v.NamespaceId)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if len(v.Status) > 0 {
		encoder.SetQuery("status").String(string(v.Status))
	}

	if v.ThingName == nil || len(*v.ThingName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member thingName must not be empty")}
	}
	if v.ThingName != nil {
		if err := encoder.SetURI("thingName").String(*v.ThingName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListJobs struct {
}

func (*awsRestjson1_serializeOpListJobs) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListJobs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListJobsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/jobs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListJobsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListJobsInput(v *ListJobsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NamespaceId != nil {
		encoder.SetQuery("namespaceId").String(*v.NamespaceId)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if len(v.Status) > 0 {
		encoder.SetQuery("status").String(string(v.Status))
	}

	if len(v.TargetSelection) > 0 {
		encoder.SetQuery("targetSelection").String(string(v.TargetSelection))
	}

	if v.ThingGroupId != nil {
		encoder.SetQuery("thingGroupId").String(*v.ThingGroupId)
	}

	if v.ThingGroupName != nil {
		encoder.SetQuery("thingGroupName").String(*v.ThingGroupName)
	}

	return nil
}

type awsRestjson1_serializeOpListJobTemplates struct {
}

func (*awsRestjson1_serializeOpListJobTemplates) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListJobTemplates) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListJobTemplatesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/job-templates")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListJobTemplatesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListJobTemplatesInput(v *ListJobTemplatesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListManagedJobTemplates struct {
}

func (*awsRestjson1_serializeOpListManagedJobTemplates) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListManagedJobTemplates) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListManagedJobTemplatesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/managed-job-templates")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListManagedJobTemplatesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListManagedJobTemplatesInput(v *ListManagedJobTemplatesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.TemplateName != nil {
		encoder.SetQuery("templateName").String(*v.TemplateName)
	}

	return nil
}

type awsRestjson1_serializeOpListMetricValues struct {
}

func (*awsRestjson1_serializeOpListMetricValues) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListMetricValues) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListMetricValuesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/metric-values")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListMetricValuesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListMetricValuesInput(v *ListMetricValuesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DimensionName != nil {
		encoder.SetQuery("dimensionName").String(*v.DimensionName)
	}

	if len(v.DimensionValueOperator) > 0 {
		encoder.SetQuery("dimensionValueOperator").String(string(v.DimensionValueOperator))
	}

	if v.EndTime != nil {
		encoder.SetQuery("endTime").String(smithytime.FormatDateTime(*v.EndTime))
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.MetricName != nil {
		encoder.SetQuery("metricName").String(*v.MetricName)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.StartTime != nil {
		encoder.SetQuery("startTime").String(smithytime.FormatDateTime(*v.StartTime))
	}

	if v.ThingName != nil {
		encoder.SetQuery("thingName").String(*v.ThingName)
	}

	return nil
}

type awsRestjson1_serializeOpListMitigationActions struct {
}

func (*awsRestjson1_serializeOpListMitigationActions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListMitigationActions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListMitigationActionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/mitigationactions/actions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListMitigationActionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListMitigationActionsInput(v *ListMitigationActionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if len(v.ActionType) > 0 {
		encoder.SetQuery("actionType").String(string(v.ActionType))
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListOTAUpdates struct {
}

func (*awsRestjson1_serializeOpListOTAUpdates) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListOTAUpdates) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListOTAUpdatesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/otaUpdates")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListOTAUpdatesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListOTAUpdatesInput(v *ListOTAUpdatesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if len(v.OtaUpdateStatus) > 0 {
		encoder.SetQuery("otaUpdateStatus").String(string(v.OtaUpdateStatus))
	}

	return nil
}

type awsRestjson1_serializeOpListOutgoingCertificates struct {
}

func (*awsRestjson1_serializeOpListOutgoingCertificates) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListOutgoingCertificates) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListOutgoingCertificatesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/certificates-out-going")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListOutgoingCertificatesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListOutgoingCertificatesInput(v *ListOutgoingCertificatesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AscendingOrder {
		encoder.SetQuery("isAscendingOrder").Boolean(v.AscendingOrder)
	}

	if v.Marker != nil {
		encoder.SetQuery("marker").String(*v.Marker)
	}

	if v.PageSize != nil {
		encoder.SetQuery("pageSize").Integer(*v.PageSize)
	}

	return nil
}

type awsRestjson1_serializeOpListPolicies struct {
}

func (*awsRestjson1_serializeOpListPolicies) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListPolicies) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListPoliciesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/policies")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListPoliciesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListPoliciesInput(v *ListPoliciesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AscendingOrder {
		encoder.SetQuery("isAscendingOrder").Boolean(v.AscendingOrder)
	}

	if v.Marker != nil {
		encoder.SetQuery("marker").String(*v.Marker)
	}

	if v.PageSize != nil {
		encoder.SetQuery("pageSize").Integer(*v.PageSize)
	}

	return nil
}

type awsRestjson1_serializeOpListPolicyPrincipals struct {
}

func (*awsRestjson1_serializeOpListPolicyPrincipals) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListPolicyPrincipals) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListPolicyPrincipalsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/policy-principals")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListPolicyPrincipalsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListPolicyPrincipalsInput(v *ListPolicyPrincipalsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AscendingOrder {
		encoder.SetQuery("isAscendingOrder").Boolean(v.AscendingOrder)
	}

	if v.Marker != nil {
		encoder.SetQuery("marker").String(*v.Marker)
	}

	if v.PageSize != nil {
		encoder.SetQuery("pageSize").Integer(*v.PageSize)
	}

	if v.PolicyName != nil && len(*v.PolicyName) > 0 {
		locationName := "X-Amzn-Iot-Policy"
		encoder.SetHeader(locationName).String(*v.PolicyName)
	}

	return nil
}

type awsRestjson1_serializeOpListPolicyVersions struct {
}

func (*awsRestjson1_serializeOpListPolicyVersions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListPolicyVersions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListPolicyVersionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/policies/{policyName}/version")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListPolicyVersionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListPolicyVersionsInput(v *ListPolicyVersionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.PolicyName == nil || len(*v.PolicyName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member policyName must not be empty")}
	}
	if v.PolicyName != nil {
		if err := encoder.SetURI("policyName").String(*v.PolicyName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListPrincipalPolicies struct {
}

func (*awsRestjson1_serializeOpListPrincipalPolicies) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListPrincipalPolicies) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListPrincipalPoliciesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/principal-policies")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListPrincipalPoliciesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListPrincipalPoliciesInput(v *ListPrincipalPoliciesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AscendingOrder {
		encoder.SetQuery("isAscendingOrder").Boolean(v.AscendingOrder)
	}

	if v.Marker != nil {
		encoder.SetQuery("marker").String(*v.Marker)
	}

	if v.PageSize != nil {
		encoder.SetQuery("pageSize").Integer(*v.PageSize)
	}

	if v.Principal != nil && len(*v.Principal) > 0 {
		locationName := "X-Amzn-Iot-Principal"
		encoder.SetHeader(locationName).String(*v.Principal)
	}

	return nil
}

type awsRestjson1_serializeOpListPrincipalThings struct {
}

func (*awsRestjson1_serializeOpListPrincipalThings) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListPrincipalThings) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListPrincipalThingsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/principals/things")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListPrincipalThingsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListPrincipalThingsInput(v *ListPrincipalThingsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.Principal != nil && len(*v.Principal) > 0 {
		locationName := "X-Amzn-Principal"
		encoder.SetHeader(locationName).String(*v.Principal)
	}

	return nil
}

type awsRestjson1_serializeOpListProvisioningTemplates struct {
}

func (*awsRestjson1_serializeOpListProvisioningTemplates) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListProvisioningTemplates) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListProvisioningTemplatesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/provisioning-templates")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListProvisioningTemplatesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListProvisioningTemplatesInput(v *ListProvisioningTemplatesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListProvisioningTemplateVersions struct {
}

func (*awsRestjson1_serializeOpListProvisioningTemplateVersions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListProvisioningTemplateVersions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListProvisioningTemplateVersionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/provisioning-templates/{templateName}/versions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListProvisioningTemplateVersionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListProvisioningTemplateVersionsInput(v *ListProvisioningTemplateVersionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.TemplateName == nil || len(*v.TemplateName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member templateName must not be empty")}
	}
	if v.TemplateName != nil {
		if err := encoder.SetURI("templateName").String(*v.TemplateName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListRoleAliases struct {
}

func (*awsRestjson1_serializeOpListRoleAliases) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListRoleAliases) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListRoleAliasesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/role-aliases")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListRoleAliasesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListRoleAliasesInput(v *ListRoleAliasesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AscendingOrder {
		encoder.SetQuery("isAscendingOrder").Boolean(v.AscendingOrder)
	}

	if v.Marker != nil {
		encoder.SetQuery("marker").String(*v.Marker)
	}

	if v.PageSize != nil {
		encoder.SetQuery("pageSize").Integer(*v.PageSize)
	}

	return nil
}

type awsRestjson1_serializeOpListScheduledAudits struct {
}

func (*awsRestjson1_serializeOpListScheduledAudits) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListScheduledAudits) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListScheduledAuditsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/audit/scheduledaudits")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListScheduledAuditsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListScheduledAuditsInput(v *ListScheduledAuditsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListSecurityProfiles struct {
}

func (*awsRestjson1_serializeOpListSecurityProfiles) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListSecurityProfiles) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListSecurityProfilesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/security-profiles")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListSecurityProfilesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListSecurityProfilesInput(v *ListSecurityProfilesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DimensionName != nil {
		encoder.SetQuery("dimensionName").String(*v.DimensionName)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.MetricName != nil {
		encoder.SetQuery("metricName").String(*v.MetricName)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListSecurityProfilesForTarget struct {
}

func (*awsRestjson1_serializeOpListSecurityProfilesForTarget) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListSecurityProfilesForTarget) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListSecurityProfilesForTargetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/security-profiles-for-target")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListSecurityProfilesForTargetInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListSecurityProfilesForTargetInput(v *ListSecurityProfilesForTargetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.Recursive {
		encoder.SetQuery("recursive").Boolean(v.Recursive)
	}

	if v.SecurityProfileTargetArn != nil {
		encoder.SetQuery("securityProfileTargetArn").String(*v.SecurityProfileTargetArn)
	}

	return nil
}

type awsRestjson1_serializeOpListStreams struct {
}

func (*awsRestjson1_serializeOpListStreams) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListStreams) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListStreamsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/streams")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListStreamsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListStreamsInput(v *ListStreamsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AscendingOrder {
		encoder.SetQuery("isAscendingOrder").Boolean(v.AscendingOrder)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListTagsForResource struct {
}

func (*awsRestjson1_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(v *ListTagsForResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.ResourceArn != nil {
		encoder.SetQuery("resourceArn").String(*v.ResourceArn)
	}

	return nil
}

type awsRestjson1_serializeOpListTargetsForPolicy struct {
}

func (*awsRestjson1_serializeOpListTargetsForPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTargetsForPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTargetsForPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/policy-targets/{policyName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTargetsForPolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTargetsForPolicyInput(v *ListTargetsForPolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Marker != nil {
		encoder.SetQuery("marker").String(*v.Marker)
	}

	if v.PageSize != nil {
		encoder.SetQuery("pageSize").Integer(*v.PageSize)
	}

	if v.PolicyName == nil || len(*v.PolicyName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member policyName must not be empty")}
	}
	if v.PolicyName != nil {
		if err := encoder.SetURI("policyName").String(*v.PolicyName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListTargetsForSecurityProfile struct {
}

func (*awsRestjson1_serializeOpListTargetsForSecurityProfile) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTargetsForSecurityProfile) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTargetsForSecurityProfileInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/security-profiles/{securityProfileName}/targets")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTargetsForSecurityProfileInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTargetsForSecurityProfileInput(v *ListTargetsForSecurityProfileInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.SecurityProfileName == nil || len(*v.SecurityProfileName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member securityProfileName must not be empty")}
	}
	if v.SecurityProfileName != nil {
		if err := encoder.SetURI("securityProfileName").String(*v.SecurityProfileName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListThingGroups struct {
}

func (*awsRestjson1_serializeOpListThingGroups) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListThingGroups) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListThingGroupsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/thing-groups")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListThingGroupsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListThingGroupsInput(v *ListThingGroupsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NamePrefixFilter != nil {
		encoder.SetQuery("namePrefixFilter").String(*v.NamePrefixFilter)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.ParentGroup != nil {
		encoder.SetQuery("parentGroup").String(*v.ParentGroup)
	}

	if v.Recursive != nil {
		encoder.SetQuery("recursive").Boolean(*v.Recursive)
	}

	return nil
}

type awsRestjson1_serializeOpListThingGroupsForThing struct {
}

func (*awsRestjson1_serializeOpListThingGroupsForThing) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListThingGroupsForThing) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListThingGroupsForThingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/things/{thingName}/thing-groups")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListThingGroupsForThingInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListThingGroupsForThingInput(v *ListThingGroupsForThingInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.ThingName == nil || len(*v.ThingName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member thingName must not be empty")}
	}
	if v.ThingName != nil {
		if err := encoder.SetURI("thingName").String(*v.ThingName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListThingPrincipals struct {
}

func (*awsRestjson1_serializeOpListThingPrincipals) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListThingPrincipals) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListThingPrincipalsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/things/{thingName}/principals")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListThingPrincipalsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListThingPrincipalsInput(v *ListThingPrincipalsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.ThingName == nil || len(*v.ThingName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member thingName must not be empty")}
	}
	if v.ThingName != nil {
		if err := encoder.SetURI("thingName").String(*v.ThingName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListThingRegistrationTaskReports struct {
}

func (*awsRestjson1_serializeOpListThingRegistrationTaskReports) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListThingRegistrationTaskReports) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListThingRegistrationTaskReportsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/thing-registration-tasks/{taskId}/reports")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListThingRegistrationTaskReportsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListThingRegistrationTaskReportsInput(v *ListThingRegistrationTaskReportsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if len(v.ReportType) > 0 {
		encoder.SetQuery("reportType").String(string(v.ReportType))
	}

	if v.TaskId == nil || len(*v.TaskId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member taskId must not be empty")}
	}
	if v.TaskId != nil {
		if err := encoder.SetURI("taskId").String(*v.TaskId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListThingRegistrationTasks struct {
}

func (*awsRestjson1_serializeOpListThingRegistrationTasks) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListThingRegistrationTasks) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListThingRegistrationTasksInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/thing-registration-tasks")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListThingRegistrationTasksInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListThingRegistrationTasksInput(v *ListThingRegistrationTasksInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if len(v.Status) > 0 {
		encoder.SetQuery("status").String(string(v.Status))
	}

	return nil
}

type awsRestjson1_serializeOpListThings struct {
}

func (*awsRestjson1_serializeOpListThings) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListThings) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListThingsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/things")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListThingsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListThingsInput(v *ListThingsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AttributeName != nil {
		encoder.SetQuery("attributeName").String(*v.AttributeName)
	}

	if v.AttributeValue != nil {
		encoder.SetQuery("attributeValue").String(*v.AttributeValue)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.ThingTypeName != nil {
		encoder.SetQuery("thingTypeName").String(*v.ThingTypeName)
	}

	if v.UsePrefixAttributeValue {
		encoder.SetQuery("usePrefixAttributeValue").Boolean(v.UsePrefixAttributeValue)
	}

	return nil
}

type awsRestjson1_serializeOpListThingsInBillingGroup struct {
}

func (*awsRestjson1_serializeOpListThingsInBillingGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListThingsInBillingGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListThingsInBillingGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/billing-groups/{billingGroupName}/things")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListThingsInBillingGroupInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListThingsInBillingGroupInput(v *ListThingsInBillingGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BillingGroupName == nil || len(*v.BillingGroupName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member billingGroupName must not be empty")}
	}
	if v.BillingGroupName != nil {
		if err := encoder.SetURI("billingGroupName").String(*v.BillingGroupName); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListThingsInThingGroup struct {
}

func (*awsRestjson1_serializeOpListThingsInThingGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListThingsInThingGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListThingsInThingGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/thing-groups/{thingGroupName}/things")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListThingsInThingGroupInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListThingsInThingGroupInput(v *ListThingsInThingGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.Recursive {
		encoder.SetQuery("recursive").Boolean(v.Recursive)
	}

	if v.ThingGroupName == nil || len(*v.ThingGroupName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member thingGroupName must not be empty")}
	}
	if v.ThingGroupName != nil {
		if err := encoder.SetURI("thingGroupName").String(*v.ThingGroupName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListThingTypes struct {
}

func (*awsRestjson1_serializeOpListThingTypes) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListThingTypes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListThingTypesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/thing-types")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListThingTypesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListThingTypesInput(v *ListThingTypesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.ThingTypeName != nil {
		encoder.SetQuery("thingTypeName").String(*v.ThingTypeName)
	}

	return nil
}

type awsRestjson1_serializeOpListTopicRuleDestinations struct {
}

func (*awsRestjson1_serializeOpListTopicRuleDestinations) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTopicRuleDestinations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTopicRuleDestinationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/destinations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTopicRuleDestinationsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTopicRuleDestinationsInput(v *ListTopicRuleDestinationsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListTopicRules struct {
}

func (*awsRestjson1_serializeOpListTopicRules) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTopicRules) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTopicRulesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/rules")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTopicRulesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTopicRulesInput(v *ListTopicRulesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.RuleDisabled != nil {
		encoder.SetQuery("ruleDisabled").Boolean(*v.RuleDisabled)
	}

	if v.Topic != nil {
		encoder.SetQuery("topic").String(*v.Topic)
	}

	return nil
}

type awsRestjson1_serializeOpListV2LoggingLevels struct {
}

func (*awsRestjson1_serializeOpListV2LoggingLevels) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListV2LoggingLevels) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListV2LoggingLevelsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2LoggingLevel")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListV2LoggingLevelsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListV2LoggingLevelsInput(v *ListV2LoggingLevelsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if len(v.TargetType) > 0 {
		encoder.SetQuery("targetType").String(string(v.TargetType))
	}

	return nil
}

type awsRestjson1_serializeOpListViolationEvents struct {
}

func (*awsRestjson1_serializeOpListViolationEvents) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListViolationEvents) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListViolationEventsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/violation-events")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListViolationEventsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListViolationEventsInput(v *ListViolationEventsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if len(v.BehaviorCriteriaType) > 0 {
		encoder.SetQuery("behaviorCriteriaType").String(string(v.BehaviorCriteriaType))
	}

	if v.EndTime != nil {
		encoder.SetQuery("endTime").String(smithytime.FormatDateTime(*v.EndTime))
	}

	if v.ListSuppressedAlerts != nil {
		encoder.SetQuery("listSuppressedAlerts").Boolean(*v.ListSuppressedAlerts)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.SecurityProfileName != nil {
		encoder.SetQuery("securityProfileName").String(*v.SecurityProfileName)
	}

	if v.StartTime != nil {
		encoder.SetQuery("startTime").String(smithytime.FormatDateTime(*v.StartTime))
	}

	if v.ThingName != nil {
		encoder.SetQuery("thingName").String(*v.ThingName)
	}

	if len(v.VerificationState) > 0 {
		encoder.SetQuery("verificationState").String(string(v.VerificationState))
	}

	return nil
}

type awsRestjson1_serializeOpPutVerificationStateOnViolation struct {
}

func (*awsRestjson1_serializeOpPutVerificationStateOnViolation) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPutVerificationStateOnViolation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutVerificationStateOnViolationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/violations/verification-state/{violationId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsPutVerificationStateOnViolationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentPutVerificationStateOnViolationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPutVerificationStateOnViolationInput(v *PutVerificationStateOnViolationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ViolationId == nil || len(*v.ViolationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member violationId must not be empty")}
	}
	if v.ViolationId != nil {
		if err := encoder.SetURI("violationId").String(*v.ViolationId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentPutVerificationStateOnViolationInput(v *PutVerificationStateOnViolationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.VerificationState) > 0 {
		ok := object.Key("verificationState")
		ok.String(string(v.VerificationState))
	}

	if v.VerificationStateDescription != nil {
		ok := object.Key("verificationStateDescription")
		ok.String(*v.VerificationStateDescription)
	}

	return nil
}

type awsRestjson1_serializeOpRegisterCACertificate struct {
}

func (*awsRestjson1_serializeOpRegisterCACertificate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpRegisterCACertificate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RegisterCACertificateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/cacertificate")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsRegisterCACertificateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentRegisterCACertificateInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsRegisterCACertificateInput(v *RegisterCACertificateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AllowAutoRegistration {
		encoder.SetQuery("allowAutoRegistration").Boolean(v.AllowAutoRegistration)
	}

	if v.SetAsActive {
		encoder.SetQuery("setAsActive").Boolean(v.SetAsActive)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentRegisterCACertificateInput(v *RegisterCACertificateInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CaCertificate != nil {
		ok := object.Key("caCertificate")
		ok.String(*v.CaCertificate)
	}

	if len(v.CertificateMode) > 0 {
		ok := object.Key("certificateMode")
		ok.String(string(v.CertificateMode))
	}

	if v.RegistrationConfig != nil {
		ok := object.Key("registrationConfig")
		if err := awsRestjson1_serializeDocumentRegistrationConfig(v.RegistrationConfig, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.VerificationCertificate != nil {
		ok := object.Key("verificationCertificate")
		ok.String(*v.VerificationCertificate)
	}

	return nil
}

type awsRestjson1_serializeOpRegisterCertificate struct {
}

func (*awsRestjson1_serializeOpRegisterCertificate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpRegisterCertificate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RegisterCertificateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/certificate/register")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsRegisterCertificateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentRegisterCertificateInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsRegisterCertificateInput(v *RegisterCertificateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.SetAsActive != nil {
		encoder.SetQuery("setAsActive").Boolean(*v.SetAsActive)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentRegisterCertificateInput(v *RegisterCertificateInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CaCertificatePem != nil {
		ok := object.Key("caCertificatePem")
		ok.String(*v.CaCertificatePem)
	}

	if v.CertificatePem != nil {
		ok := object.Key("certificatePem")
		ok.String(*v.CertificatePem)
	}

	if len(v.Status) > 0 {
		ok := object.Key("status")
		ok.String(string(v.Status))
	}

	return nil
}

type awsRestjson1_serializeOpRegisterCertificateWithoutCA struct {
}

func (*awsRestjson1_serializeOpRegisterCertificateWithoutCA) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpRegisterCertificateWithoutCA) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RegisterCertificateWithoutCAInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/certificate/register-no-ca")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentRegisterCertificateWithoutCAInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsRegisterCertificateWithoutCAInput(v *RegisterCertificateWithoutCAInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentRegisterCertificateWithoutCAInput(v *RegisterCertificateWithoutCAInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CertificatePem != nil {
		ok := object.Key("certificatePem")
		ok.String(*v.CertificatePem)
	}

	if len(v.Status) > 0 {
		ok := object.Key("status")
		ok.String(string(v.Status))
	}

	return nil
}

type awsRestjson1_serializeOpRegisterThing struct {
}

func (*awsRestjson1_serializeOpRegisterThing) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpRegisterThing) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RegisterThingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/things")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentRegisterThingInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsRegisterThingInput(v *RegisterThingInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentRegisterThingInput(v *RegisterThingInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Parameters != nil {
		ok := object.Key("parameters")
		if err := awsRestjson1_serializeDocumentParameters(v.Parameters, ok); err != nil {
			return err
		}
	}

	if v.TemplateBody != nil {
		ok := object.Key("templateBody")
		ok.String(*v.TemplateBody)
	}

	return nil
}

type awsRestjson1_serializeOpRejectCertificateTransfer struct {
}

func (*awsRestjson1_serializeOpRejectCertificateTransfer) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpRejectCertificateTransfer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RejectCertificateTransferInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/reject-certificate-transfer/{certificateId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsRejectCertificateTransferInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentRejectCertificateTransferInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsRejectCertificateTransferInput(v *RejectCertificateTransferInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CertificateId == nil || len(*v.CertificateId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member certificateId must not be empty")}
	}
	if v.CertificateId != nil {
		if err := encoder.SetURI("certificateId").String(*v.CertificateId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentRejectCertificateTransferInput(v *RejectCertificateTransferInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RejectReason != nil {
		ok := object.Key("rejectReason")
		ok.String(*v.RejectReason)
	}

	return nil
}

type awsRestjson1_serializeOpRemoveThingFromBillingGroup struct {
}

func (*awsRestjson1_serializeOpRemoveThingFromBillingGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpRemoveThingFromBillingGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RemoveThingFromBillingGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/billing-groups/removeThingFromBillingGroup")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentRemoveThingFromBillingGroupInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsRemoveThingFromBillingGroupInput(v *RemoveThingFromBillingGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentRemoveThingFromBillingGroupInput(v *RemoveThingFromBillingGroupInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BillingGroupArn != nil {
		ok := object.Key("billingGroupArn")
		ok.String(*v.BillingGroupArn)
	}

	if v.BillingGroupName != nil {
		ok := object.Key("billingGroupName")
		ok.String(*v.BillingGroupName)
	}

	if v.ThingArn != nil {
		ok := object.Key("thingArn")
		ok.String(*v.ThingArn)
	}

	if v.ThingName != nil {
		ok := object.Key("thingName")
		ok.String(*v.ThingName)
	}

	return nil
}

type awsRestjson1_serializeOpRemoveThingFromThingGroup struct {
}

func (*awsRestjson1_serializeOpRemoveThingFromThingGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpRemoveThingFromThingGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RemoveThingFromThingGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/thing-groups/removeThingFromThingGroup")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentRemoveThingFromThingGroupInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsRemoveThingFromThingGroupInput(v *RemoveThingFromThingGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentRemoveThingFromThingGroupInput(v *RemoveThingFromThingGroupInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ThingArn != nil {
		ok := object.Key("thingArn")
		ok.String(*v.ThingArn)
	}

	if v.ThingGroupArn != nil {
		ok := object.Key("thingGroupArn")
		ok.String(*v.ThingGroupArn)
	}

	if v.ThingGroupName != nil {
		ok := object.Key("thingGroupName")
		ok.String(*v.ThingGroupName)
	}

	if v.ThingName != nil {
		ok := object.Key("thingName")
		ok.String(*v.ThingName)
	}

	return nil
}

type awsRestjson1_serializeOpReplaceTopicRule struct {
}

func (*awsRestjson1_serializeOpReplaceTopicRule) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpReplaceTopicRule) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ReplaceTopicRuleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/rules/{ruleName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsReplaceTopicRuleInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if !restEncoder.HasHeader("Content-Type") {
		ctx = smithyhttp.SetIsContentTypeDefaultValue(ctx, true)
		restEncoder.SetHeader("Content-Type").String("application/json")
	}

	if input.TopicRulePayload != nil {
		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentTopicRulePayload(input.TopicRulePayload, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	} else {
		jsonEncoder := smithyjson.NewEncoder()
		jsonEncoder.Value.Object().Close()
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}

	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsReplaceTopicRuleInput(v *ReplaceTopicRuleInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.RuleName == nil || len(*v.RuleName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ruleName must not be empty")}
	}
	if v.RuleName != nil {
		if err := encoder.SetURI("ruleName").String(*v.RuleName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpSearchIndex struct {
}

func (*awsRestjson1_serializeOpSearchIndex) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpSearchIndex) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SearchIndexInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/indices/search")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentSearchIndexInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsSearchIndexInput(v *SearchIndexInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentSearchIndexInput(v *SearchIndexInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IndexName != nil {
		ok := object.Key("indexName")
		ok.String(*v.IndexName)
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if v.QueryString != nil {
		ok := object.Key("queryString")
		ok.String(*v.QueryString)
	}

	if v.QueryVersion != nil {
		ok := object.Key("queryVersion")
		ok.String(*v.QueryVersion)
	}

	return nil
}

type awsRestjson1_serializeOpSetDefaultAuthorizer struct {
}

func (*awsRestjson1_serializeOpSetDefaultAuthorizer) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpSetDefaultAuthorizer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SetDefaultAuthorizerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/default-authorizer")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentSetDefaultAuthorizerInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsSetDefaultAuthorizerInput(v *SetDefaultAuthorizerInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentSetDefaultAuthorizerInput(v *SetDefaultAuthorizerInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AuthorizerName != nil {
		ok := object.Key("authorizerName")
		ok.String(*v.AuthorizerName)
	}

	return nil
}

type awsRestjson1_serializeOpSetDefaultPolicyVersion struct {
}

func (*awsRestjson1_serializeOpSetDefaultPolicyVersion) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpSetDefaultPolicyVersion) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SetDefaultPolicyVersionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/policies/{policyName}/version/{policyVersionId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsSetDefaultPolicyVersionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsSetDefaultPolicyVersionInput(v *SetDefaultPolicyVersionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.PolicyName == nil || len(*v.PolicyName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member policyName must not be empty")}
	}
	if v.PolicyName != nil {
		if err := encoder.SetURI("policyName").String(*v.PolicyName); err != nil {
			return err
		}
	}

	if v.PolicyVersionId == nil || len(*v.PolicyVersionId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member policyVersionId must not be empty")}
	}
	if v.PolicyVersionId != nil {
		if err := encoder.SetURI("policyVersionId").String(*v.PolicyVersionId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpSetLoggingOptions struct {
}

func (*awsRestjson1_serializeOpSetLoggingOptions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpSetLoggingOptions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SetLoggingOptionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/loggingOptions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if !restEncoder.HasHeader("Content-Type") {
		ctx = smithyhttp.SetIsContentTypeDefaultValue(ctx, true)
		restEncoder.SetHeader("Content-Type").String("application/json")
	}

	if input.LoggingOptionsPayload != nil {
		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentLoggingOptionsPayload(input.LoggingOptionsPayload, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	} else {
		jsonEncoder := smithyjson.NewEncoder()
		jsonEncoder.Value.Object().Close()
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}

	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsSetLoggingOptionsInput(v *SetLoggingOptionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestjson1_serializeOpSetV2LoggingLevel struct {
}

func (*awsRestjson1_serializeOpSetV2LoggingLevel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpSetV2LoggingLevel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SetV2LoggingLevelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2LoggingLevel")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentSetV2LoggingLevelInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsSetV2LoggingLevelInput(v *SetV2LoggingLevelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentSetV2LoggingLevelInput(v *SetV2LoggingLevelInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.LogLevel) > 0 {
		ok := object.Key("logLevel")
		ok.String(string(v.LogLevel))
	}

	if v.LogTarget != nil {
		ok := object.Key("logTarget")
		if err := awsRestjson1_serializeDocumentLogTarget(v.LogTarget, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpSetV2LoggingOptions struct {
}

func (*awsRestjson1_serializeOpSetV2LoggingOptions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpSetV2LoggingOptions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SetV2LoggingOptionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2LoggingOptions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentSetV2LoggingOptionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsSetV2LoggingOptionsInput(v *SetV2LoggingOptionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentSetV2LoggingOptionsInput(v *SetV2LoggingOptionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.DefaultLogLevel) > 0 {
		ok := object.Key("defaultLogLevel")
		ok.String(string(v.DefaultLogLevel))
	}

	if v.DisableAllLogs {
		ok := object.Key("disableAllLogs")
		ok.Boolean(v.DisableAllLogs)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	return nil
}

type awsRestjson1_serializeOpStartAuditMitigationActionsTask struct {
}

func (*awsRestjson1_serializeOpStartAuditMitigationActionsTask) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartAuditMitigationActionsTask) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartAuditMitigationActionsTaskInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/audit/mitigationactions/tasks/{taskId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsStartAuditMitigationActionsTaskInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentStartAuditMitigationActionsTaskInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartAuditMitigationActionsTaskInput(v *StartAuditMitigationActionsTaskInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TaskId == nil || len(*v.TaskId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member taskId must not be empty")}
	}
	if v.TaskId != nil {
		if err := encoder.SetURI("taskId").String(*v.TaskId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentStartAuditMitigationActionsTaskInput(v *StartAuditMitigationActionsTaskInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AuditCheckToActionsMapping != nil {
		ok := object.Key("auditCheckToActionsMapping")
		if err := awsRestjson1_serializeDocumentAuditCheckToActionsMapping(v.AuditCheckToActionsMapping, ok); err != nil {
			return err
		}
	}

	if v.ClientRequestToken != nil {
		ok := object.Key("clientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.Target != nil {
		ok := object.Key("target")
		if err := awsRestjson1_serializeDocumentAuditMitigationActionsTaskTarget(v.Target, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpStartDetectMitigationActionsTask struct {
}

func (*awsRestjson1_serializeOpStartDetectMitigationActionsTask) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartDetectMitigationActionsTask) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartDetectMitigationActionsTaskInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/detect/mitigationactions/tasks/{taskId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsStartDetectMitigationActionsTaskInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentStartDetectMitigationActionsTaskInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartDetectMitigationActionsTaskInput(v *StartDetectMitigationActionsTaskInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TaskId == nil || len(*v.TaskId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member taskId must not be empty")}
	}
	if v.TaskId != nil {
		if err := encoder.SetURI("taskId").String(*v.TaskId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentStartDetectMitigationActionsTaskInput(v *StartDetectMitigationActionsTaskInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Actions != nil {
		ok := object.Key("actions")
		if err := awsRestjson1_serializeDocumentDetectMitigationActionsToExecuteList(v.Actions, ok); err != nil {
			return err
		}
	}

	if v.ClientRequestToken != nil {
		ok := object.Key("clientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.IncludeOnlyActiveViolations != nil {
		ok := object.Key("includeOnlyActiveViolations")
		ok.Boolean(*v.IncludeOnlyActiveViolations)
	}

	if v.IncludeSuppressedAlerts != nil {
		ok := object.Key("includeSuppressedAlerts")
		ok.Boolean(*v.IncludeSuppressedAlerts)
	}

	if v.Target != nil {
		ok := object.Key("target")
		if err := awsRestjson1_serializeDocumentDetectMitigationActionsTaskTarget(v.Target, ok); err != nil {
			return err
		}
	}

	if v.ViolationEventOccurrenceRange != nil {
		ok := object.Key("violationEventOccurrenceRange")
		if err := awsRestjson1_serializeDocumentViolationEventOccurrenceRange(v.ViolationEventOccurrenceRange, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpStartOnDemandAuditTask struct {
}

func (*awsRestjson1_serializeOpStartOnDemandAuditTask) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartOnDemandAuditTask) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartOnDemandAuditTaskInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/audit/tasks")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentStartOnDemandAuditTaskInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartOnDemandAuditTaskInput(v *StartOnDemandAuditTaskInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentStartOnDemandAuditTaskInput(v *StartOnDemandAuditTaskInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TargetCheckNames != nil {
		ok := object.Key("targetCheckNames")
		if err := awsRestjson1_serializeDocumentTargetAuditCheckNames(v.TargetCheckNames, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpStartThingRegistrationTask struct {
}

func (*awsRestjson1_serializeOpStartThingRegistrationTask) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartThingRegistrationTask) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartThingRegistrationTaskInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/thing-registration-tasks")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentStartThingRegistrationTaskInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartThingRegistrationTaskInput(v *StartThingRegistrationTaskInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentStartThingRegistrationTaskInput(v *StartThingRegistrationTaskInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InputFileBucket != nil {
		ok := object.Key("inputFileBucket")
		ok.String(*v.InputFileBucket)
	}

	if v.InputFileKey != nil {
		ok := object.Key("inputFileKey")
		ok.String(*v.InputFileKey)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.TemplateBody != nil {
		ok := object.Key("templateBody")
		ok.String(*v.TemplateBody)
	}

	return nil
}

type awsRestjson1_serializeOpStopThingRegistrationTask struct {
}

func (*awsRestjson1_serializeOpStopThingRegistrationTask) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStopThingRegistrationTask) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StopThingRegistrationTaskInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/thing-registration-tasks/{taskId}/cancel")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsStopThingRegistrationTaskInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStopThingRegistrationTaskInput(v *StopThingRegistrationTaskInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TaskId == nil || len(*v.TaskId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member taskId must not be empty")}
	}
	if v.TaskId != nil {
		if err := encoder.SetURI("taskId").String(*v.TaskId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpTagResource struct {
}

func (*awsRestjson1_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsTagResourceInput(v *TagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceArn != nil {
		ok := object.Key("resourceArn")
		ok.String(*v.ResourceArn)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpTestAuthorization struct {
}

func (*awsRestjson1_serializeOpTestAuthorization) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpTestAuthorization) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TestAuthorizationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/test-authorization")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsTestAuthorizationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentTestAuthorizationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsTestAuthorizationInput(v *TestAuthorizationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClientId != nil {
		encoder.SetQuery("clientId").String(*v.ClientId)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentTestAuthorizationInput(v *TestAuthorizationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AuthInfos != nil {
		ok := object.Key("authInfos")
		if err := awsRestjson1_serializeDocumentAuthInfos(v.AuthInfos, ok); err != nil {
			return err
		}
	}

	if v.CognitoIdentityPoolId != nil {
		ok := object.Key("cognitoIdentityPoolId")
		ok.String(*v.CognitoIdentityPoolId)
	}

	if v.PolicyNamesToAdd != nil {
		ok := object.Key("policyNamesToAdd")
		if err := awsRestjson1_serializeDocumentPolicyNames(v.PolicyNamesToAdd, ok); err != nil {
			return err
		}
	}

	if v.PolicyNamesToSkip != nil {
		ok := object.Key("policyNamesToSkip")
		if err := awsRestjson1_serializeDocumentPolicyNames(v.PolicyNamesToSkip, ok); err != nil {
			return err
		}
	}

	if v.Principal != nil {
		ok := object.Key("principal")
		ok.String(*v.Principal)
	}

	return nil
}

type awsRestjson1_serializeOpTestInvokeAuthorizer struct {
}

func (*awsRestjson1_serializeOpTestInvokeAuthorizer) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpTestInvokeAuthorizer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TestInvokeAuthorizerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/authorizer/{authorizerName}/test")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsTestInvokeAuthorizerInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentTestInvokeAuthorizerInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsTestInvokeAuthorizerInput(v *TestInvokeAuthorizerInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AuthorizerName == nil || len(*v.AuthorizerName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member authorizerName must not be empty")}
	}
	if v.AuthorizerName != nil {
		if err := encoder.SetURI("authorizerName").String(*v.AuthorizerName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentTestInvokeAuthorizerInput(v *TestInvokeAuthorizerInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.HttpContext != nil {
		ok := object.Key("httpContext")
		if err := awsRestjson1_serializeDocumentHttpContext(v.HttpContext, ok); err != nil {
			return err
		}
	}

	if v.MqttContext != nil {
		ok := object.Key("mqttContext")
		if err := awsRestjson1_serializeDocumentMqttContext(v.MqttContext, ok); err != nil {
			return err
		}
	}

	if v.TlsContext != nil {
		ok := object.Key("tlsContext")
		if err := awsRestjson1_serializeDocumentTlsContext(v.TlsContext, ok); err != nil {
			return err
		}
	}

	if v.Token != nil {
		ok := object.Key("token")
		ok.String(*v.Token)
	}

	if v.TokenSignature != nil {
		ok := object.Key("tokenSignature")
		ok.String(*v.TokenSignature)
	}

	return nil
}

type awsRestjson1_serializeOpTransferCertificate struct {
}

func (*awsRestjson1_serializeOpTransferCertificate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpTransferCertificate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TransferCertificateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/transfer-certificate/{certificateId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsTransferCertificateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentTransferCertificateInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsTransferCertificateInput(v *TransferCertificateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CertificateId == nil || len(*v.CertificateId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member certificateId must not be empty")}
	}
	if v.CertificateId != nil {
		if err := encoder.SetURI("certificateId").String(*v.CertificateId); err != nil {
			return err
		}
	}

	if v.TargetAwsAccount != nil {
		encoder.SetQuery("targetAwsAccount").String(*v.TargetAwsAccount)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentTransferCertificateInput(v *TransferCertificateInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TransferMessage != nil {
		ok := object.Key("transferMessage")
		ok.String(*v.TransferMessage)
	}

	return nil
}

type awsRestjson1_serializeOpUntagResource struct {
}

func (*awsRestjson1_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/untag")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUntagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUntagResourceInput(v *UntagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUntagResourceInput(v *UntagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceArn != nil {
		ok := object.Key("resourceArn")
		ok.String(*v.ResourceArn)
	}

	if v.TagKeys != nil {
		ok := object.Key("tagKeys")
		if err := awsRestjson1_serializeDocumentTagKeyList(v.TagKeys, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateAccountAuditConfiguration struct {
}

func (*awsRestjson1_serializeOpUpdateAccountAuditConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateAccountAuditConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateAccountAuditConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/audit/configuration")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateAccountAuditConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateAccountAuditConfigurationInput(v *UpdateAccountAuditConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateAccountAuditConfigurationInput(v *UpdateAccountAuditConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AuditCheckConfigurations != nil {
		ok := object.Key("auditCheckConfigurations")
		if err := awsRestjson1_serializeDocumentAuditCheckConfigurations(v.AuditCheckConfigurations, ok); err != nil {
			return err
		}
	}

	if v.AuditNotificationTargetConfigurations != nil {
		ok := object.Key("auditNotificationTargetConfigurations")
		if err := awsRestjson1_serializeDocumentAuditNotificationTargetConfigurations(v.AuditNotificationTargetConfigurations, ok); err != nil {
			return err
		}
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateAuditSuppression struct {
}

func (*awsRestjson1_serializeOpUpdateAuditSuppression) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateAuditSuppression) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateAuditSuppressionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/audit/suppressions/update")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateAuditSuppressionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateAuditSuppressionInput(v *UpdateAuditSuppressionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateAuditSuppressionInput(v *UpdateAuditSuppressionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CheckName != nil {
		ok := object.Key("checkName")
		ok.String(*v.CheckName)
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.ExpirationDate != nil {
		ok := object.Key("expirationDate")
		ok.Double(smithytime.FormatEpochSeconds(*v.ExpirationDate))
	}

	if v.ResourceIdentifier != nil {
		ok := object.Key("resourceIdentifier")
		if err := awsRestjson1_serializeDocumentResourceIdentifier(v.ResourceIdentifier, ok); err != nil {
			return err
		}
	}

	if v.SuppressIndefinitely != nil {
		ok := object.Key("suppressIndefinitely")
		ok.Boolean(*v.SuppressIndefinitely)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateAuthorizer struct {
}

func (*awsRestjson1_serializeOpUpdateAuthorizer) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateAuthorizer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateAuthorizerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/authorizer/{authorizerName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateAuthorizerInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateAuthorizerInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateAuthorizerInput(v *UpdateAuthorizerInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AuthorizerName == nil || len(*v.AuthorizerName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member authorizerName must not be empty")}
	}
	if v.AuthorizerName != nil {
		if err := encoder.SetURI("authorizerName").String(*v.AuthorizerName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateAuthorizerInput(v *UpdateAuthorizerInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AuthorizerFunctionArn != nil {
		ok := object.Key("authorizerFunctionArn")
		ok.String(*v.AuthorizerFunctionArn)
	}

	if v.EnableCachingForHttp != nil {
		ok := object.Key("enableCachingForHttp")
		ok.Boolean(*v.EnableCachingForHttp)
	}

	if len(v.Status) > 0 {
		ok := object.Key("status")
		ok.String(string(v.Status))
	}

	if v.TokenKeyName != nil {
		ok := object.Key("tokenKeyName")
		ok.String(*v.TokenKeyName)
	}

	if v.TokenSigningPublicKeys != nil {
		ok := object.Key("tokenSigningPublicKeys")
		if err := awsRestjson1_serializeDocumentPublicKeyMap(v.TokenSigningPublicKeys, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateBillingGroup struct {
}

func (*awsRestjson1_serializeOpUpdateBillingGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateBillingGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateBillingGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/billing-groups/{billingGroupName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateBillingGroupInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateBillingGroupInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateBillingGroupInput(v *UpdateBillingGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BillingGroupName == nil || len(*v.BillingGroupName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member billingGroupName must not be empty")}
	}
	if v.BillingGroupName != nil {
		if err := encoder.SetURI("billingGroupName").String(*v.BillingGroupName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateBillingGroupInput(v *UpdateBillingGroupInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BillingGroupProperties != nil {
		ok := object.Key("billingGroupProperties")
		if err := awsRestjson1_serializeDocumentBillingGroupProperties(v.BillingGroupProperties, ok); err != nil {
			return err
		}
	}

	if v.ExpectedVersion != nil {
		ok := object.Key("expectedVersion")
		ok.Long(*v.ExpectedVersion)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateCACertificate struct {
}

func (*awsRestjson1_serializeOpUpdateCACertificate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateCACertificate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateCACertificateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/cacertificate/{certificateId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateCACertificateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateCACertificateInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateCACertificateInput(v *UpdateCACertificateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CertificateId == nil || len(*v.CertificateId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member certificateId must not be empty")}
	}
	if v.CertificateId != nil {
		if err := encoder.SetURI("certificateId").String(*v.CertificateId); err != nil {
			return err
		}
	}

	if len(v.NewAutoRegistrationStatus) > 0 {
		encoder.SetQuery("newAutoRegistrationStatus").String(string(v.NewAutoRegistrationStatus))
	}

	if len(v.NewStatus) > 0 {
		encoder.SetQuery("newStatus").String(string(v.NewStatus))
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateCACertificateInput(v *UpdateCACertificateInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RegistrationConfig != nil {
		ok := object.Key("registrationConfig")
		if err := awsRestjson1_serializeDocumentRegistrationConfig(v.RegistrationConfig, ok); err != nil {
			return err
		}
	}

	if v.RemoveAutoRegistration {
		ok := object.Key("removeAutoRegistration")
		ok.Boolean(v.RemoveAutoRegistration)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateCertificate struct {
}

func (*awsRestjson1_serializeOpUpdateCertificate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateCertificate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateCertificateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/certificates/{certificateId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateCertificateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateCertificateInput(v *UpdateCertificateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CertificateId == nil || len(*v.CertificateId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member certificateId must not be empty")}
	}
	if v.CertificateId != nil {
		if err := encoder.SetURI("certificateId").String(*v.CertificateId); err != nil {
			return err
		}
	}

	if len(v.NewStatus) > 0 {
		encoder.SetQuery("newStatus").String(string(v.NewStatus))
	}

	return nil
}

type awsRestjson1_serializeOpUpdateCustomMetric struct {
}

func (*awsRestjson1_serializeOpUpdateCustomMetric) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateCustomMetric) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateCustomMetricInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/custom-metric/{metricName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateCustomMetricInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateCustomMetricInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateCustomMetricInput(v *UpdateCustomMetricInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MetricName == nil || len(*v.MetricName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member metricName must not be empty")}
	}
	if v.MetricName != nil {
		if err := encoder.SetURI("metricName").String(*v.MetricName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateCustomMetricInput(v *UpdateCustomMetricInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DisplayName != nil {
		ok := object.Key("displayName")
		ok.String(*v.DisplayName)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateDimension struct {
}

func (*awsRestjson1_serializeOpUpdateDimension) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateDimension) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateDimensionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/dimensions/{name}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateDimensionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateDimensionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateDimensionInput(v *UpdateDimensionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("name").String(*v.Name); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateDimensionInput(v *UpdateDimensionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.StringValues != nil {
		ok := object.Key("stringValues")
		if err := awsRestjson1_serializeDocumentDimensionStringValues(v.StringValues, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateDomainConfiguration struct {
}

func (*awsRestjson1_serializeOpUpdateDomainConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateDomainConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateDomainConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/domainConfigurations/{domainConfigurationName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateDomainConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateDomainConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateDomainConfigurationInput(v *UpdateDomainConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DomainConfigurationName == nil || len(*v.DomainConfigurationName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member domainConfigurationName must not be empty")}
	}
	if v.DomainConfigurationName != nil {
		if err := encoder.SetURI("domainConfigurationName").String(*v.DomainConfigurationName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateDomainConfigurationInput(v *UpdateDomainConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AuthorizerConfig != nil {
		ok := object.Key("authorizerConfig")
		if err := awsRestjson1_serializeDocumentAuthorizerConfig(v.AuthorizerConfig, ok); err != nil {
			return err
		}
	}

	if len(v.DomainConfigurationStatus) > 0 {
		ok := object.Key("domainConfigurationStatus")
		ok.String(string(v.DomainConfigurationStatus))
	}

	if v.RemoveAuthorizerConfig {
		ok := object.Key("removeAuthorizerConfig")
		ok.Boolean(v.RemoveAuthorizerConfig)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateDynamicThingGroup struct {
}

func (*awsRestjson1_serializeOpUpdateDynamicThingGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateDynamicThingGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateDynamicThingGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/dynamic-thing-groups/{thingGroupName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateDynamicThingGroupInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateDynamicThingGroupInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateDynamicThingGroupInput(v *UpdateDynamicThingGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ThingGroupName == nil || len(*v.ThingGroupName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member thingGroupName must not be empty")}
	}
	if v.ThingGroupName != nil {
		if err := encoder.SetURI("thingGroupName").String(*v.ThingGroupName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateDynamicThingGroupInput(v *UpdateDynamicThingGroupInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ExpectedVersion != nil {
		ok := object.Key("expectedVersion")
		ok.Long(*v.ExpectedVersion)
	}

	if v.IndexName != nil {
		ok := object.Key("indexName")
		ok.String(*v.IndexName)
	}

	if v.QueryString != nil {
		ok := object.Key("queryString")
		ok.String(*v.QueryString)
	}

	if v.QueryVersion != nil {
		ok := object.Key("queryVersion")
		ok.String(*v.QueryVersion)
	}

	if v.ThingGroupProperties != nil {
		ok := object.Key("thingGroupProperties")
		if err := awsRestjson1_serializeDocumentThingGroupProperties(v.ThingGroupProperties, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateEventConfigurations struct {
}

func (*awsRestjson1_serializeOpUpdateEventConfigurations) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateEventConfigurations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateEventConfigurationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/event-configurations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateEventConfigurationsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateEventConfigurationsInput(v *UpdateEventConfigurationsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateEventConfigurationsInput(v *UpdateEventConfigurationsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EventConfigurations != nil {
		ok := object.Key("eventConfigurations")
		if err := awsRestjson1_serializeDocumentEventConfigurations(v.EventConfigurations, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateFleetMetric struct {
}

func (*awsRestjson1_serializeOpUpdateFleetMetric) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateFleetMetric) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateFleetMetricInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/fleet-metric/{metricName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateFleetMetricInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateFleetMetricInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateFleetMetricInput(v *UpdateFleetMetricInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MetricName == nil || len(*v.MetricName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member metricName must not be empty")}
	}
	if v.MetricName != nil {
		if err := encoder.SetURI("metricName").String(*v.MetricName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateFleetMetricInput(v *UpdateFleetMetricInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AggregationField != nil {
		ok := object.Key("aggregationField")
		ok.String(*v.AggregationField)
	}

	if v.AggregationType != nil {
		ok := object.Key("aggregationType")
		if err := awsRestjson1_serializeDocumentAggregationType(v.AggregationType, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.ExpectedVersion != nil {
		ok := object.Key("expectedVersion")
		ok.Long(*v.ExpectedVersion)
	}

	if v.IndexName != nil {
		ok := object.Key("indexName")
		ok.String(*v.IndexName)
	}

	if v.Period != nil {
		ok := object.Key("period")
		ok.Integer(*v.Period)
	}

	if v.QueryString != nil {
		ok := object.Key("queryString")
		ok.String(*v.QueryString)
	}

	if v.QueryVersion != nil {
		ok := object.Key("queryVersion")
		ok.String(*v.QueryVersion)
	}

	if len(v.Unit) > 0 {
		ok := object.Key("unit")
		ok.String(string(v.Unit))
	}

	return nil
}

type awsRestjson1_serializeOpUpdateIndexingConfiguration struct {
}

func (*awsRestjson1_serializeOpUpdateIndexingConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateIndexingConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateIndexingConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/indexing/config")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateIndexingConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateIndexingConfigurationInput(v *UpdateIndexingConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateIndexingConfigurationInput(v *UpdateIndexingConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ThingGroupIndexingConfiguration != nil {
		ok := object.Key("thingGroupIndexingConfiguration")
		if err := awsRestjson1_serializeDocumentThingGroupIndexingConfiguration(v.ThingGroupIndexingConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ThingIndexingConfiguration != nil {
		ok := object.Key("thingIndexingConfiguration")
		if err := awsRestjson1_serializeDocumentThingIndexingConfiguration(v.ThingIndexingConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateJob struct {
}

func (*awsRestjson1_serializeOpUpdateJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/jobs/{jobId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateJobInput(v *UpdateJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.JobId == nil || len(*v.JobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member jobId must not be empty")}
	}
	if v.JobId != nil {
		if err := encoder.SetURI("jobId").String(*v.JobId); err != nil {
			return err
		}
	}

	if v.NamespaceId != nil {
		encoder.SetQuery("namespaceId").String(*v.NamespaceId)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateJobInput(v *UpdateJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AbortConfig != nil {
		ok := object.Key("abortConfig")
		if err := awsRestjson1_serializeDocumentAbortConfig(v.AbortConfig, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.JobExecutionsRetryConfig != nil {
		ok := object.Key("jobExecutionsRetryConfig")
		if err := awsRestjson1_serializeDocumentJobExecutionsRetryConfig(v.JobExecutionsRetryConfig, ok); err != nil {
			return err
		}
	}

	if v.JobExecutionsRolloutConfig != nil {
		ok := object.Key("jobExecutionsRolloutConfig")
		if err := awsRestjson1_serializeDocumentJobExecutionsRolloutConfig(v.JobExecutionsRolloutConfig, ok); err != nil {
			return err
		}
	}

	if v.PresignedUrlConfig != nil {
		ok := object.Key("presignedUrlConfig")
		if err := awsRestjson1_serializeDocumentPresignedUrlConfig(v.PresignedUrlConfig, ok); err != nil {
			return err
		}
	}

	if v.TimeoutConfig != nil {
		ok := object.Key("timeoutConfig")
		if err := awsRestjson1_serializeDocumentTimeoutConfig(v.TimeoutConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateMitigationAction struct {
}

func (*awsRestjson1_serializeOpUpdateMitigationAction) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateMitigationAction) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateMitigationActionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/mitigationactions/actions/{actionName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateMitigationActionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateMitigationActionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateMitigationActionInput(v *UpdateMitigationActionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ActionName == nil || len(*v.ActionName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member actionName must not be empty")}
	}
	if v.ActionName != nil {
		if err := encoder.SetURI("actionName").String(*v.ActionName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateMitigationActionInput(v *UpdateMitigationActionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ActionParams != nil {
		ok := object.Key("actionParams")
		if err := awsRestjson1_serializeDocumentMitigationActionParams(v.ActionParams, ok); err != nil {
			return err
		}
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateProvisioningTemplate struct {
}

func (*awsRestjson1_serializeOpUpdateProvisioningTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateProvisioningTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateProvisioningTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/provisioning-templates/{templateName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateProvisioningTemplateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateProvisioningTemplateInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateProvisioningTemplateInput(v *UpdateProvisioningTemplateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TemplateName == nil || len(*v.TemplateName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member templateName must not be empty")}
	}
	if v.TemplateName != nil {
		if err := encoder.SetURI("templateName").String(*v.TemplateName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateProvisioningTemplateInput(v *UpdateProvisioningTemplateInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DefaultVersionId != nil {
		ok := object.Key("defaultVersionId")
		ok.Integer(*v.DefaultVersionId)
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.Enabled {
		ok := object.Key("enabled")
		ok.Boolean(v.Enabled)
	}

	if v.PreProvisioningHook != nil {
		ok := object.Key("preProvisioningHook")
		if err := awsRestjson1_serializeDocumentProvisioningHook(v.PreProvisioningHook, ok); err != nil {
			return err
		}
	}

	if v.ProvisioningRoleArn != nil {
		ok := object.Key("provisioningRoleArn")
		ok.String(*v.ProvisioningRoleArn)
	}

	if v.RemovePreProvisioningHook != nil {
		ok := object.Key("removePreProvisioningHook")
		ok.Boolean(*v.RemovePreProvisioningHook)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateRoleAlias struct {
}

func (*awsRestjson1_serializeOpUpdateRoleAlias) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateRoleAlias) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateRoleAliasInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/role-aliases/{roleAlias}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateRoleAliasInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateRoleAliasInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateRoleAliasInput(v *UpdateRoleAliasInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.RoleAlias == nil || len(*v.RoleAlias) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member roleAlias must not be empty")}
	}
	if v.RoleAlias != nil {
		if err := encoder.SetURI("roleAlias").String(*v.RoleAlias); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateRoleAliasInput(v *UpdateRoleAliasInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CredentialDurationSeconds != nil {
		ok := object.Key("credentialDurationSeconds")
		ok.Integer(*v.CredentialDurationSeconds)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateScheduledAudit struct {
}

func (*awsRestjson1_serializeOpUpdateScheduledAudit) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateScheduledAudit) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateScheduledAuditInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/audit/scheduledaudits/{scheduledAuditName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateScheduledAuditInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateScheduledAuditInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateScheduledAuditInput(v *UpdateScheduledAuditInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ScheduledAuditName == nil || len(*v.ScheduledAuditName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member scheduledAuditName must not be empty")}
	}
	if v.ScheduledAuditName != nil {
		if err := encoder.SetURI("scheduledAuditName").String(*v.ScheduledAuditName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateScheduledAuditInput(v *UpdateScheduledAuditInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DayOfMonth != nil {
		ok := object.Key("dayOfMonth")
		ok.String(*v.DayOfMonth)
	}

	if len(v.DayOfWeek) > 0 {
		ok := object.Key("dayOfWeek")
		ok.String(string(v.DayOfWeek))
	}

	if len(v.Frequency) > 0 {
		ok := object.Key("frequency")
		ok.String(string(v.Frequency))
	}

	if v.TargetCheckNames != nil {
		ok := object.Key("targetCheckNames")
		if err := awsRestjson1_serializeDocumentTargetAuditCheckNames(v.TargetCheckNames, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateSecurityProfile struct {
}

func (*awsRestjson1_serializeOpUpdateSecurityProfile) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateSecurityProfile) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateSecurityProfileInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/security-profiles/{securityProfileName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateSecurityProfileInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateSecurityProfileInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateSecurityProfileInput(v *UpdateSecurityProfileInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ExpectedVersion != nil {
		encoder.SetQuery("expectedVersion").Long(*v.ExpectedVersion)
	}

	if v.SecurityProfileName == nil || len(*v.SecurityProfileName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member securityProfileName must not be empty")}
	}
	if v.SecurityProfileName != nil {
		if err := encoder.SetURI("securityProfileName").String(*v.SecurityProfileName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateSecurityProfileInput(v *UpdateSecurityProfileInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdditionalMetricsToRetain != nil {
		ok := object.Key("additionalMetricsToRetain")
		if err := awsRestjson1_serializeDocumentAdditionalMetricsToRetainList(v.AdditionalMetricsToRetain, ok); err != nil {
			return err
		}
	}

	if v.AdditionalMetricsToRetainV2 != nil {
		ok := object.Key("additionalMetricsToRetainV2")
		if err := awsRestjson1_serializeDocumentAdditionalMetricsToRetainV2List(v.AdditionalMetricsToRetainV2, ok); err != nil {
			return err
		}
	}

	if v.AlertTargets != nil {
		ok := object.Key("alertTargets")
		if err := awsRestjson1_serializeDocumentAlertTargets(v.AlertTargets, ok); err != nil {
			return err
		}
	}

	if v.Behaviors != nil {
		ok := object.Key("behaviors")
		if err := awsRestjson1_serializeDocumentBehaviors(v.Behaviors, ok); err != nil {
			return err
		}
	}

	if v.DeleteAdditionalMetricsToRetain {
		ok := object.Key("deleteAdditionalMetricsToRetain")
		ok.Boolean(v.DeleteAdditionalMetricsToRetain)
	}

	if v.DeleteAlertTargets {
		ok := object.Key("deleteAlertTargets")
		ok.Boolean(v.DeleteAlertTargets)
	}

	if v.DeleteBehaviors {
		ok := object.Key("deleteBehaviors")
		ok.Boolean(v.DeleteBehaviors)
	}

	if v.SecurityProfileDescription != nil {
		ok := object.Key("securityProfileDescription")
		ok.String(*v.SecurityProfileDescription)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateStream struct {
}

func (*awsRestjson1_serializeOpUpdateStream) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateStream) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateStreamInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/streams/{streamId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateStreamInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateStreamInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateStreamInput(v *UpdateStreamInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.StreamId == nil || len(*v.StreamId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member streamId must not be empty")}
	}
	if v.StreamId != nil {
		if err := encoder.SetURI("streamId").String(*v.StreamId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateStreamInput(v *UpdateStreamInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.Files != nil {
		ok := object.Key("files")
		if err := awsRestjson1_serializeDocumentStreamFiles(v.Files, ok); err != nil {
			return err
		}
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateThing struct {
}

func (*awsRestjson1_serializeOpUpdateThing) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateThing) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateThingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/things/{thingName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateThingInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateThingInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateThingInput(v *UpdateThingInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ThingName == nil || len(*v.ThingName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member thingName must not be empty")}
	}
	if v.ThingName != nil {
		if err := encoder.SetURI("thingName").String(*v.ThingName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateThingInput(v *UpdateThingInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AttributePayload != nil {
		ok := object.Key("attributePayload")
		if err := awsRestjson1_serializeDocumentAttributePayload(v.AttributePayload, ok); err != nil {
			return err
		}
	}

	if v.ExpectedVersion != nil {
		ok := object.Key("expectedVersion")
		ok.Long(*v.ExpectedVersion)
	}

	if v.RemoveThingType {
		ok := object.Key("removeThingType")
		ok.Boolean(v.RemoveThingType)
	}

	if v.ThingTypeName != nil {
		ok := object.Key("thingTypeName")
		ok.String(*v.ThingTypeName)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateThingGroup struct {
}

func (*awsRestjson1_serializeOpUpdateThingGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateThingGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateThingGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/thing-groups/{thingGroupName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateThingGroupInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateThingGroupInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateThingGroupInput(v *UpdateThingGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ThingGroupName == nil || len(*v.ThingGroupName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member thingGroupName must not be empty")}
	}
	if v.ThingGroupName != nil {
		if err := encoder.SetURI("thingGroupName").String(*v.ThingGroupName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateThingGroupInput(v *UpdateThingGroupInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ExpectedVersion != nil {
		ok := object.Key("expectedVersion")
		ok.Long(*v.ExpectedVersion)
	}

	if v.ThingGroupProperties != nil {
		ok := object.Key("thingGroupProperties")
		if err := awsRestjson1_serializeDocumentThingGroupProperties(v.ThingGroupProperties, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateThingGroupsForThing struct {
}

func (*awsRestjson1_serializeOpUpdateThingGroupsForThing) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateThingGroupsForThing) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateThingGroupsForThingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/thing-groups/updateThingGroupsForThing")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateThingGroupsForThingInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateThingGroupsForThingInput(v *UpdateThingGroupsForThingInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateThingGroupsForThingInput(v *UpdateThingGroupsForThingInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.OverrideDynamicGroups {
		ok := object.Key("overrideDynamicGroups")
		ok.Boolean(v.OverrideDynamicGroups)
	}

	if v.ThingGroupsToAdd != nil {
		ok := object.Key("thingGroupsToAdd")
		if err := awsRestjson1_serializeDocumentThingGroupList(v.ThingGroupsToAdd, ok); err != nil {
			return err
		}
	}

	if v.ThingGroupsToRemove != nil {
		ok := object.Key("thingGroupsToRemove")
		if err := awsRestjson1_serializeDocumentThingGroupList(v.ThingGroupsToRemove, ok); err != nil {
			return err
		}
	}

	if v.ThingName != nil {
		ok := object.Key("thingName")
		ok.String(*v.ThingName)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateTopicRuleDestination struct {
}

func (*awsRestjson1_serializeOpUpdateTopicRuleDestination) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateTopicRuleDestination) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateTopicRuleDestinationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/destinations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateTopicRuleDestinationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateTopicRuleDestinationInput(v *UpdateTopicRuleDestinationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateTopicRuleDestinationInput(v *UpdateTopicRuleDestinationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Arn != nil {
		ok := object.Key("arn")
		ok.String(*v.Arn)
	}

	if len(v.Status) > 0 {
		ok := object.Key("status")
		ok.String(string(v.Status))
	}

	return nil
}

type awsRestjson1_serializeOpValidateSecurityProfileBehaviors struct {
}

func (*awsRestjson1_serializeOpValidateSecurityProfileBehaviors) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpValidateSecurityProfileBehaviors) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ValidateSecurityProfileBehaviorsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/security-profile-behaviors/validate")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentValidateSecurityProfileBehaviorsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsValidateSecurityProfileBehaviorsInput(v *ValidateSecurityProfileBehaviorsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentValidateSecurityProfileBehaviorsInput(v *ValidateSecurityProfileBehaviorsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Behaviors != nil {
		ok := object.Key("behaviors")
		if err := awsRestjson1_serializeDocumentBehaviors(v.Behaviors, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAbortConfig(v *types.AbortConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CriteriaList != nil {
		ok := object.Key("criteriaList")
		if err := awsRestjson1_serializeDocumentAbortCriteriaList(v.CriteriaList, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAbortCriteria(v *types.AbortCriteria, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Action) > 0 {
		ok := object.Key("action")
		ok.String(string(v.Action))
	}

	if len(v.FailureType) > 0 {
		ok := object.Key("failureType")
		ok.String(string(v.FailureType))
	}

	if v.MinNumberOfExecutedThings != nil {
		ok := object.Key("minNumberOfExecutedThings")
		ok.Integer(*v.MinNumberOfExecutedThings)
	}

	if v.ThresholdPercentage != nil {
		ok := object.Key("thresholdPercentage")
		switch {
		case math.IsNaN(*v.ThresholdPercentage):
			ok.String("NaN")

		case math.IsInf(*v.ThresholdPercentage, 1):
			ok.String("Infinity")

		case math.IsInf(*v.ThresholdPercentage, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.ThresholdPercentage)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAbortCriteriaList(v []types.AbortCriteria, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAbortCriteria(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAction(v *types.Action, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CloudwatchAlarm != nil {
		ok := object.Key("cloudwatchAlarm")
		if err := awsRestjson1_serializeDocumentCloudwatchAlarmAction(v.CloudwatchAlarm, ok); err != nil {
			return err
		}
	}

	if v.CloudwatchLogs != nil {
		ok := object.Key("cloudwatchLogs")
		if err := awsRestjson1_serializeDocumentCloudwatchLogsAction(v.CloudwatchLogs, ok); err != nil {
			return err
		}
	}

	if v.CloudwatchMetric != nil {
		ok := object.Key("cloudwatchMetric")
		if err := awsRestjson1_serializeDocumentCloudwatchMetricAction(v.CloudwatchMetric, ok); err != nil {
			return err
		}
	}

	if v.DynamoDB != nil {
		ok := object.Key("dynamoDB")
		if err := awsRestjson1_serializeDocumentDynamoDBAction(v.DynamoDB, ok); err != nil {
			return err
		}
	}

	if v.DynamoDBv2 != nil {
		ok := object.Key("dynamoDBv2")
		if err := awsRestjson1_serializeDocumentDynamoDBv2Action(v.DynamoDBv2, ok); err != nil {
			return err
		}
	}

	if v.Elasticsearch != nil {
		ok := object.Key("elasticsearch")
		if err := awsRestjson1_serializeDocumentElasticsearchAction(v.Elasticsearch, ok); err != nil {
			return err
		}
	}

	if v.Firehose != nil {
		ok := object.Key("firehose")
		if err := awsRestjson1_serializeDocumentFirehoseAction(v.Firehose, ok); err != nil {
			return err
		}
	}

	if v.Http != nil {
		ok := object.Key("http")
		if err := awsRestjson1_serializeDocumentHttpAction(v.Http, ok); err != nil {
			return err
		}
	}

	if v.IotAnalytics != nil {
		ok := object.Key("iotAnalytics")
		if err := awsRestjson1_serializeDocumentIotAnalyticsAction(v.IotAnalytics, ok); err != nil {
			return err
		}
	}

	if v.IotEvents != nil {
		ok := object.Key("iotEvents")
		if err := awsRestjson1_serializeDocumentIotEventsAction(v.IotEvents, ok); err != nil {
			return err
		}
	}

	if v.IotSiteWise != nil {
		ok := object.Key("iotSiteWise")
		if err := awsRestjson1_serializeDocumentIotSiteWiseAction(v.IotSiteWise, ok); err != nil {
			return err
		}
	}

	if v.Kafka != nil {
		ok := object.Key("kafka")
		if err := awsRestjson1_serializeDocumentKafkaAction(v.Kafka, ok); err != nil {
			return err
		}
	}

	if v.Kinesis != nil {
		ok := object.Key("kinesis")
		if err := awsRestjson1_serializeDocumentKinesisAction(v.Kinesis, ok); err != nil {
			return err
		}
	}

	if v.Lambda != nil {
		ok := object.Key("lambda")
		if err := awsRestjson1_serializeDocumentLambdaAction(v.Lambda, ok); err != nil {
			return err
		}
	}

	if v.OpenSearch != nil {
		ok := object.Key("openSearch")
		if err := awsRestjson1_serializeDocumentOpenSearchAction(v.OpenSearch, ok); err != nil {
			return err
		}
	}

	if v.Republish != nil {
		ok := object.Key("republish")
		if err := awsRestjson1_serializeDocumentRepublishAction(v.Republish, ok); err != nil {
			return err
		}
	}

	if v.S3 != nil {
		ok := object.Key("s3")
		if err := awsRestjson1_serializeDocumentS3Action(v.S3, ok); err != nil {
			return err
		}
	}

	if v.Salesforce != nil {
		ok := object.Key("salesforce")
		if err := awsRestjson1_serializeDocumentSalesforceAction(v.Salesforce, ok); err != nil {
			return err
		}
	}

	if v.Sns != nil {
		ok := object.Key("sns")
		if err := awsRestjson1_serializeDocumentSnsAction(v.Sns, ok); err != nil {
			return err
		}
	}

	if v.Sqs != nil {
		ok := object.Key("sqs")
		if err := awsRestjson1_serializeDocumentSqsAction(v.Sqs, ok); err != nil {
			return err
		}
	}

	if v.StepFunctions != nil {
		ok := object.Key("stepFunctions")
		if err := awsRestjson1_serializeDocumentStepFunctionsAction(v.StepFunctions, ok); err != nil {
			return err
		}
	}

	if v.Timestream != nil {
		ok := object.Key("timestream")
		if err := awsRestjson1_serializeDocumentTimestreamAction(v.Timestream, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentActionList(v []types.Action, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAction(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAdditionalMetricsToRetainList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentAdditionalMetricsToRetainV2List(v []types.MetricToRetain, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentMetricToRetain(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAdditionalParameterMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentAddThingsToThingGroupParams(v *types.AddThingsToThingGroupParams, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.OverrideDynamicGroups != nil {
		ok := object.Key("overrideDynamicGroups")
		ok.Boolean(*v.OverrideDynamicGroups)
	}

	if v.ThingGroupNames != nil {
		ok := object.Key("thingGroupNames")
		if err := awsRestjson1_serializeDocumentThingGroupNames(v.ThingGroupNames, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAggregationType(v *types.AggregationType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Name) > 0 {
		ok := object.Key("name")
		ok.String(string(v.Name))
	}

	if v.Values != nil {
		ok := object.Key("values")
		if err := awsRestjson1_serializeDocumentAggregationTypeValues(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAggregationTypeValues(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentAlertTarget(v *types.AlertTarget, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AlertTargetArn != nil {
		ok := object.Key("alertTargetArn")
		ok.String(*v.AlertTargetArn)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentAlertTargets(v map[string]types.AlertTarget, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentAlertTarget(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAssetPropertyTimestamp(v *types.AssetPropertyTimestamp, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.OffsetInNanos != nil {
		ok := object.Key("offsetInNanos")
		ok.String(*v.OffsetInNanos)
	}

	if v.TimeInSeconds != nil {
		ok := object.Key("timeInSeconds")
		ok.String(*v.TimeInSeconds)
	}

	return nil
}

func awsRestjson1_serializeDocumentAssetPropertyValue(v *types.AssetPropertyValue, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Quality != nil {
		ok := object.Key("quality")
		ok.String(*v.Quality)
	}

	if v.Timestamp != nil {
		ok := object.Key("timestamp")
		if err := awsRestjson1_serializeDocumentAssetPropertyTimestamp(v.Timestamp, ok); err != nil {
			return err
		}
	}

	if v.Value != nil {
		ok := object.Key("value")
		if err := awsRestjson1_serializeDocumentAssetPropertyVariant(v.Value, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAssetPropertyValueList(v []types.AssetPropertyValue, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAssetPropertyValue(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAssetPropertyVariant(v types.AssetPropertyVariant, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.AssetPropertyVariantMemberBooleanValue:
		av := object.Key("booleanValue")
		av.String(uv.Value)

	case *types.AssetPropertyVariantMemberDoubleValue:
		av := object.Key("doubleValue")
		av.String(uv.Value)

	case *types.AssetPropertyVariantMemberIntegerValue:
		av := object.Key("integerValue")
		av.String(uv.Value)

	case *types.AssetPropertyVariantMemberStringValue:
		av := object.Key("stringValue")
		av.String(uv.Value)

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentAttributePayload(v *types.AttributePayload, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Attributes != nil {
		ok := object.Key("attributes")
		if err := awsRestjson1_serializeDocumentAttributes(v.Attributes, ok); err != nil {
			return err
		}
	}

	if v.Merge {
		ok := object.Key("merge")
		ok.Boolean(v.Merge)
	}

	return nil
}

func awsRestjson1_serializeDocumentAttributes(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentAttributesMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentAuditCheckConfiguration(v *types.AuditCheckConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Enabled {
		ok := object.Key("enabled")
		ok.Boolean(v.Enabled)
	}

	return nil
}

func awsRestjson1_serializeDocumentAuditCheckConfigurations(v map[string]types.AuditCheckConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentAuditCheckConfiguration(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAuditCheckToActionsMapping(v map[string][]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		if vv := v[key]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentMitigationActionNameList(v[key], om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAuditCheckToReasonCodeFilter(v map[string][]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		if vv := v[key]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentReasonForNonComplianceCodes(v[key], om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAuditMitigationActionsTaskTarget(v *types.AuditMitigationActionsTaskTarget, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AuditCheckToReasonCodeFilter != nil {
		ok := object.Key("auditCheckToReasonCodeFilter")
		if err := awsRestjson1_serializeDocumentAuditCheckToReasonCodeFilter(v.AuditCheckToReasonCodeFilter, ok); err != nil {
			return err
		}
	}

	if v.AuditTaskId != nil {
		ok := object.Key("auditTaskId")
		ok.String(*v.AuditTaskId)
	}

	if v.FindingIds != nil {
		ok := object.Key("findingIds")
		if err := awsRestjson1_serializeDocumentFindingIds(v.FindingIds, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAuditNotificationTarget(v *types.AuditNotificationTarget, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Enabled {
		ok := object.Key("enabled")
		ok.Boolean(v.Enabled)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.TargetArn != nil {
		ok := object.Key("targetArn")
		ok.String(*v.TargetArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentAuditNotificationTargetConfigurations(v map[string]types.AuditNotificationTarget, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentAuditNotificationTarget(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAuthInfo(v *types.AuthInfo, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ActionType) > 0 {
		ok := object.Key("actionType")
		ok.String(string(v.ActionType))
	}

	if v.Resources != nil {
		ok := object.Key("resources")
		if err := awsRestjson1_serializeDocumentResources(v.Resources, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAuthInfos(v []types.AuthInfo, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAuthInfo(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAuthorizerConfig(v *types.AuthorizerConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AllowAuthorizerOverride {
		ok := object.Key("allowAuthorizerOverride")
		ok.Boolean(v.AllowAuthorizerOverride)
	}

	if v.DefaultAuthorizerName != nil {
		ok := object.Key("defaultAuthorizerName")
		ok.String(*v.DefaultAuthorizerName)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsJobAbortConfig(v *types.AwsJobAbortConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AbortCriteriaList != nil {
		ok := object.Key("abortCriteriaList")
		if err := awsRestjson1_serializeDocumentAwsJobAbortCriteriaList(v.AbortCriteriaList, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsJobAbortCriteria(v *types.AwsJobAbortCriteria, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Action) > 0 {
		ok := object.Key("action")
		ok.String(string(v.Action))
	}

	if len(v.FailureType) > 0 {
		ok := object.Key("failureType")
		ok.String(string(v.FailureType))
	}

	if v.MinNumberOfExecutedThings != nil {
		ok := object.Key("minNumberOfExecutedThings")
		ok.Integer(*v.MinNumberOfExecutedThings)
	}

	if v.ThresholdPercentage != nil {
		ok := object.Key("thresholdPercentage")
		switch {
		case math.IsNaN(*v.ThresholdPercentage):
			ok.String("NaN")

		case math.IsInf(*v.ThresholdPercentage, 1):
			ok.String("Infinity")

		case math.IsInf(*v.ThresholdPercentage, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.ThresholdPercentage)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsJobAbortCriteriaList(v []types.AwsJobAbortCriteria, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsJobAbortCriteria(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsJobExecutionsRolloutConfig(v *types.AwsJobExecutionsRolloutConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ExponentialRate != nil {
		ok := object.Key("exponentialRate")
		if err := awsRestjson1_serializeDocumentAwsJobExponentialRolloutRate(v.ExponentialRate, ok); err != nil {
			return err
		}
	}

	if v.MaximumPerMinute != nil {
		ok := object.Key("maximumPerMinute")
		ok.Integer(*v.MaximumPerMinute)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsJobExponentialRolloutRate(v *types.AwsJobExponentialRolloutRate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BaseRatePerMinute != nil {
		ok := object.Key("baseRatePerMinute")
		ok.Integer(*v.BaseRatePerMinute)
	}

	{
		ok := object.Key("incrementFactor")
		switch {
		case math.IsNaN(v.IncrementFactor):
			ok.String("NaN")

		case math.IsInf(v.IncrementFactor, 1):
			ok.String("Infinity")

		case math.IsInf(v.IncrementFactor, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.IncrementFactor)

		}
	}

	if v.RateIncreaseCriteria != nil {
		ok := object.Key("rateIncreaseCriteria")
		if err := awsRestjson1_serializeDocumentAwsJobRateIncreaseCriteria(v.RateIncreaseCriteria, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsJobPresignedUrlConfig(v *types.AwsJobPresignedUrlConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ExpiresInSec != nil {
		ok := object.Key("expiresInSec")
		ok.Long(*v.ExpiresInSec)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsJobRateIncreaseCriteria(v *types.AwsJobRateIncreaseCriteria, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.NumberOfNotifiedThings != nil {
		ok := object.Key("numberOfNotifiedThings")
		ok.Integer(*v.NumberOfNotifiedThings)
	}

	if v.NumberOfSucceededThings != nil {
		ok := object.Key("numberOfSucceededThings")
		ok.Integer(*v.NumberOfSucceededThings)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsJobTimeoutConfig(v *types.AwsJobTimeoutConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InProgressTimeoutInMinutes != nil {
		ok := object.Key("inProgressTimeoutInMinutes")
		ok.Long(*v.InProgressTimeoutInMinutes)
	}

	return nil
}

func awsRestjson1_serializeDocumentBehavior(v *types.Behavior, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Criteria != nil {
		ok := object.Key("criteria")
		if err := awsRestjson1_serializeDocumentBehaviorCriteria(v.Criteria, ok); err != nil {
			return err
		}
	}

	if v.Metric != nil {
		ok := object.Key("metric")
		ok.String(*v.Metric)
	}

	if v.MetricDimension != nil {
		ok := object.Key("metricDimension")
		if err := awsRestjson1_serializeDocumentMetricDimension(v.MetricDimension, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.SuppressAlerts != nil {
		ok := object.Key("suppressAlerts")
		ok.Boolean(*v.SuppressAlerts)
	}

	return nil
}

func awsRestjson1_serializeDocumentBehaviorCriteria(v *types.BehaviorCriteria, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ComparisonOperator) > 0 {
		ok := object.Key("comparisonOperator")
		ok.String(string(v.ComparisonOperator))
	}

	if v.ConsecutiveDatapointsToAlarm != nil {
		ok := object.Key("consecutiveDatapointsToAlarm")
		ok.Integer(*v.ConsecutiveDatapointsToAlarm)
	}

	if v.ConsecutiveDatapointsToClear != nil {
		ok := object.Key("consecutiveDatapointsToClear")
		ok.Integer(*v.ConsecutiveDatapointsToClear)
	}

	if v.DurationSeconds != nil {
		ok := object.Key("durationSeconds")
		ok.Integer(*v.DurationSeconds)
	}

	if v.MlDetectionConfig != nil {
		ok := object.Key("mlDetectionConfig")
		if err := awsRestjson1_serializeDocumentMachineLearningDetectionConfig(v.MlDetectionConfig, ok); err != nil {
			return err
		}
	}

	if v.StatisticalThreshold != nil {
		ok := object.Key("statisticalThreshold")
		if err := awsRestjson1_serializeDocumentStatisticalThreshold(v.StatisticalThreshold, ok); err != nil {
			return err
		}
	}

	if v.Value != nil {
		ok := object.Key("value")
		if err := awsRestjson1_serializeDocumentMetricValue(v.Value, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBehaviors(v []types.Behavior, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentBehavior(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentBillingGroupProperties(v *types.BillingGroupProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BillingGroupDescription != nil {
		ok := object.Key("billingGroupDescription")
		ok.String(*v.BillingGroupDescription)
	}

	return nil
}

func awsRestjson1_serializeDocumentBucketsAggregationType(v *types.BucketsAggregationType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TermsAggregation != nil {
		ok := object.Key("termsAggregation")
		if err := awsRestjson1_serializeDocumentTermsAggregation(v.TermsAggregation, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCidrs(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentClientProperties(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentCloudwatchAlarmAction(v *types.CloudwatchAlarmAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AlarmName != nil {
		ok := object.Key("alarmName")
		ok.String(*v.AlarmName)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.StateReason != nil {
		ok := object.Key("stateReason")
		ok.String(*v.StateReason)
	}

	if v.StateValue != nil {
		ok := object.Key("stateValue")
		ok.String(*v.StateValue)
	}

	return nil
}

func awsRestjson1_serializeDocumentCloudwatchLogsAction(v *types.CloudwatchLogsAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LogGroupName != nil {
		ok := object.Key("logGroupName")
		ok.String(*v.LogGroupName)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentCloudwatchMetricAction(v *types.CloudwatchMetricAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MetricName != nil {
		ok := object.Key("metricName")
		ok.String(*v.MetricName)
	}

	if v.MetricNamespace != nil {
		ok := object.Key("metricNamespace")
		ok.String(*v.MetricNamespace)
	}

	if v.MetricTimestamp != nil {
		ok := object.Key("metricTimestamp")
		ok.String(*v.MetricTimestamp)
	}

	if v.MetricUnit != nil {
		ok := object.Key("metricUnit")
		ok.String(*v.MetricUnit)
	}

	if v.MetricValue != nil {
		ok := object.Key("metricValue")
		ok.String(*v.MetricValue)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentCodeSigning(v *types.CodeSigning, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AwsSignerJobId != nil {
		ok := object.Key("awsSignerJobId")
		ok.String(*v.AwsSignerJobId)
	}

	if v.CustomCodeSigning != nil {
		ok := object.Key("customCodeSigning")
		if err := awsRestjson1_serializeDocumentCustomCodeSigning(v.CustomCodeSigning, ok); err != nil {
			return err
		}
	}

	if v.StartSigningJobParameter != nil {
		ok := object.Key("startSigningJobParameter")
		if err := awsRestjson1_serializeDocumentStartSigningJobParameter(v.StartSigningJobParameter, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCodeSigningCertificateChain(v *types.CodeSigningCertificateChain, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CertificateName != nil {
		ok := object.Key("certificateName")
		ok.String(*v.CertificateName)
	}

	if v.InlineDocument != nil {
		ok := object.Key("inlineDocument")
		ok.String(*v.InlineDocument)
	}

	return nil
}

func awsRestjson1_serializeDocumentCodeSigningSignature(v *types.CodeSigningSignature, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InlineDocument != nil {
		ok := object.Key("inlineDocument")
		ok.Base64EncodeBytes(v.InlineDocument)
	}

	return nil
}

func awsRestjson1_serializeDocumentConfiguration(v *types.Configuration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Enabled {
		ok := object.Key("Enabled")
		ok.Boolean(v.Enabled)
	}

	return nil
}

func awsRestjson1_serializeDocumentCustomCodeSigning(v *types.CustomCodeSigning, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CertificateChain != nil {
		ok := object.Key("certificateChain")
		if err := awsRestjson1_serializeDocumentCodeSigningCertificateChain(v.CertificateChain, ok); err != nil {
			return err
		}
	}

	if v.HashAlgorithm != nil {
		ok := object.Key("hashAlgorithm")
		ok.String(*v.HashAlgorithm)
	}

	if v.Signature != nil {
		ok := object.Key("signature")
		if err := awsRestjson1_serializeDocumentCodeSigningSignature(v.Signature, ok); err != nil {
			return err
		}
	}

	if v.SignatureAlgorithm != nil {
		ok := object.Key("signatureAlgorithm")
		ok.String(*v.SignatureAlgorithm)
	}

	return nil
}

func awsRestjson1_serializeDocumentDestination(v *types.Destination, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.S3Destination != nil {
		ok := object.Key("s3Destination")
		if err := awsRestjson1_serializeDocumentS3Destination(v.S3Destination, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDetailsMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentDetectMitigationActionsTaskTarget(v *types.DetectMitigationActionsTaskTarget, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BehaviorName != nil {
		ok := object.Key("behaviorName")
		ok.String(*v.BehaviorName)
	}

	if v.SecurityProfileName != nil {
		ok := object.Key("securityProfileName")
		ok.String(*v.SecurityProfileName)
	}

	if v.ViolationIds != nil {
		ok := object.Key("violationIds")
		if err := awsRestjson1_serializeDocumentTargetViolationIdsForDetectMitigationActions(v.ViolationIds, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDetectMitigationActionsToExecuteList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentDimensionStringValues(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentDynamoDBAction(v *types.DynamoDBAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.HashKeyField != nil {
		ok := object.Key("hashKeyField")
		ok.String(*v.HashKeyField)
	}

	if len(v.HashKeyType) > 0 {
		ok := object.Key("hashKeyType")
		ok.String(string(v.HashKeyType))
	}

	if v.HashKeyValue != nil {
		ok := object.Key("hashKeyValue")
		ok.String(*v.HashKeyValue)
	}

	if v.Operation != nil {
		ok := object.Key("operation")
		ok.String(*v.Operation)
	}

	if v.PayloadField != nil {
		ok := object.Key("payloadField")
		ok.String(*v.PayloadField)
	}

	if v.RangeKeyField != nil {
		ok := object.Key("rangeKeyField")
		ok.String(*v.RangeKeyField)
	}

	if len(v.RangeKeyType) > 0 {
		ok := object.Key("rangeKeyType")
		ok.String(string(v.RangeKeyType))
	}

	if v.RangeKeyValue != nil {
		ok := object.Key("rangeKeyValue")
		ok.String(*v.RangeKeyValue)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.TableName != nil {
		ok := object.Key("tableName")
		ok.String(*v.TableName)
	}

	return nil
}

func awsRestjson1_serializeDocumentDynamoDBv2Action(v *types.DynamoDBv2Action, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PutItem != nil {
		ok := object.Key("putItem")
		if err := awsRestjson1_serializeDocumentPutItemInput(v.PutItem, ok); err != nil {
			return err
		}
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentElasticsearchAction(v *types.ElasticsearchAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Endpoint != nil {
		ok := object.Key("endpoint")
		ok.String(*v.Endpoint)
	}

	if v.Id != nil {
		ok := object.Key("id")
		ok.String(*v.Id)
	}

	if v.Index != nil {
		ok := object.Key("index")
		ok.String(*v.Index)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.Type != nil {
		ok := object.Key("type")
		ok.String(*v.Type)
	}

	return nil
}

func awsRestjson1_serializeDocumentEnableIoTLoggingParams(v *types.EnableIoTLoggingParams, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.LogLevel) > 0 {
		ok := object.Key("logLevel")
		ok.String(string(v.LogLevel))
	}

	if v.RoleArnForLogging != nil {
		ok := object.Key("roleArnForLogging")
		ok.String(*v.RoleArnForLogging)
	}

	return nil
}

func awsRestjson1_serializeDocumentEventConfigurations(v map[string]types.Configuration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentConfiguration(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentExponentialRolloutRate(v *types.ExponentialRolloutRate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BaseRatePerMinute != nil {
		ok := object.Key("baseRatePerMinute")
		ok.Integer(*v.BaseRatePerMinute)
	}

	{
		ok := object.Key("incrementFactor")
		switch {
		case math.IsNaN(v.IncrementFactor):
			ok.String("NaN")

		case math.IsInf(v.IncrementFactor, 1):
			ok.String("Infinity")

		case math.IsInf(v.IncrementFactor, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.IncrementFactor)

		}
	}

	if v.RateIncreaseCriteria != nil {
		ok := object.Key("rateIncreaseCriteria")
		if err := awsRestjson1_serializeDocumentRateIncreaseCriteria(v.RateIncreaseCriteria, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentField(v *types.Field, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentFields(v []types.Field, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentField(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentFileLocation(v *types.FileLocation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.S3Location != nil {
		ok := object.Key("s3Location")
		if err := awsRestjson1_serializeDocumentS3Location(v.S3Location, ok); err != nil {
			return err
		}
	}

	if v.Stream != nil {
		ok := object.Key("stream")
		if err := awsRestjson1_serializeDocumentStream(v.Stream, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentFindingIds(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentFirehoseAction(v *types.FirehoseAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BatchMode != nil {
		ok := object.Key("batchMode")
		ok.Boolean(*v.BatchMode)
	}

	if v.DeliveryStreamName != nil {
		ok := object.Key("deliveryStreamName")
		ok.String(*v.DeliveryStreamName)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.Separator != nil {
		ok := object.Key("separator")
		ok.String(*v.Separator)
	}

	return nil
}

func awsRestjson1_serializeDocumentHeaderList(v []types.HttpActionHeader, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentHttpActionHeader(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentHttpAction(v *types.HttpAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Auth != nil {
		ok := object.Key("auth")
		if err := awsRestjson1_serializeDocumentHttpAuthorization(v.Auth, ok); err != nil {
			return err
		}
	}

	if v.ConfirmationUrl != nil {
		ok := object.Key("confirmationUrl")
		ok.String(*v.ConfirmationUrl)
	}

	if v.Headers != nil {
		ok := object.Key("headers")
		if err := awsRestjson1_serializeDocumentHeaderList(v.Headers, ok); err != nil {
			return err
		}
	}

	if v.Url != nil {
		ok := object.Key("url")
		ok.String(*v.Url)
	}

	return nil
}

func awsRestjson1_serializeDocumentHttpActionHeader(v *types.HttpActionHeader, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Key != nil {
		ok := object.Key("key")
		ok.String(*v.Key)
	}

	if v.Value != nil {
		ok := object.Key("value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentHttpAuthorization(v *types.HttpAuthorization, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Sigv4 != nil {
		ok := object.Key("sigv4")
		if err := awsRestjson1_serializeDocumentSigV4Authorization(v.Sigv4, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentHttpContext(v *types.HttpContext, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Headers != nil {
		ok := object.Key("headers")
		if err := awsRestjson1_serializeDocumentHttpHeaders(v.Headers, ok); err != nil {
			return err
		}
	}

	if v.QueryString != nil {
		ok := object.Key("queryString")
		ok.String(*v.QueryString)
	}

	return nil
}

func awsRestjson1_serializeDocumentHttpHeaders(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentHttpUrlDestinationConfiguration(v *types.HttpUrlDestinationConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConfirmationUrl != nil {
		ok := object.Key("confirmationUrl")
		ok.String(*v.ConfirmationUrl)
	}

	return nil
}

func awsRestjson1_serializeDocumentIndexingFilter(v *types.IndexingFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.NamedShadowNames != nil {
		ok := object.Key("namedShadowNames")
		if err := awsRestjson1_serializeDocumentNamedShadowNamesFilter(v.NamedShadowNames, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentIotAnalyticsAction(v *types.IotAnalyticsAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BatchMode != nil {
		ok := object.Key("batchMode")
		ok.Boolean(*v.BatchMode)
	}

	if v.ChannelArn != nil {
		ok := object.Key("channelArn")
		ok.String(*v.ChannelArn)
	}

	if v.ChannelName != nil {
		ok := object.Key("channelName")
		ok.String(*v.ChannelName)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentIotEventsAction(v *types.IotEventsAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BatchMode != nil {
		ok := object.Key("batchMode")
		ok.Boolean(*v.BatchMode)
	}

	if v.InputName != nil {
		ok := object.Key("inputName")
		ok.String(*v.InputName)
	}

	if v.MessageId != nil {
		ok := object.Key("messageId")
		ok.String(*v.MessageId)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentIotSiteWiseAction(v *types.IotSiteWiseAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PutAssetPropertyValueEntries != nil {
		ok := object.Key("putAssetPropertyValueEntries")
		if err := awsRestjson1_serializeDocumentPutAssetPropertyValueEntryList(v.PutAssetPropertyValueEntries, ok); err != nil {
			return err
		}
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentJobExecutionsRetryConfig(v *types.JobExecutionsRetryConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CriteriaList != nil {
		ok := object.Key("criteriaList")
		if err := awsRestjson1_serializeDocumentRetryCriteriaList(v.CriteriaList, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentJobExecutionsRolloutConfig(v *types.JobExecutionsRolloutConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ExponentialRate != nil {
		ok := object.Key("exponentialRate")
		if err := awsRestjson1_serializeDocumentExponentialRolloutRate(v.ExponentialRate, ok); err != nil {
			return err
		}
	}

	if v.MaximumPerMinute != nil {
		ok := object.Key("maximumPerMinute")
		ok.Integer(*v.MaximumPerMinute)
	}

	return nil
}

func awsRestjson1_serializeDocumentJobTargets(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentKafkaAction(v *types.KafkaAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientProperties != nil {
		ok := object.Key("clientProperties")
		if err := awsRestjson1_serializeDocumentClientProperties(v.ClientProperties, ok); err != nil {
			return err
		}
	}

	if v.DestinationArn != nil {
		ok := object.Key("destinationArn")
		ok.String(*v.DestinationArn)
	}

	if v.Key != nil {
		ok := object.Key("key")
		ok.String(*v.Key)
	}

	if v.Partition != nil {
		ok := object.Key("partition")
		ok.String(*v.Partition)
	}

	if v.Topic != nil {
		ok := object.Key("topic")
		ok.String(*v.Topic)
	}

	return nil
}

func awsRestjson1_serializeDocumentKinesisAction(v *types.KinesisAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PartitionKey != nil {
		ok := object.Key("partitionKey")
		ok.String(*v.PartitionKey)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.StreamName != nil {
		ok := object.Key("streamName")
		ok.String(*v.StreamName)
	}

	return nil
}

func awsRestjson1_serializeDocumentLambdaAction(v *types.LambdaAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FunctionArn != nil {
		ok := object.Key("functionArn")
		ok.String(*v.FunctionArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentLoggingOptionsPayload(v *types.LoggingOptionsPayload, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.LogLevel) > 0 {
		ok := object.Key("logLevel")
		ok.String(string(v.LogLevel))
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentLogTarget(v *types.LogTarget, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TargetName != nil {
		ok := object.Key("targetName")
		ok.String(*v.TargetName)
	}

	if len(v.TargetType) > 0 {
		ok := object.Key("targetType")
		ok.String(string(v.TargetType))
	}

	return nil
}

func awsRestjson1_serializeDocumentMachineLearningDetectionConfig(v *types.MachineLearningDetectionConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ConfidenceLevel) > 0 {
		ok := object.Key("confidenceLevel")
		ok.String(string(v.ConfidenceLevel))
	}

	return nil
}

func awsRestjson1_serializeDocumentMetricDimension(v *types.MetricDimension, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DimensionName != nil {
		ok := object.Key("dimensionName")
		ok.String(*v.DimensionName)
	}

	if len(v.Operator) > 0 {
		ok := object.Key("operator")
		ok.String(string(v.Operator))
	}

	return nil
}

func awsRestjson1_serializeDocumentMetricToRetain(v *types.MetricToRetain, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Metric != nil {
		ok := object.Key("metric")
		ok.String(*v.Metric)
	}

	if v.MetricDimension != nil {
		ok := object.Key("metricDimension")
		if err := awsRestjson1_serializeDocumentMetricDimension(v.MetricDimension, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentMetricValue(v *types.MetricValue, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Cidrs != nil {
		ok := object.Key("cidrs")
		if err := awsRestjson1_serializeDocumentCidrs(v.Cidrs, ok); err != nil {
			return err
		}
	}

	if v.Count != nil {
		ok := object.Key("count")
		ok.Long(*v.Count)
	}

	if v.Number != nil {
		ok := object.Key("number")
		switch {
		case math.IsNaN(*v.Number):
			ok.String("NaN")

		case math.IsInf(*v.Number, 1):
			ok.String("Infinity")

		case math.IsInf(*v.Number, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.Number)

		}
	}

	if v.Numbers != nil {
		ok := object.Key("numbers")
		if err := awsRestjson1_serializeDocumentNumberList(v.Numbers, ok); err != nil {
			return err
		}
	}

	if v.Ports != nil {
		ok := object.Key("ports")
		if err := awsRestjson1_serializeDocumentPorts(v.Ports, ok); err != nil {
			return err
		}
	}

	if v.Strings != nil {
		ok := object.Key("strings")
		if err := awsRestjson1_serializeDocumentStringList(v.Strings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentMitigationActionNameList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentMitigationActionParams(v *types.MitigationActionParams, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AddThingsToThingGroupParams != nil {
		ok := object.Key("addThingsToThingGroupParams")
		if err := awsRestjson1_serializeDocumentAddThingsToThingGroupParams(v.AddThingsToThingGroupParams, ok); err != nil {
			return err
		}
	}

	if v.EnableIoTLoggingParams != nil {
		ok := object.Key("enableIoTLoggingParams")
		if err := awsRestjson1_serializeDocumentEnableIoTLoggingParams(v.EnableIoTLoggingParams, ok); err != nil {
			return err
		}
	}

	if v.PublishFindingToSnsParams != nil {
		ok := object.Key("publishFindingToSnsParams")
		if err := awsRestjson1_serializeDocumentPublishFindingToSnsParams(v.PublishFindingToSnsParams, ok); err != nil {
			return err
		}
	}

	if v.ReplaceDefaultPolicyVersionParams != nil {
		ok := object.Key("replaceDefaultPolicyVersionParams")
		if err := awsRestjson1_serializeDocumentReplaceDefaultPolicyVersionParams(v.ReplaceDefaultPolicyVersionParams, ok); err != nil {
			return err
		}
	}

	if v.UpdateCACertificateParams != nil {
		ok := object.Key("updateCACertificateParams")
		if err := awsRestjson1_serializeDocumentUpdateCACertificateParams(v.UpdateCACertificateParams, ok); err != nil {
			return err
		}
	}

	if v.UpdateDeviceCertificateParams != nil {
		ok := object.Key("updateDeviceCertificateParams")
		if err := awsRestjson1_serializeDocumentUpdateDeviceCertificateParams(v.UpdateDeviceCertificateParams, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentMqttContext(v *types.MqttContext, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientId != nil {
		ok := object.Key("clientId")
		ok.String(*v.ClientId)
	}

	if v.Password != nil {
		ok := object.Key("password")
		ok.Base64EncodeBytes(v.Password)
	}

	if v.Username != nil {
		ok := object.Key("username")
		ok.String(*v.Username)
	}

	return nil
}

func awsRestjson1_serializeDocumentNamedShadowNamesFilter(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentNumberList(v []float64, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		switch {
		case math.IsNaN(v[i]):
			av.String("NaN")

		case math.IsInf(v[i], 1):
			av.String("Infinity")

		case math.IsInf(v[i], -1):
			av.String("-Infinity")

		default:
			av.Double(v[i])

		}
	}
	return nil
}

func awsRestjson1_serializeDocumentOpenSearchAction(v *types.OpenSearchAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Endpoint != nil {
		ok := object.Key("endpoint")
		ok.String(*v.Endpoint)
	}

	if v.Id != nil {
		ok := object.Key("id")
		ok.String(*v.Id)
	}

	if v.Index != nil {
		ok := object.Key("index")
		ok.String(*v.Index)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.Type != nil {
		ok := object.Key("type")
		ok.String(*v.Type)
	}

	return nil
}

func awsRestjson1_serializeDocumentOTAUpdateFile(v *types.OTAUpdateFile, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Attributes != nil {
		ok := object.Key("attributes")
		if err := awsRestjson1_serializeDocumentAttributesMap(v.Attributes, ok); err != nil {
			return err
		}
	}

	if v.CodeSigning != nil {
		ok := object.Key("codeSigning")
		if err := awsRestjson1_serializeDocumentCodeSigning(v.CodeSigning, ok); err != nil {
			return err
		}
	}

	if v.FileLocation != nil {
		ok := object.Key("fileLocation")
		if err := awsRestjson1_serializeDocumentFileLocation(v.FileLocation, ok); err != nil {
			return err
		}
	}

	if v.FileName != nil {
		ok := object.Key("fileName")
		ok.String(*v.FileName)
	}

	if v.FileType != nil {
		ok := object.Key("fileType")
		ok.Integer(*v.FileType)
	}

	if v.FileVersion != nil {
		ok := object.Key("fileVersion")
		ok.String(*v.FileVersion)
	}

	return nil
}

func awsRestjson1_serializeDocumentOTAUpdateFiles(v []types.OTAUpdateFile, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentOTAUpdateFile(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentParameterMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentParameters(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentPercentList(v []float64, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		switch {
		case math.IsNaN(v[i]):
			av.String("NaN")

		case math.IsInf(v[i], 1):
			av.String("Infinity")

		case math.IsInf(v[i], -1):
			av.String("-Infinity")

		default:
			av.Double(v[i])

		}
	}
	return nil
}

func awsRestjson1_serializeDocumentPolicyNames(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentPolicyVersionIdentifier(v *types.PolicyVersionIdentifier, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PolicyName != nil {
		ok := object.Key("policyName")
		ok.String(*v.PolicyName)
	}

	if v.PolicyVersionId != nil {
		ok := object.Key("policyVersionId")
		ok.String(*v.PolicyVersionId)
	}

	return nil
}

func awsRestjson1_serializeDocumentPorts(v []int32, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.Integer(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentPresignedUrlConfig(v *types.PresignedUrlConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ExpiresInSec != nil {
		ok := object.Key("expiresInSec")
		ok.Long(*v.ExpiresInSec)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentProtocols(v []types.Protocol, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentProvisioningHook(v *types.ProvisioningHook, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PayloadVersion != nil {
		ok := object.Key("payloadVersion")
		ok.String(*v.PayloadVersion)
	}

	if v.TargetArn != nil {
		ok := object.Key("targetArn")
		ok.String(*v.TargetArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentPublicKeyMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentPublishFindingToSnsParams(v *types.PublishFindingToSnsParams, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TopicArn != nil {
		ok := object.Key("topicArn")
		ok.String(*v.TopicArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentPutAssetPropertyValueEntry(v *types.PutAssetPropertyValueEntry, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AssetId != nil {
		ok := object.Key("assetId")
		ok.String(*v.AssetId)
	}

	if v.EntryId != nil {
		ok := object.Key("entryId")
		ok.String(*v.EntryId)
	}

	if v.PropertyAlias != nil {
		ok := object.Key("propertyAlias")
		ok.String(*v.PropertyAlias)
	}

	if v.PropertyId != nil {
		ok := object.Key("propertyId")
		ok.String(*v.PropertyId)
	}

	if v.PropertyValues != nil {
		ok := object.Key("propertyValues")
		if err := awsRestjson1_serializeDocumentAssetPropertyValueList(v.PropertyValues, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPutAssetPropertyValueEntryList(v []types.PutAssetPropertyValueEntry, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentPutAssetPropertyValueEntry(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentPutItemInput(v *types.PutItemInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TableName != nil {
		ok := object.Key("tableName")
		ok.String(*v.TableName)
	}

	return nil
}

func awsRestjson1_serializeDocumentRateIncreaseCriteria(v *types.RateIncreaseCriteria, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.NumberOfNotifiedThings != nil {
		ok := object.Key("numberOfNotifiedThings")
		ok.Integer(*v.NumberOfNotifiedThings)
	}

	if v.NumberOfSucceededThings != nil {
		ok := object.Key("numberOfSucceededThings")
		ok.Integer(*v.NumberOfSucceededThings)
	}

	return nil
}

func awsRestjson1_serializeDocumentReasonForNonComplianceCodes(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentRegistrationConfig(v *types.RegistrationConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.TemplateBody != nil {
		ok := object.Key("templateBody")
		ok.String(*v.TemplateBody)
	}

	return nil
}

func awsRestjson1_serializeDocumentReplaceDefaultPolicyVersionParams(v *types.ReplaceDefaultPolicyVersionParams, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.TemplateName) > 0 {
		ok := object.Key("templateName")
		ok.String(string(v.TemplateName))
	}

	return nil
}

func awsRestjson1_serializeDocumentRepublishAction(v *types.RepublishAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Qos != nil {
		ok := object.Key("qos")
		ok.Integer(*v.Qos)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.Topic != nil {
		ok := object.Key("topic")
		ok.String(*v.Topic)
	}

	return nil
}

func awsRestjson1_serializeDocumentResourceIdentifier(v *types.ResourceIdentifier, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Account != nil {
		ok := object.Key("account")
		ok.String(*v.Account)
	}

	if v.CaCertificateId != nil {
		ok := object.Key("caCertificateId")
		ok.String(*v.CaCertificateId)
	}

	if v.ClientId != nil {
		ok := object.Key("clientId")
		ok.String(*v.ClientId)
	}

	if v.CognitoIdentityPoolId != nil {
		ok := object.Key("cognitoIdentityPoolId")
		ok.String(*v.CognitoIdentityPoolId)
	}

	if v.DeviceCertificateId != nil {
		ok := object.Key("deviceCertificateId")
		ok.String(*v.DeviceCertificateId)
	}

	if v.IamRoleArn != nil {
		ok := object.Key("iamRoleArn")
		ok.String(*v.IamRoleArn)
	}

	if v.PolicyVersionIdentifier != nil {
		ok := object.Key("policyVersionIdentifier")
		if err := awsRestjson1_serializeDocumentPolicyVersionIdentifier(v.PolicyVersionIdentifier, ok); err != nil {
			return err
		}
	}

	if v.RoleAliasArn != nil {
		ok := object.Key("roleAliasArn")
		ok.String(*v.RoleAliasArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentResources(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentRetryCriteria(v *types.RetryCriteria, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.FailureType) > 0 {
		ok := object.Key("failureType")
		ok.String(string(v.FailureType))
	}

	if v.NumberOfRetries != nil {
		ok := object.Key("numberOfRetries")
		ok.Integer(*v.NumberOfRetries)
	}

	return nil
}

func awsRestjson1_serializeDocumentRetryCriteriaList(v []types.RetryCriteria, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentRetryCriteria(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentS3Action(v *types.S3Action, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BucketName != nil {
		ok := object.Key("bucketName")
		ok.String(*v.BucketName)
	}

	if len(v.CannedAcl) > 0 {
		ok := object.Key("cannedAcl")
		ok.String(string(v.CannedAcl))
	}

	if v.Key != nil {
		ok := object.Key("key")
		ok.String(*v.Key)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentS3Destination(v *types.S3Destination, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Bucket != nil {
		ok := object.Key("bucket")
		ok.String(*v.Bucket)
	}

	if v.Prefix != nil {
		ok := object.Key("prefix")
		ok.String(*v.Prefix)
	}

	return nil
}

func awsRestjson1_serializeDocumentS3Location(v *types.S3Location, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Bucket != nil {
		ok := object.Key("bucket")
		ok.String(*v.Bucket)
	}

	if v.Key != nil {
		ok := object.Key("key")
		ok.String(*v.Key)
	}

	if v.Version != nil {
		ok := object.Key("version")
		ok.String(*v.Version)
	}

	return nil
}

func awsRestjson1_serializeDocumentSalesforceAction(v *types.SalesforceAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Token != nil {
		ok := object.Key("token")
		ok.String(*v.Token)
	}

	if v.Url != nil {
		ok := object.Key("url")
		ok.String(*v.Url)
	}

	return nil
}

func awsRestjson1_serializeDocumentSearchableAttributes(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentSecurityGroupList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentServerCertificateArns(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentSigningProfileParameter(v *types.SigningProfileParameter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CertificateArn != nil {
		ok := object.Key("certificateArn")
		ok.String(*v.CertificateArn)
	}

	if v.CertificatePathOnDevice != nil {
		ok := object.Key("certificatePathOnDevice")
		ok.String(*v.CertificatePathOnDevice)
	}

	if v.Platform != nil {
		ok := object.Key("platform")
		ok.String(*v.Platform)
	}

	return nil
}

func awsRestjson1_serializeDocumentSigV4Authorization(v *types.SigV4Authorization, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.ServiceName != nil {
		ok := object.Key("serviceName")
		ok.String(*v.ServiceName)
	}

	if v.SigningRegion != nil {
		ok := object.Key("signingRegion")
		ok.String(*v.SigningRegion)
	}

	return nil
}

func awsRestjson1_serializeDocumentSnsAction(v *types.SnsAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.MessageFormat) > 0 {
		ok := object.Key("messageFormat")
		ok.String(string(v.MessageFormat))
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.TargetArn != nil {
		ok := object.Key("targetArn")
		ok.String(*v.TargetArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentSqsAction(v *types.SqsAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.QueueUrl != nil {
		ok := object.Key("queueUrl")
		ok.String(*v.QueueUrl)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.UseBase64 != nil {
		ok := object.Key("useBase64")
		ok.Boolean(*v.UseBase64)
	}

	return nil
}

func awsRestjson1_serializeDocumentStartSigningJobParameter(v *types.StartSigningJobParameter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Destination != nil {
		ok := object.Key("destination")
		if err := awsRestjson1_serializeDocumentDestination(v.Destination, ok); err != nil {
			return err
		}
	}

	if v.SigningProfileName != nil {
		ok := object.Key("signingProfileName")
		ok.String(*v.SigningProfileName)
	}

	if v.SigningProfileParameter != nil {
		ok := object.Key("signingProfileParameter")
		if err := awsRestjson1_serializeDocumentSigningProfileParameter(v.SigningProfileParameter, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentStatisticalThreshold(v *types.StatisticalThreshold, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Statistic != nil {
		ok := object.Key("statistic")
		ok.String(*v.Statistic)
	}

	return nil
}

func awsRestjson1_serializeDocumentStepFunctionsAction(v *types.StepFunctionsAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ExecutionNamePrefix != nil {
		ok := object.Key("executionNamePrefix")
		ok.String(*v.ExecutionNamePrefix)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.StateMachineName != nil {
		ok := object.Key("stateMachineName")
		ok.String(*v.StateMachineName)
	}

	return nil
}

func awsRestjson1_serializeDocumentStream(v *types.Stream, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FileId != nil {
		ok := object.Key("fileId")
		ok.Integer(*v.FileId)
	}

	if v.StreamId != nil {
		ok := object.Key("streamId")
		ok.String(*v.StreamId)
	}

	return nil
}

func awsRestjson1_serializeDocumentStreamFile(v *types.StreamFile, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FileId != nil {
		ok := object.Key("fileId")
		ok.Integer(*v.FileId)
	}

	if v.S3Location != nil {
		ok := object.Key("s3Location")
		if err := awsRestjson1_serializeDocumentS3Location(v.S3Location, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentStreamFiles(v []types.StreamFile, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentStreamFile(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentStringList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentSubnetIdList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentTag(v *types.Tag, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Key != nil {
		ok := object.Key("Key")
		ok.String(*v.Key)
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentTagKeyList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentTagList(v []types.Tag, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentTag(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentTargetAuditCheckNames(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentTargets(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentTargetViolationIdsForDetectMitigationActions(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentTermsAggregation(v *types.TermsAggregation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxBuckets != 0 {
		ok := object.Key("maxBuckets")
		ok.Integer(v.MaxBuckets)
	}

	return nil
}

func awsRestjson1_serializeDocumentThingGroupIndexingConfiguration(v *types.ThingGroupIndexingConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CustomFields != nil {
		ok := object.Key("customFields")
		if err := awsRestjson1_serializeDocumentFields(v.CustomFields, ok); err != nil {
			return err
		}
	}

	if v.ManagedFields != nil {
		ok := object.Key("managedFields")
		if err := awsRestjson1_serializeDocumentFields(v.ManagedFields, ok); err != nil {
			return err
		}
	}

	if len(v.ThingGroupIndexingMode) > 0 {
		ok := object.Key("thingGroupIndexingMode")
		ok.String(string(v.ThingGroupIndexingMode))
	}

	return nil
}

func awsRestjson1_serializeDocumentThingGroupList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentThingGroupNames(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentThingGroupProperties(v *types.ThingGroupProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AttributePayload != nil {
		ok := object.Key("attributePayload")
		if err := awsRestjson1_serializeDocumentAttributePayload(v.AttributePayload, ok); err != nil {
			return err
		}
	}

	if v.ThingGroupDescription != nil {
		ok := object.Key("thingGroupDescription")
		ok.String(*v.ThingGroupDescription)
	}

	return nil
}

func awsRestjson1_serializeDocumentThingIndexingConfiguration(v *types.ThingIndexingConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CustomFields != nil {
		ok := object.Key("customFields")
		if err := awsRestjson1_serializeDocumentFields(v.CustomFields, ok); err != nil {
			return err
		}
	}

	if len(v.DeviceDefenderIndexingMode) > 0 {
		ok := object.Key("deviceDefenderIndexingMode")
		ok.String(string(v.DeviceDefenderIndexingMode))
	}

	if v.Filter != nil {
		ok := object.Key("filter")
		if err := awsRestjson1_serializeDocumentIndexingFilter(v.Filter, ok); err != nil {
			return err
		}
	}

	if v.ManagedFields != nil {
		ok := object.Key("managedFields")
		if err := awsRestjson1_serializeDocumentFields(v.ManagedFields, ok); err != nil {
			return err
		}
	}

	if len(v.NamedShadowIndexingMode) > 0 {
		ok := object.Key("namedShadowIndexingMode")
		ok.String(string(v.NamedShadowIndexingMode))
	}

	if len(v.ThingConnectivityIndexingMode) > 0 {
		ok := object.Key("thingConnectivityIndexingMode")
		ok.String(string(v.ThingConnectivityIndexingMode))
	}

	if len(v.ThingIndexingMode) > 0 {
		ok := object.Key("thingIndexingMode")
		ok.String(string(v.ThingIndexingMode))
	}

	return nil
}

func awsRestjson1_serializeDocumentThingTypeProperties(v *types.ThingTypeProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SearchableAttributes != nil {
		ok := object.Key("searchableAttributes")
		if err := awsRestjson1_serializeDocumentSearchableAttributes(v.SearchableAttributes, ok); err != nil {
			return err
		}
	}

	if v.ThingTypeDescription != nil {
		ok := object.Key("thingTypeDescription")
		ok.String(*v.ThingTypeDescription)
	}

	return nil
}

func awsRestjson1_serializeDocumentTimeoutConfig(v *types.TimeoutConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InProgressTimeoutInMinutes != nil {
		ok := object.Key("inProgressTimeoutInMinutes")
		ok.Long(*v.InProgressTimeoutInMinutes)
	}

	return nil
}

func awsRestjson1_serializeDocumentTimestreamAction(v *types.TimestreamAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DatabaseName != nil {
		ok := object.Key("databaseName")
		ok.String(*v.DatabaseName)
	}

	if v.Dimensions != nil {
		ok := object.Key("dimensions")
		if err := awsRestjson1_serializeDocumentTimestreamDimensionList(v.Dimensions, ok); err != nil {
			return err
		}
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.TableName != nil {
		ok := object.Key("tableName")
		ok.String(*v.TableName)
	}

	if v.Timestamp != nil {
		ok := object.Key("timestamp")
		if err := awsRestjson1_serializeDocumentTimestreamTimestamp(v.Timestamp, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentTimestreamDimension(v *types.TimestreamDimension, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Value != nil {
		ok := object.Key("value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentTimestreamDimensionList(v []types.TimestreamDimension, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentTimestreamDimension(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentTimestreamTimestamp(v *types.TimestreamTimestamp, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Unit != nil {
		ok := object.Key("unit")
		ok.String(*v.Unit)
	}

	if v.Value != nil {
		ok := object.Key("value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentTlsContext(v *types.TlsContext, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ServerName != nil {
		ok := object.Key("serverName")
		ok.String(*v.ServerName)
	}

	return nil
}

func awsRestjson1_serializeDocumentTopicRuleDestinationConfiguration(v *types.TopicRuleDestinationConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.HttpUrlConfiguration != nil {
		ok := object.Key("httpUrlConfiguration")
		if err := awsRestjson1_serializeDocumentHttpUrlDestinationConfiguration(v.HttpUrlConfiguration, ok); err != nil {
			return err
		}
	}

	if v.VpcConfiguration != nil {
		ok := object.Key("vpcConfiguration")
		if err := awsRestjson1_serializeDocumentVpcDestinationConfiguration(v.VpcConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentTopicRulePayload(v *types.TopicRulePayload, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Actions != nil {
		ok := object.Key("actions")
		if err := awsRestjson1_serializeDocumentActionList(v.Actions, ok); err != nil {
			return err
		}
	}

	if v.AwsIotSqlVersion != nil {
		ok := object.Key("awsIotSqlVersion")
		ok.String(*v.AwsIotSqlVersion)
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.ErrorAction != nil {
		ok := object.Key("errorAction")
		if err := awsRestjson1_serializeDocumentAction(v.ErrorAction, ok); err != nil {
			return err
		}
	}

	if v.RuleDisabled != nil {
		ok := object.Key("ruleDisabled")
		ok.Boolean(*v.RuleDisabled)
	}

	if v.Sql != nil {
		ok := object.Key("sql")
		ok.String(*v.Sql)
	}

	return nil
}

func awsRestjson1_serializeDocumentUpdateCACertificateParams(v *types.UpdateCACertificateParams, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Action) > 0 {
		ok := object.Key("action")
		ok.String(string(v.Action))
	}

	return nil
}

func awsRestjson1_serializeDocumentUpdateDeviceCertificateParams(v *types.UpdateDeviceCertificateParams, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Action) > 0 {
		ok := object.Key("action")
		ok.String(string(v.Action))
	}

	return nil
}

func awsRestjson1_serializeDocumentViolationEventOccurrenceRange(v *types.ViolationEventOccurrenceRange, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EndTime != nil {
		ok := object.Key("endTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.EndTime))
	}

	if v.StartTime != nil {
		ok := object.Key("startTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.StartTime))
	}

	return nil
}

func awsRestjson1_serializeDocumentVpcDestinationConfiguration(v *types.VpcDestinationConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.SecurityGroups != nil {
		ok := object.Key("securityGroups")
		if err := awsRestjson1_serializeDocumentSecurityGroupList(v.SecurityGroups, ok); err != nil {
			return err
		}
	}

	if v.SubnetIds != nil {
		ok := object.Key("subnetIds")
		if err := awsRestjson1_serializeDocumentSubnetIdList(v.SubnetIds, ok); err != nil {
			return err
		}
	}

	if v.VpcId != nil {
		ok := object.Key("vpcId")
		ok.String(*v.VpcId)
	}

	return nil
}
