// Code generated by smithy-go-codegen DO NOT EDIT.

package kendra

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/kendra/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates an access control configuration for your documents in an index. This
// includes user and group access information for your documents. This is useful
// for user context filtering, where search results are filtered based on the user
// or their group access to documents. You can update an access control
// configuration you created without indexing all of your documents again. For
// example, your index contains top-secret company documents that only certain
// employees or users should access. You created an 'allow' access control
// configuration for one user who recently joined the 'top-secret' team, switching
// from a team with 'deny' access to top-secret documents. However, the user
// suddenly returns to their previous team and should no longer have access to top
// secret documents. You can update the access control configuration to
// re-configure access control for your documents as circumstances change. You call
// the BatchPutDocument
// (https://docs.aws.amazon.com/kendra/latest/dg/API_BatchPutDocument.html) API to
// apply the updated access control configuration, with the
// AccessControlConfigurationId included in the Document
// (https://docs.aws.amazon.com/kendra/latest/dg/API_Document.html) object. If you
// use an S3 bucket as a data source, you synchronize your data source to apply the
// AccessControlConfigurationId in the .metadata.json file. Amazon Kendra currently
// only supports access control configuration for S3 data sources and documents
// indexed using the BatchPutDocument API.
func (c *Client) UpdateAccessControlConfiguration(ctx context.Context, params *UpdateAccessControlConfigurationInput, optFns ...func(*Options)) (*UpdateAccessControlConfigurationOutput, error) {
	if params == nil {
		params = &UpdateAccessControlConfigurationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateAccessControlConfiguration", params, optFns, c.addOperationUpdateAccessControlConfigurationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateAccessControlConfigurationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateAccessControlConfigurationInput struct {

	// The identifier of the access control configuration you want to update.
	//
	// This member is required.
	Id *string

	// The identifier of the index for an access control configuration.
	//
	// This member is required.
	IndexId *string

	// Information you want to update on principals (users and/or groups) and which
	// documents they should have access to. This is useful for user context filtering,
	// where search results are filtered based on the user or their group access to
	// documents.
	AccessControlList []types.Principal

	// A new description for the access control configuration.
	Description *string

	// The updated list of principal
	// (https://docs.aws.amazon.com/kendra/latest/dg/API_Principal.html) lists that
	// define the hierarchy for which documents users should have access to.
	HierarchicalAccessControlList []types.HierarchicalPrincipal

	// A new name for the access control configuration.
	Name *string

	noSmithyDocumentSerde
}

type UpdateAccessControlConfigurationOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateAccessControlConfigurationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpUpdateAccessControlConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpUpdateAccessControlConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpUpdateAccessControlConfigurationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateAccessControlConfiguration(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateAccessControlConfiguration(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "kendra",
		OperationName: "UpdateAccessControlConfiguration",
	}
}
