// Code generated by smithy-go-codegen DO NOT EDIT.

package rolesanywhere

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/rolesanywhere/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Imports the certificate revocation list (CRL). CRl is a list of certificates
// that have been revoked by the issuing certificate Authority (CA). IAM Roles
// Anywhere validates against the crl list before issuing credentials. Required
// permissions: rolesanywhere:ImportCrl.
func (c *Client) ImportCrl(ctx context.Context, params *ImportCrlInput, optFns ...func(*Options)) (*ImportCrlOutput, error) {
	if params == nil {
		params = &ImportCrlInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ImportCrl", params, optFns, c.addOperationImportCrlMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ImportCrlOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ImportCrlInput struct {

	// The x509 v3 specified certificate revocation list
	//
	// This member is required.
	CrlData []byte

	// The name of the certificate revocation list (CRL).
	//
	// This member is required.
	Name *string

	// The ARN of the TrustAnchor the certificate revocation list (CRL) will provide
	// revocation for.
	//
	// This member is required.
	TrustAnchorArn *string

	// Specifies whether the certificate revocation list (CRL) is enabled.
	Enabled *bool

	// A list of tags to attach to the certificate revocation list (CRL).
	Tags []types.Tag

	noSmithyDocumentSerde
}

type ImportCrlOutput struct {

	// The state of the certificate revocation list (CRL) after a read or write
	// operation.
	//
	// This member is required.
	Crl *types.CrlDetail

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationImportCrlMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpImportCrl{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpImportCrl{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpImportCrlValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opImportCrl(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opImportCrl(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "rolesanywhere",
		OperationName: "ImportCrl",
	}
}
