// Code generated by smithy-go-codegen DO NOT EDIT.

package route53recoveryreadiness

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a recovery group in an account. A recovery group corresponds to an
// application and includes a list of the cells that make up the application.
func (c *Client) CreateRecoveryGroup(ctx context.Context, params *CreateRecoveryGroupInput, optFns ...func(*Options)) (*CreateRecoveryGroupOutput, error) {
	if params == nil {
		params = &CreateRecoveryGroupInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateRecoveryGroup", params, optFns, c.addOperationCreateRecoveryGroupMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateRecoveryGroupOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateRecoveryGroupInput struct {

	// The name of the recovery group to create.
	//
	// This member is required.
	RecoveryGroupName *string

	// A list of the cell Amazon Resource Names (ARNs) in the recovery group.
	Cells []string

	// A collection of tags associated with a resource.
	Tags map[string]string

	noSmithyDocumentSerde
}

type CreateRecoveryGroupOutput struct {

	// A list of a cell's Amazon Resource Names (ARNs).
	Cells []string

	// The Amazon Resource Name (ARN) for the recovery group.
	RecoveryGroupArn *string

	// The name of the recovery group.
	RecoveryGroupName *string

	// The tags associated with the recovery group.
	Tags map[string]string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateRecoveryGroupMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateRecoveryGroup{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateRecoveryGroup{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpCreateRecoveryGroupValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateRecoveryGroup(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateRecoveryGroup(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "route53-recovery-readiness",
		OperationName: "CreateRecoveryGroup",
	}
}
