// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.2.0
// - protoc             v4.23.1
// source: ssh.proto

package gitalypb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

// SSHServiceClient is the client API for SSHService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type SSHServiceClient interface {
	// SSHUploadPack is an RPC to forward git-upload-pack(1) to Gitaly for SSH sessions. The RPC uses
	// bidirectional streaming so the client can stream stdin and the server can stream stdout and
	// stderr for git-upload-pack(1).
	SSHUploadPack(ctx context.Context, opts ...grpc.CallOption) (SSHService_SSHUploadPackClient, error)
	// SSHUploadPackWithSidechannel is an RPC to forward git-upload-pack(1) to Gitaly for SSH
	// sessions, via sidechannels. Sidechannel connections sidestep gRPC Protobuf message overhead and
	// allow higher throughput of bulk data transfers. The stdin, stdout, and stderr for the
	// git-upload-pack(1) are streamed through the sidechannel connection.
	SSHUploadPackWithSidechannel(ctx context.Context, in *SSHUploadPackWithSidechannelRequest, opts ...grpc.CallOption) (*SSHUploadPackWithSidechannelResponse, error)
	// SSHReceivePack is an RPC to forward git-receive-pack(1) to Gitaly for SSH sessions. The RPC uses
	// bidirectional streaming so the client can stream stdin and the server can stream stdout and
	// stderr for git-receive-pack(1).
	SSHReceivePack(ctx context.Context, opts ...grpc.CallOption) (SSHService_SSHReceivePackClient, error)
	// SSHUploadArchive is an RPC to forward git-upload-archive(1) to Gitaly for SSH sessions. The RPC
	// uses bidirectional streaming so the client can stream stdin and the server can stream stdout
	// and stderr for git-upload-archive(1).
	SSHUploadArchive(ctx context.Context, opts ...grpc.CallOption) (SSHService_SSHUploadArchiveClient, error)
}

type sSHServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewSSHServiceClient(cc grpc.ClientConnInterface) SSHServiceClient {
	return &sSHServiceClient{cc}
}

func (c *sSHServiceClient) SSHUploadPack(ctx context.Context, opts ...grpc.CallOption) (SSHService_SSHUploadPackClient, error) {
	stream, err := c.cc.NewStream(ctx, &SSHService_ServiceDesc.Streams[0], "/gitaly.SSHService/SSHUploadPack", opts...)
	if err != nil {
		return nil, err
	}
	x := &sSHServiceSSHUploadPackClient{stream}
	return x, nil
}

type SSHService_SSHUploadPackClient interface {
	Send(*SSHUploadPackRequest) error
	Recv() (*SSHUploadPackResponse, error)
	grpc.ClientStream
}

type sSHServiceSSHUploadPackClient struct {
	grpc.ClientStream
}

func (x *sSHServiceSSHUploadPackClient) Send(m *SSHUploadPackRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *sSHServiceSSHUploadPackClient) Recv() (*SSHUploadPackResponse, error) {
	m := new(SSHUploadPackResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *sSHServiceClient) SSHUploadPackWithSidechannel(ctx context.Context, in *SSHUploadPackWithSidechannelRequest, opts ...grpc.CallOption) (*SSHUploadPackWithSidechannelResponse, error) {
	out := new(SSHUploadPackWithSidechannelResponse)
	err := c.cc.Invoke(ctx, "/gitaly.SSHService/SSHUploadPackWithSidechannel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sSHServiceClient) SSHReceivePack(ctx context.Context, opts ...grpc.CallOption) (SSHService_SSHReceivePackClient, error) {
	stream, err := c.cc.NewStream(ctx, &SSHService_ServiceDesc.Streams[1], "/gitaly.SSHService/SSHReceivePack", opts...)
	if err != nil {
		return nil, err
	}
	x := &sSHServiceSSHReceivePackClient{stream}
	return x, nil
}

type SSHService_SSHReceivePackClient interface {
	Send(*SSHReceivePackRequest) error
	Recv() (*SSHReceivePackResponse, error)
	grpc.ClientStream
}

type sSHServiceSSHReceivePackClient struct {
	grpc.ClientStream
}

func (x *sSHServiceSSHReceivePackClient) Send(m *SSHReceivePackRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *sSHServiceSSHReceivePackClient) Recv() (*SSHReceivePackResponse, error) {
	m := new(SSHReceivePackResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *sSHServiceClient) SSHUploadArchive(ctx context.Context, opts ...grpc.CallOption) (SSHService_SSHUploadArchiveClient, error) {
	stream, err := c.cc.NewStream(ctx, &SSHService_ServiceDesc.Streams[2], "/gitaly.SSHService/SSHUploadArchive", opts...)
	if err != nil {
		return nil, err
	}
	x := &sSHServiceSSHUploadArchiveClient{stream}
	return x, nil
}

type SSHService_SSHUploadArchiveClient interface {
	Send(*SSHUploadArchiveRequest) error
	Recv() (*SSHUploadArchiveResponse, error)
	grpc.ClientStream
}

type sSHServiceSSHUploadArchiveClient struct {
	grpc.ClientStream
}

func (x *sSHServiceSSHUploadArchiveClient) Send(m *SSHUploadArchiveRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *sSHServiceSSHUploadArchiveClient) Recv() (*SSHUploadArchiveResponse, error) {
	m := new(SSHUploadArchiveResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// SSHServiceServer is the server API for SSHService service.
// All implementations must embed UnimplementedSSHServiceServer
// for forward compatibility
type SSHServiceServer interface {
	// SSHUploadPack is an RPC to forward git-upload-pack(1) to Gitaly for SSH sessions. The RPC uses
	// bidirectional streaming so the client can stream stdin and the server can stream stdout and
	// stderr for git-upload-pack(1).
	SSHUploadPack(SSHService_SSHUploadPackServer) error
	// SSHUploadPackWithSidechannel is an RPC to forward git-upload-pack(1) to Gitaly for SSH
	// sessions, via sidechannels. Sidechannel connections sidestep gRPC Protobuf message overhead and
	// allow higher throughput of bulk data transfers. The stdin, stdout, and stderr for the
	// git-upload-pack(1) are streamed through the sidechannel connection.
	SSHUploadPackWithSidechannel(context.Context, *SSHUploadPackWithSidechannelRequest) (*SSHUploadPackWithSidechannelResponse, error)
	// SSHReceivePack is an RPC to forward git-receive-pack(1) to Gitaly for SSH sessions. The RPC uses
	// bidirectional streaming so the client can stream stdin and the server can stream stdout and
	// stderr for git-receive-pack(1).
	SSHReceivePack(SSHService_SSHReceivePackServer) error
	// SSHUploadArchive is an RPC to forward git-upload-archive(1) to Gitaly for SSH sessions. The RPC
	// uses bidirectional streaming so the client can stream stdin and the server can stream stdout
	// and stderr for git-upload-archive(1).
	SSHUploadArchive(SSHService_SSHUploadArchiveServer) error
	mustEmbedUnimplementedSSHServiceServer()
}

// UnimplementedSSHServiceServer must be embedded to have forward compatible implementations.
type UnimplementedSSHServiceServer struct {
}

func (UnimplementedSSHServiceServer) SSHUploadPack(SSHService_SSHUploadPackServer) error {
	return status.Errorf(codes.Unimplemented, "method SSHUploadPack not implemented")
}
func (UnimplementedSSHServiceServer) SSHUploadPackWithSidechannel(context.Context, *SSHUploadPackWithSidechannelRequest) (*SSHUploadPackWithSidechannelResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SSHUploadPackWithSidechannel not implemented")
}
func (UnimplementedSSHServiceServer) SSHReceivePack(SSHService_SSHReceivePackServer) error {
	return status.Errorf(codes.Unimplemented, "method SSHReceivePack not implemented")
}
func (UnimplementedSSHServiceServer) SSHUploadArchive(SSHService_SSHUploadArchiveServer) error {
	return status.Errorf(codes.Unimplemented, "method SSHUploadArchive not implemented")
}
func (UnimplementedSSHServiceServer) mustEmbedUnimplementedSSHServiceServer() {}

// UnsafeSSHServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to SSHServiceServer will
// result in compilation errors.
type UnsafeSSHServiceServer interface {
	mustEmbedUnimplementedSSHServiceServer()
}

func RegisterSSHServiceServer(s grpc.ServiceRegistrar, srv SSHServiceServer) {
	s.RegisterService(&SSHService_ServiceDesc, srv)
}

func _SSHService_SSHUploadPack_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(SSHServiceServer).SSHUploadPack(&sSHServiceSSHUploadPackServer{stream})
}

type SSHService_SSHUploadPackServer interface {
	Send(*SSHUploadPackResponse) error
	Recv() (*SSHUploadPackRequest, error)
	grpc.ServerStream
}

type sSHServiceSSHUploadPackServer struct {
	grpc.ServerStream
}

func (x *sSHServiceSSHUploadPackServer) Send(m *SSHUploadPackResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *sSHServiceSSHUploadPackServer) Recv() (*SSHUploadPackRequest, error) {
	m := new(SSHUploadPackRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _SSHService_SSHUploadPackWithSidechannel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SSHUploadPackWithSidechannelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SSHServiceServer).SSHUploadPackWithSidechannel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.SSHService/SSHUploadPackWithSidechannel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SSHServiceServer).SSHUploadPackWithSidechannel(ctx, req.(*SSHUploadPackWithSidechannelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SSHService_SSHReceivePack_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(SSHServiceServer).SSHReceivePack(&sSHServiceSSHReceivePackServer{stream})
}

type SSHService_SSHReceivePackServer interface {
	Send(*SSHReceivePackResponse) error
	Recv() (*SSHReceivePackRequest, error)
	grpc.ServerStream
}

type sSHServiceSSHReceivePackServer struct {
	grpc.ServerStream
}

func (x *sSHServiceSSHReceivePackServer) Send(m *SSHReceivePackResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *sSHServiceSSHReceivePackServer) Recv() (*SSHReceivePackRequest, error) {
	m := new(SSHReceivePackRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _SSHService_SSHUploadArchive_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(SSHServiceServer).SSHUploadArchive(&sSHServiceSSHUploadArchiveServer{stream})
}

type SSHService_SSHUploadArchiveServer interface {
	Send(*SSHUploadArchiveResponse) error
	Recv() (*SSHUploadArchiveRequest, error)
	grpc.ServerStream
}

type sSHServiceSSHUploadArchiveServer struct {
	grpc.ServerStream
}

func (x *sSHServiceSSHUploadArchiveServer) Send(m *SSHUploadArchiveResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *sSHServiceSSHUploadArchiveServer) Recv() (*SSHUploadArchiveRequest, error) {
	m := new(SSHUploadArchiveRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// SSHService_ServiceDesc is the grpc.ServiceDesc for SSHService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var SSHService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "gitaly.SSHService",
	HandlerType: (*SSHServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "SSHUploadPackWithSidechannel",
			Handler:    _SSHService_SSHUploadPackWithSidechannel_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "SSHUploadPack",
			Handler:       _SSHService_SSHUploadPack_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "SSHReceivePack",
			Handler:       _SSHService_SSHReceivePack_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "SSHUploadArchive",
			Handler:       _SSHService_SSHUploadArchive_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "ssh.proto",
}
