/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#include "gtk-utils.h"

#include "gtkcontainer-utils.h"

#include <gtk/gtkprivate.h>


static GtkWidget *
gtk_widget_at (GtkWidget *top_widget,
	       gint       x,
	       gint       y)
{
  GtkWidget *widget;

  g_return_val_if_fail (top_widget != NULL,         NULL);
  g_return_val_if_fail (GTK_IS_WIDGET (top_widget), NULL);


  widget = NULL;

  if (GTK_WIDGET_VISIBLE (top_widget) &&
      GTK_WIDGET_CHILD_VISIBLE (top_widget))
    {
      if (!GTK_IS_CONTAINER (top_widget))
	{
	  widget = top_widget;
	}
      else
	{
	  GList *children;
	  GList *tmp;
	  GtkWidget *child;
	  gint x0, y0;
	  gint x1, y1;
	  gint x2, y2;

	  if (GTK_WIDGET_NO_WINDOW (top_widget))
	    {
	      x0 = top_widget->allocation.x;
	      y0 = top_widget->allocation.y;
	    }
	  else
	    {
	      x0 = 0;
	      y0 = 0;
	    }

	  children = gtk_container_get_children (GTK_CONTAINER (top_widget));
	  tmp = children;
	  while (tmp != NULL)
	    {
	      child = (GtkWidget *)tmp->data;
	      tmp = g_list_next (tmp);

	      if ((child != NULL) &&
		  GTK_WIDGET_VISIBLE (child) &&
		  GTK_WIDGET_CHILD_VISIBLE (child))
		{
		  x1 = (child->allocation.x - x0);
		  x2 = (x1 + child->allocation.width);
		  y1 = (child->allocation.y - y0);
		  y2 = (y1 + child->allocation.height);

		  if (((x1 <= x) && (x <= x2)) &&
		      ((y1 <= y) && (y <= y2)))
		    {
		      widget = gtk_widget_at (child,
					      (x - x1),
					      (y - y1));

		      if (widget != NULL)
			break;
		    }
		}
	    }
	  if (children != NULL)
	    g_list_free (children);

	  if (widget == NULL)
	    widget = top_widget;
	}
    }

  return widget;
}

GtkWidget *
gtk_get_widget_at_pointer (void)
{
  GdkWindow *gdk_window;
  GtkWidget *tmp_widget;
  GtkWidget *widget;
  gint x;
  gint y;


  widget = NULL;

  
  gdk_window = gdk_window_at_pointer (NULL, NULL);

  if (gdk_window != NULL)
    {
      gdk_window_get_user_data (gdk_window, (gpointer *)&tmp_widget);

      if (tmp_widget != NULL)
	{
	  gdk_window_get_pointer (gdk_window, &x, &y, NULL);

	  widget = gtk_widget_at (tmp_widget, x, y);
	}
    }


  return widget;
}


GList *
gtk_get_widget_list (void)
{
  GList *toplevels;
  GList *tmp;
  GtkWidget *toplevel;
  GList *widgets;


  widgets = NULL;
  toplevels = gtk_window_list_toplevels ();

  tmp = toplevels;
  while (tmp != NULL)
    {
      toplevel = GTK_WIDGET (tmp->data);
      tmp = g_list_next (tmp);

      
      widgets = g_list_append (widgets, toplevel);

      if (GTK_IS_CONTAINER (toplevel))
	{
	  widgets = g_list_concat (widgets,
				   gtk_container_get_descendants_list
						(GTK_CONTAINER (toplevel)));
	}
    }

  return widgets;
}
