// Code generated by smithy-go-codegen DO NOT EDIT.

package panorama

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/panorama/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Returns information about a package import job.
func (c *Client) DescribePackageImportJob(ctx context.Context, params *DescribePackageImportJobInput, optFns ...func(*Options)) (*DescribePackageImportJobOutput, error) {
	if params == nil {
		params = &DescribePackageImportJobInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribePackageImportJob", params, optFns, c.addOperationDescribePackageImportJobMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribePackageImportJobOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribePackageImportJobInput struct {

	// The job's ID.
	//
	// This member is required.
	JobId *string

	noSmithyDocumentSerde
}

type DescribePackageImportJobOutput struct {

	// When the job was created.
	//
	// This member is required.
	CreatedTime *time.Time

	// The job's input config.
	//
	// This member is required.
	InputConfig *types.PackageImportJobInputConfig

	// The job's ID.
	//
	// This member is required.
	JobId *string

	// The job's type.
	//
	// This member is required.
	JobType types.PackageImportJobType

	// When the job was updated.
	//
	// This member is required.
	LastUpdatedTime *time.Time

	// The job's output.
	//
	// This member is required.
	Output *types.PackageImportJobOutput

	// The job's output config.
	//
	// This member is required.
	OutputConfig *types.PackageImportJobOutputConfig

	// The job's status.
	//
	// This member is required.
	Status types.PackageImportJobStatus

	// The job's status message.
	//
	// This member is required.
	StatusMessage *string

	// The job's client token.
	ClientToken *string

	// The job's tags.
	JobTags []types.JobResourceTags

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribePackageImportJobMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpDescribePackageImportJob{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpDescribePackageImportJob{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpDescribePackageImportJobValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribePackageImportJob(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribePackageImportJob(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "panorama",
		OperationName: "DescribePackageImportJob",
	}
}
