// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package costexplorer

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opGetCostAndUsage = "GetCostAndUsage"

// GetCostAndUsageRequest generates a "aws/request.Request" representing the
// client's request for the GetCostAndUsage operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCostAndUsage for more information on using the GetCostAndUsage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCostAndUsageRequest method.
//    req, resp := client.GetCostAndUsageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetCostAndUsage
func (c *CostExplorer) GetCostAndUsageRequest(input *GetCostAndUsageInput) (req *request.Request, output *GetCostAndUsageOutput) {
	op := &request.Operation{
		Name:       opGetCostAndUsage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetCostAndUsageInput{}
	}

	output = &GetCostAndUsageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCostAndUsage API operation for AWS Cost Explorer Service.
//
// Retrieve cost and usage metrics for your account. You can specify which cost
// and usage-related metric, such as BlendedCosts or UsageQuantity, that you
// want the request to return. You can also filter and group your data by various
// dimensions, such as AWS Service or AvailabilityZone, in a specific time range.
// See the GetDimensionValues action for a complete list of the valid dimensions.
// Master accounts in an organization have access to all member accounts.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation GetCostAndUsage for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeLimitExceededException "LimitExceededException"
//   You made too many calls in a short period of time. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetCostAndUsage
func (c *CostExplorer) GetCostAndUsage(input *GetCostAndUsageInput) (*GetCostAndUsageOutput, error) {
	req, out := c.GetCostAndUsageRequest(input)
	return out, req.Send()
}

// GetCostAndUsageWithContext is the same as GetCostAndUsage with the addition of
// the ability to pass a context and additional request options.
//
// See GetCostAndUsage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) GetCostAndUsageWithContext(ctx aws.Context, input *GetCostAndUsageInput, opts ...request.Option) (*GetCostAndUsageOutput, error) {
	req, out := c.GetCostAndUsageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDimensionValues = "GetDimensionValues"

// GetDimensionValuesRequest generates a "aws/request.Request" representing the
// client's request for the GetDimensionValues operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDimensionValues for more information on using the GetDimensionValues
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDimensionValuesRequest method.
//    req, resp := client.GetDimensionValuesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetDimensionValues
func (c *CostExplorer) GetDimensionValuesRequest(input *GetDimensionValuesInput) (req *request.Request, output *GetDimensionValuesOutput) {
	op := &request.Operation{
		Name:       opGetDimensionValues,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDimensionValuesInput{}
	}

	output = &GetDimensionValuesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDimensionValues API operation for AWS Cost Explorer Service.
//
// You can use GetDimensionValues to retrieve all available filter values for
// a specific filter over a period of time. You can search the dimension values
// for an arbitrary string.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation GetDimensionValues for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeLimitExceededException "LimitExceededException"
//   You made too many calls in a short period of time. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetDimensionValues
func (c *CostExplorer) GetDimensionValues(input *GetDimensionValuesInput) (*GetDimensionValuesOutput, error) {
	req, out := c.GetDimensionValuesRequest(input)
	return out, req.Send()
}

// GetDimensionValuesWithContext is the same as GetDimensionValues with the addition of
// the ability to pass a context and additional request options.
//
// See GetDimensionValues for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) GetDimensionValuesWithContext(ctx aws.Context, input *GetDimensionValuesInput, opts ...request.Option) (*GetDimensionValuesOutput, error) {
	req, out := c.GetDimensionValuesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetReservationUtilization = "GetReservationUtilization"

// GetReservationUtilizationRequest generates a "aws/request.Request" representing the
// client's request for the GetReservationUtilization operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetReservationUtilization for more information on using the GetReservationUtilization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetReservationUtilizationRequest method.
//    req, resp := client.GetReservationUtilizationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetReservationUtilization
func (c *CostExplorer) GetReservationUtilizationRequest(input *GetReservationUtilizationInput) (req *request.Request, output *GetReservationUtilizationOutput) {
	op := &request.Operation{
		Name:       opGetReservationUtilization,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetReservationUtilizationInput{}
	}

	output = &GetReservationUtilizationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetReservationUtilization API operation for AWS Cost Explorer Service.
//
// You can retrieve the Reservation utilization for your account. Master accounts
// in an organization have access to their associated member accounts. You can
// filter data by dimensions in a time period. You can use GetDimensionValues
// to determine the possible dimension values. Currently, you can group only
// by SUBSCRIPTION_ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation GetReservationUtilization for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeLimitExceededException "LimitExceededException"
//   You made too many calls in a short period of time. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetReservationUtilization
func (c *CostExplorer) GetReservationUtilization(input *GetReservationUtilizationInput) (*GetReservationUtilizationOutput, error) {
	req, out := c.GetReservationUtilizationRequest(input)
	return out, req.Send()
}

// GetReservationUtilizationWithContext is the same as GetReservationUtilization with the addition of
// the ability to pass a context and additional request options.
//
// See GetReservationUtilization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) GetReservationUtilizationWithContext(ctx aws.Context, input *GetReservationUtilizationInput, opts ...request.Option) (*GetReservationUtilizationOutput, error) {
	req, out := c.GetReservationUtilizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTags = "GetTags"

// GetTagsRequest generates a "aws/request.Request" representing the
// client's request for the GetTags operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTags for more information on using the GetTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetTagsRequest method.
//    req, resp := client.GetTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetTags
func (c *CostExplorer) GetTagsRequest(input *GetTagsInput) (req *request.Request, output *GetTagsOutput) {
	op := &request.Operation{
		Name:       opGetTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetTagsInput{}
	}

	output = &GetTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTags API operation for AWS Cost Explorer Service.
//
// You can query for available tag keys and tag values for a specified period.
// You can search the tag values for an arbitrary string.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost Explorer Service's
// API operation GetTags for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeLimitExceededException "LimitExceededException"
//   You made too many calls in a short period of time. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetTags
func (c *CostExplorer) GetTags(input *GetTagsInput) (*GetTagsOutput, error) {
	req, out := c.GetTagsRequest(input)
	return out, req.Send()
}

// GetTagsWithContext is the same as GetTags with the addition of
// the ability to pass a context and additional request options.
//
// See GetTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostExplorer) GetTagsWithContext(ctx aws.Context, input *GetTagsInput, opts ...request.Option) (*GetTagsOutput, error) {
	req, out := c.GetTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The time period that you want the usage and costs for.
type DateInterval struct {
	_ struct{} `type:"structure"`

	// The end of the time period that you want the usage and costs for. The end
	// date is exclusive. For example, if the end is 2017-05-01, then the cost and
	// usage data is retrieved from the start date but not including 2017-05-01.
	//
	// End is a required field
	End *string `type:"string" required:"true"`

	// The beginning of the time period that you want the usage and costs for. The
	// start date is inclusive. For example, if start is 2017-01-01, then the cost
	// and usage data is retrieved starting at 2017-01-01 up to the end date.
	//
	// Start is a required field
	Start *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DateInterval) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DateInterval) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DateInterval) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DateInterval"}
	if s.End == nil {
		invalidParams.Add(request.NewErrParamRequired("End"))
	}
	if s.Start == nil {
		invalidParams.Add(request.NewErrParamRequired("Start"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnd sets the End field's value.
func (s *DateInterval) SetEnd(v string) *DateInterval {
	s.End = &v
	return s
}

// SetStart sets the Start field's value.
func (s *DateInterval) SetStart(v string) *DateInterval {
	s.Start = &v
	return s
}

// The metadata that you can use to filter and group your results. You can use
// GetDimensionValues to find specific values.
type DimensionValues struct {
	_ struct{} `type:"structure"`

	// The names of the metadata types that you can use to filter and group your
	// results. For example, AZ returns a list of Availability Zones.
	Key *string `type:"string" enum:"Dimension"`

	// The metadata values that you can use to filter and group your results. You
	// can use GetDimensionValues to find specific values.
	Values []*string `type:"list"`
}

// String returns the string representation
func (s DimensionValues) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DimensionValues) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *DimensionValues) SetKey(v string) *DimensionValues {
	s.Key = &v
	return s
}

// SetValues sets the Values field's value.
func (s *DimensionValues) SetValues(v []*string) *DimensionValues {
	s.Values = v
	return s
}

// The metadata of a specific type that you can use to filter and group your
// results. You can use GetDimensionValues to find specific values.
type DimensionValuesWithAttributes struct {
	_ struct{} `type:"structure"`

	// The attribute that applies to a specific Dimension.
	Attributes map[string]*string `type:"map"`

	// The value of a dimension with a specific attribute.
	Value *string `type:"string"`
}

// String returns the string representation
func (s DimensionValuesWithAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DimensionValuesWithAttributes) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *DimensionValuesWithAttributes) SetAttributes(v map[string]*string) *DimensionValuesWithAttributes {
	s.Attributes = v
	return s
}

// SetValue sets the Value field's value.
func (s *DimensionValuesWithAttributes) SetValue(v string) *DimensionValuesWithAttributes {
	s.Value = &v
	return s
}

// Use Expression to filter by cost or by usage. There are two patterns:
//
//    * Simple dimension values - You can set the dimension name and values
//    for the filters that you plan to use. For example, you can filter for
//    InstanceType==m4.xlarge OR InstanceType==c4.large. The Expression for
//    that looks like this.
//
// { "Dimensions": { "Key": "InstanceType", "Values": [ "m4.xlarge", “c4.large”
//    ] } }
//
// The list of dimension values are OR'd together to retrieve cost or usage
//    data. You can create Expression and DimensionValues objects using either
//    with* methods or set* methods in multiple lines.
//
//    * Compound dimension values with logical operations - You can use multiple
//    Expression types and the logical operators AND/OR/NOT to create a list
//    of one or more Expression objects. This allows you to filter on more advanced
//    options. For example, you can filter on ((InstanceType == m4.large OR
//    InstanceType == m3.large) OR (Tag.Type == Type1)) AND (UsageType != DataTransfer).
//    The Expression for that looks like this.
//
// { "And": [ {"Or": [ {"Dimensions": { "Key": "InstanceType", "Values": [ "m4.x.large",
//    "c4.large" ] }}, {"Tag": { "Key": "TagName", "Values": ["Value1"] } }
//    ]}, {"Not": {"dimensions": { "Key": "UsageType", "Values": ["DataTransfer"]
//    }}} ] }
//
// Because each Expression can have only one operator, the service returns an
//    error if more than one is specified. The following example shows an Expression
//    object that will create an error.
//
//  { "And": [ ... ], "DimensionValues": { "Dimension": "UsageType", "Values":
//    [ "DataTransfer" ] } }
type Expression struct {
	_ struct{} `type:"structure"`

	// Return results that match both Dimension objects.
	And []*Expression `type:"list"`

	// The specific Dimension to use for Expression.
	Dimensions *DimensionValues `type:"structure"`

	// Return results that don't match Dimension.
	Not *Expression `type:"structure"`

	// Return results that match either Dimension.
	Or []*Expression `type:"list"`

	// The specific Tag to use for Expression.
	Tags *TagValues `type:"structure"`
}

// String returns the string representation
func (s Expression) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Expression) GoString() string {
	return s.String()
}

// SetAnd sets the And field's value.
func (s *Expression) SetAnd(v []*Expression) *Expression {
	s.And = v
	return s
}

// SetDimensions sets the Dimensions field's value.
func (s *Expression) SetDimensions(v *DimensionValues) *Expression {
	s.Dimensions = v
	return s
}

// SetNot sets the Not field's value.
func (s *Expression) SetNot(v *Expression) *Expression {
	s.Not = v
	return s
}

// SetOr sets the Or field's value.
func (s *Expression) SetOr(v []*Expression) *Expression {
	s.Or = v
	return s
}

// SetTags sets the Tags field's value.
func (s *Expression) SetTags(v *TagValues) *Expression {
	s.Tags = v
	return s
}

type GetCostAndUsageInput struct {
	_ struct{} `type:"structure"`

	// Filters AWS costs by different dimensions. For example, you can specify Service
	// and Linked Account and get the costs associated with that account's usage
	// of that service. You can nest Expression objects to define any combination
	// of dimension filters. For more information, see the Expression object or
	// More Examples.
	Filter *Expression `type:"structure"`

	// Sets the AWS cost granularity to MONTHLY or DAILY.
	Granularity *string `type:"string" enum:"Granularity"`

	// You can group AWS costs using up to two different groups, either dimensions,
	// tag keys, or both.
	//
	// When you group by tag key, you get all tag values, including empty strings.
	//
	// Valid values are: AZ, INSTANCE_TYPE, LINKED_ACCCOUNT, OPERATION, PURCHASE_TYPE,
	// SERVICE, USAGE_TYPE, TAGS, and PLATFORM.
	GroupBy []*GroupDefinition `type:"list"`

	// Which metrics are returned in the query. For more information about blended
	// and unblended rates, see https://aws.amazon.com/premiumsupport/knowledge-center/blended-rates-intro/.
	//
	// Valid values are BlendedCost, UnblendedCost, and UsageQuantity.
	//
	// If you return the UsageQuantity metric, the service aggregates all usage
	// numbers without taking into account the units. For example, if you aggregate
	// usageQuantity across all of EC2, the results aren't meaningful because EC2
	// compute hours and data transfer are measured in different units (for example,
	// hours vs. GB). To get more meaningful UsageQuantity metrics, filter by UsageType
	// or UsageTypeGroups.
	Metrics []*string `type:"list"`

	// The token to retrieve the next set of results. AWS provides the token when
	// the response from a previous call has more results than the maximum page
	// size.
	NextPageToken *string `type:"string"`

	// Sets the start and end dates for retrieving AWS costs. The start date is
	// inclusive, but the end date is exclusive. For example, if start is 2017-01-01
	// and end is 2017-05-01, then the cost and usage data is retrieved from 2017-01-01
	// up to and including 2017-04-30 but not including 2017-05-01.
	TimePeriod *DateInterval `type:"structure"`
}

// String returns the string representation
func (s GetCostAndUsageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCostAndUsageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCostAndUsageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCostAndUsageInput"}
	if s.TimePeriod != nil {
		if err := s.TimePeriod.Validate(); err != nil {
			invalidParams.AddNested("TimePeriod", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *GetCostAndUsageInput) SetFilter(v *Expression) *GetCostAndUsageInput {
	s.Filter = v
	return s
}

// SetGranularity sets the Granularity field's value.
func (s *GetCostAndUsageInput) SetGranularity(v string) *GetCostAndUsageInput {
	s.Granularity = &v
	return s
}

// SetGroupBy sets the GroupBy field's value.
func (s *GetCostAndUsageInput) SetGroupBy(v []*GroupDefinition) *GetCostAndUsageInput {
	s.GroupBy = v
	return s
}

// SetMetrics sets the Metrics field's value.
func (s *GetCostAndUsageInput) SetMetrics(v []*string) *GetCostAndUsageInput {
	s.Metrics = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetCostAndUsageInput) SetNextPageToken(v string) *GetCostAndUsageInput {
	s.NextPageToken = &v
	return s
}

// SetTimePeriod sets the TimePeriod field's value.
func (s *GetCostAndUsageInput) SetTimePeriod(v *DateInterval) *GetCostAndUsageInput {
	s.TimePeriod = v
	return s
}

type GetCostAndUsageOutput struct {
	_ struct{} `type:"structure"`

	// The groups specified by the the Filter or GroupBy parameters in the request.
	GroupDefinitions []*GroupDefinition `type:"list"`

	// The token for the next set of retrievable results. AWS provides the token
	// when the response from a previous call has more results than the maximum
	// page size.
	NextPageToken *string `type:"string"`

	// The time period covered by the results in the response.
	ResultsByTime []*ResultByTime `type:"list"`
}

// String returns the string representation
func (s GetCostAndUsageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCostAndUsageOutput) GoString() string {
	return s.String()
}

// SetGroupDefinitions sets the GroupDefinitions field's value.
func (s *GetCostAndUsageOutput) SetGroupDefinitions(v []*GroupDefinition) *GetCostAndUsageOutput {
	s.GroupDefinitions = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetCostAndUsageOutput) SetNextPageToken(v string) *GetCostAndUsageOutput {
	s.NextPageToken = &v
	return s
}

// SetResultsByTime sets the ResultsByTime field's value.
func (s *GetCostAndUsageOutput) SetResultsByTime(v []*ResultByTime) *GetCostAndUsageOutput {
	s.ResultsByTime = v
	return s
}

type GetDimensionValuesInput struct {
	_ struct{} `type:"structure"`

	// The context for the call to GetDimensionValues. This can be RESERVED_INSTANCE
	// or COST_AND_USAGE. The default value is COST_AND_USAGE. If the context is
	// set to RESERVED_INSTANCE, the resulting dimension values can be used in the
	// GetReservationUtilization action. If the context is set to COST_AND_USAGE,
	// , the resulting dimension values can be used in the GetCostAndUsage operation.
	//
	// If you set the context to CostAndUsage, you can use the following dimensions
	// for searching:
	//
	//    * AZ - The Availability Zone. An example is us-east-1a.
	//
	//    * InstanceType - The type of EC2 instance. An example is m4.xlarge.
	//
	//    * LinkedAccount - The description in the attribute map that includes the
	//    full name of the member account. The value field contains the AWS ID of
	//    the member account
	//
	//    * Operation - The action performed. Examples include RunInstance and CreateBucket.
	//
	//    * PurchaseType - The reservation type of the purchase to which this usage
	//    is related. Examples include: On Demand Instances and Standard Reserved
	//    Instances
	//
	//    * Service - The AWS service such as DynamoDB.
	//
	//    * UsageType -The type of usage. An example is DataTransfer-In-Bytes. The
	//    response for the GetDimensionValues action includes a unit attribute,
	//    examples of which include GB and Hrs.
	//
	//    * UsageTypeGroup - The grouping of common usage types. An example is EC2:
	//    CloudWatch – Alarms. The response for this action includes a unit attribute.
	//
	//    * RecordType - The different types of charges such as RI fees, usage costs,
	//    tax refunds, and credits
	//
	// If you set the context to ReservedInstance, you can use the following dimensions
	// for searching:
	//
	//    * AZ - The Availability Zone. An example is us-east-1a.
	//
	//    * InstanceType - The type of EC2 instance. An example is m4.xlarge.
	//
	//    * LinkedAccount - The description in the attribute map that includes the
	//    full name of the member account. The value field contains the AWS ID of
	//    the member account
	//
	//    * Platform - The operating system. Examples are Windows or Linux.
	//
	//    * Region - The AWS region.
	//
	//    * Scope - The scope of a reserved instance (RI). Values are regional or
	//    a single availability zone.
	//
	//    * Tenancy - The tenancy of a resource. Examples are shared or dedicated.
	Context *string `type:"string" enum:"Context"`

	// The name of the dimension. Different Dimensionsare available for different
	// Contexts. For more information, see Context.
	//
	// Dimension is a required field
	Dimension *string `type:"string" required:"true" enum:"Dimension"`

	// The token to retrieve the next set of results. AWS provides the token when
	// the response from a previous call has more results than the maximum page
	// size.
	NextPageToken *string `type:"string"`

	// The value that you want to search the filter values for.
	SearchString *string `type:"string"`

	// The start and end dates for retrieving the dimension values. The start date
	// is inclusive, but the end date is exclusive. For example, if start is 2017-01-01
	// and end is 2017-05-01, then the cost and usage data is retrieved from 2017-01-01
	// up to and including 2017-04-30 but not including 2017-05-01.
	//
	// TimePeriod is a required field
	TimePeriod *DateInterval `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetDimensionValuesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDimensionValuesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDimensionValuesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDimensionValuesInput"}
	if s.Dimension == nil {
		invalidParams.Add(request.NewErrParamRequired("Dimension"))
	}
	if s.TimePeriod == nil {
		invalidParams.Add(request.NewErrParamRequired("TimePeriod"))
	}
	if s.TimePeriod != nil {
		if err := s.TimePeriod.Validate(); err != nil {
			invalidParams.AddNested("TimePeriod", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContext sets the Context field's value.
func (s *GetDimensionValuesInput) SetContext(v string) *GetDimensionValuesInput {
	s.Context = &v
	return s
}

// SetDimension sets the Dimension field's value.
func (s *GetDimensionValuesInput) SetDimension(v string) *GetDimensionValuesInput {
	s.Dimension = &v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetDimensionValuesInput) SetNextPageToken(v string) *GetDimensionValuesInput {
	s.NextPageToken = &v
	return s
}

// SetSearchString sets the SearchString field's value.
func (s *GetDimensionValuesInput) SetSearchString(v string) *GetDimensionValuesInput {
	s.SearchString = &v
	return s
}

// SetTimePeriod sets the TimePeriod field's value.
func (s *GetDimensionValuesInput) SetTimePeriod(v *DateInterval) *GetDimensionValuesInput {
	s.TimePeriod = v
	return s
}

type GetDimensionValuesOutput struct {
	_ struct{} `type:"structure"`

	// The filters that you used to filter your request. Some dimensions are available
	// only for a specific context:
	//
	// If you set the context to CostAndUsage, you can use the following dimensions
	// for searching:
	//
	//    * AZ - The Availability Zone. An example is us-east-1a.
	//
	//    * InstanceType - The type of EC2 instance. An example is m4.xlarge.
	//
	//    * LinkedAccount - The description in the attribute map that includes the
	//    full name of the member account. The value field contains the AWS ID of
	//    the member account
	//
	//    * Operation - The action performed. Examples include RunInstance and CreateBucket.
	//
	//    * PurchaseType - The reservation type of the purchase to which this usage
	//    is related. Examples include: On Demand Instances and Standard Reserved
	//    Instances
	//
	//    * Service - The AWS service such as DynamoDB.
	//
	//    * UsageType -The type of usage. An example is DataTransfer-In-Bytes. The
	//    response for the GetDimensionValues action includes a unit attribute,
	//    examples of which include GB and Hrs.
	//
	//    * UsageTypeGroup - The grouping of common usage types. An example is EC2:
	//    CloudWatch – Alarms. The response for this action includes a unit attribute.
	//
	//    * RecordType - The different types of charges such as RI fees, usage costs,
	//    tax refunds, and credits
	//
	// If you set the context to ReservedInstance, you can use the following dimensions
	// for searching:
	//
	//    * AZ - The Availability Zone. An example is us-east-1a.
	//
	//    * InstanceType - The type of EC2 instance. An example is m4.xlarge.
	//
	//    * LinkedAccount - The description in the attribute map that includes the
	//    full name of the member account. The value field contains the AWS ID of
	//    the member account
	//
	//    * Platform - The operating system. Examples are Windows or Linux.
	//
	//    * Region - The AWS region.
	//
	//    * Scope - The scope of a reserved instance (RI). Values are regional or
	//    a single availability zone.
	//
	//    * Tenancy - The tenancy of a resource. Examples are shared or dedicated.
	//
	// DimensionValues is a required field
	DimensionValues []*DimensionValuesWithAttributes `type:"list" required:"true"`

	// The token for the next set of retrievable results. AWS provides the token
	// when the response from a previous call has more results than the maximum
	// page size.
	NextPageToken *string `type:"string"`

	// The number of results that AWS returned at one time.
	//
	// ReturnSize is a required field
	ReturnSize *int64 `type:"integer" required:"true"`

	// The total number of search results.
	//
	// TotalSize is a required field
	TotalSize *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s GetDimensionValuesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDimensionValuesOutput) GoString() string {
	return s.String()
}

// SetDimensionValues sets the DimensionValues field's value.
func (s *GetDimensionValuesOutput) SetDimensionValues(v []*DimensionValuesWithAttributes) *GetDimensionValuesOutput {
	s.DimensionValues = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetDimensionValuesOutput) SetNextPageToken(v string) *GetDimensionValuesOutput {
	s.NextPageToken = &v
	return s
}

// SetReturnSize sets the ReturnSize field's value.
func (s *GetDimensionValuesOutput) SetReturnSize(v int64) *GetDimensionValuesOutput {
	s.ReturnSize = &v
	return s
}

// SetTotalSize sets the TotalSize field's value.
func (s *GetDimensionValuesOutput) SetTotalSize(v int64) *GetDimensionValuesOutput {
	s.TotalSize = &v
	return s
}

type GetReservationUtilizationInput struct {
	_ struct{} `type:"structure"`

	// Filters utilization data by using different dimensions. GetReservationUtilization
	// uses the same Expression object as the other operations, but only AND is
	// supported among each dimension, and nesting is supported up to only one level
	// deep. If there are multiple values for a dimension, they are OR'd together.
	Filter *Expression `type:"structure"`

	// Sets the AWS cost granularity to MONTHLY or DAILY. If both GroupBy and granularity
	// are not set, GetReservationUtilization defaults to DAILY. If GroupBy is set,
	// Granularity can't be set, and the response object doesn't include MONTHLY
	// or DAILY granularity.
	Granularity *string `type:"string" enum:"Granularity"`

	// Groups only by SubscriptionId. Metadata is included.
	GroupBy []*GroupDefinition `type:"list"`

	// The token to retrieve the next set of results. AWS provides the token when
	// the response from a previous call has more results than the maximum page
	// size.
	NextPageToken *string `type:"string"`

	// Sets the start and end dates for retrieving reserve instance (RI) utilization.
	// The start date is inclusive, but the end date is exclusive. For example,
	// if start is 2017-01-01 and end is 2017-05-01, then the cost and usage data
	// is retrieved from 2017-01-01 up to and including 2017-04-30 but not including
	// 2017-05-01.
	//
	// TimePeriod is a required field
	TimePeriod *DateInterval `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetReservationUtilizationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetReservationUtilizationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetReservationUtilizationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetReservationUtilizationInput"}
	if s.TimePeriod == nil {
		invalidParams.Add(request.NewErrParamRequired("TimePeriod"))
	}
	if s.TimePeriod != nil {
		if err := s.TimePeriod.Validate(); err != nil {
			invalidParams.AddNested("TimePeriod", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *GetReservationUtilizationInput) SetFilter(v *Expression) *GetReservationUtilizationInput {
	s.Filter = v
	return s
}

// SetGranularity sets the Granularity field's value.
func (s *GetReservationUtilizationInput) SetGranularity(v string) *GetReservationUtilizationInput {
	s.Granularity = &v
	return s
}

// SetGroupBy sets the GroupBy field's value.
func (s *GetReservationUtilizationInput) SetGroupBy(v []*GroupDefinition) *GetReservationUtilizationInput {
	s.GroupBy = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetReservationUtilizationInput) SetNextPageToken(v string) *GetReservationUtilizationInput {
	s.NextPageToken = &v
	return s
}

// SetTimePeriod sets the TimePeriod field's value.
func (s *GetReservationUtilizationInput) SetTimePeriod(v *DateInterval) *GetReservationUtilizationInput {
	s.TimePeriod = v
	return s
}

type GetReservationUtilizationOutput struct {
	_ struct{} `type:"structure"`

	// The token for the next set of retrievable results. AWS provides the token
	// when the response from a previous call has more results than the maximum
	// page size.
	NextPageToken *string `type:"string"`

	// The total amount of time that you utilized your RIs.
	Total *ReservationAggregates `type:"structure"`

	// The amount of time that you utilized your RIs.
	//
	// UtilizationsByTime is a required field
	UtilizationsByTime []*UtilizationByTime `type:"list" required:"true"`
}

// String returns the string representation
func (s GetReservationUtilizationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetReservationUtilizationOutput) GoString() string {
	return s.String()
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetReservationUtilizationOutput) SetNextPageToken(v string) *GetReservationUtilizationOutput {
	s.NextPageToken = &v
	return s
}

// SetTotal sets the Total field's value.
func (s *GetReservationUtilizationOutput) SetTotal(v *ReservationAggregates) *GetReservationUtilizationOutput {
	s.Total = v
	return s
}

// SetUtilizationsByTime sets the UtilizationsByTime field's value.
func (s *GetReservationUtilizationOutput) SetUtilizationsByTime(v []*UtilizationByTime) *GetReservationUtilizationOutput {
	s.UtilizationsByTime = v
	return s
}

type GetTagsInput struct {
	_ struct{} `type:"structure"`

	// The token to retrieve the next set of results. AWS provides the token when
	// the response from a previous call has more results than the maximum page
	// size.
	NextPageToken *string `type:"string"`

	// The value that you want to search for.
	SearchString *string `type:"string"`

	// The key of the tag that you want to return values for.
	TagKey *string `type:"string"`

	// The start and end dates for retrieving the dimension values. The start date
	// is inclusive, but the end date is exclusive. For example, if start is 2017-01-01
	// and end is 2017-05-01, then the cost and usage data is retrieved from 2017-01-01
	// up to and including 2017-04-30 but not including 2017-05-01.
	//
	// TimePeriod is a required field
	TimePeriod *DateInterval `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTagsInput"}
	if s.TimePeriod == nil {
		invalidParams.Add(request.NewErrParamRequired("TimePeriod"))
	}
	if s.TimePeriod != nil {
		if err := s.TimePeriod.Validate(); err != nil {
			invalidParams.AddNested("TimePeriod", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetTagsInput) SetNextPageToken(v string) *GetTagsInput {
	s.NextPageToken = &v
	return s
}

// SetSearchString sets the SearchString field's value.
func (s *GetTagsInput) SetSearchString(v string) *GetTagsInput {
	s.SearchString = &v
	return s
}

// SetTagKey sets the TagKey field's value.
func (s *GetTagsInput) SetTagKey(v string) *GetTagsInput {
	s.TagKey = &v
	return s
}

// SetTimePeriod sets the TimePeriod field's value.
func (s *GetTagsInput) SetTimePeriod(v *DateInterval) *GetTagsInput {
	s.TimePeriod = v
	return s
}

type GetTagsOutput struct {
	_ struct{} `type:"structure"`

	// The token for the next set of retrievable results. AWS provides the token
	// when the response from a previous call has more results than the maximum
	// page size.
	NextPageToken *string `type:"string"`

	// The number of query results that AWS returns at a time.
	//
	// ReturnSize is a required field
	ReturnSize *int64 `type:"integer" required:"true"`

	// The tags that match your request.
	//
	// Tags is a required field
	Tags []*string `type:"list" required:"true"`

	// The total number of query results.
	//
	// TotalSize is a required field
	TotalSize *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s GetTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTagsOutput) GoString() string {
	return s.String()
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetTagsOutput) SetNextPageToken(v string) *GetTagsOutput {
	s.NextPageToken = &v
	return s
}

// SetReturnSize sets the ReturnSize field's value.
func (s *GetTagsOutput) SetReturnSize(v int64) *GetTagsOutput {
	s.ReturnSize = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetTagsOutput) SetTags(v []*string) *GetTagsOutput {
	s.Tags = v
	return s
}

// SetTotalSize sets the TotalSize field's value.
func (s *GetTagsOutput) SetTotalSize(v int64) *GetTagsOutput {
	s.TotalSize = &v
	return s
}

// One level of grouped data within the results.
type Group struct {
	_ struct{} `type:"structure"`

	// The keys included in this group.
	Keys []*string `type:"list"`

	// The metrics included in this group.
	Metrics map[string]*MetricValue `type:"map"`
}

// String returns the string representation
func (s Group) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Group) GoString() string {
	return s.String()
}

// SetKeys sets the Keys field's value.
func (s *Group) SetKeys(v []*string) *Group {
	s.Keys = v
	return s
}

// SetMetrics sets the Metrics field's value.
func (s *Group) SetMetrics(v map[string]*MetricValue) *Group {
	s.Metrics = v
	return s
}

// Represents a group when you specify a group by criteria, or in the response
// to a query with a specific grouping.
type GroupDefinition struct {
	_ struct{} `type:"structure"`

	// The string that represents a key for a specified group.
	Key *string `type:"string"`

	// The string that represents the type of group.
	Type *string `type:"string" enum:"GroupDefinitionType"`
}

// String returns the string representation
func (s GroupDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GroupDefinition) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *GroupDefinition) SetKey(v string) *GroupDefinition {
	s.Key = &v
	return s
}

// SetType sets the Type field's value.
func (s *GroupDefinition) SetType(v string) *GroupDefinition {
	s.Type = &v
	return s
}

// The aggregated value for a metric.
type MetricValue struct {
	_ struct{} `type:"structure"`

	// The actual number that represents the metric.
	Amount *string `type:"string"`

	// The unit that the metric is given in.
	Unit *string `type:"string"`
}

// String returns the string representation
func (s MetricValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MetricValue) GoString() string {
	return s.String()
}

// SetAmount sets the Amount field's value.
func (s *MetricValue) SetAmount(v string) *MetricValue {
	s.Amount = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *MetricValue) SetUnit(v string) *MetricValue {
	s.Unit = &v
	return s
}

// The aggregated numbers for your RI usage.
type ReservationAggregates struct {
	_ struct{} `type:"structure"`

	// How many RI hours you purchased.
	PurchasedHours *string `type:"string"`

	// The total number of RI hours that you used.
	TotalActualHours *string `type:"string"`

	// The number of RI hours that you didn't use.
	UnusedHours *string `type:"string"`

	// The percentage of RI time that you used.
	UtilizationPercentage *string `type:"string"`
}

// String returns the string representation
func (s ReservationAggregates) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReservationAggregates) GoString() string {
	return s.String()
}

// SetPurchasedHours sets the PurchasedHours field's value.
func (s *ReservationAggregates) SetPurchasedHours(v string) *ReservationAggregates {
	s.PurchasedHours = &v
	return s
}

// SetTotalActualHours sets the TotalActualHours field's value.
func (s *ReservationAggregates) SetTotalActualHours(v string) *ReservationAggregates {
	s.TotalActualHours = &v
	return s
}

// SetUnusedHours sets the UnusedHours field's value.
func (s *ReservationAggregates) SetUnusedHours(v string) *ReservationAggregates {
	s.UnusedHours = &v
	return s
}

// SetUtilizationPercentage sets the UtilizationPercentage field's value.
func (s *ReservationAggregates) SetUtilizationPercentage(v string) *ReservationAggregates {
	s.UtilizationPercentage = &v
	return s
}

// A group of RIs that share a set of attributes.
type ReservationUtilizationGroup struct {
	_ struct{} `type:"structure"`

	// The attributes for this group of RIs.
	Attributes map[string]*string `type:"map"`

	// The key for a specific RI attribute.
	Key *string `type:"string"`

	// How much you used this group of RIs.
	Utilization *ReservationAggregates `type:"structure"`

	// The value of a specific RI attribute.
	Value *string `type:"string"`
}

// String returns the string representation
func (s ReservationUtilizationGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReservationUtilizationGroup) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *ReservationUtilizationGroup) SetAttributes(v map[string]*string) *ReservationUtilizationGroup {
	s.Attributes = v
	return s
}

// SetKey sets the Key field's value.
func (s *ReservationUtilizationGroup) SetKey(v string) *ReservationUtilizationGroup {
	s.Key = &v
	return s
}

// SetUtilization sets the Utilization field's value.
func (s *ReservationUtilizationGroup) SetUtilization(v *ReservationAggregates) *ReservationUtilizationGroup {
	s.Utilization = v
	return s
}

// SetValue sets the Value field's value.
func (s *ReservationUtilizationGroup) SetValue(v string) *ReservationUtilizationGroup {
	s.Value = &v
	return s
}

// The result that is associated with a time period.
type ResultByTime struct {
	_ struct{} `type:"structure"`

	// Whether or not this result is estimated.
	Estimated *bool `type:"boolean"`

	// The groups that are included in this time period.
	Groups []*Group `type:"list"`

	// The time period covered by a result.
	TimePeriod *DateInterval `type:"structure"`

	// The total amount of cost or usage accrued during the time period.
	Total map[string]*MetricValue `type:"map"`
}

// String returns the string representation
func (s ResultByTime) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResultByTime) GoString() string {
	return s.String()
}

// SetEstimated sets the Estimated field's value.
func (s *ResultByTime) SetEstimated(v bool) *ResultByTime {
	s.Estimated = &v
	return s
}

// SetGroups sets the Groups field's value.
func (s *ResultByTime) SetGroups(v []*Group) *ResultByTime {
	s.Groups = v
	return s
}

// SetTimePeriod sets the TimePeriod field's value.
func (s *ResultByTime) SetTimePeriod(v *DateInterval) *ResultByTime {
	s.TimePeriod = v
	return s
}

// SetTotal sets the Total field's value.
func (s *ResultByTime) SetTotal(v map[string]*MetricValue) *ResultByTime {
	s.Total = v
	return s
}

// The values that are available for a tag.
type TagValues struct {
	_ struct{} `type:"structure"`

	// The key for a tag.
	Key *string `type:"string"`

	// The specific value of a tag.
	Values []*string `type:"list"`
}

// String returns the string representation
func (s TagValues) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagValues) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagValues) SetKey(v string) *TagValues {
	s.Key = &v
	return s
}

// SetValues sets the Values field's value.
func (s *TagValues) SetValues(v []*string) *TagValues {
	s.Values = v
	return s
}

// The amount of utilization, in hours.
type UtilizationByTime struct {
	_ struct{} `type:"structure"`

	// The groups that are included in this utilization result.
	Groups []*ReservationUtilizationGroup `type:"list"`

	// The period of time over which this utilization was used.
	TimePeriod *DateInterval `type:"structure"`

	// The total number of RI hours that were used.
	Total *ReservationAggregates `type:"structure"`
}

// String returns the string representation
func (s UtilizationByTime) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UtilizationByTime) GoString() string {
	return s.String()
}

// SetGroups sets the Groups field's value.
func (s *UtilizationByTime) SetGroups(v []*ReservationUtilizationGroup) *UtilizationByTime {
	s.Groups = v
	return s
}

// SetTimePeriod sets the TimePeriod field's value.
func (s *UtilizationByTime) SetTimePeriod(v *DateInterval) *UtilizationByTime {
	s.TimePeriod = v
	return s
}

// SetTotal sets the Total field's value.
func (s *UtilizationByTime) SetTotal(v *ReservationAggregates) *UtilizationByTime {
	s.Total = v
	return s
}

const (
	// ContextCostAndUsage is a Context enum value
	ContextCostAndUsage = "COST_AND_USAGE"

	// ContextReservations is a Context enum value
	ContextReservations = "RESERVATIONS"
)

const (
	// DimensionAz is a Dimension enum value
	DimensionAz = "AZ"

	// DimensionInstanceType is a Dimension enum value
	DimensionInstanceType = "INSTANCE_TYPE"

	// DimensionLinkedAccount is a Dimension enum value
	DimensionLinkedAccount = "LINKED_ACCOUNT"

	// DimensionOperation is a Dimension enum value
	DimensionOperation = "OPERATION"

	// DimensionPurchaseType is a Dimension enum value
	DimensionPurchaseType = "PURCHASE_TYPE"

	// DimensionRegion is a Dimension enum value
	DimensionRegion = "REGION"

	// DimensionService is a Dimension enum value
	DimensionService = "SERVICE"

	// DimensionUsageType is a Dimension enum value
	DimensionUsageType = "USAGE_TYPE"

	// DimensionUsageTypeGroup is a Dimension enum value
	DimensionUsageTypeGroup = "USAGE_TYPE_GROUP"

	// DimensionRecordType is a Dimension enum value
	DimensionRecordType = "RECORD_TYPE"

	// DimensionOperatingSystem is a Dimension enum value
	DimensionOperatingSystem = "OPERATING_SYSTEM"

	// DimensionTenancy is a Dimension enum value
	DimensionTenancy = "TENANCY"

	// DimensionScope is a Dimension enum value
	DimensionScope = "SCOPE"

	// DimensionPlatform is a Dimension enum value
	DimensionPlatform = "PLATFORM"

	// DimensionSubscriptionId is a Dimension enum value
	DimensionSubscriptionId = "SUBSCRIPTION_ID"
)

const (
	// GranularityDaily is a Granularity enum value
	GranularityDaily = "DAILY"

	// GranularityMonthly is a Granularity enum value
	GranularityMonthly = "MONTHLY"
)

const (
	// GroupDefinitionTypeDimension is a GroupDefinitionType enum value
	GroupDefinitionTypeDimension = "DIMENSION"

	// GroupDefinitionTypeTag is a GroupDefinitionType enum value
	GroupDefinitionTypeTag = "TAG"
)
