// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package arczonalshift

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
)

const opCancelZonalShift = "CancelZonalShift"

// CancelZonalShiftRequest generates a "aws/request.Request" representing the
// client's request for the CancelZonalShift operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelZonalShift for more information on using the CancelZonalShift
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CancelZonalShiftRequest method.
//	req, resp := client.CancelZonalShiftRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/CancelZonalShift
func (c *ARCZonalShift) CancelZonalShiftRequest(input *CancelZonalShiftInput) (req *request.Request, output *CancelZonalShiftOutput) {
	op := &request.Operation{
		Name:       opCancelZonalShift,
		HTTPMethod: "DELETE",
		HTTPPath:   "/zonalshifts/{zonalShiftId}",
	}

	if input == nil {
		input = &CancelZonalShiftInput{}
	}

	output = &CancelZonalShiftOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelZonalShift API operation for AWS ARC - Zonal Shift.
//
// Cancel a zonal shift in Amazon Route 53 Application Recovery Controller that
// you've started for a resource in your AWS account in an AWS Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS ARC - Zonal Shift's
// API operation CancelZonalShift for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There was an internal server error.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ResourceNotFoundException
//     The input requested a resource that was not found.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/CancelZonalShift
func (c *ARCZonalShift) CancelZonalShift(input *CancelZonalShiftInput) (*CancelZonalShiftOutput, error) {
	req, out := c.CancelZonalShiftRequest(input)
	return out, req.Send()
}

// CancelZonalShiftWithContext is the same as CancelZonalShift with the addition of
// the ability to pass a context and additional request options.
//
// See CancelZonalShift for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ARCZonalShift) CancelZonalShiftWithContext(ctx aws.Context, input *CancelZonalShiftInput, opts ...request.Option) (*CancelZonalShiftOutput, error) {
	req, out := c.CancelZonalShiftRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetManagedResource = "GetManagedResource"

// GetManagedResourceRequest generates a "aws/request.Request" representing the
// client's request for the GetManagedResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetManagedResource for more information on using the GetManagedResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetManagedResourceRequest method.
//	req, resp := client.GetManagedResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/GetManagedResource
func (c *ARCZonalShift) GetManagedResourceRequest(input *GetManagedResourceInput) (req *request.Request, output *GetManagedResourceOutput) {
	op := &request.Operation{
		Name:       opGetManagedResource,
		HTTPMethod: "GET",
		HTTPPath:   "/managedresources/{resourceIdentifier}",
	}

	if input == nil {
		input = &GetManagedResourceInput{}
	}

	output = &GetManagedResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetManagedResource API operation for AWS ARC - Zonal Shift.
//
// Get information about a resource that's been registered for zonal shifts
// with Amazon Route 53 Application Recovery Controller in this AWS Region.
// Resources that are registered for zonal shifts are managed resources in Route
// 53 ARC.
//
// At this time, you can only start a zonal shift for Network Load Balancers
// and Application Load Balancers with cross-zone load balancing turned off.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS ARC - Zonal Shift's
// API operation GetManagedResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There was an internal server error.
//
//   - ResourceNotFoundException
//     The input requested a resource that was not found.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/GetManagedResource
func (c *ARCZonalShift) GetManagedResource(input *GetManagedResourceInput) (*GetManagedResourceOutput, error) {
	req, out := c.GetManagedResourceRequest(input)
	return out, req.Send()
}

// GetManagedResourceWithContext is the same as GetManagedResource with the addition of
// the ability to pass a context and additional request options.
//
// See GetManagedResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ARCZonalShift) GetManagedResourceWithContext(ctx aws.Context, input *GetManagedResourceInput, opts ...request.Option) (*GetManagedResourceOutput, error) {
	req, out := c.GetManagedResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListManagedResources = "ListManagedResources"

// ListManagedResourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListManagedResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListManagedResources for more information on using the ListManagedResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListManagedResourcesRequest method.
//	req, resp := client.ListManagedResourcesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/ListManagedResources
func (c *ARCZonalShift) ListManagedResourcesRequest(input *ListManagedResourcesInput) (req *request.Request, output *ListManagedResourcesOutput) {
	op := &request.Operation{
		Name:       opListManagedResources,
		HTTPMethod: "GET",
		HTTPPath:   "/managedresources",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListManagedResourcesInput{}
	}

	output = &ListManagedResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListManagedResources API operation for AWS ARC - Zonal Shift.
//
// Lists all the resources in your AWS account in this AWS Region that are managed
// for zonal shifts in Amazon Route 53 Application Recovery Controller, and
// information about them. The information includes their Amazon Resource Names
// (ARNs), the Availability Zones the resources are deployed in, and the resource
// name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS ARC - Zonal Shift's
// API operation ListManagedResources for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There was an internal server error.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/ListManagedResources
func (c *ARCZonalShift) ListManagedResources(input *ListManagedResourcesInput) (*ListManagedResourcesOutput, error) {
	req, out := c.ListManagedResourcesRequest(input)
	return out, req.Send()
}

// ListManagedResourcesWithContext is the same as ListManagedResources with the addition of
// the ability to pass a context and additional request options.
//
// See ListManagedResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ARCZonalShift) ListManagedResourcesWithContext(ctx aws.Context, input *ListManagedResourcesInput, opts ...request.Option) (*ListManagedResourcesOutput, error) {
	req, out := c.ListManagedResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListManagedResourcesPages iterates over the pages of a ListManagedResources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListManagedResources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListManagedResources operation.
//	pageNum := 0
//	err := client.ListManagedResourcesPages(params,
//	    func(page *arczonalshift.ListManagedResourcesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ARCZonalShift) ListManagedResourcesPages(input *ListManagedResourcesInput, fn func(*ListManagedResourcesOutput, bool) bool) error {
	return c.ListManagedResourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListManagedResourcesPagesWithContext same as ListManagedResourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ARCZonalShift) ListManagedResourcesPagesWithContext(ctx aws.Context, input *ListManagedResourcesInput, fn func(*ListManagedResourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListManagedResourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListManagedResourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListManagedResourcesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListZonalShifts = "ListZonalShifts"

// ListZonalShiftsRequest generates a "aws/request.Request" representing the
// client's request for the ListZonalShifts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListZonalShifts for more information on using the ListZonalShifts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListZonalShiftsRequest method.
//	req, resp := client.ListZonalShiftsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/ListZonalShifts
func (c *ARCZonalShift) ListZonalShiftsRequest(input *ListZonalShiftsInput) (req *request.Request, output *ListZonalShiftsOutput) {
	op := &request.Operation{
		Name:       opListZonalShifts,
		HTTPMethod: "GET",
		HTTPPath:   "/zonalshifts",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListZonalShiftsInput{}
	}

	output = &ListZonalShiftsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListZonalShifts API operation for AWS ARC - Zonal Shift.
//
// Lists all the active zonal shifts in Amazon Route 53 Application Recovery
// Controller in your AWS account in this AWS Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS ARC - Zonal Shift's
// API operation ListZonalShifts for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There was an internal server error.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/ListZonalShifts
func (c *ARCZonalShift) ListZonalShifts(input *ListZonalShiftsInput) (*ListZonalShiftsOutput, error) {
	req, out := c.ListZonalShiftsRequest(input)
	return out, req.Send()
}

// ListZonalShiftsWithContext is the same as ListZonalShifts with the addition of
// the ability to pass a context and additional request options.
//
// See ListZonalShifts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ARCZonalShift) ListZonalShiftsWithContext(ctx aws.Context, input *ListZonalShiftsInput, opts ...request.Option) (*ListZonalShiftsOutput, error) {
	req, out := c.ListZonalShiftsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListZonalShiftsPages iterates over the pages of a ListZonalShifts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListZonalShifts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListZonalShifts operation.
//	pageNum := 0
//	err := client.ListZonalShiftsPages(params,
//	    func(page *arczonalshift.ListZonalShiftsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ARCZonalShift) ListZonalShiftsPages(input *ListZonalShiftsInput, fn func(*ListZonalShiftsOutput, bool) bool) error {
	return c.ListZonalShiftsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListZonalShiftsPagesWithContext same as ListZonalShiftsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ARCZonalShift) ListZonalShiftsPagesWithContext(ctx aws.Context, input *ListZonalShiftsInput, fn func(*ListZonalShiftsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListZonalShiftsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListZonalShiftsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListZonalShiftsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opStartZonalShift = "StartZonalShift"

// StartZonalShiftRequest generates a "aws/request.Request" representing the
// client's request for the StartZonalShift operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartZonalShift for more information on using the StartZonalShift
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartZonalShiftRequest method.
//	req, resp := client.StartZonalShiftRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/StartZonalShift
func (c *ARCZonalShift) StartZonalShiftRequest(input *StartZonalShiftInput) (req *request.Request, output *StartZonalShiftOutput) {
	op := &request.Operation{
		Name:       opStartZonalShift,
		HTTPMethod: "POST",
		HTTPPath:   "/zonalshifts",
	}

	if input == nil {
		input = &StartZonalShiftInput{}
	}

	output = &StartZonalShiftOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartZonalShift API operation for AWS ARC - Zonal Shift.
//
// You start a zonal shift to temporarily move load balancer traffic away from
// an Availability Zone in a AWS Region, to help your application recover immediately,
// for example, from a developer's bad code deployment or from an AWS infrastructure
// failure in a single Availability Zone. You can start a zonal shift in Route
// 53 ARC only for managed resources in your account in an AWS Region. Resources
// are automatically registered with Route 53 ARC by AWS services.
//
// At this time, you can only start a zonal shift for Network Load Balancers
// and Application Load Balancers with cross-zone load balancing turned off.
//
// When you start a zonal shift, traffic for the resource is no longer routed
// to the Availability Zone. The zonal shift is created immediately in Route
// 53 ARC. However, it can take a short time, typically up to a few minutes,
// for existing, in-progress connections in the Availability Zone to complete.
//
// For more information, see Zonal shift (https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.html)
// in the Amazon Route 53 Application Recovery Controller Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS ARC - Zonal Shift's
// API operation StartZonalShift for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There was an internal server error.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ResourceNotFoundException
//     The input requested a resource that was not found.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/StartZonalShift
func (c *ARCZonalShift) StartZonalShift(input *StartZonalShiftInput) (*StartZonalShiftOutput, error) {
	req, out := c.StartZonalShiftRequest(input)
	return out, req.Send()
}

// StartZonalShiftWithContext is the same as StartZonalShift with the addition of
// the ability to pass a context and additional request options.
//
// See StartZonalShift for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ARCZonalShift) StartZonalShiftWithContext(ctx aws.Context, input *StartZonalShiftInput, opts ...request.Option) (*StartZonalShiftOutput, error) {
	req, out := c.StartZonalShiftRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateZonalShift = "UpdateZonalShift"

// UpdateZonalShiftRequest generates a "aws/request.Request" representing the
// client's request for the UpdateZonalShift operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateZonalShift for more information on using the UpdateZonalShift
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateZonalShiftRequest method.
//	req, resp := client.UpdateZonalShiftRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/UpdateZonalShift
func (c *ARCZonalShift) UpdateZonalShiftRequest(input *UpdateZonalShiftInput) (req *request.Request, output *UpdateZonalShiftOutput) {
	op := &request.Operation{
		Name:       opUpdateZonalShift,
		HTTPMethod: "PATCH",
		HTTPPath:   "/zonalshifts/{zonalShiftId}",
	}

	if input == nil {
		input = &UpdateZonalShiftInput{}
	}

	output = &UpdateZonalShiftOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateZonalShift API operation for AWS ARC - Zonal Shift.
//
// Update an active zonal shift in Amazon Route 53 Application Recovery Controller
// in your AWS account. You can update a zonal shift to set a new expiration,
// or edit or replace the comment for the zonal shift.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS ARC - Zonal Shift's
// API operation UpdateZonalShift for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There was an internal server error.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ResourceNotFoundException
//     The input requested a resource that was not found.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/UpdateZonalShift
func (c *ARCZonalShift) UpdateZonalShift(input *UpdateZonalShiftInput) (*UpdateZonalShiftOutput, error) {
	req, out := c.UpdateZonalShiftRequest(input)
	return out, req.Send()
}

// UpdateZonalShiftWithContext is the same as UpdateZonalShift with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateZonalShift for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ARCZonalShift) UpdateZonalShiftWithContext(ctx aws.Context, input *UpdateZonalShiftInput, opts ...request.Option) (*UpdateZonalShiftOutput, error) {
	req, out := c.UpdateZonalShiftRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You do not have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CancelZonalShiftInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The internally-generated identifier of a zonal shift.
	//
	// ZonalShiftId is a required field
	ZonalShiftId *string `location:"uri" locationName:"zonalShiftId" min:"6" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelZonalShiftInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelZonalShiftInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelZonalShiftInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelZonalShiftInput"}
	if s.ZonalShiftId == nil {
		invalidParams.Add(request.NewErrParamRequired("ZonalShiftId"))
	}
	if s.ZonalShiftId != nil && len(*s.ZonalShiftId) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("ZonalShiftId", 6))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetZonalShiftId sets the ZonalShiftId field's value.
func (s *CancelZonalShiftInput) SetZonalShiftId(v string) *CancelZonalShiftInput {
	s.ZonalShiftId = &v
	return s
}

type CancelZonalShiftOutput struct {
	_ struct{} `type:"structure"`

	// The Availability Zone that traffic is moved away from for a resource when
	// you start a zonal shift. Until the zonal shift expires or you cancel it,
	// traffic for the resource is instead moved to other Availability Zones in
	// the AWS Region.
	//
	// AwayFrom is a required field
	AwayFrom *string `locationName:"awayFrom" type:"string" required:"true"`

	// A comment that you enter about the zonal shift. Only the latest comment is
	// retained; no comment history is maintained. A new comment overwrites any
	// existing comment string.
	//
	// Comment is a required field
	Comment *string `locationName:"comment" type:"string" required:"true"`

	// The expiry time (expiration time) for the zonal shift. A zonal shift is temporary
	// and must be set to expire when you start the zonal shift. You can initially
	// set a zonal shift to expire in a maximum of three days (72 hours). However,
	// you can update a zonal shift to set a new expiration at any time.
	//
	// When you start a zonal shift, you specify how long you want it to be active,
	// which Route 53 ARC converts to an expiry time (expiration time). You can
	// cancel a zonal shift, for example, if you're ready to restore traffic to
	// the Availability Zone. Or you can update the zonal shift to specify another
	// length of time to expire in.
	//
	// ExpiryTime is a required field
	ExpiryTime *time.Time `locationName:"expiryTime" type:"timestamp" required:"true"`

	// The identifier for the resource to include in a zonal shift. The identifier
	// is the Amazon Resource Name (ARN) for the resource.
	//
	// At this time, you can only start a zonal shift for Network Load Balancers
	// and Application Load Balancers with cross-zone load balancing turned off.
	//
	// ResourceIdentifier is a required field
	ResourceIdentifier *string `locationName:"resourceIdentifier" min:"8" type:"string" required:"true"`

	// The time (UTC) when the zonal shift is started.
	//
	// StartTime is a required field
	StartTime *time.Time `locationName:"startTime" type:"timestamp" required:"true"`

	// A status for a zonal shift.
	//
	// The Status for a zonal shift can have one of the following values:
	//
	//    * ACTIVE: The zonal shift is started and active.
	//
	//    * EXPIRED: The zonal shift has expired (the expiry time was exceeded).
	//
	//    * CANCELED: The zonal shift was canceled.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ZonalShiftStatus"`

	// The identifier of a zonal shift.
	//
	// ZonalShiftId is a required field
	ZonalShiftId *string `locationName:"zonalShiftId" min:"6" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelZonalShiftOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelZonalShiftOutput) GoString() string {
	return s.String()
}

// SetAwayFrom sets the AwayFrom field's value.
func (s *CancelZonalShiftOutput) SetAwayFrom(v string) *CancelZonalShiftOutput {
	s.AwayFrom = &v
	return s
}

// SetComment sets the Comment field's value.
func (s *CancelZonalShiftOutput) SetComment(v string) *CancelZonalShiftOutput {
	s.Comment = &v
	return s
}

// SetExpiryTime sets the ExpiryTime field's value.
func (s *CancelZonalShiftOutput) SetExpiryTime(v time.Time) *CancelZonalShiftOutput {
	s.ExpiryTime = &v
	return s
}

// SetResourceIdentifier sets the ResourceIdentifier field's value.
func (s *CancelZonalShiftOutput) SetResourceIdentifier(v string) *CancelZonalShiftOutput {
	s.ResourceIdentifier = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *CancelZonalShiftOutput) SetStartTime(v time.Time) *CancelZonalShiftOutput {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CancelZonalShiftOutput) SetStatus(v string) *CancelZonalShiftOutput {
	s.Status = &v
	return s
}

// SetZonalShiftId sets the ZonalShiftId field's value.
func (s *CancelZonalShiftOutput) SetZonalShiftId(v string) *CancelZonalShiftOutput {
	s.ZonalShiftId = &v
	return s
}

// The request could not be processed because of conflict in the current state
// of the resource.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The reason for the conflict exception.
	//
	// Reason is a required field
	Reason *string `locationName:"reason" type:"string" required:"true" enum:"ConflictExceptionReason"`

	// The zonal shift ID associated with the conflict exception.
	ZonalShiftId *string `locationName:"zonalShiftId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type GetManagedResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier for the resource to include in a zonal shift. The identifier
	// is the Amazon Resource Name (ARN) for the resource.
	//
	// At this time, you can only start a zonal shift for Network Load Balancers
	// and Application Load Balancers with cross-zone load balancing turned off.
	//
	// ResourceIdentifier is a required field
	ResourceIdentifier *string `location:"uri" locationName:"resourceIdentifier" min:"8" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetManagedResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetManagedResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetManagedResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetManagedResourceInput"}
	if s.ResourceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceIdentifier"))
	}
	if s.ResourceIdentifier != nil && len(*s.ResourceIdentifier) < 8 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceIdentifier", 8))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceIdentifier sets the ResourceIdentifier field's value.
func (s *GetManagedResourceInput) SetResourceIdentifier(v string) *GetManagedResourceInput {
	s.ResourceIdentifier = &v
	return s
}

type GetManagedResourceOutput struct {
	_ struct{} `type:"structure"`

	// A collection of key-value pairs that indicate whether resources are active
	// in Availability Zones or not. The key name is the Availability Zone where
	// the resource is deployed. The value is 1 or 0.
	//
	// AppliedWeights is a required field
	AppliedWeights map[string]*float64 `locationName:"appliedWeights" type:"map" required:"true"`

	// The Amazon Resource Name (ARN) for the resource.
	Arn *string `locationName:"arn" min:"8" type:"string"`

	// The name of the resource.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The zonal shifts that are currently active for a resource.
	//
	// ZonalShifts is a required field
	ZonalShifts []*ZonalShiftInResource `locationName:"zonalShifts" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetManagedResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetManagedResourceOutput) GoString() string {
	return s.String()
}

// SetAppliedWeights sets the AppliedWeights field's value.
func (s *GetManagedResourceOutput) SetAppliedWeights(v map[string]*float64) *GetManagedResourceOutput {
	s.AppliedWeights = v
	return s
}

// SetArn sets the Arn field's value.
func (s *GetManagedResourceOutput) SetArn(v string) *GetManagedResourceOutput {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetManagedResourceOutput) SetName(v string) *GetManagedResourceOutput {
	s.Name = &v
	return s
}

// SetZonalShifts sets the ZonalShifts field's value.
func (s *GetManagedResourceOutput) SetZonalShifts(v []*ZonalShiftInResource) *GetManagedResourceOutput {
	s.ZonalShifts = v
	return s
}

// There was an internal server error.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListManagedResourcesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The number of objects that you want to return with this call.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// Specifies that you want to receive the next page of results. Valid only if
	// you received a NextToken response in the previous request. If you did, it
	// indicates that more output is available. Set this parameter to the value
	// provided by the previous call's NextToken response to request the next page
	// of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListManagedResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListManagedResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListManagedResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListManagedResourcesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListManagedResourcesInput) SetMaxResults(v int64) *ListManagedResourcesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListManagedResourcesInput) SetNextToken(v string) *ListManagedResourcesInput {
	s.NextToken = &v
	return s
}

type ListManagedResourcesOutput struct {
	_ struct{} `type:"structure"`

	// The items in the response list.
	//
	// Items is a required field
	Items []*ManagedResourceSummary `locationName:"items" type:"list" required:"true"`

	// Specifies that you want to receive the next page of results. Valid only if
	// you received a NextToken response in the previous request. If you did, it
	// indicates that more output is available. Set this parameter to the value
	// provided by the previous call's NextToken response to request the next page
	// of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListManagedResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListManagedResourcesOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListManagedResourcesOutput) SetItems(v []*ManagedResourceSummary) *ListManagedResourcesOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListManagedResourcesOutput) SetNextToken(v string) *ListManagedResourcesOutput {
	s.NextToken = &v
	return s
}

type ListZonalShiftsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The number of objects that you want to return with this call.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// Specifies that you want to receive the next page of results. Valid only if
	// you received a NextToken response in the previous request. If you did, it
	// indicates that more output is available. Set this parameter to the value
	// provided by the previous call's NextToken response to request the next page
	// of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// A status for a zonal shift.
	//
	// The Status for a zonal shift can have one of the following values:
	//
	//    * ACTIVE: The zonal shift is started and active.
	//
	//    * EXPIRED: The zonal shift has expired (the expiry time was exceeded).
	//
	//    * CANCELED: The zonal shift was canceled.
	Status *string `location:"querystring" locationName:"status" type:"string" enum:"ZonalShiftStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListZonalShiftsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListZonalShiftsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListZonalShiftsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListZonalShiftsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListZonalShiftsInput) SetMaxResults(v int64) *ListZonalShiftsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListZonalShiftsInput) SetNextToken(v string) *ListZonalShiftsInput {
	s.NextToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListZonalShiftsInput) SetStatus(v string) *ListZonalShiftsInput {
	s.Status = &v
	return s
}

type ListZonalShiftsOutput struct {
	_ struct{} `type:"structure"`

	// The items in the response list.
	Items []*ZonalShiftSummary `locationName:"items" type:"list"`

	// Specifies that you want to receive the next page of results. Valid only if
	// you received a NextToken response in the previous request. If you did, it
	// indicates that more output is available. Set this parameter to the value
	// provided by the previous call's NextToken response to request the next page
	// of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListZonalShiftsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListZonalShiftsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListZonalShiftsOutput) SetItems(v []*ZonalShiftSummary) *ListZonalShiftsOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListZonalShiftsOutput) SetNextToken(v string) *ListZonalShiftsOutput {
	s.NextToken = &v
	return s
}

// A complex structure for a managed resource in an account.
//
// A managed resource is a Network Load Balancer or Application Load Balancer
// that has been registered with Route 53 ARC by Elastic Load Balancing. You
// can start a zonal shift in Route 53 ARC for a managed resource to temporarily
// move traffic for the resource away from an Availability Zone in an AWS Region.
//
// At this time, you can only start a zonal shift for Network Load Balancers
// and Application Load Balancers with cross-zone load balancing turned off.
type ManagedResourceSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the managed resource.
	Arn *string `locationName:"arn" min:"8" type:"string"`

	// The Availability Zones that a resource is deployed in.
	//
	// AvailabilityZones is a required field
	AvailabilityZones []*string `locationName:"availabilityZones" type:"list" required:"true"`

	// The name of the managed resource.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ManagedResourceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ManagedResourceSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ManagedResourceSummary) SetArn(v string) *ManagedResourceSummary {
	s.Arn = &v
	return s
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *ManagedResourceSummary) SetAvailabilityZones(v []*string) *ManagedResourceSummary {
	s.AvailabilityZones = v
	return s
}

// SetName sets the Name field's value.
func (s *ManagedResourceSummary) SetName(v string) *ManagedResourceSummary {
	s.Name = &v
	return s
}

// The input requested a resource that was not found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

type StartZonalShiftInput struct {
	_ struct{} `type:"structure"`

	// The Availability Zone that traffic is moved away from for a resource when
	// you start a zonal shift. Until the zonal shift expires or you cancel it,
	// traffic for the resource is instead moved to other Availability Zones in
	// the AWS Region.
	//
	// AwayFrom is a required field
	AwayFrom *string `locationName:"awayFrom" type:"string" required:"true"`

	// A comment that you enter about the zonal shift. Only the latest comment is
	// retained; no comment history is maintained. A new comment overwrites any
	// existing comment string.
	//
	// Comment is a required field
	Comment *string `locationName:"comment" type:"string" required:"true"`

	// The length of time that you want a zonal shift to be active, which Route
	// 53 ARC converts to an expiry time (expiration time). Zonal shifts are temporary.
	// You can set a zonal shift to be active initially for up to three days (72
	// hours).
	//
	// If you want to still keep traffic away from an Availability Zone, you can
	// update the zonal shift and set a new expiration. You can also cancel a zonal
	// shift, before it expires, for example, if you're ready to restore traffic
	// to the Availability Zone.
	//
	// To set a length of time for a zonal shift to be active, specify a whole number,
	// and then one of the following, with no space:
	//
	//    <ul> <li> <p> <b>A lowercase letter m:</b> To specify that the value is
	//    in minutes.</p> </li> <li> <p> <b>A lowercase letter h:</b> To specify
	//    that the value is in hours.</p> </li> </ul> <p>For example: <code>20h</code>
	//    means the zonal shift expires in 20 hours. <code>120m</code> means the
	//    zonal shift expires in 120 minutes (2 hours).</p>
	//
	// ExpiresIn is a required field
	ExpiresIn *string `locationName:"expiresIn" min:"2" type:"string" required:"true"`

	// The identifier for the resource to include in a zonal shift. The identifier
	// is the Amazon Resource Name (ARN) for the resource.
	//
	// At this time, you can only start a zonal shift for Network Load Balancers
	// and Application Load Balancers with cross-zone load balancing turned off.
	//
	// ResourceIdentifier is a required field
	ResourceIdentifier *string `locationName:"resourceIdentifier" min:"8" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartZonalShiftInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartZonalShiftInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartZonalShiftInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartZonalShiftInput"}
	if s.AwayFrom == nil {
		invalidParams.Add(request.NewErrParamRequired("AwayFrom"))
	}
	if s.Comment == nil {
		invalidParams.Add(request.NewErrParamRequired("Comment"))
	}
	if s.ExpiresIn == nil {
		invalidParams.Add(request.NewErrParamRequired("ExpiresIn"))
	}
	if s.ExpiresIn != nil && len(*s.ExpiresIn) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ExpiresIn", 2))
	}
	if s.ResourceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceIdentifier"))
	}
	if s.ResourceIdentifier != nil && len(*s.ResourceIdentifier) < 8 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceIdentifier", 8))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwayFrom sets the AwayFrom field's value.
func (s *StartZonalShiftInput) SetAwayFrom(v string) *StartZonalShiftInput {
	s.AwayFrom = &v
	return s
}

// SetComment sets the Comment field's value.
func (s *StartZonalShiftInput) SetComment(v string) *StartZonalShiftInput {
	s.Comment = &v
	return s
}

// SetExpiresIn sets the ExpiresIn field's value.
func (s *StartZonalShiftInput) SetExpiresIn(v string) *StartZonalShiftInput {
	s.ExpiresIn = &v
	return s
}

// SetResourceIdentifier sets the ResourceIdentifier field's value.
func (s *StartZonalShiftInput) SetResourceIdentifier(v string) *StartZonalShiftInput {
	s.ResourceIdentifier = &v
	return s
}

type StartZonalShiftOutput struct {
	_ struct{} `type:"structure"`

	// The Availability Zone that traffic is moved away from for a resource when
	// you start a zonal shift. Until the zonal shift expires or you cancel it,
	// traffic for the resource is instead moved to other Availability Zones in
	// the AWS Region.
	//
	// AwayFrom is a required field
	AwayFrom *string `locationName:"awayFrom" type:"string" required:"true"`

	// A comment that you enter about the zonal shift. Only the latest comment is
	// retained; no comment history is maintained. A new comment overwrites any
	// existing comment string.
	//
	// Comment is a required field
	Comment *string `locationName:"comment" type:"string" required:"true"`

	// The expiry time (expiration time) for the zonal shift. A zonal shift is temporary
	// and must be set to expire when you start the zonal shift. You can initially
	// set a zonal shift to expire in a maximum of three days (72 hours). However,
	// you can update a zonal shift to set a new expiration at any time.
	//
	// When you start a zonal shift, you specify how long you want it to be active,
	// which Route 53 ARC converts to an expiry time (expiration time). You can
	// cancel a zonal shift, for example, if you're ready to restore traffic to
	// the Availability Zone. Or you can update the zonal shift to specify another
	// length of time to expire in.
	//
	// ExpiryTime is a required field
	ExpiryTime *time.Time `locationName:"expiryTime" type:"timestamp" required:"true"`

	// The identifier for the resource to include in a zonal shift. The identifier
	// is the Amazon Resource Name (ARN) for the resource.
	//
	// At this time, you can only start a zonal shift for Network Load Balancers
	// and Application Load Balancers with cross-zone load balancing turned off.
	//
	// ResourceIdentifier is a required field
	ResourceIdentifier *string `locationName:"resourceIdentifier" min:"8" type:"string" required:"true"`

	// The time (UTC) when the zonal shift is started.
	//
	// StartTime is a required field
	StartTime *time.Time `locationName:"startTime" type:"timestamp" required:"true"`

	// A status for a zonal shift.
	//
	// The Status for a zonal shift can have one of the following values:
	//
	//    * ACTIVE: The zonal shift is started and active.
	//
	//    * EXPIRED: The zonal shift has expired (the expiry time was exceeded).
	//
	//    * CANCELED: The zonal shift was canceled.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ZonalShiftStatus"`

	// The identifier of a zonal shift.
	//
	// ZonalShiftId is a required field
	ZonalShiftId *string `locationName:"zonalShiftId" min:"6" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartZonalShiftOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartZonalShiftOutput) GoString() string {
	return s.String()
}

// SetAwayFrom sets the AwayFrom field's value.
func (s *StartZonalShiftOutput) SetAwayFrom(v string) *StartZonalShiftOutput {
	s.AwayFrom = &v
	return s
}

// SetComment sets the Comment field's value.
func (s *StartZonalShiftOutput) SetComment(v string) *StartZonalShiftOutput {
	s.Comment = &v
	return s
}

// SetExpiryTime sets the ExpiryTime field's value.
func (s *StartZonalShiftOutput) SetExpiryTime(v time.Time) *StartZonalShiftOutput {
	s.ExpiryTime = &v
	return s
}

// SetResourceIdentifier sets the ResourceIdentifier field's value.
func (s *StartZonalShiftOutput) SetResourceIdentifier(v string) *StartZonalShiftOutput {
	s.ResourceIdentifier = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *StartZonalShiftOutput) SetStartTime(v time.Time) *StartZonalShiftOutput {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *StartZonalShiftOutput) SetStatus(v string) *StartZonalShiftOutput {
	s.Status = &v
	return s
}

// SetZonalShiftId sets the ZonalShiftId field's value.
func (s *StartZonalShiftOutput) SetZonalShiftId(v string) *StartZonalShiftOutput {
	s.ZonalShiftId = &v
	return s
}

// The request was denied due to request throttling.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UpdateZonalShiftInput struct {
	_ struct{} `type:"structure"`

	// A comment that you enter about the zonal shift. Only the latest comment is
	// retained; no comment history is maintained. A new comment overwrites any
	// existing comment string.
	Comment *string `locationName:"comment" type:"string"`

	// The length of time that you want a zonal shift to be active, which Route
	// 53 ARC converts to an expiry time (expiration time). Zonal shifts are temporary.
	// You can set a zonal shift to be active initially for up to three days (72
	// hours).
	//
	// If you want to still keep traffic away from an Availability Zone, you can
	// update the zonal shift and set a new expiration. You can also cancel a zonal
	// shift, before it expires, for example, if you're ready to restore traffic
	// to the Availability Zone.
	//
	// To set a length of time for a zonal shift to be active, specify a whole number,
	// and then one of the following, with no space:
	//
	//    * A lowercase letter m: To specify that the value is in minutes.
	//
	//    * A lowercase letter h: To specify that the value is in hours.
	//
	// For example: 20h means the zonal shift expires in 20 hours. 120m means the
	// zonal shift expires in 120 minutes (2 hours).
	ExpiresIn *string `locationName:"expiresIn" min:"2" type:"string"`

	// The identifier of a zonal shift.
	//
	// ZonalShiftId is a required field
	ZonalShiftId *string `location:"uri" locationName:"zonalShiftId" min:"6" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateZonalShiftInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateZonalShiftInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateZonalShiftInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateZonalShiftInput"}
	if s.ExpiresIn != nil && len(*s.ExpiresIn) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ExpiresIn", 2))
	}
	if s.ZonalShiftId == nil {
		invalidParams.Add(request.NewErrParamRequired("ZonalShiftId"))
	}
	if s.ZonalShiftId != nil && len(*s.ZonalShiftId) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("ZonalShiftId", 6))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComment sets the Comment field's value.
func (s *UpdateZonalShiftInput) SetComment(v string) *UpdateZonalShiftInput {
	s.Comment = &v
	return s
}

// SetExpiresIn sets the ExpiresIn field's value.
func (s *UpdateZonalShiftInput) SetExpiresIn(v string) *UpdateZonalShiftInput {
	s.ExpiresIn = &v
	return s
}

// SetZonalShiftId sets the ZonalShiftId field's value.
func (s *UpdateZonalShiftInput) SetZonalShiftId(v string) *UpdateZonalShiftInput {
	s.ZonalShiftId = &v
	return s
}

type UpdateZonalShiftOutput struct {
	_ struct{} `type:"structure"`

	// The Availability Zone that traffic is moved away from for a resource when
	// you start a zonal shift. Until the zonal shift expires or you cancel it,
	// traffic for the resource is instead moved to other Availability Zones in
	// the AWS Region.
	//
	// AwayFrom is a required field
	AwayFrom *string `locationName:"awayFrom" type:"string" required:"true"`

	// A comment that you enter about the zonal shift. Only the latest comment is
	// retained; no comment history is maintained. A new comment overwrites any
	// existing comment string.
	//
	// Comment is a required field
	Comment *string `locationName:"comment" type:"string" required:"true"`

	// The expiry time (expiration time) for the zonal shift. A zonal shift is temporary
	// and must be set to expire when you start the zonal shift. You can initially
	// set a zonal shift to expire in a maximum of three days (72 hours). However,
	// you can update a zonal shift to set a new expiration at any time.
	//
	// When you start a zonal shift, you specify how long you want it to be active,
	// which Route 53 ARC converts to an expiry time (expiration time). You can
	// cancel a zonal shift, for example, if you're ready to restore traffic to
	// the Availability Zone. Or you can update the zonal shift to specify another
	// length of time to expire in.
	//
	// ExpiryTime is a required field
	ExpiryTime *time.Time `locationName:"expiryTime" type:"timestamp" required:"true"`

	// The identifier for the resource to include in a zonal shift. The identifier
	// is the Amazon Resource Name (ARN) for the resource.
	//
	// At this time, you can only start a zonal shift for Network Load Balancers
	// and Application Load Balancers with cross-zone load balancing turned off.
	//
	// ResourceIdentifier is a required field
	ResourceIdentifier *string `locationName:"resourceIdentifier" min:"8" type:"string" required:"true"`

	// The time (UTC) when the zonal shift is started.
	//
	// StartTime is a required field
	StartTime *time.Time `locationName:"startTime" type:"timestamp" required:"true"`

	// A status for a zonal shift.
	//
	// The Status for a zonal shift can have one of the following values:
	//
	//    * ACTIVE: The zonal shift is started and active.
	//
	//    * EXPIRED: The zonal shift has expired (the expiry time was exceeded).
	//
	//    * CANCELED: The zonal shift was canceled.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ZonalShiftStatus"`

	// The identifier of a zonal shift.
	//
	// ZonalShiftId is a required field
	ZonalShiftId *string `locationName:"zonalShiftId" min:"6" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateZonalShiftOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateZonalShiftOutput) GoString() string {
	return s.String()
}

// SetAwayFrom sets the AwayFrom field's value.
func (s *UpdateZonalShiftOutput) SetAwayFrom(v string) *UpdateZonalShiftOutput {
	s.AwayFrom = &v
	return s
}

// SetComment sets the Comment field's value.
func (s *UpdateZonalShiftOutput) SetComment(v string) *UpdateZonalShiftOutput {
	s.Comment = &v
	return s
}

// SetExpiryTime sets the ExpiryTime field's value.
func (s *UpdateZonalShiftOutput) SetExpiryTime(v time.Time) *UpdateZonalShiftOutput {
	s.ExpiryTime = &v
	return s
}

// SetResourceIdentifier sets the ResourceIdentifier field's value.
func (s *UpdateZonalShiftOutput) SetResourceIdentifier(v string) *UpdateZonalShiftOutput {
	s.ResourceIdentifier = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *UpdateZonalShiftOutput) SetStartTime(v time.Time) *UpdateZonalShiftOutput {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateZonalShiftOutput) SetStatus(v string) *UpdateZonalShiftOutput {
	s.Status = &v
	return s
}

// SetZonalShiftId sets the ZonalShiftId field's value.
func (s *UpdateZonalShiftOutput) SetZonalShiftId(v string) *UpdateZonalShiftOutput {
	s.ZonalShiftId = &v
	return s
}

// The input fails to satisfy the constraints specified by an AWS service.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The reason for the validation exception.
	//
	// Reason is a required field
	Reason *string `locationName:"reason" type:"string" required:"true" enum:"ValidationExceptionReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A complex structure that lists the zonal shifts for a managed resource and
// their statuses for the resource.
type ZonalShiftInResource struct {
	_ struct{} `type:"structure"`

	// An appliedStatus for a zonal shift for a resource can have one of two values:
	// APPLIED or NOT_APPLIED.
	//
	// AppliedStatus is a required field
	AppliedStatus *string `locationName:"appliedStatus" type:"string" required:"true" enum:"AppliedStatus"`

	// The Availability Zone that traffic is moved away from for a resource when
	// you start a zonal shift. Until the zonal shift expires or you cancel it,
	// traffic for the resource is instead moved to other Availability Zones in
	// the AWS Region.
	//
	// AwayFrom is a required field
	AwayFrom *string `locationName:"awayFrom" type:"string" required:"true"`

	// A comment that you enter about the zonal shift. Only the latest comment is
	// retained; no comment history is maintained. That is, a new comment overwrites
	// any existing comment string.
	//
	// Comment is a required field
	Comment *string `locationName:"comment" type:"string" required:"true"`

	// The expiry time (expiration time) for the zonal shift. A zonal shift is temporary
	// and must be set to expire when you start the zonal shift. You can initially
	// set a zonal shift to expire in a maximum of three days (72 hours). However,
	// you can update a zonal shift to set a new expiration at any time.
	//
	// When you start a zonal shift, you specify how long you want it to be active,
	// which Route 53 ARC converts to an expiry time (expiration time). You can
	// cancel a zonal shift, for example, if you're ready to restore traffic to
	// the Availability Zone. Or you can update the zonal shift to specify another
	// length of time to expire in.
	//
	// ExpiryTime is a required field
	ExpiryTime *time.Time `locationName:"expiryTime" type:"timestamp" required:"true"`

	// The identifier for the resource to include in a zonal shift. The identifier
	// is the Amazon Resource Name (ARN) for the resource.
	//
	// At this time, you can only start a zonal shift for Network Load Balancers
	// and Application Load Balancers with cross-zone load balancing turned off.
	//
	// ResourceIdentifier is a required field
	ResourceIdentifier *string `locationName:"resourceIdentifier" min:"8" type:"string" required:"true"`

	// The time (UTC) when the zonal shift is started.
	//
	// StartTime is a required field
	StartTime *time.Time `locationName:"startTime" type:"timestamp" required:"true"`

	// The identifier of a zonal shift.
	//
	// ZonalShiftId is a required field
	ZonalShiftId *string `locationName:"zonalShiftId" min:"6" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ZonalShiftInResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ZonalShiftInResource) GoString() string {
	return s.String()
}

// SetAppliedStatus sets the AppliedStatus field's value.
func (s *ZonalShiftInResource) SetAppliedStatus(v string) *ZonalShiftInResource {
	s.AppliedStatus = &v
	return s
}

// SetAwayFrom sets the AwayFrom field's value.
func (s *ZonalShiftInResource) SetAwayFrom(v string) *ZonalShiftInResource {
	s.AwayFrom = &v
	return s
}

// SetComment sets the Comment field's value.
func (s *ZonalShiftInResource) SetComment(v string) *ZonalShiftInResource {
	s.Comment = &v
	return s
}

// SetExpiryTime sets the ExpiryTime field's value.
func (s *ZonalShiftInResource) SetExpiryTime(v time.Time) *ZonalShiftInResource {
	s.ExpiryTime = &v
	return s
}

// SetResourceIdentifier sets the ResourceIdentifier field's value.
func (s *ZonalShiftInResource) SetResourceIdentifier(v string) *ZonalShiftInResource {
	s.ResourceIdentifier = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ZonalShiftInResource) SetStartTime(v time.Time) *ZonalShiftInResource {
	s.StartTime = &v
	return s
}

// SetZonalShiftId sets the ZonalShiftId field's value.
func (s *ZonalShiftInResource) SetZonalShiftId(v string) *ZonalShiftInResource {
	s.ZonalShiftId = &v
	return s
}

// You start a zonal shift to temporarily move load balancer traffic away from
// an Availability Zone in a AWS Region. A zonal shift helps your application
// recover immediately, for example, from a developer's bad code deployment
// or from an AWS infrastructure failure in a single Availability Zone. You
// can start a zonal shift in Route 53 ARC only for managed resources in your
// account in an AWS Region. Supported AWS resources are automatically registered
// with Route 53 ARC.
//
// Zonal shifts are temporary. A zonal shift can be active for up to three days
// (72 hours).
//
// When you start a zonal shift, you specify how long you want it to be active,
// which Amazon Route 53 Application Recovery Controller converts to an expiry
// time (expiration time). You can cancel a zonal shift, for example, if you're
// ready to restore traffic to the Availability Zone. Or you can extend the
// zonal shift by updating the expiration so the zonal shift is active longer.
type ZonalShiftSummary struct {
	_ struct{} `type:"structure"`

	// The Availability Zone that traffic is moved away from for a resource when
	// you start a zonal shift. Until the zonal shift expires or you cancel it,
	// traffic for the resource is instead moved to other Availability Zones in
	// the AWS Region.
	//
	// AwayFrom is a required field
	AwayFrom *string `locationName:"awayFrom" type:"string" required:"true"`

	// A comment that you enter about the zonal shift. Only the latest comment is
	// retained; no comment history is maintained. That is, a new comment overwrites
	// any existing comment string.
	//
	// Comment is a required field
	Comment *string `locationName:"comment" type:"string" required:"true"`

	// The expiry time (expiration time) for the zonal shift. A zonal shift is temporary
	// and must be set to expire when you start the zonal shift. You can initially
	// set a zonal shift to expire in a maximum of three days (72 hours). However,
	// you can update a zonal shift to set a new expiration at any time.
	//
	// When you start a zonal shift, you specify how long you want it to be active,
	// which Route 53 ARC converts to an expiry time (expiration time). You can
	// cancel a zonal shift, for example, if you're ready to restore traffic to
	// the Availability Zone. Or you can update the zonal shift to specify another
	// length of time to expire in.
	//
	// ExpiryTime is a required field
	ExpiryTime *time.Time `locationName:"expiryTime" type:"timestamp" required:"true"`

	// The identifier for the resource to include in a zonal shift. The identifier
	// is the Amazon Resource Name (ARN) for the resource.
	//
	// At this time, you can only start a zonal shift for Network Load Balancers
	// and Application Load Balancers with cross-zone load balancing turned off.
	//
	// ResourceIdentifier is a required field
	ResourceIdentifier *string `locationName:"resourceIdentifier" min:"8" type:"string" required:"true"`

	// The time (UTC) when the zonal shift is started.
	//
	// StartTime is a required field
	StartTime *time.Time `locationName:"startTime" type:"timestamp" required:"true"`

	// A status for a zonal shift.
	//
	// The Status for a zonal shift can have one of the following values:
	//
	//    * ACTIVE: The zonal shift is started and active.
	//
	//    * EXPIRED: The zonal shift has expired (the expiry time was exceeded).
	//
	//    * CANCELED: The zonal shift was canceled.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ZonalShiftStatus"`

	// The identifier of a zonal shift.
	//
	// ZonalShiftId is a required field
	ZonalShiftId *string `locationName:"zonalShiftId" min:"6" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ZonalShiftSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ZonalShiftSummary) GoString() string {
	return s.String()
}

// SetAwayFrom sets the AwayFrom field's value.
func (s *ZonalShiftSummary) SetAwayFrom(v string) *ZonalShiftSummary {
	s.AwayFrom = &v
	return s
}

// SetComment sets the Comment field's value.
func (s *ZonalShiftSummary) SetComment(v string) *ZonalShiftSummary {
	s.Comment = &v
	return s
}

// SetExpiryTime sets the ExpiryTime field's value.
func (s *ZonalShiftSummary) SetExpiryTime(v time.Time) *ZonalShiftSummary {
	s.ExpiryTime = &v
	return s
}

// SetResourceIdentifier sets the ResourceIdentifier field's value.
func (s *ZonalShiftSummary) SetResourceIdentifier(v string) *ZonalShiftSummary {
	s.ResourceIdentifier = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ZonalShiftSummary) SetStartTime(v time.Time) *ZonalShiftSummary {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ZonalShiftSummary) SetStatus(v string) *ZonalShiftSummary {
	s.Status = &v
	return s
}

// SetZonalShiftId sets the ZonalShiftId field's value.
func (s *ZonalShiftSummary) SetZonalShiftId(v string) *ZonalShiftSummary {
	s.ZonalShiftId = &v
	return s
}

const (
	// AppliedStatusApplied is a AppliedStatus enum value
	AppliedStatusApplied = "APPLIED"

	// AppliedStatusNotApplied is a AppliedStatus enum value
	AppliedStatusNotApplied = "NOT_APPLIED"
)

// AppliedStatus_Values returns all elements of the AppliedStatus enum
func AppliedStatus_Values() []string {
	return []string{
		AppliedStatusApplied,
		AppliedStatusNotApplied,
	}
}

const (
	// ConflictExceptionReasonZonalShiftAlreadyExists is a ConflictExceptionReason enum value
	ConflictExceptionReasonZonalShiftAlreadyExists = "ZonalShiftAlreadyExists"

	// ConflictExceptionReasonZonalShiftStatusNotActive is a ConflictExceptionReason enum value
	ConflictExceptionReasonZonalShiftStatusNotActive = "ZonalShiftStatusNotActive"

	// ConflictExceptionReasonSimultaneousZonalShiftsConflict is a ConflictExceptionReason enum value
	ConflictExceptionReasonSimultaneousZonalShiftsConflict = "SimultaneousZonalShiftsConflict"
)

// ConflictExceptionReason_Values returns all elements of the ConflictExceptionReason enum
func ConflictExceptionReason_Values() []string {
	return []string{
		ConflictExceptionReasonZonalShiftAlreadyExists,
		ConflictExceptionReasonZonalShiftStatusNotActive,
		ConflictExceptionReasonSimultaneousZonalShiftsConflict,
	}
}

const (
	// ValidationExceptionReasonInvalidExpiresIn is a ValidationExceptionReason enum value
	ValidationExceptionReasonInvalidExpiresIn = "InvalidExpiresIn"

	// ValidationExceptionReasonInvalidStatus is a ValidationExceptionReason enum value
	ValidationExceptionReasonInvalidStatus = "InvalidStatus"

	// ValidationExceptionReasonMissingValue is a ValidationExceptionReason enum value
	ValidationExceptionReasonMissingValue = "MissingValue"

	// ValidationExceptionReasonInvalidToken is a ValidationExceptionReason enum value
	ValidationExceptionReasonInvalidToken = "InvalidToken"

	// ValidationExceptionReasonInvalidResourceIdentifier is a ValidationExceptionReason enum value
	ValidationExceptionReasonInvalidResourceIdentifier = "InvalidResourceIdentifier"

	// ValidationExceptionReasonInvalidAz is a ValidationExceptionReason enum value
	ValidationExceptionReasonInvalidAz = "InvalidAz"

	// ValidationExceptionReasonUnsupportedAz is a ValidationExceptionReason enum value
	ValidationExceptionReasonUnsupportedAz = "UnsupportedAz"
)

// ValidationExceptionReason_Values returns all elements of the ValidationExceptionReason enum
func ValidationExceptionReason_Values() []string {
	return []string{
		ValidationExceptionReasonInvalidExpiresIn,
		ValidationExceptionReasonInvalidStatus,
		ValidationExceptionReasonMissingValue,
		ValidationExceptionReasonInvalidToken,
		ValidationExceptionReasonInvalidResourceIdentifier,
		ValidationExceptionReasonInvalidAz,
		ValidationExceptionReasonUnsupportedAz,
	}
}

const (
	// ZonalShiftStatusActive is a ZonalShiftStatus enum value
	ZonalShiftStatusActive = "ACTIVE"

	// ZonalShiftStatusExpired is a ZonalShiftStatus enum value
	ZonalShiftStatusExpired = "EXPIRED"

	// ZonalShiftStatusCanceled is a ZonalShiftStatus enum value
	ZonalShiftStatusCanceled = "CANCELED"
)

// ZonalShiftStatus_Values returns all elements of the ZonalShiftStatus enum
func ZonalShiftStatus_Values() []string {
	return []string{
		ZonalShiftStatusActive,
		ZonalShiftStatusExpired,
		ZonalShiftStatusCanceled,
	}
}
