package costmanagement

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/costmanagement/mgmt/2018-08-01-preview/costmanagement"

// Alert the Alert model definition
type Alert struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Alert id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Alert name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Alert type
	Type *string `json:"type,omitempty"`
	// AlertProperties - Alert properties
	*AlertProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for Alert.
func (a Alert) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.AlertProperties != nil {
		objectMap["properties"] = a.AlertProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Alert struct.
func (a *Alert) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				a.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				a.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				a.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var alertProperties AlertProperties
				err = json.Unmarshal(*v, &alertProperties)
				if err != nil {
					return err
				}
				a.AlertProperties = &alertProperties
			}
		}
	}

	return nil
}

// AlertDefinition the definition (rule) of an Alert
type AlertDefinition struct {
	// Category - READ-ONLY; Category of the alert. Possible values include: 'Cost', 'Usage', 'Billing'
	Category AlertCategory `json:"category,omitempty"`
	// Type - READ-ONLY; The type of cost-entity the alert is defined on. Possible values include: 'Budget', 'Invoice', 'Credit'
	Type AlertType `json:"type,omitempty"`
	// Criteria - READ-ONLY; Criteria (condition) of the alert. Possible values include: 'CostThresholdExceeded', 'UsageThresholdExceeded', 'CreditThresholdReached'
	Criteria AlertCriteria `json:"criteria,omitempty"`
}

// MarshalJSON is the custom marshaler for AlertDefinition.
func (ad AlertDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// AlertListResult result of listing alerts. It contains a list of available alerts in the scope provided.
type AlertListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of alerts.
	Value *[]Alert `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page of Alerts.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for AlertListResult.
func (alr AlertListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// AlertListResultIterator provides access to a complete listing of Alert values.
type AlertListResultIterator struct {
	i    int
	page AlertListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AlertListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AlertListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AlertListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AlertListResultIterator) Response() AlertListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AlertListResultIterator) Value() Alert {
	if !iter.page.NotDone() {
		return Alert{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AlertListResultIterator type.
func NewAlertListResultIterator(page AlertListResultPage) AlertListResultIterator {
	return AlertListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (alr AlertListResult) IsEmpty() bool {
	return alr.Value == nil || len(*alr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (alr AlertListResult) hasNextLink() bool {
	return alr.NextLink != nil && len(*alr.NextLink) != 0
}

// alertListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (alr AlertListResult) alertListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !alr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(alr.NextLink)))
}

// AlertListResultPage contains a page of Alert values.
type AlertListResultPage struct {
	fn  func(context.Context, AlertListResult) (AlertListResult, error)
	alr AlertListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AlertListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.alr)
		if err != nil {
			return err
		}
		page.alr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AlertListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AlertListResultPage) NotDone() bool {
	return !page.alr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AlertListResultPage) Response() AlertListResult {
	return page.alr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AlertListResultPage) Values() []Alert {
	if page.alr.IsEmpty() {
		return nil
	}
	return *page.alr.Value
}

// Creates a new instance of the AlertListResultPage type.
func NewAlertListResultPage(cur AlertListResult, getNextPage func(context.Context, AlertListResult) (AlertListResult, error)) AlertListResultPage {
	return AlertListResultPage{
		fn:  getNextPage,
		alr: cur,
	}
}

// AlertProperties the properties of an Alert.
type AlertProperties struct {
	// CostEntityID - READ-ONLY; The id of the creating cost-entity (budget, invoice, credit).
	CostEntityID *string `json:"costEntityId,omitempty"`
	// Definition - READ-ONLY; The definition (rule) of an Alert
	Definition *AlertDefinition `json:"definition,omitempty"`
	// Description - READ-ONLY; Description of an alert.
	Description *string `json:"description,omitempty"`
	// Scope - READ-ONLY; The scope of an alert.
	Scope *string `json:"scope,omitempty"`
	// Source - READ-ONLY; The source of an Alert. Possible values include: 'Preset', 'User'
	Source AlertSource `json:"source,omitempty"`
	// Details - READ-ONLY; Specific details of an alert - key-value dictionary.
	Details map[string]*string `json:"details"`
	// CreationTime - READ-ONLY; The time when the alert was created.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// CloseTime - READ-ONLY; The time when the alert was closed (resolved / overridden).
	CloseTime *date.Time `json:"closeTime,omitempty"`
	// Status - The current status of the alert. Possible values include: 'Active', 'Overridden', 'Resolved', 'Dismissed'
	Status AlertStatus `json:"status,omitempty"`
	// StatusModificationTime - READ-ONLY; The current status when alert status was modified.
	StatusModificationTime *date.Time `json:"statusModificationTime,omitempty"`
	// ModificationTime - READ-ONLY; The current status when alert was modified.
	ModificationTime *date.Time `json:"modificationTime,omitempty"`
	// ModificationUsername - READ-ONLY; The username who modified the alert.
	ModificationUsername *string `json:"modificationUsername,omitempty"`
}

// MarshalJSON is the custom marshaler for AlertProperties.
func (ap AlertProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ap.Status != "" {
		objectMap["status"] = ap.Status
	}
	return json.Marshal(objectMap)
}

// CommonReportProperties the common properties of the report.
type CommonReportProperties struct {
	// Format - The format of the report being delivered. Possible values include: 'Csv'
	Format FormatType `json:"format,omitempty"`
	// DeliveryInfo - Has delivery information for the report.
	DeliveryInfo *ReportDeliveryInfo `json:"deliveryInfo,omitempty"`
	// Definition - Has definition for the report.
	Definition *ReportDefinition `json:"definition,omitempty"`
}

// ConnectorCollectionErrorInfo details of any error encountered on last collection attempt
type ConnectorCollectionErrorInfo struct {
	// ErrorMessage - READ-ONLY; Detailed error message
	ErrorMessage *string `json:"errorMessage,omitempty"`
	// ErrorCode - READ-ONLY; Short error message
	ErrorCode *string `json:"errorCode,omitempty"`
	// ErrorStartTime - READ-ONLY; Time the error started occurring (Last time error occurred in lastRun)
	ErrorStartTime *date.Time `json:"errorStartTime,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectorCollectionErrorInfo.
func (ccei ConnectorCollectionErrorInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ConnectorCollectionInfo collection and ingestion information
type ConnectorCollectionInfo struct {
	// LastRun - READ-ONLY; Last time the data acquisition process completed (even if no new data was found)
	LastRun *date.Time `json:"lastRun,omitempty"`
	// SourceLastUpdated - READ-ONLY; Source timestamp of external data currently available in Azure (eg AWS last processed CUR file timestamp)
	SourceLastUpdated *date.Time `json:"sourceLastUpdated,omitempty"`
	// LastUpdated - READ-ONLY; Last time the external data was updated into Azure
	LastUpdated *date.Time `json:"lastUpdated,omitempty"`
	// Error - Error information of last collection
	Error *ConnectorCollectionErrorInfo `json:"error,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectorCollectionInfo.
func (cci ConnectorCollectionInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cci.Error != nil {
		objectMap["error"] = cci.Error
	}
	return json.Marshal(objectMap)
}

// ConnectorDefinition the Connector model definition
type ConnectorDefinition struct {
	autorest.Response `json:"-"`
	// Kind - Connector kind (eg aws)
	Kind *string `json:"kind,omitempty"`
	// ID - READ-ONLY; Connector id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Connector name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Connector type
	Type *string `json:"type,omitempty"`
	// Location - Connector location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ConnectorProperties - Connector properties
	*ConnectorProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectorDefinition.
func (cd ConnectorDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cd.Kind != nil {
		objectMap["kind"] = cd.Kind
	}
	if cd.Location != nil {
		objectMap["location"] = cd.Location
	}
	if cd.Tags != nil {
		objectMap["tags"] = cd.Tags
	}
	if cd.ConnectorProperties != nil {
		objectMap["properties"] = cd.ConnectorProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ConnectorDefinition struct.
func (cd *ConnectorDefinition) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				cd.Kind = &kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cd.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cd.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				cd.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				cd.Tags = tags
			}
		case "properties":
			if v != nil {
				var connectorProperties ConnectorProperties
				err = json.Unmarshal(*v, &connectorProperties)
				if err != nil {
					return err
				}
				cd.ConnectorProperties = &connectorProperties
			}
		}
	}

	return nil
}

// ConnectorDefinitionListResult result of listing connector definitions. It contains a list of available
// connector definitions in the scope provided.
type ConnectorDefinitionListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of connector definitions.
	Value *[]ConnectorDefinition `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectorDefinitionListResult.
func (cdlr ConnectorDefinitionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ConnectorProperties the properties of a Connector
type ConnectorProperties struct {
	// DisplayName - Connector DisplayName (defaults to Name)
	DisplayName *string `json:"displayName,omitempty"`
	// ProviderAccountID - READ-ONLY; Connector providerAccountId (determined from credentials)
	ProviderAccountID *string `json:"providerAccountId,omitempty"`
	// CredentialsKey - Credentials authentication key (eg AWS ARN)
	CredentialsKey *string `json:"credentialsKey,omitempty"`
	// CredentialsSecret - Credentials secret (eg AWS ExternalId)
	CredentialsSecret *string `json:"credentialsSecret,omitempty"`
	// ReportID - Identifying source report. (For AWS this is a CUR report name, defined with Daily and with Resources)
	ReportID *string `json:"reportId,omitempty"`
	// CreatedOn - READ-ONLY; Connector definition creation datetime
	CreatedOn *date.Time `json:"createdOn,omitempty"`
	// ModifiedOn - READ-ONLY; Connector last modified datetime
	ModifiedOn *date.Time `json:"modifiedOn,omitempty"`
	// Status - Connector status. Possible values include: 'ConnectorStatusActive', 'ConnectorStatusError', 'ConnectorStatusSuspended'
	Status ConnectorStatus `json:"status,omitempty"`
	// Collection - READ-ONLY; Collection information
	Collection *ConnectorCollectionInfo `json:"collection,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectorProperties.
func (cp ConnectorProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cp.DisplayName != nil {
		objectMap["displayName"] = cp.DisplayName
	}
	if cp.CredentialsKey != nil {
		objectMap["credentialsKey"] = cp.CredentialsKey
	}
	if cp.CredentialsSecret != nil {
		objectMap["credentialsSecret"] = cp.CredentialsSecret
	}
	if cp.ReportID != nil {
		objectMap["reportId"] = cp.ReportID
	}
	if cp.Status != "" {
		objectMap["status"] = cp.Status
	}
	return json.Marshal(objectMap)
}

// Dimension ...
type Dimension struct {
	*DimensionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Tags - READ-ONLY; Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Dimension.
func (d Dimension) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if d.DimensionProperties != nil {
		objectMap["properties"] = d.DimensionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Dimension struct.
func (d *Dimension) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var dimensionProperties DimensionProperties
				err = json.Unmarshal(*v, &dimensionProperties)
				if err != nil {
					return err
				}
				d.DimensionProperties = &dimensionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				d.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				d.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				d.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				d.Tags = tags
			}
		}
	}

	return nil
}

// DimensionProperties ...
type DimensionProperties struct {
	Data       *[]string  `json:"data,omitempty"`
	Total      *int32     `json:"total,omitempty"`
	Category   *string    `json:"category,omitempty"`
	UsageStart *date.Time `json:"usageStart,omitempty"`
	UsageEnd   *date.Time `json:"usageEnd,omitempty"`
	NextLink   *string    `json:"nextLink,omitempty"`
}

// DimensionsListResult result of listing dimensions. It contains a list of available dimensions.
type DimensionsListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of dimensions.
	Value *[]Dimension `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for DimensionsListResult.
func (dlr DimensionsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorBase the details of the error.
type ErrorBase struct {
	// Code - READ-ONLY; A machine readable error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; A human readable error message.
	Message *string `json:"message,omitempty"`
	// Target - READ-ONLY; Indicates which property in the request is responsible for the error.
	Target *string `json:"target,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorBase.
func (eb ErrorBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorDetails the details of the error.
type ErrorDetails struct {
	// Code - READ-ONLY; A machine readable error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; A human readable error message.
	Message *string `json:"message,omitempty"`
	// Target - Indicates which property in the request is responsible for the error.
	Target *string `json:"target,omitempty"`
	// Details - error details.
	Details *[]ErrorBase `json:"details,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorDetails.
func (ed ErrorDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ed.Target != nil {
		objectMap["target"] = ed.Target
	}
	if ed.Details != nil {
		objectMap["details"] = ed.Details
	}
	return json.Marshal(objectMap)
}

// ErrorResponse error response indicates that the service is not able to process the incoming request. The
// reason is provided in the error message.
type ErrorResponse struct {
	// Error - The details of the error.
	Error *ErrorDetails `json:"error,omitempty"`
}

// Operation a Cost Management REST API operation.
type Operation struct {
	// Name - READ-ONLY; Operation name: {provider}/{resource}/{operation}.
	Name *string `json:"name,omitempty"`
	// Display - The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`
}

// MarshalJSON is the custom marshaler for Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if o.Display != nil {
		objectMap["display"] = o.Display
	}
	return json.Marshal(objectMap)
}

// OperationDisplay the object that represents the operation.
type OperationDisplay struct {
	// Provider - READ-ONLY; Service provider: Microsoft.CostManagement.
	Provider *string `json:"provider,omitempty"`
	// Resource - READ-ONLY; Resource on which the operation is performed: UsageDetail, etc.
	Resource *string `json:"resource,omitempty"`
	// Operation - READ-ONLY; Operation type: Read, write, delete, etc.
	Operation *string `json:"operation,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// OperationListResult result of listing CostManagement operations. It contains a list of operations and a
// URL link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of CostManagement operations supported by the Microsoft.CostManagement resource provider.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationListResult.
func (olr OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OperationListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{
		fn:  getNextPage,
		olr: cur,
	}
}

// Query ...
type Query struct {
	*QueryProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Tags - READ-ONLY; Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Query.
func (q Query) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if q.QueryProperties != nil {
		objectMap["properties"] = q.QueryProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Query struct.
func (q *Query) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var queryProperties QueryProperties
				err = json.Unmarshal(*v, &queryProperties)
				if err != nil {
					return err
				}
				q.QueryProperties = &queryProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				q.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				q.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				q.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				q.Tags = tags
			}
		}
	}

	return nil
}

// QueryColumn ...
type QueryColumn struct {
	Name *string `json:"name,omitempty"`
	Type *string `json:"type,omitempty"`
}

// QueryProperties ...
type QueryProperties struct {
	NextLink *string `json:"nextLink,omitempty"`
	// Columns - Array of columns
	Columns *[]QueryColumn   `json:"columns,omitempty"`
	Rows    *[][]interface{} `json:"rows,omitempty"`
}

// QueryResult result of query. It contains all columns listed under groupings and aggregation.
type QueryResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of usage data.
	Value *[]Query `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for QueryResult.
func (qr QueryResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Report a report resource.
type Report struct {
	autorest.Response `json:"-"`
	*ReportProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Tags - READ-ONLY; Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Report.
func (r Report) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.ReportProperties != nil {
		objectMap["properties"] = r.ReportProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Report struct.
func (r *Report) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var reportProperties ReportProperties
				err = json.Unmarshal(*v, &reportProperties)
				if err != nil {
					return err
				}
				r.ReportProperties = &reportProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				r.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				r.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				r.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				r.Tags = tags
			}
		}
	}

	return nil
}

// ReportAggregation the aggregation expression to be used in the report.
type ReportAggregation struct {
	// Name - The name of the column to aggregate.
	Name *string `json:"name,omitempty"`
	// Function - The name of the aggregation function to use.
	Function *string `json:"function,omitempty"`
}

// ReportComparisonExpression the comparison expression to be used in the report.
type ReportComparisonExpression struct {
	// Name - The name of the column to use in comparison.
	Name *string `json:"name,omitempty"`
	// Operator - The operator to use for comparison.
	Operator *string `json:"operator,omitempty"`
	// Values - Array of values to use for comparison
	Values *[]string `json:"values,omitempty"`
}

// ReportDataset the definition of data present in the report.
type ReportDataset struct {
	// Granularity - The granularity of rows in the report. Possible values include: 'Daily', 'Hourly'
	Granularity GranularityType `json:"granularity,omitempty"`
	// Configuration - Has configuration information for the data in the report. The configuration will be ignored if aggregation and grouping are provided.
	Configuration *ReportDatasetConfiguration `json:"configuration,omitempty"`
	// Aggregation - Dictionary of aggregation expression to use in the report. The key of each item in the dictionary is the alias for the aggregated column. Report can have up to 2 aggregation clauses.
	Aggregation map[string]*ReportAggregation `json:"aggregation"`
	// Grouping - Array of group by expression to use in the report. Report can have up to 2 group by clauses.
	Grouping *[]ReportGrouping `json:"grouping,omitempty"`
	// Filter - Has filter expression to use in the report.
	Filter *ReportFilter `json:"filter,omitempty"`
}

// MarshalJSON is the custom marshaler for ReportDataset.
func (rd ReportDataset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rd.Granularity != "" {
		objectMap["granularity"] = rd.Granularity
	}
	if rd.Configuration != nil {
		objectMap["configuration"] = rd.Configuration
	}
	if rd.Aggregation != nil {
		objectMap["aggregation"] = rd.Aggregation
	}
	if rd.Grouping != nil {
		objectMap["grouping"] = rd.Grouping
	}
	if rd.Filter != nil {
		objectMap["filter"] = rd.Filter
	}
	return json.Marshal(objectMap)
}

// ReportDatasetConfiguration the configuration of dataset in the report.
type ReportDatasetConfiguration struct {
	// Columns - Array of column names to be included in the report. Any valid report column name is allowed. If not provided, then report includes all columns.
	Columns *[]string `json:"columns,omitempty"`
}

// ReportDefinition the definition of a report.
type ReportDefinition struct {
	// Type - The type of the report.
	Type *string `json:"type,omitempty"`
	// Timeframe - The time frame for pulling data for the report. If custom, then a specific time period must be provided. Possible values include: 'WeekToDate', 'MonthToDate', 'Custom'
	Timeframe TimeframeType `json:"timeframe,omitempty"`
	// TimePeriod - Has time period for pulling data for the report.
	TimePeriod *ReportTimePeriod `json:"timePeriod,omitempty"`
	// Dataset - Has definition for data in this report.
	Dataset *ReportDataset `json:"dataset,omitempty"`
}

// ReportDeliveryDestination the destination information for the delivery of the report.
type ReportDeliveryDestination struct {
	// ResourceID - The resource id of the storage account where reports will be delivered.
	ResourceID *string `json:"resourceId,omitempty"`
	// Container - The name of the container where reports will be uploaded.
	Container *string `json:"container,omitempty"`
	// RootFolderPath - The name of the directory where reports will be uploaded.
	RootFolderPath *string `json:"rootFolderPath,omitempty"`
}

// ReportDeliveryInfo the delivery information associated with a report.
type ReportDeliveryInfo struct {
	// Destination - Has destination for the report being delivered.
	Destination *ReportDeliveryDestination `json:"destination,omitempty"`
}

// ReportExecution a report execution.
type ReportExecution struct {
	*ReportExecutionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Tags - READ-ONLY; Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ReportExecution.
func (re ReportExecution) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if re.ReportExecutionProperties != nil {
		objectMap["properties"] = re.ReportExecutionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ReportExecution struct.
func (re *ReportExecution) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var reportExecutionProperties ReportExecutionProperties
				err = json.Unmarshal(*v, &reportExecutionProperties)
				if err != nil {
					return err
				}
				re.ReportExecutionProperties = &reportExecutionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				re.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				re.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				re.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				re.Tags = tags
			}
		}
	}

	return nil
}

// ReportExecutionListResult result of listing reports execution history of a report by name
type ReportExecutionListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of report executions.
	Value *[]ReportExecution `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for ReportExecutionListResult.
func (relr ReportExecutionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ReportExecutionProperties the properties of the report execution.
type ReportExecutionProperties struct {
	// ExecutionType - The type of the report execution. Possible values include: 'OnDemand', 'Scheduled'
	ExecutionType ExecutionType `json:"executionType,omitempty"`
	// Status - The status of the report execution. Possible values include: 'Queued', 'InProgress', 'Completed', 'Failed', 'Timeout', 'NewDataNotAvailable', 'DataNotAvailable'
	Status ExecutionStatus `json:"status,omitempty"`
	// SubmittedBy - The identifier for the entity that executed the report. For OnDemand executions, it is the email id. For Scheduled executions, it is the constant value - System.
	SubmittedBy *string `json:"submittedBy,omitempty"`
	// SubmittedTime - The time when report was queued to be executed.
	SubmittedTime *date.Time `json:"submittedTime,omitempty"`
	// ProcessingStartTime - The time when report was picked up to be executed.
	ProcessingStartTime *date.Time `json:"processingStartTime,omitempty"`
	// ProcessingEndTime - The time when report execution finished.
	ProcessingEndTime *date.Time `json:"processingEndTime,omitempty"`
	// FileName - The name of the file report got written to.
	FileName       *string                 `json:"fileName,omitempty"`
	ReportSettings *CommonReportProperties `json:"reportSettings,omitempty"`
}

// ReportFilter the filter expression to be used in the report.
type ReportFilter struct {
	// And - The logical "AND" expression. Must have at least 2 items.
	And *[]ReportFilter `json:"and,omitempty"`
	// Or - The logical "OR" expression. Must have at least 2 items.
	Or *[]ReportFilter `json:"or,omitempty"`
	// Not - The logical "NOT" expression.
	Not *ReportFilter `json:"not,omitempty"`
	// Dimension - Has comparison expression for a dimension
	Dimension *ReportComparisonExpression `json:"dimension,omitempty"`
	// Tag - Has comparison expression for a tag
	Tag *ReportComparisonExpression `json:"tag,omitempty"`
}

// ReportGrouping the group by expression to be used in the report.
type ReportGrouping struct {
	// Type - Has type of the column to group. Possible values include: 'ReportColumnTypeTag', 'ReportColumnTypeDimension'
	Type ReportColumnType `json:"type,omitempty"`
	// Name - The name of the column to group.
	Name *string `json:"name,omitempty"`
}

// ReportListResult result of listing reports. It contains a list of available reports in the scope
// provided.
type ReportListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of reports.
	Value *[]Report `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for ReportListResult.
func (rlr ReportListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ReportProperties the properties of the report.
type ReportProperties struct {
	// Schedule - Has schedule information for the report.
	Schedule *ReportSchedule `json:"schedule,omitempty"`
	// Format - The format of the report being delivered. Possible values include: 'Csv'
	Format FormatType `json:"format,omitempty"`
	// DeliveryInfo - Has delivery information for the report.
	DeliveryInfo *ReportDeliveryInfo `json:"deliveryInfo,omitempty"`
	// Definition - Has definition for the report.
	Definition *ReportDefinition `json:"definition,omitempty"`
}

// ReportRecurrencePeriod the start and end date for recurrence schedule.
type ReportRecurrencePeriod struct {
	// From - The start date of recurrence.
	From *date.Time `json:"from,omitempty"`
	// To - The end date of recurrence.
	To *date.Time `json:"to,omitempty"`
}

// ReportSchedule the schedule associated with a report.
type ReportSchedule struct {
	// Status - The status of the schedule. Whether active or not. If inactive, the report's scheduled execution is paused. Possible values include: 'StatusTypeActive', 'StatusTypeInactive'
	Status StatusType `json:"status,omitempty"`
	// Recurrence - The schedule recurrence. Possible values include: 'RecurrenceTypeDaily', 'RecurrenceTypeWeekly', 'RecurrenceTypeMonthly', 'RecurrenceTypeAnnually'
	Recurrence RecurrenceType `json:"recurrence,omitempty"`
	// RecurrencePeriod - Has start and end date of the recurrence. The start date must be in future. If present, the end date must be greater than start date.
	RecurrencePeriod *ReportRecurrencePeriod `json:"recurrencePeriod,omitempty"`
}

// ReportTimePeriod the start and end date for pulling data for the report.
type ReportTimePeriod struct {
	// From - The start date to pull data from.
	From *date.Time `json:"from,omitempty"`
	// To - The end date to pull data to.
	To *date.Time `json:"to,omitempty"`
}

// Resource the Resource model definition.
type Resource struct {
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Tags - READ-ONLY; Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}
