/**
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

(function() {
  'use strict';

  /**
   * @ngdoc service
   * @name horizon.framework.widgets.modal.wizard-modal.service
   *
   * @description
   * Horizon's wrapper for angular-bootstrap modal service.
   * It should only be use for Wizard dialogs.
   *
   * @example:
   *  angular
   *    .controller('modalExampleCtrl', ExampleCtrl);
   *
   *  ExampleCtrl.$inject = [
   *    'horizon.framework.widgets.modal.wizard-modal.service'
   *  ];
   *
   *  function ExampleCtrl($scope, wizardModalService) {
   *    var options = {
   *      workflow: workflow, // the workflow used in the wizard
   *      submit: submit // callback to call on a wizard submit
   *    };
   *
   *    wizardModalService(options);
   *  });
   */
  angular
    .module('horizon.framework.widgets.modal')
    .factory('horizon.framework.widgets.modal.wizard-modal.service', WizardModalService);

  WizardModalService.$inject = [
    '$log',
    '$uibModal'
  ];

  function WizardModalService($log, $uibModal) {
    var service = {
      modal: modal
    };

    return service;

    ////////////////////

    function modal(params) {
      if (params && params.workflow && params.submit) {
        var options = {
          size: 'lg',
          controller: 'WizardModalController as modalCtrl',
          template: '<wizard></wizard>',
          backdrop: 'static',
          windowClass: 'modal-dialog-wizard',
          resolve: {
            workflow: function() {
              return params.workflow;
            },
            submit: function() {
              return params.submit;
            },
            data: function() {
              return params.data;
            }
          }
        };

        return $uibModal.open(options);
      }
    }
  }
})();
