package CParse::Attribute;

use 5.6.0;
use strict;
use warnings;

sub new
  {
    my $this = shift;
    my $class = ref($this) || $this;
    my $name = shift;
    my $args = shift;
    my $self = {name => $name,
                args => $args,
               };
    bless $self, $class;
    return $self;
  }

sub name
  {
    my $self = shift;

    return $self->{name};
  }

sub args
  {
    my $self = shift;

    return $self->{args};
  }

sub dump_c
  {
    my $self = shift;

    my $str = $self->{name};

    if (scalar @{$self->{args}})
      {
        $str .= "(" . join(', ', map {$_->dump_c} @{$self->{args}}) . ")";
      }

    return $str;
  }

1;
