#
# Copyright (C) 2020-2023 Intel Corporation
#
# SPDX-License-Identifier: MIT
#

if(NOT NEO_ALLOW_LEGACY_PLATFORMS_SUPPORT)
  if(WIN32)
    DISABLE_FLAGS_FOR("GEN8" "BDW")
    DISABLE_FLAGS_FOR("GEN9" "SKL" "KBL" "BXT" "GLK" "CFL")
    DISABLE_FLAGS_FOR("GEN11" "ICLLP" "LKF" "EHL")
  else()
    SET_FLAGS_FOR("GEN8" "BDW")
    SET_FLAGS_FOR("GEN9" "SKL" "KBL" "BXT" "GLK" "CFL")
    SET_FLAGS_FOR("GEN11" "ICLLP" "LKF" "EHL")
  endif()
else()
  SET_FLAGS_FOR("GEN8" "BDW")
  SET_FLAGS_FOR("GEN9" "SKL" "KBL" "BXT" "GLK" "CFL")
  SET_FLAGS_FOR("GEN11" "ICLLP" "LKF" "EHL")
endif()
DISABLE_FLAGS_FOR("XE_HP_CORE" "XE_HP_SDV")
SET_FLAGS_FOR("GEN12LP" "TGLLP" "RKL" "ADLS" "ADLP" "DG1" "ADLN")
SET_FLAGS_FOR("XE_HPG_CORE" "DG2" "MTL")
SET_FLAGS_FOR("XE_HPC_CORE" "PVC")

foreach(CORE_TYPE ${XEHP_AND_LATER_CORE_TYPES})
  if(TESTS_${CORE_TYPE})
    set(TESTS_XEHP_AND_LATER 1)
  endif()
  if(SUPPORT_${CORE_TYPE})
    set(SUPPORT_XEHP_AND_LATER 1)
  endif()
endforeach()

foreach(CORE_TYPE ${DG2_AND_LATER_CORE_TYPES})
  if(TESTS_${CORE_TYPE})
    set(TESTS_DG2_AND_LATER 1)
  endif()
  if(SUPPORT_${CORE_TYPE})
    set(SUPPORT_DG2_AND_LATER 1)
  endif()
endforeach()

foreach(CORE_TYPE ${MTL_AND_LATER_CORE_TYPES})
  if(TESTS_${CORE_TYPE})
    set(TESTS_MTL_AND_LATER 1)
  endif()
  if(SUPPORT_${CORE_TYPE})
    set(SUPPORT_MTL_AND_LATER 1)
  endif()
endforeach()

foreach(CORE_TYPE ${PVC_AND_LATER_CORE_TYPES})
  if(TESTS_${CORE_TYPE})
    set(TESTS_PVC_AND_LATER 1)
  endif()
  if(SUPPORT_${CORE_TYPE})
    set(SUPPORT_PVC_AND_LATER 1)
  endif()
endforeach()

# Add supported and tested platforms
if(SUPPORT_GEN8)
  if(TESTS_GEN8)
    ADD_ITEM_FOR_CORE_TYPE("FAMILY_NAME" "TESTED" "GEN8" "Gen8Family")
  endif()
  if(SUPPORT_BDW)
    set(BDW_GEN8_REVISIONS 0)
    set(BDW_GEN8_RELEASES "8.0.0")
    ADD_PRODUCT("SUPPORTED" "BDW" "IGFX_BROADWELL")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED" "GEN8" "BDW")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_2_0" "GEN8" "BDW")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_IMAGES" "GEN8" "BDW")
    if(TESTS_BDW)
      ADD_ITEM_FOR_CORE_TYPE("PLATFORMS" "TESTED" "GEN8" "BDW")
      ADD_PRODUCT("TESTED" "BDW" "IGFX_BROADWELL")
    endif()
  endif()
endif()

if(SUPPORT_GEN9)
  if(TESTS_GEN9)
    ADD_ITEM_FOR_CORE_TYPE("FAMILY_NAME" "TESTED" "GEN9" "Gen9Family")
  endif()
  if(SUPPORT_SKL)
    set(SKL_GEN9_REVISIONS 9)
    set(SKL_GEN9_RELEASES "9.0.9")
    ADD_PRODUCT("SUPPORTED" "SKL" "IGFX_SKYLAKE")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED" "GEN9" "SKL")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_2_0" "GEN9" "SKL")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_VME" "GEN9" "SKL")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_IMAGES" "GEN9" "SKL")
    if(TESTS_SKL)
      ADD_ITEM_FOR_CORE_TYPE("PLATFORMS" "TESTED" "GEN9" "SKL")
      ADD_PRODUCT("TESTED" "SKL" "IGFX_SKYLAKE")
    endif()
  endif()

  if(SUPPORT_KBL)
    set(KBL_GEN9_REVISIONS 9)
    set(KBL_GEN9_RELEASES "9.1.9")
    ADD_PRODUCT("SUPPORTED" "KBL" "IGFX_KABYLAKE")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED" "GEN9" "KBL")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_2_0" "GEN9" "KBL")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_VME" "GEN9" "KBL")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_IMAGES" "GEN9" "KBL")
    if(TESTS_KBL)
      ADD_ITEM_FOR_CORE_TYPE("PLATFORMS" "TESTED" "GEN9" "KBL")
      ADD_PRODUCT("TESTED" "KBL" "IGFX_KABYLAKE")
    endif()
  endif()

  if(SUPPORT_GLK)
    set(GLK_GEN9_REVISIONS 0)
    set(GLK_GEN9_RELEASES "9.4.0")
    ADD_PRODUCT("SUPPORTED" "GLK" "IGFX_GEMINILAKE")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED" "GEN9" "GLK")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_VME" "GEN9" "GLK")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_IMAGES" "GEN9" "GLK")
    if(TESTS_GLK)
      ADD_ITEM_FOR_CORE_TYPE("PLATFORMS" "TESTED" "GEN9" "GLK")
      ADD_PRODUCT("TESTED" "GLK" "IGFX_GEMINILAKE")
    endif()
  endif()

  if(SUPPORT_CFL)
    set(CFL_GEN9_REVISIONS 9)
    set(CFL_GEN9_RELEASES "9.2.9")
    ADD_PRODUCT("SUPPORTED" "CFL" "IGFX_COFFEELAKE")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED" "GEN9" "CFL")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_2_0" "GEN9" "CFL")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_VME" "GEN9" "CFL")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_IMAGES" "GEN9" "CFL")
    if(TESTS_CFL)
      ADD_ITEM_FOR_CORE_TYPE("PLATFORMS" "TESTED" "GEN9" "CFL")
      ADD_PRODUCT("TESTED" "CFL" "IGFX_COFFEELAKE")
    endif()
  endif()

  if(SUPPORT_BXT)
    set(BXT_GEN9_REVISIONS 0)
    set(BXT_GEN9_RELEASES "9.3.0")
    ADD_PRODUCT("SUPPORTED" "BXT" "IGFX_BROXTON")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED" "GEN9" "BXT")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_VME" "GEN9" "BXT")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_IMAGES" "GEN9" "BXT")
    if(TESTS_BXT)
      ADD_ITEM_FOR_CORE_TYPE("PLATFORMS" "TESTED" "GEN9" "BXT")
      ADD_PRODUCT("TESTED" "BXT" "IGFX_BROXTON")
    endif()
  endif()
endif()

if(SUPPORT_GEN11)
  if(TESTS_GEN11)
    ADD_ITEM_FOR_CORE_TYPE("FAMILY_NAME" "TESTED" "GEN11" "Gen11Family")
  endif()

  if(SUPPORT_ICLLP)
    set(ICLLP_GEN11_REVISIONS 0)
    set(ICLLP_GEN11_RELEASES "11.0.0")
    ADD_PRODUCT("SUPPORTED" "ICLLP" "IGFX_ICELAKE_LP")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED" "GEN11" "ICLLP")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_2_0" "GEN11" "ICLLP")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_VME" "GEN11" "ICLLP")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_IMAGES" "GEN11" "ICLLP")
    if(TESTS_ICLLP)
      ADD_ITEM_FOR_CORE_TYPE("PLATFORMS" "TESTED" "GEN11" "ICLLP")
      ADD_PRODUCT("TESTED" "ICLLP" "IGFX_ICELAKE_LP")
    endif()
  endif()

  if(SUPPORT_LKF)
    set(LKF_GEN11_REVISIONS 0)
    set(LKF_GEN11_RELEASES "11.1.0")
    ADD_PRODUCT("SUPPORTED" "LKF" "IGFX_LAKEFIELD")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED" "GEN11" "LKF")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_IMAGES" "GEN11" "LKF")
    if(TESTS_LKF)
      ADD_ITEM_FOR_CORE_TYPE("PLATFORMS" "TESTED" "GEN11" "LKF")
      ADD_PRODUCT("TESTED" "LKF" "IGFX_LAKEFIELD")
    endif()
  endif()

  if(SUPPORT_EHL)
    set(EHL_GEN11_REVISIONS 0)
    set(EHL_GEN11_RELEASES "11.2.0")
    ADD_PRODUCT("SUPPORTED" "EHL" "IGFX_ELKHARTLAKE")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED" "GEN11" "EHL")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_IMAGES" "GEN11" "EHL")
    if(TESTS_EHL)
      ADD_ITEM_FOR_CORE_TYPE("PLATFORMS" "TESTED" "GEN11" "EHL")
      ADD_PRODUCT("TESTED" "EHL" "IGFX_ELKHARTLAKE")
    endif()
  endif()
endif()

if(SUPPORT_GEN12LP)
  if(TESTS_GEN12LP)
    ADD_ITEM_FOR_CORE_TYPE("FAMILY_NAME" "TESTED" "GEN12LP" "Gen12LpFamily")
  endif()
  if(SUPPORT_TGLLP)
    set(TGLLP_GEN12LP_REVISIONS 0)
    set(TGLLP_GEN12LP_RELEASES "12.0.0")
    ADD_PRODUCT("SUPPORTED" "TGLLP" "IGFX_TIGERLAKE_LP")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED" "GEN12LP" "TGLLP")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_IMAGES" "GEN12LP" "TGLLP")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_AUX_TRANSLATION" "GEN12LP" "TGLLP")
    if(TESTS_TGLLP)
      ADD_ITEM_FOR_CORE_TYPE("PLATFORMS" "TESTED" "GEN12LP" "TGLLP")
      ADD_PRODUCT("TESTED" "TGLLP" "IGFX_TIGERLAKE_LP")
    endif()
  endif()

  if(SUPPORT_DG1)
    set(DG1_GEN12LP_REVISIONS 0)
    set(DG1_GEN12LP_RELEASES "12.10.0")
    ADD_PRODUCT("SUPPORTED" "DG1" "IGFX_DG1")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED" "GEN12LP" "DG1")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_IMAGES" "GEN12LP" "DG1")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_AUX_TRANSLATION" "GEN12LP" "DG1")
    if(TESTS_DG1)
      ADD_ITEM_FOR_CORE_TYPE("PLATFORMS" "TESTED" "GEN12LP" "DG1")
      ADD_PRODUCT("TESTED" "DG1" "IGFX_DG1")
    endif()
  endif()

  if(SUPPORT_RKL)
    set(RKL_GEN12LP_REVISIONS 0)
    set(RKL_GEN12LP_RELEASES "12.1.0")
    ADD_PRODUCT("SUPPORTED" "RKL" "IGFX_ROCKETLAKE")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED" "GEN12LP" "RKL")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_IMAGES" "GEN12LP" "RKL")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_AUX_TRANSLATION" "GEN12LP" "RKL")
    if(TESTS_RKL)
      ADD_ITEM_FOR_CORE_TYPE("PLATFORMS" "TESTED" "GEN12LP" "RKL")
      ADD_PRODUCT("TESTED" "RKL" "IGFX_ROCKETLAKE")
    endif()
  endif()

  if(SUPPORT_ADLS)
    set(ADLS_GEN12LP_REVISIONS 0)
    set(ADLS_GEN12LP_RELEASES "12.2.0")
    ADD_PRODUCT("SUPPORTED" "ADLS" "IGFX_ALDERLAKE_S")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED" "GEN12LP" "ADLS")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_IMAGES" "GEN12LP" "ADLS")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_AUX_TRANSLATION" "GEN12LP" "ADLS")
    if(TESTS_ADLS)
      ADD_ITEM_FOR_CORE_TYPE("PLATFORMS" "TESTED" "GEN12LP" "ADLS")
      ADD_PRODUCT("TESTED" "ADLS" "IGFX_ALDERLAKE_S")
    endif()
  endif()

  if(SUPPORT_ADLP)
    set(ADLP_GEN12LP_REVISIONS 0)
    set(ADLP_GEN12LP_RELEASES "12.3.0")
    ADD_PRODUCT("SUPPORTED" "ADLP" "IGFX_ALDERLAKE_P")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED" "GEN12LP" "ADLP")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_IMAGES" "GEN12LP" "ADLP")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_AUX_TRANSLATION" "GEN12LP" "ADLP")
    if(TESTS_ADLP)
      ADD_ITEM_FOR_CORE_TYPE("PLATFORMS" "TESTED" "GEN12LP" "ADLP")
      ADD_PRODUCT("TESTED" "ADLP" "IGFX_ALDERLAKE_P")
    endif()
  endif()

  if(SUPPORT_ADLN)
    set(ADLN_GEN12LP_REVISIONS 0)
    set(ADLN_GEN12LP_RELEASES "12.4.0")
    ADD_PRODUCT("SUPPORTED" "ADLN" "IGFX_ALDERLAKE_N")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED" "GEN12LP" "ADLN")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_IMAGES" "GEN12LP" "ADLN")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_AUX_TRANSLATION" "GEN12LP" "ADLN")
    if(TESTS_ADLN)
      ADD_ITEM_FOR_CORE_TYPE("PLATFORMS" "TESTED" "GEN12LP" "ADLN")
      ADD_PRODUCT("TESTED" "ADLN" "IGFX_ALDERLAKE_N")
    endif()
  endif()
endif()

if(SUPPORT_XE_HPG_CORE)
  if(TESTS_XE_HPG_CORE)
    ADD_ITEM_FOR_CORE_TYPE("FAMILY_NAME" "TESTED" "XE_HPG_CORE" "XeHpgCoreFamily")
  endif()
  if(SUPPORT_MTL)
    set(MTL_XE_HPG_CORE_REVISIONS 0)
    set(MTL_XE_HPG_CORE_RELEASES "12.70.0" "12.70.4" "12.71.0" "12.71.4")
    ADD_PRODUCT("SUPPORTED" "MTL" "IGFX_METEORLAKE")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED" "XE_HPG_CORE" "MTL")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_IMAGES" "XE_HPG_CORE" "MTL")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_AUX_TRANSLATION" "XE_HPG_CORE" "MTL")
    if(TESTS_MTL)
      ADD_ITEM_FOR_CORE_TYPE("PLATFORMS" "TESTED" "XE_HPG_CORE" "MTL")
      ADD_PRODUCT("TESTED" "MTL" "IGFX_METEORLAKE")
    endif()
  endif()
  if(SUPPORT_DG2)
    set(DG2_XE_HPG_CORE_REVISIONS 0)
    set(DG2_XE_HPG_CORE_RELEASES "12.55.0" "12.55.1" "12.55.4" "12.55.8" "12.56.0" "12.56.4" "12.56.5" "12.57.0")
    ADD_PRODUCT("SUPPORTED" "DG2" "IGFX_DG2")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED" "XE_HPG_CORE" "DG2")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_AUX_TRANSLATION" "XE_HPG_CORE" "DG2")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_IMAGES" "XE_HPG_CORE" "DG2")
    if(TESTS_DG2)
      ADD_ITEM_FOR_CORE_TYPE("PLATFORMS" "TESTED" "XE_HPG_CORE" "DG2")
      ADD_PRODUCT("TESTED" "DG2" "IGFX_DG2")
    endif()
  endif()
endif()

if(SUPPORT_XE_HPC_CORE)
  set(XE_HPC_CORE_TEST_KERNELS_BLOCKLIST "CopyBuffer_simd8.cl")
  if(TESTS_XE_HPC_CORE)
    ADD_ITEM_FOR_CORE_TYPE("FAMILY_NAME" "TESTED" "XE_HPC_CORE" "XeHpcCoreFamily")
  endif()

  if(SUPPORT_PVC)
    set(PVC_XE_HPC_CORE_REVISIONS 0 3 30 38 46 47 157)
    set(PVC_XE_HPC_CORE_RELEASES "12.60.0" "12.60.1" "12.60.3" "12.60.5" "12.60.6" "12.60.7")
    ADD_PRODUCT("SUPPORTED" "PVC" "IGFX_PVC")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED" "XE_HPC_CORE" "PVC")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_AUX_TRANSLATION" "XE_HPC_CORE" "PVC")
    set(PREFERRED_PLATFORM "PVC")
    if(TESTS_PVC)
      set(PREFERRED_FAMILY_NAME "XeHpcCoreFamily")
      ADD_ITEM_FOR_CORE_TYPE("PLATFORMS" "TESTED" "XE_HPC_CORE" "PVC")
      ADD_PRODUCT("TESTED" "PVC" "IGFX_PVC")
    endif()
  endif()
endif()
