# All Rights Reserved.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.


"""
Mapping of values for CONF.conductor.automated_clean_step_source, representing
different possible sources for cleaning steps.
"""

AUTOGENERATED = 'autogenerated'
"Use traditional Ironic method with automatically determined cleaning steps"

RUNBOOK = 'runbook'
"Use a runbook for automated cleaning; fail if no runbook is configured."

HYBRID = 'hybrid'
"Use a runbook if configured; use autogenerated steps if not."
