/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.jardiff;

import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.objectweb.asm.Type;
import org.osjava.jardiff.AbstractInfo;
import org.osjava.jardiff.ClassInfo;
import org.osjava.jardiff.DiffException;
import org.osjava.jardiff.DiffHandler;
import org.osjava.jardiff.FieldInfo;
import org.osjava.jardiff.MethodInfo;
import org.osjava.jardiff.Tools;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SAXDiffHandler
implements DiffHandler {
    public static final String XML_URI = "http://www.osjava.org/jardiff/0.1";
    private final TransformerHandler handler;
    protected final AttributesImpl attr = new AttributesImpl();

    public SAXDiffHandler() throws DiffException {
        try {
            SAXTransformerFactory stf = (SAXTransformerFactory)TransformerFactory.newInstance();
            this.handler = stf.newTransformerHandler();
            this.handler.setResult(new StreamResult(System.out));
        }
        catch (TransformerConfigurationException tce) {
            throw new DiffException(tce);
        }
    }

    public SAXDiffHandler(TransformerHandler handler) {
        this.handler = handler;
    }

    public void startDiff(String oldJar, String newJar) throws DiffException {
        try {
            this.handler.startDocument();
            this.handler.startPrefixMapping("", XML_URI);
            this.attr.addAttribute(XML_URI, "", "old", "CDATA", oldJar);
            this.attr.addAttribute(XML_URI, "", "new", "CDATA", newJar);
            this.attr.addAttribute("http://www.w3.org/2000/xmlns/", "", "xmlns", "CDATA", XML_URI);
            this.handler.startElement(XML_URI, "", "diff", this.attr);
            this.attr.clear();
        }
        catch (SAXException se) {
            throw new DiffException(se);
        }
    }

    public void startRemoved() throws DiffException {
        try {
            this.handler.startElement(XML_URI, "", "removed", this.attr);
        }
        catch (SAXException se) {
            throw new DiffException(se);
        }
    }

    public void classRemoved(ClassInfo info) throws DiffException {
        try {
            this.writeClassInfo(info);
        }
        catch (SAXException se) {
            throw new DiffException(se);
        }
    }

    public void endRemoved() throws DiffException {
        try {
            this.handler.endElement(XML_URI, "", "removed");
        }
        catch (SAXException se) {
            throw new DiffException(se);
        }
    }

    public void startAdded() throws DiffException {
        try {
            this.handler.startElement(XML_URI, "", "added", this.attr);
        }
        catch (SAXException se) {
            throw new DiffException(se);
        }
    }

    public void classAdded(ClassInfo info) throws DiffException {
        try {
            this.writeClassInfo(info);
        }
        catch (SAXException se) {
            throw new DiffException(se);
        }
    }

    public void endAdded() throws DiffException {
        try {
            this.handler.endElement(XML_URI, "", "added");
        }
        catch (SAXException se) {
            throw new DiffException(se);
        }
    }

    public void startChanged() throws DiffException {
        try {
            this.handler.startElement(XML_URI, "", "changed", this.attr);
        }
        catch (SAXException se) {
            throw new DiffException(se);
        }
    }

    public void startClassChanged(String internalName) throws DiffException {
        try {
            this.attr.addAttribute(XML_URI, "", "name", "CDATA", Tools.getClassName(internalName));
            this.handler.startElement(XML_URI, "", "classchanged", this.attr);
            this.attr.clear();
        }
        catch (SAXException se) {
            throw new DiffException(se);
        }
    }

    public void fieldRemoved(FieldInfo info) throws DiffException {
        try {
            this.writeFieldInfo(info);
        }
        catch (SAXException se) {
            throw new DiffException(se);
        }
    }

    public void methodRemoved(MethodInfo info) throws DiffException {
        try {
            this.writeMethodInfo(info);
        }
        catch (SAXException se) {
            throw new DiffException(se);
        }
    }

    public void fieldAdded(FieldInfo info) throws DiffException {
        try {
            this.writeFieldInfo(info);
        }
        catch (SAXException se) {
            throw new DiffException(se);
        }
    }

    public void methodAdded(MethodInfo info) throws DiffException {
        try {
            this.writeMethodInfo(info);
        }
        catch (SAXException se) {
            throw new DiffException(se);
        }
    }

    public void classChanged(ClassInfo oldInfo, ClassInfo newInfo) throws DiffException {
        try {
            this.handler.startElement(XML_URI, "", "classchange", this.attr);
            this.handler.startElement(XML_URI, "", "from", this.attr);
            this.writeClassInfo(oldInfo);
            this.handler.endElement(XML_URI, "", "from");
            this.handler.startElement(XML_URI, "", "to", this.attr);
            this.writeClassInfo(newInfo);
            this.handler.endElement(XML_URI, "", "to");
            this.handler.endElement(XML_URI, "", "classchange");
        }
        catch (SAXException se) {
            throw new DiffException(se);
        }
    }

    public void fieldChanged(FieldInfo oldInfo, FieldInfo newInfo) throws DiffException {
        try {
            this.handler.startElement(XML_URI, "", "fieldchange", this.attr);
            this.handler.startElement(XML_URI, "", "from", this.attr);
            this.writeFieldInfo(oldInfo);
            this.handler.endElement(XML_URI, "", "from");
            this.handler.startElement(XML_URI, "", "to", this.attr);
            this.writeFieldInfo(newInfo);
            this.handler.endElement(XML_URI, "", "to");
            this.handler.endElement(XML_URI, "", "fieldchange");
        }
        catch (SAXException se) {
            throw new DiffException(se);
        }
    }

    public void methodChanged(MethodInfo oldInfo, MethodInfo newInfo) throws DiffException {
        try {
            this.handler.startElement(XML_URI, "", "methodchange", this.attr);
            this.handler.startElement(XML_URI, "", "from", this.attr);
            this.writeMethodInfo(oldInfo);
            this.handler.endElement(XML_URI, "", "from");
            this.handler.startElement(XML_URI, "", "to", this.attr);
            this.writeMethodInfo(newInfo);
            this.handler.endElement(XML_URI, "", "to");
            this.handler.endElement(XML_URI, "", "methodchange");
        }
        catch (SAXException se) {
            throw new DiffException(se);
        }
    }

    public void endClassChanged() throws DiffException {
        try {
            this.handler.endElement(XML_URI, "", "classchanged");
        }
        catch (SAXException se) {
            throw new DiffException(se);
        }
    }

    public void endChanged() throws DiffException {
        try {
            this.handler.endElement(XML_URI, "", "changed");
        }
        catch (SAXException se) {
            throw new DiffException(se);
        }
    }

    public void endDiff() throws DiffException {
        try {
            this.handler.endElement(XML_URI, "", "diff");
            this.handler.endPrefixMapping("");
            this.handler.endDocument();
        }
        catch (SAXException se) {
            throw new DiffException(se);
        }
    }

    protected void writeClassInfo(ClassInfo info) throws SAXException {
        this.addAccessFlags(info);
        if (info.getName() != null) {
            this.attr.addAttribute(XML_URI, "", "name", "CDATA", Tools.getClassName(info.getName()));
        }
        if (info.getSignature() != null) {
            this.attr.addAttribute(XML_URI, "", "signature", "CDATA", info.getSignature());
        }
        if (info.getSupername() != null) {
            this.attr.addAttribute(XML_URI, "", "superclass", "CDATA", Tools.getClassName(info.getSupername()));
        }
        this.handler.startElement(XML_URI, "", "class", this.attr);
        this.attr.clear();
        String[] interfaces = info.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            this.attr.addAttribute(XML_URI, "", "name", "CDATA", Tools.getClassName(interfaces[i]));
            this.handler.startElement(XML_URI, "", "implements", this.attr);
            this.attr.clear();
            this.handler.endElement(XML_URI, "", "implements");
        }
        this.handler.endElement(XML_URI, "", "class");
    }

    protected void writeMethodInfo(MethodInfo info) throws SAXException {
        String[] exceptions;
        this.addAccessFlags(info);
        if (info.getName() != null) {
            this.attr.addAttribute(XML_URI, "", "name", "CDATA", info.getName());
        }
        if (info.getSignature() != null) {
            this.attr.addAttribute(XML_URI, "", "signature", "CDATA", info.getSignature());
        }
        this.handler.startElement(XML_URI, "", "method", this.attr);
        this.attr.clear();
        if (info.getDesc() != null) {
            this.addMethodNodes(info.getDesc());
        }
        if ((exceptions = info.getExceptions()) != null) {
            for (int i = 0; i < exceptions.length; ++i) {
                this.attr.addAttribute(XML_URI, "", "name", "CDATA", Tools.getClassName(exceptions[i]));
                this.handler.startElement(XML_URI, "", "exception", this.attr);
                this.handler.endElement(XML_URI, "", "exception");
                this.attr.clear();
            }
        }
        this.handler.endElement(XML_URI, "", "method");
    }

    protected void writeFieldInfo(FieldInfo info) throws SAXException {
        this.addAccessFlags(info);
        if (info.getName() != null) {
            this.attr.addAttribute(XML_URI, "", "name", "CDATA", info.getName());
        }
        if (info.getSignature() != null) {
            this.attr.addAttribute(XML_URI, "", "signature", "CDATA", info.getSignature());
        }
        if (info.getValue() != null) {
            this.attr.addAttribute(XML_URI, "", "value", "CDATA", info.getValue().toString());
        }
        this.handler.startElement(XML_URI, "", "field", this.attr);
        this.attr.clear();
        if (info.getDesc() != null) {
            this.addTypeNode(info.getDesc());
        }
        this.handler.endElement(XML_URI, "", "field");
    }

    protected void addAccessFlags(AbstractInfo info) throws SAXException {
        this.attr.addAttribute(XML_URI, "", "access", "CDATA", info.getAccessType());
        if (info.isAbstract()) {
            this.attr.addAttribute(XML_URI, "", "abstract", "CDATA", "yes");
        }
        if (info.isAnnotation()) {
            this.attr.addAttribute(XML_URI, "", "annotation", "CDATA", "yes");
        }
        if (info.isBridge()) {
            this.attr.addAttribute(XML_URI, "", "bridge", "CDATA", "yes");
        }
        if (info.isDeprecated()) {
            this.attr.addAttribute(XML_URI, "", "deprecated", "CDATA", "yes");
        }
        if (info.isEnum()) {
            this.attr.addAttribute(XML_URI, "", "enum", "CDATA", "yes");
        }
        if (info.isFinal()) {
            this.attr.addAttribute(XML_URI, "", "final", "CDATA", "yes");
        }
        if (info.isInterface()) {
            this.attr.addAttribute(XML_URI, "", "interface", "CDATA", "yes");
        }
        if (info.isNative()) {
            this.attr.addAttribute(XML_URI, "", "native", "CDATA", "yes");
        }
        if (info.isStatic()) {
            this.attr.addAttribute(XML_URI, "", "static", "CDATA", "yes");
        }
        if (info.isStrict()) {
            this.attr.addAttribute(XML_URI, "", "strict", "CDATA", "yes");
        }
        if (info.isSuper()) {
            this.attr.addAttribute(XML_URI, "", "super", "CDATA", "yes");
        }
        if (info.isSynchronized()) {
            this.attr.addAttribute(XML_URI, "", "synchronized", "CDATA", "yes");
        }
        if (info.isSynthetic()) {
            this.attr.addAttribute(XML_URI, "", "synthetic", "CDATA", "yes");
        }
        if (info.isTransient()) {
            this.attr.addAttribute(XML_URI, "", "transient", "CDATA", "yes");
        }
        if (info.isVarargs()) {
            this.attr.addAttribute(XML_URI, "", "varargs", "CDATA", "yes");
        }
        if (info.isVolatile()) {
            this.attr.addAttribute(XML_URI, "", "volatile", "CDATA", "yes");
        }
    }

    protected void addMethodNodes(String desc) throws SAXException {
        Type[] args = Type.getArgumentTypes((String)desc);
        Type ret = Type.getReturnType((String)desc);
        this.handler.startElement(XML_URI, "", "arguments", this.attr);
        for (int i = 0; i < args.length; ++i) {
            this.addTypeNode(args[i]);
        }
        this.handler.endElement(XML_URI, "", "arguments");
        this.handler.startElement(XML_URI, "", "return", this.attr);
        this.addTypeNode(ret);
        this.handler.endElement(XML_URI, "", "return");
    }

    protected void addTypeNode(String desc) throws SAXException {
        this.addTypeNode(Type.getType((String)desc));
    }

    protected void addTypeNode(Type type) throws SAXException {
        int i = type.getSort();
        if (i == 9) {
            this.attr.addAttribute(XML_URI, "", "array", "CDATA", "yes");
            this.attr.addAttribute(XML_URI, "", "dimensions", "CDATA", "" + type.getDimensions());
            type = type.getElementType();
            i = type.getSort();
        }
        switch (i) {
            case 1: {
                this.attr.addAttribute(XML_URI, "", "primitive", "CDATA", "yes");
                this.attr.addAttribute(XML_URI, "", "name", "CDATA", "boolean");
                break;
            }
            case 3: {
                this.attr.addAttribute(XML_URI, "", "primitive", "CDATA", "yes");
                this.attr.addAttribute(XML_URI, "", "name", "CDATA", "byte");
                break;
            }
            case 2: {
                this.attr.addAttribute(XML_URI, "", "primitive", "CDATA", "yes");
                this.attr.addAttribute(XML_URI, "", "name", "CDATA", "char");
                break;
            }
            case 8: {
                this.attr.addAttribute(XML_URI, "", "primitive", "CDATA", "yes");
                this.attr.addAttribute(XML_URI, "", "name", "CDATA", "double");
                break;
            }
            case 6: {
                this.attr.addAttribute(XML_URI, "", "primitive", "CDATA", "yes");
                this.attr.addAttribute(XML_URI, "", "name", "CDATA", "float");
                break;
            }
            case 5: {
                this.attr.addAttribute(XML_URI, "", "primitive", "CDATA", "yes");
                this.attr.addAttribute(XML_URI, "", "name", "CDATA", "int");
                break;
            }
            case 7: {
                this.attr.addAttribute(XML_URI, "", "primitive", "CDATA", "yes");
                this.attr.addAttribute(XML_URI, "", "name", "CDATA", "long");
                break;
            }
            case 10: {
                this.attr.addAttribute(XML_URI, "", "name", "CDATA", Tools.getClassName(type.getInternalName()));
                break;
            }
            case 4: {
                this.attr.addAttribute(XML_URI, "", "primitive", "CDATA", "yes");
                this.attr.addAttribute(XML_URI, "", "name", "CDATA", "short");
                break;
            }
            case 0: {
                this.attr.addAttribute(XML_URI, "", "primitive", "CDATA", "yes");
                this.attr.addAttribute(XML_URI, "", "name", "CDATA", "void");
            }
        }
        this.handler.startElement(XML_URI, "", "type", this.attr);
        this.handler.endElement(XML_URI, "", "type");
        this.attr.clear();
    }
}

