
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2023 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQTimeLine.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QTimeLine>
#include <QChildEvent>
#include <QEasingCurve>
#include <QEvent>
#include <QObject>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtCoreCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QTimeLine

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QTimeLine::staticMetaObject);
}


// int QTimeLine::currentFrame()


static void _init_f_currentFrame_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_currentFrame_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QTimeLine *)cls)->currentFrame ());
}


// int QTimeLine::currentTime()


static void _init_f_currentTime_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_currentTime_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QTimeLine *)cls)->currentTime ());
}


// double QTimeLine::currentValue()


static void _init_f_currentValue_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_currentValue_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QTimeLine *)cls)->currentValue ());
}


// QTimeLine::CurveShape QTimeLine::curveShape()


static void _init_f_curveShape_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QTimeLine::CurveShape>::target_type > ();
}

static void _call_f_curveShape_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QTimeLine::CurveShape>::target_type > ((qt_gsi::Converter<QTimeLine::CurveShape>::target_type)qt_gsi::CppToQtAdaptor<QTimeLine::CurveShape>(((QTimeLine *)cls)->curveShape ()));
}


// QTimeLine::Direction QTimeLine::direction()


static void _init_f_direction_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QTimeLine::Direction>::target_type > ();
}

static void _call_f_direction_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QTimeLine::Direction>::target_type > ((qt_gsi::Converter<QTimeLine::Direction>::target_type)qt_gsi::CppToQtAdaptor<QTimeLine::Direction>(((QTimeLine *)cls)->direction ()));
}


// int QTimeLine::duration()


static void _init_f_duration_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_duration_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QTimeLine *)cls)->duration ());
}


// QEasingCurve QTimeLine::easingCurve()


static void _init_f_easingCurve_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QEasingCurve > ();
}

static void _call_f_easingCurve_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QEasingCurve > ((QEasingCurve)((QTimeLine *)cls)->easingCurve ());
}


// int QTimeLine::endFrame()


static void _init_f_endFrame_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_endFrame_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QTimeLine *)cls)->endFrame ());
}


// int QTimeLine::frameForTime(int msec)


static void _init_f_frameForTime_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("msec");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_frameForTime_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<int > ((int)((QTimeLine *)cls)->frameForTime (arg1));
}


// int QTimeLine::loopCount()


static void _init_f_loopCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_loopCount_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QTimeLine *)cls)->loopCount ());
}


// void QTimeLine::resume()


static void _init_f_resume_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_resume_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTimeLine *)cls)->resume ();
}


// void QTimeLine::setCurrentTime(int msec)


static void _init_f_setCurrentTime_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("msec");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCurrentTime_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTimeLine *)cls)->setCurrentTime (arg1);
}


// void QTimeLine::setCurveShape(QTimeLine::CurveShape shape)


static void _init_f_setCurveShape_2438 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("shape");
  decl->add_arg<const qt_gsi::Converter<QTimeLine::CurveShape>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCurveShape_2438 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QTimeLine::CurveShape>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QTimeLine::CurveShape>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTimeLine *)cls)->setCurveShape (qt_gsi::QtToCppAdaptor<QTimeLine::CurveShape>(arg1).cref());
}


// void QTimeLine::setDirection(QTimeLine::Direction direction)


static void _init_f_setDirection_2353 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("direction");
  decl->add_arg<const qt_gsi::Converter<QTimeLine::Direction>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDirection_2353 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QTimeLine::Direction>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QTimeLine::Direction>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTimeLine *)cls)->setDirection (qt_gsi::QtToCppAdaptor<QTimeLine::Direction>(arg1).cref());
}


// void QTimeLine::setDuration(int duration)


static void _init_f_setDuration_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("duration");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDuration_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTimeLine *)cls)->setDuration (arg1);
}


// void QTimeLine::setEasingCurve(const QEasingCurve &curve)


static void _init_f_setEasingCurve_2510 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("curve");
  decl->add_arg<const QEasingCurve & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setEasingCurve_2510 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QEasingCurve &arg1 = gsi::arg_reader<const QEasingCurve & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTimeLine *)cls)->setEasingCurve (arg1);
}


// void QTimeLine::setEndFrame(int frame)


static void _init_f_setEndFrame_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("frame");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setEndFrame_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTimeLine *)cls)->setEndFrame (arg1);
}


// void QTimeLine::setFrameRange(int startFrame, int endFrame)


static void _init_f_setFrameRange_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("startFrame");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("endFrame");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setFrameRange_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTimeLine *)cls)->setFrameRange (arg1, arg2);
}


// void QTimeLine::setLoopCount(int count)


static void _init_f_setLoopCount_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("count");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setLoopCount_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTimeLine *)cls)->setLoopCount (arg1);
}


// void QTimeLine::setPaused(bool paused)


static void _init_f_setPaused_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("paused");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPaused_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTimeLine *)cls)->setPaused (arg1);
}


// void QTimeLine::setStartFrame(int frame)


static void _init_f_setStartFrame_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("frame");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStartFrame_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTimeLine *)cls)->setStartFrame (arg1);
}


// void QTimeLine::setUpdateInterval(int interval)


static void _init_f_setUpdateInterval_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("interval");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setUpdateInterval_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTimeLine *)cls)->setUpdateInterval (arg1);
}


// void QTimeLine::start()


static void _init_f_start_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_start_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTimeLine *)cls)->start ();
}


// int QTimeLine::startFrame()


static void _init_f_startFrame_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_startFrame_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QTimeLine *)cls)->startFrame ());
}


// QTimeLine::State QTimeLine::state()


static void _init_f_state_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QTimeLine::State>::target_type > ();
}

static void _call_f_state_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QTimeLine::State>::target_type > ((qt_gsi::Converter<QTimeLine::State>::target_type)qt_gsi::CppToQtAdaptor<QTimeLine::State>(((QTimeLine *)cls)->state ()));
}


// void QTimeLine::stop()


static void _init_f_stop_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_stop_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTimeLine *)cls)->stop ();
}


// void QTimeLine::toggleDirection()


static void _init_f_toggleDirection_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_toggleDirection_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTimeLine *)cls)->toggleDirection ();
}


// int QTimeLine::updateInterval()


static void _init_f_updateInterval_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_updateInterval_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QTimeLine *)cls)->updateInterval ());
}


// double QTimeLine::valueForTime(int msec)


static void _init_f_valueForTime_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("msec");
  decl->add_arg<int > (argspec_0);
  decl->set_return<double > ();
}

static void _call_f_valueForTime_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<double > ((double)((QTimeLine *)cls)->valueForTime (arg1));
}


// static QString QTimeLine::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (0, heap);
  ret.write<QString > ((QString)QTimeLine::tr (arg1, arg2));
}


// static QString QTimeLine::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = gsi::arg_reader<const char * >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ret.write<QString > ((QString)QTimeLine::tr (arg1, arg2, arg3));
}


// static QString QTimeLine::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (0, heap);
  ret.write<QString > ((QString)QTimeLine::trUtf8 (arg1, arg2));
}


// static QString QTimeLine::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = gsi::arg_reader<const char * >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ret.write<QString > ((QString)QTimeLine::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QTimeLine () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("currentFrame", "@brief Method int QTimeLine::currentFrame()\n", true, &_init_f_currentFrame_c0, &_call_f_currentFrame_c0);
  methods += new qt_gsi::GenericMethod (":currentTime", "@brief Method int QTimeLine::currentTime()\n", true, &_init_f_currentTime_c0, &_call_f_currentTime_c0);
  methods += new qt_gsi::GenericMethod ("currentValue", "@brief Method double QTimeLine::currentValue()\n", true, &_init_f_currentValue_c0, &_call_f_currentValue_c0);
  methods += new qt_gsi::GenericMethod (":curveShape", "@brief Method QTimeLine::CurveShape QTimeLine::curveShape()\n", true, &_init_f_curveShape_c0, &_call_f_curveShape_c0);
  methods += new qt_gsi::GenericMethod (":direction", "@brief Method QTimeLine::Direction QTimeLine::direction()\n", true, &_init_f_direction_c0, &_call_f_direction_c0);
  methods += new qt_gsi::GenericMethod (":duration", "@brief Method int QTimeLine::duration()\n", true, &_init_f_duration_c0, &_call_f_duration_c0);
  methods += new qt_gsi::GenericMethod (":easingCurve", "@brief Method QEasingCurve QTimeLine::easingCurve()\n", true, &_init_f_easingCurve_c0, &_call_f_easingCurve_c0);
  methods += new qt_gsi::GenericMethod (":endFrame", "@brief Method int QTimeLine::endFrame()\n", true, &_init_f_endFrame_c0, &_call_f_endFrame_c0);
  methods += new qt_gsi::GenericMethod ("frameForTime", "@brief Method int QTimeLine::frameForTime(int msec)\n", true, &_init_f_frameForTime_c767, &_call_f_frameForTime_c767);
  methods += new qt_gsi::GenericMethod (":loopCount", "@brief Method int QTimeLine::loopCount()\n", true, &_init_f_loopCount_c0, &_call_f_loopCount_c0);
  methods += new qt_gsi::GenericMethod ("resume", "@brief Method void QTimeLine::resume()\n", false, &_init_f_resume_0, &_call_f_resume_0);
  methods += new qt_gsi::GenericMethod ("setCurrentTime|currentTime=", "@brief Method void QTimeLine::setCurrentTime(int msec)\n", false, &_init_f_setCurrentTime_767, &_call_f_setCurrentTime_767);
  methods += new qt_gsi::GenericMethod ("setCurveShape|curveShape=", "@brief Method void QTimeLine::setCurveShape(QTimeLine::CurveShape shape)\n", false, &_init_f_setCurveShape_2438, &_call_f_setCurveShape_2438);
  methods += new qt_gsi::GenericMethod ("setDirection|direction=", "@brief Method void QTimeLine::setDirection(QTimeLine::Direction direction)\n", false, &_init_f_setDirection_2353, &_call_f_setDirection_2353);
  methods += new qt_gsi::GenericMethod ("setDuration|duration=", "@brief Method void QTimeLine::setDuration(int duration)\n", false, &_init_f_setDuration_767, &_call_f_setDuration_767);
  methods += new qt_gsi::GenericMethod ("setEasingCurve|easingCurve=", "@brief Method void QTimeLine::setEasingCurve(const QEasingCurve &curve)\n", false, &_init_f_setEasingCurve_2510, &_call_f_setEasingCurve_2510);
  methods += new qt_gsi::GenericMethod ("setEndFrame|endFrame=", "@brief Method void QTimeLine::setEndFrame(int frame)\n", false, &_init_f_setEndFrame_767, &_call_f_setEndFrame_767);
  methods += new qt_gsi::GenericMethod ("setFrameRange", "@brief Method void QTimeLine::setFrameRange(int startFrame, int endFrame)\n", false, &_init_f_setFrameRange_1426, &_call_f_setFrameRange_1426);
  methods += new qt_gsi::GenericMethod ("setLoopCount|loopCount=", "@brief Method void QTimeLine::setLoopCount(int count)\n", false, &_init_f_setLoopCount_767, &_call_f_setLoopCount_767);
  methods += new qt_gsi::GenericMethod ("setPaused", "@brief Method void QTimeLine::setPaused(bool paused)\n", false, &_init_f_setPaused_864, &_call_f_setPaused_864);
  methods += new qt_gsi::GenericMethod ("setStartFrame|startFrame=", "@brief Method void QTimeLine::setStartFrame(int frame)\n", false, &_init_f_setStartFrame_767, &_call_f_setStartFrame_767);
  methods += new qt_gsi::GenericMethod ("setUpdateInterval|updateInterval=", "@brief Method void QTimeLine::setUpdateInterval(int interval)\n", false, &_init_f_setUpdateInterval_767, &_call_f_setUpdateInterval_767);
  methods += new qt_gsi::GenericMethod ("start", "@brief Method void QTimeLine::start()\n", false, &_init_f_start_0, &_call_f_start_0);
  methods += new qt_gsi::GenericMethod (":startFrame", "@brief Method int QTimeLine::startFrame()\n", true, &_init_f_startFrame_c0, &_call_f_startFrame_c0);
  methods += new qt_gsi::GenericMethod ("state", "@brief Method QTimeLine::State QTimeLine::state()\n", true, &_init_f_state_c0, &_call_f_state_c0);
  methods += new qt_gsi::GenericMethod ("stop", "@brief Method void QTimeLine::stop()\n", false, &_init_f_stop_0, &_call_f_stop_0);
  methods += new qt_gsi::GenericMethod ("toggleDirection", "@brief Method void QTimeLine::toggleDirection()\n", false, &_init_f_toggleDirection_0, &_call_f_toggleDirection_0);
  methods += new qt_gsi::GenericMethod (":updateInterval", "@brief Method int QTimeLine::updateInterval()\n", true, &_init_f_updateInterval_c0, &_call_f_updateInterval_c0);
  methods += new qt_gsi::GenericMethod ("valueForTime", "@brief Method double QTimeLine::valueForTime(int msec)\n", true, &_init_f_valueForTime_c767, &_call_f_valueForTime_c767);
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QTimeLine::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("finished()", "finished", "@brief Signal declaration for QTimeLine::finished()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("frameChanged(int)", "frameChanged", gsi::arg("arg1"), "@brief Signal declaration for QTimeLine::frameChanged(int)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<QTimeLine::State>::target_type & > ("stateChanged(QTimeLine::State)", "stateChanged", gsi::arg("newState"), "@brief Signal declaration for QTimeLine::stateChanged(QTimeLine::State newState)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<double > ("valueChanged(double)", "valueChanged", gsi::arg("x"), "@brief Signal declaration for QTimeLine::valueChanged(double x)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QTimeLine::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QTimeLine::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QTimeLine::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QTimeLine::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QObject> &qtdecl_QObject ();

qt_gsi::QtNativeClass<QTimeLine> decl_QTimeLine (qtdecl_QObject (), "QtCore", "QTimeLine_Native",
  methods_QTimeLine (),
  "@hide\n@alias QTimeLine");

GSI_QTCORE_PUBLIC gsi::Class<QTimeLine> &qtdecl_QTimeLine () { return decl_QTimeLine; }

}


class QTimeLine_Adaptor : public QTimeLine, public qt_gsi::QtObjectBase
{
public:

  virtual ~QTimeLine_Adaptor();

  //  [adaptor ctor] QTimeLine::QTimeLine(int duration, QObject *parent)
  QTimeLine_Adaptor() : QTimeLine()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QTimeLine::QTimeLine(int duration, QObject *parent)
  QTimeLine_Adaptor(int duration) : QTimeLine(duration)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QTimeLine::QTimeLine(int duration, QObject *parent)
  QTimeLine_Adaptor(int duration, QObject *parent) : QTimeLine(duration, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] int QTimeLine::receivers(const char *signal)
  int fp_QTimeLine_receivers_c1731 (const char *signal) const {
    return QTimeLine::receivers(signal);
  }

  //  [expose] QObject *QTimeLine::sender()
  QObject * fp_QTimeLine_sender_c0 () const {
    return QTimeLine::sender();
  }

  //  [adaptor impl] bool QTimeLine::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QTimeLine::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QTimeLine_Adaptor, bool, QEvent *>(&QTimeLine_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QTimeLine::event(arg1);
    }
  }

  //  [adaptor impl] bool QTimeLine::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QTimeLine::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QTimeLine_Adaptor, bool, QObject *, QEvent *>(&QTimeLine_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QTimeLine::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] double QTimeLine::valueForTime(int msec)
  double cbs_valueForTime_c767_0(int msec) const
  {
    return QTimeLine::valueForTime(msec);
  }

  virtual double valueForTime(int msec) const
  {
    if (cb_valueForTime_c767_0.can_issue()) {
      return cb_valueForTime_c767_0.issue<QTimeLine_Adaptor, double, int>(&QTimeLine_Adaptor::cbs_valueForTime_c767_0, msec);
    } else {
      return QTimeLine::valueForTime(msec);
    }
  }

  //  [adaptor impl] void QTimeLine::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QTimeLine::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QTimeLine_Adaptor, QChildEvent *>(&QTimeLine_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QTimeLine::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QTimeLine::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QTimeLine::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QTimeLine_Adaptor, QEvent *>(&QTimeLine_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QTimeLine::customEvent(arg1);
    }
  }

  //  [emitter impl] void QTimeLine::destroyed(QObject *)
  void emitter_QTimeLine_destroyed_1302(QObject *arg1)
  {
    emit QTimeLine::destroyed(arg1);
  }

  //  [adaptor impl] void QTimeLine::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QTimeLine::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QTimeLine_Adaptor, const char *>(&QTimeLine_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QTimeLine::disconnectNotify(signal);
    }
  }

  //  [emitter impl] void QTimeLine::finished()
  void emitter_QTimeLine_finished_0()
  {
    emit QTimeLine::finished();
  }

  //  [emitter impl] void QTimeLine::frameChanged(int)
  void emitter_QTimeLine_frameChanged_767(int arg1)
  {
    emit QTimeLine::frameChanged(arg1);
  }

  //  [emitter impl] void QTimeLine::stateChanged(QTimeLine::State newState)
  void emitter_QTimeLine_stateChanged_1937(QTimeLine::State newState)
  {
    emit QTimeLine::stateChanged(newState);
  }

  //  [adaptor impl] void QTimeLine::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QTimeLine::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QTimeLine_Adaptor, QTimerEvent *>(&QTimeLine_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QTimeLine::timerEvent(event);
    }
  }

  //  [emitter impl] void QTimeLine::valueChanged(double x)
  void emitter_QTimeLine_valueChanged_1071(double x)
  {
    emit QTimeLine::valueChanged(x);
  }

  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_valueForTime_c767_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QTimeLine_Adaptor::~QTimeLine_Adaptor() { }

//  Constructor QTimeLine::QTimeLine(int duration, QObject *parent) (adaptor class)

static void _init_ctor_QTimeLine_Adaptor_1961 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("duration", true, "1000");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_1);
  decl->set_return_new<QTimeLine_Adaptor> ();
}

static void _call_ctor_QTimeLine_Adaptor_1961 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (1000, heap);
  QObject *arg2 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ret.write<QTimeLine_Adaptor *> (new QTimeLine_Adaptor (arg1, arg2));
}


// void QTimeLine::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTimeLine_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeLine_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QTimeLine::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTimeLine_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeLine_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QTimeLine::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ((QTimeLine_Adaptor *)cls)->emitter_QTimeLine_destroyed_1302 (arg1);
}


// void QTimeLine::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTimeLine_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeLine_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}


// bool QTimeLine::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QTimeLine_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeLine_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QTimeLine::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QTimeLine_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeLine_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// emitter void QTimeLine::finished()

static void _init_emitter_finished_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_finished_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QTimeLine_Adaptor *)cls)->emitter_QTimeLine_finished_0 ();
}


// emitter void QTimeLine::frameChanged(int)

static void _init_emitter_frameChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_frameChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QTimeLine_Adaptor *)cls)->emitter_QTimeLine_frameChanged_767 (arg1);
}


// exposed int QTimeLine::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QTimeLine_Adaptor *)cls)->fp_QTimeLine_receivers_c1731 (arg1));
}


// exposed QObject *QTimeLine::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QTimeLine_Adaptor *)cls)->fp_QTimeLine_sender_c0 ());
}


// emitter void QTimeLine::stateChanged(QTimeLine::State newState)

static void _init_emitter_stateChanged_1937 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("newState");
  decl->add_arg<const qt_gsi::Converter<QTimeLine::State>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_stateChanged_1937 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QTimeLine::State>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QTimeLine::State>::target_type & >() (args, heap);
  ((QTimeLine_Adaptor *)cls)->emitter_QTimeLine_stateChanged_1937 (arg1);
}


// void QTimeLine::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTimeLine_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeLine_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// emitter void QTimeLine::valueChanged(double x)

static void _init_emitter_valueChanged_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_valueChanged_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  ((QTimeLine_Adaptor *)cls)->emitter_QTimeLine_valueChanged_1071 (arg1);
}


// double QTimeLine::valueForTime(int msec)

static void _init_cbs_valueForTime_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("msec");
  decl->add_arg<int > (argspec_0);
  decl->set_return<double > ();
}

static void _call_cbs_valueForTime_c767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<double > ((double)((QTimeLine_Adaptor *)cls)->cbs_valueForTime_c767_0 (arg1));
}

static void _set_callback_cbs_valueForTime_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeLine_Adaptor *)cls)->cb_valueForTime_c767_0 = cb;
}


namespace gsi
{

gsi::Class<QTimeLine> &qtdecl_QTimeLine ();

static gsi::Methods methods_QTimeLine_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QTimeLine::QTimeLine(int duration, QObject *parent)\nThis method creates an object of class QTimeLine.", &_init_ctor_QTimeLine_Adaptor_1961, &_call_ctor_QTimeLine_Adaptor_1961);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QTimeLine::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QTimeLine::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QTimeLine::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QTimeLine::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QTimeLine::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QTimeLine::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("emit_finished", "@brief Emitter for signal void QTimeLine::finished()\nCall this method to emit this signal.", false, &_init_emitter_finished_0, &_call_emitter_finished_0);
  methods += new qt_gsi::GenericMethod ("emit_frameChanged", "@brief Emitter for signal void QTimeLine::frameChanged(int)\nCall this method to emit this signal.", false, &_init_emitter_frameChanged_767, &_call_emitter_frameChanged_767);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QTimeLine::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QTimeLine::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("emit_stateChanged", "@brief Emitter for signal void QTimeLine::stateChanged(QTimeLine::State newState)\nCall this method to emit this signal.", false, &_init_emitter_stateChanged_1937, &_call_emitter_stateChanged_1937);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QTimeLine::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("emit_valueChanged", "@brief Emitter for signal void QTimeLine::valueChanged(double x)\nCall this method to emit this signal.", false, &_init_emitter_valueChanged_1071, &_call_emitter_valueChanged_1071);
  methods += new qt_gsi::GenericMethod ("valueForTime", "@brief Virtual method double QTimeLine::valueForTime(int msec)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_valueForTime_c767_0, &_call_cbs_valueForTime_c767_0);
  methods += new qt_gsi::GenericMethod ("valueForTime", "@hide", true, &_init_cbs_valueForTime_c767_0, &_call_cbs_valueForTime_c767_0, &_set_callback_cbs_valueForTime_c767_0);
  return methods;
}

gsi::Class<QTimeLine_Adaptor> decl_QTimeLine_Adaptor (qtdecl_QTimeLine (), "QtCore", "QTimeLine",
  methods_QTimeLine_Adaptor (),
  "@qt\n@brief Binding of QTimeLine");

}


//  Implementation of the enum wrapper class for QTimeLine::CurveShape
namespace qt_gsi
{

static gsi::Enum<QTimeLine::CurveShape> decl_QTimeLine_CurveShape_Enum ("QtCore", "QTimeLine_CurveShape",
    gsi::enum_const ("EaseInCurve", QTimeLine::EaseInCurve, "@brief Enum constant QTimeLine::EaseInCurve") +
    gsi::enum_const ("EaseOutCurve", QTimeLine::EaseOutCurve, "@brief Enum constant QTimeLine::EaseOutCurve") +
    gsi::enum_const ("EaseInOutCurve", QTimeLine::EaseInOutCurve, "@brief Enum constant QTimeLine::EaseInOutCurve") +
    gsi::enum_const ("LinearCurve", QTimeLine::LinearCurve, "@brief Enum constant QTimeLine::LinearCurve") +
    gsi::enum_const ("SineCurve", QTimeLine::SineCurve, "@brief Enum constant QTimeLine::SineCurve") +
    gsi::enum_const ("CosineCurve", QTimeLine::CosineCurve, "@brief Enum constant QTimeLine::CosineCurve"),
  "@qt\n@brief This class represents the QTimeLine::CurveShape enum");

static gsi::QFlagsClass<QTimeLine::CurveShape > decl_QTimeLine_CurveShape_Enums ("QtCore", "QTimeLine_QFlags_CurveShape",
  "@qt\n@brief This class represents the QFlags<QTimeLine::CurveShape> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QTimeLine> inject_QTimeLine_CurveShape_Enum_in_parent (decl_QTimeLine_CurveShape_Enum.defs ());
static gsi::ClassExt<QTimeLine> decl_QTimeLine_CurveShape_Enum_as_child (decl_QTimeLine_CurveShape_Enum, "CurveShape");
static gsi::ClassExt<QTimeLine> decl_QTimeLine_CurveShape_Enums_as_child (decl_QTimeLine_CurveShape_Enums, "QFlags_CurveShape");

}


//  Implementation of the enum wrapper class for QTimeLine::Direction
namespace qt_gsi
{

static gsi::Enum<QTimeLine::Direction> decl_QTimeLine_Direction_Enum ("QtCore", "QTimeLine_Direction",
    gsi::enum_const ("Forward", QTimeLine::Forward, "@brief Enum constant QTimeLine::Forward") +
    gsi::enum_const ("Backward", QTimeLine::Backward, "@brief Enum constant QTimeLine::Backward"),
  "@qt\n@brief This class represents the QTimeLine::Direction enum");

static gsi::QFlagsClass<QTimeLine::Direction > decl_QTimeLine_Direction_Enums ("QtCore", "QTimeLine_QFlags_Direction",
  "@qt\n@brief This class represents the QFlags<QTimeLine::Direction> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QTimeLine> inject_QTimeLine_Direction_Enum_in_parent (decl_QTimeLine_Direction_Enum.defs ());
static gsi::ClassExt<QTimeLine> decl_QTimeLine_Direction_Enum_as_child (decl_QTimeLine_Direction_Enum, "Direction");
static gsi::ClassExt<QTimeLine> decl_QTimeLine_Direction_Enums_as_child (decl_QTimeLine_Direction_Enums, "QFlags_Direction");

}


//  Implementation of the enum wrapper class for QTimeLine::State
namespace qt_gsi
{

static gsi::Enum<QTimeLine::State> decl_QTimeLine_State_Enum ("QtCore", "QTimeLine_State",
    gsi::enum_const ("NotRunning", QTimeLine::NotRunning, "@brief Enum constant QTimeLine::NotRunning") +
    gsi::enum_const ("Paused", QTimeLine::Paused, "@brief Enum constant QTimeLine::Paused") +
    gsi::enum_const ("Running", QTimeLine::Running, "@brief Enum constant QTimeLine::Running"),
  "@qt\n@brief This class represents the QTimeLine::State enum");

static gsi::QFlagsClass<QTimeLine::State > decl_QTimeLine_State_Enums ("QtCore", "QTimeLine_QFlags_State",
  "@qt\n@brief This class represents the QFlags<QTimeLine::State> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QTimeLine> inject_QTimeLine_State_Enum_in_parent (decl_QTimeLine_State_Enum.defs ());
static gsi::ClassExt<QTimeLine> decl_QTimeLine_State_Enum_as_child (decl_QTimeLine_State_Enum, "State");
static gsi::ClassExt<QTimeLine> decl_QTimeLine_State_Enums_as_child (decl_QTimeLine_State_Enums, "QFlags_State");

}

