
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2023 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQFileOpenEvent.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QFileOpenEvent>
#include <QFile>
#include <QUrl>
#include "gsiQt.h"
#include "gsiQtGuiCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QFileOpenEvent

// QString QFileOpenEvent::file()


static void _init_f_file_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_file_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QFileOpenEvent *)cls)->file ());
}


// bool QFileOpenEvent::openFile(QFile &file, QFlags<QIODeviceBase::OpenModeFlag> flags)


static void _init_f_openFile_c4596 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("file");
  decl->add_arg<QFile & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("flags");
  decl->add_arg<QFlags<QIODeviceBase::OpenModeFlag> > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_openFile_c4596 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFile &arg1 = gsi::arg_reader<QFile & >() (args, heap);
  QFlags<QIODeviceBase::OpenModeFlag> arg2 = gsi::arg_reader<QFlags<QIODeviceBase::OpenModeFlag> >() (args, heap);
  ret.write<bool > ((bool)((QFileOpenEvent *)cls)->openFile (arg1, arg2));
}


// QUrl QFileOpenEvent::url()


static void _init_f_url_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QUrl > ();
}

static void _call_f_url_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QUrl > ((QUrl)((QFileOpenEvent *)cls)->url ());
}


namespace gsi
{

static gsi::Methods methods_QFileOpenEvent () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericMethod ("file", "@brief Method QString QFileOpenEvent::file()\n", true, &_init_f_file_c0, &_call_f_file_c0);
  methods += new qt_gsi::GenericMethod ("openFile", "@brief Method bool QFileOpenEvent::openFile(QFile &file, QFlags<QIODeviceBase::OpenModeFlag> flags)\n", true, &_init_f_openFile_c4596, &_call_f_openFile_c4596);
  methods += new qt_gsi::GenericMethod ("url", "@brief Method QUrl QFileOpenEvent::url()\n", true, &_init_f_url_c0, &_call_f_url_c0);
  return methods;
}

gsi::Class<QEvent> &qtdecl_QEvent ();

gsi::Class<QFileOpenEvent> decl_QFileOpenEvent (qtdecl_QEvent (), "QtGui", "QFileOpenEvent_Native",
  methods_QFileOpenEvent (),
  "@hide\n@alias QFileOpenEvent");

GSI_QTGUI_PUBLIC gsi::Class<QFileOpenEvent> &qtdecl_QFileOpenEvent () { return decl_QFileOpenEvent; }

}


class QFileOpenEvent_Adaptor : public QFileOpenEvent, public qt_gsi::QtObjectBase
{
public:

  virtual ~QFileOpenEvent_Adaptor();

  //  [adaptor ctor] QFileOpenEvent::QFileOpenEvent(const QString &file)
  QFileOpenEvent_Adaptor(const QString &file) : QFileOpenEvent(file)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QFileOpenEvent::QFileOpenEvent(const QUrl &url)
  QFileOpenEvent_Adaptor(const QUrl &url) : QFileOpenEvent(url)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor impl] void QFileOpenEvent::setAccepted(bool accepted)
  void cbs_setAccepted_864_0(bool accepted)
  {
    QFileOpenEvent::setAccepted(accepted);
  }

  virtual void setAccepted(bool accepted)
  {
    if (cb_setAccepted_864_0.can_issue()) {
      cb_setAccepted_864_0.issue<QFileOpenEvent_Adaptor, bool>(&QFileOpenEvent_Adaptor::cbs_setAccepted_864_0, accepted);
    } else {
      QFileOpenEvent::setAccepted(accepted);
    }
  }

  gsi::Callback cb_setAccepted_864_0;
};

QFileOpenEvent_Adaptor::~QFileOpenEvent_Adaptor() { }

//  Constructor QFileOpenEvent::QFileOpenEvent(const QString &file) (adaptor class)

static void _init_ctor_QFileOpenEvent_Adaptor_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("file");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return_new<QFileOpenEvent_Adaptor> ();
}

static void _call_ctor_QFileOpenEvent_Adaptor_2025 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QFileOpenEvent_Adaptor *> (new QFileOpenEvent_Adaptor (arg1));
}


//  Constructor QFileOpenEvent::QFileOpenEvent(const QUrl &url) (adaptor class)

static void _init_ctor_QFileOpenEvent_Adaptor_1701 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("url");
  decl->add_arg<const QUrl & > (argspec_0);
  decl->set_return_new<QFileOpenEvent_Adaptor> ();
}

static void _call_ctor_QFileOpenEvent_Adaptor_1701 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QUrl &arg1 = gsi::arg_reader<const QUrl & >() (args, heap);
  ret.write<QFileOpenEvent_Adaptor *> (new QFileOpenEvent_Adaptor (arg1));
}


// void QFileOpenEvent::setAccepted(bool accepted)

static void _init_cbs_setAccepted_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("accepted");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setAccepted_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileOpenEvent_Adaptor *)cls)->cbs_setAccepted_864_0 (arg1);
}

static void _set_callback_cbs_setAccepted_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileOpenEvent_Adaptor *)cls)->cb_setAccepted_864_0 = cb;
}


namespace gsi
{

gsi::Class<QFileOpenEvent> &qtdecl_QFileOpenEvent ();

static gsi::Methods methods_QFileOpenEvent_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QFileOpenEvent::QFileOpenEvent(const QString &file)\nThis method creates an object of class QFileOpenEvent.", &_init_ctor_QFileOpenEvent_Adaptor_2025, &_call_ctor_QFileOpenEvent_Adaptor_2025);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QFileOpenEvent::QFileOpenEvent(const QUrl &url)\nThis method creates an object of class QFileOpenEvent.", &_init_ctor_QFileOpenEvent_Adaptor_1701, &_call_ctor_QFileOpenEvent_Adaptor_1701);
  methods += new qt_gsi::GenericMethod ("setAccepted", "@brief Virtual method void QFileOpenEvent::setAccepted(bool accepted)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setAccepted_864_0, &_call_cbs_setAccepted_864_0);
  methods += new qt_gsi::GenericMethod ("setAccepted", "@hide", false, &_init_cbs_setAccepted_864_0, &_call_cbs_setAccepted_864_0, &_set_callback_cbs_setAccepted_864_0);
  return methods;
}

gsi::Class<QFileOpenEvent_Adaptor> decl_QFileOpenEvent_Adaptor (qtdecl_QFileOpenEvent (), "QtGui", "QFileOpenEvent",
  methods_QFileOpenEvent_Adaptor (),
  "@qt\n@brief Binding of QFileOpenEvent");

}

