type -'a obj

module VariantType = struct
  external value: [>`gvarianttype] obj -> [<`gvarianttype] obj = "ml_g_variant_type_value"
  external peek_string: [>`gvarianttype] obj -> string = "ml_g_variant_type_peek_string"
  external next: [>`gvarianttype] obj -> [<`gvarianttype] obj = "ml_g_variant_type_next"
  external new_maybe: [>`gvarianttype] obj -> [<`gvarianttype] obj = "ml_g_variant_type_new_maybe"
  external new_dict_entry: [>`gvarianttype] obj -> [>`gvarianttype] obj -> [<`gvarianttype] obj = "ml_g_variant_type_new_dict_entry"
  external new_array: [>`gvarianttype] obj -> [<`gvarianttype] obj = "ml_g_variant_type_new_array"
  external n_items: [>`gvarianttype] obj -> int = "ml_g_variant_type_n_items"
  external key: [>`gvarianttype] obj -> [<`gvarianttype] obj = "ml_g_variant_type_key"
  external is_variant: [>`gvarianttype] obj -> bool = "ml_g_variant_type_is_variant"
  external is_tuple: [>`gvarianttype] obj -> bool = "ml_g_variant_type_is_tuple"
  external is_subtype_of: [>`gvarianttype] obj -> [>`gvarianttype] obj -> bool = "ml_g_variant_type_is_subtype_of"
  external is_maybe: [>`gvarianttype] obj -> bool = "ml_g_variant_type_is_maybe"
  external is_dict_entry: [>`gvarianttype] obj -> bool = "ml_g_variant_type_is_dict_entry"
  external is_definite: [>`gvarianttype] obj -> bool = "ml_g_variant_type_is_definite"
  external is_container: [>`gvarianttype] obj -> bool = "ml_g_variant_type_is_container"
  external is_basic: [>`gvarianttype] obj -> bool = "ml_g_variant_type_is_basic"
  external is_array: [>`gvarianttype] obj -> bool = "ml_g_variant_type_is_array"
  external get_string_length: [>`gvarianttype] obj -> int = "ml_g_variant_type_get_string_length"
  external free: [>`gvarianttype] obj -> unit = "ml_g_variant_type_free"
  external first: [>`gvarianttype] obj -> [<`gvarianttype] obj = "ml_g_variant_type_first"
  external element: [>`gvarianttype] obj -> [<`gvarianttype] obj = "ml_g_variant_type_element"
  external dup_string: [>`gvarianttype] obj -> string = "ml_g_variant_type_dup_string"
  external copy: [>`gvarianttype] obj -> [<`gvarianttype] obj = "ml_g_variant_type_copy"
  end
module VariantIter = struct
  external next_value: [>`gvariantiter] obj -> [<`gvariant] obj = "ml_g_variant_iter_next_value"
  external n_children: [>`gvariantiter] obj -> int = "ml_g_variant_iter_n_children"
  external init: [>`gvariantiter] obj -> [>`gvariant] obj -> int = "ml_g_variant_iter_init"
  external free: [>`gvariantiter] obj -> unit = "ml_g_variant_iter_free"
  external copy: [>`gvariantiter] obj -> [<`gvariantiter] obj = "ml_g_variant_iter_copy"
  end
module VariantBuilder = struct
  external unref: [>`gvariantbuilder] obj -> unit = "ml_g_variant_builder_unref"
  external ref: [>`gvariantbuilder] obj -> [<`gvariantbuilder] obj = "ml_g_variant_builder_ref"
  external g_variant_builder_open: [>`gvariantbuilder] obj -> [>`gvarianttype] obj -> unit = "ml_g_variant_builder_open"
  external init: [>`gvariantbuilder] obj -> [>`gvarianttype] obj -> unit = "ml_g_variant_builder_init"
  external end: [>`gvariantbuilder] obj -> [<`gvariant] obj = "ml_g_variant_builder_end"
  external close: [>`gvariantbuilder] obj -> unit = "ml_g_variant_builder_close"
  external clear: [>`gvariantbuilder] obj -> unit = "ml_g_variant_builder_clear"
  external add_value: [>`gvariantbuilder] obj -> [>`gvariant] obj -> unit = "ml_g_variant_builder_add_value"
  end
module Variant = struct
  external unref: [>`gvariant] obj -> unit = "ml_g_variant_unref"
  external ref_sink: [>`gvariant] obj -> [<`gvariant] obj = "ml_g_variant_ref_sink"
  external ref: [>`gvariant] obj -> [<`gvariant] obj = "ml_g_variant_ref"
  external print_string: [>`gvariant] obj -> [>`gstring] obj -> bool -> [<`gstring] obj = "ml_g_variant_print_string"
  external print: [>`gvariant] obj -> bool -> string = "ml_g_variant_print"
  external new_variant: [>`gvariant] obj -> [<`gvariant] obj = "ml_g_variant_new_variant"
  external new_dict_entry: [>`gvariant] obj -> [>`gvariant] obj -> [<`gvariant] obj = "ml_g_variant_new_dict_entry"
  external n_children: [>`gvariant] obj -> int = "ml_g_variant_n_children"
  external lookup_value: [>`gvariant] obj -> string -> [>`gvarianttype] obj -> [<`gvariant] obj = "ml_g_variant_lookup_value"
  external iter_new: [>`gvariant] obj -> [<`gvariantiter] obj = "ml_g_variant_iter_new"
  external is_of_type: [>`gvariant] obj -> [>`gvarianttype] obj -> bool = "ml_g_variant_is_of_type"
  external is_normal_form: [>`gvariant] obj -> bool = "ml_g_variant_is_normal_form"
  external is_floating: [>`gvariant] obj -> bool = "ml_g_variant_is_floating"
  external is_container: [>`gvariant] obj -> bool = "ml_g_variant_is_container"
  external get_variant: [>`gvariant] obj -> [<`gvariant] obj = "ml_g_variant_get_variant"
  external get_uint64: [>`gvariant] obj -> int64 = "ml_g_variant_get_uint64"
  external get_uint32: [>`gvariant] obj -> int32 = "ml_g_variant_get_uint32"
  external get_uint16: [>`gvariant] obj -> int = "ml_g_variant_get_uint16"
  external get_type_string: [>`gvariant] obj -> string = "ml_g_variant_get_type_string"
  external get_size: [>`gvariant] obj -> int = "ml_g_variant_get_size"
  external get_normal_form: [>`gvariant] obj -> [<`gvariant] obj = "ml_g_variant_get_normal_form"
  external get_maybe: [>`gvariant] obj -> [<`gvariant] obj = "ml_g_variant_get_maybe"
  external get_int64: [>`gvariant] obj -> int64 = "ml_g_variant_get_int64"
  external get_int32: [>`gvariant] obj -> int32 = "ml_g_variant_get_int32"
  external get_int16: [>`gvariant] obj -> int = "ml_g_variant_get_int16"
  external get_handle: [>`gvariant] obj -> int32 = "ml_g_variant_get_handle"
  external get_double: [>`gvariant] obj -> float = "ml_g_variant_get_double"
  external get_child_value: [>`gvariant] obj -> int -> [<`gvariant] obj = "ml_g_variant_get_child_value"
  external get_bytestring: [>`gvariant] obj -> string = "ml_g_variant_get_bytestring"
  external get_byte: [>`gvariant] obj -> int = "ml_g_variant_get_byte"
  external get_boolean: [>`gvariant] obj -> bool = "ml_g_variant_get_boolean"
  external byteswap: [>`gvariant] obj -> [<`gvariant] obj = "ml_g_variant_byteswap"
  end
module Tuples = struct
  external destroy: [>`gtuples] obj -> unit = "ml_g_tuples_destroy"
  end
module Tree = struct
  external unref: [>`gtree] obj -> unit = "ml_g_tree_unref"
  external ref: [>`gtree] obj -> [<`gtree] obj = "ml_g_tree_ref"
  external nnodes: [>`gtree] obj -> int = "ml_g_tree_nnodes"
  external height: [>`gtree] obj -> int = "ml_g_tree_height"
  external destroy: [>`gtree] obj -> unit = "ml_g_tree_destroy"
  end
module TrashStack = struct
  end
module Timer = struct
  external stop: [>`gtimer] obj -> unit = "ml_g_timer_stop"
  external start: [>`gtimer] obj -> unit = "ml_g_timer_start"
  external reset: [>`gtimer] obj -> unit = "ml_g_timer_reset"
  external destroy: [>`gtimer] obj -> unit = "ml_g_timer_destroy"
  external continue: [>`gtimer] obj -> unit = "ml_g_timer_continue"
  end
module TimeZone = struct
  external unref: [>`gtimezone] obj -> unit = "ml_g_time_zone_unref"
  external ref: [>`gtimezone] obj -> [<`gtimezone] obj = "ml_g_time_zone_ref"
  external is_dst: [>`gtimezone] obj -> int -> bool = "ml_g_time_zone_is_dst"
  external get_offset: [>`gtimezone] obj -> int -> int32 = "ml_g_time_zone_get_offset"
  external get_abbreviation: [>`gtimezone] obj -> int -> string = "ml_g_time_zone_get_abbreviation"
  end
module TimeVal = struct
  external to_iso8601: [>`gtimeval] obj -> string = "ml_g_time_val_to_iso8601"
  external add: [>`gtimeval] obj -> float -> unit = "ml_g_time_val_add"
  end
module ThreadPool = struct
  external unprocessed: [>`gthreadpool] obj -> int = "ml_g_thread_pool_unprocessed"
  external get_num_threads: [>`gthreadpool] obj -> int = "ml_g_thread_pool_get_num_threads"
  external get_max_threads: [>`gthreadpool] obj -> int = "ml_g_thread_pool_get_max_threads"
  external free: [>`gthreadpool] obj -> bool -> bool -> unit = "ml_g_thread_pool_free"
  end
module ThreadFunctions = struct
  end
module Thread = struct
  end
module TestSuite = struct
  external add_suite: [>`gtestsuite] obj -> [>`gtestsuite] obj -> unit = "ml_g_test_suite_add_suite"
  external add: [>`gtestsuite] obj -> [>`gtestcase] obj -> unit = "ml_g_test_suite_add"
  end
module TestLogMsg = struct
  external free: [>`gtestlogmsg] obj -> unit = "ml_g_test_log_msg_free"
  end
module TestLogBuffer = struct
  external pop: [>`gtestlogbuffer] obj -> [<`gtestlogmsg] obj = "ml_g_test_log_buffer_pop"
  external free: [>`gtestlogbuffer] obj -> unit = "ml_g_test_log_buffer_free"
  end
module TestConfig = struct
  end
module TestCase = struct
  end
module StringChunk = struct
  external insert_len: [>`gstringchunk] obj -> string -> int -> string = "ml_g_string_chunk_insert_len"
  external insert_const: [>`gstringchunk] obj -> string -> string = "ml_g_string_chunk_insert_const"
  external insert: [>`gstringchunk] obj -> string -> string = "ml_g_string_chunk_insert"
  external free: [>`gstringchunk] obj -> unit = "ml_g_string_chunk_free"
  external clear: [>`gstringchunk] obj -> unit = "ml_g_string_chunk_clear"
  end
module String = struct
  external up: [>`gstring] obj -> [<`gstring] obj = "ml_g_string_up"
  external truncate: [>`gstring] obj -> int -> [<`gstring] obj = "ml_g_string_truncate"
  external set_size: [>`gstring] obj -> int -> [<`gstring] obj = "ml_g_string_set_size"
  external prepend_unichar: [>`gstring] obj -> int32 -> [<`gstring] obj = "ml_g_string_prepend_unichar"
  external prepend_len: [>`gstring] obj -> string -> int -> [<`gstring] obj = "ml_g_string_prepend_len"
  external prepend_c: [>`gstring] obj -> int -> [<`gstring] obj = "ml_g_string_prepend_c"
  external prepend: [>`gstring] obj -> string -> [<`gstring] obj = "ml_g_string_prepend"
  external overwrite_len: [>`gstring] obj -> int -> string -> int -> [<`gstring] obj = "ml_g_string_overwrite_len"
  external overwrite: [>`gstring] obj -> int -> string -> [<`gstring] obj = "ml_g_string_overwrite"
  external insert_unichar: [>`gstring] obj -> int -> int32 -> [<`gstring] obj = "ml_g_string_insert_unichar"
  external insert_len: [>`gstring] obj -> int -> string -> int -> [<`gstring] obj = "ml_g_string_insert_len"
  external insert_c: [>`gstring] obj -> int -> int -> [<`gstring] obj = "ml_g_string_insert_c"
  external insert: [>`gstring] obj -> int -> string -> [<`gstring] obj = "ml_g_string_insert"
  external hash: [>`gstring] obj -> int = "ml_g_string_hash"
  external free: [>`gstring] obj -> bool -> string = "ml_g_string_free"
  external erase: [>`gstring] obj -> int -> int -> [<`gstring] obj = "ml_g_string_erase"
  external equal: [>`gstring] obj -> [>`gstring] obj -> bool = "ml_g_string_equal"
  external down: [>`gstring] obj -> [<`gstring] obj = "ml_g_string_down"
  external assign: [>`gstring] obj -> string -> [<`gstring] obj = "ml_g_string_assign"
  external ascii_up: [>`gstring] obj -> [<`gstring] obj = "ml_g_string_ascii_up"
  external ascii_down: [>`gstring] obj -> [<`gstring] obj = "ml_g_string_ascii_down"
  external append_uri_escaped: [>`gstring] obj -> string -> string -> bool -> [<`gstring] obj = "ml_g_string_append_uri_escaped"
  external append_unichar: [>`gstring] obj -> int32 -> [<`gstring] obj = "ml_g_string_append_unichar"
  external append_len: [>`gstring] obj -> string -> int -> [<`gstring] obj = "ml_g_string_append_len"
  external append_c: [>`gstring] obj -> int -> [<`gstring] obj = "ml_g_string_append_c"
  external append: [>`gstring] obj -> string -> [<`gstring] obj = "ml_g_string_append"
  end
module StaticRecMutex = struct
  external unlock_full: [>`gstaticrecmutex] obj -> int = "ml_g_static_rec_mutex_unlock_full"
  external unlock: [>`gstaticrecmutex] obj -> unit = "ml_g_static_rec_mutex_unlock"
  external trylock: [>`gstaticrecmutex] obj -> bool = "ml_g_static_rec_mutex_trylock"
  external lock_full: [>`gstaticrecmutex] obj -> int -> unit = "ml_g_static_rec_mutex_lock_full"
  external lock: [>`gstaticrecmutex] obj -> unit = "ml_g_static_rec_mutex_lock"
  external init: [>`gstaticrecmutex] obj -> unit = "ml_g_static_rec_mutex_init"
  external free: [>`gstaticrecmutex] obj -> unit = "ml_g_static_rec_mutex_free"
  end
module StaticRWLock = struct
  external writer_unlock: [>`gstaticrwlock] obj -> unit = "ml_g_static_rw_lock_writer_unlock"
  external writer_trylock: [>`gstaticrwlock] obj -> bool = "ml_g_static_rw_lock_writer_trylock"
  external writer_lock: [>`gstaticrwlock] obj -> unit = "ml_g_static_rw_lock_writer_lock"
  external reader_unlock: [>`gstaticrwlock] obj -> unit = "ml_g_static_rw_lock_reader_unlock"
  external reader_trylock: [>`gstaticrwlock] obj -> bool = "ml_g_static_rw_lock_reader_trylock"
  external reader_lock: [>`gstaticrwlock] obj -> unit = "ml_g_static_rw_lock_reader_lock"
  external init: [>`gstaticrwlock] obj -> unit = "ml_g_static_rw_lock_init"
  external free: [>`gstaticrwlock] obj -> unit = "ml_g_static_rw_lock_free"
  end
module StaticPrivate = struct
  external init: [>`gstaticprivate] obj -> unit = "ml_g_static_private_init"
  external free: [>`gstaticprivate] obj -> unit = "ml_g_static_private_free"
  end
module StaticMutex = struct
  external init: [>`gstaticmutex] obj -> unit = "ml_g_static_mutex_init"
  external free: [>`gstaticmutex] obj -> unit = "ml_g_static_mutex_free"
  end
module StatBuf = struct
  end
module SourcePrivate = struct
  end
module SourceFuncs = struct
  end
module SourceCallbackFuncs = struct
  end
module Source = struct
  external unref: [>`gsource] obj -> unit = "ml_g_source_unref"
  external set_priority: [>`gsource] obj -> int -> unit = "ml_g_source_set_priority"
  external set_name: [>`gsource] obj -> string -> unit = "ml_g_source_set_name"
  external set_funcs: [>`gsource] obj -> [>`gsourcefuncs] obj -> unit = "ml_g_source_set_funcs"
  external set_can_recurse: [>`gsource] obj -> bool -> unit = "ml_g_source_set_can_recurse"
  external remove_poll: [>`gsource] obj -> [>`gpollfd] obj -> unit = "ml_g_source_remove_poll"
  external remove_child_source: [>`gsource] obj -> [>`gsource] obj -> unit = "ml_g_source_remove_child_source"
  external ref: [>`gsource] obj -> [<`gsource] obj = "ml_g_source_ref"
  external is_destroyed: [>`gsource] obj -> bool = "ml_g_source_is_destroyed"
  external get_time: [>`gsource] obj -> int64 = "ml_g_source_get_time"
  external get_priority: [>`gsource] obj -> int = "ml_g_source_get_priority"
  external get_name: [>`gsource] obj -> string = "ml_g_source_get_name"
  external get_id: [>`gsource] obj -> int = "ml_g_source_get_id"
  external get_current_time: [>`gsource] obj -> [>`gtimeval] obj -> unit = "ml_g_source_get_current_time"
  external get_context: [>`gsource] obj -> [<`gmaincontext] obj = "ml_g_source_get_context"
  external get_can_recurse: [>`gsource] obj -> bool = "ml_g_source_get_can_recurse"
  external destroy: [>`gsource] obj -> unit = "ml_g_source_destroy"
  external attach: [>`gsource] obj -> [>`gmaincontext] obj -> int = "ml_g_source_attach"
  external add_poll: [>`gsource] obj -> [>`gpollfd] obj -> unit = "ml_g_source_add_poll"
  external add_child_source: [>`gsource] obj -> [>`gsource] obj -> unit = "ml_g_source_add_child_source"
  end
module SequenceIter = struct
  external prev: [>`gsequenceiter] obj -> [<`gsequenceiter] obj = "ml_g_sequence_iter_prev"
  external next: [>`gsequenceiter] obj -> [<`gsequenceiter] obj = "ml_g_sequence_iter_next"
  external move: [>`gsequenceiter] obj -> int -> [<`gsequenceiter] obj = "ml_g_sequence_iter_move"
  external is_end: [>`gsequenceiter] obj -> bool = "ml_g_sequence_iter_is_end"
  external is_begin: [>`gsequenceiter] obj -> bool = "ml_g_sequence_iter_is_begin"
  external get_sequence: [>`gsequenceiter] obj -> [<`gsequence] obj = "ml_g_sequence_iter_get_sequence"
  external get_position: [>`gsequenceiter] obj -> int = "ml_g_sequence_iter_get_position"
  external compare: [>`gsequenceiter] obj -> [>`gsequenceiter] obj -> int = "ml_g_sequence_iter_compare"
  end
module Sequence = struct
  external get_length: [>`gsequence] obj -> int = "ml_g_sequence_get_length"
  external get_iter_at_pos: [>`gsequence] obj -> int -> [<`gsequenceiter] obj = "ml_g_sequence_get_iter_at_pos"
  external get_end_iter: [>`gsequence] obj -> [<`gsequenceiter] obj = "ml_g_sequence_get_end_iter"
  external get_begin_iter: [>`gsequence] obj -> [<`gsequenceiter] obj = "ml_g_sequence_get_begin_iter"
  external free: [>`gsequence] obj -> unit = "ml_g_sequence_free"
  end
module ScannerConfig = struct
  end
module Scanner = struct
  external sync_file_offset: [>`gscanner] obj -> unit = "ml_g_scanner_sync_file_offset"
  external set_scope: [>`gscanner] obj -> int -> int = "ml_g_scanner_set_scope"
  external scope_remove_symbol: [>`gscanner] obj -> int -> string -> unit = "ml_g_scanner_scope_remove_symbol"
  external input_text: [>`gscanner] obj -> string -> int -> unit = "ml_g_scanner_input_text"
  external input_file: [>`gscanner] obj -> int -> unit = "ml_g_scanner_input_file"
  external eof: [>`gscanner] obj -> bool = "ml_g_scanner_eof"
  external destroy: [>`gscanner] obj -> unit = "ml_g_scanner_destroy"
  external cur_position: [>`gscanner] obj -> int = "ml_g_scanner_cur_position"
  external cur_line: [>`gscanner] obj -> int = "ml_g_scanner_cur_line"
  end
module SList = struct
  end
module Relation = struct
  external print: [>`grelation] obj -> unit = "ml_g_relation_print"
  external destroy: [>`grelation] obj -> unit = "ml_g_relation_destroy"
  end
module Regex = struct
  external unref: [>`gregex] obj -> unit = "ml_g_regex_unref"
  external ref: [>`gregex] obj -> [<`gregex] obj = "ml_g_regex_ref"
  external get_string_number: [>`gregex] obj -> string -> int = "ml_g_regex_get_string_number"
  external get_pattern: [>`gregex] obj -> string = "ml_g_regex_get_pattern"
  external get_max_backref: [>`gregex] obj -> int = "ml_g_regex_get_max_backref"
  external get_capture_count: [>`gregex] obj -> int = "ml_g_regex_get_capture_count"
  end
module Rand = struct
  external set_seed: [>`grand] obj -> int32 -> unit = "ml_g_rand_set_seed"
  external int_range: [>`grand] obj -> int32 -> int32 -> int32 = "ml_g_rand_int_range"
  external int: [>`grand] obj -> int32 = "ml_g_rand_int"
  external free: [>`grand] obj -> unit = "ml_g_rand_free"
  external double_range: [>`grand] obj -> float -> float -> float = "ml_g_rand_double_range"
  external double: [>`grand] obj -> float = "ml_g_rand_double"
  external copy: [>`grand] obj -> [<`grand] obj = "ml_g_rand_copy"
  end
module Queue = struct
  external unlink: [>`gqueue] obj -> [>`glist] obj -> unit = "ml_g_queue_unlink"
  external reverse: [>`gqueue] obj -> unit = "ml_g_queue_reverse"
  external push_tail_link: [>`gqueue] obj -> [>`glist] obj -> unit = "ml_g_queue_push_tail_link"
  external push_nth_link: [>`gqueue] obj -> int -> [>`glist] obj -> unit = "ml_g_queue_push_nth_link"
  external push_head_link: [>`gqueue] obj -> [>`glist] obj -> unit = "ml_g_queue_push_head_link"
  external pop_tail_link: [>`gqueue] obj -> [<`glist] obj = "ml_g_queue_pop_tail_link"
  external pop_nth_link: [>`gqueue] obj -> int -> [<`glist] obj = "ml_g_queue_pop_nth_link"
  external pop_head_link: [>`gqueue] obj -> [<`glist] obj = "ml_g_queue_pop_head_link"
  external peek_tail_link: [>`gqueue] obj -> [<`glist] obj = "ml_g_queue_peek_tail_link"
  external peek_nth_link: [>`gqueue] obj -> int -> [<`glist] obj = "ml_g_queue_peek_nth_link"
  external peek_head_link: [>`gqueue] obj -> [<`glist] obj = "ml_g_queue_peek_head_link"
  external link_index: [>`gqueue] obj -> [>`glist] obj -> int = "ml_g_queue_link_index"
  external is_empty: [>`gqueue] obj -> bool = "ml_g_queue_is_empty"
  external init: [>`gqueue] obj -> unit = "ml_g_queue_init"
  external get_length: [>`gqueue] obj -> int = "ml_g_queue_get_length"
  external free: [>`gqueue] obj -> unit = "ml_g_queue_free"
  external delete_link: [>`gqueue] obj -> [>`glist] obj -> unit = "ml_g_queue_delete_link"
  external copy: [>`gqueue] obj -> [<`gqueue] obj = "ml_g_queue_copy"
  external clear: [>`gqueue] obj -> unit = "ml_g_queue_clear"
  end
module PtrArray = struct
  end
module Private = struct
  end
module PollFD = struct
  end
module PatternSpec = struct
  external free: [>`gpatternspec] obj -> unit = "ml_g_pattern_spec_free"
  external equal: [>`gpatternspec] obj -> [>`gpatternspec] obj -> bool = "ml_g_pattern_spec_equal"
  end
module OptionGroup = struct
  external set_translation_domain: [>`goptiongroup] obj -> string -> unit = "ml_g_option_group_set_translation_domain"
  external free: [>`goptiongroup] obj -> unit = "ml_g_option_group_free"
  external add_entries: [>`goptiongroup] obj -> [>`goptionentry] obj -> unit = "ml_g_option_group_add_entries"
  end
module OptionEntry = struct
  end
module OptionContext = struct
  external set_translation_domain: [>`goptioncontext] obj -> string -> unit = "ml_g_option_context_set_translation_domain"
  external set_summary: [>`goptioncontext] obj -> string -> unit = "ml_g_option_context_set_summary"
  external set_main_group: [>`goptioncontext] obj -> [>`goptiongroup] obj -> unit = "ml_g_option_context_set_main_group"
  external set_ignore_unknown_options: [>`goptioncontext] obj -> bool -> unit = "ml_g_option_context_set_ignore_unknown_options"
  external set_help_enabled: [>`goptioncontext] obj -> bool -> unit = "ml_g_option_context_set_help_enabled"
  external set_description: [>`goptioncontext] obj -> string -> unit = "ml_g_option_context_set_description"
  external get_summary: [>`goptioncontext] obj -> string = "ml_g_option_context_get_summary"
  external get_main_group: [>`goptioncontext] obj -> [<`goptiongroup] obj = "ml_g_option_context_get_main_group"
  external get_ignore_unknown_options: [>`goptioncontext] obj -> bool = "ml_g_option_context_get_ignore_unknown_options"
  external get_help_enabled: [>`goptioncontext] obj -> bool = "ml_g_option_context_get_help_enabled"
  external get_help: [>`goptioncontext] obj -> bool -> [>`goptiongroup] obj -> string = "ml_g_option_context_get_help"
  external get_description: [>`goptioncontext] obj -> string = "ml_g_option_context_get_description"
  external free: [>`goptioncontext] obj -> unit = "ml_g_option_context_free"
  external add_main_entries: [>`goptioncontext] obj -> [>`goptionentry] obj -> string -> unit = "ml_g_option_context_add_main_entries"
  external add_group: [>`goptioncontext] obj -> [>`goptiongroup] obj -> unit = "ml_g_option_context_add_group"
  end
module Once = struct
  end
module Node = struct
  external unlink: [>`gnode] obj -> unit = "ml_g_node_unlink"
  external reverse_children: [>`gnode] obj -> unit = "ml_g_node_reverse_children"
  external prepend: [>`gnode] obj -> [>`gnode] obj -> [<`gnode] obj = "ml_g_node_prepend"
  external nth_child: [>`gnode] obj -> int -> [<`gnode] obj = "ml_g_node_nth_child"
  external n_children: [>`gnode] obj -> int = "ml_g_node_n_children"
  external max_height: [>`gnode] obj -> int = "ml_g_node_max_height"
  external last_sibling: [>`gnode] obj -> [<`gnode] obj = "ml_g_node_last_sibling"
  external last_child: [>`gnode] obj -> [<`gnode] obj = "ml_g_node_last_child"
  external is_ancestor: [>`gnode] obj -> [>`gnode] obj -> bool = "ml_g_node_is_ancestor"
  external insert_before: [>`gnode] obj -> [>`gnode] obj -> [>`gnode] obj -> [<`gnode] obj = "ml_g_node_insert_before"
  external insert_after: [>`gnode] obj -> [>`gnode] obj -> [>`gnode] obj -> [<`gnode] obj = "ml_g_node_insert_after"
  external insert: [>`gnode] obj -> int -> [>`gnode] obj -> [<`gnode] obj = "ml_g_node_insert"
  external get_root: [>`gnode] obj -> [<`gnode] obj = "ml_g_node_get_root"
  external first_sibling: [>`gnode] obj -> [<`gnode] obj = "ml_g_node_first_sibling"
  external destroy: [>`gnode] obj -> unit = "ml_g_node_destroy"
  external depth: [>`gnode] obj -> int = "ml_g_node_depth"
  external copy: [>`gnode] obj -> [<`gnode] obj = "ml_g_node_copy"
  external child_position: [>`gnode] obj -> [>`gnode] obj -> int = "ml_g_node_child_position"
  end
module Mutex = struct
  end
module MemVTable = struct
  end
module MemChunk = struct
  external reset: [>`gmemchunk] obj -> unit = "ml_g_mem_chunk_reset"
  external print: [>`gmemchunk] obj -> unit = "ml_g_mem_chunk_print"
  external destroy: [>`gmemchunk] obj -> unit = "ml_g_mem_chunk_destroy"
  external clean: [>`gmemchunk] obj -> unit = "ml_g_mem_chunk_clean"
  end
module MatchInfo = struct
  external matches: [>`gmatchinfo] obj -> bool = "ml_g_match_info_matches"
  external is_partial_match: [>`gmatchinfo] obj -> bool = "ml_g_match_info_is_partial_match"
  external get_string: [>`gmatchinfo] obj -> string = "ml_g_match_info_get_string"
  external get_regex: [>`gmatchinfo] obj -> [<`gregex] obj = "ml_g_match_info_get_regex"
  external get_match_count: [>`gmatchinfo] obj -> int = "ml_g_match_info_get_match_count"
  external free: [>`gmatchinfo] obj -> unit = "ml_g_match_info_free"
  external fetch_named: [>`gmatchinfo] obj -> string -> string = "ml_g_match_info_fetch_named"
  external fetch: [>`gmatchinfo] obj -> int -> string = "ml_g_match_info_fetch"
  end
module MarkupParser = struct
  end
module MarkupParseContext = struct
  external get_element_stack: [>`gmarkupparsecontext] obj -> [<`gslist] obj = "ml_g_markup_parse_context_get_element_stack"
  external get_element: [>`gmarkupparsecontext] obj -> string = "ml_g_markup_parse_context_get_element"
  external free: [>`gmarkupparsecontext] obj -> unit = "ml_g_markup_parse_context_free"
  end
module MappedFile = struct
  external unref: [>`gmappedfile] obj -> unit = "ml_g_mapped_file_unref"
  external ref: [>`gmappedfile] obj -> [<`gmappedfile] obj = "ml_g_mapped_file_ref"
  external get_length: [>`gmappedfile] obj -> int = "ml_g_mapped_file_get_length"
  external get_contents: [>`gmappedfile] obj -> string = "ml_g_mapped_file_get_contents"
  external free: [>`gmappedfile] obj -> unit = "ml_g_mapped_file_free"
  end
module MainLoop = struct
  external unref: [>`gmainloop] obj -> unit = "ml_g_main_loop_unref"
  external run: [>`gmainloop] obj -> unit = "ml_g_main_loop_run"
  external ref: [>`gmainloop] obj -> [<`gmainloop] obj = "ml_g_main_loop_ref"
  external quit: [>`gmainloop] obj -> unit = "ml_g_main_loop_quit"
  external is_running: [>`gmainloop] obj -> bool = "ml_g_main_loop_is_running"
  external get_context: [>`gmainloop] obj -> [<`gmaincontext] obj = "ml_g_main_loop_get_context"
  end
module MainContext = struct
  external wakeup: [>`gmaincontext] obj -> unit = "ml_g_main_context_wakeup"
  external wait: [>`gmaincontext] obj -> [>`gcond] obj -> [>`gmutex] obj -> bool = "ml_g_main_context_wait"
  external unref: [>`gmaincontext] obj -> unit = "ml_g_main_context_unref"
  external remove_poll: [>`gmaincontext] obj -> [>`gpollfd] obj -> unit = "ml_g_main_context_remove_poll"
  external release: [>`gmaincontext] obj -> unit = "ml_g_main_context_release"
  external ref: [>`gmaincontext] obj -> [<`gmaincontext] obj = "ml_g_main_context_ref"
  external push_thread_default: [>`gmaincontext] obj -> unit = "ml_g_main_context_push_thread_default"
  external pop_thread_default: [>`gmaincontext] obj -> unit = "ml_g_main_context_pop_thread_default"
  external pending: [>`gmaincontext] obj -> bool = "ml_g_main_context_pending"
  external iteration: [>`gmaincontext] obj -> bool -> bool = "ml_g_main_context_iteration"
  external is_owner: [>`gmaincontext] obj -> bool = "ml_g_main_context_is_owner"
  external find_source_by_id: [>`gmaincontext] obj -> int -> [<`gsource] obj = "ml_g_main_context_find_source_by_id"
  external dispatch: [>`gmaincontext] obj -> unit = "ml_g_main_context_dispatch"
  external check: [>`gmaincontext] obj -> int -> [>`gpollfd] obj -> int -> int = "ml_g_main_context_check"
  external add_poll: [>`gmaincontext] obj -> [>`gpollfd] obj -> int -> unit = "ml_g_main_context_add_poll"
  external acquire: [>`gmaincontext] obj -> bool = "ml_g_main_context_acquire"
  end
module List = struct
  end
module KeyFile = struct
  external set_value: [>`gkeyfile] obj -> string -> string -> string -> unit = "ml_g_key_file_set_value"
  external set_uint64: [>`gkeyfile] obj -> string -> string -> int64 -> unit = "ml_g_key_file_set_uint64"
  external set_string: [>`gkeyfile] obj -> string -> string -> string -> unit = "ml_g_key_file_set_string"
  external set_locale_string: [>`gkeyfile] obj -> string -> string -> string -> string -> unit = "ml_g_key_file_set_locale_string"
  external set_list_separator: [>`gkeyfile] obj -> int -> unit = "ml_g_key_file_set_list_separator"
  external set_integer_list: [>`gkeyfile] obj -> string -> string -> int -> int -> unit = "ml_g_key_file_set_integer_list"
  external set_integer: [>`gkeyfile] obj -> string -> string -> int -> unit = "ml_g_key_file_set_integer"
  external set_int64: [>`gkeyfile] obj -> string -> string -> int64 -> unit = "ml_g_key_file_set_int64"
  external set_double_list: [>`gkeyfile] obj -> string -> string -> float -> int -> unit = "ml_g_key_file_set_double_list"
  external set_double: [>`gkeyfile] obj -> string -> string -> float -> unit = "ml_g_key_file_set_double"
  external set_boolean_list: [>`gkeyfile] obj -> string -> string -> bool -> int -> unit = "ml_g_key_file_set_boolean_list"
  external set_boolean: [>`gkeyfile] obj -> string -> string -> bool -> unit = "ml_g_key_file_set_boolean"
  external has_group: [>`gkeyfile] obj -> string -> bool = "ml_g_key_file_has_group"
  external get_start_group: [>`gkeyfile] obj -> string = "ml_g_key_file_get_start_group"
  external free: [>`gkeyfile] obj -> unit = "ml_g_key_file_free"
  end
module IOFuncs = struct
  end
module IOChannel = struct
  external unref: [>`giochannel] obj -> unit = "ml_g_io_channel_unref"
  external unix_get_fd: [>`giochannel] obj -> int = "ml_g_io_channel_unix_get_fd"
  external set_line_term: [>`giochannel] obj -> string -> int -> unit = "ml_g_io_channel_set_line_term"
  external set_close_on_unref: [>`giochannel] obj -> bool -> unit = "ml_g_io_channel_set_close_on_unref"
  external set_buffered: [>`giochannel] obj -> bool -> unit = "ml_g_io_channel_set_buffered"
  external set_buffer_size: [>`giochannel] obj -> int -> unit = "ml_g_io_channel_set_buffer_size"
  external ref: [>`giochannel] obj -> [<`giochannel] obj = "ml_g_io_channel_ref"
  external init: [>`giochannel] obj -> unit = "ml_g_io_channel_init"
  external get_encoding: [>`giochannel] obj -> string = "ml_g_io_channel_get_encoding"
  external get_close_on_unref: [>`giochannel] obj -> bool = "ml_g_io_channel_get_close_on_unref"
  external get_buffered: [>`giochannel] obj -> bool = "ml_g_io_channel_get_buffered"
  external get_buffer_size: [>`giochannel] obj -> int = "ml_g_io_channel_get_buffer_size"
  external close: [>`giochannel] obj -> unit = "ml_g_io_channel_close"
  end
module IConv = struct
  end
module HookList = struct
  external invoke_check: [>`ghooklist] obj -> bool -> unit = "ml_g_hook_list_invoke_check"
  external invoke: [>`ghooklist] obj -> bool -> unit = "ml_g_hook_list_invoke"
  external init: [>`ghooklist] obj -> int -> unit = "ml_g_hook_list_init"
  external clear: [>`ghooklist] obj -> unit = "ml_g_hook_list_clear"
  end
module Hook = struct
  external compare_ids: [>`ghook] obj -> [>`ghook] obj -> int = "ml_g_hook_compare_ids"
  end
module HashTableIter = struct
  external steal: [>`ghashtableiter] obj -> unit = "ml_g_hash_table_iter_steal"
  external remove: [>`ghashtableiter] obj -> unit = "ml_g_hash_table_iter_remove"
  external init: [>`ghashtableiter] obj -> [>`ghashtable] obj -> unit = "ml_g_hash_table_iter_init"
  external get_hash_table: [>`ghashtableiter] obj -> [<`ghashtable] obj = "ml_g_hash_table_iter_get_hash_table"
  end
module HashTable = struct
  end
module Error = struct
  external matches: [>`gerror] obj -> int32 -> int -> bool = "ml_g_error_matches"
  external free: [>`gerror] obj -> unit = "ml_g_error_free"
  external copy: [>`gerror] obj -> [<`gerror] obj = "ml_g_error_copy"
  end
module Dir = struct
  external rewind: [>`gdir] obj -> unit = "ml_g_dir_rewind"
  external read_name: [>`gdir] obj -> string = "ml_g_dir_read_name"
  external close: [>`gdir] obj -> unit = "ml_g_dir_close"
  end
module DebugKey = struct
  end
module DateTime = struct
  external unref: [>`gdatetime] obj -> unit = "ml_g_date_time_unref"
  external to_utc: [>`gdatetime] obj -> [<`gdatetime] obj = "ml_g_date_time_to_utc"
  external to_unix: [>`gdatetime] obj -> int64 = "ml_g_date_time_to_unix"
  external to_timezone: [>`gdatetime] obj -> [>`gtimezone] obj -> [<`gdatetime] obj = "ml_g_date_time_to_timezone"
  external to_timeval: [>`gdatetime] obj -> [>`gtimeval] obj -> bool = "ml_g_date_time_to_timeval"
  external to_local: [>`gdatetime] obj -> [<`gdatetime] obj = "ml_g_date_time_to_local"
  external ref: [>`gdatetime] obj -> [<`gdatetime] obj = "ml_g_date_time_ref"
  external is_daylight_savings: [>`gdatetime] obj -> bool = "ml_g_date_time_is_daylight_savings"
  external get_year: [>`gdatetime] obj -> int = "ml_g_date_time_get_year"
  external get_week_of_year: [>`gdatetime] obj -> int = "ml_g_date_time_get_week_of_year"
  external get_week_numbering_year: [>`gdatetime] obj -> int = "ml_g_date_time_get_week_numbering_year"
  external get_utc_offset: [>`gdatetime] obj -> int64 = "ml_g_date_time_get_utc_offset"
  external get_timezone_abbreviation: [>`gdatetime] obj -> string = "ml_g_date_time_get_timezone_abbreviation"
  external get_seconds: [>`gdatetime] obj -> float = "ml_g_date_time_get_seconds"
  external get_second: [>`gdatetime] obj -> int = "ml_g_date_time_get_second"
  external get_month: [>`gdatetime] obj -> int = "ml_g_date_time_get_month"
  external get_minute: [>`gdatetime] obj -> int = "ml_g_date_time_get_minute"
  external get_microsecond: [>`gdatetime] obj -> int = "ml_g_date_time_get_microsecond"
  external get_hour: [>`gdatetime] obj -> int = "ml_g_date_time_get_hour"
  external get_day_of_year: [>`gdatetime] obj -> int = "ml_g_date_time_get_day_of_year"
  external get_day_of_week: [>`gdatetime] obj -> int = "ml_g_date_time_get_day_of_week"
  external get_day_of_month: [>`gdatetime] obj -> int = "ml_g_date_time_get_day_of_month"
  external format: [>`gdatetime] obj -> string -> string = "ml_g_date_time_format"
  external difference: [>`gdatetime] obj -> [>`gdatetime] obj -> int64 = "ml_g_date_time_difference"
  external add_years: [>`gdatetime] obj -> int -> [<`gdatetime] obj = "ml_g_date_time_add_years"
  external add_weeks: [>`gdatetime] obj -> int -> [<`gdatetime] obj = "ml_g_date_time_add_weeks"
  external add_seconds: [>`gdatetime] obj -> float -> [<`gdatetime] obj = "ml_g_date_time_add_seconds"
  external add_months: [>`gdatetime] obj -> int -> [<`gdatetime] obj = "ml_g_date_time_add_months"
  external add_minutes: [>`gdatetime] obj -> int -> [<`gdatetime] obj = "ml_g_date_time_add_minutes"
  external add_hours: [>`gdatetime] obj -> int -> [<`gdatetime] obj = "ml_g_date_time_add_hours"
  external add_full: [>`gdatetime] obj -> int -> int -> int -> int -> int -> float -> [<`gdatetime] obj = "ml_g_date_time_add_full"
  external add_days: [>`gdatetime] obj -> int -> [<`gdatetime] obj = "ml_g_date_time_add_days"
  external add: [>`gdatetime] obj -> int64 -> [<`gdatetime] obj = "ml_g_date_time_add"
  end
module Date = struct
  external valid: [>`gdate] obj -> bool = "ml_g_date_valid"
  external subtract_years: [>`gdate] obj -> int -> unit = "ml_g_date_subtract_years"
  external subtract_months: [>`gdate] obj -> int -> unit = "ml_g_date_subtract_months"
  external subtract_days: [>`gdate] obj -> int -> unit = "ml_g_date_subtract_days"
  external set_year: [>`gdate] obj -> int -> unit = "ml_g_date_set_year"
  external set_time_val: [>`gdate] obj -> [>`gtimeval] obj -> unit = "ml_g_date_set_time_val"
  external set_time: [>`gdate] obj -> int32 -> unit = "ml_g_date_set_time"
  external set_parse: [>`gdate] obj -> string -> unit = "ml_g_date_set_parse"
  external set_julian: [>`gdate] obj -> int32 -> unit = "ml_g_date_set_julian"
  external set_day: [>`gdate] obj -> int -> unit = "ml_g_date_set_day"
  external order: [>`gdate] obj -> [>`gdate] obj -> unit = "ml_g_date_order"
  external is_last_of_month: [>`gdate] obj -> bool = "ml_g_date_is_last_of_month"
  external is_first_of_month: [>`gdate] obj -> bool = "ml_g_date_is_first_of_month"
  external get_year: [>`gdate] obj -> int = "ml_g_date_get_year"
  external get_sunday_week_of_year: [>`gdate] obj -> int = "ml_g_date_get_sunday_week_of_year"
  external get_monday_week_of_year: [>`gdate] obj -> int = "ml_g_date_get_monday_week_of_year"
  external get_julian: [>`gdate] obj -> int32 = "ml_g_date_get_julian"
  external get_iso8601_week_of_year: [>`gdate] obj -> int = "ml_g_date_get_iso8601_week_of_year"
  external get_day_of_year: [>`gdate] obj -> int = "ml_g_date_get_day_of_year"
  external get_day: [>`gdate] obj -> int = "ml_g_date_get_day"
  external free: [>`gdate] obj -> unit = "ml_g_date_free"
  external days_between: [>`gdate] obj -> [>`gdate] obj -> int = "ml_g_date_days_between"
  external compare: [>`gdate] obj -> [>`gdate] obj -> int = "ml_g_date_compare"
  external clear: [>`gdate] obj -> int -> unit = "ml_g_date_clear"
  external clamp: [>`gdate] obj -> [>`gdate] obj -> [>`gdate] obj -> unit = "ml_g_date_clamp"
  external add_years: [>`gdate] obj -> int -> unit = "ml_g_date_add_years"
  external add_months: [>`gdate] obj -> int -> unit = "ml_g_date_add_months"
  external add_days: [>`gdate] obj -> int -> unit = "ml_g_date_add_days"
  end
module Data = struct
  end
module Cond = struct
  end
module Completion = struct
  external remove_items: [>`gcompletion] obj -> [>`glist] obj -> unit = "ml_g_completion_remove_items"
  external free: [>`gcompletion] obj -> unit = "ml_g_completion_free"
  external clear_items: [>`gcompletion] obj -> unit = "ml_g_completion_clear_items"
  external add_items: [>`gcompletion] obj -> [>`glist] obj -> unit = "ml_g_completion_add_items"
  end
module Checksum = struct
  external update: [>`gchecksum] obj -> string -> int -> unit = "ml_g_checksum_update"
  external reset: [>`gchecksum] obj -> unit = "ml_g_checksum_reset"
  external get_string: [>`gchecksum] obj -> string = "ml_g_checksum_get_string"
  external free: [>`gchecksum] obj -> unit = "ml_g_checksum_free"
  external copy: [>`gchecksum] obj -> [<`gchecksum] obj = "ml_g_checksum_copy"
  end
module Cache = struct
  external destroy: [>`gcache] obj -> unit = "ml_g_cache_destroy"
  end
module ByteArray = struct
  end
module BookmarkFile = struct
  external set_title: [>`gbookmarkfile] obj -> string -> string -> unit = "ml_g_bookmark_file_set_title"
  external set_mime_type: [>`gbookmarkfile] obj -> string -> string -> unit = "ml_g_bookmark_file_set_mime_type"
  external set_is_private: [>`gbookmarkfile] obj -> string -> bool -> unit = "ml_g_bookmark_file_set_is_private"
  external set_icon: [>`gbookmarkfile] obj -> string -> string -> string -> unit = "ml_g_bookmark_file_set_icon"
  external set_description: [>`gbookmarkfile] obj -> string -> string -> unit = "ml_g_bookmark_file_set_description"
  external has_item: [>`gbookmarkfile] obj -> string -> bool = "ml_g_bookmark_file_has_item"
  external get_size: [>`gbookmarkfile] obj -> int = "ml_g_bookmark_file_get_size"
  external free: [>`gbookmarkfile] obj -> unit = "ml_g_bookmark_file_free"
  external add_group: [>`gbookmarkfile] obj -> string -> string -> unit = "ml_g_bookmark_file_add_group"
  external add_application: [>`gbookmarkfile] obj -> string -> string -> string -> unit = "ml_g_bookmark_file_add_application"
  end
module AsyncQueue = struct
  external unref_and_unlock: [>`gasyncqueue] obj -> unit = "ml_g_async_queue_unref_and_unlock"
  external unref: [>`gasyncqueue] obj -> unit = "ml_g_async_queue_unref"
  external unlock: [>`gasyncqueue] obj -> unit = "ml_g_async_queue_unlock"
  external ref_unlocked: [>`gasyncqueue] obj -> unit = "ml_g_async_queue_ref_unlocked"
  external ref: [>`gasyncqueue] obj -> [<`gasyncqueue] obj = "ml_g_async_queue_ref"
  external lock: [>`gasyncqueue] obj -> unit = "ml_g_async_queue_lock"
  external length_unlocked: [>`gasyncqueue] obj -> int = "ml_g_async_queue_length_unlocked"
  external length: [>`gasyncqueue] obj -> int = "ml_g_async_queue_length"
  end
module Array = struct
  end
module Allocator = struct
  external free: [>`gallocator] obj -> unit = "ml_g_allocator_free"
  end
(* Global functions *)
external warn_message: string -> string -> int -> string -> string -> unit = "ml_g_warn_message"
external variant_type_string_is_valid: string -> bool = "ml_g_variant_type_string_is_valid"
external variant_type_new: string -> [<`gvarianttype] obj = "ml_g_variant_type_new"
external variant_type_checked_: string -> [<`gvarianttype] obj = "ml_g_variant_type_checked_"
external variant_parser_get_error_quark: unit -> int32 = "ml_g_variant_parser_get_error_quark"
external variant_is_signature: string -> bool = "ml_g_variant_is_signature"
external variant_is_object_path: string -> bool = "ml_g_variant_is_object_path"
external variant_get_type: [>`gvariant] obj -> [<`gvarianttype] obj = "ml_g_variant_get_type"
external variant_builder_new: [>`gvarianttype] obj -> [<`gvariantbuilder] obj = "ml_g_variant_builder_new"
external utf8_strup: string -> int -> string = "ml_g_utf8_strup"
external utf8_strreverse: string -> int -> string = "ml_g_utf8_strreverse"
external utf8_strrchr: string -> int -> int32 -> string = "ml_g_utf8_strrchr"
external utf8_strncpy: string -> string -> int -> string = "ml_g_utf8_strncpy"
external utf8_strlen: string -> int -> float = "ml_g_utf8_strlen"
external utf8_strdown: string -> int -> string = "ml_g_utf8_strdown"
external utf8_strchr: string -> int -> int32 -> string = "ml_g_utf8_strchr"
external utf8_prev_char: string -> string = "ml_g_utf8_prev_char"
external utf8_pointer_to_offset: string -> string -> float = "ml_g_utf8_pointer_to_offset"
external utf8_offset_to_pointer: string -> float -> string = "ml_g_utf8_offset_to_pointer"
external utf8_get_char_validated: string -> int -> int32 = "ml_g_utf8_get_char_validated"
external utf8_get_char: string -> int32 = "ml_g_utf8_get_char"
external utf8_find_prev_char: string -> string -> string = "ml_g_utf8_find_prev_char"
external utf8_find_next_char: string -> string -> string = "ml_g_utf8_find_next_char"
external utf8_collate_key_for_filename: string -> int -> string = "ml_g_utf8_collate_key_for_filename"
external utf8_collate_key: string -> int -> string = "ml_g_utf8_collate_key"
external utf8_collate: string -> string -> int = "ml_g_utf8_collate"
external utf8_casefold: string -> int -> string = "ml_g_utf8_casefold"
external usleep: float -> unit = "ml_g_usleep"
external uri_unescape_string: string -> string -> string = "ml_g_uri_unescape_string"
external uri_unescape_segment: string -> string -> string -> string = "ml_g_uri_unescape_segment"
external uri_parse_scheme: string -> string = "ml_g_uri_parse_scheme"
external uri_escape_string: string -> string -> bool -> string = "ml_g_uri_escape_string"
external unsetenv: string -> unit = "ml_g_unsetenv"
external unlink: string -> int = "ml_g_unlink"
external unichar_xdigit_value: int32 -> int = "ml_g_unichar_xdigit_value"
external unichar_validate: int32 -> bool = "ml_g_unichar_validate"
external unichar_toupper: int32 -> int32 = "ml_g_unichar_toupper"
external unichar_totitle: int32 -> int32 = "ml_g_unichar_totitle"
external unichar_tolower: int32 -> int32 = "ml_g_unichar_tolower"
external unichar_to_utf8: int32 -> string -> int = "ml_g_unichar_to_utf8"
external unichar_iszerowidth: int32 -> bool = "ml_g_unichar_iszerowidth"
external unichar_isxdigit: int32 -> bool = "ml_g_unichar_isxdigit"
external unichar_iswide_cjk: int32 -> bool = "ml_g_unichar_iswide_cjk"
external unichar_iswide: int32 -> bool = "ml_g_unichar_iswide"
external unichar_isupper: int32 -> bool = "ml_g_unichar_isupper"
external unichar_istitle: int32 -> bool = "ml_g_unichar_istitle"
external unichar_isspace: int32 -> bool = "ml_g_unichar_isspace"
external unichar_ispunct: int32 -> bool = "ml_g_unichar_ispunct"
external unichar_isprint: int32 -> bool = "ml_g_unichar_isprint"
external unichar_ismark: int32 -> bool = "ml_g_unichar_ismark"
external unichar_islower: int32 -> bool = "ml_g_unichar_islower"
external unichar_isgraph: int32 -> bool = "ml_g_unichar_isgraph"
external unichar_isdigit: int32 -> bool = "ml_g_unichar_isdigit"
external unichar_isdefined: int32 -> bool = "ml_g_unichar_isdefined"
external unichar_iscntrl: int32 -> bool = "ml_g_unichar_iscntrl"
external unichar_isalpha: int32 -> bool = "ml_g_unichar_isalpha"
external unichar_isalnum: int32 -> bool = "ml_g_unichar_isalnum"
external unichar_digit_value: int32 -> int = "ml_g_unichar_digit_value"
external unichar_combining_class: int32 -> int = "ml_g_unichar_combining_class"
external timer_new: unit -> [<`gtimer] obj = "ml_g_timer_new"
external timeout_source_new_seconds: int -> [<`gsource] obj = "ml_g_timeout_source_new_seconds"
external timeout_source_new: int -> [<`gsource] obj = "ml_g_timeout_source_new"
external time_zone_new_utc: unit -> [<`gtimezone] obj = "ml_g_time_zone_new_utc"
external time_zone_new_local: unit -> [<`gtimezone] obj = "ml_g_time_zone_new_local"
external time_zone_new: string -> [<`gtimezone] obj = "ml_g_time_zone_new"
external time_val_from_iso8601: string -> [>`gtimeval] obj -> bool = "ml_g_time_val_from_iso8601"
external thread_self: unit -> [<`gthread] obj = "ml_g_thread_self"
external thread_pool_stop_unused_threads: unit -> unit = "ml_g_thread_pool_stop_unused_threads"
external thread_pool_set_max_unused_threads: int -> unit = "ml_g_thread_pool_set_max_unused_threads"
external thread_pool_set_max_idle_time: int -> unit = "ml_g_thread_pool_set_max_idle_time"
external thread_pool_get_num_unused_threads: unit -> int = "ml_g_thread_pool_get_num_unused_threads"
external thread_pool_get_max_unused_threads: unit -> int = "ml_g_thread_pool_get_max_unused_threads"
external thread_pool_get_max_idle_time: unit -> int = "ml_g_thread_pool_get_max_idle_time"
external thread_init_with_errorcheck_mutexes: [>`gthreadfunctions] obj -> unit = "ml_g_thread_init_with_errorcheck_mutexes"
external thread_init: [>`gthreadfunctions] obj option -> unit = "ml_g_thread_init"
external thread_get_initialized: unit -> bool = "ml_g_thread_get_initialized"
external thread_error_quark: unit -> int32 = "ml_g_thread_error_quark"
external test_trap_reached_timeout: unit -> bool = "ml_g_test_trap_reached_timeout"
external test_trap_has_passed: unit -> bool = "ml_g_test_trap_has_passed"
external test_trap_assertions: string -> string -> int -> string -> int64 -> string -> unit = "ml_g_test_trap_assertions"
external test_timer_start: unit -> unit = "ml_g_test_timer_start"
external test_timer_last: unit -> float = "ml_g_test_timer_last"
external test_timer_elapsed: unit -> float = "ml_g_test_timer_elapsed"
external test_run_suite: [>`gtestsuite] obj -> int = "ml_g_test_run_suite"
external test_run: unit -> int = "ml_g_test_run"
external test_rand_int_range: int32 -> int32 -> int32 = "ml_g_test_rand_int_range"
external test_rand_int: unit -> int32 = "ml_g_test_rand_int"
external test_rand_double_range: float -> float -> float = "ml_g_test_rand_double_range"
external test_rand_double: unit -> float = "ml_g_test_rand_double"
external test_log_buffer_new: unit -> [<`gtestlogbuffer] obj = "ml_g_test_log_buffer_new"
external test_get_root: unit -> [<`gtestsuite] obj = "ml_g_test_get_root"
external test_create_suite: string -> [<`gtestsuite] obj = "ml_g_test_create_suite"
external test_bug_base: string -> unit = "ml_g_test_bug_base"
external test_bug: string -> unit = "ml_g_test_bug"
external strup: string -> string = "ml_g_strup"
external strstr_len: string -> int -> string -> string = "ml_g_strstr_len"
external strsignal: int -> string = "ml_g_strsignal"
external strrstr_len: string -> int -> string -> string = "ml_g_strrstr_len"
external strrstr: string -> string -> string = "ml_g_strrstr"
external strreverse: string -> string = "ml_g_strreverse"
external strnfill: int -> int -> string = "ml_g_strnfill"
external strndup: string -> int -> string = "ml_g_strndup"
external strncasecmp: string -> string -> int -> int = "ml_g_strncasecmp"
external strlcpy: string -> string -> int -> int = "ml_g_strlcpy"
external strlcat: string -> string -> int -> int = "ml_g_strlcat"
external strip_context: string -> string -> string = "ml_g_strip_context"
external string_sized_new: int -> [<`gstring] obj = "ml_g_string_sized_new"
external string_new_len: string -> int -> [<`gstring] obj = "ml_g_string_new_len"
external string_new: string -> [<`gstring] obj = "ml_g_string_new"
external string_chunk_new: int -> [<`gstringchunk] obj = "ml_g_string_chunk_new"
external strescape: string -> string -> string = "ml_g_strescape"
external strerror: int -> string = "ml_g_strerror"
external strdup: string -> string = "ml_g_strdup"
external strdown: string -> string = "ml_g_strdown"
external strdelimit: string -> string -> int -> string = "ml_g_strdelimit"
external strcompress: string -> string = "ml_g_strcompress"
external strcmp0: string -> string -> int = "ml_g_strcmp0"
external strchug: string -> string = "ml_g_strchug"
external strchomp: string -> string = "ml_g_strchomp"
external strcasecmp: string -> string -> int = "ml_g_strcasecmp"
external strcanon: string -> string -> int -> string = "ml_g_strcanon"
external str_has_suffix: string -> string -> bool = "ml_g_str_has_suffix"
external str_has_prefix: string -> string -> bool = "ml_g_str_has_prefix"
external stpcpy: string -> string -> string = "ml_g_stpcpy"
external spawn_error_quark: unit -> int32 = "ml_g_spawn_error_quark"
external spawn_close_pid: int -> unit = "ml_g_spawn_close_pid"
external spaced_primes_closest: int -> int = "ml_g_spaced_primes_closest"
external source_set_name_by_id: int -> string -> unit = "ml_g_source_set_name_by_id"
external source_remove: int -> bool = "ml_g_source_remove"
external source_new: [>`gsourcefuncs] obj -> int -> [<`gsource] obj = "ml_g_source_new"
external slist_reverse: [>`gslist] obj -> [<`gslist] obj = "ml_g_slist_reverse"
external slist_remove_link: [>`gslist] obj -> [>`gslist] obj -> [<`gslist] obj = "ml_g_slist_remove_link"
external slist_position: [>`gslist] obj -> [>`gslist] obj -> int = "ml_g_slist_position"
external slist_pop_allocator: unit -> unit = "ml_g_slist_pop_allocator"
external slist_nth: [>`gslist] obj -> int -> [<`gslist] obj = "ml_g_slist_nth"
external slist_length: [>`gslist] obj -> int = "ml_g_slist_length"
external slist_last: [>`gslist] obj -> [<`gslist] obj = "ml_g_slist_last"
external slist_free_1: [>`gslist] obj -> unit = "ml_g_slist_free_1"
external slist_free: [>`gslist] obj -> unit = "ml_g_slist_free"
external slist_delete_link: [>`gslist] obj -> [>`gslist] obj -> [<`gslist] obj = "ml_g_slist_delete_link"
external slist_copy: [>`gslist] obj -> [<`gslist] obj = "ml_g_slist_copy"
external slist_concat: [>`gslist] obj -> [>`gslist] obj -> [<`gslist] obj = "ml_g_slist_concat"
external slist_alloc: unit -> [<`gslist] obj = "ml_g_slist_alloc"
external shell_quote: string -> string = "ml_g_shell_quote"
external shell_error_quark: unit -> int32 = "ml_g_shell_error_quark"
external setenv: string -> string -> bool -> bool = "ml_g_setenv"
external set_prgname: string -> unit = "ml_g_set_prgname"
external set_application_name: string -> unit = "ml_g_set_application_name"
external sequence_swap: [>`gsequenceiter] obj -> [>`gsequenceiter] obj -> unit = "ml_g_sequence_swap"
external sequence_remove_range: [>`gsequenceiter] obj -> [>`gsequenceiter] obj -> unit = "ml_g_sequence_remove_range"
external sequence_remove: [>`gsequenceiter] obj -> unit = "ml_g_sequence_remove"
external sequence_range_get_midpoint: [>`gsequenceiter] obj -> [>`gsequenceiter] obj -> [<`gsequenceiter] obj = "ml_g_sequence_range_get_midpoint"
external sequence_move_range: [>`gsequenceiter] obj -> [>`gsequenceiter] obj -> [>`gsequenceiter] obj -> unit = "ml_g_sequence_move_range"
external sequence_move: [>`gsequenceiter] obj -> [>`gsequenceiter] obj -> unit = "ml_g_sequence_move"
external scanner_new: [>`gscannerconfig] obj -> [<`gscanner] obj = "ml_g_scanner_new"
external rmdir: string -> int = "ml_g_rmdir"
external return_if_fail_warning: string -> string -> string -> unit = "ml_g_return_if_fail_warning"
external reload_user_special_dirs_cache: unit -> unit = "ml_g_reload_user_special_dirs_cache"
external relation_new: int -> [<`grelation] obj = "ml_g_relation_new"
external regex_escape_string: string -> int -> string = "ml_g_regex_escape_string"
external regex_error_quark: unit -> int32 = "ml_g_regex_error_quark"
external random_set_seed: int32 -> unit = "ml_g_random_set_seed"
external random_int_range: int32 -> int32 -> int32 = "ml_g_random_int_range"
external random_int: unit -> int32 = "ml_g_random_int"
external random_double_range: float -> float -> float = "ml_g_random_double_range"
external random_double: unit -> float = "ml_g_random_double"
external rand_new_with_seed: int32 -> [<`grand] obj = "ml_g_rand_new_with_seed"
external rand_new: unit -> [<`grand] obj = "ml_g_rand_new"
external queue_new: unit -> [<`gqueue] obj = "ml_g_queue_new"
external quark_try_string: string -> int32 = "ml_g_quark_try_string"
external quark_to_string: int32 -> string = "ml_g_quark_to_string"
external quark_from_string: string -> int32 = "ml_g_quark_from_string"
external quark_from_static_string: string -> int32 = "ml_g_quark_from_static_string"
external poll: [>`gpollfd] obj -> int -> int -> int = "ml_g_poll"
external pattern_spec_new: string -> [<`gpatternspec] obj = "ml_g_pattern_spec_new"
external pattern_match_string: [>`gpatternspec] obj -> string -> bool = "ml_g_pattern_match_string"
external pattern_match_simple: string -> string -> bool = "ml_g_pattern_match_simple"
external pattern_match: [>`gpatternspec] obj -> int -> string -> string -> bool = "ml_g_pattern_match"
external path_skip_root: string -> string = "ml_g_path_skip_root"
external path_is_absolute: string -> bool = "ml_g_path_is_absolute"
external path_get_dirname: string -> string = "ml_g_path_get_dirname"
external path_get_basename: string -> string = "ml_g_path_get_basename"
external parse_debug_string: string -> [>`gdebugkey] obj -> int -> int = "ml_g_parse_debug_string"
external option_error_quark: unit -> int32 = "ml_g_option_error_quark"
external option_context_new: string -> [<`goptioncontext] obj = "ml_g_option_context_new"
external on_error_stack_trace: string -> unit = "ml_g_on_error_stack_trace"
external on_error_query: string -> unit = "ml_g_on_error_query"
external node_pop_allocator: unit -> unit = "ml_g_node_pop_allocator"
external mkstemp_full: string -> int -> int -> int = "ml_g_mkstemp_full"
external mkstemp: string -> int = "ml_g_mkstemp"
external mkdir_with_parents: string -> int -> int = "ml_g_mkdir_with_parents"
external mem_set_vtable: [>`gmemvtable] obj -> unit = "ml_g_mem_set_vtable"
external mem_profile: unit -> unit = "ml_g_mem_profile"
external mem_is_system_malloc: unit -> bool = "ml_g_mem_is_system_malloc"
external mem_chunk_new: string -> int -> int -> int -> [<`gmemchunk] obj = "ml_g_mem_chunk_new"
external mem_chunk_info: unit -> unit = "ml_g_mem_chunk_info"
external markup_escape_text: string -> int -> string = "ml_g_markup_escape_text"
external markup_error_quark: unit -> int32 = "ml_g_markup_error_quark"
external main_loop_new: [>`gmaincontext] obj option -> bool -> [<`gmainloop] obj = "ml_g_main_loop_new"
external main_depth: unit -> int = "ml_g_main_depth"
external main_current_source: unit -> [<`gsource] obj = "ml_g_main_current_source"
external main_context_new: unit -> [<`gmaincontext] obj = "ml_g_main_context_new"
external main_context_get_thread_default: unit -> [<`gmaincontext] obj = "ml_g_main_context_get_thread_default"
external main_context_default: unit -> [<`gmaincontext] obj = "ml_g_main_context_default"
external log_remove_handler: string -> int -> unit = "ml_g_log_remove_handler"
external list_reverse: [>`glist] obj -> [<`glist] obj = "ml_g_list_reverse"
external list_remove_link: [>`glist] obj -> [>`glist] obj -> [<`glist] obj = "ml_g_list_remove_link"
external list_position: [>`glist] obj -> [>`glist] obj -> int = "ml_g_list_position"
external list_pop_allocator: unit -> unit = "ml_g_list_pop_allocator"
external list_nth_prev: [>`glist] obj -> int -> [<`glist] obj = "ml_g_list_nth_prev"
external list_nth: [>`glist] obj -> int -> [<`glist] obj = "ml_g_list_nth"
external list_length: [>`glist] obj -> int = "ml_g_list_length"
external list_last: [>`glist] obj -> [<`glist] obj = "ml_g_list_last"
external list_free_1: [>`glist] obj -> unit = "ml_g_list_free_1"
external list_free: [>`glist] obj -> unit = "ml_g_list_free"
external list_first: [>`glist] obj -> [<`glist] obj = "ml_g_list_first"
external list_delete_link: [>`glist] obj -> [>`glist] obj -> [<`glist] obj = "ml_g_list_delete_link"
external list_copy: [>`glist] obj -> [<`glist] obj = "ml_g_list_copy"
external list_concat: [>`glist] obj -> [>`glist] obj -> [<`glist] obj = "ml_g_list_concat"
external list_alloc: unit -> [<`glist] obj = "ml_g_list_alloc"
external key_file_new: unit -> [<`gkeyfile] obj = "ml_g_key_file_new"
external key_file_error_quark: unit -> int32 = "ml_g_key_file_error_quark"
external io_channel_unix_new: int -> [<`giochannel] obj = "ml_g_io_channel_unix_new"
external io_channel_error_quark: unit -> int32 = "ml_g_io_channel_error_quark"
external intern_string: string -> string = "ml_g_intern_string"
external intern_static_string: string -> string = "ml_g_intern_static_string"
external idle_source_new: unit -> [<`gsource] obj = "ml_g_idle_source_new"
external hostname_to_unicode: string -> string = "ml_g_hostname_to_unicode"
external hostname_to_ascii: string -> string = "ml_g_hostname_to_ascii"
external hostname_is_non_ascii: string -> bool = "ml_g_hostname_is_non_ascii"
external hostname_is_ip_address: string -> bool = "ml_g_hostname_is_ip_address"
external hostname_is_ascii_encoded: string -> bool = "ml_g_hostname_is_ascii_encoded"
external hook_unref: [>`ghooklist] obj -> [>`ghook] obj -> unit = "ml_g_hook_unref"
external hook_ref: [>`ghooklist] obj -> [>`ghook] obj -> [<`ghook] obj = "ml_g_hook_ref"
external hook_prepend: [>`ghooklist] obj -> [>`ghook] obj -> unit = "ml_g_hook_prepend"
external hook_next_valid: [>`ghooklist] obj -> [>`ghook] obj -> bool -> [<`ghook] obj = "ml_g_hook_next_valid"
external hook_insert_before: [>`ghooklist] obj -> [>`ghook] obj -> [>`ghook] obj -> unit = "ml_g_hook_insert_before"
external hook_get: [>`ghooklist] obj -> float -> [<`ghook] obj = "ml_g_hook_get"
external hook_free: [>`ghooklist] obj -> [>`ghook] obj -> unit = "ml_g_hook_free"
external hook_first_valid: [>`ghooklist] obj -> bool -> [<`ghook] obj = "ml_g_hook_first_valid"
external hook_destroy_link: [>`ghooklist] obj -> [>`ghook] obj -> unit = "ml_g_hook_destroy_link"
external hook_destroy: [>`ghooklist] obj -> float -> bool = "ml_g_hook_destroy"
external hook_alloc: [>`ghooklist] obj -> [<`ghook] obj = "ml_g_hook_alloc"
external hash_table_unref: [>`ghashtable] obj -> unit = "ml_g_hash_table_unref"
external hash_table_steal_all: [>`ghashtable] obj -> unit = "ml_g_hash_table_steal_all"
external hash_table_size: [>`ghashtable] obj -> int = "ml_g_hash_table_size"
external hash_table_remove_all: [>`ghashtable] obj -> unit = "ml_g_hash_table_remove_all"
external hash_table_ref: [>`ghashtable] obj -> [<`ghashtable] obj = "ml_g_hash_table_ref"
external hash_table_get_values: [>`ghashtable] obj -> [<`glist] obj = "ml_g_hash_table_get_values"
external hash_table_get_keys: [>`ghashtable] obj -> [<`glist] obj = "ml_g_hash_table_get_keys"
external hash_table_destroy: [>`ghashtable] obj -> unit = "ml_g_hash_table_destroy"
external getenv: string -> string = "ml_g_getenv"
external get_user_runtime_dir: unit -> string = "ml_g_get_user_runtime_dir"
external get_user_name: unit -> string = "ml_g_get_user_name"
external get_user_data_dir: unit -> string = "ml_g_get_user_data_dir"
external get_user_config_dir: unit -> string = "ml_g_get_user_config_dir"
external get_user_cache_dir: unit -> string = "ml_g_get_user_cache_dir"
external get_tmp_dir: unit -> string = "ml_g_get_tmp_dir"
external get_real_time: unit -> int64 = "ml_g_get_real_time"
external get_real_name: unit -> string = "ml_g_get_real_name"
external get_prgname: unit -> string = "ml_g_get_prgname"
external get_monotonic_time: unit -> int64 = "ml_g_get_monotonic_time"
external get_host_name: unit -> string = "ml_g_get_host_name"
external get_home_dir: unit -> string = "ml_g_get_home_dir"
external get_current_time: [>`gtimeval] obj -> unit = "ml_g_get_current_time"
external get_current_dir: unit -> string = "ml_g_get_current_dir"
external get_application_name: unit -> string = "ml_g_get_application_name"
external find_program_in_path: string -> string = "ml_g_find_program_in_path"
external filename_display_name: string -> string = "ml_g_filename_display_name"
external filename_display_basename: string -> string = "ml_g_filename_display_basename"
external file_error_quark: unit -> int32 = "ml_g_file_error_quark"
external error_new_literal: int32 -> int -> string -> [<`gerror] obj = "ml_g_error_new_literal"
external dummy_decl: unit -> unit = "ml_glib_dummy_decl"
external dpgettext2: string -> string -> string -> string = "ml_g_dpgettext2"
external dpgettext: string -> string -> int -> string = "ml_g_dpgettext"
external dngettext: string -> string -> string -> float -> string = "ml_g_dngettext"
external dgettext: string -> string -> string = "ml_g_dgettext"
external dcgettext: string -> string -> int -> string = "ml_g_dcgettext"
external date_valid_year: int -> bool = "ml_g_date_valid_year"
external date_valid_julian: int32 -> bool = "ml_g_date_valid_julian"
external date_valid_day: int -> bool = "ml_g_date_valid_day"
external date_time_new_utc: int -> int -> int -> int -> int -> float -> [<`gdatetime] obj = "ml_g_date_time_new_utc"
external date_time_new_now_utc: unit -> [<`gdatetime] obj = "ml_g_date_time_new_now_utc"
external date_time_new_now_local: unit -> [<`gdatetime] obj = "ml_g_date_time_new_now_local"
external date_time_new_now: [>`gtimezone] obj -> [<`gdatetime] obj = "ml_g_date_time_new_now"
external date_time_new_local: int -> int -> int -> int -> int -> float -> [<`gdatetime] obj = "ml_g_date_time_new_local"
external date_time_new_from_unix_utc: int64 -> [<`gdatetime] obj = "ml_g_date_time_new_from_unix_utc"
external date_time_new_from_unix_local: int64 -> [<`gdatetime] obj = "ml_g_date_time_new_from_unix_local"
external date_time_new_from_timeval_utc: [>`gtimeval] obj -> [<`gdatetime] obj = "ml_g_date_time_new_from_timeval_utc"
external date_time_new_from_timeval_local: [>`gtimeval] obj -> [<`gdatetime] obj = "ml_g_date_time_new_from_timeval_local"
external date_time_new: [>`gtimezone] obj -> int -> int -> int -> int -> int -> float -> [<`gdatetime] obj = "ml_g_date_time_new"
external date_strftime: string -> int -> string -> [>`gdate] obj -> int = "ml_g_date_strftime"
external date_new_julian: int32 -> [<`gdate] obj = "ml_g_date_new_julian"
external date_new: unit -> [<`gdate] obj = "ml_g_date_new"
external date_is_leap_year: int -> bool = "ml_g_date_is_leap_year"
external date_get_sunday_weeks_in_year: int -> int = "ml_g_date_get_sunday_weeks_in_year"
external date_get_monday_weeks_in_year: int -> int = "ml_g_date_get_monday_weeks_in_year"
external convert_error_quark: unit -> int32 = "ml_g_convert_error_quark"
external child_watch_source_new: int -> [<`gsource] obj = "ml_g_child_watch_source_new"
external check_version: int -> int -> int -> string = "ml_glib_check_version"
external chdir: string -> int = "ml_g_chdir"
external bookmark_file_new: unit -> [<`gbookmarkfile] obj = "ml_g_bookmark_file_new"
external bookmark_file_error_quark: unit -> int32 = "ml_g_bookmark_file_error_quark"
external blow_chunks: unit -> unit = "ml_g_blow_chunks"
external bit_storage: float -> int = "ml_g_bit_storage"
external bit_nth_msf: float -> int -> int = "ml_g_bit_nth_msf"
external bit_nth_lsf: float -> int -> int = "ml_g_bit_nth_lsf"
external basename: string -> string = "ml_g_basename"
external base64_encode: string -> int -> string = "ml_g_base64_encode"
external async_queue_new: unit -> [<`gasyncqueue] obj = "ml_g_async_queue_new"
external assertion_message_expr: string -> string -> int -> string -> string -> unit = "ml_g_assertion_message_expr"
external assertion_message_error: string -> string -> int -> string -> string -> [>`gerror] obj -> int32 -> int -> unit = "ml_g_assertion_message_error"
external assertion_message_cmpstr: string -> string -> int -> string -> string -> string -> string -> string -> unit = "ml_g_assertion_message_cmpstr"
external assertion_message_cmpnum: string -> string -> int -> string -> string -> float -> string -> float -> int -> unit = "ml_g_assertion_message_cmpnum"
external assertion_message: string -> string -> int -> string -> string -> unit = "ml_g_assertion_message"
external assert_warning: string -> string -> int -> string -> string -> unit = "ml_g_assert_warning"
external ascii_xdigit_value: int -> int = "ml_g_ascii_xdigit_value"
external ascii_toupper: int -> int = "ml_g_ascii_toupper"
external ascii_tolower: int -> int = "ml_g_ascii_tolower"
external ascii_strup: string -> int -> string = "ml_g_ascii_strup"
external ascii_strncasecmp: string -> string -> int -> int = "ml_g_ascii_strncasecmp"
external ascii_strdown: string -> int -> string = "ml_g_ascii_strdown"
external ascii_strcasecmp: string -> string -> int = "ml_g_ascii_strcasecmp"
external ascii_formatd: string -> int -> string -> float -> string = "ml_g_ascii_formatd"
external ascii_dtostr: string -> int -> float -> string = "ml_g_ascii_dtostr"
external ascii_digit_value: int -> int = "ml_g_ascii_digit_value"
external allocator_new: string -> int -> [<`gallocator] obj = "ml_g_allocator_new"
external access: string -> int -> int = "ml_g_access"
(* End of global functions *)

