#include "soa_rr.h"

namespace ADNS {

	SOA_RR::SOA_RR()
	{
		rr_type = RR_TYPE::SOA;
		rr_class = RR_CLASS::IN;
		mname = gcnew DOMAIN_NAME();
		rname = gcnew DOMAIN_NAME();
	}

	DOMAIN_NAME^ SOA_RR::GetMname()
	{
		return mname->Clone();
	}

	DOMAIN_NAME^ SOA_RR::GetRname()
	{
		return rname->Clone();
	}

	Void SOA_RR::SetMname(DOMAIN_NAME^ dn)
	{
		mname = dn->Clone();
		UpdateRdata();
	}

	Void SOA_RR::SetRname(DOMAIN_NAME^ dn)
	{
		rname = dn->Clone();
		UpdateRdata();
	}

	UInt32 SOA_RR::GetSerial()
	{
		return serial;
	}

	Void SOA_RR::SetSerial(UInt32 n)
	{
		serial = n;
		UpdateRdata();
	}

	UInt32 SOA_RR::GetRefresh()
	{
		return serial;
	}

	Void SOA_RR::SetRefresh(UInt32 n)
	{
		serial = n;
		UpdateRdata();
	}

	UInt32 SOA_RR::GetRetry()
	{
		return serial;
	}

	Void SOA_RR::SetRetry(UInt32 n)
	{
		serial = n;
		UpdateRdata();
	}

	UInt32 SOA_RR::GetExpire()
	{
		return serial;
	}

	Void SOA_RR::SetExpire(UInt32 n)
	{
		serial = n;
		UpdateRdata();
	}
	UInt32 SOA_RR::GetMinimum()
	{
		return serial;
	}

	Void SOA_RR::SetMinimum(UInt32 n)
	{
		serial = n;
		UpdateRdata();
	}

	Void SOA_RR::UpdateRdata()
	{
		int overall_len;

		overall_len = mname->Size() + rname->Size() + 20;  //5 unsigned ints at 4 bytes each
		if (!rdata)
			rdata = gcnew array<Byte>(overall_len);
		else
			rdata->Resize(rdata,overall_len);

		mname->GetName()->CopyTo(rdata,0);
		rname->GetName()->CopyTo(rdata,mname->Size());
		BitConverter::GetBytes(IPAddress::HostToNetworkOrder((int) serial))->CopyTo(rdata,mname->Size() + rname->Size());
		BitConverter::GetBytes(IPAddress::HostToNetworkOrder((int) refresh))->CopyTo(rdata,mname->Size() + rname->Size() + 4);
		BitConverter::GetBytes(IPAddress::HostToNetworkOrder((int) retry))->CopyTo(rdata,mname->Size() + rname->Size() + 8);
		BitConverter::GetBytes(IPAddress::HostToNetworkOrder((int) expire))->CopyTo(rdata,mname->Size() + rname->Size() + 12);
		BitConverter::GetBytes(IPAddress::HostToNetworkOrder((int) minimum))->CopyTo(rdata,mname->Size() + rname->Size() + 16);
		return;
		
	}

	String^ SOA_RR::Print()
	{
		String^ output;
		output = PrintHeader();
		output += " ";
		output += mname->Print();
		output += " ";
		output += rname->Print();
		output += " ";
		output += Convert::ToString(serial);
		output += " ";
		output += Convert::ToString(refresh);
		output += " ";
		output += Convert::ToString(retry);
		output += " ";
		output += Convert::ToString(expire);
		output += " ";
		output += Convert::ToString(minimum);

		return output;
	}

	Void SOA_RR::ToCanonical()
	{
		owner->MakeCanonical();
		mname->MakeCanonical();
		rname->MakeCanonical();
		UpdateRdata();
		return;
	}
	
	SOA_RR^ SOA_RR::Clone()
	{
		SOA_RR^ newrr = gcnew SOA_RR();
		newrr->rr_type = rr_type;
		newrr->owner = owner->Clone();
		newrr->ttl = ttl;
		newrr->rr_class = rr_class;
		newrr->mname = mname->Clone();
		newrr->rname = rname->Clone();
		newrr->serial = serial;
		newrr->refresh = refresh;
		newrr->retry = retry;
		newrr->expire = expire;
		newrr->minimum = minimum;
		newrr->UpdateRdata();
		return newrr;
	}

	ResourceRecord^ SOA_RR::ParseResourceRecord(array<Byte>^ domainname, UInt16 rr_type, UInt16 rr_class, UInt32 ttl, UInt16 rdata_len, array<Byte>^ packet, int rdata_start)
	{
		SOA_RR^ soaout;
		array<Byte>^ tmparray;
		int reallen;
		int pos;

		soaout = gcnew SOA_RR();
		//Set the rest of the header fields
		soaout->owner = gcnew DOMAIN_NAME(domainname);
		soaout->rr_class = (RR_CLASS) rr_class;
		soaout->ttl = ttl;
		//Get MNAME
		pos = rdata_start;
		tmparray = ReadDomainFromPacket(packet, pos, reallen);
		soaout->SetMname(gcnew DOMAIN_NAME(tmparray));
		//Get RNAME
		pos += reallen;
		tmparray = ReadDomainFromPacket(packet, pos, reallen);
		soaout->SetRname(gcnew DOMAIN_NAME(tmparray));
		//Get Refresh
		pos += reallen;
		soaout->SetRefresh(IPAddress::NetworkToHostOrder((int) BitConverter::ToUInt32(packet,pos)));
		//Get Retry
		pos += 4;
		soaout->SetRetry(IPAddress::NetworkToHostOrder((int) BitConverter::ToUInt32(packet,pos)));
		//Get Expire
		pos += 4;
		soaout->SetExpire(IPAddress::NetworkToHostOrder((int) BitConverter::ToUInt32(packet,pos)));
		//Get Minimum
		pos += 4;
		soaout->SetMinimum(IPAddress::NetworkToHostOrder((int) BitConverter::ToUInt32(packet,pos)));
		return soaout;

	}

	String^ SOA_RR::PrintRR(ResourceRecord^ rec)
	{
		return safe_cast<SOA_RR^>(rec)->Print();
	}

	ResourceRecord^ SOA_RR::CloneRR(ResourceRecord^ rec)
	{
		return safe_cast<SOA_RR^>(rec)->Clone();
	}
}
