/*
 * Decompiled with CFR 0.152.
 */
package com.claritysys.jvm.builder;

import com.claritysys.jvm.builder.ByteArray;
import com.claritysys.jvm.builder.CatchBlock;
import com.claritysys.jvm.builder.CodeBlock;
import com.claritysys.jvm.builder.ElseBlock;
import com.claritysys.jvm.builder.IfBlock;
import com.claritysys.jvm.builder.Label;
import com.claritysys.jvm.builder.Opcodes;
import com.claritysys.jvm.builder.TryBlock;
import com.claritysys.jvm.classfile.CfField;
import com.claritysys.jvm.classfile.CfMethod;
import com.claritysys.jvm.classfile.ConstantPool;
import com.claritysys.jvm.classfile.CpClass;
import com.claritysys.jvm.classfile.CpRef;
import com.claritysys.jvm.classfile.CpString;
import com.claritysys.jvm.classfile.CpUtf8;
import com.claritysys.jvm.classfile.CpValue2;
import com.claritysys.jvm.classfile.LineNumber;
import com.claritysys.jvm.classfile.LocalVariable;
import com.claritysys.jvm.classfile.Utils;
import com.claritysys.jvm.disassembler.OpcodeInfo;
import com.claritysys.util.Java;
import java.util.NoSuchElementException;

public final class CodeBuilder
implements Opcodes {
    private CfMethod cfMethod;
    private ConstantPool constantPool;
    private final ByteArray code = new ByteArray();
    private CodeBlock block;
    private int nextLocalIndex;
    private LocalVariable undeclaredLocals;
    private boolean flushed;

    public CodeBuilder(CfMethod cfMethod) {
        this.init(cfMethod);
    }

    public void setMethod(CfMethod method) {
        if (!this.flushed) {
            throw new IllegalStateException("Flush prior method before re-using CodeBuilder");
        }
        this.code.reset();
        this.init(method);
    }

    public void init(CfMethod cfMethod) {
        this.cfMethod = cfMethod;
        this.constantPool = cfMethod.getConstantPool();
        this.nextLocalIndex = cfMethod.getMaxLocals();
    }

    public ByteArray getByteArray() {
        return this.code;
    }

    public LocalVariable getLocal(int slot) {
        LocalVariable local = null;
        if (slot < this.cfMethod.getMaxLocals()) {
            if (this.cfMethod.getLocals() == null) {
                this.cfMethod.createLocalsFromSignature();
            }
            local = this.cfMethod.getLocal(slot);
        } else {
            for (LocalVariable lv = this.undeclaredLocals; lv != null; lv = lv.getNext()) {
                if (lv.getIndex() != slot) continue;
                local = lv;
            }
        }
        if (local == null) {
            throw new NoSuchElementException("No local with index " + slot);
        }
        return local;
    }

    public LocalVariable addLocal(String sig, String name) {
        if (name == null) {
            name = "local_" + this.nextLocalIndex;
        }
        CpUtf8 nameCp = this.constantPool.addUtf8(name);
        CpUtf8 sigCp = this.constantPool.addUtf8(sig);
        LocalVariable local = new LocalVariable(this.cfMethod, this.code.getPC(), 0, nameCp, sigCp, this.nextLocalIndex);
        this.nextLocalIndex += Utils.getStackWords(sig);
        local.setNext(this.undeclaredLocals);
        this.undeclaredLocals = local;
        return local;
    }

    public LocalVariable addLocal(String sig) {
        return this.addLocal(sig, null);
    }

    public LocalVariable addLocal(CpClass type) {
        return this.addLocal(type, null);
    }

    public LocalVariable addLocal(CpClass type, String name) {
        String stringName = type.getStringName();
        StringBuffer buf = new StringBuffer(stringName.length() + 2);
        buf.append('L').append(stringName).append(';');
        return this.addLocal(buf.toString(), name);
    }

    public void setLineNumber(int line) {
        LineNumber lineNumber = new LineNumber(this.code.getPC(), line);
        this.cfMethod.addLine(lineNumber);
    }

    public CfMethod getMethod() {
        return this.cfMethod;
    }

    public int getMaxLocals() {
        return this.nextLocalIndex;
    }

    public int getMaxStack() {
        return this.code.getMaxStack();
    }

    public Label createLabel() {
        return new Label(this.code);
    }

    public Label defineLabel() {
        Label label = this.createLabel();
        label.define();
        return label;
    }

    public void flush() {
        while (this.block != null) {
            this.blockEnd();
        }
        this.defineLocals(this.undeclaredLocals, this.getByteArray().getPC());
        this.undeclaredLocals = null;
        this.cfMethod.setCode(this.code.getCode());
        this.cfMethod.setMaxLocals(this.getMaxLocals());
        this.cfMethod.setMaxStack(this.getMaxStack() + 1);
        this.flushed = true;
        this.cfMethod.getClassFile().releaseCodeBuilder(this);
    }

    public void defineLocals(LocalVariable undeclaredLocals, int endPc) {
        for (LocalVariable local = undeclaredLocals; local != null; local = local.getNext()) {
            local.setLength(endPc - local.getStartPc());
            this.cfMethod.addLocal(local);
        }
    }

    public String addImport(String fqClassName) {
        return this.constantPool.addImport(fqClassName);
    }

    public void add(short opcode) {
        if (opcode > 256) {
            if (opcode == 1010) {
                this.emitReturn();
                return;
            }
            throw new IllegalArgumentException("Virtual opcode " + opcode + " requires parameter(s).");
        }
        if (NO_OF_OPERANDS[opcode] != 0) {
            throw new IllegalArgumentException("Opcode " + OPCODE_NAMES[opcode] + " requires one or more operands.");
        }
        this.code.putOpcode(opcode);
    }

    public void add(short opcode, long l) {
        if (opcode != 1020) {
            throw new IllegalArgumentException("Only xLCONST supports 'long' operand");
        }
        if (l == 0L) {
            this.add((short)9);
        } else if (l == 1L) {
            this.add((short)10);
        } else {
            CpValue2 cpValue2 = this.constantPool.addLong(l);
            this.add((short)20, cpValue2.getIndex());
        }
    }

    public void add(short opcode, double d) {
        if (opcode != 1030) {
            throw new IllegalArgumentException("Only xDCONST supports 'double' operand");
        }
        if (d == 0.0) {
            this.add((short)14);
        } else if (d == 1.0) {
            this.add((short)15);
        } else {
            CpValue2 cpValue2 = this.constantPool.addDouble(d);
            this.add((short)20, cpValue2.getIndex());
        }
    }

    public void add(short opcode, int i) {
        if (opcode > 256) {
            if (opcode == 1015) {
                this.emitPushInt(i);
                return;
            }
            if (opcode == 1020) {
                this.add(opcode, (long)i);
                return;
            }
            throw new IllegalArgumentException("Can't use VOP " + opcode + " in <int> form.");
        }
        if (NO_OF_OPERANDS[opcode] != 1) {
            throw new IllegalArgumentException("Opcode " + OPCODE_NAMES[opcode] + " takes " + NO_OF_OPERANDS[opcode] + " parameters, not 1.");
        }
        this.code.putOpcode(opcode);
        short type = TYPE_OF_OPERANDS[opcode][0];
        if (type == 8) {
            this.code.put1(i);
        } else if (type == 9) {
            this.code.put2(i);
        } else if (type == 10) {
            this.code.put4(i);
        } else {
            throw new IllegalArgumentException("Unknown type: " + type);
        }
    }

    public void add(short opcode, Class clas) {
        this.add(opcode, this.constantPool.addClass(clas));
    }

    public void add(short opcode, CpClass clas) {
        this.checkParam(opcode, 11);
        this.code.putOpcode(opcode);
        this.code.put2(clas.getIndex());
    }

    public void add(short opcode, String s1) {
        switch (OpcodeInfo.OPERAND_INTERPRETATION[opcode][0]) {
            case 11: {
                CpClass clas = this.constantPool.addClass(s1);
                this.add(opcode, clas);
                break;
            }
            case 9: {
                CpClass defaultClass = this.getMethod().getClassFile().getClassCp();
                boolean isInterface = opcode == 185;
                CpRef methodRef = this.constantPool.addMethodRef(isInterface, defaultClass, s1);
                this.add(opcode, methodRef);
                break;
            }
            case 3: 
            case 4: {
                CpString cpString = this.constantPool.addString(s1);
                int index = cpString.getIndex();
                this.emitLoadConstant(index);
                break;
            }
            default: {
                throw new IllegalArgumentException("Can't convert String for arg");
            }
        }
    }

    public void add(short opcode, String type, int count) {
        if (opcode != 197) {
            throw new IllegalArgumentException("This format only valid for MULTIANEWARRAY");
        }
        CpClass cpType = this.constantPool.addClass(type);
        this.code.putOpcode(opcode);
        this.code.put2(cpType.getIndex());
        this.code.put1(count);
        this.code.adjustStack(-count);
        this.code.adjustStack(1);
    }

    public void add(short opcode, String s1, String s2) {
        switch (OpcodeInfo.OPERAND_INTERPRETATION[opcode][0]) {
            case 8: {
                this.add(opcode, this.constantPool.addFieldRefJL(s1, s2));
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad call format: " + OPCODE_NAMES[opcode] + " (" + s1 + "," + s2 + ")");
            }
        }
    }

    public void add(short opcode, Label f) {
        this.checkParam(opcode, 7);
        int offset = f.getOffset(false);
        this.code.putOpcode(opcode);
        this.code.put2(offset);
    }

    public void add(short opcode, String className, String methodName, Class returnType, Class[] paramTypes) {
        String vmSig = Java.getVmSignature((Class[])paramTypes, (Class)returnType);
        this.add(opcode, this.constantPool.addMethodRef(opcode == 185, className, methodName, vmSig));
    }

    public void add(short opcode, String className, String methodName, String sig) {
        this.add(opcode, this.constantPool.addMethodRef(opcode == 185, className, methodName, sig));
    }

    public void add(short opcode, CfField field) {
        this.emitFieldOp(opcode, field.getRef());
    }

    public void add(short opcode, CfMethod method) {
        this.add(opcode, method.getRef());
    }

    public void add(short opcode, CpRef ref) {
        if (ref.getTag() == 9) {
            this.emitFieldOp(opcode, ref);
            return;
        }
        if (opcode != 185) {
            this.checkParam(opcode, 9);
            if (ref.getTag() != 10) {
                throw new IllegalArgumentException(OPCODE_NAMES[opcode] + " requires have METHODREF argument, not: " + ref);
            }
        } else if (ref.getTag() != 11) {
            throw new IllegalArgumentException(OPCODE_NAMES[opcode] + " requires have INTERFACE_METHODREF argument, not: " + ref);
        }
        this.code.putOpcode(opcode);
        this.code.put2(ref.getIndex());
        int consume = ref.getNonStaticStackSize();
        if (opcode == 184) {
            --consume;
        }
        this.code.adjustStack(-consume);
        int produce = ref.getStackSize();
        this.code.adjustStack(produce);
        if (opcode == 185) {
            this.code.put1(consume);
            this.code.put1(0);
        }
    }

    public void add(short opcode, LocalVariable var) {
        if (opcode > 256) {
            if (opcode == 1000) {
                this.emitLoad(var);
            } else if (opcode == 1005) {
                this.emitStore(var);
            } else {
                throw new IllegalArgumentException("Virtual opcode " + opcode + " can't reference local variable.");
            }
            return;
        }
        this.checkParam(opcode, 6);
        this.code.putOpcode(opcode);
        this.code.put1(var.getIndex());
    }

    public void add(short opcode, LocalVariable var, int n) {
        if (opcode != 132) {
            throw new IllegalArgumentException("Only IINC allowed.");
        }
        int slot = var.getIndex();
        if (slot > 255 || n < -128 || n > 127) {
            this.code.putOpcode(opcode);
            this.code.put2(slot);
            this.code.put2(n);
        } else {
            this.code.putOpcode(opcode);
            this.code.put1(slot);
            this.code.put1(n);
        }
    }

    public void blockEnd() {
        this.block.end();
        if (this.block instanceof IfBlock) {
            this.add((short)0);
        }
        this.popBlock();
    }

    public void blockStart() {
        throw new UnsupportedOperationException("TODO");
    }

    public void blockIf(short opcode) {
        IfBlock block = (IfBlock)this.pushBlock(new IfBlock(this));
        this.add(opcode, block.getEndLabel());
        block.start();
    }

    public void blockIfEQ() {
        this.blockIf((short)154);
    }

    public void blockIfNE() {
        this.blockIf((short)153);
    }

    public void blockIfEQ(int type) {
        switch (type) {
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                this.blockIf((short)160);
                break;
            }
            case 7: {
                this.add((short)151);
                this.blockIf((short)154);
                break;
            }
            case 6: {
                this.add((short)149);
                this.blockIf((short)154);
                break;
            }
            case 11: {
                this.add((short)148);
                this.blockIf((short)154);
                break;
            }
            default: {
                throw new IllegalArgumentException("blockIfEQ(type) can only be used with primitive types, not type=" + type + ". " + "Use blockIfObjectsEQ() for object" + " types.");
            }
        }
    }

    public void blockIfObjectsEQ() {
        this.blockIf((short)166);
    }

    public void blockIfObjectsNE() {
        this.blockIf((short)165);
    }

    public void blockIfNull() {
        this.blockIf((short)199);
    }

    public void blockIfNotNull() {
        this.blockIf((short)198);
    }

    public void blockIfFalse() {
        this.blockIfEQ();
    }

    public void blockIfTrue() {
        this.blockIfNE();
    }

    public void blockElse() {
        CodeBlock current = this.block;
        if (!(current instanceof IfBlock)) {
            throw new IllegalStateException("No If block in scope, can't have Else!");
        }
        IfBlock ifBlock = (IfBlock)this.block;
        this.popBlock();
        ElseBlock elseBlock = (ElseBlock)this.pushBlock(new ElseBlock(this));
        if (!this.code.isUnreachable()) {
            this.add((short)167, elseBlock.getEndLabel());
        }
        ifBlock.end();
        elseBlock.start();
    }

    public void blockTry() {
        TryBlock block = (TryBlock)this.pushBlock(new TryBlock(this));
        block.start();
    }

    public void blockCatch(LocalVariable catchAndStore) {
        String s = catchAndStore.getDescriptor().getString();
        if (!s.startsWith("L")) {
            throw new IllegalArgumentException("Catch variable must be object type.");
        }
        s = s.substring(1, s.length() - 1);
        this.blockCatch(s);
        this.add((short)58, catchAndStore);
    }

    public void blockCatch(String exceptionType) {
        CodeBlock current = this.block;
        if (!(current instanceof TryBlock) && !(current instanceof CatchBlock)) {
            throw new IllegalStateException("No try or catch block in scope, can't have catch!");
        }
        CodeBlock tryOrCatchBlock = this.block;
        this.popBlock();
        TryBlock tryBlock = tryOrCatchBlock instanceof TryBlock ? (TryBlock)tryOrCatchBlock : ((CatchBlock)tryOrCatchBlock).getTryBlock();
        CpClass catchType = this.constantPool.addClass(exceptionType);
        CatchBlock catchBlock = (CatchBlock)this.pushBlock(new CatchBlock(this, tryBlock, catchType));
        if (!this.code.isUnreachable()) {
            this.add((short)167, tryOrCatchBlock.getEndLabel());
            catchBlock.setEndLabel(tryOrCatchBlock.getEndLabel());
            tryOrCatchBlock.clearEndLabel();
        }
        tryOrCatchBlock.end();
        catchBlock.start();
    }

    public void blockFinally() {
        throw new UnsupportedOperationException("TODO");
    }

    private void emitFieldOp(short opcode, CpRef f) {
        this.checkParam(opcode, 8);
        this.code.putOpcode(opcode);
        this.code.put2(f.getIndex());
        if (opcode == 180) {
            this.code.adjustStack(f.getStackSize());
        } else if (opcode == 181) {
            this.code.adjustStack(-f.getStackSize());
        } else if (opcode == 178) {
            this.code.adjustStack(f.getStackSize());
        } else if (opcode == 179) {
            this.code.adjustStack(-f.getStackSize());
        }
    }

    private void emitPushInt(int i) {
        if (i >= -1 && i <= 5) {
            this.code.putOpcode(i + 3);
        } else if (i >= -128 && i < 128) {
            this.code.putOpcode(16);
            this.code.put1(i);
        } else if (i >= Short.MIN_VALUE && i < 32768) {
            this.code.putOpcode(17);
            this.code.put2(i);
        } else {
            this.emitLoadConstant(this.constantPool.addInteger(i).getIndex());
        }
    }

    private void emitLoad(LocalVariable v) {
        int opcode;
        int index = v.getIndex();
        switch (v.getType()) {
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                opcode = 21;
                break;
            }
            case 11: {
                opcode = 22;
                break;
            }
            case 7: {
                opcode = 24;
                break;
            }
            case 6: {
                opcode = 23;
                break;
            }
            case 13: 
            case 14: {
                opcode = 25;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.emitLoad(opcode, index);
    }

    private void emitLoad(int opcode, int index) {
        if (index < 4) {
            int betterOpcode = (opcode - 21 << 2) + 26 + index;
            this.code.putOpcode(betterOpcode);
        } else {
            this.code.putOpcode(opcode);
            this.code.put1(index);
        }
    }

    private void emitLoadConstant(int index) {
        if (index > 255) {
            this.code.putOpcode(19);
            this.code.put2(index);
        } else {
            this.code.putOpcode(18);
            this.code.put1(index);
        }
    }

    private void emitReturn() {
        int opcode;
        switch (this.cfMethod.getReturnType()) {
            case 12: {
                opcode = 177;
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                opcode = 172;
                break;
            }
            case 11: {
                opcode = 173;
                break;
            }
            case 7: {
                opcode = 175;
                break;
            }
            case 6: {
                opcode = 174;
                break;
            }
            case 13: 
            case 14: {
                opcode = 176;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown method return type: " + this.cfMethod.getReturnType());
            }
        }
        this.code.putOpcode(opcode);
        this.code.setUnreachable(true);
    }

    private void emitStore(LocalVariable v) {
        int opcode;
        switch (v.getType()) {
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                opcode = 54;
                break;
            }
            case 11: {
                opcode = 55;
                break;
            }
            case 7: {
                opcode = 57;
                break;
            }
            case 6: {
                opcode = 56;
                break;
            }
            case 13: 
            case 14: {
                opcode = 58;
                break;
            }
            default: {
                throw new IllegalStateException("Can't generate STORE for type: " + v.getType());
            }
        }
        this.emitStore(opcode, v.getIndex());
    }

    private void emitStore(int opcode, int index) {
        if (index < 4) {
            int betterOpcode = (opcode - 54 << 2) + 59 + index;
            this.code.putOpcode(betterOpcode);
        } else {
            this.code.putOpcode(opcode);
            this.code.put1(index);
        }
    }

    private void checkParam(int opcode, int paramType) {
        int[] INTERP = OpcodeInfo.OPERAND_INTERPRETATION[opcode];
        if (INTERP.length != 1) {
            throw new IllegalArgumentException("Opcode " + OPCODE_NAMES[opcode] + " takes " + INTERP.length + " params.");
        }
        if (INTERP[0] != paramType) {
            throw new IllegalArgumentException("Opcode " + OPCODE_NAMES[opcode] + " cannot take operand type: OpcodeInfo." + paramType);
        }
    }

    private CodeBlock pushBlock(CodeBlock newBlock) {
        newBlock.setSurroundingBlock(this.block);
        this.block = newBlock;
        return newBlock;
    }

    private CodeBlock popBlock() {
        if (this.block == null) {
            return null;
        }
        this.block = this.block.getSurroundingBlock();
        return this.block;
    }
}

