package Business::EDI::CodeList::DiscrepancyNatureIdentificationCode;

use base 'Business::EDI::CodeList';
my $VERSION     = 0.02;
sub list_number {4221;}
my $usage       = 'B';

# 4221  Discrepancy nature identification code                  [B]
# Desc: Code specifying the identification used to define the
# nature of a discrepancy.
# Repr: an..3

my %code_hash = (
'AA' => [ 'Item discontinued by wholesaler',
    'The wholesaler no longer offers the ordered product.' ],
'AB' => [ 'Item no longer produced',
    'The item ordered has been discontinued and is no longer in production.' ],
'AC' => [ 'Over-shipped',
    'Code indicating that there was an excess quantity of goods in a shipment relative to the order.' ],
'AD' => [ 'Item out of stock at manufacturer',
    'The item is out of stock at manufacturer.' ],
'AE' => [ 'Delivered but not advised',
    'Shipment or goods have been delivered without any advance notification of delivery.' ],
'AF' => [ 'Goods delivered damaged',
    'Part or all of the goods in a shipment were delivered damaged.' ],
'AG' => [ 'Delivered too late',
    'Delivered but at a later date than the delivery date under the agreed conditions or stipulated in the order.' ],
'AH' => [ 'Next higher packaging quantity',
    'The ordered item has been, or is to be, packed to the next higher packaging quantity.' ],
'AN' => [ 'Available now - no shipping schedule',
    'The material is available for shipment but there is no authorization for movement known.' ],
'AS' => [ 'Available now - scheduled to ship (date)',
    'The material is available for shipment and is committed for shipment/delivery at a future date.' ],
'BK' => [ 'Back ordered from previous order',
    'An order is being held as no material is available to fulfil the requirement.' ],
'BP' => [ 'Shipment partial - back order to follow',
    'A portion of the previous order is being held as open, as enough material was not available to fulfil the requirement.' ],
'CA' => [ 'Customer inquiry - all items',
    'The response includes information concerning all of the issues included in the prior inquiry.' ],
'CC' => [ 'Shipment complete',
    'The quantity dispatched fulfilled the order quantity.' ],
'CE' => [ 'Shipment includes extra items to meet price break',
    'The quantity dispatched exceeds the order quantity to accommodate a quantity of scale price model opportunity.' ],
'CI' => [ 'Customer inquiry - shipped items only',
    'The response includes information addressing only of the items dispatched that were included in the prior inquiry.' ],
'CK' => [ 'Cancelled from previous order',
    'Amount deleted from the earlier schedule.' ],
'CM' => [ 'Shipment complete with additional quantity',
    'The quantity dispatched exceeds the ordered quantity.' ],
'CO' => [ 'Customer inquiry - unshipped items only',
    'The response includes information addressing only the items that have not been dispatched, that were included in the prior inquiry.' ],
'CP' => [ 'Shipment partial - considered complete, no backorder',
    'The quantity shipped is less than the amount authorized and there is no plan to ship the remaining amount.' ],
'CS' => [ 'Shipment complete with substitution',
    'The quantity and product shipped, though not exactly matching the original order, is compliant with and fulfils the expectation.' ],
'IC' => [ 'Item cancelled',
    'The material previously ordered is no longer needed.' ],
'IS' => [ 'Item represents substitution from original order',
    'The quantity and product shipped is compliant with the expectation.' ],
'LS' => [ 'Last shipment (date)',
    'The date that the most recent material dispatch was made.' ],
'NF' => [ 'Not yet published',
    'The product requested is not publicly available at this time.' ],
'NN' => [ 'Not in process - no shipping schedule',
    'The product requested is neither available nor in process, as there is not an authorization to manufacture product.' ],
'NS' => [ 'Not in process - schedule to ship (date)',
    'The product requested is neither available nor in process. A planned dispatch date has been provided.' ],
'OF' => [ 'Order sent to factory for production (date)',
    'The product requested is not available. The schedule has been forwarded to manufacturing for inclusion on this date.' ],
'OM' => [ 'Item sent to factory for production (date)',
    'The product has been moved to the manufacturing area and scheduled for completion on the following date.' ],
'OP' => [ 'Out of print',
    'Item is no longer available.' ],
'OS' => [ 'Item out of stock because of strike or force majeure',
    'Item is not available due to strike or an unforeseeable event.' ],
'OW' => [ 'Item out of stock at wholesaler',
    'Item is not available at the distribution point.' ],
'PA' => [ 'Purchase order inquiry - all items',
    'The response includes information concerning all of the articles included in the prior inquiry that had been requested by the contact initiator.' ],
'PD' => [ 'Purchase order complete',
    'The amount fulfilling the requirements of the contract.' ],
'PI' => [ 'Purchase order inquiry - shipped items only',
    'The response includes information concerning all of the articles that were dispatched and included in the prior inquiry that had been requested by the contact initiator.' ],
'PK' => [ 'Packed-to-date (date)',
    'Quantity represents the amount processed and ready for shipment at this date.' ],
'PN' => [ 'In process - no shipping schedule',
    'This amount is being manufactured in anticipation for a possible authorization for shipment.' ],
'PO' => [ 'Purchase order inquiry - unshipped items only',
    'The response includes information concerning all of the articles that were not dispatched and included in the prior inquiry that had been requested by the contact initiator.' ],
'PP' => [ 'Purchase order inquiry - specific items',
    'The response includes information concerning a unique sub-set of the total list of articles that the contract initiator had requested information on.' ],
'PS' => [ 'In process - scheduled to ship (date)',
    'This amount is being manufactured in anticipation for a possible authorization for shipment.' ],
'RA' => [ 'Item rationed',
    'Product is restricted because of limited availability.' ],
'SL' => [ 'Shipped-to-date (date)',
    'Cumulative amount shipped through this date.' ],
'SP' => [ 'Scheduled for production at factory',
    'Product is anticipated for manufacture on this date.' ],
'SS' => [ 'Split shipment',
    'Shipment is only part of the ordered quantity.' ],
'TW' => [ 'Item temporary discontinued by wholesaler',
    'Product is, for the time being, not available from the distribution point.' ],
'UR' => [ 'Unsolicited report',
    'The product information was provided voluntarily.' ],
'US' => [ 'Pack to closest complete logistic packaging quantity',
    'Pack to the closest complete logistic packaging quantity.' ],
'UT' => [ 'Pack to next lower complete logistic quantity',
    'Pack to the next lower complete logistic packaging quantity.' ],
'ZZZ' => [ 'Mutually defined',
    'A code assigned within a code list to be used on an interim basis and as defined among trading partners until a precise code can be assigned to the code list.' ],
);
sub get_codes { return \%code_hash; }

1;
