/*--------------------------------------------------------------------------+
$Id: Model.java 26268 2010-02-18 10:44:30Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.test.example;

import java.util.ArrayList;
import java.util.List;

import edu.tum.cs.commons.clone.IDeepCloneable;

/**
 * Model class.
 * 
 * @author Florian Deissenboeck
 * @author $Author: juergens $
 * @version $Rev: 26268 $
 * @levd.rating GREEN Hash: 48D37F79B9AE6F146AF21AE4FBAF10E3
 */
public class Model implements IDeepCloneable {

	/** The persons. */
	private final ArrayList<Person> persons = new ArrayList<Person>();

	/** Create model. */
	public Model() {
		super();
	}

	/** Copy constructor. */
	private Model(Model orig) {
		for (Person person : orig.persons) {
			add(person.deepClone());
		}
	}

	/** Add a person. */
	public void add(Person person) {
		persons.add(person);
	}

	/** Get list of persons. */
	public List<Person> getPersons() {
		return persons;
	}

	/** Create deep clone. */
	public Model deepClone() {
		return new Model(this);
	}

}