// Copyright (c) 2019 - 2021, Osamu Watanabe
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
//    modification, are permitted provided that the following conditions are met:
//
// 1. Redistributions of source code must retain the above copyright notice, this
// list of conditions and the following disclaimer.
//
// 2. Redistributions in binary form must reproduce the above copyright notice,
// this list of conditions and the following disclaimer in the documentation
// and/or other materials provided with the distribution.
//
// 3. Neither the name of the copyright holder nor the names of its
// contributors may be used to endorse or promote products derived from
// this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
//    IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
//    FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
//    DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
//    SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
//    CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

#pragma once

static const uint16_t dec_CxtVLC_table1_fast_16[1024] = {
    0x0016, 0x006A, 0x0046, 0x00DD, 0x0086, 0x888B, 0x0026, 0x444D, 0x0016, 0x00AA, 0x0046, 0x88AD, 0x0086,
    0x003A, 0x0026, 0x00DE, 0x0016, 0x00CA, 0x0046, 0x009D, 0x0086, 0x005A, 0x0026, 0x222D, 0x0016, 0x009A,
    0x0046, 0x007D, 0x0086, 0x01FD, 0x0026, 0x007E, 0x0016, 0x006A, 0x0046, 0x88CD, 0x0086, 0x888B, 0x0026,
    0x111D, 0x0016, 0x00AA, 0x0046, 0x005D, 0x0086, 0x003A, 0x0026, 0x00EE, 0x0016, 0x00CA, 0x0046, 0x00BD,
    0x0086, 0x005A, 0x0026, 0x11FF, 0x0016, 0x009A, 0x0046, 0x003D, 0x0086, 0x04ED, 0x0026, 0x2AAF, 0x0016,
    0x006A, 0x0046, 0x00DD, 0x0086, 0x888B, 0x0026, 0x444D, 0x0016, 0x00AA, 0x0046, 0x88AD, 0x0086, 0x003A,
    0x0026, 0x44EF, 0x0016, 0x00CA, 0x0046, 0x009D, 0x0086, 0x005A, 0x0026, 0x222D, 0x0016, 0x009A, 0x0046,
    0x007D, 0x0086, 0x01FD, 0x0026, 0x00BE, 0x0016, 0x006A, 0x0046, 0x88CD, 0x0086, 0x888B, 0x0026, 0x111D,
    0x0016, 0x00AA, 0x0046, 0x005D, 0x0086, 0x003A, 0x0026, 0x4CCF, 0x0016, 0x00CA, 0x0046, 0x00BD, 0x0086,
    0x005A, 0x0026, 0x00FE, 0x0016, 0x009A, 0x0046, 0x003D, 0x0086, 0x04ED, 0x0026, 0x006F, 0x0002, 0x0088,
    0x0002, 0x005C, 0x0002, 0x0018, 0x0002, 0x00DE, 0x0002, 0x0028, 0x0002, 0x009C, 0x0002, 0x004A, 0x0002,
    0x007E, 0x0002, 0x0088, 0x0002, 0x00CC, 0x0002, 0x0018, 0x0002, 0x888F, 0x0002, 0x0028, 0x0002, 0x00FE,
    0x0002, 0x003A, 0x0002, 0x222F, 0x0002, 0x0088, 0x0002, 0x04FD, 0x0002, 0x0018, 0x0002, 0x00BE, 0x0002,
    0x0028, 0x0002, 0x00BF, 0x0002, 0x004A, 0x0002, 0x006E, 0x0002, 0x0088, 0x0002, 0x00AC, 0x0002, 0x0018,
    0x0002, 0x444F, 0x0002, 0x0028, 0x0002, 0x00EE, 0x0002, 0x003A, 0x0002, 0x113F, 0x0002, 0x0088, 0x0002,
    0x005C, 0x0002, 0x0018, 0x0002, 0x00CF, 0x0002, 0x0028, 0x0002, 0x009C, 0x0002, 0x004A, 0x0002, 0x006F,
    0x0002, 0x0088, 0x0002, 0x00CC, 0x0002, 0x0018, 0x0002, 0x009F, 0x0002, 0x0028, 0x0002, 0x00EF, 0x0002,
    0x003A, 0x0002, 0x233F, 0x0002, 0x0088, 0x0002, 0x04FD, 0x0002, 0x0018, 0x0002, 0x00AF, 0x0002, 0x0028,
    0x0002, 0x44FF, 0x0002, 0x004A, 0x0002, 0x005F, 0x0002, 0x0088, 0x0002, 0x00AC, 0x0002, 0x0018, 0x0002,
    0x007F, 0x0002, 0x0028, 0x0002, 0x00DF, 0x0002, 0x003A, 0x0002, 0x111F, 0x0002, 0x0028, 0x0002, 0x005C,
    0x0002, 0x008A, 0x0002, 0x00BF, 0x0002, 0x0018, 0x0002, 0x00FE, 0x0002, 0x00CC, 0x0002, 0x007E, 0x0002,
    0x0028, 0x0002, 0x8FFF, 0x0002, 0x004A, 0x0002, 0x007F, 0x0002, 0x0018, 0x0002, 0x00DF, 0x0002, 0x00AC,
    0x0002, 0x133F, 0x0002, 0x0028, 0x0002, 0x222D, 0x0002, 0x008A, 0x0002, 0x00BE, 0x0002, 0x0018, 0x0002,
    0x44EF, 0x0002, 0x2AAD, 0x0002, 0x006E, 0x0002, 0x0028, 0x0002, 0x15FF, 0x0002, 0x004A, 0x0002, 0x009E,
    0x0002, 0x0018, 0x0002, 0x00CF, 0x0002, 0x003C, 0x0002, 0x223F, 0x0002, 0x0028, 0x0002, 0x005C, 0x0002,
    0x008A, 0x0002, 0x2BBF, 0x0002, 0x0018, 0x0002, 0x04EF, 0x0002, 0x00CC, 0x0002, 0x006F, 0x0002, 0x0028,
    0x0002, 0x27FF, 0x0002, 0x004A, 0x0002, 0x009F, 0x0002, 0x0018, 0x0002, 0x00DE, 0x0002, 0x00AC, 0x0002,
    0x444F, 0x0002, 0x0028, 0x0002, 0x222D, 0x0002, 0x008A, 0x0002, 0x8AAF, 0x0002, 0x0018, 0x0002, 0x00EE,
    0x0002, 0x2AAD, 0x0002, 0x005F, 0x0002, 0x0028, 0x0002, 0x44FF, 0x0002, 0x004A, 0x0002, 0x888F, 0x0002,
    0x0018, 0x0002, 0xAAAF, 0x0002, 0x003C, 0x0002, 0x111F, 0x0004, 0x8FFD, 0x0028, 0x005C, 0x0004, 0x00BC,
    0x008A, 0x66FF, 0x0004, 0x00CD, 0x0018, 0x111D, 0x0004, 0x009C, 0x003A, 0x8AAF, 0x0004, 0x00FC, 0x0028,
    0x133D, 0x0004, 0x00AC, 0x004A, 0x3BBF, 0x0004, 0x2BBD, 0x0018, 0x5FFF, 0x0004, 0x006C, 0x157D, 0x455F,
    0x0004, 0x2FFD, 0x0028, 0x222D, 0x0004, 0x22AD, 0x008A, 0x44EF, 0x0004, 0x00CC, 0x0018, 0x4FFF, 0x0004,
    0x007C, 0x003A, 0x447F, 0x0004, 0x04DD, 0x0028, 0x233D, 0x0004, 0x009D, 0x004A, 0x00DE, 0x0004, 0x88BD,
    0x0018, 0xAFFF, 0x0004, 0x115D, 0x1FFD, 0x444F, 0x0004, 0x8FFD, 0x0028, 0x005C, 0x0004, 0x00BC, 0x008A,
    0x8CEF, 0x0004, 0x00CD, 0x0018, 0x111D, 0x0004, 0x009C, 0x003A, 0x888F, 0x0004, 0x00FC, 0x0028, 0x133D,
    0x0004, 0x00AC, 0x004A, 0x44DF, 0x0004, 0x2BBD, 0x0018, 0x8AFF, 0x0004, 0x006C, 0x157D, 0x006F, 0x0004,
    0x2FFD, 0x0028, 0x222D, 0x0004, 0x22AD, 0x008A, 0x00EE, 0x0004, 0x00CC, 0x0018, 0x2EEF, 0x0004, 0x007C,
    0x003A, 0x277F, 0x0004, 0x04DD, 0x0028, 0x233D, 0x0004, 0x009D, 0x004A, 0x1BBF, 0x0004, 0x88BD, 0x0018,
    0x37FF, 0x0004, 0x115D, 0x1FFD, 0x333F, 0x0002, 0x0088, 0x0002, 0x02ED, 0x0002, 0x00CA, 0x0002, 0x4CCF,
    0x0002, 0x0048, 0x0002, 0x23FF, 0x0002, 0x001A, 0x0002, 0x888F, 0x0002, 0x0088, 0x0002, 0x006C, 0x0002,
    0x002A, 0x0002, 0x00AF, 0x0002, 0x0048, 0x0002, 0x22EF, 0x0002, 0x00AC, 0x0002, 0x005F, 0x0002, 0x0088,
    0x0002, 0x444D, 0x0002, 0x00CA, 0x0002, 0xCCCF, 0x0002, 0x0048, 0x0002, 0x00FE, 0x0002, 0x001A, 0x0002,
    0x006F, 0x0002, 0x0088, 0x0002, 0x005C, 0x0002, 0x002A, 0x0002, 0x009F, 0x0002, 0x0048, 0x0002, 0x00DF,
    0x0002, 0x03FD, 0x0002, 0x222F, 0x0002, 0x0088, 0x0002, 0x02ED, 0x0002, 0x00CA, 0x0002, 0x8CCF, 0x0002,
    0x0048, 0x0002, 0x11FF, 0x0002, 0x001A, 0x0002, 0x007E, 0x0002, 0x0088, 0x0002, 0x006C, 0x0002, 0x002A,
    0x0002, 0x007F, 0x0002, 0x0048, 0x0002, 0x00EE, 0x0002, 0x00AC, 0x0002, 0x003E, 0x0002, 0x0088, 0x0002,
    0x444D, 0x0002, 0x00CA, 0x0002, 0x00BE, 0x0002, 0x0048, 0x0002, 0x00BF, 0x0002, 0x001A, 0x0002, 0x003F,
    0x0002, 0x0088, 0x0002, 0x005C, 0x0002, 0x002A, 0x0002, 0x009E, 0x0002, 0x0048, 0x0002, 0x00DE, 0x0002,
    0x03FD, 0x0002, 0x111F, 0x0004, 0x8AED, 0x0048, 0x888D, 0x0004, 0x00DC, 0x00CA, 0x3FFF, 0x0004, 0xCFFD,
    0x002A, 0x003D, 0x0004, 0x00BC, 0x005A, 0x8DDF, 0x0004, 0x8FFD, 0x0048, 0x006C, 0x0004, 0x027D, 0x008A,
    0x99FF, 0x0004, 0x00EC, 0x00FA, 0x003C, 0x0004, 0x00AC, 0x001A, 0x009F, 0x0004, 0x2FFD, 0x0048, 0x007C,
    0x0004, 0x44CD, 0x00CA, 0x67FF, 0x0004, 0x1FFD, 0x002A, 0x444D, 0x0004, 0x00AD, 0x005A, 0x8CCF, 0x0004,
    0x4FFD, 0x0048, 0x445D, 0x0004, 0x01BD, 0x008A, 0x4EEF, 0x0004, 0x45DD, 0x00FA, 0x111D, 0x0004, 0x009C,
    0x001A, 0x222F, 0x0004, 0x8AED, 0x0048, 0x888D, 0x0004, 0x00DC, 0x00CA, 0xAFFF, 0x0004, 0xCFFD, 0x002A,
    0x003D, 0x0004, 0x00BC, 0x005A, 0x11BF, 0x0004, 0x8FFD, 0x0048, 0x006C, 0x0004, 0x027D, 0x008A, 0x22EF,
    0x0004, 0x00EC, 0x00FA, 0x003C, 0x0004, 0x00AC, 0x001A, 0x227F, 0x0004, 0x2FFD, 0x0048, 0x007C, 0x0004,
    0x44CD, 0x00CA, 0x5DFF, 0x0004, 0x1FFD, 0x002A, 0x444D, 0x0004, 0x00AD, 0x005A, 0x006F, 0x0004, 0x4FFD,
    0x0048, 0x445D, 0x0004, 0x01BD, 0x008A, 0x11DF, 0x0004, 0x45DD, 0x00FA, 0x111D, 0x0004, 0x009C, 0x001A,
    0x155F, 0x0006, 0x00FC, 0x0018, 0x111D, 0x0048, 0x888D, 0x00AA, 0x4DDF, 0x0006, 0x2AAD, 0x005A, 0x67FF,
    0x0028, 0x223D, 0x00BC, 0xAAAF, 0x0006, 0x00EC, 0x0018, 0x5FFF, 0x0048, 0x006C, 0x008A, 0xCCCF, 0x0006,
    0x009D, 0x00CA, 0x44EF, 0x0028, 0x003C, 0x8FFD, 0x137F, 0x0006, 0x8EED, 0x0018, 0x1FFF, 0x0048, 0x007C,
    0x00AA, 0x4CCF, 0x0006, 0x227D, 0x005A, 0x1DDF, 0x0028, 0x444D, 0x4FFD, 0x155F, 0x0006, 0x00DC, 0x0018,
    0x2EEF, 0x0048, 0x445D, 0x008A, 0x22BF, 0x0006, 0x009C, 0x00CA, 0x8CDF, 0x0028, 0x222D, 0x2FFD, 0x226F,
    0x0006, 0x00FC, 0x0018, 0x111D, 0x0048, 0x888D, 0x00AA, 0x1BBF, 0x0006, 0x2AAD, 0x005A, 0x33FF, 0x0028,
    0x223D, 0x00BC, 0x8AAF, 0x0006, 0x00EC, 0x0018, 0x9BFF, 0x0048, 0x006C, 0x008A, 0x8ABF, 0x0006, 0x009D,
    0x00CA, 0x4EEF, 0x0028, 0x003C, 0x8FFD, 0x466F, 0x0006, 0x8EED, 0x0018, 0xCFFF, 0x0048, 0x007C, 0x00AA,
    0x8CCF, 0x0006, 0x227D, 0x005A, 0xAEEF, 0x0028, 0x444D, 0x4FFD, 0x477F, 0x0006, 0x00DC, 0x0018, 0xAFFF,
    0x0048, 0x445D, 0x008A, 0x2BBF, 0x0006, 0x009C, 0x00CA, 0x44DF, 0x0028, 0x222D, 0x2FFD, 0x133F, 0x00F6,
    0xAFFD, 0x1FFB, 0x003C, 0x0008, 0x23BD, 0x007A, 0x11DF, 0x00F6, 0x45DD, 0x2FFB, 0x4EEF, 0x00DA, 0x177D,
    0xCFFD, 0x377F, 0x00F6, 0x3FFD, 0x8FFB, 0x111D, 0x0008, 0x009C, 0x005A, 0x1BBF, 0x00F6, 0x00CD, 0x00BA,
    0x8DDF, 0x4FFB, 0x006C, 0x9BFD, 0x455F, 0x00F6, 0x67FD, 0x1FFB, 0x002C, 0x0008, 0x00AC, 0x007A, 0x009F,
    0x00F6, 0x00AD, 0x2FFB, 0x7FFF, 0x00DA, 0x004C, 0x5FFD, 0x477F, 0x00F6, 0x00EC, 0x8FFB, 0x001C, 0x0008,
    0x008C, 0x005A, 0x888F, 0x00F6, 0x00CC, 0x00BA, 0x2EEF, 0x4FFB, 0x115D, 0x8AED, 0x113F, 0x00F6, 0xAFFD,
    0x1FFB, 0x003C, 0x0008, 0x23BD, 0x007A, 0x1DDF, 0x00F6, 0x45DD, 0x2FFB, 0xBFFF, 0x00DA, 0x177D, 0xCFFD,
    0x447F, 0x00F6, 0x3FFD, 0x8FFB, 0x111D, 0x0008, 0x009C, 0x005A, 0x277F, 0x00F6, 0x00CD, 0x00BA, 0x22EF,
    0x4FFB, 0x006C, 0x9BFD, 0x444F, 0x00F6, 0x67FD, 0x1FFB, 0x002C, 0x0008, 0x00AC, 0x007A, 0x11BF, 0x00F6,
    0x00AD, 0x2FFB, 0xFFFF, 0x00DA, 0x004C, 0x5FFD, 0x233F, 0x00F6, 0x00EC, 0x8FFB, 0x001C, 0x0008, 0x008C,
    0x005A, 0x006F, 0x00F6, 0x00CC, 0x00BA, 0x8BBF, 0x4FFB, 0x115D, 0x8AED, 0x222F};

static const uint16_t dec_CxtVLC_table0_fast_16[1024] = {
    0x0026, 0x00AA, 0x0046, 0x006C, 0x0086, 0x8AED, 0x0018, 0x8DDF, 0x0026, 0x01BD, 0x0046, 0x5FFF, 0x0086,
    0x027D, 0x005A, 0x155F, 0x0026, 0x003A, 0x0046, 0x444D, 0x0086, 0x4CCD, 0x0018, 0xCCCF, 0x0026, 0x2EFD,
    0x0046, 0x99FF, 0x0086, 0x009C, 0x00CA, 0x133F, 0x0026, 0x00AA, 0x0046, 0x445D, 0x0086, 0x8CCD, 0x0018,
    0x11DF, 0x0026, 0x4FFD, 0x0046, 0xCFFF, 0x0086, 0x009D, 0x005A, 0x007E, 0x0026, 0x003A, 0x0046, 0x1FFF,
    0x0086, 0x88AD, 0x0018, 0x00BE, 0x0026, 0x8FFD, 0x0046, 0x4EEF, 0x0086, 0x888D, 0x00CA, 0x111F, 0x0026,
    0x00AA, 0x0046, 0x006C, 0x0086, 0x8AED, 0x0018, 0x45DF, 0x0026, 0x01BD, 0x0046, 0x22EF, 0x0086, 0x027D,
    0x005A, 0x227F, 0x0026, 0x003A, 0x0046, 0x444D, 0x0086, 0x4CCD, 0x0018, 0x11BF, 0x0026, 0x2EFD, 0x0046,
    0x00FE, 0x0086, 0x009C, 0x00CA, 0x223F, 0x0026, 0x00AA, 0x0046, 0x445D, 0x0086, 0x8CCD, 0x0018, 0x00DE,
    0x0026, 0x4FFD, 0x0046, 0xABFF, 0x0086, 0x009D, 0x005A, 0x006F, 0x0026, 0x003A, 0x0046, 0x6EFF, 0x0086,
    0x88AD, 0x0018, 0x2AAF, 0x0026, 0x8FFD, 0x0046, 0x00EE, 0x0086, 0x888D, 0x00CA, 0x222F, 0x0004, 0x00CA,
    0x0088, 0x027D, 0x0004, 0x4CCD, 0x0028, 0x00FE, 0x0004, 0x2AFD, 0x0048, 0x005C, 0x0004, 0x009D, 0x0018,
    0x00DE, 0x0004, 0x01BD, 0x0088, 0x006C, 0x0004, 0x88AD, 0x0028, 0x11DF, 0x0004, 0x8AED, 0x0048, 0x003C,
    0x0004, 0x888D, 0x0018, 0x111F, 0x0004, 0x00CA, 0x0088, 0x006D, 0x0004, 0x88CD, 0x0028, 0x88FF, 0x0004,
    0x8BFD, 0x0048, 0x444D, 0x0004, 0x009C, 0x0018, 0x00BE, 0x0004, 0x4EFD, 0x0088, 0x445D, 0x0004, 0x00AC,
    0x0028, 0x00EE, 0x0004, 0x45DD, 0x0048, 0x222D, 0x0004, 0x003D, 0x0018, 0x007E, 0x0004, 0x00CA, 0x0088,
    0x027D, 0x0004, 0x4CCD, 0x0028, 0x1FFF, 0x0004, 0x2AFD, 0x0048, 0x005C, 0x0004, 0x009D, 0x0018, 0x11BF,
    0x0004, 0x01BD, 0x0088, 0x006C, 0x0004, 0x88AD, 0x0028, 0x22EF, 0x0004, 0x8AED, 0x0048, 0x003C, 0x0004,
    0x888D, 0x0018, 0x227F, 0x0004, 0x00CA, 0x0088, 0x006D, 0x0004, 0x88CD, 0x0028, 0x4EEF, 0x0004, 0x8BFD,
    0x0048, 0x444D, 0x0004, 0x009C, 0x0018, 0x2AAF, 0x0004, 0x4EFD, 0x0088, 0x445D, 0x0004, 0x00AC, 0x0028,
    0x8DDF, 0x0004, 0x45DD, 0x0048, 0x222D, 0x0004, 0x003D, 0x0018, 0x155F, 0x0004, 0x005A, 0x0088, 0x006C,
    0x0004, 0x88DD, 0x0028, 0x23FF, 0x0004, 0x11FD, 0x0048, 0x444D, 0x0004, 0x00AD, 0x0018, 0x00BE, 0x0004,
    0x137D, 0x0088, 0x155D, 0x0004, 0x00CC, 0x0028, 0x00DE, 0x0004, 0x02ED, 0x0048, 0x111D, 0x0004, 0x009D,
    0x0018, 0x007E, 0x0004, 0x005A, 0x0088, 0x455D, 0x0004, 0x44CD, 0x0028, 0x00EE, 0x0004, 0x1FFD, 0x0048,
    0x003C, 0x0004, 0x00AC, 0x0018, 0x555F, 0x0004, 0x47FD, 0x0088, 0x113D, 0x0004, 0x02BD, 0x0028, 0x477F,
    0x0004, 0x4CDD, 0x0048, 0x8FFF, 0x0004, 0x009C, 0x0018, 0x222F, 0x0004, 0x005A, 0x0088, 0x006C, 0x0004,
    0x88DD, 0x0028, 0x00FE, 0x0004, 0x11FD, 0x0048, 0x444D, 0x0004, 0x00AD, 0x0018, 0x888F, 0x0004, 0x137D,
    0x0088, 0x155D, 0x0004, 0x00CC, 0x0028, 0x8CCF, 0x0004, 0x02ED, 0x0048, 0x111D, 0x0004, 0x009D, 0x0018,
    0x006F, 0x0004, 0x005A, 0x0088, 0x455D, 0x0004, 0x44CD, 0x0028, 0x1DDF, 0x0004, 0x1FFD, 0x0048, 0x003C,
    0x0004, 0x00AC, 0x0018, 0x227F, 0x0004, 0x47FD, 0x0088, 0x113D, 0x0004, 0x02BD, 0x0028, 0x22BF, 0x0004,
    0x4CDD, 0x0048, 0x22EF, 0x0004, 0x009C, 0x0018, 0x233F, 0x0006, 0x4DDD, 0x4FFB, 0xCFFF, 0x0018, 0x113D,
    0x005A, 0x888F, 0x0006, 0x23BD, 0x008A, 0x00EE, 0x002A, 0x155D, 0xAAFD, 0x277F, 0x0006, 0x44CD, 0x8FFB,
    0x44EF, 0x0018, 0x467D, 0x004A, 0x2AAF, 0x0006, 0x00AC, 0x555B, 0x99DF, 0x1FFB, 0x003C, 0x5FFD, 0x266F,
    0x0006, 0x1DDD, 0x4FFB, 0x6EFF, 0x0018, 0x177D, 0x005A, 0x1BBF, 0x0006, 0x88AD, 0x008A, 0x5DDF, 0x002A,
    0x444D, 0x2FFD, 0x667F, 0x0006, 0x00CC, 0x8FFB, 0x2EEF, 0x0018, 0x455D, 0x004A, 0x119F, 0x0006, 0x009C,
    0x555B, 0x8CCF, 0x1FFB, 0x111D, 0x8CED, 0x006E, 0x0006, 0x4DDD, 0x4FFB, 0x3FFF, 0x0018, 0x113D, 0x005A,
    0x11BF, 0x0006, 0x23BD, 0x008A, 0x8DDF, 0x002A, 0x155D, 0xAAFD, 0x222F, 0x0006, 0x44CD, 0x8FFB, 0x00FE,
    0x0018, 0x467D, 0x004A, 0x899F, 0x0006, 0x00AC, 0x555B, 0x00DE, 0x1FFB, 0x003C, 0x5FFD, 0x446F, 0x0006,
    0x1DDD, 0x4FFB, 0x9BFF, 0x0018, 0x177D, 0x005A, 0x00BE, 0x0006, 0x88AD, 0x008A, 0xCDDF, 0x002A, 0x444D,
    0x2FFD, 0x007E, 0x0006, 0x00CC, 0x8FFB, 0x4EEF, 0x0018, 0x455D, 0x004A, 0x377F, 0x0006, 0x009C, 0x555B,
    0x8BBF, 0x1FFB, 0x111D, 0x8CED, 0x233F, 0x0004, 0x00AA, 0x0088, 0x047D, 0x0004, 0x01DD, 0x0028, 0x11DF,
    0x0004, 0x27FD, 0x0048, 0x005C, 0x0004, 0x8AAD, 0x0018, 0x2BBF, 0x0004, 0x009C, 0x0088, 0x006C, 0x0004,
    0x00CC, 0x0028, 0x00EE, 0x0004, 0x8CED, 0x0048, 0x222D, 0x0004, 0x888D, 0x0018, 0x007E, 0x0004, 0x00AA,
    0x0088, 0x006D, 0x0004, 0x88CD, 0x0028, 0x00FE, 0x0004, 0x19FD, 0x0048, 0x003C, 0x0004, 0x2AAD, 0x0018,
    0xAAAF, 0x0004, 0x8BFD, 0x0088, 0x005D, 0x0004, 0x00BD, 0x0028, 0x4CCF, 0x0004, 0x44ED, 0x0048, 0x4FFF,
    0x0004, 0x223D, 0x0018, 0x111F, 0x0004, 0x00AA, 0x0088, 0x047D, 0x0004, 0x01DD, 0x0028, 0x99FF, 0x0004,
    0x27FD, 0x0048, 0x005C, 0x0004, 0x8AAD, 0x0018, 0x00BE, 0x0004, 0x009C, 0x0088, 0x006C, 0x0004, 0x00CC,
    0x0028, 0x00DE, 0x0004, 0x8CED, 0x0048, 0x222D, 0x0004, 0x888D, 0x0018, 0x444F, 0x0004, 0x00AA, 0x0088,
    0x006D, 0x0004, 0x88CD, 0x0028, 0x2EEF, 0x0004, 0x19FD, 0x0048, 0x003C, 0x0004, 0x2AAD, 0x0018, 0x447F,
    0x0004, 0x8BFD, 0x0088, 0x005D, 0x0004, 0x00BD, 0x0028, 0x009F, 0x0004, 0x44ED, 0x0048, 0x67FF, 0x0004,
    0x223D, 0x0018, 0x133F, 0x0006, 0x00CC, 0x008A, 0x9DFF, 0x2FFB, 0x467D, 0x1FFD, 0x99BF, 0x0006, 0x2AAD,
    0x002A, 0x66EF, 0x4FFB, 0x005C, 0x2EED, 0x377F, 0x0006, 0x89BD, 0x004A, 0x00FE, 0x8FFB, 0x006C, 0x67FD,
    0x889F, 0x0006, 0x888D, 0x001A, 0x5DDF, 0x00AA, 0x222D, 0x89DD, 0x444F, 0x0006, 0x2BBD, 0x008A, 0xCFFF,
    0x2FFB, 0x226D, 0x009C, 0x00BE, 0x0006, 0xAAAD, 0x002A, 0x1DDF, 0x4FFB, 0x003C, 0x4DDD, 0x466F, 0x0006,
    0x8AAD, 0x004A, 0xAEEF, 0x8FFB, 0x445D, 0x8EED, 0x177F, 0x0006, 0x233D, 0x001A, 0x4CCF, 0x00AA, 0xAFFF,
    0x88CD, 0x133F, 0x0006, 0x00CC, 0x008A, 0x77FF, 0x2FFB, 0x467D, 0x1FFD, 0x3BBF, 0x0006, 0x2AAD, 0x002A,
    0x00EE, 0x4FFB, 0x005C, 0x2EED, 0x007E, 0x0006, 0x89BD, 0x004A, 0x4EEF, 0x8FFB, 0x006C, 0x67FD, 0x667F,
    0x0006, 0x888D, 0x001A, 0x00DE, 0x00AA, 0x222D, 0x89DD, 0x333F, 0x0006, 0x2BBD, 0x008A, 0x57FF, 0x2FFB,
    0x226D, 0x009C, 0x199F, 0x0006, 0xAAAD, 0x002A, 0x99DF, 0x4FFB, 0x003C, 0x4DDD, 0x155F, 0x0006, 0x8AAD,
    0x004A, 0xCEEF, 0x8FFB, 0x445D, 0x8EED, 0x277F, 0x0006, 0x233D, 0x001A, 0x1BBF, 0x00AA, 0x3FFF, 0x88CD,
    0x111F, 0x0006, 0x45DD, 0x2FFB, 0x111D, 0x0018, 0x467D, 0x8FFD, 0xCCCF, 0x0006, 0x19BD, 0x004A, 0x22EF,
    0x002A, 0x222D, 0x3FFD, 0x888F, 0x0006, 0x00CC, 0x008A, 0x00FE, 0x0018, 0x115D, 0xCFFD, 0x8AAF, 0x0006,
    0x00AC, 0x003A, 0x8CDF, 0x1FFB, 0x133D, 0x66FD, 0x466F, 0x0006, 0x8CCD, 0x2FFB, 0x5FFF, 0x0018, 0x006C,
    0x4FFD, 0xABBF, 0x0006, 0x22AD, 0x004A, 0x00EE, 0x002A, 0x233D, 0xAEFD, 0x377F, 0x0006, 0x2BBD, 0x008A,
    0x55DF, 0x0018, 0x005C, 0x177D, 0x119F, 0x0006, 0x009C, 0x003A, 0x4CCF, 0x1FFB, 0x333D, 0x8EED, 0x444F,
    0x0006, 0x45DD, 0x2FFB, 0x111D, 0x0018, 0x467D, 0x8FFD, 0x99BF, 0x0006, 0x19BD, 0x004A, 0x2EEF, 0x002A,
    0x222D, 0x3FFD, 0x667F, 0x0006, 0x00CC, 0x008A, 0x4EEF, 0x0018, 0x115D, 0xCFFD, 0x899F, 0x0006, 0x00AC,
    0x003A, 0x00DE, 0x1FFB, 0x133D, 0x66FD, 0x226F, 0x0006, 0x8CCD, 0x2FFB, 0x9BFF, 0x0018, 0x006C, 0x4FFD,
    0x00BE, 0x0006, 0x22AD, 0x004A, 0x1DDF, 0x002A, 0x233D, 0xAEFD, 0x007E, 0x0006, 0x2BBD, 0x008A, 0xCEEF,
    0x0018, 0x005C, 0x177D, 0x277F, 0x0006, 0x009C, 0x003A, 0x8BBF, 0x1FFB, 0x333D, 0x8EED, 0x455F, 0x1FF9,
    0x1DDD, 0xAFFB, 0x00DE, 0x8FF9, 0x001C, 0xFFFB, 0x477F, 0x4FF9, 0x177D, 0x3FFB, 0x3BBF, 0x2FF9, 0xAEEF,
    0x8EED, 0x444F, 0x1FF9, 0x22AD, 0x000A, 0x8BBF, 0x8FF9, 0x00FE, 0xCFFD, 0x007E, 0x4FF9, 0x115D, 0x5FFB,
    0x577F, 0x2FF9, 0x8DDF, 0x2EED, 0x333F, 0x1FF9, 0x2BBD, 0xAFFB, 0x88CF, 0x8FF9, 0xBFFF, 0xFFFB, 0x377F,
    0x4FF9, 0x006D, 0x3FFB, 0x00BE, 0x2FF9, 0x66EF, 0x9FFD, 0x133F, 0x1FF9, 0x009D, 0x000A, 0xABBF, 0x8FF9,
    0xDFFF, 0x6FFD, 0x006E, 0x4FF9, 0x002C, 0x5FFB, 0x888F, 0x2FF9, 0xCDDF, 0x4DDD, 0x222F, 0x1FF9, 0x1DDD,
    0xAFFB, 0x4CCF, 0x8FF9, 0x001C, 0xFFFB, 0x277F, 0x4FF9, 0x177D, 0x3FFB, 0x99BF, 0x2FF9, 0xCEEF, 0x8EED,
    0x004E, 0x1FF9, 0x22AD, 0x000A, 0x00AE, 0x8FF9, 0x7FFF, 0xCFFD, 0x005E, 0x4FF9, 0x115D, 0x5FFB, 0x009E,
    0x2FF9, 0x5DDF, 0x2EED, 0x003E, 0x1FF9, 0x2BBD, 0xAFFB, 0x00CE, 0x8FF9, 0xEFFF, 0xFFFB, 0x667F, 0x4FF9,
    0x006D, 0x3FFB, 0x8AAF, 0x2FF9, 0x00EE, 0x9FFD, 0x233F, 0x1FF9, 0x009D, 0x000A, 0x1BBF, 0x8FF9, 0x4EEF,
    0x6FFD, 0x455F, 0x4FF9, 0x002C, 0x5FFB, 0x008E, 0x2FF9, 0x99DF, 0x4DDD, 0x111F};

/*
static const int32_t dec_CxtVLC_table0_fast[1024] = {
38,    170,   70,    108,   134,   35565, 24,    36319, 38,    445,   70,    24575, 134,
637,   90,    5471,  38,    58,    70,    17485, 134,   19661, 24,    52431, 38,    12029,
70,    39423, 134,   156,   202,   4927,  38,    170,   70,    17501, 134,   36045, 24,
4575,  38,    20477, 70,    53247, 134,   157,   90,    126,   38,    58,    70,    8191,
134,   34989, 24,    190,   38,    36861, 70,    20207, 134,   34957, 202,   4383,  38,
170,   70,    108,   134,   35565, 24,    17887, 38,    445,   70,    8943,  134,   637,
90,    8831,  38,    58,    70,    17485, 134,   19661, 24,    4543,  38,    12029, 70,
254,   134,   156,   202,   8767,  38,    170,   70,    17501, 134,   36045, 24,    222,
38,    20477, 70,    44031, 134,   157,   90,    111,   38,    58,    70,    28415, 134,
34989, 24,    10927, 38,    36861, 70,    238,   134,   34957, 202,   8751,  4,     202,
136,   637,   4,     19661, 40,    254,   4,     11005, 72,    92,    4,     157,   24,
222,   4,     445,   136,   108,   4,     34989, 40,    4575,  4,     35565, 72,    60,
4,     34957, 24,    4383,  4,     202,   136,   109,   4,     35021, 40,    35071, 4,
35837, 72,    17485, 4,     156,   24,    190,   4,     20221, 136,   17501, 4,     172,
40,    238,   4,     17885, 72,    8749,  4,     61,    24,    126,   4,     202,   136,
637,   4,     19661, 40,    8191,  4,     11005, 72,    92,    4,     157,   24,    4543,
4,     445,   136,   108,   4,     34989, 40,    8943,  4,     35565, 72,    60,    4,
34957, 24,    8831,  4,     202,   136,   109,   4,     35021, 40,    20207, 4,     35837,
72,    17485, 4,     156,   24,    10927, 4,     20221, 136,   17501, 4,     172,   40,
36319, 4,     17885, 72,    8749,  4,     61,    24,    5471,  4,     90,    136,   108,
4,     35037, 40,    9215,  4,     4605,  72,    17485, 4,     173,   24,    190,   4,
4989,  136,   5469,  4,     204,   40,    222,   4,     749,   72,    4381,  4,     157,
24,    126,   4,     90,    136,   17757, 4,     17613, 40,    238,   4,     8189,  72,
60,    4,     172,   24,    21855, 4,     18429, 136,   4413,  4,     701,   40,    18303,
4,     19677, 72,    36863, 4,     156,   24,    8751,  4,     90,    136,   108,   4,
35037, 40,    254,   4,     4605,  72,    17485, 4,     173,   24,    34959, 4,     4989,
136,   5469,  4,     204,   40,    36047, 4,     749,   72,    4381,  4,     157,   24,
111,   4,     90,    136,   17757, 4,     17613, 40,    7647,  4,     8189,  72,    60,
4,     172,   24,    8831,  4,     18429, 136,   4413,  4,     701,   40,    8895,  4,
19677, 72,    8943,  4,     156,   24,    9023,  6,     19933, 20475, 53247, 24,    4413,
90,    34959, 6,     9149,  138,   238,   42,    5469,  43773, 10111, 6,     17613, 36859,
17647, 24,    18045, 74,    10927, 6,     172,   21851, 39391, 8187,  60,    24573, 9839,
6,     7645,  20475, 28415, 24,    6013,  90,    7103,  6,     34989, 138,   24031, 42,
17485, 12285, 26239, 6,     204,   36859, 12015, 24,    17757, 74,    4511,  6,     156,
21851, 36047, 8187,  4381,  36077, 110,   6,     19933, 20475, 16383, 24,    4413,  90,
4543,  6,     9149,  138,   36319, 42,    5469,  43773, 8751,  6,     17613, 36859, 254,
24,    18045, 74,    35231, 6,     172,   21851, 222,   8187,  60,    24573, 17519, 6,
7645,  20475, 39935, 24,    6013,  90,    190,   6,     34989, 138,   52703, 42,    17485,
12285, 126,   6,     204,   36859, 20207, 24,    17757, 74,    14207, 6,     156,   21851,
35775, 8187,  4381,  36077, 9023,  4,     170,   136,   1149,  4,     477,   40,    4575,
4,     10237, 72,    92,    4,     35501, 24,    11199, 4,     156,   136,   108,   4,
204,   40,    238,   4,     36077, 72,    8749,  4,     34957, 24,    126,   4,     170,
136,   109,   4,     35021, 40,    254,   4,     6653,  72,    60,    4,     10925, 24,
43695, 4,     35837, 136,   93,    4,     189,   40,    19663, 4,     17645, 72,    20479,
4,     8765,  24,    4383,  4,     170,   136,   1149,  4,     477,   40,    39423, 4,
10237, 72,    92,    4,     35501, 24,    190,   4,     156,   136,   108,   4,     204,
40,    222,   4,     36077, 72,    8749,  4,     34957, 24,    17487, 4,     170,   136,
109,   4,     35021, 40,    12015, 4,     6653,  72,    60,    4,     10925, 24,    17535,
4,     35837, 136,   93,    4,     189,   40,    159,   4,     17645, 72,    26623, 4,
8765,  24,    4927,  6,     204,   138,   40447, 12283, 18045, 8189,  39359, 6,     10925,
42,    26351, 20475, 92,    12013, 14207, 6,     35261, 74,    254,   36859, 108,   26621,
34975, 6,     34957, 26,    24031, 170,   8749,  35293, 17487, 6,     11197, 138,   53247,
12283, 8813,  156,   190,   6,     43693, 42,    7647,  20475, 60,    19933, 18031, 6,
35501, 74,    44783, 36859, 17501, 36589, 6015,  6,     9021,  26,    19663, 170,   45055,
35021, 4927,  6,     204,   138,   30719, 12283, 18045, 8189,  15295, 6,     10925, 42,
238,   20475, 92,    12013, 126,   6,     35261, 74,    20207, 36859, 108,   26621, 26239,
6,     34957, 26,    222,   170,   8749,  35293, 13119, 6,     11197, 138,   22527, 12283,
8813,  156,   6559,  6,     43693, 42,    39391, 20475, 60,    19933, 5471,  6,     35501,
74,    52975, 36859, 17501, 36589, 10111, 6,     9021,  26,    7103,  170,   16383, 35021,
4383,  6,     17885, 12283, 4381,  24,    18045, 36861, 52431, 6,     6589,  74,    8943,
42,    8749,  16381, 34959, 6,     204,   138,   254,   24,    4445,  53245, 35503, 6,
172,   58,    36063, 8187,  4925,  26365, 18031, 6,     36045, 12283, 24575, 24,    108,
20477, 43967, 6,     8877,  74,    238,   42,    9021,  44797, 14207, 6,     11197, 138,
21983, 24,    92,    6013,  4511,  6,     156,   58,    19663, 8187,  13117, 36589, 17487,
6,     17885, 12283, 4381,  24,    18045, 36861, 39359, 6,     6589,  74,    12015, 42,
8749,  16381, 26239, 6,     204,   138,   20207, 24,    4445,  53245, 35231, 6,     172,
58,    222,   8187,  4925,  26365, 8815,  6,     36045, 12283, 39935, 24,    108,   20477,
190,   6,     8877,  74,    7647,  42,    9021,  44797, 126,   6,     11197, 138,   52975,
24,    92,    6013,  10111, 6,     156,   58,    35775, 8187,  13117, 36589, 17759, 8185,
7645,  45051, 222,   36857, 28,    65531, 18303, 20473, 6013,  16379, 15295, 12281, 44783,
36589, 17487, 8185,  8877,  10,    35775, 36857, 254,   53245, 126,   20473, 4445,  24571,
22399, 12281, 36319, 12013, 13119, 8185,  11197, 45051, 35023, 36857, 49151, 65531, 14207,
20473, 109,   16379, 190,   12281, 26351, 40957, 4927,  8185,  157,   10,    43967, 36857,
57343, 28669, 110,   20473, 44,    24571, 34959, 12281, 52703, 19933, 8751,  8185,  7645,
45051, 19663, 36857, 28,    65531, 10111, 20473, 6013,  16379, 39359, 12281, 52975, 36589,
78,    8185,  8877,  10,    174,   36857, 32767, 53245, 94,    20473, 4445,  24571, 158,
12281, 24031, 12013, 62,    8185,  11197, 45051, 206,   36857, 61439, 65531, 26239, 20473,
109,   16379, 35503, 12281, 238,   40957, 9023,  8185,  157,   10,    7103,  36857, 20207,
28669, 17759, 20473, 44,    24571, 142,   12281, 39391, 19933, 4383};

const int32_t dec_CxtVLC_table1_fast[1024] = {
22,    106,   70,    221,   134,   34955, 38,    17485, 22,    170,   70,    34989, 134,
58,    38,    222,   22,    202,   70,    157,   134,   90,    38,    8749,  22,    154,
70,    125,   134,   509,   38,    126,   22,    106,   70,    35021, 134,   34955, 38,
4381,  22,    170,   70,    93,    134,   58,    38,    238,   22,    202,   70,    189,
134,   90,    38,    4607,  22,    154,   70,    61,    134,   1261,  38,    10927, 22,
106,   70,    221,   134,   34955, 38,    17485, 22,    170,   70,    34989, 134,   58,
38,    17647, 22,    202,   70,    157,   134,   90,    38,    8749,  22,    154,   70,
125,   134,   509,   38,    190,   22,    106,   70,    35021, 134,   34955, 38,    4381,
22,    170,   70,    93,    134,   58,    38,    19663, 22,    202,   70,    189,   134,
90,    38,    254,   22,    154,   70,    61,    134,   1261,  38,    111,   2,     136,
2,     92,    2,     24,    2,     222,   2,     40,    2,     156,   2,     74,    2,
126,   2,     136,   2,     204,   2,     24,    2,     34959, 2,     40,    2,     254,
2,     58,    2,     8751,  2,     136,   2,     1277,  2,     24,    2,     190,   2,
40,    2,     191,   2,     74,    2,     110,   2,     136,   2,     172,   2,     24,
2,     17487, 2,     40,    2,     238,   2,     58,    2,     4415,  2,     136,   2,
92,    2,     24,    2,     207,   2,     40,    2,     156,   2,     74,    2,     111,
2,     136,   2,     204,   2,     24,    2,     159,   2,     40,    2,     239,   2,
58,    2,     9023,  2,     136,   2,     1277,  2,     24,    2,     175,   2,     40,
2,     17663, 2,     74,    2,     95,    2,     136,   2,     172,   2,     24,    2,
127,   2,     40,    2,     223,   2,     58,    2,     4383,  2,     40,    2,     92,
2,     138,   2,     191,   2,     24,    2,     254,   2,     204,   2,     126,   2,
40,    2,     36863, 2,     74,    2,     127,   2,     24,    2,     223,   2,     172,
2,     4927,  2,     40,    2,     8749,  2,     138,   2,     190,   2,     24,    2,
17647, 2,     10925, 2,     110,   2,     40,    2,     5631,  2,     74,    2,     158,
2,     24,    2,     207,   2,     60,    2,     8767,  2,     40,    2,     92,    2,
138,   2,     11199, 2,     24,    2,     1263,  2,     204,   2,     111,   2,     40,
2,     10239, 2,     74,    2,     159,   2,     24,    2,     222,   2,     172,   2,
17487, 2,     40,    2,     8749,  2,     138,   2,     35503, 2,     24,    2,     238,
2,     10925, 2,     95,    2,     40,    2,     17663, 2,     74,    2,     34959, 2,
24,    2,     43695, 2,     60,    2,     4383,  4,     36861, 40,    92,    4,     188,
138,   26367, 4,     205,   24,    4381,  4,     156,   58,    35503, 4,     252,   40,
4925,  4,     172,   74,    15295, 4,     11197, 24,    24575, 4,     108,   5501,  17759,
4,     12285, 40,    8749,  4,     8877,  138,   17647, 4,     204,   24,    20479, 4,
124,   58,    17535, 4,     1245,  40,    9021,  4,     157,   74,    222,   4,     35005,
24,    45055, 4,     4445,  8189,  17487, 4,     36861, 40,    92,    4,     188,   138,
36079, 4,     205,   24,    4381,  4,     156,   58,    34959, 4,     252,   40,    4925,
4,     172,   74,    17631, 4,     11197, 24,    35583, 4,     108,   5501,  111,   4,
12285, 40,    8749,  4,     8877,  138,   238,   4,     204,   24,    12015, 4,     124,
58,    10111, 4,     1245,  40,    9021,  4,     157,   74,    7103,  4,     35005, 24,
14335, 4,     4445,  8189,  13119, 2,     136,   2,     749,   2,     202,   2,     19663,
2,     72,    2,     9215,  2,     26,    2,     34959, 2,     136,   2,     108,   2,
42,    2,     175,   2,     72,    2,     8943,  2,     172,   2,     95,    2,     136,
2,     17485, 2,     202,   2,     52431, 2,     72,    2,     254,   2,     26,    2,
111,   2,     136,   2,     92,    2,     42,    2,     159,   2,     72,    2,     223,
2,     1021,  2,     8751,  2,     136,   2,     749,   2,     202,   2,     36047, 2,
72,    2,     4607,  2,     26,    2,     126,   2,     136,   2,     108,   2,     42,
2,     127,   2,     72,    2,     238,   2,     172,   2,     62,    2,     136,   2,
17485, 2,     202,   2,     190,   2,     72,    2,     191,   2,     26,    2,     63,
2,     136,   2,     92,    2,     42,    2,     158,   2,     72,    2,     222,   2,
1021,  2,     4383,  4,     35565, 72,    34957, 4,     220,   202,   16383, 4,     53245,
42,    61,    4,     188,   90,    36319, 4,     36861, 72,    108,   4,     637,   138,
39423, 4,     236,   250,   60,    4,     172,   26,    159,   4,     12285, 72,    124,
4,     17613, 202,   26623, 4,     8189,  42,    17485, 4,     173,   90,    36047, 4,
20477, 72,    17501, 4,     445,   138,   20207, 4,     17885, 250,   4381,  4,     156,
26,    8751,  4,     35565, 72,    34957, 4,     220,   202,   45055, 4,     53245, 42,
61,    4,     188,   90,    4543,  4,     36861, 72,    108,   4,     637,   138,   8943,
4,     236,   250,   60,    4,     172,   26,    8831,  4,     12285, 72,    124,   4,
17613, 202,   24063, 4,     8189,  42,    17485, 4,     173,   90,    111,   4,     20477,
72,    17501, 4,     445,   138,   4575,  4,     17885, 250,   4381,  4,     156,   26,
5471,  6,     252,   24,    4381,  72,    34957, 170,   19935, 6,     10925, 90,    26623,
40,    8765,  188,   43695, 6,     236,   24,    24575, 72,    108,   138,   52431, 6,
157,   202,   17647, 40,    60,    36861, 4991,  6,     36589, 24,    8191,  72,    124,
170,   19663, 6,     8829,  90,    7647,  40,    17485, 20477, 5471,  6,     220,   24,
12015, 72,    17501, 138,   8895,  6,     156,   202,   36063, 40,    8749,  12285, 8815,
6,     252,   24,    4381,  72,    34957, 170,   7103,  6,     10925, 90,    13311, 40,
8765,  188,   35503, 6,     236,   24,    39935, 72,    108,   138,   35519, 6,     157,
202,   20207, 40,    60,    36861, 18031, 6,     36589, 24,    53247, 72,    124,   170,
36047, 6,     8829,  90,    44783, 40,    17485, 20477, 18303, 6,     220,   24,    45055,
72,    17501, 138,   11199, 6,     156,   202,   17631, 40,    8749,  12285, 4927,  246,
45053, 8187,  60,    8,     9149,  122,   4575,  246,   17885, 12283, 20207, 218,   6013,
53245, 14207, 246,   16381, 36859, 4381,  8,     156,   90,    7103,  246,   205,   186,
36319, 20475, 108,   39933, 17759, 246,   26621, 8187,  44,    8,     172,   122,   159,
246,   173,   12283, 32767, 218,   76,    24573, 18303, 246,   236,   36859, 28,    8,
140,   90,    34959, 246,   204,   186,   12015, 20475, 4445,  35565, 4415,  246,   45053,
8187,  60,    8,     9149,  122,   7647,  246,   17885, 12283, 49151, 218,   6013,  53245,
17535, 246,   16381, 36859, 4381,  8,     156,   90,    10111, 246,   205,   186,   8943,
20475, 108,   39933, 17487, 246,   26621, 8187,  44,    8,     172,   122,   4543,  246,
173,   12283, 65535, 218,   76,    24573, 9023,  246,   236,   36859, 28,    8,     140,
90,    111,   246,   204,   186,   35775, 20475, 4445,  35565, 8751};
const int32_t dec_CxtVLC_table0[5][1024] = {
{3, 5, 3, 6, 3, 6, 4, 7, 3, 6, 3, 7, 3, 6, 5, 7, 3, 5, 3, 6, 3, 6, 4, 7, 3, 6, 3, 7, 3, 6, 5,
 7, 3, 5, 3, 6, 3, 6, 4, 7, 3, 6, 3, 7, 3, 6, 5, 7, 3, 5, 3, 7, 3, 6, 4, 7, 3, 6, 3, 7, 3, 6,
 5, 7, 3, 5, 3, 6, 3, 6, 4, 7, 3, 6, 3, 7, 3, 6, 5, 7, 3, 5, 3, 6, 3, 6, 4, 7, 3, 6, 3, 7, 3,
 6, 5, 7, 3, 5, 3, 6, 3, 6, 4, 7, 3, 6, 3, 7, 3, 6, 5, 7, 3, 5, 3, 7, 3, 6, 4, 7, 3, 6, 3, 7,
 3, 6, 5, 7, 2, 5, 4, 6, 2, 6, 4, 7, 2, 6, 4, 6, 2, 6, 4, 7, 2, 6, 4, 6, 2, 6, 4, 7, 2, 6, 4,
 6, 2, 6, 4, 7, 2, 5, 4, 6, 2, 6, 4, 7, 2, 6, 4, 6, 2, 6, 4, 7, 2, 6, 4, 6, 2, 6, 4, 7, 2, 6,
 4, 6, 2, 6, 4, 7, 2, 5, 4, 6, 2, 6, 4, 7, 2, 6, 4, 6, 2, 6, 4, 7, 2, 6, 4, 6, 2, 6, 4, 7, 2,
 6, 4, 6, 2, 6, 4, 7, 2, 5, 4, 6, 2, 6, 4, 7, 2, 6, 4, 6, 2, 6, 4, 7, 2, 6, 4, 6, 2, 6, 4, 7,
 2, 6, 4, 6, 2, 6, 4, 7, 2, 5, 4, 6, 2, 6, 4, 7, 2, 6, 4, 6, 2, 6, 4, 7, 2, 6, 4, 6, 2, 6, 4,
 7, 2, 6, 4, 6, 2, 6, 4, 7, 2, 5, 4, 6, 2, 6, 4, 7, 2, 6, 4, 6, 2, 6, 4, 7, 2, 6, 4, 6, 2, 6,
 4, 7, 2, 6, 4, 7, 2, 6, 4, 7, 2, 5, 4, 6, 2, 6, 4, 7, 2, 6, 4, 6, 2, 6, 4, 7, 2, 6, 4, 6, 2,
 6, 4, 7, 2, 6, 4, 6, 2, 6, 4, 7, 2, 5, 4, 6, 2, 6, 4, 7, 2, 6, 4, 6, 2, 6, 4, 7, 2, 6, 4, 6,
 2, 6, 4, 7, 2, 6, 4, 7, 2, 6, 4, 7, 3, 6, 5, 7, 4, 6, 5, 7, 3, 6, 5, 7, 5, 6, 6, 7, 3, 6, 5,
 7, 4, 6, 5, 7, 3, 6, 5, 7, 5, 6, 6, 7, 3, 6, 5, 7, 4, 6, 5, 7, 3, 6, 5, 7, 5, 6, 6, 7, 3, 6,
 5, 7, 4, 6, 5, 7, 3, 6, 5, 7, 5, 6, 6, 7, 3, 6, 5, 7, 4, 6, 5, 7, 3, 6, 5, 7, 5, 6, 6, 7, 3,
 6, 5, 7, 4, 6, 5, 7, 3, 6, 5, 7, 5, 6, 6, 7, 3, 6, 5, 7, 4, 6, 5, 7, 3, 6, 5, 7, 5, 6, 6, 7,
 3, 6, 5, 7, 4, 6, 5, 7, 3, 6, 5, 7, 5, 6, 6, 7, 2, 5, 4, 6, 2, 6, 4, 7, 2, 6, 4, 6, 2, 6, 4,
 7, 2, 6, 4, 6, 2, 6, 4, 7, 2, 6, 4, 6, 2, 6, 4, 7, 2, 5, 4, 6, 2, 6, 4, 7, 2, 6, 4, 6, 2, 6,
 4, 7, 2, 6, 4, 6, 2, 6, 4, 7, 2, 6, 4, 7, 2, 6, 4, 7, 2, 5, 4, 6, 2, 6, 4, 7, 2, 6, 4, 6, 2,
 6, 4, 7, 2, 6, 4, 6, 2, 6, 4, 7, 2, 6, 4, 6, 2, 6, 4, 7, 2, 5, 4, 6, 2, 6, 4, 7, 2, 6, 4, 6,
 2, 6, 4, 7, 2, 6, 4, 6, 2, 6, 4, 7, 2, 6, 4, 7, 2, 6, 4, 7, 3, 6, 5, 7, 5, 6, 6, 7, 3, 6, 5,
 7, 5, 6, 6, 7, 3, 6, 5, 7, 5, 6, 6, 7, 3, 6, 5, 7, 5, 6, 6, 7, 3, 6, 5, 7, 5, 6, 6, 7, 3, 6,
 5, 7, 5, 6, 6, 7, 3, 6, 5, 7, 5, 6, 6, 7, 3, 6, 5, 7, 5, 7, 6, 7, 3, 6, 5, 7, 5, 6, 6, 7, 3,
 6, 5, 7, 5, 6, 6, 7, 3, 6, 5, 7, 5, 6, 6, 7, 3, 6, 5, 7, 5, 6, 6, 7, 3, 6, 5, 7, 5, 6, 6, 7,
 3, 6, 5, 7, 5, 6, 6, 7, 3, 6, 5, 7, 5, 6, 6, 7, 3, 6, 5, 7, 5, 7, 6, 7, 3, 6, 5, 6, 4, 6, 6,
 7, 3, 6, 5, 7, 5, 6, 6, 7, 3, 6, 5, 7, 4, 6, 6, 7, 3, 6, 5, 7, 5, 6, 6, 7, 3, 6, 5, 7, 4, 6,
 6, 7, 3, 6, 5, 7, 5, 6, 6, 7, 3, 6, 5, 7, 4, 6, 6, 7, 3, 6, 5, 7, 5, 6, 6, 7, 3, 6, 5, 6, 4,
 6, 6, 7, 3, 6, 5, 7, 5, 6, 6, 7, 3, 6, 5, 7, 4, 6, 6, 7, 3, 6, 5, 7, 5, 6, 6, 7, 3, 6, 5, 7,
 4, 6, 6, 7, 3, 6, 5, 7, 5, 6, 6, 7, 3, 6, 5, 7, 4, 6, 6, 7, 3, 6, 5, 7, 5, 6, 6, 7, 4, 6, 5,
 7, 4, 6, 5, 7, 4, 6, 5, 7, 4, 7, 6, 7, 4, 6, 5, 7, 4, 7, 6, 7, 4, 6, 5, 7, 4, 7, 6, 7, 4, 6,
 5, 7, 4, 7, 5, 7, 4, 6, 5, 7, 4, 7, 6, 7, 4, 6, 5, 7, 4, 7, 6, 7, 4, 6, 5, 7, 4, 7, 6, 7, 4,
 6, 5, 7, 4, 6, 5, 7, 4, 6, 5, 7, 4, 7, 6, 7, 4, 6, 5, 7, 4, 7, 6, 7, 4, 6, 5, 7, 4, 7, 6, 7,
 4, 6, 5, 7, 4, 7, 5, 7, 4, 6, 5, 7, 4, 7, 6, 7, 4, 6, 5, 7, 4, 7, 6, 7, 4, 6, 5, 7, 4, 7, 6,
 7},
{2,  10, 4,  6,  8,  14, 1,  13, 2,  11, 4,  15, 8,  7,  5,  5,  2,  3,  4,  4,  8,  12, 1,  12,
 2,  15, 4,  15, 8,  9,  12, 3,  2,  10, 4,  5,  8,  12, 1,  13, 2,  15, 4,  15, 8,  9,  5,  7,
 2,  3,  4,  15, 8,  10, 1,  11, 2,  15, 4,  14, 8,  8,  12, 1,  2,  10, 4,  6,  8,  14, 1,  13,
 2,  11, 4,  14, 8,  7,  5,  7,  2,  3,  4,  4,  8,  12, 1,  11, 2,  15, 4,  15, 8,  9,  12, 3,
 2,  10, 4,  5,  8,  12, 1,  13, 2,  15, 4,  15, 8,  9,  5,  6,  2,  3,  4,  15, 8,  10, 1,  10,
 2,  15, 4,  14, 8,  8,  12, 2,  0,  12, 8,  7,  0,  12, 2,  15, 0,  15, 4,  5,  0,  9,  1,  13,
 0,  11, 8,  6,  0,  10, 2,  13, 0,  14, 4,  3,  0,  8,  1,  1,  0,  12, 8,  6,  0,  12, 2,  15,
 0,  15, 4,  4,  0,  9,  1,  11, 0,  15, 8,  5,  0,  10, 2,  14, 0,  13, 4,  2,  0,  3,  1,  7,
 0,  12, 8,  7,  0,  12, 2,  15, 0,  15, 4,  5,  0,  9,  1,  11, 0,  11, 8,  6,  0,  10, 2,  14,
 0,  14, 4,  3,  0,  8,  1,  7,  0,  12, 8,  6,  0,  12, 2,  14, 0,  15, 4,  4,  0,  9,  1,  10,
 0,  15, 8,  5,  0,  10, 2,  13, 0,  13, 4,  2,  0,  3,  1,  5,  0,  5,  8,  6,  0,  13, 2,  15,
 0,  15, 4,  4,  0,  10, 1,  11, 0,  7,  8,  5,  0,  12, 2,  13, 0,  14, 4,  1,  0,  9,  1,  7,
 0,  5,  8,  5,  0,  12, 2,  14, 0,  15, 4,  3,  0,  10, 1,  5,  0,  15, 8,  3,  0,  11, 2,  7,
 0,  13, 4,  15, 0,  9,  1,  2,  0,  5,  8,  6,  0,  13, 2,  15, 0,  15, 4,  4,  0,  10, 1,  8,
 0,  7,  8,  5,  0,  12, 2,  12, 0,  14, 4,  1,  0,  9,  1,  6,  0,  5,  8,  5,  0,  12, 2,  13,
 0,  15, 4,  3,  0,  10, 1,  7,  0,  15, 8,  3,  0,  11, 2,  11, 0,  13, 4,  14, 0,  9,  1,  3,
 0,  13, 15, 15, 1,  3,  5,  8,  0,  11, 8,  14, 2,  5,  15, 7,  0,  12, 15, 14, 1,  7,  4,  10,
 0,  10, 5,  13, 15, 3,  15, 6,  0,  13, 15, 15, 1,  7,  5,  11, 0,  10, 8,  13, 2,  4,  15, 7,
 0,  12, 15, 14, 1,  5,  4,  9,  0,  9,  5,  12, 15, 1,  14, 6,  0,  13, 15, 15, 1,  3,  5,  11,
 0,  11, 8,  13, 2,  5,  15, 2,  0,  12, 15, 15, 1,  7,  4,  9,  0,  10, 5,  13, 15, 3,  15, 6,
 0,  13, 15, 15, 1,  7,  5,  11, 0,  10, 8,  13, 2,  4,  15, 7,  0,  12, 15, 14, 1,  5,  4,  7,
 0,  9,  5,  11, 15, 1,  14, 3,  0,  10, 8,  7,  0,  13, 2,  13, 0,  15, 4,  5,  0,  10, 1,  11,
 0,  9,  8,  6,  0,  12, 2,  14, 0,  14, 4,  2,  0,  8,  1,  7,  0,  10, 8,  6,  0,  12, 2,  15,
 0,  15, 4,  3,  0,  10, 1,  10, 0,  15, 8,  5,  0,  11, 2,  12, 0,  14, 4,  15, 0,  3,  1,  1,
 0,  10, 8,  7,  0,  13, 2,  15, 0,  15, 4,  5,  0,  10, 1,  11, 0,  9,  8,  6,  0,  12, 2,  13,
 0,  14, 4,  2,  0,  8,  1,  4,  0,  10, 8,  6,  0,  12, 2,  14, 0,  15, 4,  3,  0,  10, 1,  7,
 0,  15, 8,  5,  0,  11, 2,  9,  0,  14, 4,  15, 0,  3,  1,  3,  0,  12, 8,  15, 15, 7,  15, 11,
 0,  10, 2,  14, 15, 5,  14, 7,  0,  11, 4,  15, 15, 6,  15, 9,  0,  8,  1,  13, 10, 2,  13, 4,
 0,  11, 8,  15, 15, 6,  9,  11, 0,  10, 2,  13, 15, 3,  13, 6,  0,  10, 4,  14, 15, 5,  14, 7,
 0,  3,  1,  12, 10, 15, 12, 3,  0,  12, 8,  15, 15, 7,  15, 11, 0,  10, 2,  14, 15, 5,  14, 7,
 0,  11, 4,  14, 15, 6,  15, 7,  0,  8,  1,  13, 10, 2,  13, 3,  0,  11, 8,  15, 15, 6,  9,  9,
 0,  10, 2,  13, 15, 3,  13, 5,  0,  10, 4,  14, 15, 5,  14, 7,  0,  3,  1,  11, 10, 15, 12, 1,
 0,  13, 15, 1,  1,  7,  15, 12, 0,  11, 4,  14, 2,  2,  15, 8,  0,  12, 8,  15, 1,  5,  15, 10,
 0,  10, 3,  13, 15, 3,  15, 6,  0,  12, 15, 15, 1,  6,  15, 11, 0,  10, 4,  14, 2,  3,  15, 7,
 0,  11, 8,  13, 1,  5,  7,  9,  0,  9,  3,  12, 15, 3,  14, 4,  0,  13, 15, 1,  1,  7,  15, 11,
 0,  11, 4,  14, 2,  2,  15, 7,  0,  12, 8,  14, 1,  5,  15, 9,  0,  10, 3,  13, 15, 3,  15, 6,
 0,  12, 15, 15, 1,  6,  15, 11, 0,  10, 4,  13, 2,  3,  15, 7,  0,  11, 8,  14, 1,  5,  7,  7,
 0,  9,  3,  11, 15, 3,  14, 5,  15, 13, 15, 13, 15, 1,  15, 7,  15, 7,  15, 11, 15, 14, 14, 4,
 15, 10, 0,  11, 15, 15, 15, 7,  15, 5,  15, 7,  15, 13, 14, 3,  15, 11, 15, 12, 15, 15, 15, 7,
 15, 6,  15, 11, 15, 14, 15, 3,  15, 9,  0,  11, 15, 15, 15, 6,  15, 2,  15, 8,  15, 13, 13, 2,
 15, 13, 15, 12, 15, 1,  15, 7,  15, 7,  15, 11, 15, 14, 14, 4,  15, 10, 0,  10, 15, 15, 15, 5,
 15, 5,  15, 9,  15, 13, 14, 3,  15, 11, 15, 12, 15, 15, 15, 7,  15, 6,  15, 10, 15, 14, 15, 3,
 15, 9,  0,  11, 15, 14, 15, 5,  15, 2,  15, 8,  15, 13, 13, 1},
{0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0,
 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 1,
 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0,
 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0,
 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0,
 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1,
 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0,
 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1,
 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0,
 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1,
 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0,
 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1,
 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 1, 1, 0, 1, 1,
 1, 0, 1, 0, 1, 0, 0, 1, 1, 1, 0, 1, 1, 0, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 0, 0,
 1, 1, 0, 1, 0, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 0,
 1, 1, 0, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0, 1, 1, 0, 1, 1, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 1, 1, 0,
 0, 0, 1, 1, 0, 1, 0, 1, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0,
 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1,
 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0,
 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0,
 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 1, 1, 1, 1, 0, 1, 0,
 1, 1, 0, 1, 1, 0, 1, 0, 0, 1, 0, 1, 1, 0, 1, 0, 1, 0, 1, 1, 1, 0, 1, 0, 1, 1, 1, 0, 0, 0, 1,
 0, 1, 1, 0, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 0,
 1, 0, 0, 1, 0, 1, 0, 0, 1, 0, 1, 1, 0, 1, 1, 0, 1, 0, 0, 0, 1, 1, 1, 0, 1, 0, 1, 1, 1, 0, 1,
 0, 1, 0, 1, 1, 0, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1,
 1, 0, 1, 0, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 0,
 1, 1, 0, 1, 0, 0, 0, 1, 1, 1, 0, 1, 0, 1, 0, 0, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0,
 1, 1, 1, 0, 1, 0, 1, 0, 1, 1, 1, 0, 0, 0, 1, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 0, 1, 1, 1,
 0, 0, 1, 0, 0, 1, 0, 1, 0, 1, 1, 0, 0, 1, 0, 1, 0, 0, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1,
 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1,
 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 0, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0,
 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1,
 1},
{0,  0,  0,  0,  0,  10, 0,  13, 0,  1,  0,  15, 0,  2,  0,  5,  0,  0,  0,  4,  0,  12, 0,  12,
 0,  14, 0,  9,  0,  0,  0,  3,  0,  0,  0,  4,  0,  12, 0,  1,  0,  15, 0,  15, 0,  0,  0,  0,
 0,  0,  0,  15, 0,  8,  0,  0,  0,  15, 0,  14, 0,  8,  0,  1,  0,  0,  0,  0,  0,  10, 0,  5,
 0,  1,  0,  2,  0,  2,  0,  2,  0,  0,  0,  4,  0,  12, 0,  1,  0,  14, 0,  0,  0,  0,  0,  2,
 0,  0,  0,  4,  0,  12, 0,  0,  0,  15, 0,  11, 0,  0,  0,  0,  0,  0,  0,  14, 0,  8,  0,  10,
 0,  15, 0,  0,  0,  8,  0,  2,  0,  0,  0,  2,  0,  12, 0,  0,  0,  10, 0,  0,  0,  0,  0,  0,
 0,  1,  0,  0,  0,  8,  0,  1,  0,  10, 0,  0,  0,  8,  0,  1,  0,  0,  0,  0,  0,  8,  0,  8,
 0,  11, 0,  4,  0,  0,  0,  0,  0,  14, 0,  4,  0,  0,  0,  0,  0,  5,  0,  2,  0,  0,  0,  0,
 0,  0,  0,  2,  0,  12, 0,  15, 0,  10, 0,  0,  0,  0,  0,  1,  0,  1,  0,  0,  0,  8,  0,  2,
 0,  10, 0,  0,  0,  8,  0,  2,  0,  0,  0,  0,  0,  8,  0,  14, 0,  11, 0,  4,  0,  0,  0,  10,
 0,  14, 0,  4,  0,  0,  0,  13, 0,  5,  0,  2,  0,  0,  0,  5,  0,  0,  0,  0,  0,  8,  0,  3,
 0,  1,  0,  4,  0,  0,  0,  0,  0,  3,  0,  5,  0,  0,  0,  0,  0,  2,  0,  1,  0,  0,  0,  0,
 0,  0,  0,  5,  0,  4,  0,  0,  0,  15, 0,  0,  0,  0,  0,  5,  0,  7,  0,  1,  0,  2,  0,  7,
 0,  12, 0,  15, 0,  0,  0,  2,  0,  0,  0,  0,  0,  8,  0,  0,  0,  1,  0,  4,  0,  0,  0,  8,
 0,  3,  0,  5,  0,  0,  0,  12, 0,  2,  0,  1,  0,  0,  0,  0,  0,  0,  0,  5,  0,  4,  0,  13,
 0,  15, 0,  0,  0,  0,  0,  2,  0,  7,  0,  1,  0,  2,  0,  2,  0,  12, 0,  2,  0,  0,  0,  3,
 0,  13, 15, 15, 0,  1,  0,  8,  0,  3,  0,  0,  0,  5,  10, 7,  0,  4,  15, 4,  0,  6,  0,  10,
 0,  0,  5,  9,  15, 0,  15, 6,  0,  13, 15, 14, 0,  7,  0,  11, 0,  8,  0,  13, 0,  4,  15, 6,
 0,  0,  15, 14, 0,  5,  0,  1,  0,  0,  5,  12, 15, 1,  12, 0,  0,  13, 15, 15, 0,  1,  0,  1,
 0,  3,  0,  13, 0,  5,  10, 2,  0,  4,  15, 0,  0,  6,  0,  9,  0,  0,  5,  0,  15, 0,  15, 4,
 0,  13, 15, 11, 0,  7,  0,  0,  0,  8,  0,  13, 0,  4,  15, 0,  0,  0,  15, 14, 0,  5,  0,  7,
 0,  0,  5,  11, 15, 1,  12, 3,  0,  0,  0,  4,  0,  1,  0,  1,  0,  7,  0,  0,  0,  10, 0,  11,
 0,  0,  0,  0,  0,  0,  0,  0,  0,  12, 0,  2,  0,  8,  0,  0,  0,  0,  0,  0,  0,  8,  0,  0,
 0,  9,  0,  0,  0,  10, 0,  10, 0,  11, 0,  0,  0,  0,  0,  12, 0,  4,  0,  15, 0,  2,  0,  1,
 0,  0,  0,  4,  0,  1,  0,  9,  0,  7,  0,  0,  0,  10, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 0,  12, 0,  2,  0,  8,  0,  4,  0,  0,  0,  0,  0,  8,  0,  14, 0,  9,  0,  0,  0,  10, 0,  4,
 0,  11, 0,  0,  0,  0,  0,  0,  0,  4,  0,  7,  0,  2,  0,  3,  0,  0,  0,  13, 15, 6,  15, 9,
 0,  10, 0,  6,  15, 0,  14, 7,  0,  9,  0,  0,  15, 0,  7,  8,  0,  8,  0,  13, 0,  2,  9,  4,
 0,  11, 0,  15, 15, 2,  0,  0,  0,  10, 0,  13, 15, 0,  13, 6,  0,  10, 0,  14, 15, 4,  14, 7,
 0,  3,  0,  12, 0,  15, 8,  3,  0,  0,  0,  7,  15, 6,  15, 11, 0,  10, 0,  0,  15, 0,  14, 0,
 0,  9,  0,  14, 15, 0,  7,  6,  0,  8,  0,  0,  0,  2,  9,  3,  0,  11, 0,  7,  15, 2,  0,  9,
 0,  10, 0,  9,  15, 0,  13, 5,  0,  10, 0,  14, 15, 4,  14, 7,  0,  3,  0,  11, 0,  15, 8,  1,
 0,  5,  15, 1,  0,  6,  15, 12, 0,  9,  0,  2,  0,  2,  15, 8,  0,  0,  0,  0,  0,  1,  15, 10,
 0,  0,  0,  12, 15, 3,  6,  6,  0,  12, 15, 15, 0,  0,  15, 11, 0,  2,  0,  0,  0,  3,  14, 7,
 0,  11, 0,  5,  0,  0,  7,  1,  0,  0,  0,  12, 15, 3,  14, 4,  0,  5,  15, 1,  0,  6,  15, 9,
 0,  9,  0,  14, 0,  2,  15, 6,  0,  0,  0,  14, 0,  1,  15, 9,  0,  0,  0,  0,  15, 3,  6,  2,
 0,  12, 15, 11, 0,  0,  15, 0,  0,  2,  0,  13, 0,  3,  14, 0,  0,  11, 0,  14, 0,  0,  7,  7,
 0,  0,  0,  11, 15, 3,  14, 5,  15, 13, 15, 0,  15, 0,  15, 7,  15, 7,  15, 11, 15, 14, 14, 4,
 15, 2,  0,  11, 15, 0,  15, 0,  15, 1,  15, 7,  15, 13, 14, 3,  15, 11, 15, 8,  15, 15, 15, 7,
 15, 0,  15, 0,  15, 6,  15, 3,  15, 0,  0,  11, 15, 15, 15, 0,  15, 0,  15, 8,  15, 13, 13, 2,
 15, 13, 15, 12, 15, 0,  15, 7,  15, 7,  15, 9,  15, 14, 14, 0,  15, 2,  0,  0,  15, 15, 15, 0,
 15, 1,  15, 0,  15, 13, 14, 0,  15, 11, 15, 0,  15, 15, 15, 6,  15, 0,  15, 10, 15, 0,  15, 3,
 15, 0,  0,  11, 15, 14, 15, 5,  15, 0,  15, 0,  15, 9,  13, 1},
{0,  0,  0,  0,  0,  8,  0,  8,  0,  0,  0, 5, 0,  0, 0,  1,  0,  0, 0,  4,  0,  4, 0,  12, 0,
 2,  0,  9,  0,  0,  0,  1,  0,  0,  0,  4, 0, 8,  0, 1,  0,  4,  0, 12, 0,  0,  0, 0,  0,  0,
 0,  1,  0,  8,  0,  0,  0,  8,  0,  4,  0, 8, 0,  1, 0,  0,  0,  0, 0,  8,  0,  4, 0,  0,  0,
 2,  0,  0,  0,  2,  0,  0,  0,  4,  0,  4, 0, 1,  0, 2,  0,  0,  0, 0,  0,  2,  0, 0,  0,  4,
 0,  8,  0,  0,  0,  4,  0,  10, 0,  0,  0, 0, 0,  0, 0,  6,  0,  8, 0,  2,  0,  8, 0,  0,  0,
 8,  0,  2,  0,  0,  0,  0,  0,  4,  0,  0, 0, 2,  0, 0,  0,  0,  0, 0,  0,  0,  0, 0,  0,  8,
 0,  1,  0,  8,  0,  0,  0,  8,  0,  1,  0, 0, 0,  0, 0,  8,  0,  8, 0,  8,  0,  4, 0,  0,  0,
 0,  0,  4,  0,  4,  0,  0,  0,  0,  0,  4, 0, 2,  0, 0,  0,  0,  0, 0,  0,  0,  0, 4,  0,  1,
 0,  2,  0,  0,  0,  0,  0,  1,  0,  0,  0, 0, 0,  8, 0,  2,  0,  8, 0,  0,  0,  8, 0,  2,  0,
 0,  0,  0,  0,  8,  0,  4,  0,  8,  0,  4, 0, 0,  0, 2,  0,  4,  0, 4,  0,  0,  0, 8,  0,  4,
 0,  2,  0,  0,  0,  1,  0,  0,  0,  0,  0, 8, 0,  2, 0,  1,  0,  4, 0,  0,  0,  0, 0,  1,  0,
 1,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0, 0, 0,  0, 0,  0,  4,  0, 4,  0,  0,  0, 1,  0,  0,
 0,  0,  0,  5,  0,  4,  0,  1,  0,  0,  0, 4, 0,  4, 0,  8,  0,  0, 0,  2,  0,  0, 0,  0,  0,
 8,  0,  0,  0,  1,  0,  4,  0,  0,  0,  8, 0, 1,  0, 1,  0,  0,  0, 8,  0,  0,  0, 1,  0,  0,
 0,  0,  0,  0,  0,  4,  0,  4,  0,  1,  0, 1, 0,  0, 0,  0,  0,  2, 0,  4,  0,  1, 0,  0,  0,
 2,  0,  4,  0,  2,  0,  0,  0,  2,  0,  4, 4, 12, 0, 1,  0,  8,  0, 2,  0,  0,  0, 1,  10, 2,
 0,  4,  8,  4,  0,  4,  0,  2,  0,  0,  5, 9, 1,  0, 5,  2,  0,  1, 4,  6,  0,  1, 0,  1,  0,
 8,  0,  5,  0,  4,  2,  6,  0,  0,  8,  2, 0, 4,  0, 1,  0,  0,  5, 8,  1,  1,  8, 0,  0,  4,
 4,  3,  0,  1,  0,  1,  0,  2,  0,  8,  0, 1, 10, 2, 0,  4,  8,  0, 0,  4,  0,  8, 0,  0,  5,
 0,  1,  0,  5,  4,  0,  1,  4,  9,  0,  1, 0, 0,  0, 8,  0,  12, 0, 4,  2,  0,  0, 0,  8,  4,
 0,  4,  0,  3,  0,  0,  5,  8,  1,  1,  8, 2, 0,  0, 0,  0,  0,  0, 0,  1,  0,  2, 0,  0,  0,
 8,  0,  2,  0,  0,  0,  0,  0,  0,  0,  0, 0, 8,  0, 2,  0,  8,  0, 0,  0,  0,  0, 0,  0,  8,
 0,  0,  0,  1,  0,  0,  0,  2,  0,  10, 0, 8, 0,  0, 0,  0,  0,  4, 0,  4,  0,  4, 0,  2,  0,
 1,  0,  0,  0,  0,  0,  0,  0,  9,  0,  2, 0, 0,  0, 8,  0,  0,  0, 0,  0,  0,  0, 0,  0,  0,
 0,  8,  0,  2,  0,  8,  0,  4,  0,  0,  0, 0, 0,  8, 0,  2,  0,  1, 0,  0,  0,  2, 0,  4,  0,
 8,  0,  0,  0,  0,  0,  0,  0,  4,  0,  6, 0, 2,  0, 1,  0,  0,  0, 9,  2,  4,  1, 9,  0,  2,
 0,  6,  4,  0,  2,  3,  0,  8,  0,  0,  8, 0, 6,  8, 0,  8,  0,  5, 0,  2,  8,  4, 0,  2,  0,
 12, 2,  2,  0,  0,  0,  10, 0,  1,  4,  0, 4, 4,  0, 8,  0,  10, 8, 4,  8,  1,  0, 2,  0,  4,
 0,  10, 8,  1,  0,  0,  0,  7,  2,  4,  1, 3, 0,  2, 0,  0,  4,  0, 2,  0,  0,  8, 0,  4,  8,
 0,  6,  6,  0,  8,  0,  0,  0,  2,  8,  3, 0, 2,  0, 5,  2,  2,  0, 1,  0,  10, 0, 9,  4,  0,
 4,  1,  0,  8,  0,  12, 8,  4,  8,  2,  0, 2, 0,  1, 0,  3,  8,  1, 0,  4,  2,  1, 0,  4,  8,
 12, 0,  1,  0,  2,  0,  2,  3,  8,  0,  0, 0, 0,  0, 1,  12, 8,  0, 0,  0,  8,  1, 1,  6,  4,
 0,  8,  2,  5,  0,  0,  4,  10, 0,  2,  0, 0, 0,  2, 10, 3,  0,  2, 0,  5,  0,  0, 1,  1,  0,
 0,  0,  4,  1,  3,  8,  4,  0,  4,  2,  1, 0, 4,  8, 9,  0,  1,  0, 2,  0,  2,  3, 6,  0,  0,
 0,  4,  0,  1,  12, 8,  0,  0,  0,  0,  1, 1, 6,  2, 0,  8,  2,  9, 0,  0,  4,  0, 0,  2,  0,
 1,  0,  2,  10, 0,  0,  2,  0,  12, 0,  0, 1, 2,  0, 0,  0,  8,  1, 3,  8,  4,  1, 1,  10, 0,
 8,  0,  15, 4,  4,  1,  3,  3,  2,  10, 8, 4, 1,  2, 0,  8,  8,  0, 12, 0,  4,  1, 5,  5,  2,
 8,  2,  3,  1,  2,  10, 8,  8,  11, 15, 3, 4, 0,  3, 0,  2,  6,  9, 1,  1,  0,  0, 10, 8,  13,
 6,  0,  4,  0,  5,  8,  2,  12, 4,  2,  1, 1, 10, 4, 8,  0,  15, 2, 4,  1,  3,  9, 2,  12, 8,
 0,  1,  2,  0,  0,  8,  7,  12, 0,  4,  1, 5, 0,  2, 5,  2,  0,  1, 2,  10, 0,  8, 14, 15, 6,
 4,  0,  3,  8,  2,  0,  9,  2,  1,  0,  0, 1, 8,  4, 6,  4,  4,  0, 5,  0,  2,  9, 4,  1}

};

const int32_t dec_CxtVLC_table1[5][1024] = {
{3, 5, 3, 6, 3, 5, 3, 6, 3, 5, 3, 6, 3, 5, 3, 7, 3, 5, 3, 6, 3, 5, 3, 6, 3, 5, 3, 6, 3, 6, 3,
 7, 3, 5, 3, 6, 3, 5, 3, 6, 3, 5, 3, 6, 3, 5, 3, 7, 3, 5, 3, 6, 3, 5, 3, 7, 3, 5, 3, 6, 3, 6,
 3, 7, 3, 5, 3, 6, 3, 5, 3, 6, 3, 5, 3, 6, 3, 5, 3, 7, 3, 5, 3, 6, 3, 5, 3, 6, 3, 5, 3, 6, 3,
 6, 3, 7, 3, 5, 3, 6, 3, 5, 3, 6, 3, 5, 3, 6, 3, 5, 3, 7, 3, 5, 3, 6, 3, 5, 3, 7, 3, 5, 3, 6,
 3, 6, 3, 7, 1, 4, 1, 6, 1, 4, 1, 7, 1, 4, 1, 6, 1, 5, 1, 7, 1, 4, 1, 6, 1, 4, 1, 7, 1, 4, 1,
 7, 1, 5, 1, 7, 1, 4, 1, 6, 1, 4, 1, 7, 1, 4, 1, 7, 1, 5, 1, 7, 1, 4, 1, 6, 1, 4, 1, 7, 1, 4,
 1, 7, 1, 5, 1, 7, 1, 4, 1, 6, 1, 4, 1, 7, 1, 4, 1, 6, 1, 5, 1, 7, 1, 4, 1, 6, 1, 4, 1, 7, 1,
 4, 1, 7, 1, 5, 1, 7, 1, 4, 1, 6, 1, 4, 1, 7, 1, 4, 1, 7, 1, 5, 1, 7, 1, 4, 1, 6, 1, 4, 1, 7,
 1, 4, 1, 7, 1, 5, 1, 7, 1, 4, 1, 6, 1, 5, 1, 7, 1, 4, 1, 7, 1, 6, 1, 7, 1, 4, 1, 7, 1, 5, 1,
 7, 1, 4, 1, 7, 1, 6, 1, 7, 1, 4, 1, 6, 1, 5, 1, 7, 1, 4, 1, 7, 1, 6, 1, 7, 1, 4, 1, 7, 1, 5,
 1, 7, 1, 4, 1, 7, 1, 6, 1, 7, 1, 4, 1, 6, 1, 5, 1, 7, 1, 4, 1, 7, 1, 6, 1, 7, 1, 4, 1, 7, 1,
 5, 1, 7, 1, 4, 1, 7, 1, 6, 1, 7, 1, 4, 1, 6, 1, 5, 1, 7, 1, 4, 1, 7, 1, 6, 1, 7, 1, 4, 1, 7,
 1, 5, 1, 7, 1, 4, 1, 7, 1, 6, 1, 7, 2, 6, 4, 6, 2, 6, 5, 7, 2, 6, 4, 6, 2, 6, 5, 7, 2, 6, 4,
 6, 2, 6, 5, 7, 2, 6, 4, 7, 2, 6, 6, 7, 2, 6, 4, 6, 2, 6, 5, 7, 2, 6, 4, 7, 2, 6, 5, 7, 2, 6,
 4, 6, 2, 6, 5, 7, 2, 6, 4, 7, 2, 6, 6, 7, 2, 6, 4, 6, 2, 6, 5, 7, 2, 6, 4, 6, 2, 6, 5, 7, 2,
 6, 4, 6, 2, 6, 5, 7, 2, 6, 4, 7, 2, 6, 6, 7, 2, 6, 4, 6, 2, 6, 5, 7, 2, 6, 4, 7, 2, 6, 5, 7,
 2, 6, 4, 6, 2, 6, 5, 7, 2, 6, 4, 7, 2, 6, 6, 7, 1, 4, 1, 6, 1, 5, 1, 7, 1, 4, 1, 7, 1, 5, 1,
 7, 1, 4, 1, 6, 1, 5, 1, 7, 1, 4, 1, 7, 1, 6, 1, 7, 1, 4, 1, 6, 1, 5, 1, 7, 1, 4, 1, 7, 1, 5,
 1, 7, 1, 4, 1, 6, 1, 5, 1, 7, 1, 4, 1, 7, 1, 6, 1, 7, 1, 4, 1, 6, 1, 5, 1, 7, 1, 4, 1, 7, 1,
 5, 1, 7, 1, 4, 1, 6, 1, 5, 1, 7, 1, 4, 1, 7, 1, 6, 1, 7, 1, 4, 1, 6, 1, 5, 1, 7, 1, 4, 1, 7,
 1, 5, 1, 7, 1, 4, 1, 6, 1, 5, 1, 7, 1, 4, 1, 7, 1, 6, 1, 7, 2, 6, 4, 6, 2, 6, 5, 7, 2, 6, 5,
 6, 2, 6, 5, 7, 2, 6, 4, 6, 2, 6, 5, 7, 2, 6, 5, 6, 2, 6, 5, 7, 2, 6, 4, 6, 2, 6, 5, 7, 2, 6,
 5, 6, 2, 6, 5, 7, 2, 6, 4, 6, 2, 6, 5, 7, 2, 6, 5, 6, 2, 6, 5, 7, 2, 6, 4, 6, 2, 6, 5, 7, 2,
 6, 5, 6, 2, 6, 5, 7, 2, 6, 4, 6, 2, 6, 5, 7, 2, 6, 5, 6, 2, 6, 5, 7, 2, 6, 4, 6, 2, 6, 5, 7,
 2, 6, 5, 6, 2, 6, 5, 7, 2, 6, 4, 6, 2, 6, 5, 7, 2, 6, 5, 6, 2, 6, 5, 7, 3, 6, 4, 6, 4, 6, 5,
 7, 3, 6, 5, 7, 4, 6, 6, 7, 3, 6, 4, 7, 4, 6, 5, 7, 3, 6, 5, 7, 4, 6, 6, 7, 3, 6, 4, 7, 4, 6,
 5, 7, 3, 6, 5, 7, 4, 6, 6, 7, 3, 6, 4, 7, 4, 6, 5, 7, 3, 6, 5, 7, 4, 6, 6, 7, 3, 6, 4, 6, 4,
 6, 5, 7, 3, 6, 5, 7, 4, 6, 6, 7, 3, 6, 4, 7, 4, 6, 5, 7, 3, 6, 5, 7, 4, 6, 6, 7, 3, 6, 4, 7,
 4, 6, 5, 7, 3, 6, 5, 7, 4, 6, 6, 7, 3, 6, 4, 7, 4, 6, 5, 7, 3, 6, 5, 7, 4, 6, 6, 7, 3, 6, 5,
 6, 4, 6, 5, 7, 3, 6, 5, 7, 5, 6, 6, 7, 3, 6, 5, 6, 4, 6, 5, 7, 3, 6, 5, 7, 5, 6, 6, 7, 3, 6,
 5, 6, 4, 6, 5, 7, 3, 6, 5, 7, 5, 6, 6, 7, 3, 6, 5, 6, 4, 6, 5, 7, 3, 6, 5, 7, 5, 6, 6, 7, 3,
 6, 5, 6, 4, 6, 5, 7, 3, 6, 5, 7, 5, 6, 6, 7, 3, 6, 5, 6, 4, 6, 5, 7, 3, 6, 5, 7, 5, 6, 6, 7,
 3, 6, 5, 6, 4, 6, 5, 7, 3, 6, 5, 7, 5, 6, 6, 7, 3, 6, 5, 6, 4, 6, 5, 7, 3, 6, 5, 7, 5, 6, 6,
 7},
{1,  6,  4,  13, 8,  8,  2,  4,  1,  10, 4,  10, 8,  3,  2,  13, 1,  12, 4,  9,  8,  5,  2,  2,
 1,  9,  4,  7,  8,  15, 2,  7,  1,  6,  4,  12, 8,  8,  2,  1,  1,  10, 4,  5,  8,  3,  2,  14,
 1,  12, 4,  11, 8,  5,  2,  15, 1,  9,  4,  3,  8,  14, 2,  10, 1,  6,  4,  13, 8,  8,  2,  4,
 1,  10, 4,  10, 8,  3,  2,  14, 1,  12, 4,  9,  8,  5,  2,  2,  1,  9,  4,  7,  8,  15, 2,  11,
 1,  6,  4,  12, 8,  8,  2,  1,  1,  10, 4,  5,  8,  3,  2,  12, 1,  12, 4,  11, 8,  5,  2,  15,
 1,  9,  4,  3,  8,  14, 2,  6,  0,  8,  0,  5,  0,  1,  0,  13, 0,  2,  0,  9,  0,  4,  0,  7,
 0,  8,  0,  12, 0,  1,  0,  8,  0,  2,  0,  15, 0,  3,  0,  2,  0,  8,  0,  15, 0,  1,  0,  11,
 0,  2,  0,  11, 0,  4,  0,  6,  0,  8,  0,  10, 0,  1,  0,  4,  0,  2,  0,  14, 0,  3,  0,  3,
 0,  8,  0,  5,  0,  1,  0,  12, 0,  2,  0,  9,  0,  4,  0,  6,  0,  8,  0,  12, 0,  1,  0,  9,
 0,  2,  0,  14, 0,  3,  0,  3,  0,  8,  0,  15, 0,  1,  0,  10, 0,  2,  0,  15, 0,  4,  0,  5,
 0,  8,  0,  10, 0,  1,  0,  7,  0,  2,  0,  13, 0,  3,  0,  1,  0,  2,  0,  5,  0,  8,  0,  11,
 0,  1,  0,  15, 0,  12, 0,  7,  0,  2,  0,  15, 0,  4,  0,  7,  0,  1,  0,  13, 0,  10, 0,  3,
 0,  2,  0,  2,  0,  8,  0,  11, 0,  1,  0,  14, 0,  10, 0,  6,  0,  2,  0,  15, 0,  4,  0,  9,
 0,  1,  0,  12, 0,  3,  0,  3,  0,  2,  0,  5,  0,  8,  0,  11, 0,  1,  0,  14, 0,  12, 0,  6,
 0,  2,  0,  15, 0,  4,  0,  9,  0,  1,  0,  13, 0,  10, 0,  4,  0,  2,  0,  2,  0,  8,  0,  10,
 0,  1,  0,  14, 0,  10, 0,  5,  0,  2,  0,  15, 0,  4,  0,  8,  0,  1,  0,  10, 0,  3,  0,  1,
 0,  15, 2,  5,  0,  11, 8,  15, 0,  12, 1,  1,  0,  9,  3,  10, 0,  15, 2,  3,  0,  10, 4,  11,
 0,  11, 1,  15, 0,  6,  7,  5,  0,  15, 2,  2,  0,  10, 8,  14, 0,  12, 1,  15, 0,  7,  3,  7,
 0,  13, 2,  3,  0,  9,  4,  13, 0,  11, 1,  15, 0,  5,  15, 4,  0,  15, 2,  5,  0,  11, 8,  14,
 0,  12, 1,  1,  0,  9,  3,  8,  0,  15, 2,  3,  0,  10, 4,  13, 0,  11, 1,  15, 0,  6,  7,  6,
 0,  15, 2,  2,  0,  10, 8,  14, 0,  12, 1,  14, 0,  7,  3,  7,  0,  13, 2,  3,  0,  9,  4,  11,
 0,  11, 1,  15, 0,  5,  15, 3,  0,  8,  0,  14, 0,  12, 0,  12, 0,  4,  0,  15, 0,  1,  0,  8,
 0,  8,  0,  6,  0,  2,  0,  10, 0,  4,  0,  14, 0,  10, 0,  5,  0,  8,  0,  4,  0,  12, 0,  12,
 0,  4,  0,  15, 0,  1,  0,  6,  0,  8,  0,  5,  0,  2,  0,  9,  0,  4,  0,  13, 0,  15, 0,  2,
 0,  8,  0,  14, 0,  12, 0,  12, 0,  4,  0,  15, 0,  1,  0,  7,  0,  8,  0,  6,  0,  2,  0,  7,
 0,  4,  0,  14, 0,  10, 0,  3,  0,  8,  0,  4,  0,  12, 0,  11, 0,  4,  0,  11, 0,  1,  0,  3,
 0,  8,  0,  5,  0,  2,  0,  9,  0,  4,  0,  13, 0,  15, 0,  1,  0,  14, 4,  8,  0,  13, 12, 15,
 0,  15, 2,  3,  0,  11, 5,  13, 0,  15, 4,  6,  0,  7,  8,  15, 0,  14, 15, 3,  0,  10, 1,  9,
 0,  15, 4,  7,  0,  12, 12, 15, 0,  15, 2,  4,  0,  10, 5,  12, 0,  15, 4,  5,  0,  11, 8,  14,
 0,  13, 15, 1,  0,  9,  1,  2,  0,  14, 4,  8,  0,  13, 12, 15, 0,  15, 2,  3,  0,  11, 5,  11,
 0,  15, 4,  6,  0,  7,  8,  14, 0,  14, 15, 3,  0,  10, 1,  7,  0,  15, 4,  7,  0,  12, 12, 15,
 0,  15, 2,  4,  0,  10, 5,  6,  0,  15, 4,  5,  0,  11, 8,  13, 0,  13, 15, 1,  0,  9,  1,  5,
 0,  15, 1,  1,  4,  8,  10, 13, 0,  10, 5,  15, 2,  3,  11, 10, 0,  14, 1,  15, 4,  6,  8,  12,
 0,  9,  12, 14, 2,  3,  15, 7,  0,  14, 1,  15, 4,  7,  10, 12, 0,  7,  5,  13, 2,  4,  15, 5,
 0,  13, 1,  14, 4,  5,  8,  11, 0,  9,  12, 13, 2,  2,  15, 6,  0,  15, 1,  1,  4,  8,  10, 11,
 0,  10, 5,  15, 2,  3,  11, 10, 0,  14, 1,  15, 4,  6,  8,  11, 0,  9,  12, 14, 2,  3,  15, 6,
 0,  14, 1,  15, 4,  7,  10, 12, 0,  7,  5,  14, 2,  4,  15, 7,  0,  13, 1,  15, 4,  5,  8,  11,
 0,  9,  12, 13, 2,  2,  15, 3,  15, 15, 15, 3,  0,  11, 7,  13, 15, 13, 15, 14, 13, 7,  15, 7,
 15, 15, 15, 1,  0,  9,  5,  11, 15, 12, 11, 13, 15, 6,  15, 5,  15, 15, 15, 2,  0,  10, 7,  9,
 15, 10, 15, 15, 13, 4,  15, 7,  15, 14, 15, 1,  0,  8,  5,  8,  15, 12, 11, 14, 15, 5,  14, 3,
 15, 15, 15, 3,  0,  11, 7,  13, 15, 13, 15, 15, 13, 7,  15, 7,  15, 15, 15, 1,  0,  9,  5,  7,
 15, 12, 11, 14, 15, 6,  15, 4,  15, 15, 15, 2,  0,  10, 7,  11, 15, 10, 15, 15, 13, 4,  15, 3,
 15, 14, 15, 1,  0,  8,  5,  6,  15, 12, 11, 11, 15, 5,  14, 2},
{0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0,
 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1,
 0, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0,
 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1,
 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0,
 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0,
 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0,
 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1,
 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0,
 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0,
 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0,
 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1,
 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0,
 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1,
 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0,
 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 1, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1,
 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0,
 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0,
 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1,
 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0,
 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 1,
 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0,
 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1,
 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0,
 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 1, 1, 0, 1, 0, 1, 0, 0,
 0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 1, 1, 0, 0, 0, 1, 0,
 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 1, 1, 0, 1, 0, 1,
 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 1, 1, 0, 1, 1,
 0, 0, 1, 0, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 0, 0, 1, 0, 1, 0, 1, 1, 0, 1, 1, 0, 1,
 1, 0, 0, 0, 0, 1, 0, 1, 1, 1, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 1, 1, 1, 0,
 1, 1, 0, 0, 1, 0, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 0, 0, 1, 0, 1, 0, 1, 1, 0, 1, 1,
 0, 1, 1, 0, 0, 0, 0, 1, 0, 1, 1, 1, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 1, 1,
 1},
{0, 0,  0,  0,  0,  8,  0,  4,  0, 0,  0,  8,  0,  0,  0,  0,  0, 0,  0,  0,  0,  0, 0,  2,
 0, 0,  0,  0,  0,  1,  0,  0,  0, 0,  0,  8,  0,  8,  0,  1,  0, 0,  0,  0,  0,  0, 0,  0,
 0, 0,  0,  0,  0,  0,  0,  1,  0, 0,  0,  0,  0,  4,  0,  10, 0, 0,  0,  0,  0,  8, 0,  4,
 0, 0,  0,  8,  0,  0,  0,  4,  0, 0,  0,  0,  0,  0,  0,  2,  0, 0,  0,  0,  0,  1, 0,  0,
 0, 0,  0,  8,  0,  8,  0,  1,  0, 0,  0,  0,  0,  0,  0,  12, 0, 0,  0,  0,  0,  0, 0,  0,
 0, 0,  0,  0,  0,  4,  0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0, 0,  0,  0,  0,  0, 0,  0,
 0, 0,  0,  0,  0,  0,  0,  8,  0, 0,  0,  0,  0,  0,  0,  2,  0, 0,  0,  4,  0,  0, 0,  0,
 0, 0,  0,  0,  0,  0,  0,  0,  0, 0,  0,  0,  0,  0,  0,  4,  0, 0,  0,  0,  0,  0, 0,  1,
 0, 0,  0,  0,  0,  0,  0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0, 0,  0,  0,  0,  0, 0,  0,
 0, 0,  0,  0,  0,  0,  0,  3,  0, 0,  0,  4,  0,  0,  0,  0,  0, 0,  0,  4,  0,  0, 0,  0,
 0, 0,  0,  0,  0,  0,  0,  0,  0, 0,  0,  0,  0,  0,  0,  1,  0, 0,  0,  0,  0,  0, 0,  0,
 0, 0,  0,  0,  0,  0,  0,  0,  0, 0,  0,  15, 0,  0,  0,  0,  0, 0,  0,  0,  0,  0, 0,  3,
 0, 0,  0,  2,  0,  0,  0,  0,  0, 0,  0,  4,  0,  10, 0,  0,  0, 0,  0,  5,  0,  0, 0,  0,
 0, 0,  0,  0,  0,  0,  0,  2,  0, 0,  0,  0,  0,  0,  0,  11, 0, 0,  0,  4,  0,  0, 0,  0,
 0, 0,  0,  7,  0,  0,  0,  0,  0, 0,  0,  0,  0,  0,  0,  4,  0, 0,  0,  2,  0,  0, 0,  10,
 0, 0,  0,  0,  0,  10, 0,  0,  0, 0,  0,  4,  0,  0,  0,  8,  0, 0,  0,  10, 0,  0, 0,  1,
 0, 15, 0,  0,  0,  0,  0,  6,  0, 0,  0,  1,  0,  0,  0,  10, 0, 0,  0,  3,  0,  0, 0,  11,
 0, 11, 0,  15, 0,  0,  5,  5,  0, 15, 0,  2,  0,  2,  0,  4,  0, 0,  0,  15, 0,  0, 0,  4,
 0, 4,  0,  3,  0,  0,  0,  0,  0, 8,  0,  15, 0,  1,  15, 4,  0, 15, 0,  0,  0,  0, 0,  12,
 0, 0,  0,  1,  0,  0,  0,  8,  0, 0,  0,  3,  0,  0,  0,  4,  0, 11, 0,  10, 0,  0, 5,  0,
 0, 15, 0,  2,  0,  2,  0,  0,  0, 0,  0,  14, 0,  0,  0,  7,  0, 4,  0,  3,  0,  0, 0,  11,
 0, 8,  0,  7,  0,  1,  15, 3,  0, 0,  0,  2,  0,  0,  0,  12, 0, 0,  0,  3,  0,  0, 0,  8,
 0, 0,  0,  0,  0,  0,  0,  0,  0, 0,  0,  2,  0,  0,  0,  0,  0, 0,  0,  4,  0,  0, 0,  12,
 0, 0,  0,  0,  0,  0,  0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0, 0,  0,  0,  0,  3, 0,  2,
 0, 0,  0,  2,  0,  0,  0,  12, 0, 0,  0,  1,  0,  0,  0,  0,  0, 0,  0,  0,  0,  0, 0,  0,
 0, 0,  0,  0,  0,  0,  0,  0,  0, 0,  0,  4,  0,  0,  0,  0,  0, 0,  0,  0,  0,  0, 0,  0,
 0, 0,  0,  0,  0,  0,  0,  0,  0, 0,  0,  0,  0,  3,  0,  1,  0, 10, 0,  8,  0,  0, 0,  15,
 0, 15, 0,  0,  0,  0,  0,  13, 0, 15, 0,  0,  0,  2,  0,  9,  0, 0,  0,  0,  0,  0, 0,  0,
 0, 15, 0,  0,  0,  4,  0,  7,  0, 15, 0,  4,  0,  0,  0,  12, 0, 15, 0,  4,  0,  1, 0,  14,
 0, 5,  0,  1,  0,  0,  0,  2,  0, 10, 0,  8,  0,  0,  0,  15, 0, 15, 0,  0,  0,  0, 0,  1,
 0, 15, 0,  0,  0,  2,  0,  2,  0, 0,  0,  0,  0,  0,  0,  2,  0, 15, 0,  0,  0,  4, 0,  13,
 0, 15, 0,  4,  0,  0,  0,  0,  0, 15, 0,  4,  0,  1,  0,  1,  0, 5,  0,  1,  0,  0, 0,  5,
 0, 0,  0,  1,  0,  8,  0,  13, 0, 10, 0,  7,  0,  2,  0,  10, 0, 0,  0,  15, 0,  0, 0,  12,
 0, 0,  0,  4,  0,  0,  15, 3,  0, 14, 0,  15, 0,  0,  0,  12, 0, 2,  0,  13, 0,  4, 15, 5,
 0, 0,  0,  14, 0,  4,  0,  2,  0, 0,  0,  12, 0,  2,  15, 2,  0, 0,  0,  1,  0,  8, 0,  11,
 0, 10, 0,  3,  0,  2,  0,  10, 0, 0,  0,  11, 0,  0,  0,  10, 0, 0,  0,  14, 0,  0, 15, 6,
 0, 14, 0,  15, 0,  0,  0,  12, 0, 2,  0,  14, 0,  4,  15, 7,  0, 0,  0,  15, 0,  4, 0,  11,
 0, 0,  0,  4,  0,  2,  15, 3,  0, 15, 15, 0,  0,  3,  0,  1,  0, 5,  15, 14, 0,  7, 15, 7,
 0, 15, 15, 1,  0,  0,  0,  11, 0, 0,  0,  13, 15, 0,  11, 5,  0, 7,  15, 0,  0,  0, 0,  0,
 0, 0,  15, 15, 0,  0,  15, 7,  0, 0,  15, 0,  0,  0,  0,  8,  0, 0,  0,  14, 15, 1, 10, 1,
 0, 15, 15, 0,  0,  3,  0,  13, 0, 5,  15, 15, 0,  7,  15, 4,  0, 15, 15, 1,  0,  0, 0,  7,
 0, 0,  0,  2,  15, 0,  11, 4,  0, 7,  15, 0,  0,  0,  0,  1,  0, 0,  15, 15, 0,  0, 15, 3,
 0, 0,  15, 0,  0,  0,  0,  0,  0, 0,  0,  11, 15, 1,  10, 2},
{0, 0,  0, 0, 0, 8,  0, 4,  0, 0,  0, 8,  0, 0,  0,  0,  0, 0, 0, 0,  0, 0, 0,  2,  0, 0, 0, 0,
 0, 0,  0, 0, 0, 0,  0, 8,  0, 8,  0, 1,  0, 0,  0,  0,  0, 0, 0, 0,  0, 0, 0,  0,  0, 0, 0, 1,
 0, 0,  0, 0, 0, 0,  0, 2,  0, 0,  0, 0,  0, 8,  0,  4,  0, 0, 0, 8,  0, 0, 0,  4,  0, 0, 0, 0,
 0, 0,  0, 2, 0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0,  8,  0, 8, 0, 1,  0, 0, 0,  0,  0, 0, 0, 4,
 0, 0,  0, 0, 0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0,  0,  0, 0, 0, 0,  0, 0, 0,  0,  0, 0, 0, 0,
 0, 0,  0, 0, 0, 0,  0, 0,  0, 0,  0, 8,  0, 0,  0,  0,  0, 0, 0, 2,  0, 0, 0,  0,  0, 0, 0, 0,
 0, 0,  0, 0, 0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0,  4,  0, 0, 0, 0,  0, 0, 0,  1,  0, 0, 0, 0,
 0, 0,  0, 0, 0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0,  0,  0, 0, 0, 0,  0, 0, 0,  0,  0, 0, 0, 2,
 0, 0,  0, 0, 0, 0,  0, 0,  0, 0,  0, 4,  0, 0,  0,  0,  0, 0, 0, 0,  0, 0, 0,  0,  0, 0, 0, 0,
 0, 0,  0, 1, 0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0,  0,  0, 0, 0, 0,  0, 0, 0,  8,  0, 0, 0, 0,
 0, 0,  0, 0, 0, 0,  0, 1,  0, 0,  0, 2,  0, 0,  0,  0,  0, 0, 0, 4,  0, 2, 0,  0,  0, 0, 0, 1,
 0, 0,  0, 0, 0, 0,  0, 0,  0, 0,  0, 2,  0, 0,  0,  0,  0, 0, 0, 2,  0, 0, 0,  0,  0, 0, 0, 0,
 0, 0,  0, 2, 0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0,  4,  0, 0, 0, 2,  0, 0, 0,  8,  0, 0, 0, 0,
 0, 2,  0, 0, 0, 0,  0, 4,  0, 0,  0, 8,  0, 0,  0,  10, 0, 0, 0, 1,  0, 8, 0,  0,  0, 0, 0, 6,
 0, 0,  0, 1, 0, 0,  0, 8,  0, 0,  0, 1,  0, 0,  0,  3,  0, 2, 0, 5,  0, 0, 1,  4,  0, 2, 0, 2,
 0, 2,  0, 4, 0, 0,  0, 4,  0, 0,  0, 4,  0, 0,  0,  2,  0, 0, 0, 0,  0, 8, 0,  10, 0, 1, 1, 4,
 0, 8,  0, 0, 0, 0,  0, 8,  0, 0,  0, 1,  0, 0,  0,  8,  0, 0, 0, 1,  0, 0, 0,  4,  0, 2, 0, 8,
 0, 0,  1, 0, 0, 2,  0, 2,  0, 2,  0, 0,  0, 0,  0,  2,  0, 0, 0, 2,  0, 0, 0,  2,  0, 0, 0, 1,
 0, 8,  0, 3, 0, 1,  1, 3,  0, 0,  0, 0,  0, 0,  0,  4,  0, 0, 0, 2,  0, 0, 0,  8,  0, 0, 0, 0,
 0, 0,  0, 0, 0, 0,  0, 2,  0, 0,  0, 0,  0, 0,  0,  4,  0, 0, 0, 12, 0, 0, 0,  0,  0, 0, 0, 0,
 0, 0,  0, 0, 0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0,  2,  0, 0, 0, 0,  0, 0, 0,  8,  0, 0, 0, 1,
 0, 0,  0, 0, 0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0,  0,  0, 0, 0, 0,  0, 0, 0,  4,  0, 0, 0, 0,
 0, 0,  0, 0, 0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0,  0,  0, 0, 0, 0,  0, 0, 0,  1,  0, 8, 0, 8,
 0, 0,  0, 3, 0, 12, 0, 0,  0, 0,  0, 8,  0, 8,  0,  0,  0, 0, 0, 9,  0, 0, 0,  0,  0, 0, 0, 0,
 0, 2,  0, 0, 0, 4,  0, 6,  0, 1,  0, 4,  0, 0,  0,  8,  0, 4, 0, 4,  0, 0, 0,  4,  0, 4, 0, 1,
 0, 0,  0, 2, 0, 8,  0, 8,  0, 0,  0, 10, 0, 12, 0,  0,  0, 0, 0, 1,  0, 8, 0,  0,  0, 0, 0, 2,
 0, 0,  0, 0, 0, 0,  0, 2,  0, 2,  0, 0,  0, 4,  0,  5,  0, 1, 0, 4,  0, 0, 0,  0,  0, 4, 0, 4,
 0, 0,  0, 1, 0, 4,  0, 1,  0, 0,  0, 1,  0, 0,  0,  1,  0, 8, 0, 4,  0, 2, 0,  6,  0, 2, 0, 10,
 0, 0,  0, 5, 0, 0,  0, 12, 0, 0,  0, 4,  0, 0,  8,  1,  0, 8, 0, 1,  0, 0, 0,  4,  0, 2, 0, 1,
 0, 4,  4, 1, 0, 0,  0, 2,  0, 4,  0, 2,  0, 0,  0,  8,  0, 2, 2, 2,  0, 0, 0,  1,  0, 8, 0, 1,
 0, 2,  0, 3, 0, 2,  0, 8,  0, 0,  0, 9,  0, 0,  0,  8,  0, 0, 0, 4,  0, 0, 8,  4,  0, 8, 0, 12,
 0, 0,  0, 8, 0, 2,  0, 10, 0, 4,  4, 4,  0, 0,  0,  10, 0, 4, 0, 2,  0, 0, 0,  4,  0, 2, 2, 1,
 0, 10, 1, 0, 0, 2,  0, 1,  0, 4,  2, 4,  0, 1,  12, 3,  0, 3, 8, 1,  0, 0, 0,  1,  0, 0, 0, 8,
 4, 0,  9, 4, 0, 6,  1, 0,  0, 0,  0, 0,  0, 0,  2,  7,  0, 0, 5, 4,  0, 0, 8,  0,  0, 0, 0, 8,
 0, 0,  0, 2, 4, 1,  8, 1,  0, 10, 1, 0,  0, 2,  0,  1,  0, 4, 2, 11, 0, 1, 12, 4,  0, 3, 8, 1,
 0, 0,  0, 2, 0, 0,  0, 2,  4, 0,  9, 4,  0, 6,  1,  0,  0, 0, 0, 1,  0, 0, 2,  15, 0, 0, 5, 2,
 0, 0,  8, 0, 0, 0,  0, 0,  0, 0,  0, 8,  4, 1,  8,  2}};
 */
