# BEGIN COPYRIGHT BLOCK
# Copyright (C) 2015  Red Hat
# see files 'COPYING' and 'COPYING.openssl' for use and warranty
# information
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
# 
# Additional permission under GPLv3 section 7:
# 
# If you modify this Program, or any covered work, by linking or
# combining it with OpenSSL, or a modified version of OpenSSL licensed
# under the OpenSSL license
# (https://www.openssl.org/source/license.html), the licensors of this
# Program grant you additional permission to convey the resulting
# work. Corresponding Source for a non-source form of such a
# combination shall include the source code for the parts that are
# licensed under the OpenSSL license as well as that of the covered
# work.
# END COPYRIGHT BLOCK
if test -z "$with_lfds_src" ; then
   # by default, look for liblfds subdir of nunc-stans source dir
   with_lfds_src=$srcdir/liblfds
fi

AC_CHECKING(for lfds)
AC_MSG_CHECKING(for --with-lfds-src)
AC_ARG_WITH(lfds-src, AS_HELP_STRING([--with-lfds-src@<:@=PATH@:>@],[LFDS source directory]),
[
  if test "$withval" = "yes"; then
    AC_MSG_RESULT(yes)
  elif test "$withval" = "no"; then
    AC_MSG_RESULT(no)
  elif test -d "$withval"; then
    AC_MSG_RESULT([using $withval])
    dnl - check the user provided location
    lfds_lib="-L$withval/bin"
    lfds_libdir="$withval/lib"
    lfds_incdir="$withval/inc"
    if ! test -e "$lfds_incdir/liblfds.h" ; then
      AC_MSG_ERROR([$withval include dir not found])
    fi
    lfds_inc="-I$lfds_incdir"
    lfds_subdir=$withval
    if test "$enable_debug" = "yes" ; then
      lfds_make_target=ardbg
    else
      lfds_make_target=arrel
    fi
    dnl - we need a GNU style makefile in that directory
    if test -f $lfds_subdir/GNUmakefile ; then
      AC_MSG_WARN([$lfds_subdir/GNUmakefile exists - will overwrite])
    fi
    cat > $lfds_subdir/GNUmakefile <<EOF
# First, include the real Makefile
include makefile.linux
# Then, define the other targets needed by Automake Makefiles.
# note - if building from source, we build liblfds as an ar not an so
# so there is nothing to install - but we still need install to make
# the library if it doesn't exist
# Always set pic so we can link into the nunc-stans shared lib
CFLAGS = $CFLAGS \$(AM_CFLAGS) -c -fpic -Wno-unknown-pragmas -std=c99 -I"\$(SRCDIR)" -I"\$(INCDIR)" $LFDS_CFLAGS
lfds_make_target = $lfds_make_target
.PHONY: dvi pdf ps info html check
dvi pdf ps info html:
check: test
install all: \$(lfds_make_target)
EOF
  else
    echo
    AC_MSG_ERROR([$withval not found])
  fi
],
AC_MSG_RESULT(no))

dnl  - check for --with-lfds
AC_MSG_CHECKING(for --with-lfds)
AC_ARG_WITH(lfds, AS_HELP_STRING([--with-lfds@<:@=PATH@:>@],[LFDS directory]),
[
  if test "$withval" = "yes"; then
    AC_MSG_RESULT(yes)
  elif test "$withval" = "no"; then
    AC_MSG_RESULT(no)
  elif test -d "$withval"/inc -a -d "$withval"/bin; then
    AC_MSG_RESULT([using $withval])
    dnl - check the user provided location
    lfds_lib="-L$withval/bin"
    lfds_libdir="$withval/lib"
    lfds_incdir="$withval/inc"
    if ! test -e "$lfds_incdir/liblfds.h" ; then
      AC_MSG_ERROR([$withval include dir not found])
    fi
    lfds_inc="-I$lfds_incdir"
  else
    echo
    AC_MSG_ERROR([$withval not found])
  fi
],
AC_MSG_RESULT(no))

# check for --with-lfds-inc
AC_MSG_CHECKING(for --with-lfds-inc)
AC_ARG_WITH(lfds-inc, AS_HELP_STRING([--with-lfds-inc=PATH],[LFDS include file directory]),
[
  if test -e "$withval"/liblfds.h
  then
    AC_MSG_RESULT([using $withval])
    lfds_incdir="$withval"
    lfds_inc="-I$withval"
  else
    echo
    AC_MSG_ERROR([$withval not found])
  fi
],
AC_MSG_RESULT(no))

# check for --with-lfds-lib
AC_MSG_CHECKING(for --with-lfds-lib)
AC_ARG_WITH(lfds-lib, AS_HELP_STRING([--with-lfds-lib=PATH],[LFDS library directory]),
[
  if test -d "$withval"
  then
    AC_MSG_RESULT([using $withval])
    lfds_lib="-L$withval"
    lfds_libdir="$withval"
  else
    echo
    AC_MSG_ERROR([$withval not found])
  fi
],
AC_MSG_RESULT(no))
