/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.starteam;

import com.starbase.starteam.Folder;
import com.starbase.starteam.Label;
import com.starbase.starteam.StarTeamFinder;
import com.starbase.starteam.View;
import java.io.File;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.optional.starteam.StarTeamTask;

public abstract class TreeBasedTask
extends StarTeamTask {
    public static final String DEFAULT_INCLUDESETTING = "*";
    public static final String DEFAULT_EXCLUDESETTING = null;
    private String rootStarteamFolder = "/";
    private String rootLocalFolder = null;
    private String includes = "*";
    private String excludes = DEFAULT_EXCLUDESETTING;
    private String label = null;
    private boolean recursive = true;
    private boolean forced = false;

    public void setRootStarteamFolder(String rootStarteamFolder) {
        this.rootStarteamFolder = rootStarteamFolder;
    }

    public String getRootStarteamFolder() {
        return this.rootStarteamFolder;
    }

    public void setRootLocalFolder(String rootLocalFolder) {
        this.rootLocalFolder = rootLocalFolder;
    }

    public String getRootLocalFolder() {
        return this.rootLocalFolder;
    }

    public void setIncludes(String includes) {
        this.includes = includes;
    }

    public String getIncludes() {
        return this.includes;
    }

    public void setExcludes(String excludes) {
        this.excludes = excludes;
    }

    public String getExcludes() {
        return this.excludes;
    }

    protected void _setLabel(String label) {
        if (null != label && (label = label.trim()).length() > 0) {
            this.label = label;
        }
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean v) {
        this.recursive = v;
    }

    public boolean isForced() {
        return this.forced;
    }

    public void setForced(boolean v) {
        this.forced = v;
    }

    protected boolean shouldProcess(String pName) {
        boolean includeIt = this.matchPatterns(this.getIncludes(), pName);
        boolean excludeIt = this.matchPatterns(this.getExcludes(), pName);
        return includeIt && !excludeIt;
    }

    protected boolean matchPatterns(String patterns, String pName) {
        if (patterns == null) {
            return false;
        }
        StringTokenizer exStr = new StringTokenizer(patterns, ",");
        while (exStr.hasMoreTokens()) {
            if (!DirectoryScanner.match((String)exStr.nextToken(), (String)pName)) continue;
            return true;
        }
        return false;
    }

    public void execute() throws BuildException {
        try {
            File localrootfolder;
            this.testPreconditions();
            View snapshot = this.openView();
            Folder starteamrootfolder = StarTeamFinder.findFolder((Folder)snapshot.getRootFolder(), (String)this.rootStarteamFolder);
            if (null == starteamrootfolder) {
                throw new BuildException("Unable to find root folder in repository.");
            }
            if (null == this.rootLocalFolder) {
                localrootfolder = new File(starteamrootfolder.getPath());
            } else {
                localrootfolder = new File(this.getRootLocalFolder());
                this.log("overriding local folder to " + localrootfolder);
            }
            this.visit(starteamrootfolder, localrootfolder);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    protected int getLabelID(View v) throws BuildException {
        if (null != this.label) {
            Label[] allLabels = v.getLabels();
            int i = 0;
            while (i < allLabels.length) {
                if (allLabels[i].getName().equals(this.label)) {
                    return allLabels[i].getID();
                }
                ++i;
            }
            throw new BuildException("Error: label " + this.label + " does not exist in view");
        }
        return -1;
    }

    protected abstract void visit(Folder var1, File var2) throws BuildException;

    protected abstract void testPreconditions() throws BuildException;

    protected static Hashtable listLocalFiles(File localFolder) {
        Hashtable<String, String> localFileList = new Hashtable<String, String>();
        if (localFolder.exists()) {
            String[] localFiles = localFolder.list();
            int i = 0;
            while (i < localFiles.length) {
                localFileList.put(localFolder.toString() + File.separatorChar + localFiles[i], "");
                ++i;
            }
        }
        return localFileList;
    }

    protected boolean delistLocalFile(Hashtable localFiles, File thisfile) {
        return null != localFiles.remove(thisfile.toString());
    }
}

