/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.expr;

import com.jclark.xsl.expr.ArrayNodeIterator;
import com.jclark.xsl.expr.ConvertibleExpr;
import com.jclark.xsl.expr.ConvertibleNodeSetExpr;
import com.jclark.xsl.expr.ConvertibleStringExpr;
import com.jclark.xsl.expr.ExprContext;
import com.jclark.xsl.expr.Function;
import com.jclark.xsl.expr.LiteralExpr;
import com.jclark.xsl.expr.ParseException;
import com.jclark.xsl.om.Name;
import com.jclark.xsl.om.NamespacePrefixMap;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.NodeIterator;
import com.jclark.xsl.om.SafeNodeIterator;
import com.jclark.xsl.om.XSLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

class RegexpMatchFunction
implements Function {
    RegexpMatchFunction() {
    }

    public ConvertibleExpr makeCallExpr(ConvertibleExpr[] args, Node exprNode) throws ParseException {
        if (args.length < 2 || args.length > 3) {
            throw new ParseException("expected 2 or 3 arguments");
        }
        final ConvertibleStringExpr se = args[0].makeStringExpr();
        final ConvertibleStringExpr se2 = args[1].makeStringExpr();
        final ConvertibleStringExpr se3 = args.length == 2 ? new LiteralExpr("") : args[2].makeStringExpr();
        return new ConvertibleNodeSetExpr(){

            public NodeIterator eval(Node node, ExprContext context) throws XSLException {
                return RegexpMatchFunction.match(node, context, se.eval(node, context), se2.eval(node, context), se3.eval(node, context));
            }
        };
    }

    private static final NodeIterator match(Node node, ExprContext context, String src, String pattern, String flags) throws XSLException {
        try {
            boolean globalReplace = false;
            boolean ignoreCase = false;
            if (flags.length() > 0) {
                globalReplace = flags.indexOf("g") >= 0;
                ignoreCase = flags.indexOf("i") >= 0;
            }
            Node[] groups = new Node[24];
            Pattern pat = ignoreCase ? Pattern.compile(pattern, 2) : Pattern.compile(pattern);
            Matcher matcher = pat.matcher(src);
            if (matcher.find()) {
                int gc = matcher.groupCount();
                for (int i = 0; i < gc + 1; ++i) {
                    RegexTextNode regexGroupTextNode = new RegexTextNode(matcher.group(i), i, node);
                    groups[i] = regexGroupTextNode;
                }
                return new ArrayNodeIterator(groups, 1, gc + 1);
            }
            return null;
        }
        catch (PatternSyntaxException ex) {
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static class RegexNodeIterator
    implements SafeNodeIterator {
        private Node nextNode;

        RegexNodeIterator(Node nextNode) {
            this.nextNode = nextNode;
        }

        public Node next() {
            return null;
        }
    }

    private static class RegexTextNode
    implements Node {
        Node _parent;
        Node _root;
        int _index;
        Node _nextSibling;
        private String _data;

        RegexTextNode(String regexGroupText, int index, Node parent) {
            this._parent = parent;
            this._index = index;
            this._data = regexGroupText;
            this._root = this._parent.getRoot();
            this._nextSibling = null;
        }

        public Node getParent() {
            return this._parent;
        }

        public SafeNodeIterator getFollowingSiblings() {
            return new RegexNodeIterator(null);
        }

        public URL getURL() {
            return this._parent.getURL();
        }

        boolean canStrip() {
            return false;
        }

        public Node getAttribute(Name name) {
            return null;
        }

        public String getAttributeValue(Name name) {
            return null;
        }

        public SafeNodeIterator getAttributes() {
            return new RegexNodeIterator(null);
        }

        public SafeNodeIterator getNamespaces() {
            return new RegexNodeIterator(null);
        }

        public Name getName() {
            return null;
        }

        public NamespacePrefixMap getNamespacePrefixMap() {
            return this.getParent().getNamespacePrefixMap();
        }

        public int compareTo(Node node) {
            return -1;
        }

        public Node getElementWithId(String name) {
            return this._root.getElementWithId(name);
        }

        public String getUnparsedEntityURI(String name) {
            return this._root.getUnparsedEntityURI(name);
        }

        public boolean isId(String name) {
            return false;
        }

        public String getGeneratedId() {
            int d = this._index;
            if (d == 0) {
                return "N" + String.valueOf(this._index);
            }
            return "N" + String.valueOf(d) + "_" + String.valueOf(this._index);
        }

        public Node getRoot() {
            return this._root;
        }

        public int getLineNumber() {
            return this._parent.getLineNumber();
        }

        public int getColumnNumber() {
            return -1;
        }

        public String getSystemId() {
            return this.getRoot().getSystemId();
        }

        public String getPublicId() {
            return null;
        }

        public byte getType() {
            return 1;
        }

        public String getData() {
            return this._data;
        }

        public SafeNodeIterator getChildren() {
            return new RegexNodeIterator(null);
        }
    }
}

