#include "maildir-bulletin.h"
#include "mb_util.h"
#include <time.h>
#include <pwd.h>
#include <sys/types.h>
#include <dirent.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string>

using namespace std;

int expire_file(CPCCHAR file, mb_log &log)
{
  struct stat buf;
  if(stat(file, &buf))
  {
    log.error("Can't stat file \"%s\"", file);
    return 1;
  }
  ino_t inode = buf.st_ino;
  setpwent();
  passwd *pw;
  int count = 0;
  while( (pw = getpwent()) )
  {
    if(pw->pw_uid > MIN_USER_ID)
    {
      string newDir = pw->pw_dir;
      newDir += "/Maildir/new";
      DIR *d = opendir(newDir.c_str());
      if(!d)
      {
        log.error("Can't open directory \"%s\"", newDir.c_str());
      }
      else
      {
        dirent *dent;
        while( (dent = readdir(d)) )
        {
          string fileName(newDir);
          fileName += "/";
          fileName += dent->d_name;
          if(stat(fileName.c_str(), &buf))
          {
            log.error("Can't stat file \"%s\"", fileName.c_str());
            return 1;
          }
          if(buf.st_ino == inode)
          {
            if(unlink(fileName.c_str()))
            {
              log.error("Can't unlink file \"%s\"", fileName.c_str());
              return 1;
            }
            count++;
          }
        }
        closedir(d);
      }
    }
  }
  endpwent();
  if(count)
  {
    char bCount[9];
    sprintf(bCount, "%d", count);
    log.info("Deleted %s links to bulletin \"%s\"", bCount, file);
  }
  return 0;
}

int main(int argc, char **argv)
{
  time_t t = time(NULL);
  struct tm *loc = NULL;
  loc = localtime(&t);
  mb_log log(LOG_FILE, ERROR_FILE, loc);
  int i;
  if(argc > 1)
  {
    log.interactive(true);
    for(i = 1; i < argc; i++)
    {
      expire_file(argv[i], log);
    }
    return 0;
  }
  DIR *d = opendir(BULLETINSDIR);
  if(!d)
  {
    log.error("Can't open directory \"" BULLETINSDIR "\"", NULL, NULL, true);
    return 1;
  }
  dirent *dent;
  while( (dent = readdir(d)) )
  {
    int sepCount = 0;
    for(i = 0; dent->d_name[i] && sepCount < 5; i++)
    {
      if(dent->d_name[i] == ':')
        sepCount++;
    }
    int year, mon, day;
    if(3 == sscanf(&(dent->d_name[i]), "%d-%d-%d", &year, &mon, &day) )
    {
      year -= 1900;
      mon--;
      if(loc->tm_year > year
         || (loc->tm_year == year && (loc->tm_mon > mon
                                     || (loc->tm_mon == mon && loc->tm_mday > day)
                                     ) ) )
      {
        string name(BULLETINSDIR);
        name += "/";
        name += dent->d_name;
        expire_file(name.c_str(), log);
        string newName(BULLETINSDIR);
        newName += "/removed/";
        newName += dent->d_name;
        if(rename(name.c_str(), newName.c_str()) )
        {
          log.error("Can't rename \"%s\" to \"%s\".", name.c_str()
                  , newName.c_str(), true);
          return 1;
        }
      }
    }
  }
  return 0;
}

