/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

//
// .NAME:
//  Preferences
//
// .AUTHOR:
//  Gilberto Camara, Baudouin Raoult and Fernando Ii
//
// .SUMMARY:
//  Defines a class for handling interfaces preferences
//
//
// .CLIENTS:
//  SuperPage
//
// .RESPONSABILITIES:
//  - Keep track of users' preferences
//  - Inform these preferences to the user
//
//
// .COLLABORATORS:
//
//
//
// .BASE CLASS:
//
//
// .DERIVED CLASSES:
//
//
// .REFERENCES:
//
//
#ifndef Preferences_H
#define Preferences_H

#include "Presentable.h"

class Preferences
{
public:
    // Constructors
    Preferences(Presentable& owner);
    Preferences(const Preferences&);

    // Destructor
    ~Preferences() {}

    // Class Members
    void Owner(Presentable& xx) { owner_ = &xx; }
    Presentable& Owner() { return *owner_; }

    // Class functions
    static MvRequest CoastRequest();

#if 0
	static MvRequest PrinterRequest();

	static MvRequest MapDefRequest();


	void SetZoomOption ( int option );

	void SetInputType ( InputType inputType )
		{ inputType_ = inputType; }

	bool IsInput()
		{ return ( inputType_ != NOINPUT ); }

	bool IsPoint()
		{ return ( ( cursorType_ == POINTCURSOR ) && 
			   ( inputType_  == POINTINPUT ) ); }

	bool IsToolPlusPoint()
		{ return ( ( cursorType_ == TOOLPLUSPOINTCURSOR ) && 
			   ( inputType_  == POINTINPUT ) ); }

	bool IsToolPlusArea()
		{ return ( ( cursorType_ == TOOLPLUSAREACURSOR ) && 
			   ( inputType_  == AREAINPUT ) ); }
	bool IsLine()
		{ return ( ( cursorType_ == POINTERCURSOR ) && 
			   ( inputType_  == LINEINPUT ) ); }

	bool IsArea()
		{ return ( ( cursorType_ == POINTERCURSOR ) && 
			   ( inputType_  == AREAINPUT ) ); }

	bool IsMap()
		{ return ( ( cursorType_ == POINTERCURSOR ) && 
			   ( inputType_  == MAPINPUT ) ); }

	void SetCursorType ( CursorType cursorType )
		{ cursorType_ = cursorType; }

	bool IsPointerCursor()
		{ return ( cursorType_ == POINTERCURSOR ); }

	bool IsMagnify()
		{ return ( cursorType_ == MAGNIFYCURSOR ); }

	bool IsZoom()
		{ return ( cursorType_ == ZOOMCURSOR ); }

	bool IsScroll()
		{ return ( cursorType_ == SCROLLCURSOR ); }

	bool ZoomInNewWindow()
		{ return ( cursorType_ == MAGNIFYCURSOR ); }

	bool KeepAspectRatio()
		{ return keepAspectRatio_; }

	void SetAspectRatioConstraint ( bool option )
		{ keepAspectRatio_ = option; } 

	void EditPrinterPreferences( bool printJob = false );

	void SavePrinterPreferences(MvRequest& );

	MvRequest ReadPinterPreferences();

	void EditInterfacePreferences();

	void SaveInterfacePreferences( MvRequest& );

	MvRequest ReadInterfacePreferences();

	void EditMapPreferences();

	void SaveMapPreferences( MvRequest& );

	void EditCoastPreferences();

	void SaveCoastPreferences( MvRequest& );
#endif

private:
    // No assignment allowed
    Preferences& operator=(const Preferences&) { return *this; }

    // Members
    //	CursorType         cursorType_;
    //	InputType          inputType_;
    //	bool               keepAspectRatio_;
    //	bool               printJob_;
    Presentable* owner_;
};

#endif
