/*
 * Copyright 2015 MiLaboratory.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.milaboratory.core.io.sequence;

import cc.redberry.pipe.OutputPort;

/**
 * If this reader has some system resources associated with it (like opened file or network streams) implement
 * {@link cc.redberry.pipe.OutputPortCloseable} interface along with this interface.
 *
 * @author Dmitry Bolotin
 * @author Stanislav Poslavsky
 */
public interface SequenceReader<S extends SequenceRead> extends OutputPort<S> {
    /**
     * For sequential readers returns the number of reads read till this moment, after reader is exhausted returns total
     * number of reads. For random access readers returns total number of reads.
     *
     * <p>This method is thread-safe.</p>
     *
     * @return number of reads read till this moment for sequential readers and total number of reads for random access
     * readers
     */
    long getNumberOfReads();
}
