// Code generated by gocc; DO NOT EDIT.

package lexer

import (
	"io/ioutil"
	"unicode/utf8"

	"miller/parsing/token"
)

const (
	NoState    = -1
	NumStates  = 295
	NumSymbols = 467
)

type Lexer struct {
	src    []byte
	pos    int
	line   int
	column int
}

func NewLexer(src []byte) *Lexer {
	lexer := &Lexer{
		src:    src,
		pos:    0,
		line:   1,
		column: 1,
	}
	return lexer
}

func NewLexerFile(fpath string) (*Lexer, error) {
	src, err := ioutil.ReadFile(fpath)
	if err != nil {
		return nil, err
	}
	return NewLexer(src), nil
}

func (l *Lexer) Scan() (tok *token.Token) {
	tok = new(token.Token)
	if l.pos >= len(l.src) {
		tok.Type = token.EOF
		tok.Pos.Offset, tok.Pos.Line, tok.Pos.Column = l.pos, l.line, l.column
		return
	}
	start, startLine, startColumn, end := l.pos, l.line, l.column, 0
	tok.Type = token.INVALID
	state, rune1, size := 0, rune(-1), 0
	for state != -1 {
		if l.pos >= len(l.src) {
			rune1 = -1
		} else {
			rune1, size = utf8.DecodeRune(l.src[l.pos:])
			l.pos += size
		}

		nextState := -1
		if rune1 != -1 {
			nextState = TransTab[state](rune1)
		}
		state = nextState

		if state != -1 {

			switch rune1 {
			case '\n':
				l.line++
				l.column = 1
			case '\r':
				l.column = 1
			case '\t':
				l.column += 4
			default:
				l.column++
			}

			switch {
			case ActTab[state].Accept != -1:
				tok.Type = ActTab[state].Accept
				end = l.pos
			case ActTab[state].Ignore != "":
				start, startLine, startColumn = l.pos, l.line, l.column
				state = 0
				if start >= len(l.src) {
					tok.Type = token.EOF
				}

			}
		} else {
			if tok.Type == token.INVALID {
				end = l.pos
			}
		}
	}
	if end > start {
		l.pos = end
		tok.Lit = l.src[start:end]
	} else {
		tok.Lit = []byte{}
	}
	tok.Pos.Offset, tok.Pos.Line, tok.Pos.Column = start, startLine, startColumn

	return
}

func (l *Lexer) Reset() {
	l.pos = 0
}

/*
Lexer symbols:
0: '"'
1: '"'
2: '0'
3: 'x'
4: '0'
5: 'b'
6: '.'
7: '.'
8: '-'
9: '.'
10: '.'
11: '-'
12: '.'
13: '.'
14: '-'
15: 'M'
16: '_'
17: 'P'
18: 'I'
19: 'M'
20: '_'
21: 'E'
22: 'I'
23: 'P'
24: 'S'
25: 'I'
26: 'F'
27: 'S'
28: 'I'
29: 'R'
30: 'S'
31: 'O'
32: 'P'
33: 'S'
34: 'O'
35: 'F'
36: 'S'
37: 'O'
38: 'R'
39: 'S'
40: 'N'
41: 'F'
42: 'N'
43: 'R'
44: 'F'
45: 'N'
46: 'R'
47: 'F'
48: 'I'
49: 'L'
50: 'E'
51: 'N'
52: 'A'
53: 'M'
54: 'E'
55: 'F'
56: 'I'
57: 'L'
58: 'E'
59: 'N'
60: 'U'
61: 'M'
62: 'E'
63: 'N'
64: 'V'
65: 'b'
66: 'e'
67: 'g'
68: 'i'
69: 'n'
70: 'd'
71: 'o'
72: 'd'
73: 'u'
74: 'm'
75: 'p'
76: 'e'
77: 'd'
78: 'u'
79: 'm'
80: 'p'
81: 'e'
82: 'l'
83: 'i'
84: 'f'
85: 'e'
86: 'l'
87: 's'
88: 'e'
89: 'e'
90: 'm'
91: 'i'
92: 't'
93: 'e'
94: 'n'
95: 'd'
96: 'f'
97: 'i'
98: 'l'
99: 't'
100: 'e'
101: 'r'
102: 'f'
103: 'o'
104: 'r'
105: 'i'
106: 'f'
107: 'i'
108: 'n'
109: 'w'
110: 'h'
111: 'i'
112: 'l'
113: 'e'
114: 'b'
115: 'r'
116: 'e'
117: 'a'
118: 'k'
119: 'c'
120: 'o'
121: 'n'
122: 't'
123: 'i'
124: 'n'
125: 'u'
126: 'e'
127: 'r'
128: 'e'
129: 't'
130: 'u'
131: 'r'
132: 'n'
133: 'f'
134: 'u'
135: 'n'
136: 'c'
137: 's'
138: 'u'
139: 'b'
140: 'r'
141: 'c'
142: 'a'
143: 'l'
144: 'l'
145: 'a'
146: 'r'
147: 'r'
148: 'b'
149: 'o'
150: 'o'
151: 'l'
152: 'f'
153: 'l'
154: 'o'
155: 'a'
156: 't'
157: 'i'
158: 'n'
159: 't'
160: 'm'
161: 'a'
162: 'p'
163: 'n'
164: 'u'
165: 'm'
166: 's'
167: 't'
168: 'r'
169: 'v'
170: 'a'
171: 'r'
172: 'u'
173: 'n'
174: 's'
175: 'e'
176: 't'
177: 'p'
178: 'r'
179: 'i'
180: 'n'
181: 't'
182: 'p'
183: 'r'
184: 'i'
185: 'n'
186: 't'
187: 'n'
188: 'e'
189: 'p'
190: 'r'
191: 'i'
192: 'n'
193: 't'
194: 'e'
195: 'p'
196: 'r'
197: 'i'
198: 'n'
199: 't'
200: 'n'
201: '$'
202: '$'
203: '{'
204: '}'
205: '$'
206: '*'
207: '@'
208: '@'
209: '{'
210: '}'
211: '@'
212: '*'
213: '%'
214: '%'
215: '%'
216: 'p'
217: 'a'
218: 'n'
219: 'i'
220: 'c'
221: '%'
222: '%'
223: '%'
224: ';'
225: '{'
226: '}'
227: '='
228: '$'
229: '['
230: ']'
231: '$'
232: '['
233: '['
234: ']'
235: ']'
236: '$'
237: '['
238: '['
239: '['
240: ']'
241: ']'
242: ']'
243: '@'
244: '['
245: '|'
246: '|'
247: '='
248: '^'
249: '^'
250: '='
251: '&'
252: '&'
253: '='
254: '?'
255: '?'
256: '='
257: '?'
258: '?'
259: '?'
260: '='
261: '|'
262: '='
263: '&'
264: '='
265: '^'
266: '='
267: '<'
268: '<'
269: '='
270: '>'
271: '>'
272: '='
273: '>'
274: '>'
275: '>'
276: '='
277: '+'
278: '='
279: '.'
280: '='
281: '-'
282: '='
283: '*'
284: '='
285: '/'
286: '='
287: '/'
288: '/'
289: '='
290: '%'
291: '='
292: '*'
293: '*'
294: '='
295: '?'
296: ':'
297: '|'
298: '|'
299: '^'
300: '^'
301: '&'
302: '&'
303: '?'
304: '?'
305: '?'
306: '?'
307: '?'
308: '='
309: '~'
310: '!'
311: '='
312: '~'
313: '='
314: '='
315: '!'
316: '='
317: '>'
318: '>'
319: '='
320: '<'
321: '<'
322: '='
323: '|'
324: '^'
325: '&'
326: '<'
327: '<'
328: '>'
329: '>'
330: '>'
331: '>'
332: '>'
333: '+'
334: '-'
335: '.'
336: '+'
337: '.'
338: '-'
339: '.'
340: '*'
341: '/'
342: '/'
343: '/'
344: '%'
345: '.'
346: '*'
347: '.'
348: '/'
349: '.'
350: '/'
351: '/'
352: '!'
353: '~'
354: '*'
355: '*'
356: '('
357: ')'
358: '['
359: ','
360: '['
361: '['
362: '['
363: '['
364: '['
365: '_'
366: ' '
367: '!'
368: '#'
369: '$'
370: '%'
371: '&'
372: '''
373: '\'
374: '('
375: ')'
376: '*'
377: '+'
378: ','
379: '-'
380: '.'
381: '/'
382: ':'
383: ';'
384: '<'
385: '='
386: '>'
387: '?'
388: '@'
389: '['
390: ']'
391: '^'
392: '_'
393: '`'
394: '{'
395: '|'
396: '}'
397: '~'
398: '\'
399: '"'
400: 'e'
401: 'E'
402: 't'
403: 'r'
404: 'u'
405: 'e'
406: 'f'
407: 'a'
408: 'l'
409: 's'
410: 'e'
411: ' '
412: '!'
413: '#'
414: '$'
415: '%'
416: '&'
417: '''
418: '\'
419: '('
420: ')'
421: '*'
422: '+'
423: ','
424: '-'
425: '.'
426: '/'
427: ':'
428: ';'
429: '<'
430: '='
431: '>'
432: '?'
433: '@'
434: '['
435: ']'
436: '^'
437: '_'
438: '`'
439: '|'
440: '~'
441: '\'
442: '{'
443: '\'
444: '}'
445: ' '
446: '\t'
447: '\n'
448: '\r'
449: '#'
450: '\n'
451: 'a'-'z'
452: 'A'-'Z'
453: '0'-'9'
454: '0'-'9'
455: 'a'-'f'
456: 'A'-'F'
457: '0'-'1'
458: 'A'-'Z'
459: 'a'-'z'
460: '0'-'9'
461: \u0100-\U0010ffff
462: 'A'-'Z'
463: 'a'-'z'
464: '0'-'9'
465: \u0100-\U0010ffff
466: .
*/
