/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zgrviewer;

import com.xerox.VTM.engine.SwingWorker;
import com.xerox.VTM.engine.View;
import com.xerox.VTM.svg.SVGReader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.claribole.zgrviewer.AppletUtils;
import net.claribole.zgrviewer.ConfigManager;
import net.claribole.zgrviewer.GVLoader;
import net.claribole.zgrviewer.GraphicsManager;
import net.claribole.zgrviewer.NavPanel;
import net.claribole.zgrviewer.ZGRAGlassPane;
import net.claribole.zgrviewer.ZGRApplication;
import net.claribole.zgrviewer.ZgrAppletEvtHdlr;
import net.claribole.zvtm.engine.RepaintListener;

public class ZGRApplet
extends JApplet
implements MouseListener,
KeyListener,
ZGRApplication,
RepaintListener {
    static final int DEFAULT_VIEW_WIDTH = 640;
    static final int DEFAULT_VIEW_HEIGHT = 480;
    static final String APPLET_WIDTH_PARAM = "width";
    static final String APPLET_HEIGHT_PARAM = "height";
    static final String SVG_FILE_URL_PARAM = "svgURL";
    static final String SHOW_NAVIGATION_CONTROLS_PARAM = "showNavControls";
    static final String SHOW_FC_PALETTE_PARAM = "showFCPalette";
    static final String APPLET_TITLE_PARAM = "title";
    static final String APPLET_BKG_COLOR_PARAM = "appletBackgroundColor";
    static final String GRAPH_BKG_COLOR_PARAM = "graphBackgroundColor";
    static final String HIGHLIGHT_COLOR_PARAM = "highlightColor";
    static final String CURSOR_COLOR_PARAM = "cursorColor";
    static final String CENTER_ON_LABEL_PARAM = "centerOnLabel";
    static final String ANTIALIASING_PARAM = "antialiased";
    static final String DISPLAY_OVERVIEW_PARAM = "displayOverview";
    static final String HTTP_PROTOCOL = "http://";
    static final String HTTPS_PROTOCOL = "https://";
    static final String FTP_PROTOCOL = "ftp:/";
    static final String FILE_PROTOCOL = "file:/";
    static final String JAVASCRIPT_PROTOCOL = "javascript:";
    static final String HREF_TARGET_PARAM = "target";
    String APPLET_TITLE = "ZGRViewer - Applet";
    static ConfigManager cfgMngr;
    public GVLoader gvLdr;
    public GraphicsManager grMngr;
    ZgrAppletEvtHdlr meh;
    JPanel viewPanel;
    NavPanel navPanel;
    JLabel statusBar;
    int appletWindowWidth = 640;
    int appletWindowHeight = 480;
    ZGRAGlassPane gp;
    boolean paintedAtLeastOnce = false;

    public ZGRApplet() {
        this.getRootPane().putClientProperty("defeatSystemEventQueueCheck", Boolean.TRUE);
    }

    public void init() {
        this.initConfig();
        this.initGUI();
    }

    void initConfig() {
        this.grMngr = new GraphicsManager(this);
        cfgMngr = new ConfigManager(this.grMngr, true);
        this.grMngr.setConfigManager(cfgMngr);
        this.gvLdr = new GVLoader(this, this.grMngr, cfgMngr, null);
    }

    void initGUI() {
        String s;
        this.addKeyListener(this);
        this.addMouseListener(this);
        try {
            this.appletWindowWidth = Integer.parseInt(this.getParameter(APPLET_WIDTH_PARAM));
        }
        catch (NumberFormatException ex) {
            this.appletWindowWidth = 640;
        }
        try {
            this.appletWindowHeight = Integer.parseInt(this.getParameter(APPLET_HEIGHT_PARAM));
        }
        catch (NumberFormatException ex) {
            this.appletWindowHeight = 480;
        }
        boolean showNavControl = true;
        try {
            String s2 = this.getParameter(SHOW_NAVIGATION_CONTROLS_PARAM);
            if (s2 != null) {
                showNavControl = new Boolean(s2);
            }
        }
        catch (Exception ex) {
            showNavControl = true;
        }
        boolean showFCPalette = true;
        try {
            String s3 = this.getParameter(SHOW_FC_PALETTE_PARAM);
            if (s3 != null) {
                showFCPalette = new Boolean(s3);
            }
        }
        catch (Exception ex) {
            showFCPalette = true;
        }
        boolean showOverview = true;
        try {
            String s4 = this.getParameter(DISPLAY_OVERVIEW_PARAM);
            if (s4 != null) {
                showOverview = new Boolean(s4);
            }
        }
        catch (Exception ex) {
            showOverview = true;
        }
        try {
            this.APPLET_TITLE = this.getParameter(APPLET_TITLE_PARAM);
        }
        catch (Exception ex) {
            this.APPLET_TITLE = "ZGRViewer - Applet";
        }
        Color APPLET_BKG_COLOR = null;
        try {
            APPLET_BKG_COLOR = SVGReader.getColor(this.getParameter(APPLET_BKG_COLOR_PARAM));
        }
        catch (Exception ex) {
            // empty catch block
        }
        Color CURSOR_COLOR = null;
        try {
            CURSOR_COLOR = SVGReader.getColor(this.getParameter(CURSOR_COLOR_PARAM));
        }
        catch (Exception ex) {
            // empty catch block
        }
        boolean graphBkgColorSpecified = false;
        try {
            ZGRApplet.cfgMngr.backgroundColor = SVGReader.getColor(this.getParameter(GRAPH_BKG_COLOR_PARAM));
            graphBkgColorSpecified = true;
        }
        catch (Exception ex) {
            ZGRApplet.cfgMngr.backgroundColor = Color.WHITE;
            graphBkgColorSpecified = false;
        }
        final boolean graphBkgColorSpecifiedF = graphBkgColorSpecified;
        String centerOnLabel = null;
        try {
            centerOnLabel = this.getParameter(CENTER_ON_LABEL_PARAM);
        }
        catch (Exception ex) {
            centerOnLabel = null;
        }
        final String centerOnLabelF = centerOnLabel;
        boolean antialiased = true;
        try {
            s = this.getParameter(ANTIALIASING_PARAM);
            if (s != null) {
                antialiased = new Boolean(s);
            }
        }
        catch (Exception ex) {
            antialiased = true;
        }
        try {
            s = this.getParameter(HIGHLIGHT_COLOR_PARAM);
            if (s != null) {
                ConfigManager.HIGHLIGHT_COLOR = SVGReader.getColor(s);
            }
        }
        catch (Exception ex) {
            ConfigManager.HIGHLIGHT_COLOR = Color.RED;
        }
        AppletUtils.initLookAndFeel();
        Container cpane = this.getContentPane();
        this.setSize(this.appletWindowWidth - 10, this.appletWindowHeight - 10);
        cpane.setSize(this.appletWindowWidth, this.appletWindowHeight);
        cpane.setBackground(APPLET_BKG_COLOR);
        this.viewPanel = this.grMngr.createPanelView(this.grMngr.createZVTMelements(true), this.appletWindowWidth, this.appletWindowHeight - 40);
        this.meh = new ZgrAppletEvtHdlr(this, this.grMngr);
        this.grMngr.parameterizeView(this.meh);
        this.viewPanel.setPreferredSize(new Dimension(this.appletWindowWidth - 10, this.appletWindowHeight - 40));
        this.grMngr.mainView.setAntialiasing(antialiased);
        this.statusBar = new JLabel("");
        JPanel borderPanel = new JPanel();
        borderPanel.setLayout(new BorderLayout());
        borderPanel.add((Component)this.viewPanel, "Center");
        borderPanel.add((Component)this.statusBar, "South");
        borderPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black, 1), this.APPLET_TITLE));
        borderPanel.setOpaque(false);
        if (showNavControl || showOverview) {
            GridBagLayout gridBag = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.fill = 1;
            constraints.anchor = 10;
            cpane.setLayout(gridBag);
            ZGRApplet.buildConstraints(constraints, 0, 0, 1, 1, 90, 100);
            gridBag.setConstraints(borderPanel, constraints);
            cpane.add(borderPanel);
            this.navPanel = new NavPanel(this.grMngr, centerOnLabelF, showOverview);
            ZGRApplet.buildConstraints(constraints, 1, 0, 1, 1, 10, 0);
            gridBag.setConstraints(this.navPanel, constraints);
            cpane.add(this.navPanel);
        } else {
            cpane.add(borderPanel);
        }
        if (CURSOR_COLOR != null) {
            this.grMngr.mainView.mouse.setColor(CURSOR_COLOR);
            this.grMngr.mainView.mouse.setHintColor(CURSOR_COLOR);
        }
        this.grMngr.tp.setEnabled(showFCPalette);
        this.gp = new ZGRAGlassPane(this.appletWindowWidth, this.appletWindowHeight);
        this.setGlassPane(this.gp);
        this.gp.setVisible(true);
        this.gp.setMessage("Loading Graphviz/SVG...");
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                this.sleep(1000);
                ZGRApplet.this.requestFocus();
                ZGRApplet.this.grMngr.vsm.repaintNow();
                URL svgUrl = null;
                try {
                    svgUrl = new URL(ZGRApplet.this.getDocumentBase(), ZGRApplet.this.getParameter(ZGRApplet.SVG_FILE_URL_PARAM));
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                ZGRApplet.this.gvLdr.loadSVG(svgUrl.toString());
                if (graphBkgColorSpecifiedF) {
                    ZGRApplet.this.grMngr.mainView.setBackgroundColor(ZGRApplet.cfgMngr.backgroundColor);
                }
                ZGRApplet.this.grMngr.tp.updateHiddenPosition();
                ZGRApplet.this.grMngr.vsm.repaintNow(ZGRApplet.this.grMngr.mainView, ZGRApplet.this);
                while (!ZGRApplet.this.paintedAtLeastOnce) {
                    this.sleep(500);
                }
                if (centerOnLabelF != null) {
                    ZGRApplet.this.grMngr.search(centerOnLabelF, 1);
                }
                ZGRApplet.this.grMngr.vsm.repaintNow();
                ZGRApplet.this.gp.setVisible(false);
                return null;
            }

            public void finished() {
                ZGRApplet.this.setStatusBarText(" ");
            }
        };
        worker.start();
    }

    public void viewRepainted(View v) {
        this.paintedAtLeastOnce = true;
        v.removeRepaintListener();
    }

    public void setStatusBarText(String s) {
        this.statusBar.setText(s);
    }

    void displayURLinBrowser(String uri) {
        String target = this.getParameter(HREF_TARGET_PARAM);
        if (uri.startsWith(JAVASCRIPT_PROTOCOL)) {
            target = "_self";
        }
        if (target == null) {
            target = "_blank";
        }
        try {
            URL displayUrl = !uri.startsWith(JAVASCRIPT_PROTOCOL) && !uri.startsWith(HTTP_PROTOCOL) && !uri.startsWith(HTTPS_PROTOCOL) && !uri.startsWith(FTP_PROTOCOL) && !uri.startsWith(FILE_PROTOCOL) ? new URL(this.getDocumentBase(), uri) : new URL(uri);
            this.getAppletContext().showDocument(displayUrl, target);
        }
        catch (MalformedURLException ex) {
            System.out.println("Error: could not load " + uri);
        }
    }

    public void about() {
        JOptionPane.showMessageDialog(this, "ZGRViewer 0.8.2\n\nA Visualization Tool for GraphViz based on ZVTM\nhttp://zvtm.sourceforge.net/zgrviewer.html\n\nWritten by Emmanuel Pietriga\n(INRIA project In Situ)\nemmanuel.pietriga@inria.fr");
    }

    public void keyPressed(KeyEvent e) {
        int code = e.getKeyCode();
        char c = e.getKeyChar();
        if (code == 33) {
            this.grMngr.getHigherView();
        } else if (code == 34) {
            this.grMngr.getLowerView();
        } else if (code == 36) {
            this.grMngr.getGlobalView();
        } else if (code == 38) {
            this.grMngr.translateView((short)1);
        } else if (code == 40) {
            this.grMngr.translateView((short)0);
        } else if (code == 37) {
            this.grMngr.translateView((short)3);
        } else if (code == 39) {
            this.grMngr.translateView((short)2);
        } else if (c == '+') {
            if (this.grMngr.lensType != 0 && this.grMngr.lens != null) {
                this.grMngr.magnifyFocus(1.0, this.grMngr.lensType, this.grMngr.mainCamera);
            } else if (this.meh.inZoomWindow) {
                this.meh.tfactor = (this.grMngr.dmCamera.focal + Math.abs(this.grMngr.dmCamera.altitude)) / this.grMngr.dmCamera.focal;
                this.grMngr.dmCamera.altitudeOffset(-this.meh.tfactor * 21.0f);
                this.grMngr.updateMagWindow();
                this.grMngr.vsm.repaintNow();
            } else {
                this.meh.tfactor = (this.grMngr.mainCamera.focal + Math.abs(this.grMngr.mainCamera.altitude)) / this.grMngr.mainCamera.focal;
                this.grMngr.mainCamera.altitudeOffset(-this.meh.tfactor * 21.0f);
                this.grMngr.cameraMoved();
            }
        } else if (c == '-') {
            if (this.grMngr.lensType != 0 && this.grMngr.lens != null) {
                this.grMngr.magnifyFocus(-1.0, this.grMngr.lensType, this.grMngr.mainCamera);
            } else if (this.meh.inZoomWindow) {
                this.meh.tfactor = (this.grMngr.dmCamera.focal + Math.abs(this.grMngr.dmCamera.altitude)) / this.grMngr.dmCamera.focal;
                this.grMngr.dmCamera.altitudeOffset(this.meh.tfactor * 22.0f);
                this.grMngr.updateMagWindow();
                this.grMngr.vsm.repaintNow();
            } else {
                this.meh.tfactor = (this.grMngr.mainCamera.focal + Math.abs(this.grMngr.mainCamera.altitude)) / this.grMngr.mainCamera.focal;
                this.grMngr.mainCamera.altitudeOffset(this.meh.tfactor * 22.0f);
                this.grMngr.cameraMoved();
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        this.requestFocus();
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    static void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }
}

