/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.engine;

import com.xerox.VTM.engine.AnimParams;
import com.xerox.VTM.engine.CAnimation;
import com.xerox.VTM.engine.CTransZoom;
import com.xerox.VTM.engine.CTranslation;
import com.xerox.VTM.engine.CZoom;
import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.DPTransformation;
import com.xerox.VTM.engine.GAnimation;
import com.xerox.VTM.engine.GCbCurveCtrl;
import com.xerox.VTM.engine.GColoration;
import com.xerox.VTM.engine.GColorationPRR;
import com.xerox.VTM.engine.GCurveCtrl;
import com.xerox.VTM.engine.GQdCurveCtrl;
import com.xerox.VTM.engine.GResize;
import com.xerox.VTM.engine.GResizePRR;
import com.xerox.VTM.engine.GRotate;
import com.xerox.VTM.engine.GRotatePRR;
import com.xerox.VTM.engine.GTranslation;
import com.xerox.VTM.engine.GTranslationPRR;
import com.xerox.VTM.engine.LongPoint;
import com.xerox.VTM.engine.PolarCoords;
import com.xerox.VTM.engine.VirtualSpaceManager;
import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.glyphs.Translucent;
import com.xerox.VTM.glyphs.VCbCurve;
import com.xerox.VTM.glyphs.VQdCurve;
import java.awt.Point;
import java.util.Hashtable;
import java.util.Vector;
import net.claribole.zvtm.engine.AnimationListener;
import net.claribole.zvtm.engine.LensKillAction;
import net.claribole.zvtm.engine.PAnimation;
import net.claribole.zvtm.engine.PResize;
import net.claribole.zvtm.engine.PTransResize;
import net.claribole.zvtm.engine.PTranslation;
import net.claribole.zvtm.engine.PTranslucency;
import net.claribole.zvtm.engine.Portal;
import net.claribole.zvtm.engine.PostAnimationAction;
import net.claribole.zvtm.glyphs.DPath;
import net.claribole.zvtm.lens.FSLMaxMagRadii;
import net.claribole.zvtm.lens.FSLRadii;
import net.claribole.zvtm.lens.FixedSizeLens;
import net.claribole.zvtm.lens.LAnimation;
import net.claribole.zvtm.lens.LMaximumMagnification;
import net.claribole.zvtm.lens.LMetrics;
import net.claribole.zvtm.lens.LPDistanceMetrics;
import net.claribole.zvtm.lens.Lens;

public class AnimManager
implements Runnable {
    public static final short GL_TRANS_LIN = 0;
    public static final short GL_TRANS_PAR = 1;
    public static final short GL_TRANS_SIG = 2;
    public static final short GL_SZ_LIN = 3;
    public static final short GL_SZ_PAR = 4;
    public static final short GL_SZ_SIG = 5;
    public static final short GL_ROT_LIN = 6;
    public static final short GL_ROT_PAR = 7;
    public static final short GL_ROT_SIG = 8;
    public static final short GL_COLOR_LIN = 9;
    public static final short DP_TRANS_LIN = 0;
    public static final short DP_TRANS_PAR = 1;
    public static final short DP_TRANS_SIG = 2;
    public static final short DP_TRANS_LIN_ABS = 3;
    public static final short DP_TRANS_PAR_ABS = 4;
    public static final short DP_TRANS_SIG_ABS = 5;
    public static final short GL_CP_TRANS_LIN = 0;
    public static final short GL_CP_TRANS_PAR = 1;
    public static final short GL_CP_TRANS_SIG = 2;
    public static final short LS_RD_LIN = 0;
    public static final short LS_RD_PAR = 1;
    public static final short LS_RD_SIG = 2;
    public static final short LS_MM_LIN = 3;
    public static final short LS_MM_PAR = 4;
    public static final short LS_MM_SIG = 5;
    public static final short LS_MM_RD_LIN = 6;
    public static final short LS_MM_RD_PAR = 7;
    public static final short LS_MM_RD_SIG = 8;
    public static final short LS_LP_LIN = 9;
    public static final short LS_LP_PAR = 10;
    public static final short LS_LP_SIG = 11;
    public static final short CA_TRANS_LIN = 0;
    public static final short CA_TRANS_PAR = 1;
    public static final short CA_TRANS_SIG = 2;
    public static final short CA_ALT_LIN = 3;
    public static final short CA_ALT_PAR = 4;
    public static final short CA_ALT_SIG = 5;
    public static final short CA_ALT_TRANS_SIG = 6;
    public static final short CA_ALT_TRANS_LIN = 7;
    public static final short PT_TRANS_LIN = 0;
    public static final short PT_TRANS_PAR = 1;
    public static final short PT_TRANS_SIG = 2;
    public static final short PT_SZ_LIN = 3;
    public static final short PT_SZ_PAR = 4;
    public static final short PT_SZ_SIG = 5;
    public static final short PT_SZ_TRANS_SIG = 6;
    public static final short PT_SZ_TRANS_LIN = 7;
    public static final short PT_ALPHA_LIN = 8;
    public static final String GL_TRANS = "pos";
    public static final String GL_SZ = "sz";
    public static final String GL_ROT = "or";
    public static final String GL_COLOR = "col";
    public static final String GL_CTRL = "ctrl";
    public static final String CA_TRANS = "pos";
    public static final String CA_ALT = "sz";
    public static final String CA_BOTH = "both";
    public static final String PT_TRANS = "pos";
    public static final String PT_SZ = "sz";
    public static final String PT_BOTH = "both";
    public static final String PT_ALPHA = "alpha";
    public static final String LS_MM = "mm";
    public static final String LS_RD = "rd";
    public static final String LS_BOTH = "both";
    public static final String LS_LP = "lp";
    VirtualSpaceManager vsm;
    Thread runAnim;
    boolean started = false;
    static int frameTime = 20;
    protected boolean[] repaintViews;
    protected boolean repaintAll = false;
    public static final int sigFactor = 4;
    Vector animCameraBag;
    Vector animGlyphBag;
    Vector animLensBag;
    Vector animPortalBag;
    Hashtable pendingGAnims;
    Hashtable pendingCAnims;
    Hashtable pendingLAnims;
    Hashtable pendingPAnims;
    Hashtable animatedGlyphs;
    Hashtable animatedCameras;
    Hashtable animatedLenses;
    Hashtable animatedPortals;
    AnimationListener animListener = null;
    private boolean notifyCameraAnim = false;
    private boolean cameraTranslated = false;
    public double Xspeed;
    public double Yspeed;
    public float Aspeed;
    Camera activeCam;
    CAnimation vcan;
    LAnimation vlan;
    PAnimation vpan;
    int vi;

    AnimManager(VirtualSpaceManager parentVSM) {
        this.vsm = parentVSM;
        this.repaintViews = new boolean[0];
        this.animCameraBag = new Vector();
        this.animPortalBag = new Vector();
        this.animGlyphBag = new Vector();
        this.animLensBag = new Vector();
        this.pendingGAnims = new Hashtable();
        this.pendingCAnims = new Hashtable();
        this.pendingPAnims = new Hashtable();
        this.pendingLAnims = new Hashtable();
        this.animatedGlyphs = new Hashtable();
        this.animatedCameras = new Hashtable();
        this.animatedPortals = new Hashtable();
        this.animatedLenses = new Hashtable();
        this.Xspeed = 0.0;
        this.Yspeed = 0.0;
        this.Aspeed = 0.0f;
    }

    public void start() {
        this.started = true;
        this.runAnim = new Thread(this);
        this.runAnim.setPriority(5);
        this.runAnim.start();
    }

    public synchronized void stop() {
        this.started = false;
        this.runAnim = null;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread me = Thread.currentThread();
        while (this.vsm.activeView == null) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                if (VirtualSpaceManager.debug) {
                    System.err.println("animmanager.run.sleep0 " + e);
                }
                return;
            }
        }
        while (this.runAnim == me) {
            int i;
            block32: {
                try {
                    this.activeCam = this.vsm.getActiveCamera();
                    if (this.Xspeed != 0.0) {
                        this.activeCam.dposx -= this.Xspeed;
                        this.activeCam.posx = Math.round(this.activeCam.dposx);
                        this.repaintViews[this.vsm.activeViewIndex] = true;
                        this.cameraTranslated = true;
                        this.notifyCameraAnim = true;
                    }
                    if (this.Yspeed != 0.0) {
                        this.activeCam.dposy -= this.Yspeed;
                        this.activeCam.posy = Math.round(this.activeCam.dposy);
                        this.repaintViews[this.vsm.activeViewIndex] = true;
                        this.cameraTranslated = true;
                        this.notifyCameraAnim = true;
                    }
                    if (this.cameraTranslated) {
                        this.activeCam.propagateMove(-this.Xspeed, -this.Yspeed);
                    }
                    if (this.Aspeed != 0.0f) {
                        this.activeCam.altitudeOffset(-this.Aspeed);
                        this.repaintViews[this.vsm.activeViewIndex] = true;
                        this.notifyCameraAnim = true;
                    }
                }
                catch (NullPointerException e) {
                    if (!VirtualSpaceManager.debug) break block32;
                    System.err.println("animmanager.run.activecam " + e);
                }
            }
            for (i = 0; i < this.animCameraBag.size(); ++i) {
                try {
                    this.vcan = (CAnimation)this.animCameraBag.get(i);
                    this.vcan.animate();
                    this.vi = this.vsm.getViewIndex(this.vcan.target.getOwningView().getName());
                    if (this.vi != -1) {
                        this.repaintViews[this.vi] = true;
                    }
                    this.notifyCameraAnim = true;
                    continue;
                }
                catch (NullPointerException e) {
                    if (!VirtualSpaceManager.debug) continue;
                    System.err.println("animmanager.run.camera anim stopped " + e);
                }
            }
            for (i = 0; i < this.animLensBag.size(); ++i) {
                this.vlan = (LAnimation)this.animLensBag.get(i);
                this.vlan.animate();
                this.vi = this.vsm.getViewIndex(this.vlan.target.getOwningView().getName());
                if (this.vi == -1) continue;
                this.repaintViews[this.vi] = true;
            }
            for (i = 0; i < this.animPortalBag.size(); ++i) {
                try {
                    this.vpan = (PAnimation)this.animPortalBag.get(i);
                    this.vpan.animate();
                    this.vi = this.vsm.getViewIndex(this.vpan.target.getOwningView().getName());
                    if (this.vi == -1) continue;
                    this.repaintViews[this.vi] = true;
                    continue;
                }
                catch (NullPointerException e) {
                    if (!VirtualSpaceManager.debug) continue;
                    System.err.println("animmanager.run.camera anim stopped " + e);
                }
            }
            for (i = 0; i < this.animGlyphBag.size(); ++i) {
                try {
                    if (!((GAnimation)this.animGlyphBag.get(i)).animate()) continue;
                    this.repaintAll = true;
                    continue;
                }
                catch (NullPointerException e) {
                    if (!VirtualSpaceManager.debug) continue;
                    System.err.println("animmanager.run.glyph anim stopped " + e);
                    e.printStackTrace();
                }
            }
            if (this.repaintAll) {
                this.vsm.repaintNow();
                this.repaintAll = false;
            } else {
                for (i = 0; i < this.repaintViews.length; ++i) {
                    if (!this.repaintViews[i]) continue;
                    this.vsm.repaintNow(i);
                    this.repaintViews[i] = false;
                }
            }
            if (this.animListener != null && this.notifyCameraAnim) {
                AnimManager i2 = this;
                synchronized (i2) {
                    this.animListener.cameraMoved();
                    this.notifyCameraAnim = false;
                }
            }
            try {
                Thread.sleep(frameTime);
            }
            catch (InterruptedException e) {
                if (VirtualSpaceManager.debug) {
                    System.err.println("animmanager.run.sleep " + e);
                }
                return;
            }
        }
    }

    public void setAnimationListener(AnimationListener al) {
        this.animListener = al;
    }

    public AnimationListener getAnimationListener() {
        return this.animListener;
    }

    protected void registerView() {
        boolean[] tmpA = new boolean[this.repaintViews.length + 1];
        System.arraycopy(this.repaintViews, 0, tmpA, 0, this.repaintViews.length);
        tmpA[this.repaintViews.length] = false;
        this.repaintViews = tmpA;
    }

    protected void unregisterView(int i) {
        boolean[] tmpA = new boolean[this.repaintViews.length - 1];
        if (tmpA.length > 0) {
            System.arraycopy(this.repaintViews, 0, tmpA, 0, i);
            System.arraycopy(this.repaintViews, i + 1, tmpA, i, this.repaintViews.length - i - 1);
        }
        this.repaintViews = tmpA;
    }

    private void newGlyphAnim(long duration, short type, Object data, Long gID, int refresh, PostAnimationAction paa) throws ClassCastException {
        Glyph g = this.vsm.getGlyph(gID);
        switch (type) {
            case 0: {
                if (this.animatedGlyphs.containsKey(gID) && ((int[])this.animatedGlyphs.get(gID))[0] == 1) {
                    this.putAsPendingGAnimation(gID, "pos", duration, type, data, paa);
                    break;
                }
                if (this.animatedGlyphs.containsKey(gID)) {
                    ((int[])this.animatedGlyphs.get((Object)gID))[0] = 1;
                } else {
                    int[] tmpA = new int[]{1, 0, 0, 0};
                    this.animatedGlyphs.put(gID, tmpA);
                }
                GTranslation an = refresh == 0 ? new GTranslation(g, this, duration) : new GTranslationPRR(g, this, duration, refresh);
                an.setPostAnimationAction(paa);
                long x = g.vx;
                long y = g.vy;
                long tx = ((LongPoint)data).x;
                long ty = ((LongPoint)data).y;
                double nbSteps = Math.round(duration / (long)frameTime);
                double dx = (double)tx / nbSteps;
                double dy = (double)ty / nbSteps;
                an.steps = new LongPoint[(int)nbSteps];
                int i = 0;
                while ((double)i < nbSteps - 1.0) {
                    an.steps[i] = new LongPoint((long)((double)x + (double)i * dx), (long)((double)y + (double)i * dy));
                    ++i;
                }
                an.steps[(int)nbSteps - 1] = new LongPoint(x + tx, y + ty);
                this.animGlyphBag.add(an);
                an.start();
                break;
            }
            case 1: {
                if (this.animatedGlyphs.containsKey(gID) && ((int[])this.animatedGlyphs.get(gID))[0] == 1) {
                    this.putAsPendingGAnimation(gID, "pos", duration, type, data, paa);
                    break;
                }
                if (this.animatedGlyphs.containsKey(gID)) {
                    ((int[])this.animatedGlyphs.get((Object)gID))[0] = 1;
                } else {
                    int[] tmpA = new int[]{1, 0, 0, 0};
                    this.animatedGlyphs.put(gID, tmpA);
                }
                GTranslation an = refresh == 0 ? new GTranslation(g, this, duration) : new GTranslationPRR(g, this, duration, refresh);
                an.setPostAnimationAction(paa);
                long x = g.vx;
                long y = g.vy;
                long tx = ((LongPoint)data).x;
                long ty = ((LongPoint)data).y;
                double nbSteps = Math.round((double)(duration / (long)frameTime));
                an.steps = new LongPoint[(int)nbSteps];
                int i = 0;
                while ((double)i < nbSteps - 1.0) {
                    double stepValue = Math.pow((double)(i + 1) / nbSteps, 4.0);
                    long dx = Math.round((double)tx * stepValue);
                    long dy = Math.round((double)ty * stepValue);
                    an.steps[i++] = new LongPoint(x + dx, y + dy);
                }
                an.steps[(int)nbSteps - 1] = new LongPoint(x + tx, y + ty);
                this.animGlyphBag.add(an);
                an.start();
                break;
            }
            case 2: {
                if (this.animatedGlyphs.containsKey(gID) && ((int[])this.animatedGlyphs.get(gID))[0] == 1) {
                    this.putAsPendingGAnimation(gID, "pos", duration, type, data, paa);
                    break;
                }
                if (this.animatedGlyphs.containsKey(gID)) {
                    ((int[])this.animatedGlyphs.get((Object)gID))[0] = 1;
                } else {
                    int[] tmpA = new int[]{1, 0, 0, 0};
                    this.animatedGlyphs.put(gID, tmpA);
                }
                GTranslation an = refresh == 0 ? new GTranslation(g, this, duration) : new GTranslationPRR(g, this, duration, refresh);
                an.setPostAnimationAction(paa);
                long x = g.vx;
                long y = g.vy;
                long tx = ((LongPoint)data).x;
                long ty = ((LongPoint)data).y;
                double nbSteps = Math.round((double)(duration / (long)frameTime));
                an.steps = new LongPoint[(int)nbSteps];
                int i = 0;
                while ((double)i < nbSteps - 1.0) {
                    double stepValue = AnimManager.computeSigmoid(4, (double)(i + 1) / nbSteps);
                    long dx = Math.round((double)tx * stepValue);
                    long dy = Math.round((double)ty * stepValue);
                    an.steps[i++] = new LongPoint(x + dx, y + dy);
                }
                an.steps[(int)nbSteps - 1] = new LongPoint(x + tx, y + ty);
                this.animGlyphBag.add(an);
                an.start();
                break;
            }
            case 3: {
                if (this.animatedGlyphs.containsKey(gID) && ((int[])this.animatedGlyphs.get(gID))[1] == 1) {
                    this.putAsPendingGAnimation(gID, "sz", duration, type, data, paa);
                    break;
                }
                if (this.animatedGlyphs.containsKey(gID)) {
                    ((int[])this.animatedGlyphs.get((Object)gID))[1] = 1;
                } else {
                    int[] tmpA = new int[]{0, 1, 0, 0};
                    this.animatedGlyphs.put(gID, tmpA);
                }
                GResize an = refresh == 0 ? new GResize(g, this, duration) : new GResizePRR(g, this, duration, refresh);
                an.setPostAnimationAction(paa);
                float sz = g.getSize();
                float tsz = ((Float)data).floatValue() * sz;
                float nbSteps = Math.round(duration / (long)frameTime);
                float dsz = (tsz - sz) / nbSteps;
                an.steps = new float[(int)nbSteps];
                int i = 0;
                while ((float)i < nbSteps - 1.0f) {
                    an.steps[i] = sz + (float)i * dsz;
                    ++i;
                }
                an.steps[(int)nbSteps - 1] = tsz;
                this.animGlyphBag.add(an);
                an.start();
                break;
            }
            case 4: {
                if (this.animatedGlyphs.containsKey(gID) && ((int[])this.animatedGlyphs.get(gID))[1] == 1) {
                    this.putAsPendingGAnimation(gID, "sz", duration, type, data, paa);
                    break;
                }
                if (this.animatedGlyphs.containsKey(gID)) {
                    ((int[])this.animatedGlyphs.get((Object)gID))[1] = 1;
                } else {
                    int[] tmpA = new int[]{0, 1, 0, 0};
                    this.animatedGlyphs.put(gID, tmpA);
                }
                GResize an = refresh == 0 ? new GResize(g, this, duration) : new GResizePRR(g, this, duration, refresh);
                an.setPostAnimationAction(paa);
                float sz = g.getSize();
                float tsz = ((Float)data).floatValue() * sz;
                float nbSteps = Math.round(duration / (long)frameTime);
                an.steps = new float[(int)nbSteps];
                int i = 0;
                while ((float)i < nbSteps - 1.0f) {
                    float stepValue = (float)Math.pow((float)(i + 1) / nbSteps, 4.0);
                    float dsz = (tsz - sz) * stepValue;
                    an.steps[i] = sz + dsz;
                    ++i;
                }
                an.steps[(int)nbSteps - 1] = tsz;
                this.animGlyphBag.add(an);
                an.start();
                break;
            }
            case 5: {
                if (this.animatedGlyphs.containsKey(gID) && ((int[])this.animatedGlyphs.get(gID))[1] == 1) {
                    this.putAsPendingGAnimation(gID, "sz", duration, type, data, paa);
                    break;
                }
                if (this.animatedGlyphs.containsKey(gID)) {
                    ((int[])this.animatedGlyphs.get((Object)gID))[1] = 1;
                } else {
                    int[] tmpA = new int[]{0, 1, 0, 0};
                    this.animatedGlyphs.put(gID, tmpA);
                }
                GResize an = refresh == 0 ? new GResize(g, this, duration) : new GResizePRR(g, this, duration, refresh);
                an.setPostAnimationAction(paa);
                float sz = g.getSize();
                float tsz = ((Float)data).floatValue() * sz;
                float nbSteps = Math.round(duration / (long)frameTime);
                an.steps = new float[(int)nbSteps];
                int i = 0;
                while ((float)i < nbSteps - 1.0f) {
                    float stepValue = (float)AnimManager.computeSigmoid(4, (float)(i + 1) / nbSteps);
                    float dsz = (tsz - sz) * stepValue;
                    an.steps[i] = sz + dsz;
                    ++i;
                }
                an.steps[(int)nbSteps - 1] = tsz;
                this.animGlyphBag.add(an);
                an.start();
                break;
            }
            case 6: {
                if (this.animatedGlyphs.containsKey(gID) && ((int[])this.animatedGlyphs.get(gID))[2] == 1) {
                    this.putAsPendingGAnimation(gID, GL_ROT, duration, type, data, paa);
                    break;
                }
                if (this.animatedGlyphs.containsKey(gID)) {
                    ((int[])this.animatedGlyphs.get((Object)gID))[2] = 1;
                } else {
                    int[] tmpA = new int[]{0, 0, 1, 0};
                    this.animatedGlyphs.put(gID, tmpA);
                }
                GRotate an = refresh == 0 ? new GRotate(g, this, duration) : new GRotatePRR(g, this, duration, refresh);
                an.setPostAnimationAction(paa);
                float or = g.getOrient();
                float tor = ((Float)data).floatValue() + or;
                float nbSteps = Math.round(duration / (long)frameTime);
                float dor = (tor - or) / nbSteps;
                an.steps = new float[(int)nbSteps];
                int i = 0;
                while ((float)i < nbSteps - 1.0f) {
                    an.steps[i] = or + (float)i * dor;
                    ++i;
                }
                if ((double)Math.abs(tor) >= Math.PI * 2) {
                    tor %= (float)Math.PI * 2;
                }
                an.steps[(int)nbSteps - 1] = tor;
                this.animGlyphBag.add(an);
                an.start();
                break;
            }
            case 7: {
                if (this.animatedGlyphs.containsKey(gID) && ((int[])this.animatedGlyphs.get(gID))[2] == 1) {
                    this.putAsPendingGAnimation(gID, GL_ROT, duration, type, data, paa);
                    break;
                }
                if (this.animatedGlyphs.containsKey(gID)) {
                    ((int[])this.animatedGlyphs.get((Object)gID))[2] = 1;
                } else {
                    int[] tmpA = new int[]{0, 0, 1, 0};
                    this.animatedGlyphs.put(gID, tmpA);
                }
                GRotate an = refresh == 0 ? new GRotate(g, this, duration) : new GRotatePRR(g, this, duration, refresh);
                an.setPostAnimationAction(paa);
                float or = g.getOrient();
                float tor = ((Float)data).floatValue() + or;
                float nbSteps = Math.round(duration / (long)frameTime);
                an.steps = new float[(int)nbSteps];
                int i = 0;
                while ((float)i < nbSteps - 1.0f) {
                    float stepValue = (float)Math.pow((float)(i + 1) / nbSteps, 4.0);
                    float dor = (tor - or) * stepValue;
                    an.steps[i] = or + dor;
                    ++i;
                }
                if ((double)Math.abs(tor) >= Math.PI * 2) {
                    tor %= (float)Math.PI * 2;
                }
                an.steps[(int)nbSteps - 1] = tor;
                this.animGlyphBag.add(an);
                an.start();
                break;
            }
            case 8: {
                if (this.animatedGlyphs.containsKey(gID) && ((int[])this.animatedGlyphs.get(gID))[2] == 1) {
                    this.putAsPendingGAnimation(gID, GL_ROT, duration, type, data, paa);
                    break;
                }
                if (this.animatedGlyphs.containsKey(gID)) {
                    ((int[])this.animatedGlyphs.get((Object)gID))[2] = 1;
                } else {
                    int[] tmpA = new int[]{0, 0, 1, 0};
                    this.animatedGlyphs.put(gID, tmpA);
                }
                GRotate an = refresh == 0 ? new GRotate(g, this, duration) : new GRotatePRR(g, this, duration, refresh);
                an.setPostAnimationAction(paa);
                float or = g.getOrient();
                float tor = ((Float)data).floatValue() + or;
                float nbSteps = Math.round(duration / (long)frameTime);
                an.steps = new float[(int)nbSteps];
                int i = 0;
                while ((float)i < nbSteps - 1.0f) {
                    float stepValue = (float)AnimManager.computeSigmoid(4, (float)(i + 1) / nbSteps);
                    float dor = (tor - or) * stepValue;
                    an.steps[i] = or + dor;
                    ++i;
                }
                if ((double)Math.abs(tor) >= Math.PI * 2) {
                    tor %= (float)Math.PI * 2;
                }
                an.steps[(int)nbSteps - 1] = tor;
                this.animGlyphBag.add(an);
                an.start();
                break;
            }
            case 9: {
                int i;
                double dv;
                double ds;
                double dh;
                float[] cdata;
                if (data instanceof Vector) {
                    Vector v = (Vector)data;
                    cdata = new float[v.size()];
                    for (int i2 = 0; i2 < cdata.length; ++i2) {
                        cdata[i2] = ((Float)v.elementAt(i2)).floatValue();
                    }
                } else {
                    cdata = (float[])data;
                }
                if (this.animatedGlyphs.containsKey(gID) && ((int[])this.animatedGlyphs.get(gID))[3] == 1) {
                    this.putAsPendingGAnimation(gID, GL_COLOR, duration, type, data, paa);
                    break;
                }
                if (this.animatedGlyphs.containsKey(gID)) {
                    ((int[])this.animatedGlyphs.get((Object)gID))[3] = 1;
                } else {
                    int[] tmpA = new int[]{0, 0, 0, 1};
                    this.animatedGlyphs.put(gID, tmpA);
                }
                GColoration an = refresh == 0 ? new GColoration(g, this, duration) : new GColorationPRR(g, this, duration, refresh);
                an.setPostAnimationAction(paa);
                double nbSteps = Math.round(duration / (long)frameTime);
                an.nbSteps = (int)nbSteps;
                float[] thsv = new float[3];
                for (int i3 = 0; i3 < 3; ++i3) {
                    thsv[i3] = cdata[i3];
                }
                if (thsv[0] != 0.0f || thsv[1] != 0.0f || thsv[2] != 0.0f) {
                    float[] hsv = g.getHSVColor();
                    dh = (double)thsv[0] / nbSteps;
                    ds = (double)thsv[1] / nbSteps;
                    dv = (double)thsv[2] / nbSteps;
                    an.steps = new float[an.nbSteps][3];
                    i = 0;
                    while ((double)i < nbSteps - 1.0) {
                        an.steps[i][0] = hsv[0] + (float)i * (float)dh;
                        an.steps[i][1] = hsv[1] + (float)i * (float)ds;
                        an.steps[i][2] = hsv[2] + (float)i * (float)dv;
                        ++i;
                    }
                    an.steps[(int)nbSteps - 1][0] = hsv[0] + thsv[0];
                    an.steps[(int)nbSteps - 1][1] = hsv[1] + thsv[1];
                    an.steps[(int)nbSteps - 1][2] = hsv[2] + thsv[2];
                }
                thsv = new float[3];
                for (int i4 = 0; i4 < 3; ++i4) {
                    thsv[i4] = cdata[i4 + 3];
                }
                if (thsv[0] != 0.0f || thsv[1] != 0.0f || thsv[2] != 0.0f) {
                    float[] hsv = g.getHSVColor();
                    dh = (double)thsv[0] / nbSteps;
                    ds = (double)thsv[1] / nbSteps;
                    dv = (double)thsv[2] / nbSteps;
                    an.bsteps = new float[(int)nbSteps][3];
                    i = 0;
                    while ((double)i < nbSteps - 1.0) {
                        an.bsteps[i][0] = hsv[0] + (float)i * (float)dh;
                        an.bsteps[i][1] = hsv[1] + (float)i * (float)ds;
                        an.bsteps[i][2] = hsv[2] + (float)i * (float)dv;
                        ++i;
                    }
                    an.bsteps[(int)nbSteps - 1][0] = hsv[0] + thsv[0];
                    an.bsteps[(int)nbSteps - 1][1] = hsv[1] + thsv[1];
                    an.bsteps[(int)nbSteps - 1][2] = hsv[2] + thsv[2];
                }
                if (cdata.length == 7 && g instanceof Translucent) {
                    float tav = cdata[6];
                    float sav = ((Translucent)((Object)g)).getTranslucencyValue();
                    double dt = (double)tav / nbSteps;
                    an.alphasteps = new float[an.nbSteps];
                    int i5 = 0;
                    while ((double)i5 < nbSteps - 1.0) {
                        an.alphasteps[i5] = sav + (float)i5 * (float)dt;
                        ++i5;
                    }
                    an.alphasteps[(int)nbSteps - 1] = sav + tav;
                }
                this.animGlyphBag.add(an);
                an.start();
                break;
            }
            default: {
                System.err.println("Error : AnimManager.createGlyphAnimation : unknown animation type");
            }
        }
    }

    public void createGlyphAnimation(long duration, short type, Object data, Long gID) throws ClassCastException {
        this.newGlyphAnim(duration, type, data, gID, 0, null);
    }

    public void createGlyphAnimation(long duration, short type, Object data, Long gID, PostAnimationAction paa) throws ClassCastException {
        this.newGlyphAnim(duration, type, data, gID, 0, paa);
    }

    public void createGlyphAnimation(long duration, int refresh, short type, Object data, Long gID) throws ClassCastException {
        this.newGlyphAnim(duration, type, data, gID, refresh, null);
    }

    public void createGlyphAnimation(long duration, int refresh, short type, Object data, Long gID, PostAnimationAction paa) throws ClassCastException {
        this.newGlyphAnim(duration, type, data, gID, refresh, paa);
    }

    private void putAsPendingGAnimation(Long gID, String dim, long duration, short type, Object data, PostAnimationAction paa) {
        if (this.pendingGAnims.containsKey(gID)) {
            Hashtable animByDim = (Hashtable)this.pendingGAnims.get(gID);
            Vector pa = animByDim.containsKey(dim) ? (Vector)animByDim.get(dim) : new Vector();
            pa.add(new AnimParams(duration, type, data, paa));
            animByDim.put(dim, pa);
        } else {
            Vector<AnimParams> pa = new Vector<AnimParams>();
            pa.add(new AnimParams(duration, type, data, paa));
            Hashtable<String, Vector<AnimParams>> animByDim = new Hashtable<String, Vector<AnimParams>>();
            animByDim.put(dim, pa);
            this.pendingGAnims.put(gID, animByDim);
        }
    }

    synchronized void killGAnim(GAnimation gan, String dim) {
        Hashtable pendingDims;
        Long gID = gan.target.getID();
        this.animGlyphBag.remove(gan);
        if (this.animatedGlyphs.containsKey(gID)) {
            int[] animDims = (int[])this.animatedGlyphs.get(gID);
            if (dim == "pos") {
                animDims[0] = 0;
            } else if (dim == "sz") {
                animDims[1] = 0;
            } else if (dim == GL_ROT) {
                animDims[2] = 0;
            } else if (dim == GL_COLOR) {
                animDims[3] = 0;
            }
            if (this.allValuesEqualZero(animDims)) {
                this.animatedGlyphs.remove(gID);
            }
        }
        gan.postAnimAction();
        if (this.pendingGAnims.containsKey(gID) && (pendingDims = (Hashtable)this.pendingGAnims.get(gID)).containsKey(dim)) {
            Glyph g;
            Vector pa = (Vector)pendingDims.get(dim);
            AnimParams ap = (AnimParams)pa.elementAt(0);
            pa.removeElementAt(0);
            if (pa.isEmpty()) {
                pendingDims.remove(dim);
            }
            if ((g = this.vsm.getGlyph(gID)) instanceof DPath) {
                this.createPathAnimation(ap.duration, ap.type, (LongPoint[])ap.data, gID, ap.paa);
            } else {
                this.newGlyphAnim(ap.duration, ap.type, ap.data, gID, 0, ap.paa);
            }
            if (pendingDims.isEmpty()) {
                this.pendingGAnims.remove(gID);
            }
        }
    }

    public void interruptGlyphAnimation(Glyph g, String dim, boolean all, boolean finish) {
        GAnimation an = null;
        for (int i = 0; i < this.animGlyphBag.size(); ++i) {
            GAnimation tmpAn = (GAnimation)this.animGlyphBag.elementAt(i);
            if (tmpAn.target != g || tmpAn.type != dim) continue;
            an = tmpAn;
            break;
        }
        if (an != null) {
            if (all) {
                Hashtable pendingDims;
                if (finish) {
                    an.conclude();
                }
                if (this.pendingGAnims.containsKey(g.getID()) && (pendingDims = (Hashtable)this.pendingGAnims.get(g.getID())).containsKey(dim)) {
                    pendingDims.remove(dim);
                    if (pendingDims.isEmpty()) {
                        this.pendingGAnims.remove(g.getID());
                    }
                }
            } else if (finish) {
                an.conclude();
            }
            if (dim == GL_CTRL) {
                this.killCurveAnim((GCurveCtrl)an);
            } else {
                this.killGAnim(an, dim);
            }
        }
    }

    public void createQdCurveCtrlPtAnimation(long duration, short type, Object data, Long gID, PostAnimationAction paa) {
        Glyph g = this.vsm.getGlyph(gID);
        if (g instanceof VQdCurve) {
            if (this.animatedGlyphs.containsKey(gID) && ((int[])this.animatedGlyphs.get(gID)).length < 5) {
                this.animatedGlyphs.put(gID, this.addElementsToIntArray((int[])this.animatedGlyphs.get(gID), 1));
            }
            if (this.animatedGlyphs.containsKey(gID) && ((int[])this.animatedGlyphs.get(gID))[4] == 1) {
                this.putAsPendingGAnimation(gID, GL_CTRL, duration, type, data, paa);
            } else {
                if (this.animatedGlyphs.containsKey(gID)) {
                    ((int[])this.animatedGlyphs.get((Object)gID))[4] = 1;
                } else {
                    int[] tmpA = new int[]{0, 0, 0, 0, 0};
                    tmpA[4] = 1;
                    this.animatedGlyphs.put(gID, tmpA);
                }
                GQdCurveCtrl an = new GQdCurveCtrl((VQdCurve)g, this, duration);
                an.setPostAnimationAction(paa);
                long rad = ((VQdCurve)g).getCtrlPointRadius();
                float ang = ((VQdCurve)g).getCtrlPointAngle();
                long trad = ((PolarCoords)data).r;
                float tang = ((PolarCoords)data).theta;
                double nbSteps = Math.round(duration / (long)frameTime);
                an.steps = new PolarCoords[(int)nbSteps];
                switch (type) {
                    case 0: {
                        double drad = (double)trad / nbSteps;
                        double dang = (double)tang / nbSteps;
                        int i = 0;
                        while ((double)i < nbSteps - 1.0) {
                            an.steps[i] = new PolarCoords((long)((double)rad + (double)i * drad), (float)((double)ang + (double)i * dang));
                            ++i;
                        }
                        an.steps[(int)nbSteps - 1] = new PolarCoords(rad + trad, ang + tang);
                        this.animGlyphBag.add(an);
                        an.start();
                        break;
                    }
                    case 1: {
                        int i = 0;
                        while ((double)i < nbSteps - 1.0) {
                            double stepValue = Math.pow((double)(i + 1) / nbSteps, 4.0);
                            an.steps[i++] = new PolarCoords(rad + Math.round((double)trad * stepValue), (float)((double)ang + (double)tang * stepValue));
                        }
                        an.steps[(int)nbSteps - 1] = new PolarCoords(rad + trad, ang + tang);
                        this.animGlyphBag.add(an);
                        an.start();
                        break;
                    }
                    case 2: {
                        int i = 0;
                        while ((double)i < nbSteps - 1.0) {
                            double stepValue = AnimManager.computeSigmoid(4, (double)(i + 1) / nbSteps);
                            an.steps[i++] = new PolarCoords(rad + Math.round((double)trad * stepValue), (float)((double)ang + (double)tang * stepValue));
                        }
                        an.steps[(int)nbSteps - 1] = new PolarCoords(rad + trad, ang + tang);
                        this.animGlyphBag.add(an);
                        an.start();
                        break;
                    }
                    default: {
                        System.err.println("Error : AnimManager.createQdCurveCtrlPtAnimation : unknown animation type");
                        break;
                    }
                }
            }
        } else {
            System.err.println("Error : AnimManager.createQdCurveCtrlPtAnimation : glyph is not a curve");
        }
    }

    public void createCbCurveCtrlPtAnimation(long duration, short type, Object data, Long gID, PostAnimationAction paa) {
        Glyph g = this.vsm.getGlyph(gID);
        if (g instanceof VCbCurve) {
            if (this.animatedGlyphs.containsKey(gID) && ((int[])this.animatedGlyphs.get(gID)).length < 6) {
                this.animatedGlyphs.put(gID, this.addElementsToIntArray((int[])this.animatedGlyphs.get(gID), 2));
            }
            if (this.animatedGlyphs.containsKey(gID) && (((int[])this.animatedGlyphs.get(gID))[4] == 1 || ((int[])this.animatedGlyphs.get(gID))[5] == 1)) {
                this.putAsPendingGAnimation(gID, GL_CTRL, duration, type, data, paa);
            } else {
                if (this.animatedGlyphs.containsKey(gID)) {
                    ((int[])this.animatedGlyphs.get((Object)gID))[4] = 1;
                } else {
                    int[] tmpA = new int[]{0, 0, 0, 0, 0};
                    tmpA[4] = 1;
                    this.animatedGlyphs.put(gID, tmpA);
                }
                GCbCurveCtrl an = new GCbCurveCtrl((VCbCurve)g, this, duration);
                an.setPostAnimationAction(paa);
                long rad1 = ((VCbCurve)g).getCtrlPointRadius1();
                float ang1 = ((VCbCurve)g).getCtrlPointAngle1();
                long rad2 = ((VCbCurve)g).getCtrlPointRadius2();
                float ang2 = ((VCbCurve)g).getCtrlPointAngle2();
                long trad1 = ((PolarCoords)((Vector)data).elementAt((int)0)).r;
                float tang1 = ((PolarCoords)((Vector)data).elementAt((int)0)).theta;
                long trad2 = ((PolarCoords)((Vector)data).elementAt((int)1)).r;
                float tang2 = ((PolarCoords)((Vector)data).elementAt((int)1)).theta;
                double nbSteps = Math.round(duration / (long)frameTime);
                switch (type) {
                    case 0: {
                        int i;
                        if (trad1 != 0L || tang1 != 0.0f) {
                            an.steps = new PolarCoords[(int)nbSteps];
                            double drad1 = (double)trad1 / nbSteps;
                            double dang1 = (double)tang1 / nbSteps;
                            i = 0;
                            while ((double)i < nbSteps - 1.0) {
                                an.steps[i] = new PolarCoords((long)((double)rad1 + (double)i * drad1), (float)((double)ang1 + (double)i * dang1));
                                ++i;
                            }
                            an.steps[(int)nbSteps - 1] = new PolarCoords(rad1 + trad1, ang1 + tang1);
                        } else {
                            an.steps = null;
                        }
                        if (trad2 != 0L || tang2 != 0.0f) {
                            an.steps2 = new PolarCoords[(int)nbSteps];
                            double drad2 = (double)trad2 / nbSteps;
                            double dang2 = (double)tang2 / nbSteps;
                            i = 0;
                            while ((double)i < nbSteps - 1.0) {
                                an.steps2[i] = new PolarCoords((long)((double)rad2 + (double)i * drad2), (float)((double)ang2 + (double)i * dang2));
                                ++i;
                            }
                            an.steps2[(int)nbSteps - 1] = new PolarCoords(rad2 + trad2, ang2 + tang2);
                        } else {
                            an.steps2 = null;
                        }
                        this.animGlyphBag.add(an);
                        an.start();
                        break;
                    }
                    case 1: {
                        int i;
                        if (trad1 != 0L || tang1 != 0.0f) {
                            an.steps = new PolarCoords[(int)nbSteps];
                            i = 0;
                            while ((double)i < nbSteps - 1.0) {
                                double stepValue1 = Math.pow((double)(i + 1) / nbSteps, 4.0);
                                an.steps[i++] = new PolarCoords(rad1 + Math.round((double)trad1 * stepValue1), ang1 + (float)((double)tang1 * stepValue1));
                            }
                            an.steps[(int)nbSteps - 1] = new PolarCoords(rad1 + trad1, ang1 + tang1);
                        } else {
                            an.steps = null;
                        }
                        if (trad2 != 0L || tang2 != 0.0f) {
                            an.steps2 = new PolarCoords[(int)nbSteps];
                            i = 0;
                            while ((double)i < nbSteps - 1.0) {
                                double stepValue2 = Math.pow((double)(i + 1) / nbSteps, 4.0);
                                an.steps2[i++] = new PolarCoords(rad2 + Math.round((double)trad2 * stepValue2), (float)((double)ang2 + (double)tang2 * stepValue2));
                            }
                            an.steps2[(int)nbSteps - 1] = new PolarCoords(rad2 + trad2, ang2 + tang2);
                        } else {
                            an.steps2 = null;
                        }
                        this.animGlyphBag.add(an);
                        an.start();
                        break;
                    }
                    case 2: {
                        int i;
                        if (trad1 != 0L || tang1 != 0.0f) {
                            an.steps = new PolarCoords[(int)nbSteps];
                            i = 0;
                            while ((double)i < nbSteps - 1.0) {
                                double stepValue1 = AnimManager.computeSigmoid(4, (double)(i + 1) / nbSteps);
                                an.steps[i++] = new PolarCoords(rad1 + Math.round((double)trad1 * stepValue1), (float)((double)ang1 + (double)tang1 * stepValue1));
                            }
                            an.steps[(int)nbSteps - 1] = new PolarCoords(rad1 + trad1, ang1 + tang1);
                        } else {
                            an.steps = null;
                        }
                        if (trad2 != 0L || tang2 != 0.0f) {
                            an.steps2 = new PolarCoords[(int)nbSteps];
                            i = 0;
                            while ((double)i < nbSteps - 1.0) {
                                double stepValue2 = AnimManager.computeSigmoid(4, (double)(i + 1) / nbSteps);
                                an.steps2[i++] = new PolarCoords(rad2 + Math.round((double)trad2 * stepValue2), (float)((double)ang2 + (double)tang2 * stepValue2));
                            }
                            an.steps2[(int)nbSteps - 1] = new PolarCoords(rad2 + trad2, ang2 + tang2);
                        } else {
                            an.steps2 = null;
                        }
                        this.animGlyphBag.add(an);
                        an.start();
                        break;
                    }
                    default: {
                        System.err.println("Error : AnimManager.createCbCurveCtrlPtAnimation : unknown animation type");
                        break;
                    }
                }
            }
        } else {
            System.err.println("Error : AnimManager.createCbCurveCtrlPtAnimation : glyph is not a curve");
        }
    }

    void killCurveAnim(GCurveCtrl gan) {
        Hashtable pendingDims;
        Long gID = gan.target.getID();
        this.animGlyphBag.remove(gan);
        if (this.animatedGlyphs.containsKey(gID)) {
            int[] animDims = (int[])this.animatedGlyphs.get(gID);
            animDims[4] = 0;
            if (this.allValuesEqualZero(animDims)) {
                this.animatedGlyphs.remove(gID);
            }
        }
        gan.postAnimAction();
        if (this.pendingGAnims.containsKey(gID) && (pendingDims = (Hashtable)this.pendingGAnims.get(gID)).containsKey(GL_CTRL)) {
            Glyph curve;
            Vector pa = (Vector)pendingDims.get(GL_CTRL);
            AnimParams ap = (AnimParams)pa.elementAt(0);
            pa.removeElementAt(0);
            if (pa.isEmpty()) {
                pendingDims.remove(GL_CTRL);
            }
            if ((curve = this.vsm.getGlyph(gID)) instanceof VQdCurve) {
                this.createQdCurveCtrlPtAnimation(ap.duration, ap.type, ap.data, gID, ap.paa);
            } else if (curve instanceof VCbCurve) {
                this.createCbCurveCtrlPtAnimation(ap.duration, ap.type, ap.data, gID, ap.paa);
            }
        }
    }

    public void createPathAnimation(long duration, short type, LongPoint[] data, Long gID, PostAnimationAction paa) {
        Glyph g = this.vsm.getGlyph(gID);
        if (g instanceof DPath) {
            if (this.animatedGlyphs.containsKey(gID) && ((int[])this.animatedGlyphs.get(gID))[0] == 1) {
                this.putAsPendingGAnimation(gID, "pos", duration, type, data, paa);
            } else {
                if (this.animatedGlyphs.containsKey(gID)) {
                    ((int[])this.animatedGlyphs.get((Object)gID))[0] = 1;
                } else {
                    int[] tmpA = new int[]{0, 0, 0, 0, 0};
                    tmpA[4] = 1;
                    this.animatedGlyphs.put(gID, tmpA);
                }
                DPTransformation an = new DPTransformation(g, this, duration);
                an.setPostAnimationAction(paa);
                LongPoint[] currentPoints = ((DPath)g).getAllPointsCoordinates();
                double nbSteps = Math.round(duration / (long)frameTime);
                if (type == 3 || type == 4 || type == 5) {
                    for (int i = 0; i < data.length; ++i) {
                        data[i].x -= currentPoints[i].x;
                        data[i].y -= currentPoints[i].y;
                    }
                    switch (type) {
                        case 3: {
                            type = 0;
                            break;
                        }
                        case 4: {
                            type = 1;
                            break;
                        }
                        case 5: {
                            type = (short)2;
                        }
                    }
                }
                switch (type) {
                    case 0: {
                        an.steps = new LongPoint[(int)nbSteps][data.length];
                        int step = 0;
                        while ((double)step < nbSteps - 1.0) {
                            LongPoint[] stepCoordinates = new LongPoint[data.length];
                            for (int i = 0; i < data.length; ++i) {
                                stepCoordinates[i] = new LongPoint((double)currentPoints[i].x + (double)((long)(step + 1) * data[i].x) / nbSteps, (double)currentPoints[i].y + (double)((long)(step + 1) * data[i].y) / nbSteps);
                            }
                            an.steps[step] = stepCoordinates;
                            ++step;
                        }
                        LongPoint[] stepCoordinates = new LongPoint[data.length];
                        for (int i = 0; i < data.length; ++i) {
                            stepCoordinates[i] = new LongPoint(currentPoints[i].x + data[i].x, currentPoints[i].y + data[i].y);
                        }
                        an.steps[(int)nbSteps - 1] = stepCoordinates;
                        this.animGlyphBag.add(an);
                        an.start();
                        break;
                    }
                    case 1: {
                        an.steps = new LongPoint[(int)nbSteps][data.length];
                        int step = 0;
                        while ((double)step < nbSteps - 1.0) {
                            LongPoint[] stepCoordinates = new LongPoint[data.length];
                            double stepValue = Math.pow((double)(step + 1) / nbSteps, 4.0);
                            for (int i = 0; i < data.length; ++i) {
                                long dx = Math.round((double)data[i].x * stepValue);
                                long dy = Math.round((double)data[i].y * stepValue);
                                stepCoordinates[i] = new LongPoint(currentPoints[i].x + dx, currentPoints[i].y + dy);
                            }
                            an.steps[step] = stepCoordinates;
                            ++step;
                        }
                        LongPoint[] stepCoordinates = new LongPoint[data.length];
                        for (int i = 0; i < data.length; ++i) {
                            stepCoordinates[i] = new LongPoint(currentPoints[i].x + data[i].x, currentPoints[i].y + data[i].y);
                        }
                        an.steps[(int)nbSteps - 1] = stepCoordinates;
                        this.animGlyphBag.add(an);
                        an.start();
                        break;
                    }
                    case 2: {
                        an.steps = new LongPoint[(int)nbSteps][data.length];
                        int step = 0;
                        while ((double)step < nbSteps - 1.0) {
                            LongPoint[] stepCoordinates = new LongPoint[data.length];
                            double stepValue = AnimManager.computeSigmoid(4, (double)(step + 1) / nbSteps);
                            for (int i = 0; i < data.length; ++i) {
                                long dx = Math.round((double)data[i].x * stepValue);
                                long dy = Math.round((double)data[i].y * stepValue);
                                stepCoordinates[i] = new LongPoint(currentPoints[i].x + dx, currentPoints[i].y + dy);
                            }
                            an.steps[step] = stepCoordinates;
                            ++step;
                        }
                        LongPoint[] stepCoordinates = new LongPoint[data.length];
                        for (int i = 0; i < data.length; ++i) {
                            stepCoordinates[i] = new LongPoint(currentPoints[i].x + data[i].x, currentPoints[i].y + data[i].y);
                        }
                        an.steps[(int)nbSteps - 1] = stepCoordinates;
                        this.animGlyphBag.add(an);
                        an.start();
                        break;
                    }
                    default: {
                        System.err.println("Error : AnimManager.createCbCurveCtrlPtAnimation : unknown animation type");
                        break;
                    }
                }
            }
        } else {
            System.err.println("Error : AnimManager.createCbCurveCtrlPtAnimation : glyph is not a curve");
        }
    }

    public void createCameraAnimation(long duration, short type, Object data, Integer cID) {
        this.createCameraAnimation(duration, type, data, cID, null);
    }

    public void createCameraAnimation(long duration, short type, Object data, Integer cID, PostAnimationAction paa) {
        Camera c = this.vsm.getCamera(cID);
        switch (type) {
            case 0: {
                if (this.animatedCameras.containsKey(cID) && ((int[])this.animatedCameras.get(cID))[0] == 1) {
                    this.putAsPendingCAnimation(cID, "pos", duration, type, data, paa);
                    break;
                }
                if (this.animatedCameras.containsKey(cID)) {
                    ((int[])this.animatedCameras.get((Object)cID))[0] = 1;
                } else {
                    int[] tmpA = new int[]{1, 0};
                    this.animatedCameras.put(cID, tmpA);
                }
                double nbSteps = Math.round(duration / (long)frameTime);
                if (!(nbSteps > 0.0)) break;
                CTranslation an = new CTranslation(c, this, duration);
                an.setPostAnimationAction(paa);
                long x = c.posx;
                long y = c.posy;
                long tx = ((LongPoint)data).x;
                long ty = ((LongPoint)data).y;
                double dx = (double)tx / nbSteps;
                double dy = (double)ty / nbSteps;
                an.steps = new LongPoint[(int)nbSteps];
                int i = 0;
                while ((double)i < nbSteps - 1.0) {
                    an.steps[i] = new LongPoint((long)((double)x + (double)i * dx), (long)((double)y + (double)i * dy));
                    ++i;
                }
                an.steps[(int)nbSteps - 1] = new LongPoint(x + tx, y + ty);
                this.animCameraBag.add(an);
                an.start();
                break;
            }
            case 1: {
                if (this.animatedCameras.containsKey(cID) && ((int[])this.animatedCameras.get(cID))[0] == 1) {
                    this.putAsPendingCAnimation(cID, "pos", duration, type, data, paa);
                    break;
                }
                if (this.animatedCameras.containsKey(cID)) {
                    ((int[])this.animatedCameras.get((Object)cID))[0] = 1;
                } else {
                    int[] tmpA = new int[]{1, 0};
                    this.animatedCameras.put(cID, tmpA);
                }
                double nbSteps = Math.round((double)(duration / (long)frameTime));
                if (!(nbSteps > 0.0)) break;
                CTranslation an = new CTranslation(c, this, duration);
                an.setPostAnimationAction(paa);
                long x = c.posx;
                long y = c.posy;
                long tx = ((LongPoint)data).x;
                long ty = ((LongPoint)data).y;
                an.steps = new LongPoint[(int)nbSteps];
                int i = 0;
                while ((double)i < nbSteps - 1.0) {
                    double stepValue = Math.pow((double)(i + 1) / nbSteps, 4.0);
                    long dx = Math.round((double)tx * stepValue);
                    long dy = Math.round((double)ty * stepValue);
                    an.steps[i++] = new LongPoint(x + dx, y + dy);
                }
                an.steps[(int)nbSteps - 1] = new LongPoint(x + tx, y + ty);
                this.animCameraBag.add(an);
                an.start();
                break;
            }
            case 2: {
                if (this.animatedCameras.containsKey(cID) && ((int[])this.animatedCameras.get(cID))[0] == 1) {
                    this.putAsPendingCAnimation(cID, "pos", duration, type, data, paa);
                    break;
                }
                if (this.animatedCameras.containsKey(cID)) {
                    ((int[])this.animatedCameras.get((Object)cID))[0] = 1;
                } else {
                    int[] tmpA = new int[]{1, 0};
                    this.animatedCameras.put(cID, tmpA);
                }
                double nbSteps = Math.round((double)(duration / (long)frameTime));
                if (!(nbSteps > 0.0)) break;
                CTranslation an = new CTranslation(c, this, duration);
                an.setPostAnimationAction(paa);
                long x = c.posx;
                long y = c.posy;
                long tx = ((LongPoint)data).x;
                long ty = ((LongPoint)data).y;
                an.steps = new LongPoint[(int)nbSteps];
                int i = 0;
                while ((double)i < nbSteps - 1.0) {
                    double stepValue = AnimManager.computeSigmoid(4, (double)(i + 1) / nbSteps);
                    long dx = Math.round((double)tx * stepValue);
                    long dy = Math.round((double)ty * stepValue);
                    an.steps[i++] = new LongPoint(x + dx, y + dy);
                }
                an.steps[(int)nbSteps - 1] = new LongPoint(x + tx, y + ty);
                this.animCameraBag.add(an);
                an.start();
                break;
            }
            case 3: {
                float step;
                if (this.animatedCameras.containsKey(cID) && ((int[])this.animatedCameras.get(cID))[1] == 1) {
                    this.putAsPendingCAnimation(cID, "sz", duration, type, data, paa);
                    break;
                }
                if (this.animatedCameras.containsKey(cID)) {
                    ((int[])this.animatedCameras.get((Object)cID))[1] = 1;
                } else {
                    int[] tmpA = new int[]{0, 1};
                    this.animatedCameras.put(cID, tmpA);
                }
                int nbSteps = Math.round(duration / (long)frameTime);
                if (nbSteps <= 0) break;
                CZoom an = new CZoom(c, this, duration);
                an.setPostAnimationAction(paa);
                float alt = c.altitude;
                float ta = ((Float)data).floatValue();
                double da = ta / (float)nbSteps;
                an.steps = new float[nbSteps];
                for (int i = 0; i < nbSteps - 1; ++i) {
                    step = (float)((double)alt + (double)i * da);
                    if (step < (float)this.vsm.zoomFloor) {
                        step = this.vsm.zoomFloor;
                    }
                    an.steps[i] = step;
                }
                step = alt + ta;
                if (step < (float)this.vsm.zoomFloor) {
                    step = this.vsm.zoomFloor;
                }
                an.steps[nbSteps - 1] = step;
                this.animCameraBag.add(an);
                an.start();
                break;
            }
            case 4: {
                float step;
                if (this.animatedCameras.containsKey(cID) && ((int[])this.animatedCameras.get(cID))[1] == 1) {
                    this.putAsPendingCAnimation(cID, "sz", duration, type, data, paa);
                    break;
                }
                if (this.animatedCameras.containsKey(cID)) {
                    ((int[])this.animatedCameras.get((Object)cID))[1] = 1;
                } else {
                    int[] tmpA = new int[]{0, 1};
                    this.animatedCameras.put(cID, tmpA);
                }
                double nbSteps = Math.round((double)(duration / (long)frameTime));
                if (!(nbSteps > 0.0)) break;
                CZoom an = new CZoom(c, this, duration);
                an.setPostAnimationAction(paa);
                float alt = c.altitude;
                float ta = ((Float)data).floatValue();
                an.steps = new float[(int)nbSteps];
                int i = 0;
                while ((double)i < nbSteps - 1.0) {
                    double stepValue = Math.pow((double)(i + 1) / nbSteps, 4.0);
                    float da = ta * (float)stepValue;
                    step = alt + da;
                    if (step < (float)this.vsm.zoomFloor) {
                        step = this.vsm.zoomFloor;
                    }
                    an.steps[i++] = step;
                }
                step = alt + ta;
                if (step < (float)this.vsm.zoomFloor) {
                    step = this.vsm.zoomFloor;
                }
                an.steps[(int)nbSteps - 1] = step;
                this.animCameraBag.add(an);
                an.start();
                break;
            }
            case 5: {
                float step;
                if (this.animatedCameras.containsKey(cID) && ((int[])this.animatedCameras.get(cID))[1] == 1) {
                    this.putAsPendingCAnimation(cID, "sz", duration, type, data, paa);
                    break;
                }
                if (this.animatedCameras.containsKey(cID)) {
                    ((int[])this.animatedCameras.get((Object)cID))[1] = 1;
                } else {
                    int[] tmpA = new int[]{0, 1};
                    this.animatedCameras.put(cID, tmpA);
                }
                double nbSteps = Math.round((double)(duration / (long)frameTime));
                if (!(nbSteps > 0.0)) break;
                CZoom an = new CZoom(c, this, duration);
                an.setPostAnimationAction(paa);
                float alt = c.altitude;
                float ta = ((Float)data).floatValue();
                an.steps = new float[(int)nbSteps];
                int i = 0;
                while ((double)i < nbSteps - 1.0) {
                    double stepValue = AnimManager.computeSigmoid(4, (double)(i + 1) / nbSteps);
                    float da = ta * (float)stepValue;
                    step = alt + da;
                    if (step < (float)this.vsm.zoomFloor) {
                        step = this.vsm.zoomFloor;
                    }
                    an.steps[i++] = step;
                }
                step = alt + ta;
                if (step < (float)this.vsm.zoomFloor) {
                    step = this.vsm.zoomFloor;
                }
                an.steps[(int)nbSteps - 1] = step;
                this.animCameraBag.add(an);
                an.start();
                break;
            }
            case 6: {
                float step;
                if (this.animatedCameras.containsKey(cID) && (((int[])this.animatedCameras.get(cID))[0] == 1 || ((int[])this.animatedCameras.get(cID))[1] == 1)) {
                    this.putAsPendingCAnimation(cID, "both", duration, type, data, paa);
                    break;
                }
                if (this.animatedCameras.containsKey(cID)) {
                    ((int[])this.animatedCameras.get((Object)cID))[0] = 1;
                    ((int[])this.animatedCameras.get((Object)cID))[1] = 1;
                } else {
                    int[] tmpA = new int[]{1, 1};
                    this.animatedCameras.put(cID, tmpA);
                }
                double nbSteps = Math.round((double)(duration / (long)frameTime));
                if (!(nbSteps > 0.0)) break;
                CTransZoom an = new CTransZoom(c, this, duration);
                an.setPostAnimationAction(paa);
                float alt = c.altitude;
                long x = c.posx;
                long y = c.posy;
                float ta = ((Float)((Vector)data).elementAt(0)).floatValue();
                long tx = ((LongPoint)((Vector)data).elementAt((int)1)).x;
                long ty = ((LongPoint)((Vector)data).elementAt((int)1)).y;
                an.zsteps = new float[(int)nbSteps];
                an.tsteps = new LongPoint[(int)nbSteps];
                int i = 0;
                while ((double)i < nbSteps - 1.0) {
                    double stepValue = AnimManager.computeSigmoid(4, (double)(i + 1) / nbSteps);
                    float da = ta * (float)stepValue;
                    long dx = Math.round((double)tx * stepValue);
                    long dy = Math.round((double)ty * stepValue);
                    step = alt + da;
                    if (step < (float)this.vsm.zoomFloor) {
                        step = this.vsm.zoomFloor;
                    }
                    an.zsteps[i] = step;
                    an.tsteps[i++] = new LongPoint(x + dx, y + dy);
                }
                step = alt + ta;
                if (step < (float)this.vsm.zoomFloor) {
                    step = this.vsm.zoomFloor;
                }
                an.zsteps[(int)nbSteps - 1] = step;
                an.tsteps[(int)nbSteps - 1] = new LongPoint(x + tx, y + ty);
                this.animCameraBag.add(an);
                an.start();
                break;
            }
            case 7: {
                float step;
                if (this.animatedCameras.containsKey(cID) && (((int[])this.animatedCameras.get(cID))[0] == 1 || ((int[])this.animatedCameras.get(cID))[1] == 1)) {
                    this.putAsPendingCAnimation(cID, "both", duration, type, data, paa);
                    break;
                }
                if (this.animatedCameras.containsKey(cID)) {
                    ((int[])this.animatedCameras.get((Object)cID))[0] = 1;
                    ((int[])this.animatedCameras.get((Object)cID))[1] = 1;
                } else {
                    int[] tmpA = new int[]{1, 1};
                    this.animatedCameras.put(cID, tmpA);
                }
                double nbSteps = Math.round((double)(duration / (long)frameTime));
                if (!(nbSteps > 0.0)) break;
                CTransZoom an = new CTransZoom(c, this, duration);
                an.setPostAnimationAction(paa);
                float alt = c.altitude;
                long x = c.posx;
                long y = c.posy;
                float ta = ((Float)((Vector)data).elementAt(0)).floatValue();
                long tx = ((LongPoint)((Vector)data).elementAt((int)1)).x;
                long ty = ((LongPoint)((Vector)data).elementAt((int)1)).y;
                an.zsteps = new float[(int)nbSteps];
                an.tsteps = new LongPoint[(int)nbSteps];
                double da = (double)ta / nbSteps;
                double dx = (double)tx / nbSteps;
                double dy = (double)ty / nbSteps;
                int i = 0;
                while ((double)i < nbSteps - 1.0) {
                    step = (float)((double)alt + (double)i * da);
                    if (step < (float)this.vsm.zoomFloor) {
                        step = this.vsm.zoomFloor;
                    }
                    an.zsteps[i] = step;
                    an.tsteps[i] = new LongPoint((long)((double)x + (double)i * dx), (long)((double)y + (double)i * dy));
                    ++i;
                }
                step = alt + ta;
                if (step < (float)this.vsm.zoomFloor) {
                    step = this.vsm.zoomFloor;
                }
                an.zsteps[(int)nbSteps - 1] = step;
                an.tsteps[(int)nbSteps - 1] = new LongPoint(x + tx, y + ty);
                this.animCameraBag.add(an);
                an.start();
                break;
            }
            default: {
                System.err.println("Error : AnimManager.createCameraAnimation : unknown animation type");
            }
        }
    }

    void putAsPendingCAnimation(Integer cID, String dim, long duration, short type, Object data, PostAnimationAction paa) {
        if (this.pendingCAnims.containsKey(cID)) {
            Hashtable animByDim = (Hashtable)this.pendingCAnims.get(cID);
            Vector pa = animByDim.containsKey(dim) ? (Vector)animByDim.get(dim) : new Vector();
            pa.add(new AnimParams(duration, type, data, paa));
            animByDim.put(dim, pa);
        } else {
            Vector<AnimParams> pa = new Vector<AnimParams>();
            pa.add(new AnimParams(duration, type, data, paa));
            Hashtable<String, Vector<AnimParams>> animByDim = new Hashtable<String, Vector<AnimParams>>();
            animByDim.put(dim, pa);
            this.pendingCAnims.put(cID, animByDim);
        }
    }

    void killCAnim(CAnimation can, String dim) {
        Hashtable pendingDims;
        Integer cID = can.target.getID();
        this.animCameraBag.remove(can);
        if (this.animatedCameras.containsKey(cID)) {
            int[] animDims = (int[])this.animatedCameras.get(cID);
            if (dim.equals("pos")) {
                animDims[0] = 0;
            } else if (dim.equals("sz")) {
                animDims[1] = 0;
            } else if (dim.equals("both")) {
                animDims[0] = 0;
                animDims[1] = 0;
            }
            if (this.allValuesEqualZero(animDims)) {
                this.animatedCameras.remove(cID);
            }
        }
        can.postAnimAction();
        if (this.pendingCAnims.containsKey(cID) && (pendingDims = (Hashtable)this.pendingCAnims.get(cID)).containsKey(dim)) {
            Vector pa = (Vector)pendingDims.get(dim);
            AnimParams ap = (AnimParams)pa.elementAt(0);
            pa.removeElementAt(0);
            if (pa.isEmpty()) {
                pendingDims.remove(dim);
                if (pendingDims.isEmpty()) {
                    this.pendingCAnims.remove(cID);
                }
            }
            this.createCameraAnimation(ap.duration, ap.type, ap.data, cID, ap.paa);
        }
    }

    public void interruptCameraAnimation(Camera c, String dim, boolean all, boolean finish) {
        CAnimation an = null;
        for (int i = 0; i < this.animCameraBag.size(); ++i) {
            CAnimation tmpAn = (CAnimation)this.animCameraBag.elementAt(i);
            if (tmpAn.target != c || tmpAn.type != dim) continue;
            an = tmpAn;
            break;
        }
        if (an != null) {
            if (all) {
                Hashtable pendingDims;
                if (finish) {
                    an.conclude();
                }
                if (this.pendingCAnims.containsKey(c.getID()) && (pendingDims = (Hashtable)this.pendingCAnims.get(c.getID())).containsKey(dim)) {
                    pendingDims.remove(dim);
                    if (pendingDims.isEmpty()) {
                        this.pendingCAnims.remove(c.getID());
                    }
                }
            } else if (finish) {
                an.conclude();
            }
            this.killCAnim(an, dim);
        }
    }

    public void createLensAnimation(long duration, short type, Object data, Integer lID, boolean kill) {
        if (kill) {
            this.createLensAnimation(duration, type, data, lID, new LensKillAction(this.vsm));
        } else {
            this.createLensAnimation(duration, type, data, lID, null);
        }
    }

    public void createLensAnimation(long duration, short type, Object data, Integer lID, PostAnimationAction paa) {
        Lens l = this.vsm.getLens(lID);
        if (l == null) {
            return;
        }
        switch (type) {
            case 0: {
                if (this.animatedLenses.containsKey(lID) && ((int[])this.animatedLenses.get(lID))[1] == 1) {
                    this.putAsPendingLAnimation(lID, LS_RD, duration, type, data, paa);
                    break;
                }
                if (this.animatedLenses.containsKey(lID)) {
                    ((int[])this.animatedLenses.get((Object)lID))[1] = 1;
                } else {
                    int[] tmpA = new int[]{0, 1, 0};
                    this.animatedLenses.put(lID, tmpA);
                }
                double nbSteps = Math.round(duration / (long)frameTime);
                if (!(nbSteps > 0.0)) break;
                int r1 = ((FixedSizeLens)l).getOuterRadius();
                int r2 = ((FixedSizeLens)l).getInnerRadius();
                FSLRadii an = new FSLRadii((FixedSizeLens)l, this, duration);
                an.setPostAnimationAction(paa);
                int[] offsets = (int[])data;
                int tr1 = offsets[0];
                int tr2 = offsets[1];
                double dr1 = (double)tr1 / nbSteps;
                double dr2 = (double)tr2 / nbSteps;
                an.steps = new int[(int)nbSteps][2];
                int i = 0;
                while ((double)i < nbSteps - 1.0) {
                    an.steps[i][0] = (int)Math.round((double)r1 + (double)i * dr1);
                    an.steps[i][1] = (int)Math.round((double)r2 + (double)i * dr2);
                    ++i;
                }
                an.steps[(int)nbSteps - 1][0] = r1 + tr1;
                an.steps[(int)nbSteps - 1][1] = r2 + tr2;
                if (an.steps[an.steps.length - 1][0] > an.steps[0][0]) {
                    l.setMagRasterDimensions(Math.round(2.0f * l.getMaximumMagnification() * (float)an.steps[an.steps.length - 1][0]));
                } else {
                    an.setFinalRasterSize(Math.round(2.0f * l.getMaximumMagnification() * (float)an.steps[an.steps.length - 1][0]));
                }
                this.animLensBag.add(an);
                an.start();
                break;
            }
            case 1: {
                if (this.animatedLenses.containsKey(lID) && ((int[])this.animatedLenses.get(lID))[1] == 1) {
                    this.putAsPendingLAnimation(lID, LS_RD, duration, type, data, paa);
                    break;
                }
                if (this.animatedLenses.containsKey(lID)) {
                    ((int[])this.animatedLenses.get((Object)lID))[1] = 1;
                } else {
                    int[] tmpA = new int[]{0, 1, 0};
                    this.animatedLenses.put(lID, tmpA);
                }
                double nbSteps = Math.round(duration / (long)frameTime);
                if (!(nbSteps > 0.0)) break;
                FSLRadii an = new FSLRadii((FixedSizeLens)l, this, duration);
                an.setPostAnimationAction(paa);
                int r1 = ((FixedSizeLens)l).getOuterRadius();
                int r2 = ((FixedSizeLens)l).getInnerRadius();
                int[] offsets = (int[])data;
                int tr1 = offsets[0];
                int tr2 = offsets[1];
                an.steps = new int[(int)nbSteps][2];
                int i = 0;
                while ((double)i < nbSteps - 1.0) {
                    double stepValue = Math.pow((double)(i + 1) / nbSteps, 4.0);
                    an.steps[i][0] = (int)Math.round((double)r1 + (double)tr1 * stepValue);
                    an.steps[i][1] = (int)Math.round((double)r2 + (double)tr2 * stepValue);
                    ++i;
                }
                an.steps[(int)nbSteps - 1][0] = r1 + tr1;
                an.steps[(int)nbSteps - 1][1] = r2 + tr2;
                if (an.steps[an.steps.length - 1][0] > an.steps[0][0]) {
                    l.setMagRasterDimensions(Math.round(2.0f * l.getMaximumMagnification() * (float)an.steps[an.steps.length - 1][0]));
                } else {
                    an.setFinalRasterSize(Math.round(2.0f * l.getMaximumMagnification() * (float)an.steps[an.steps.length - 1][0]));
                }
                this.animLensBag.add(an);
                an.start();
                break;
            }
            case 2: {
                if (this.animatedLenses.containsKey(lID) && ((int[])this.animatedLenses.get(lID))[1] == 1) {
                    this.putAsPendingLAnimation(lID, LS_RD, duration, type, data, paa);
                    break;
                }
                if (this.animatedLenses.containsKey(lID)) {
                    ((int[])this.animatedLenses.get((Object)lID))[1] = 1;
                } else {
                    int[] tmpA = new int[]{0, 1, 0};
                    this.animatedLenses.put(lID, tmpA);
                }
                double nbSteps = Math.round(duration / (long)frameTime);
                if (!(nbSteps > 0.0)) break;
                FSLRadii an = new FSLRadii((FixedSizeLens)l, this, duration);
                an.setPostAnimationAction(paa);
                int r1 = ((FixedSizeLens)l).getOuterRadius();
                int r2 = ((FixedSizeLens)l).getInnerRadius();
                int[] offsets = (int[])data;
                int tr1 = offsets[0];
                int tr2 = offsets[1];
                an.steps = new int[(int)nbSteps][2];
                int i = 0;
                while ((double)i < nbSteps - 1.0) {
                    double stepValue = AnimManager.computeSigmoid(4, (double)(i + 1) / nbSteps);
                    an.steps[i][0] = (int)Math.round((double)r1 + (double)tr1 * stepValue);
                    an.steps[i][1] = (int)Math.round((double)r2 + (double)tr2 * stepValue);
                    ++i;
                }
                an.steps[(int)nbSteps - 1][0] = r1 + tr1;
                an.steps[(int)nbSteps - 1][1] = r2 + tr2;
                if (an.steps[an.steps.length - 1][0] > an.steps[0][0]) {
                    l.setMagRasterDimensions(Math.round(2.0f * l.getMaximumMagnification() * (float)an.steps[an.steps.length - 1][0]));
                } else {
                    an.setFinalRasterSize(Math.round(2.0f * l.getMaximumMagnification() * (float)an.steps[an.steps.length - 1][0]));
                }
                this.animLensBag.add(an);
                an.start();
                break;
            }
            case 3: {
                float step;
                if (this.animatedLenses.containsKey(lID) && ((int[])this.animatedLenses.get(lID))[0] == 1) {
                    this.putAsPendingLAnimation(lID, LS_MM, duration, type, data, paa);
                    break;
                }
                if (this.animatedLenses.containsKey(lID)) {
                    ((int[])this.animatedLenses.get((Object)lID))[0] = 1;
                } else {
                    int[] tmpA = new int[]{1, 0, 0};
                    this.animatedLenses.put(lID, tmpA);
                }
                double nbSteps = Math.round(duration / (long)frameTime);
                if (!(nbSteps > 0.0)) break;
                LMaximumMagnification an = new LMaximumMagnification(l, this, duration);
                an.setPostAnimationAction(paa);
                float mm = l.getMaximumMagnification();
                float tmm = ((Float)data).floatValue();
                double dmm = (double)tmm / nbSteps;
                an.steps = new float[(int)nbSteps];
                int i = 0;
                while ((double)i < nbSteps - 1.0) {
                    step = (float)((double)mm + (double)i * dmm);
                    if (step < Lens.MM_FLOOR) {
                        step = Lens.MM_FLOOR;
                    }
                    an.steps[i] = step;
                    ++i;
                }
                step = mm + tmm;
                if (step < Lens.MM_FLOOR) {
                    step = Lens.MM_FLOOR;
                }
                an.steps[(int)nbSteps - 1] = step;
                if (step > an.steps[0]) {
                    l.setMagRasterDimensions(Math.round(2.0f * step * (float)l.getRadius()));
                } else {
                    an.setFinalRasterSize(Math.round(2.0f * step * (float)l.getRadius()));
                }
                this.animLensBag.add(an);
                an.start();
                break;
            }
            case 4: {
                float step;
                if (this.animatedLenses.containsKey(lID) && ((int[])this.animatedLenses.get(lID))[0] == 1) {
                    this.putAsPendingLAnimation(lID, LS_MM, duration, type, data, paa);
                    break;
                }
                if (this.animatedLenses.containsKey(lID)) {
                    ((int[])this.animatedLenses.get((Object)lID))[0] = 1;
                } else {
                    int[] tmpA = new int[]{1, 0, 0};
                    this.animatedLenses.put(lID, tmpA);
                }
                double nbSteps = Math.round(duration / (long)frameTime);
                if (!(nbSteps > 0.0)) break;
                LMaximumMagnification an = new LMaximumMagnification(l, this, duration);
                an.setPostAnimationAction(paa);
                float mm = l.getMaximumMagnification();
                float tmm = ((Float)data).floatValue();
                an.steps = new float[(int)nbSteps];
                int i = 0;
                while ((double)i < nbSteps - 1.0) {
                    double stepValue = Math.pow((double)(i + 1) / nbSteps, 4.0);
                    float dmm = tmm * (float)stepValue;
                    step = mm + dmm;
                    if (step < Lens.MM_FLOOR) {
                        step = Lens.MM_FLOOR;
                    }
                    an.steps[i++] = step;
                }
                step = mm + tmm;
                if (step < Lens.MM_FLOOR) {
                    step = Lens.MM_FLOOR;
                }
                an.steps[(int)nbSteps - 1] = step;
                if (step > an.steps[0]) {
                    l.setMagRasterDimensions(Math.round(2.0f * step * (float)l.getRadius()));
                } else {
                    an.setFinalRasterSize(Math.round(2.0f * step * (float)l.getRadius()));
                }
                this.animLensBag.add(an);
                an.start();
                break;
            }
            case 5: {
                float step;
                if (this.animatedLenses.containsKey(lID) && ((int[])this.animatedLenses.get(lID))[0] == 1) {
                    this.putAsPendingLAnimation(lID, LS_MM, duration, type, data, paa);
                    break;
                }
                if (this.animatedLenses.containsKey(lID)) {
                    ((int[])this.animatedLenses.get((Object)lID))[0] = 1;
                } else {
                    int[] tmpA = new int[]{1, 0, 0};
                    this.animatedLenses.put(lID, tmpA);
                }
                double nbSteps = Math.round(duration / (long)frameTime);
                if (!(nbSteps > 0.0)) break;
                LMaximumMagnification an = new LMaximumMagnification(l, this, duration);
                an.setPostAnimationAction(paa);
                float mm = l.getMaximumMagnification();
                float tmm = ((Float)data).floatValue();
                an.steps = new float[(int)nbSteps];
                int i = 0;
                while ((double)i < nbSteps - 1.0) {
                    double stepValue = AnimManager.computeSigmoid(4, (double)(i + 1) / nbSteps);
                    float dmm = tmm * (float)stepValue;
                    step = mm + dmm;
                    if (step < Lens.MM_FLOOR) {
                        step = Lens.MM_FLOOR;
                    }
                    an.steps[i++] = step;
                }
                step = mm + tmm;
                if (step < Lens.MM_FLOOR) {
                    step = Lens.MM_FLOOR;
                }
                an.steps[(int)nbSteps - 1] = step;
                if (step > an.steps[0]) {
                    l.setMagRasterDimensions(Math.round(2.0f * step * (float)l.getRadius()));
                } else {
                    an.setFinalRasterSize(Math.round(2.0f * step * (float)l.getRadius()));
                }
                this.animLensBag.add(an);
                an.start();
                break;
            }
            case 6: {
                float step;
                if (this.animatedLenses.containsKey(lID) && (((int[])this.animatedLenses.get(lID))[0] == 1 || ((int[])this.animatedLenses.get(lID))[1] == 1)) {
                    this.putAsPendingLAnimation(lID, "both", duration, type, data, paa);
                    break;
                }
                if (this.animatedLenses.containsKey(lID)) {
                    ((int[])this.animatedLenses.get((Object)lID))[0] = 1;
                } else {
                    int[] tmpA = new int[]{1, 1, 0};
                    this.animatedLenses.put(lID, tmpA);
                }
                double nbSteps = Math.round(duration / (long)frameTime);
                if (!(nbSteps > 0.0)) break;
                FSLMaxMagRadii an = new FSLMaxMagRadii((FixedSizeLens)l, this, duration);
                an.setPostAnimationAction(paa);
                int r1 = ((FixedSizeLens)l).getOuterRadius();
                int r2 = ((FixedSizeLens)l).getInnerRadius();
                int[] offsets = (int[])((Vector)data).elementAt(1);
                int tr1 = offsets[0];
                int tr2 = offsets[1];
                double dr1 = (double)tr1 / nbSteps;
                double dr2 = (double)tr2 / nbSteps;
                an.rsteps = new int[(int)nbSteps][2];
                int i = 0;
                while ((double)i < nbSteps - 1.0) {
                    an.rsteps[i][0] = (int)Math.round((double)r1 + (double)i * dr1);
                    an.rsteps[i][1] = (int)Math.round((double)r2 + (double)i * dr2);
                    ++i;
                }
                an.rsteps[(int)nbSteps - 1][0] = r1 + tr1;
                an.rsteps[(int)nbSteps - 1][1] = r2 + tr2;
                float mm = l.getMaximumMagnification();
                float tmm = ((Float)((Vector)data).elementAt(0)).floatValue();
                double dmm = (double)tmm / nbSteps;
                an.mmsteps = new float[(int)nbSteps];
                int i2 = 0;
                while ((double)i2 < nbSteps - 1.0) {
                    step = (float)((double)mm + (double)i2 * dmm);
                    if (step < Lens.MM_FLOOR) {
                        step = Lens.MM_FLOOR;
                    }
                    an.mmsteps[i2] = step;
                    ++i2;
                }
                step = mm + tmm;
                if (step < Lens.MM_FLOOR) {
                    step = Lens.MM_FLOOR;
                }
                an.mmsteps[(int)nbSteps - 1] = step;
                if ((float)an.rsteps[an.rsteps.length - 1][0] * an.mmsteps[an.mmsteps.length - 1] > (float)an.rsteps[0][0] * an.mmsteps[0]) {
                    l.setMagRasterDimensions(Math.round((float)(2 * an.rsteps[an.rsteps.length - 1][0]) * an.mmsteps[an.mmsteps.length - 1]));
                } else {
                    an.setFinalRasterSize(Math.round((float)(2 * an.rsteps[an.rsteps.length - 1][0]) * an.mmsteps[an.mmsteps.length - 1]));
                }
                this.animLensBag.add(an);
                an.start();
                break;
            }
            case 7: {
                float step;
                double stepValue;
                if (this.animatedLenses.containsKey(lID) && (((int[])this.animatedLenses.get(lID))[0] == 1 || ((int[])this.animatedLenses.get(lID))[1] == 1)) {
                    this.putAsPendingLAnimation(lID, "both", duration, type, data, paa);
                    break;
                }
                if (this.animatedLenses.containsKey(lID)) {
                    ((int[])this.animatedLenses.get((Object)lID))[0] = 1;
                } else {
                    int[] tmpA = new int[]{1, 1, 0};
                    this.animatedLenses.put(lID, tmpA);
                }
                double nbSteps = Math.round(duration / (long)frameTime);
                if (!(nbSteps > 0.0)) break;
                FSLMaxMagRadii an = new FSLMaxMagRadii((FixedSizeLens)l, this, duration);
                an.setPostAnimationAction(paa);
                int r1 = ((FixedSizeLens)l).getOuterRadius();
                int r2 = ((FixedSizeLens)l).getInnerRadius();
                int[] offsets = (int[])((Vector)data).elementAt(1);
                int tr1 = offsets[0];
                int tr2 = offsets[1];
                an.rsteps = new int[(int)nbSteps][2];
                int i = 0;
                while ((double)i < nbSteps - 1.0) {
                    stepValue = Math.pow((double)(i + 1) / nbSteps, 4.0);
                    an.rsteps[i][0] = (int)Math.round((double)r1 + (double)tr1 * stepValue);
                    an.rsteps[i][1] = (int)Math.round((double)r2 + (double)tr2 * stepValue);
                    ++i;
                }
                an.rsteps[(int)nbSteps - 1][0] = r1 + tr1;
                an.rsteps[(int)nbSteps - 1][1] = r2 + tr2;
                float mm = l.getMaximumMagnification();
                float tmm = ((Float)((Vector)data).elementAt(0)).floatValue();
                an.mmsteps = new float[(int)nbSteps];
                int i3 = 0;
                while ((double)i3 < nbSteps - 1.0) {
                    stepValue = Math.pow((double)(i3 + 1) / nbSteps, 4.0);
                    float dmm = tmm * (float)stepValue;
                    step = mm + dmm;
                    if (step < Lens.MM_FLOOR) {
                        step = Lens.MM_FLOOR;
                    }
                    an.mmsteps[i3++] = step;
                }
                step = mm + tmm;
                if (step < Lens.MM_FLOOR) {
                    step = Lens.MM_FLOOR;
                }
                an.mmsteps[(int)nbSteps - 1] = step;
                if ((float)an.rsteps[an.rsteps.length - 1][0] * an.mmsteps[an.mmsteps.length - 1] > (float)an.rsteps[0][0] * an.mmsteps[0]) {
                    l.setMagRasterDimensions(Math.round((float)(2 * an.rsteps[an.rsteps.length - 1][0]) * an.mmsteps[an.mmsteps.length - 1]));
                } else {
                    an.setFinalRasterSize(Math.round((float)(2 * an.rsteps[an.rsteps.length - 1][0]) * an.mmsteps[an.mmsteps.length - 1]));
                }
                this.animLensBag.add(an);
                an.start();
                break;
            }
            case 8: {
                float step;
                double stepValue;
                if (this.animatedLenses.containsKey(lID) && (((int[])this.animatedLenses.get(lID))[0] == 1 || ((int[])this.animatedLenses.get(lID))[1] == 1)) {
                    this.putAsPendingLAnimation(lID, "both", duration, type, data, paa);
                    break;
                }
                if (this.animatedLenses.containsKey(lID)) {
                    ((int[])this.animatedLenses.get((Object)lID))[0] = 1;
                } else {
                    int[] tmpA = new int[]{1, 1, 0};
                    this.animatedLenses.put(lID, tmpA);
                }
                double nbSteps = Math.round(duration / (long)frameTime);
                if (!(nbSteps > 0.0)) break;
                FSLMaxMagRadii an = new FSLMaxMagRadii((FixedSizeLens)l, this, duration);
                an.setPostAnimationAction(paa);
                int r1 = ((FixedSizeLens)l).getOuterRadius();
                int r2 = ((FixedSizeLens)l).getInnerRadius();
                int[] offsets = (int[])((Vector)data).elementAt(1);
                int tr1 = offsets[0];
                int tr2 = offsets[1];
                an.rsteps = new int[(int)nbSteps][2];
                int i = 0;
                while ((double)i < nbSteps - 1.0) {
                    stepValue = AnimManager.computeSigmoid(4, (double)(i + 1) / nbSteps);
                    an.rsteps[i][0] = (int)Math.round((double)r1 + (double)tr1 * stepValue);
                    an.rsteps[i][1] = (int)Math.round((double)r2 + (double)tr2 * stepValue);
                    ++i;
                }
                an.rsteps[(int)nbSteps - 1][0] = r1 + tr1;
                an.rsteps[(int)nbSteps - 1][1] = r2 + tr2;
                float mm = l.getMaximumMagnification();
                float tmm = ((Float)((Vector)data).elementAt(0)).floatValue();
                an.mmsteps = new float[(int)nbSteps];
                int i4 = 0;
                while ((double)i4 < nbSteps - 1.0) {
                    stepValue = AnimManager.computeSigmoid(4, (double)(i4 + 1) / nbSteps);
                    float dmm = tmm * (float)stepValue;
                    step = mm + dmm;
                    if (step < Lens.MM_FLOOR) {
                        step = Lens.MM_FLOOR;
                    }
                    an.mmsteps[i4++] = step;
                }
                step = mm + tmm;
                if (step < Lens.MM_FLOOR) {
                    step = Lens.MM_FLOOR;
                }
                an.mmsteps[(int)nbSteps - 1] = step;
                if ((float)an.rsteps[an.rsteps.length - 1][0] * an.mmsteps[an.mmsteps.length - 1] > (float)an.rsteps[0][0] * an.mmsteps[0]) {
                    l.setMagRasterDimensions(Math.round((float)(2 * an.rsteps[an.rsteps.length - 1][0]) * an.mmsteps[an.mmsteps.length - 1]));
                } else {
                    an.setFinalRasterSize(Math.round((float)(2 * an.rsteps[an.rsteps.length - 1][0]) * an.mmsteps[an.mmsteps.length - 1]));
                }
                this.animLensBag.add(an);
                an.start();
                break;
            }
            case 9: {
                float step;
                if (this.animatedLenses.containsKey(lID) && ((int[])this.animatedLenses.get(lID))[2] == 1) {
                    this.putAsPendingLAnimation(lID, LS_LP, duration, type, data, paa);
                    break;
                }
                if (this.animatedLenses.containsKey(lID)) {
                    ((int[])this.animatedLenses.get((Object)lID))[2] = 1;
                } else {
                    int[] tmpA = new int[]{0, 0, 1};
                    this.animatedLenses.put(lID, tmpA);
                }
                double nbSteps = Math.round(duration / (long)frameTime);
                if (!(nbSteps > 0.0)) break;
                LMetrics an = new LMetrics(l, this, duration);
                an.setPostAnimationAction(paa);
                float mm = ((LPDistanceMetrics)((Object)l)).getDistanceMetrics();
                float tmm = ((Float)data).floatValue();
                double dmm = (double)tmm / nbSteps;
                an.steps = new float[(int)nbSteps];
                int i = 0;
                while ((double)i < nbSteps - 1.0) {
                    step = (float)((double)mm + (double)i * dmm);
                    if (step <= 0.01f) {
                        step = 0.01f;
                    }
                    an.steps[i] = step;
                    ++i;
                }
                step = mm + tmm;
                if (step < 0.01f) {
                    step = 0.01f;
                }
                an.steps[(int)nbSteps - 1] = step;
                this.animLensBag.add(an);
                an.start();
                break;
            }
            case 10: {
                float step;
                if (this.animatedLenses.containsKey(lID) && ((int[])this.animatedLenses.get(lID))[2] == 1) {
                    this.putAsPendingLAnimation(lID, LS_LP, duration, type, data, paa);
                    break;
                }
                if (this.animatedLenses.containsKey(lID)) {
                    ((int[])this.animatedLenses.get((Object)lID))[2] = 1;
                } else {
                    int[] tmpA = new int[]{0, 0, 1};
                    this.animatedLenses.put(lID, tmpA);
                }
                double nbSteps = Math.round(duration / (long)frameTime);
                if (!(nbSteps > 0.0)) break;
                LMetrics an = new LMetrics(l, this, duration);
                an.setPostAnimationAction(paa);
                float mm = ((LPDistanceMetrics)((Object)l)).getDistanceMetrics();
                float tmm = ((Float)data).floatValue();
                an.steps = new float[(int)nbSteps];
                int i = 0;
                while ((double)i < nbSteps - 1.0) {
                    double stepValue = Math.pow((double)(i + 1) / nbSteps, 4.0);
                    float dmm = tmm * (float)stepValue;
                    step = mm + dmm;
                    if (step < 0.01f) {
                        step = 0.01f;
                    }
                    an.steps[i++] = step;
                }
                step = mm + tmm;
                if (step < 0.01f) {
                    step = 0.01f;
                }
                an.steps[(int)nbSteps - 1] = step;
                this.animLensBag.add(an);
                an.start();
                break;
            }
            case 11: {
                float step;
                if (this.animatedLenses.containsKey(lID) && ((int[])this.animatedLenses.get(lID))[2] == 1) {
                    this.putAsPendingLAnimation(lID, LS_LP, duration, type, data, paa);
                    break;
                }
                if (this.animatedLenses.containsKey(lID)) {
                    ((int[])this.animatedLenses.get((Object)lID))[2] = 1;
                } else {
                    int[] tmpA = new int[]{0, 0, 1};
                    this.animatedLenses.put(lID, tmpA);
                }
                double nbSteps = Math.round(duration / (long)frameTime);
                if (!(nbSteps > 0.0)) break;
                LMetrics an = new LMetrics(l, this, duration);
                an.setPostAnimationAction(paa);
                float mm = ((LPDistanceMetrics)((Object)l)).getDistanceMetrics();
                float tmm = ((Float)data).floatValue();
                an.steps = new float[(int)nbSteps];
                int i = 0;
                while ((double)i < nbSteps - 1.0) {
                    double stepValue = AnimManager.computeSigmoid(4, (double)(i + 1) / nbSteps);
                    float dmm = tmm * (float)stepValue;
                    step = mm + dmm;
                    if (step < 0.01f) {
                        step = 0.01f;
                    }
                    an.steps[i++] = step;
                }
                step = mm + tmm;
                if (step < 0.01f) {
                    step = 0.01f;
                }
                an.steps[(int)nbSteps - 1] = step;
                this.animLensBag.add(an);
                an.start();
                break;
            }
            default: {
                System.err.println("Error : AnimManager.createLensAnimation : unknown animation type");
            }
        }
    }

    void putAsPendingLAnimation(Integer lID, String dim, long duration, short type, Object data, PostAnimationAction paa) {
        if (this.pendingLAnims.containsKey(lID)) {
            Hashtable animByDim = (Hashtable)this.pendingLAnims.get(lID);
            Vector pa = animByDim.containsKey(dim) ? (Vector)animByDim.get(dim) : new Vector();
            pa.add(new AnimParams(duration, type, data, paa));
            animByDim.put(dim, pa);
        } else {
            Vector<AnimParams> pa = new Vector<AnimParams>();
            pa.add(new AnimParams(duration, type, data, paa));
            Hashtable<String, Vector<AnimParams>> animByDim = new Hashtable<String, Vector<AnimParams>>();
            animByDim.put(dim, pa);
            this.pendingLAnims.put(lID, animByDim);
        }
    }

    public void killLAnim(LAnimation lan, String dim) {
        Hashtable pendingDims;
        lan.updateRaster();
        Integer lID = lan.target.getID();
        this.animLensBag.remove(lan);
        if (this.animatedLenses.containsKey(lID)) {
            int[] animDims = (int[])this.animatedLenses.get(lID);
            if (dim.equals(LS_MM)) {
                animDims[0] = 0;
            } else if (dim.equals(LS_RD)) {
                animDims[1] = 0;
            } else if (dim.equals("both")) {
                animDims[0] = 0;
                animDims[1] = 0;
            } else if (dim.equals(LS_LP)) {
                animDims[2] = 0;
            }
            if (this.allValuesEqualZero(animDims)) {
                this.animatedLenses.remove(lID);
            }
        }
        lan.postAnimAction();
        if (this.pendingLAnims.containsKey(lID) && (pendingDims = (Hashtable)this.pendingLAnims.get(lID)).containsKey(dim)) {
            Vector pa = (Vector)pendingDims.get(dim);
            AnimParams ap = (AnimParams)pa.elementAt(0);
            pa.removeElementAt(0);
            if (pa.isEmpty()) {
                pendingDims.remove(dim);
                if (pendingDims.isEmpty()) {
                    this.pendingLAnims.remove(lID);
                }
            }
            this.createLensAnimation(ap.duration, ap.type, ap.data, lID, ap.paa);
        }
    }

    public void createPortalAnimation(long duration, short type, Object data, Integer pID, PostAnimationAction paa) {
        Portal p = this.vsm.getPortal(pID);
        switch (type) {
            case 0: {
                if (this.animatedPortals.containsKey(pID) && ((int[])this.animatedPortals.get(pID))[0] == 1) {
                    this.putAsPendingPAnimation(pID, "pos", duration, type, data, paa);
                    break;
                }
                if (this.animatedPortals.containsKey(pID)) {
                    ((int[])this.animatedPortals.get((Object)pID))[0] = 1;
                } else {
                    int[] tmpA = new int[]{1, 0, 0};
                    this.animatedPortals.put(pID, tmpA);
                }
                float nbSteps = Math.round(duration / (long)frameTime);
                if (!(nbSteps > 0.0f)) break;
                PTranslation an = new PTranslation(p, this, duration);
                an.setPostAnimationAction(paa);
                int x = p.x;
                int y = p.y;
                int tx = ((Point)data).x;
                int ty = ((Point)data).y;
                float dx = (float)tx / nbSteps;
                float dy = (float)ty / nbSteps;
                an.steps = new Point[(int)nbSteps];
                int i = 0;
                while ((float)i < nbSteps - 1.0f) {
                    an.steps[i] = new Point(Math.round((float)x + (float)i * dx), Math.round((float)y + (float)i * dy));
                    ++i;
                }
                an.steps[(int)nbSteps - 1] = new Point(x + tx, y + ty);
                this.animPortalBag.add(an);
                an.start();
                break;
            }
            case 2: {
                if (this.animatedPortals.containsKey(pID) && ((int[])this.animatedPortals.get(pID))[0] == 1) {
                    this.putAsPendingPAnimation(pID, "pos", duration, type, data, paa);
                    break;
                }
                if (this.animatedPortals.containsKey(pID)) {
                    ((int[])this.animatedPortals.get((Object)pID))[0] = 1;
                } else {
                    int[] tmpA = new int[]{1, 0, 0};
                    this.animatedPortals.put(pID, tmpA);
                }
                float nbSteps = Math.round((float)duration / (float)frameTime);
                if (!(nbSteps > 0.0f)) break;
                PTranslation an = new PTranslation(p, this, duration);
                an.setPostAnimationAction(paa);
                int x = p.x;
                int y = p.y;
                int tx = ((Point)data).x;
                int ty = ((Point)data).y;
                an.steps = new Point[(int)nbSteps];
                int i = 0;
                while ((float)i < nbSteps - 1.0f) {
                    float stepValue = (float)AnimManager.computeSigmoid(4, (float)(i + 1) / nbSteps);
                    int dx = Math.round((float)tx * stepValue);
                    int dy = Math.round((float)ty * stepValue);
                    an.steps[i++] = new Point(x + dx, y + dy);
                }
                an.steps[(int)nbSteps - 1] = new Point(x + tx, y + ty);
                this.animPortalBag.add(an);
                an.start();
                break;
            }
            case 3: {
                if (this.animatedPortals.containsKey(pID) && ((int[])this.animatedPortals.get(pID))[1] == 1) {
                    this.putAsPendingPAnimation(pID, "sz", duration, type, data, paa);
                    break;
                }
                if (this.animatedPortals.containsKey(pID)) {
                    ((int[])this.animatedPortals.get((Object)pID))[1] = 1;
                } else {
                    int[] tmpA = new int[]{0, 1, 0};
                    this.animatedPortals.put(pID, tmpA);
                }
                float nbSteps = Math.round(duration / (long)frameTime);
                if (!(nbSteps > 0.0f)) break;
                PResize an = new PResize(p, this, duration);
                an.setPostAnimationAction(paa);
                int w = p.w;
                int h = p.h;
                int tw = ((Point)data).x;
                int th = ((Point)data).y;
                float dw = (float)tw / nbSteps;
                float dh = (float)th / nbSteps;
                an.steps = new Point[(int)nbSteps];
                int i = 0;
                while ((float)i < nbSteps - 1.0f) {
                    an.steps[i] = new Point(Math.round((float)w + (float)i * dw), Math.round((float)h + (float)i * dh));
                    ++i;
                }
                an.steps[(int)nbSteps - 1] = new Point(w + tw, h + th);
                this.animPortalBag.add(an);
                an.start();
                break;
            }
            case 5: {
                if (this.animatedPortals.containsKey(pID) && ((int[])this.animatedPortals.get(pID))[1] == 1) {
                    this.putAsPendingPAnimation(pID, "sz", duration, type, data, paa);
                    break;
                }
                if (this.animatedPortals.containsKey(pID)) {
                    ((int[])this.animatedPortals.get((Object)pID))[1] = 1;
                } else {
                    int[] tmpA = new int[]{0, 1, 0};
                    this.animatedPortals.put(pID, tmpA);
                }
                float nbSteps = Math.round((float)duration / (float)frameTime);
                if (!(nbSteps > 0.0f)) break;
                PResize an = new PResize(p, this, duration);
                an.setPostAnimationAction(paa);
                int w = p.w;
                int h = p.h;
                int tw = ((Point)data).x;
                int th = ((Point)data).y;
                an.steps = new Point[(int)nbSteps];
                int i = 0;
                while ((float)i < nbSteps - 1.0f) {
                    float stepValue = (float)AnimManager.computeSigmoid(4, (float)(i + 1) / nbSteps);
                    int dw = Math.round((float)tw * stepValue);
                    int dh = Math.round((float)th * stepValue);
                    an.steps[i++] = new Point(w + dw, h + dh);
                }
                an.steps[(int)nbSteps - 1] = new Point(w + tw, h + th);
                this.animPortalBag.add(an);
                an.start();
                break;
            }
            case 7: {
                if (this.animatedPortals.containsKey(pID) && (((int[])this.animatedPortals.get(pID))[0] == 1 || ((int[])this.animatedPortals.get(pID))[1] == 1)) {
                    this.putAsPendingPAnimation(pID, "both", duration, type, data, paa);
                    break;
                }
                if (this.animatedPortals.containsKey(pID)) {
                    ((int[])this.animatedPortals.get((Object)pID))[0] = 1;
                    ((int[])this.animatedPortals.get((Object)pID))[1] = 1;
                } else {
                    int[] tmpA = new int[]{1, 1, 0};
                    this.animatedPortals.put(pID, tmpA);
                }
                float nbSteps = Math.round(duration / (long)frameTime);
                if (!(nbSteps > 0.0f)) break;
                PTransResize an = new PTransResize(p, this, duration);
                an.setPostAnimationAction(paa);
                int x = p.x;
                int y = p.y;
                int tx = ((Point[])data)[1].x;
                int ty = ((Point[])data)[1].y;
                float dx = (float)tx / nbSteps;
                float dy = (float)ty / nbSteps;
                int w = p.w;
                int h = p.h;
                int tw = ((Point[])data)[0].x;
                int th = ((Point[])data)[0].y;
                float dw = (float)tw / nbSteps;
                float dh = (float)th / nbSteps;
                an.tsteps = new Point[(int)nbSteps];
                an.ssteps = new Point[(int)nbSteps];
                int i = 0;
                while ((float)i < nbSteps - 1.0f) {
                    an.tsteps[i] = new Point(Math.round((float)x + (float)i * dx), Math.round((float)y + (float)i * dy));
                    an.ssteps[i] = new Point(Math.round((float)w + (float)i * dw), Math.round((float)h + (float)i * dh));
                    ++i;
                }
                an.tsteps[(int)nbSteps - 1] = new Point(x + tx, y + ty);
                an.ssteps[(int)nbSteps - 1] = new Point(w + tw, h + th);
                this.animPortalBag.add(an);
                an.start();
                break;
            }
            case 6: {
                if (this.animatedPortals.containsKey(pID) && (((int[])this.animatedPortals.get(pID))[0] == 1 || ((int[])this.animatedPortals.get(pID))[1] == 1)) {
                    this.putAsPendingPAnimation(pID, "both", duration, type, data, paa);
                    break;
                }
                if (this.animatedPortals.containsKey(pID)) {
                    ((int[])this.animatedPortals.get((Object)pID))[0] = 1;
                    ((int[])this.animatedPortals.get((Object)pID))[1] = 1;
                } else {
                    int[] tmpA = new int[]{1, 1, 0};
                    this.animatedPortals.put(pID, tmpA);
                }
                float nbSteps = Math.round((float)duration / (float)frameTime);
                if (!(nbSteps > 0.0f)) break;
                PTransResize an = new PTransResize(p, this, duration);
                an.setPostAnimationAction(paa);
                int x = p.x;
                int y = p.y;
                int tx = ((Point[])data)[1].x;
                int ty = ((Point[])data)[1].y;
                int w = p.w;
                int h = p.h;
                int tw = ((Point[])data)[0].x;
                int th = ((Point[])data)[0].y;
                an.tsteps = new Point[(int)nbSteps];
                an.ssteps = new Point[(int)nbSteps];
                int i = 0;
                while ((float)i < nbSteps - 1.0f) {
                    float stepValue = (float)AnimManager.computeSigmoid(4, (float)(i + 1) / nbSteps);
                    int dx = Math.round((float)tx * stepValue);
                    int dy = Math.round((float)ty * stepValue);
                    int dw = Math.round((float)tw * stepValue);
                    int dh = Math.round((float)th * stepValue);
                    an.tsteps[i] = new Point(x + dx, y + dy);
                    an.ssteps[i] = new Point(w + dw, h + dh);
                    ++i;
                }
                an.tsteps[(int)nbSteps - 1] = new Point(x + tx, y + ty);
                an.ssteps[(int)nbSteps - 1] = new Point(w + tw, h + th);
                this.animPortalBag.add(an);
                an.start();
                break;
            }
            case 8: {
                if (this.animatedPortals.containsKey(pID) && ((int[])this.animatedPortals.get(pID))[2] == 1) {
                    this.putAsPendingPAnimation(pID, PT_ALPHA, duration, type, data, paa);
                    break;
                }
                if (this.animatedPortals.containsKey(pID)) {
                    ((int[])this.animatedPortals.get((Object)pID))[2] = 1;
                } else {
                    int[] tmpA = new int[]{0, 0, 1};
                    this.animatedPortals.put(pID, tmpA);
                }
                float nbSteps = Math.round(duration / (long)frameTime);
                if (!(nbSteps > 0.0f)) break;
                PTranslucency an = new PTranslucency(p, this, duration);
                an.setPostAnimationAction(paa);
                float tav = ((Float)data).floatValue();
                float sav = ((Translucent)((Object)p)).getTranslucencyValue();
                double dt = tav / nbSteps;
                an.steps = new float[(int)nbSteps];
                int i = 0;
                while ((float)i < nbSteps - 1.0f) {
                    an.steps[i] = sav + (float)i * (float)dt;
                    ++i;
                }
                an.steps[(int)nbSteps - 1] = sav + tav;
                this.animPortalBag.add(an);
                an.start();
                break;
            }
            default: {
                System.err.println("Error : AnimManager.createPortalAnimation : unknown animation type");
            }
        }
    }

    void putAsPendingPAnimation(Integer pID, String dim, long duration, short type, Object data, PostAnimationAction paa) {
        if (this.pendingPAnims.containsKey(pID)) {
            Hashtable animByDim = (Hashtable)this.pendingPAnims.get(pID);
            Vector pa = animByDim.containsKey(dim) ? (Vector)animByDim.get(dim) : new Vector();
            pa.add(new AnimParams(duration, type, data, paa));
            animByDim.put(dim, pa);
        } else {
            Vector<AnimParams> pa = new Vector<AnimParams>();
            pa.add(new AnimParams(duration, type, data, paa));
            Hashtable<String, Vector<AnimParams>> animByDim = new Hashtable<String, Vector<AnimParams>>();
            animByDim.put(dim, pa);
            this.pendingPAnims.put(pID, animByDim);
        }
    }

    public void killPAnim(PAnimation pan, String dim) {
        Hashtable pendingDims;
        Integer pID = pan.target.getID();
        this.animPortalBag.remove(pan);
        if (this.animatedPortals.containsKey(pID)) {
            int[] animDims = (int[])this.animatedPortals.get(pID);
            if (dim.equals("pos")) {
                animDims[0] = 0;
            } else if (dim.equals("sz")) {
                animDims[1] = 0;
            } else if (dim.equals("both")) {
                animDims[0] = 0;
                animDims[1] = 0;
            } else if (dim.equals(PT_ALPHA)) {
                animDims[2] = 0;
            }
            if (this.allValuesEqualZero(animDims)) {
                this.animatedPortals.remove(pID);
            }
        }
        pan.postAnimAction();
        if (this.pendingPAnims.containsKey(pID) && (pendingDims = (Hashtable)this.pendingPAnims.get(pID)).containsKey(dim)) {
            Vector pa = (Vector)pendingDims.get(dim);
            AnimParams ap = (AnimParams)pa.elementAt(0);
            pa.removeElementAt(0);
            if (pa.isEmpty()) {
                pendingDims.remove(dim);
                if (pendingDims.isEmpty()) {
                    this.pendingPAnims.remove(pID);
                }
            }
            this.createPortalAnimation(ap.duration, ap.type, ap.data, pID, ap.paa);
        }
    }

    public void interruptPortalAnimation(Portal p, String dim, boolean all, boolean finish) {
        PAnimation an = null;
        for (int i = 0; i < this.animPortalBag.size(); ++i) {
            PAnimation tmpAn = (PAnimation)this.animPortalBag.elementAt(i);
            if (tmpAn.target != p || tmpAn.type != dim) continue;
            an = tmpAn;
            break;
        }
        if (an != null) {
            if (all) {
                Hashtable pendingDims;
                if (finish) {
                    an.conclude();
                }
                if (this.pendingPAnims.containsKey(p.getID()) && (pendingDims = (Hashtable)this.pendingPAnims.get(p.getID())).containsKey(dim)) {
                    pendingDims.remove(dim);
                    if (pendingDims.isEmpty()) {
                        this.pendingPAnims.remove(p.getID());
                    }
                }
            } else if (finish) {
                an.conclude();
            }
            this.killPAnim(an, dim);
        }
    }

    static double computeSigmoid(int n, double x) {
        return (Math.atan((double)n * (2.0 * x - 1.0)) / Math.atan(n) + 1.0) / 2.0;
    }

    boolean allValuesEqualZero(int[] ar) {
        for (int i = 0; i < ar.length; ++i) {
            if (ar[i] == 0) continue;
            return false;
        }
        return true;
    }

    int[] addElementsToIntArray(int[] ar, int nb) {
        int i;
        int[] res = new int[ar.length + nb];
        for (i = 0; i < ar.length; ++i) {
            res[i] = ar[i];
        }
        for (i = ar.length; i < res.length; ++i) {
            res[i] = 0;
        }
        return res;
    }
}

