/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.engine;

import com.xerox.VTM.engine.View;
import com.xerox.VTM.engine.VirtualSpace;
import com.xerox.VTM.glyphs.Glyph;
import net.claribole.zvtm.engine.Location;

public class Camera {
    public static final float DEFAULT_FOCAL = 100.0f;
    Integer ID;
    int index;
    public long posx;
    public long posy;
    double dposx;
    double dposy;
    public float altitude;
    public float focal;
    boolean enabled;
    VirtualSpace parentSpace;
    View view;
    Glyph[] stickedGlyphs;
    Camera[] stickedCameras;
    boolean[] stickAltitude;
    boolean eager = true;
    boolean shouldRepaint = false;

    Camera(long x, long y, float alt, float f, int i) {
        this.posx = x;
        this.posy = y;
        this.updatePrecisePosition();
        this.altitude = alt;
        this.focal = f;
        this.index = i;
        this.enabled = true;
    }

    Camera(long x, long y, float alt, float f, int i, boolean l) {
        this.posx = x;
        this.posy = y;
        this.updatePrecisePosition();
        this.altitude = alt;
        this.focal = f;
        this.index = i;
        this.enabled = true;
        this.eager = !l;
    }

    public void updatePrecisePosition() {
        this.dposx = this.posx;
        this.dposy = this.posy;
    }

    public void setLocation(long x, long y) {
        this.propagateMove(x - this.posx, y - this.posy);
        this.posx = x;
        this.posy = y;
        this.updatePrecisePosition();
        if (this.view != null) {
            this.parentSpace.vsm.repaintNow(this.view);
        }
    }

    public void move(long x, long y) {
        this.posx += x;
        this.posy += y;
        this.updatePrecisePosition();
        this.propagateMove(x, y);
        if (this.view != null) {
            this.parentSpace.vsm.repaintNow(this.view);
        }
    }

    public void move(double x, double y) {
        this.dposx += x;
        this.dposy += y;
        this.posx = Math.round(this.dposx);
        this.posy = Math.round(this.dposy);
        this.propagateMove(this.posx, this.posy);
        if (this.view != null) {
            this.parentSpace.vsm.repaintNow(this.view);
        }
    }

    public void moveTo(long x, long y) {
        this.posx = x;
        this.posy = y;
        this.updatePrecisePosition();
        this.propagateMove(x - this.posx, y - this.posy);
        if (this.view != null) {
            this.parentSpace.vsm.repaintNow(this.view);
        }
    }

    public void setAltitude(float a) {
        this.setAltitude(a, false);
    }

    public void altitudeOffset(float a) {
        this.altitudeOffset(a, false);
    }

    public void setAltitude(float a, boolean repaint) {
        float oldAlt = this.altitude;
        this.altitude = a >= (float)this.parentSpace.vsm.zoomFloor ? a : (float)this.parentSpace.vsm.zoomFloor;
        this.propagateAltitudeChange(this.altitude - oldAlt);
        if (repaint && this.view != null) {
            this.parentSpace.vsm.repaintNow(this.view);
        }
    }

    public void altitudeOffset(float a, boolean repaint) {
        float oldAlt = this.altitude;
        this.altitude = this.altitude + a > (float)this.parentSpace.vsm.zoomFloor ? (this.altitude += a) : (float)this.parentSpace.vsm.zoomFloor;
        this.propagateAltitudeChange(this.altitude - oldAlt);
        if (repaint && this.view != null) {
            this.parentSpace.vsm.repaintNow(this.view);
        }
    }

    public float getAltitude() {
        return this.altitude;
    }

    public void setLocation(Location l) {
        this.propagateMove(l.vx - this.posx, l.vy - this.posy);
        this.propagateAltitudeChange(l.alt - this.altitude);
        this.posx = l.vx;
        this.posy = l.vy;
        this.altitude = l.alt;
        this.updatePrecisePosition();
        if (this.view != null) {
            this.parentSpace.vsm.repaintNow(this.view);
        }
    }

    public Location getLocation() {
        return new Location(this.posx, this.posy, this.altitude);
    }

    public void setFocal(float f) {
        if (f < 0.0f) {
            f = 0.0f;
        }
        this.focal = f;
    }

    public float getFocal() {
        return this.focal;
    }

    public void propagateMove(double x, double y) {
        int i;
        long lx = Math.round(x);
        long ly = Math.round(y);
        if (this.stickedGlyphs != null) {
            for (i = 0; i < this.stickedGlyphs.length; ++i) {
                this.stickedGlyphs[i].move(lx, ly);
            }
        }
        if (this.stickedCameras != null) {
            for (i = 0; i < this.stickedCameras.length; ++i) {
                this.stickedCameras[i].moveTo(this.posx, this.posy);
            }
        }
    }

    public void propagateAltitudeChange(float alt) {
        if (this.stickedCameras != null && alt != 0.0f) {
            for (int i = 0; i < this.stickedCameras.length; ++i) {
                if (!this.stickAltitude[i]) continue;
                this.stickedCameras[i].setAltitude(this.altitude);
            }
        }
    }

    public int getIndex() {
        return this.index;
    }

    public Integer getID() {
        return this.ID;
    }

    public void setID(Integer ident) {
        this.ID = ident;
    }

    protected void setOwningSpace(VirtualSpace vs) {
        this.parentSpace = vs;
    }

    public VirtualSpace getOwningSpace() {
        return this.parentSpace;
    }

    public void setOwningView(View vi) {
        this.view = vi;
    }

    public View getOwningView() {
        return this.view;
    }

    public void stick(Glyph g) {
        if (this.stickedGlyphs == null) {
            this.stickedGlyphs = new Glyph[1];
            this.stickedGlyphs[0] = g;
            g.stickedTo = this;
        } else {
            boolean alreadySticked = false;
            for (int i = 0; i < this.stickedGlyphs.length; ++i) {
                if (this.stickedGlyphs[i] != g) continue;
                alreadySticked = true;
                break;
            }
            if (!alreadySticked) {
                Glyph[] newStickList = new Glyph[this.stickedGlyphs.length + 1];
                System.arraycopy(this.stickedGlyphs, 0, newStickList, 0, this.stickedGlyphs.length);
                newStickList[this.stickedGlyphs.length] = g;
                this.stickedGlyphs = newStickList;
                g.stickedTo = this;
            } else {
                VirtualSpace virtualSpace = this.parentSpace;
                if (virtualSpace.vsm.debugModeON()) {
                    System.err.println("Warning: trying to stick Glyph " + g + " to Camera " + this + " while they are already sticked.");
                }
            }
        }
    }

    public void unstick(Glyph g) {
        if (this.stickedGlyphs != null) {
            for (int i = 0; i < this.stickedGlyphs.length; ++i) {
                if (this.stickedGlyphs[i] != g) continue;
                g.stickedTo = null;
                Glyph[] newStickList = new Glyph[this.stickedGlyphs.length - 1];
                System.arraycopy(this.stickedGlyphs, 0, newStickList, 0, i);
                System.arraycopy(this.stickedGlyphs, i + 1, newStickList, i, this.stickedGlyphs.length - i - 1);
                this.stickedGlyphs = newStickList;
                break;
            }
            if (this.stickedGlyphs.length == 0) {
                this.stickedGlyphs = null;
            }
        }
    }

    public void unstickAllGlyphs() {
        if (this.stickedGlyphs != null) {
            for (int i = 0; i < this.stickedGlyphs.length; ++i) {
                this.stickedGlyphs[i].stickedTo = null;
                this.stickedGlyphs[i] = null;
            }
            this.stickedGlyphs = null;
        }
    }

    public Glyph[] getStickedGlyphArray() {
        return this.stickedGlyphs;
    }

    public void stick(Camera c) {
        this.stick(c, true);
    }

    public void stick(Camera c, boolean stickAlt) {
        if (this.stickedCameras == null) {
            this.stickedCameras = new Camera[1];
            this.stickedCameras[0] = c;
            this.stickAltitude = new boolean[1];
            this.stickAltitude[0] = stickAlt;
        } else {
            boolean alreadySticked = false;
            for (int i = 0; i < this.stickedCameras.length; ++i) {
                if (this.stickedCameras[i] != c) continue;
                alreadySticked = true;
                break;
            }
            if (!alreadySticked) {
                Camera[] newStickList = new Camera[this.stickedCameras.length + 1];
                System.arraycopy(this.stickedCameras, 0, newStickList, 0, this.stickedCameras.length);
                newStickList[this.stickedCameras.length] = c;
                this.stickedCameras = newStickList;
                boolean[] newStickAltList = new boolean[this.stickAltitude.length + 1];
                System.arraycopy(this.stickAltitude, 0, newStickAltList, 0, this.stickAltitude.length);
                newStickAltList[this.stickAltitude.length] = stickAlt;
                this.stickAltitude = newStickAltList;
            } else {
                VirtualSpace virtualSpace = this.parentSpace;
                if (virtualSpace.vsm.debugModeON()) {
                    System.err.println("Warning: trying to stick Camera " + c + " to Camera " + this + " while they are already sticked.");
                }
            }
        }
    }

    public void unstick(Camera c) {
        if (this.stickedCameras != null) {
            for (int i = 0; i < this.stickedCameras.length; ++i) {
                if (this.stickedCameras[i] != c) continue;
                Camera[] newStickList = new Camera[this.stickedCameras.length - 1];
                System.arraycopy(this.stickedCameras, 0, newStickList, 0, i);
                System.arraycopy(this.stickedCameras, i + 1, newStickList, i, this.stickedCameras.length - i - 1);
                this.stickedCameras = newStickList;
                boolean[] newStickAltList = new boolean[this.stickAltitude.length - 1];
                System.arraycopy(this.stickAltitude, 0, newStickAltList, 0, i);
                System.arraycopy(this.stickAltitude, i + 1, newStickAltList, i, this.stickAltitude.length - i - 1);
                this.stickAltitude = newStickAltList;
                break;
            }
            if (this.stickedCameras.length == 0) {
                this.stickedCameras = null;
                this.stickAltitude = null;
            }
        }
    }

    public void unstickAllCameras() {
        if (this.stickedCameras != null) {
            for (int i = 0; i < this.stickedCameras.length; ++i) {
                this.stickedCameras[i] = null;
            }
            this.stickedCameras = null;
            this.stickAltitude = null;
        }
    }

    public Camera[] getStickedCameraArray() {
        return this.stickedCameras;
    }

    public void enable() {
        this.setEnabled(true);
    }

    public void disable() {
        this.setEnabled(false);
    }

    public void setEnabled(boolean b) {
        if (b != this.enabled) {
            this.enabled = b;
            this.parentSpace.vsm.repaintNow(this.view);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setLaziness(boolean b) {
        this.eager = !b;
    }

    public boolean getLaziness() {
        return !this.eager;
    }

    public void repaintNow() {
        this.shouldRepaint = true;
    }

    protected boolean shouldRepaint() {
        if (this.shouldRepaint) {
            this.shouldRepaint = false;
            return true;
        }
        return false;
    }

    public String toString() {
        return new String("Camera " + this.ID + " position (" + this.posx + "," + this.posy + ") alt " + this.altitude + " focal " + this.focal);
    }
}

