/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl;

import java.io.IOException;
import org.apache.xerces.impl.XML11DTDScannerImpl;
import org.apache.xerces.impl.XML11DocumentScannerImpl;
import org.apache.xerces.impl.XML11NamespaceBinder;
import org.apache.xerces.impl.XMLDTDScannerImpl;
import org.apache.xerces.impl.XMLDocumentScannerImpl;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.impl.XMLEntityScanner;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.dtd.XML11DTDProcessor;
import org.apache.xerces.impl.dtd.XML11DTDValidator;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.XMLDTDContentModelHandler;
import org.apache.xerces.xni.XMLDTDHandler;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLComponent;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLDTDContentModelFilter;
import org.apache.xerces.xni.parser.XMLDTDFilter;
import org.apache.xerces.xni.parser.XMLDTDScanner;
import org.apache.xerces.xni.parser.XMLDocumentFilter;
import org.apache.xerces.xni.parser.XMLDocumentScanner;
import org.apache.xerces.xni.parser.XMLInputSource;

public class XMLVersionDetector
implements XMLComponent,
XMLDocumentScanner,
XMLDTDScanner {
    private static final char[] XML11_VERSION = new char[]{'1', '.', '1'};
    private static final char[] EXPECTED_VERSION_STRING = new char[]{'<', '?', 'x', 'm', 'l', ' ', 'v', 'e', 'r', 's', 'i', 'o', 'n', '=', ' ', ' ', ' ', ' ', ' '};
    protected static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    protected static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    protected static final String ENTITY_MANAGER = "http://apache.org/xml/properties/internal/entity-manager";
    protected static final String DTD_SCANNER_PROPERTY = "http://apache.org/xml/properties/internal/dtd-scanner";
    protected static final String DTD_VALIDATOR_PROPERTY = "http://apache.org/xml/properties/internal/validator/dtd";
    protected static final String DTD_PROCESSOR_PROPERTY = "http://apache.org/xml/properties/internal/dtd-processor";
    protected static final String NAMESPACE_BINDER_PROPERTY = "http://apache.org/xml/properties/internal/namespace-binder";
    private static final String[] RECOGNIZED_PROPERTIES = new String[]{"http://apache.org/xml/properties/internal/symbol-table", "http://apache.org/xml/properties/internal/error-reporter", "http://apache.org/xml/properties/internal/entity-manager", "http://apache.org/xml/properties/internal/dtd-scanner", "http://apache.org/xml/properties/internal/validator/dtd", "http://apache.org/xml/properties/internal/dtd-processor", "http://apache.org/xml/properties/internal/namespace-binder"};
    private static final String[] PROPERTY_DEFAULTS = new String[]{null, null, null, null, null, null, null};
    protected SymbolTable fSymbolTable;
    protected XMLErrorReporter fErrorReporter;
    protected XMLEntityManager fEntityManager;
    protected XMLEntityScanner fEntityScanner = null;
    protected XMLComponentManager fComponentManager = null;
    protected XMLDocumentHandler fDocumentHandler = null;
    protected XMLDTDHandler fDTDHandler = null;
    protected XMLDTDContentModelHandler fDTDContentModelHandler = null;
    protected XMLDocumentScannerImpl fRealDocumentScanner = null;
    protected XMLDTDScannerImpl fRealDTDScanner = null;
    protected XMLDocumentScannerImpl fXML10DocScanner = null;
    protected XMLDTDScannerImpl fXML10DTDScanner = null;
    protected XML11DocumentScannerImpl fXML11DocScanner = null;
    protected XML11DTDScannerImpl fXML11DTDScanner = null;
    protected XML11DTDValidator fXML11DTDValidator = null;
    protected XML11DTDProcessor fXML11DTDProcessor = null;
    protected XML11NamespaceBinder fXML11NamespaceBinder = null;
    protected static final String fVersionSymbol = "version".intern();
    protected static final String fXMLSymbol = "[xml]".intern();
    private XMLString fVersionNum = new XMLString();

    public void reset(XMLComponentManager xMLComponentManager) throws XMLConfigurationException {
        this.fSymbolTable = (SymbolTable)xMLComponentManager.getProperty(SYMBOL_TABLE);
        this.fErrorReporter = (XMLErrorReporter)xMLComponentManager.getProperty(ERROR_REPORTER);
        this.fEntityManager = (XMLEntityManager)xMLComponentManager.getProperty(ENTITY_MANAGER);
        this.fComponentManager = xMLComponentManager;
        int n = 14;
        while (n < EXPECTED_VERSION_STRING.length) {
            XMLVersionDetector.EXPECTED_VERSION_STRING[n] = 32;
            ++n;
        }
    }

    public void setProperty(String string, Object object) throws XMLConfigurationException {
        if (string.startsWith("http://apache.org/xml/properties/")) {
            String string2 = string.substring("http://apache.org/xml/properties/".length());
            if (string2.equals("internal/symbol-table")) {
                this.fSymbolTable = (SymbolTable)object;
            } else if (string2.equals("internal/error-reporter")) {
                this.fErrorReporter = (XMLErrorReporter)object;
            } else if (string2.equals("internal/entity-manager")) {
                this.fEntityManager = (XMLEntityManager)object;
            }
        }
    }

    public void setFeature(String string, boolean bl) throws XMLConfigurationException {
    }

    public boolean getFeature(String string) throws XMLConfigurationException {
        throw new XMLConfigurationException(0, string);
    }

    public String[] getRecognizedFeatures() {
        return null;
    }

    public String[] getRecognizedProperties() {
        return (String[])RECOGNIZED_PROPERTIES.clone();
    }

    public Boolean getFeatureDefault(String string) {
        return null;
    }

    public Object getPropertyDefault(String string) {
        int n = 0;
        while (n < RECOGNIZED_PROPERTIES.length) {
            if (RECOGNIZED_PROPERTIES[n].equals(string)) {
                return PROPERTY_DEFAULTS[n];
            }
            ++n;
        }
        return null;
    }

    public void setInputSource(XMLInputSource xMLInputSource) throws IOException {
        String string = this.fEntityManager.setupCurrentEntity(fXMLSymbol, xMLInputSource, false, true);
        this.reinitializePipelines(this.determineDocVersion());
        this.fEntityManager.setEntityHandler(this.fRealDocumentScanner);
        this.fRealDocumentScanner.startEntity(fXMLSymbol, this.fEntityManager.getCurrentResourceIdentifier(), string);
    }

    public boolean scanDocument(boolean bl) throws IOException, XNIException {
        return this.fRealDocumentScanner.scanDocument(bl);
    }

    public void setDocumentHandler(XMLDocumentHandler xMLDocumentHandler) {
        this.fDocumentHandler = xMLDocumentHandler;
    }

    public XMLDocumentHandler getDocumentHandler() {
        return this.fDocumentHandler;
    }

    public void setDTDContentModelHandler(XMLDTDContentModelHandler xMLDTDContentModelHandler) {
        this.fDTDContentModelHandler = xMLDTDContentModelHandler;
    }

    public XMLDTDContentModelHandler getDTDContentModelHandler() {
        return this.fDTDContentModelHandler;
    }

    public void setDTDHandler(XMLDTDHandler xMLDTDHandler) {
        this.fDTDHandler = xMLDTDHandler;
    }

    public XMLDTDHandler getDTDHandler() {
        return this.fDTDHandler;
    }

    public boolean scanDTDInternalSubset(boolean bl, boolean bl2, boolean bl3) throws IOException, XNIException {
        return false;
    }

    public boolean scanDTDExternalSubset(boolean bl) throws IOException, XNIException {
        return false;
    }

    private short determineDocVersion() throws IOException {
        this.fEntityManager.setScannerVersion((short)2);
        XMLEntityScanner xMLEntityScanner = this.fEntityManager.getEntityScanner();
        if (!xMLEntityScanner.skipString("<?xml")) {
            return 1;
        }
        if (!xMLEntityScanner.skipSpaces()) {
            this.fixupCurrentEntity(this.fEntityManager, EXPECTED_VERSION_STRING, 5);
            return 1;
        }
        if (!xMLEntityScanner.skipString("version")) {
            this.fixupCurrentEntity(this.fEntityManager, EXPECTED_VERSION_STRING, 6);
            return 1;
        }
        xMLEntityScanner.skipSpaces();
        if (xMLEntityScanner.scanChar() != 61) {
            this.fixupCurrentEntity(this.fEntityManager, EXPECTED_VERSION_STRING, 13);
            return 1;
        }
        xMLEntityScanner.skipSpaces();
        int n = xMLEntityScanner.scanChar();
        XMLVersionDetector.EXPECTED_VERSION_STRING[14] = (char)n;
        int n2 = 0;
        while (n2 < XML11_VERSION.length) {
            XMLVersionDetector.EXPECTED_VERSION_STRING[15 + n2] = (char)xMLEntityScanner.scanChar();
            ++n2;
        }
        XMLVersionDetector.EXPECTED_VERSION_STRING[18] = (char)xMLEntityScanner.scanChar();
        this.fixupCurrentEntity(this.fEntityManager, EXPECTED_VERSION_STRING, 19);
        int n3 = 0;
        while (n3 < XML11_VERSION.length) {
            if (EXPECTED_VERSION_STRING[15 + n3] != XML11_VERSION[n3]) break;
            ++n3;
        }
        if (n3 == XML11_VERSION.length) {
            return 2;
        }
        return 1;
    }

    private void reinitializePipelines(short s) {
        if (s == 2) {
            this.fEntityManager.setScannerVersion((short)2);
            if (this.fXML11DocScanner == null) {
                this.fXML11DocScanner = new XML11DocumentScannerImpl();
            }
            this.fRealDocumentScanner = this.fXML11DocScanner;
            if (this.fXML11DTDScanner == null) {
                this.fXML11DTDScanner = new XML11DTDScannerImpl();
            }
            this.fRealDTDScanner = this.fXML11DTDScanner;
            XMLDocumentFilter xMLDocumentFilter = null;
            xMLDocumentFilter = (XMLDocumentFilter)this.fComponentManager.getProperty(DTD_VALIDATOR_PROPERTY);
            if (xMLDocumentFilter != null) {
                if (this.fXML11DTDValidator == null) {
                    this.fXML11DTDValidator = new XML11DTDValidator();
                }
                this.fXML11DTDValidator.reset(this.fComponentManager);
                if (xMLDocumentFilter.getDocumentSource() != null) {
                    xMLDocumentFilter.getDocumentSource().setDocumentHandler(this.fXML11DTDValidator);
                    this.fXML11DTDValidator.setDocumentSource(xMLDocumentFilter.getDocumentSource());
                }
                if (xMLDocumentFilter.getDocumentHandler() != null) {
                    xMLDocumentFilter.getDocumentHandler().setDocumentSource(this.fXML11DTDValidator);
                    this.fXML11DTDValidator.setDocumentHandler(xMLDocumentFilter.getDocumentHandler());
                }
            }
            XMLDocumentFilter xMLDocumentFilter2 = null;
            xMLDocumentFilter2 = (XMLDocumentFilter)this.fComponentManager.getProperty(NAMESPACE_BINDER_PROPERTY);
            if (xMLDocumentFilter2 != null) {
                if (this.fXML11NamespaceBinder == null) {
                    this.fXML11NamespaceBinder = new XML11NamespaceBinder();
                }
                this.fXML11NamespaceBinder.reset(this.fComponentManager);
                if (xMLDocumentFilter2.getDocumentSource() != null) {
                    xMLDocumentFilter2.getDocumentSource().setDocumentHandler(this.fXML11NamespaceBinder);
                    this.fXML11NamespaceBinder.setDocumentSource(xMLDocumentFilter2.getDocumentSource());
                }
                if (xMLDocumentFilter2.getDocumentHandler() != null) {
                    xMLDocumentFilter2.getDocumentHandler().setDocumentSource(this.fXML11NamespaceBinder);
                    this.fXML11NamespaceBinder.setDocumentHandler(xMLDocumentFilter2.getDocumentHandler());
                }
            }
            XMLDTDFilter xMLDTDFilter = null;
            xMLDTDFilter = (XMLDTDFilter)this.fComponentManager.getProperty(DTD_PROCESSOR_PROPERTY);
            if (xMLDTDFilter != null) {
                XMLDTDContentModelFilter xMLDTDContentModelFilter;
                if (this.fXML11DTDProcessor == null) {
                    this.fXML11DTDProcessor = new XML11DTDProcessor();
                }
                this.fXML11DTDProcessor.reset(this.fComponentManager);
                if (xMLDTDFilter.getDTDSource() != null) {
                    xMLDTDFilter.getDTDSource().setDTDHandler(this.fXML11DTDProcessor);
                    this.fXML11DTDProcessor.setDTDSource(xMLDTDFilter.getDTDSource());
                }
                if (xMLDTDFilter.getDTDHandler() != null) {
                    xMLDTDFilter.getDTDHandler().setDTDSource(this.fXML11DTDProcessor);
                    this.fXML11DTDProcessor.setDTDHandler(xMLDTDFilter.getDTDHandler());
                }
                if ((xMLDTDContentModelFilter = (XMLDTDContentModelFilter)this.fComponentManager.getProperty(DTD_PROCESSOR_PROPERTY)).getDTDContentModelSource() != null) {
                    xMLDTDContentModelFilter.getDTDContentModelSource().setDTDContentModelHandler(this.fXML11DTDProcessor);
                    this.fXML11DTDProcessor.setDTDContentModelSource(xMLDTDContentModelFilter.getDTDContentModelSource());
                }
                if (xMLDTDContentModelFilter.getDTDContentModelHandler() != null) {
                    xMLDTDContentModelFilter.getDTDContentModelHandler().setDTDContentModelSource(this.fXML11DTDProcessor);
                    this.fXML11DTDProcessor.setDTDContentModelHandler(xMLDTDContentModelFilter.getDTDContentModelHandler());
                }
            }
        } else {
            this.fEntityManager.setScannerVersion((short)1);
            if (this.fXML10DocScanner == null) {
                this.fXML10DocScanner = new XMLDocumentScannerImpl();
            }
            this.fRealDocumentScanner = this.fXML10DocScanner;
            if (this.fXML10DTDScanner == null) {
                this.fXML10DTDScanner = new XMLDTDScannerImpl();
            }
            this.fRealDTDScanner = this.fXML10DTDScanner;
        }
        this.fRealDocumentScanner.reset(this.fComponentManager);
        this.fRealDocumentScanner.setDocumentHandler(this.fDocumentHandler);
        this.fDocumentHandler.setDocumentSource(this.fRealDocumentScanner);
        this.fRealDTDScanner.reset(this.fComponentManager);
        this.fRealDTDScanner.setDTDHandler(this.fDTDHandler);
        this.fDTDHandler.setDTDSource(this.fRealDTDScanner);
        this.fRealDTDScanner.setDTDContentModelHandler(this.fDTDContentModelHandler);
        this.fDTDContentModelHandler.setDTDContentModelSource(this.fRealDTDScanner);
        this.fRealDocumentScanner.setProperty(DTD_SCANNER_PROPERTY, this.fRealDTDScanner);
    }

    private void fixupCurrentEntity(XMLEntityManager xMLEntityManager, char[] cArray, int n) {
        XMLEntityManager.ScannedEntity scannedEntity = xMLEntityManager.getCurrentEntity();
        if (scannedEntity.count - scannedEntity.position + n > scannedEntity.ch.length) {
            char[] cArray2 = scannedEntity.ch;
            scannedEntity.ch = new char[n + scannedEntity.count - scannedEntity.position + 1];
            System.arraycopy(cArray2, 0, scannedEntity.ch, 0, cArray2.length);
        }
        if (scannedEntity.position < n) {
            System.arraycopy(scannedEntity.ch, scannedEntity.position, scannedEntity.ch, n, scannedEntity.count - scannedEntity.position);
            scannedEntity.count += n - scannedEntity.position;
        } else {
            int n2 = n;
            while (n2 < scannedEntity.position) {
                scannedEntity.ch[n2] = 32;
                ++n2;
            }
        }
        System.arraycopy(cArray, 0, scannedEntity.ch, 0, n);
        scannedEntity.position = 0;
        scannedEntity.lineNumber = 1;
        scannedEntity.columnNumber = 1;
    }
}

