/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.dsm.dsi.test;

import com.sourceforge.knecs.dsm.dsi.DSI;
import com.sourceforge.knecs.dsm.dsi.DSIProperty;
import com.sourceforge.knecs.dsm.dsi.StatusException;
import com.sourceforge.knecs.security.auth.DialogAuthListener;
import com.sourceforge.knecs.util.LoggerUtils;
import java.util.Hashtable;

public class TestPropFind {
    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Does a propfindall");
            System.err.println("Usage: TestPropFind <url>");
            System.exit(-1);
        }
        String url = args[0];
        DialogAuthListener dal = new DialogAuthListener();
        DSI dsi = new DSI(url, dal);
        try {
            Hashtable props = dsi.getMetaData();
            if (props != null) {
                for (Object tmp : props.keySet()) {
                    DSIProperty prop = (DSIProperty)props.get(tmp);
                    String propVal = prop.getPropertyAsString();
                    if (propVal.length() == 0) {
                        propVal = prop.getPropertyAsXMLString(true);
                    }
                    System.out.println(prop.getPropertyKey() + "=" + propVal);
                }
            } else {
                System.out.println("propfind is null");
            }
        }
        catch (StatusException ex) {
            System.out.println(ex.getMessage());
            System.out.println(LoggerUtils.getStackTrace(ex));
        }
        System.exit(0);
    }
}

