#!/usr/bin/perl -w
use strict;

use Debian::DebConf::Client::ConfModule ':all';

&pptpd("/etc/pptpd.conf", get("pptpd/localip"), get("pptpd/remoteip"));
exit 0;

sub pptpd ($$$) {

	my $line;         # eine Zeile von IN
	my $xxx;
	my @lines;
	my $count;
	my $filename;
	my $localIp;
	my $remoteIp;
	my $spaces;
	my $foundlocal=0;
	my $foundremote=0;
	my $IDString="# generated by pptpdconfig";

	$filename=shift;
	$localIp=shift;
	$remoteIp=shift;
	print("Configuring pptpd to use localip(s) $localIp and remoteip(s) ");
	print("$remoteIp ...\n");
	
	open(IN, "<$filename") || die("$filename not found.\n");
	@lines=<IN>;
	
	open(OUT, ">${filename}.old");
	print OUT @lines;
	close OUT;
	
	$count=0;
	while ($count<=$#lines)
	{
		$line=$lines[$count];
		if ($line=~/^\s*localip/) {
			if ($line=~/$IDString/)
			{
		   	($spaces)=($line=~/^(\s*)\S*.*/);
				$lines[$count]="${spaces}localip $localIp $IDString\n";
		 		$foundlocal=1;
		 	}
			else
			{
				$lines[$count]="# removed by pptpdconfig --- ".$lines[$count]."\n";
			}
		}
		
		if ($line=~/^\s*remoteip/) {
			if ($line=~/$IDString/)
			{
		   	($spaces)=($line=~/^(\s*)\S*.*/);
				$lines[$count]="${spaces}remoteip $remoteIp $IDString\n";
		 		$foundremote=1;
		 	}
			else
			{
				$lines[$count]="# removed by pptpdconfig --- ".$lines[$count]."\n";
			}
		}
		$count++;
	}
	if ($foundlocal==0)
	{
		push(@lines, "localip $localIp $IDString\n");
	}
	if ($foundremote==0)
	{
		push(@lines, "remoteip $remoteIp $IDString\n");
	}
	close IN;
	print("done\n");
	
	open(OUT, ">$filename");
	print OUT @lines;
	close OUT;
}
