/* $Cambridge: hermes/src/prayer/cmd/cmd_abook_compose.c,v 1.3 2008/09/16 09:59:55 dpc22 Exp $ */
/************************************************
 *    Prayer - a Webmail Interface              *
 ************************************************/

/* Copyright (c) University of Cambridge 2000 - 2008 */
/* See the file NOTICE for conditions of use and distribution. */

#include "prayer_session.h"

void cmd_abook_compose(struct session *session)
{
    struct template_vals *tvals = session->template_vals;
    struct request *request = session->request;
    struct options *options = session->options;
    struct buffer *b = request->write_buffer;
    struct list_item *li;
    unsigned long count = 0;

    if (request->argc == 3) {
        string_strdup(&session->abook_compose_name, request->argv[1]);
        string_strdup(&session->abook_compose_email, request->argv[2]);

        string_canon_decode(session->abook_compose_name);
        string_canon_decode(session->abook_compose_email);
    }

    if (list_length(options->role_list) == 0L) {
        session_redirect(session, request, "abook_compose2");
        return;
    }

    template_vals_foreach_init(tvals, "@roles", count);
    template_vals_foreach_string(tvals, "@roles", count, "name", "default");
    count++;

    for (li = options->role_list->head; li; li = li->next) {
        struct role *role = (struct role *) li;

        template_vals_foreach_init(tvals, "@roles", count);
        template_vals_foreach_string(tvals, "@roles", count,
                                     "name", role->name);
        count++;
    }

    template_vals_string(tvals, "next", "abook_compose2");
    session_seed_template(session, tvals);
    template_expand("roles_select", tvals, b);
    response_html(request, 200);
}
