# Copyright 2022 - 2022, Martijn Braam and the OpenAtem contributors
# SPDX-License-Identifier: LGPL-3.0-only
import os.path

from pyatem.converters.lut import load_cube, lut_to_bmd17

fixtures_dir = os.environ.get('TEST_FIXTURES', os.path.join(os.path.dirname(__file__), '../fixtures'))


def test_load_cube():
    result = load_cube(os.path.join(fixtures_dir, 'linear-17.cube'))
    assert result.title == "Generated by Resolve"
    assert result.keywords['LUT_3D_SIZE'] == 17
    assert len(result.table) == 4913


def test_generate_bmd17():
    lut = load_cube(os.path.join(fixtures_dir, 'linear-17.cube'))
    result = lut_to_bmd17(lut)

    with open(os.path.join(fixtures_dir, 'linear-17.bin'), 'rb') as handle:
        reference = handle.read()

    assert result == reference
