# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class IotHubDefinitionDescription(Model):
    """Description of the IoT hub.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param apply_allocation_policy: flag for applying allocationPolicy or not
     for a given iot hub.
    :type apply_allocation_policy: bool
    :param allocation_weight: weight to apply for a given iot h.
    :type allocation_weight: int
    :ivar name: Host name of the IoT hub.
    :vartype name: str
    :param connection_string: Required. Connection string og the IoT hub.
    :type connection_string: str
    :param location: Required. ARM region of the IoT hub.
    :type location: str
    """

    _validation = {
        'name': {'readonly': True},
        'connection_string': {'required': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'apply_allocation_policy': {'key': 'applyAllocationPolicy', 'type': 'bool'},
        'allocation_weight': {'key': 'allocationWeight', 'type': 'int'},
        'name': {'key': 'name', 'type': 'str'},
        'connection_string': {'key': 'connectionString', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(IotHubDefinitionDescription, self).__init__(**kwargs)
        self.apply_allocation_policy = kwargs.get('apply_allocation_policy', None)
        self.allocation_weight = kwargs.get('allocation_weight', None)
        self.name = None
        self.connection_string = kwargs.get('connection_string', None)
        self.location = kwargs.get('location', None)
