% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_mean_distance.R
\name{get_mean_distance}
\alias{get_mean_distance}
\title{Get the mean distance}
\usage{
get_mean_distance(graph)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}
}
\value{
A single numeric value representing the mean distance of the graph.
}
\description{
Get the mean distance of a graph, which is the average path length in the
graph. This operates through calculation of the shortest paths between all
pairs of nodes.
}
\examples{
# Create a cycle graph
graph <-
  create_graph() \%>\%
  add_cycle(n = 5)

# Determine the mean distance
graph \%>\%
  get_mean_distance()

# Create a full graph and then
# get the mean distance value
create_graph() \%>\%
  add_full_graph(n = 10) \%>\%
  get_mean_distance()

}
