% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factor_ext.R
\name{factor_ext_functions}
\alias{factor_ext_functions}
\alias{values}
\alias{values.factor_ext}
\alias{values.factor}
\alias{values.default}
\alias{as.character.factor_ext}
\alias{[[.factor_ext}
\alias{[[<-.factor_ext}
\alias{[.factor_ext}
\alias{[<-.factor_ext}
\alias{is.factor_ext}
\alias{coercible_to_factor}
\alias{coerce_to_factor}
\alias{print.factor_ext}
\alias{==.factor_ext}
\alias{!=.factor_ext}
\alias{c.factor_ext}
\title{Various functions for \code{factor_ext} objects}
\usage{
values(x, ...)

\method{values}{factor_ext}(x, ...)

\method{values}{factor}(x, ...)

\method{values}{default}(x, ...)

\method{as.character}{factor_ext}(x, ...)

\method{[[}{factor_ext}(x, ...)

\method{[[}{factor_ext}(x, ...) <- value

\method{[}{factor_ext}(x, ..., drop = FALSE)

\method{[}{factor_ext}(x, ...) <- value

is.factor_ext(x)

coercible_to_factor(x)

coerce_to_factor(x)

\method{print}{factor_ext}(x, quote = FALSE, max.levels = NULL,
  width = getOption("width"), ...)

\method{==}{factor_ext}(e1, e2)

\method{!=}{factor_ext}(e1, e2)

\method{c}{factor_ext}(...)
}
\arguments{
\item{x}{Object of type \code{factor_ext}}

\item{...}{Currently ignored}

\item{value}{The object to assign; here has be a level of \code{factor_ext}}

\item{drop}{Should dimensions of size 1 be dropped?}

\item{quote}{logical, indicating whether or not strings should be printed with surrounding quotes.}

\item{max.levels}{integer, indicating how many levels should be printed. if '0', no extra "Levels" line will be printed.  The
default, 'NULL', entails choosing 'max.levels' such that the levels print on one line of width 'width' (same for values).}

\item{width}{only used when \code{max.levels} is NULL (see above)}

\item{e1, e2}{The two objects in the equality or inequality comparison.}
}
\value{
Depending on the function
}
\description{
Various functions for \code{factor_ext} objects
}
\details{
\describe{
  \item{values}{Extracts the underlying values of an object (the generic here)}
  \item{values.factor_ext}{Extracts the underlying values of a \code{factor_ext} object}
  \item{values.factor}{Extracts the underlying values of a \code{factor}}
  \item{values.default}{Default of the values function; currently returns an error}
  \item{as.character}{Coerces \code{factor_ext} to a character-representation using it levels, not values}
  \item{[[.factor_ext}{Single-item subsetting of a \code{factor_ext} object}
  \item{[[<-.factor_ext}{Single-item subset assignment to a \code{factor_ext} object}
  \item{[.factor_ext}{Subsetting of a \code{factor_ext} object}
  \item{[<-.factor_ext}{Subset assignment to a \code{factor_ext} object}
  \item{is.factor_ext}{Check if it is a \code{factor_ext} object. Returns a logical}
  \item{coercible_to_factor}{Checks if a \code{factor_ext} could be coerced to a \code{factor}. Return a logical.}
  \item{coerce_to_factor}{Coerces to a \code{factor}, otherwise throws an error if not possible.}
  \item{print.factor_ext}{Prints a \code{factor_ext} object.}
  \item{==.factor_ext}{Compare two \code{factor_ext} for equality.}
  \item{!=.factor_ext}{Compare two \code{factor_ext} for inequality.}
  \item{c.factor_ext}{Concatenate objects of type \code{factor_ext}.}
}
}
\author{
Holger Hoefling
}
