% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jwt.R
\name{jwt_claim}
\alias{jwt_claim}
\alias{jwt_encode_sig}
\alias{jwt_encode_hmac}
\title{Create and encode a JWT}
\usage{
jwt_claim(
  iss = NULL,
  sub = NULL,
  aud = NULL,
  exp = unix_time() + 5L * 60L,
  nbf = unix_time(),
  iat = unix_time(),
  jti = NULL,
  ...
)

jwt_encode_sig(claim, key, size = 256, header = list())

jwt_encode_hmac(claim, secret, size = 256, header = list())
}
\arguments{
\item{iss}{Issuer claim. Identifies the principal that issued the JWT.}

\item{sub}{Subject claim. Identifies the principal that is the subject of
the JWT (i.e. the entity that the claims apply to).}

\item{aud}{Audience claim. Identifies the recipients that the JWT is
intended. Each principle intended to process the JWT must be identified
with a unique value.}

\item{exp}{Expiration claim. Identifies the expiration time on or after which
the JWT MUST NOT be accepted for processing. Defaults to 5 minutes.}

\item{nbf}{Not before claim. Identifies the time before which the JWT
MUST NOT be accepted for processing. Defaults to current time.}

\item{iat}{Issued at claim. Identifies the time at which the JWT was
issued.  Defaults to current time.}

\item{jti}{JWT ID claim. Provides a unique identifier for the JWT.
If omitted, uses a random 32-byte sequence encoded with base64url.}

\item{...}{Any additional claims to include in the claim set.}

\item{claim}{Claim set produced by \code{\link[=jwt_claim]{jwt_claim()}}.}

\item{key}{RSA or EC private key either specified as a path to a file,
a connection, or a string (PEM/SSH format), or a raw vector (DER format).}

\item{size}{Size, in bits, of sha2 signature, i.e. 256, 384 or 512.
Only for HMAC/RSA, not applicable for ECDSA keys.}

\item{header}{A named list giving additional fields to include in the
JWT header.}

\item{secret}{String or raw vector with a secret passphrase.}
}
\value{
An S3 list with class \code{jwt_claim}.
}
\description{
\code{jwt_claim()} is a wrapper around \code{\link[jose:jwt_claim]{jose::jwt_claim()}} that creates a JWT
claim set with a few extra default values. \code{jwt_encode_sig()} and
\code{jwt_encode_hmac()} are thin wrappers around \code{\link[jose:jwt_encode]{jose::jwt_encode_sig()}} and
\code{\link[jose:jwt_encode]{jose::jwt_encode_hmac()}} that exist primarily to make specification
in other functions a little simpler.
}
\examples{
claim <- jwt_claim()
str(claim)
}
\keyword{internal}
