% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/with-mock.R
\name{with_mock}
\alias{with_mock}
\title{Mock functions in a package.}
\usage{
with_mock(..., .parent = parent.frame(), .env = topenv(.parent))
}
\arguments{
\item{...}{\code{[any]}\cr named arguments redefine mocked functions,
unnamed parameters will be evaluated after mocking the functions}

\item{.parent}{\code{[environment]}\cr the environment in which to evaluate the expressions,
defaults to \code{\link[=parent.frame]{parent.frame()}}. Usually doesn't need to be changed.}

\item{.env}{\code{[environment]}\cr the environment in which to patch the functions,
defaults to \code{\link[=topenv]{topenv()}}. Usually doesn't need to be changed.}
}
\value{
The result of the last unnamed parameter, visibility is preserved
}
\description{
Executes code after temporarily substituting implementations of package
functions.  This is useful for testing code that relies on functions that are
slow, have unintended side effects or access resources that may not be
available when testing.
}
\details{
This works by adding a shadow environment as a parent of the environment
in which the expressions are evaluated.  Everything happens at the R level,
but only functions in your own package can be mocked.
Otherwise, the implementation is modeled after the original version in the
\code{testthat} pacakge, which is now deprecated.
}
\examples{
some_func <- function() stop("oops")
some_other_func <- function() some_func()
tester_func <- function() {
  with_mock(
    some_func = function() 42,
    some_other_func()
  )
}
try(some_other_func())
tester_func()
}
\references{
Suraj Gupta (2012): \href{http://blog.obeautifulcode.com/R/How-R-Searches-And-Finds-Stuff/}{How R Searches And Finds Stuff}
}
